#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ADC
#endif

// Bitfields in register ADC_HC0.
static const field_t hw_adc_hc0[] =
{
    {
        "ADCH",
        "This 5-bit field selects one of the input channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AIEN",
        "An interrupt is generated whenever ADC_HS[COCO0]=1 (conversion ADC_HC0"
        " completed), provided the corresponding interrupt is enabled.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_HC1.
static const field_t hw_adc_hc1[] =
{
    {
        "ADCH",
        "This 5-bit field selects one of the input channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AIEN",
        "An interrupt is generated whenever ADC_HS[COCO0]=1(conversion ADC_HC0 "
        "completed), provided the corresponding interrupt is enabled.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_HS.
static const field_t hw_adc_hs[] =
{
    {
        "COCO0",
        "The COCOn flag is a read-only bit that is set each time a conversion i"
        "s completed when the compare function is disabled (ADC_GC[ACFE]=0) and"
        " the hardware average function is disabled (ADC_GC[AVGE]=0).",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COCO1",
        "See description for COCO0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_R0.
static const field_t hw_adc_r0[] =
{
    {
        "CDATA",
        "",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_R1.
static const field_t hw_adc_r1[] =
{
    {
        "CDATA",
        "Data (result of an ADC conversion)",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CFG.
static const field_t hw_adc_cfg[] =
{
    {
        "ADICLK",
        "Selects the input clock source to generate the internal clock ADCK.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Used to set the ADC resolution mode.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADLSMP",
        "Selects between different sample times based on the ADC_CFG[ADSTS] fie"
        "ld.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIV",
        "Selects the divide ratio used by the ADC to generate the internal cloc"
        "k ADCK.",
        5, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADLPC",
        "Puts the ADC hard block into low power mode and reduces the comparator"
        " enable period by controlling its timing in the SAR controller block t"
        "owards the anlong hard block.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADSTS",
        "Defines the sample time duration.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADHSC",
        "This bit configures the ADC for high speed operation.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFSEL",
        "Selects the voltage reference source used for conversions (see the chi"
        "p-specific SARADC information for details).",
        11, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADTRG",
        "Selects the type of trigger used for initiating a conversion.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Determines how many ADC conversions will be averaged to create the ADC"
        " average result.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OVWREN",
        "Controls the overwriting of the next converted Data onto the existing "
        "(previous) unread data into the Data result register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_GC.
static const field_t hw_adc_gc[] =
{
    {
        "ADACKEN",
        "Enables the ADC's asynchronous clock source and the clock source outpu"
        "t regardless of the conversion and input clock select (ADC_CFG[ADICLK]"
        ") settings of the ADC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAEN",
        "Enables the DMA logic.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACREN",
        "Configures the compare function to check the conversion result of the "
        "input being monitored is either between or outside the range formed by"
        " the compare values in register (ADC_CV) determined by the value of AC"
        "FGT.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACFGT",
        "Configures the compare function to check the conversion result relativ"
        "e to the compare value register (ADC_CV) based upon the value of ACREN"
        " (bit 2 in ADC_GC register).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACFE",
        "Enables the compare function.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGE",
        "Enables the hardware average function of the ADC.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADCO",
        "Enables continuous conversions.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAL",
        "CAL begins the calibration sequence when set.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_GS.
static const field_t hw_adc_gs[] =
{
    {
        "ADACT",
        "Indicates that a conversion or hardware averaging is in progress.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CALF",
        "Displays the result of the calibration sequence.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWKST",
        "Holds the status of asynchronous interrupt status that occured during "
        "stop mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CV.
static const field_t hw_adc_cv[] =
{
    {
        "CV1",
        "Contains a compare value used to compare with the conversion result wh"
        "en the compare function ais enabled (ADC_GC[ACFE]=1).",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CV2",
        "Contains a compare value used to compare with the conversion result wh"
        "en the compare function and compare range function are enabled (ADC_GC"
        "[ACFE]=1, ADC_GC[ACREN]=1).",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_OFS.
static const field_t hw_adc_ofs[] =
{
    {
        "OFS",
        "User configurable offset value.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIGN",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CAL.
static const field_t hw_adc_cal[] =
{
    {
        "CAL_CODE",
        "This value is automatically loaded and updated at the end of calibrati"
        "on.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ADC module.
static const reg_t hw_adc[] =
{
    {
        "HC0",
        "ADC_HC0 can be used for both software and hardware trigger mode.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_hc0
    },
    {
        "HC1",
        "ADC_HC1 are for use only in hardware trigger mode.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_hc1
    },
    {
        "HS",
        "Bit 0 is used for both software and hardware trigger modes of operatio"
        "n.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_adc_hs
    },
    {
        "R0",
        "Contains the result of an ADC conversion of the channel selected by th"
        "e respective hardware trigger and channel control register (ADC_HC0:AD"
        "C_HCn).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_adc_r0
    },
    {
        "R1",
        "Contains the result of an ADC conversion of the channel selected by th"
        "e respective Hardware Trigger and channel control register (ADC_HC0:AD"
        "C_HCn).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_adc_r1
    },
    {
        "CFG",
        "Selects the mode of operation, clock source, clock divide, configure f"
        "or low power, long sample time, high speed configuration and selects t"
        "he sample time duration.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_adc_cfg
    },
    {
        "GC",
        "Controls the calibration, continuous convert, hardware averaging funct"
        "ions, conversion active, hardware/software trigger select, compare fun"
        "ction and voltage reference select of the ADC module.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_adc_gc
    },
    {
        "GS",
        "Controls the calibration, continuous convert, hardware averaging funct"
        "ions, conversion active, hardware/software trigger select, compare fun"
        "ction and voltage reference select of the ADC module.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_adc_gs
    },
    {
        "CV",
        "Contains compare values used to compare with the conversion result whe"
        "n the compare function is enabled (ADC_GC[ACFE]=1).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_cv
    },
    {
        "OFS",
        "Contains the user-defined offset error correction value.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_ofs
    },
    {
        "CAL",
        "Contains calibration information that is generated by the calibration "
        "function.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_adc_cal
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AIPSTZ
#endif

// Bitfields in register AIPSTZ_MPR.
static const field_t hw_aipstz_mpr[] =
{
    {
        "MPROT5",
        "Master 5 Priviledge, Buffer, Read, Write Control.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT3",
        "Master 3 Priviledge, Buffer, Read, Write Control.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT2",
        "Master 2 Priviledge, Buffer, Read, Write Control",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT1",
        "Master 1 Priviledge, Buffer, Read, Write Control",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT0",
        "Master 0 Priviledge, Buffer, Read, Write Control",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR.
static const field_t hw_aipstz_opacr[] =
{
    {
        "OPAC7",
        "Off-platform Peripheral Access Control 7",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC6",
        "Off-platform Peripheral Access Control 6",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC5",
        "Off-platform Peripheral Access Control 5",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC4",
        "Off-platform Peripheral Access Control 4",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC3",
        "Off-platform Peripheral Access Control 3",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC2",
        "Off-platform Peripheral Access Control 2",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC1",
        "Off-platform Peripheral Access Control 1",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC0",
        "Off-platform Peripheral Access Control 0",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR1.
static const field_t hw_aipstz_opacr1[] =
{
    {
        "OPAC15",
        "Off-platform Peripheral Access Control 15",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC14",
        "Off-platform Peripheral Access Control 14",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC13",
        "Off-platform Peripheral Access Control 13",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC12",
        "Off-platform Peripheral Access Control 12",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC11",
        "Off-platform Peripheral Access Control 11",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC10",
        "Off-platform Peripheral Access Control 10",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC9",
        "Off-platform Peripheral Access Control 9",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC8",
        "Off-platform Peripheral Access Control 8",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR2.
static const field_t hw_aipstz_opacr2[] =
{
    {
        "OPAC23",
        "Off-platform Peripheral Access Control 23",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC22",
        "Off-platform Peripheral Access Control 22",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC21",
        "Off-platform Peripheral Access Control 21",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC20",
        "Off-platform Peripheral Access Control 20",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC19",
        "Off-platform Peripheral Access Control 19",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC18",
        "Off-platform Peripheral Access Control 18",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC17",
        "Off-platform Peripheral Access Control 17",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC16",
        "Off-platform Peripheral Access Control 16",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR3.
static const field_t hw_aipstz_opacr3[] =
{
    {
        "OPAC31",
        "Off-platform Peripheral Access Control 31",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC30",
        "Off-platform Peripheral Access Control 30",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC29",
        "Off-platform Peripheral Access Control 29",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC28",
        "Off-platform Peripheral Access Control 28",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC27",
        "Off-platform Peripheral Access Control 27",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC26",
        "Off-platform Peripheral Access Control 26",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC25",
        "Off-platform Peripheral Access Control 25",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC24",
        "Off-platform Peripheral Access Control 24",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR4.
static const field_t hw_aipstz_opacr4[] =
{
    {
        "OPAC33",
        "Off-platform Peripheral Access Control 33",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC32",
        "Off-platform Peripheral Access Control 32",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AIPSTZ module.
static const reg_t hw_aipstz[] =
{
    {
        "MPR",
        "Each AIPSTZ_MPR specifies 16 4-bit fields defining the access privileg"
        "e level associated with a bus master in the platform, as well as speci"
        "fying whether write accesses from this master are bufferable shown in "
        "The registers provide one field per bus master, where field 15 corresp"
        "onds to master 15, field 14 to master 14,...",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_aipstz_mpr
    },
    {
        "OPACR",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr
    },
    {
        "OPACR1",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr1
    },
    {
        "OPACR2",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr2
    },
    {
        "OPACR3",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr3
    },
    {
        "OPACR4",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_aipstz_opacr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark APBH
#endif

// Bitfields in register APBH_CTRL0.
static const field_t hw_apbh_ctrl0[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_SET.
static const field_t hw_apbh_ctrl0_set[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_CLR.
static const field_t hw_apbh_ctrl0_clr[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_TOG.
static const field_t hw_apbh_ctrl0_tog[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1.
static const field_t hw_apbh_ctrl1[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_SET.
static const field_t hw_apbh_ctrl1_set[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_CLR.
static const field_t hw_apbh_ctrl1_clr[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_TOG.
static const field_t hw_apbh_ctrl1_tog[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2.
static const field_t hw_apbh_ctrl2[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_SET.
static const field_t hw_apbh_ctrl2_set[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_CLR.
static const field_t hw_apbh_ctrl2_clr[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_TOG.
static const field_t hw_apbh_ctrl2_tog[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL.
static const field_t hw_apbh_channel_ctrl[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_SET.
static const field_t hw_apbh_channel_ctrl_set[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_CLR.
static const field_t hw_apbh_channel_ctrl_clr[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_TOG.
static const field_t hw_apbh_channel_ctrl_tog[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DEVSEL.
static const field_t hw_apbh_devsel[] =
{
    {
        "CH0",
        "Reserved.",
        0, // LSB
        1, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH1",
        "Reserved.",
        2, // LSB
        3, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH2",
        "Reserved.",
        4, // LSB
        5, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH3",
        "Reserved.",
        6, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH4",
        "Reserved.",
        8, // LSB
        9, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH5",
        "Reserved.",
        10, // LSB
        11, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH6",
        "Reserved.",
        12, // LSB
        13, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH7",
        "Reserved.",
        14, // LSB
        15, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH8",
        "Reserved.",
        16, // LSB
        17, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH9",
        "Reserved.",
        18, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH10",
        "Reserved.",
        20, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH11",
        "Reserved.",
        22, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH12",
        "Reserved.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH13",
        "Reserved.",
        26, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH14",
        "Reserved.",
        28, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH15",
        "Reserved.",
        30, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DMA_BURST_SIZE.
static const field_t hw_apbh_dma_burst_size[] =
{
    {
        "CH0",
        "DMA burst size for GPMI channel 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1",
        "DMA burst size for GPMI channel 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2",
        "DMA burst size for GPMI channel 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3",
        "DMA burst size for GPMI channel 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4",
        "DMA burst size for GPMI channel 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5",
        "DMA burst size for GPMI channel 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6",
        "DMA burst size for GPMI channel 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7",
        "DMA burst size for GPMI channel 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8",
        "DMA burst size for SSP.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9",
        "Reserved.",
        18, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH10",
        "Reserved.",
        20, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH11",
        "Reserved.",
        22, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH12",
        "Reserved.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH13",
        "Reserved.",
        26, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH14",
        "Reserved.",
        28, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH15",
        "Reserved.",
        30, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DEBUG.
static const field_t hw_apbh_debug[] =
{
    {
        "GPMI_ONE_FIFO",
        "Set to 0ne and the 8 GPMI channels will share the DMA FIFO, and when s"
        "et to zero, the 8 GPMI channels will use its own DMA FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_CURCMDAR.
static const field_t hw_apbh_ch0_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_NXTCMDAR.
static const field_t hw_apbh_ch0_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_CMD.
static const field_t hw_apbh_ch0_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_BAR.
static const field_t hw_apbh_ch0_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_SEMA.
static const field_t hw_apbh_ch0_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_DEBUG1.
static const field_t hw_apbh_ch0_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_DEBUG2.
static const field_t hw_apbh_ch0_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_CURCMDAR.
static const field_t hw_apbh_ch1_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_NXTCMDAR.
static const field_t hw_apbh_ch1_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_CMD.
static const field_t hw_apbh_ch1_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_BAR.
static const field_t hw_apbh_ch1_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_SEMA.
static const field_t hw_apbh_ch1_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_DEBUG1.
static const field_t hw_apbh_ch1_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_DEBUG2.
static const field_t hw_apbh_ch1_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_CURCMDAR.
static const field_t hw_apbh_ch2_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_NXTCMDAR.
static const field_t hw_apbh_ch2_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_CMD.
static const field_t hw_apbh_ch2_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_BAR.
static const field_t hw_apbh_ch2_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_SEMA.
static const field_t hw_apbh_ch2_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_DEBUG1.
static const field_t hw_apbh_ch2_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_DEBUG2.
static const field_t hw_apbh_ch2_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_CURCMDAR.
static const field_t hw_apbh_ch3_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_NXTCMDAR.
static const field_t hw_apbh_ch3_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_CMD.
static const field_t hw_apbh_ch3_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_BAR.
static const field_t hw_apbh_ch3_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_SEMA.
static const field_t hw_apbh_ch3_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_DEBUG1.
static const field_t hw_apbh_ch3_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_DEBUG2.
static const field_t hw_apbh_ch3_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_CURCMDAR.
static const field_t hw_apbh_ch4_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_NXTCMDAR.
static const field_t hw_apbh_ch4_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_CMD.
static const field_t hw_apbh_ch4_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_BAR.
static const field_t hw_apbh_ch4_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_SEMA.
static const field_t hw_apbh_ch4_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_DEBUG1.
static const field_t hw_apbh_ch4_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_DEBUG2.
static const field_t hw_apbh_ch4_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_CURCMDAR.
static const field_t hw_apbh_ch5_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_NXTCMDAR.
static const field_t hw_apbh_ch5_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_CMD.
static const field_t hw_apbh_ch5_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_BAR.
static const field_t hw_apbh_ch5_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_SEMA.
static const field_t hw_apbh_ch5_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_DEBUG1.
static const field_t hw_apbh_ch5_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_DEBUG2.
static const field_t hw_apbh_ch5_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_CURCMDAR.
static const field_t hw_apbh_ch6_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_NXTCMDAR.
static const field_t hw_apbh_ch6_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_CMD.
static const field_t hw_apbh_ch6_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_BAR.
static const field_t hw_apbh_ch6_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_SEMA.
static const field_t hw_apbh_ch6_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_DEBUG1.
static const field_t hw_apbh_ch6_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_DEBUG2.
static const field_t hw_apbh_ch6_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_CURCMDAR.
static const field_t hw_apbh_ch7_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_NXTCMDAR.
static const field_t hw_apbh_ch7_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_CMD.
static const field_t hw_apbh_ch7_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_BAR.
static const field_t hw_apbh_ch7_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_SEMA.
static const field_t hw_apbh_ch7_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_DEBUG1.
static const field_t hw_apbh_ch7_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_DEBUG2.
static const field_t hw_apbh_ch7_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_CURCMDAR.
static const field_t hw_apbh_ch8_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_NXTCMDAR.
static const field_t hw_apbh_ch8_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_CMD.
static const field_t hw_apbh_ch8_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_BAR.
static const field_t hw_apbh_ch8_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_SEMA.
static const field_t hw_apbh_ch8_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_DEBUG1.
static const field_t hw_apbh_ch8_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_DEBUG2.
static const field_t hw_apbh_ch8_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_CURCMDAR.
static const field_t hw_apbh_ch9_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_NXTCMDAR.
static const field_t hw_apbh_ch9_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_CMD.
static const field_t hw_apbh_ch9_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_BAR.
static const field_t hw_apbh_ch9_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_SEMA.
static const field_t hw_apbh_ch9_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_DEBUG1.
static const field_t hw_apbh_ch9_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_DEBUG2.
static const field_t hw_apbh_ch9_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_CURCMDAR.
static const field_t hw_apbh_ch10_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_NXTCMDAR.
static const field_t hw_apbh_ch10_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_CMD.
static const field_t hw_apbh_ch10_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_BAR.
static const field_t hw_apbh_ch10_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_SEMA.
static const field_t hw_apbh_ch10_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_DEBUG1.
static const field_t hw_apbh_ch10_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_DEBUG2.
static const field_t hw_apbh_ch10_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_CURCMDAR.
static const field_t hw_apbh_ch11_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_NXTCMDAR.
static const field_t hw_apbh_ch11_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_CMD.
static const field_t hw_apbh_ch11_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_BAR.
static const field_t hw_apbh_ch11_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_SEMA.
static const field_t hw_apbh_ch11_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_DEBUG1.
static const field_t hw_apbh_ch11_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_DEBUG2.
static const field_t hw_apbh_ch11_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_CURCMDAR.
static const field_t hw_apbh_ch12_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_NXTCMDAR.
static const field_t hw_apbh_ch12_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_CMD.
static const field_t hw_apbh_ch12_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_BAR.
static const field_t hw_apbh_ch12_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_SEMA.
static const field_t hw_apbh_ch12_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_DEBUG1.
static const field_t hw_apbh_ch12_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_DEBUG2.
static const field_t hw_apbh_ch12_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_CURCMDAR.
static const field_t hw_apbh_ch13_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_NXTCMDAR.
static const field_t hw_apbh_ch13_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_CMD.
static const field_t hw_apbh_ch13_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_BAR.
static const field_t hw_apbh_ch13_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_SEMA.
static const field_t hw_apbh_ch13_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_DEBUG1.
static const field_t hw_apbh_ch13_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_DEBUG2.
static const field_t hw_apbh_ch13_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_CURCMDAR.
static const field_t hw_apbh_ch14_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_NXTCMDAR.
static const field_t hw_apbh_ch14_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_CMD.
static const field_t hw_apbh_ch14_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_BAR.
static const field_t hw_apbh_ch14_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_SEMA.
static const field_t hw_apbh_ch14_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_DEBUG1.
static const field_t hw_apbh_ch14_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_DEBUG2.
static const field_t hw_apbh_ch14_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_CURCMDAR.
static const field_t hw_apbh_ch15_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_NXTCMDAR.
static const field_t hw_apbh_ch15_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_CMD.
static const field_t hw_apbh_ch15_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_BAR.
static const field_t hw_apbh_ch15_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_SEMA.
static const field_t hw_apbh_ch15_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_DEBUG1.
static const field_t hw_apbh_ch15_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_DEBUG2.
static const field_t hw_apbh_ch15_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_VERSION.
static const field_t hw_apbh_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a APBH module.
static const reg_t hw_apbh[] =
{
    {
        "CTRL0",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0
    },
    {
        "CTRL0_SET",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_set
    },
    {
        "CTRL0_CLR",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_clr
    },
    {
        "CTRL0_TOG",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_tog
    },
    {
        "CTRL1",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1
    },
    {
        "CTRL1_SET",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_set
    },
    {
        "CTRL1_CLR",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_clr
    },
    {
        "CTRL1_TOG",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_tog
    },
    {
        "CTRL2",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2
    },
    {
        "CTRL2_SET",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_set
    },
    {
        "CTRL2_CLR",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_clr
    },
    {
        "CTRL2_TOG",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_tog
    },
    {
        "CHANNEL_CTRL",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl
    },
    {
        "CHANNEL_CTRL_SET",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_set
    },
    {
        "CHANNEL_CTRL_CLR",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_clr
    },
    {
        "CHANNEL_CTRL_TOG",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_tog
    },
    {
        "DEVSEL",
        "This register allows reassignment of the APBH device connected to the "
        "DMA Channels.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        false, // Writable
        16, // Number of bitfields
        hw_apbh_devsel
    },
    {
        "DMA_BURST_SIZE",
        "This register programs the apbh burst size of the APBH DMA devices whe"
        "n a DMA burst request is issued.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_apbh_dma_burst_size
    },
    {
        "DEBUG",
        "This register is for debug purpose.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_debug
    },
    {
        "CH0_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_curcmdar
    },
    {
        "CH0_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_nxtcmdar
    },
    {
        "CH0_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch0_cmd
    },
    {
        "CH0_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_bar
    },
    {
        "CH0_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch0_sema
    },
    {
        "CH0_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch0_debug1
    },
    {
        "CH0_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch0_debug2
    },
    {
        "CH1_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_curcmdar
    },
    {
        "CH1_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_nxtcmdar
    },
    {
        "CH1_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch1_cmd
    },
    {
        "CH1_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_bar
    },
    {
        "CH1_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch1_sema
    },
    {
        "CH1_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch1_debug1
    },
    {
        "CH1_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch1_debug2
    },
    {
        "CH2_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_curcmdar
    },
    {
        "CH2_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_nxtcmdar
    },
    {
        "CH2_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch2_cmd
    },
    {
        "CH2_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_bar
    },
    {
        "CH2_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch2_sema
    },
    {
        "CH2_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch2_debug1
    },
    {
        "CH2_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch2_debug2
    },
    {
        "CH3_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_curcmdar
    },
    {
        "CH3_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_nxtcmdar
    },
    {
        "CH3_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch3_cmd
    },
    {
        "CH3_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000280, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_bar
    },
    {
        "CH3_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch3_sema
    },
    {
        "CH3_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch3_debug1
    },
    {
        "CH3_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch3_debug2
    },
    {
        "CH4_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_curcmdar
    },
    {
        "CH4_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_nxtcmdar
    },
    {
        "CH4_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch4_cmd
    },
    {
        "CH4_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000002f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_bar
    },
    {
        "CH4_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch4_sema
    },
    {
        "CH4_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000310, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch4_debug1
    },
    {
        "CH4_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000320, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch4_debug2
    },
    {
        "CH5_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000330, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_curcmdar
    },
    {
        "CH5_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000340, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_nxtcmdar
    },
    {
        "CH5_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000350, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch5_cmd
    },
    {
        "CH5_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000360, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_bar
    },
    {
        "CH5_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000370, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch5_sema
    },
    {
        "CH5_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000380, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch5_debug1
    },
    {
        "CH5_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000390, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch5_debug2
    },
    {
        "CH6_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000003a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_curcmdar
    },
    {
        "CH6_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000003b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_nxtcmdar
    },
    {
        "CH6_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000003c0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch6_cmd
    },
    {
        "CH6_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000003d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_bar
    },
    {
        "CH6_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000003e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch6_sema
    },
    {
        "CH6_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000003f0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch6_debug1
    },
    {
        "CH6_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch6_debug2
    },
    {
        "CH7_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_curcmdar
    },
    {
        "CH7_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000420, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_nxtcmdar
    },
    {
        "CH7_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000430, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch7_cmd
    },
    {
        "CH7_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000440, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_bar
    },
    {
        "CH7_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000450, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch7_sema
    },
    {
        "CH7_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000460, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch7_debug1
    },
    {
        "CH7_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000470, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch7_debug2
    },
    {
        "CH8_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000480, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_curcmdar
    },
    {
        "CH8_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000490, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_nxtcmdar
    },
    {
        "CH8_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000004a0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch8_cmd
    },
    {
        "CH8_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000004b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_bar
    },
    {
        "CH8_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000004c0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch8_sema
    },
    {
        "CH8_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000004d0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch8_debug1
    },
    {
        "CH8_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000004e0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch8_debug2
    },
    {
        "CH9_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000004f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_curcmdar
    },
    {
        "CH9_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000500, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_nxtcmdar
    },
    {
        "CH9_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000510, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch9_cmd
    },
    {
        "CH9_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000520, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_bar
    },
    {
        "CH9_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000530, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch9_sema
    },
    {
        "CH9_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000540, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch9_debug1
    },
    {
        "CH9_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000550, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch9_debug2
    },
    {
        "CH10_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000560, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_curcmdar
    },
    {
        "CH10_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000570, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_nxtcmdar
    },
    {
        "CH10_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000580, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch10_cmd
    },
    {
        "CH10_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000590, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_bar
    },
    {
        "CH10_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000005a0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch10_sema
    },
    {
        "CH10_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000005b0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch10_debug1
    },
    {
        "CH10_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000005c0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch10_debug2
    },
    {
        "CH11_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000005d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_curcmdar
    },
    {
        "CH11_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000005e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_nxtcmdar
    },
    {
        "CH11_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000005f0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch11_cmd
    },
    {
        "CH11_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000600, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_bar
    },
    {
        "CH11_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch11_sema
    },
    {
        "CH11_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch11_debug1
    },
    {
        "CH11_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000630, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch11_debug2
    },
    {
        "CH12_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000640, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_curcmdar
    },
    {
        "CH12_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000650, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_nxtcmdar
    },
    {
        "CH12_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000660, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch12_cmd
    },
    {
        "CH12_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000670, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_bar
    },
    {
        "CH12_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000680, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch12_sema
    },
    {
        "CH12_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000690, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch12_debug1
    },
    {
        "CH12_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000006a0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch12_debug2
    },
    {
        "CH13_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000006b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_curcmdar
    },
    {
        "CH13_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000006c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_nxtcmdar
    },
    {
        "CH13_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000006d0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch13_cmd
    },
    {
        "CH13_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000006e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_bar
    },
    {
        "CH13_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000006f0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch13_sema
    },
    {
        "CH13_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000700, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch13_debug1
    },
    {
        "CH13_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000710, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch13_debug2
    },
    {
        "CH14_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000720, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_curcmdar
    },
    {
        "CH14_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000730, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_nxtcmdar
    },
    {
        "CH14_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000740, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch14_cmd
    },
    {
        "CH14_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000750, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_bar
    },
    {
        "CH14_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000760, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch14_sema
    },
    {
        "CH14_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000770, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch14_debug1
    },
    {
        "CH14_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000780, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch14_debug2
    },
    {
        "CH15_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000790, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_curcmdar
    },
    {
        "CH15_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000007a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_nxtcmdar
    },
    {
        "CH15_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000007b0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch15_cmd
    },
    {
        "CH15_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000007c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_bar
    },
    {
        "CH15_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000007d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch15_sema
    },
    {
        "CH15_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000007e0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch15_debug1
    },
    {
        "CH15_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000007f0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch15_debug2
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes it "
        "indicates the version of the block.",
        4, // Width in bytes
        0x00000800, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_apbh_version
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ASRC
#endif

// Bitfields in register ASRC_ASRCTR.
static const field_t hw_asrc_asrctr[] =
{
    {
        "ASRCEN",
        "ASRC Enable Enable the operation of ASRC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREA",
        "ASRC Enable A Enable the operation of the conversion A of ASRC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREB",
        "ASRC Enable B Enable the operation of the conversion B of ASRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREC",
        "ASRC Enable C Enable the operation of the conversion C of ASRC.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRST",
        "Software Reset This bit is self-clear bit.",
        4, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "IDRA",
        "Use Ideal Ratio for Pair A When USRA=0, this bit has no usage.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRA",
        "Use Ratio for Pair A Use ratio as the input to ASRC.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRB",
        "Use Ideal Ratio for Pair B When USRB=0, this bit has no usage.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRB",
        "Use Ratio for Pair B Use ratio as the input to ASRC.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRC",
        "Use Ideal Ratio for Pair C When USRC=0, this bit has no usage.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRC",
        "Use Ratio for Pair C Use ratio as the input to ASRC.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSA",
        "ASRC Pair A Automatic Selection For Processing Options When this bit i"
        "s 1, pair A will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODA, ASRCFG:POSTMODA see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register) based on "
        "the frequencies it detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSB",
        "ASRC Pair B Automatic Selection For Processing Options When this bit i"
        "s 1, pair B will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODB, ASRCFG:POSTMODB see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register) based on "
        "the frequencies it detected.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSC",
        "ASRC Pair C Automatic Selection For Processing Options When this bit i"
        "s 1, pair C will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODC, ASRCFG:POSTMODC see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register) based on "
        "the frequencies it detected.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIER.
static const field_t hw_asrc_asrier[] =
{
    {
        "ADIEA",
        "Data Input A Interrupt Enable Enables the data input A Interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEB",
        "Data Input B Interrupt Enable Enables the data input B interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEC",
        "Data Input C Interrupt Enable Enables the data input C interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEA",
        "Data Output A Interrupt Enable Enables the data output A interrupt.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEB",
        "Data Output B Interrupt Enable Enables the data output B interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEC",
        "Data Output C Interrupt Enable Enables the data output C interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOLIE",
        "Overload Interrupt Enable Enables the overload interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFPWE",
        "FP in Wait State Interrupt Enable Enables the FP in wait state interru"
        "pt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCNCR.
static const field_t hw_asrc_asrcncr[] =
{
    {
        "ANCA",
        "Number of A Channels",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCB",
        "Number of B Channels",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCC",
        "Number of C ChannelsANCC+ANCB+ANCA<=10.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCFG.
static const field_t hw_asrc_asrcfg[] =
{
    {
        "PREMODA",
        "Pre-Processing Configuration for Conversion Pair A These bits will be "
        "read/write by user if ASRCTR:ATSA=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register).",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODA",
        "Post-Processing Configuration for Conversion Pair A These bits will be"
        " read/write by user if ASRCTR:ATSA=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register).",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODB",
        "Pre-Processing Configuration for Conversion Pair B These bits will be "
        "read/write by user if ASRCTR:ATSB=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register).",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODB",
        "Post-Processing Configuration for Conversion Pair B These bits will be"
        " read/write by user if ASRCTR:ATSB=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register).",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODC",
        "Pre-Processing Configuration for Conversion Pair C These bits will be "
        "read/write by user if ASRCTR:ATSC=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register).",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODC",
        "Post-Processing Configuration for Conversion Pair C These bits will be"
        " read/write by user if ASRCTR:ATSC=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register).",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRA",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir A",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRB",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir B",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRC",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir C",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INIRQA",
        "Initialization for Conversion Pair A is served When this bit is 1, it "
        "means the initialization for conversion pair A is served.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQB",
        "Initialization for Conversion Pair B is served When this bit is 1, it "
        "means the initialization for conversion pair B is served.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQC",
        "Initialization for Conversion Pair C is served When this bit is 1, it "
        "means the initialization for conversion pair C is served.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCSR.
static const field_t hw_asrc_asrcsr[] =
{
    {
        "AICSA",
        "Input Clock Source A",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSB",
        "Input Clock Source B",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSC",
        "Input Clock Source C",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSA",
        "Output Clock Source A",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSB",
        "Output Clock Source B",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSC",
        "Output Clock Source C",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR1.
static const field_t hw_asrc_asrcdr1[] =
{
    {
        "AICPA",
        "Input Clock Prescaler A Specify the prescaling factor of the input pre"
        "scaler A.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDA",
        "Input Clock Divider A Specify the divide ratio of the input clock divi"
        "der A.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICPB",
        "Input Clock Prescaler B Specify the prescaling factor of the input pre"
        "scaler B.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDB",
        "Input Clock Divider B Specify the divide ratio of the input clock divi"
        "der B.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPA",
        "Output Clock Prescaler A Specify the prescaling factor of the output p"
        "rescaler A.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDA",
        "Output Clock Divider A Specify the divide ratio of the output clock di"
        "vider A.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPB",
        "Output Clock Prescaler B Specify the prescaling factor of the output p"
        "rescaler B.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDB",
        "Output Clock Divider B Specify the divide ratio of the output clock di"
        "vider B.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR2.
static const field_t hw_asrc_asrcdr2[] =
{
    {
        "AICPC",
        "Input Clock Prescaler C Specify the prescaling factor of the input pre"
        "scaler C.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDC",
        "Input Clock Divider C Specify the divide ratio of the input clock divi"
        "der C.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPC",
        "Output Clock Prescaler C Specify the prescaling factor of the output p"
        "rescaler C.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDC",
        "Output Clock Divider C Specify the divide ratio of the output clock di"
        "vider C.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRSTR.
static const field_t hw_asrc_asrstr[] =
{
    {
        "AIDEA",
        "Number of data in Input Data Buffer A is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRA is "
        "less than threshold and the processor can write data to ASRDIRA.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEB",
        "Number of data in Input Data Buffer B is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRB is "
        "less than threshold and the processor can write data to ASRDIRB.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEC",
        "Number of data in Input Data Buffer C is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRC is "
        "less than threshold and the processor can write data to ASRDIRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFA",
        "Number of data in Output Data Buffer A is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "A is greater than threshold and the processor can read data from ASRDO"
        "RA.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFB",
        "Number of data in Output Data Buffer B is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "B is greater than threshold and the processor can read data from ASRDO"
        "RB.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFC",
        "Number of data in Output Data Buffer C is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "C is greater than threshold and the processor can read data from ASRDO"
        "RC.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOLE",
        "Overload Error Flag When set, this bit indicates that the task rate is"
        " too high for the ASRC to handle.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FPWT",
        "FP is in wait states This bit is for debug only.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUA",
        "Input Data Buffer A has underflowed When set, this bit indicates that "
        "input data buffer A has underflowed.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUB",
        "Input Data Buffer B has underflowed When set, this bit indicates that "
        "input data buffer B has underflowed.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUC",
        "Input Data Buffer C has underflowed When set, this bit indicates that "
        "input data buffer C has underflowed.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOA",
        "Output Data Buffer A has overflowed When set, this bit indicates that "
        "output data buffer A has overflowed.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOB",
        "Output Data Buffer B has overflowed When set, this bit indicates that "
        "output data buffer B has overflowed.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOC",
        "Output Data Buffer C has overflowed When set, this bit indicates that "
        "output data buffer C has overflowed.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLA",
        "Pair A Input Task Overload When set, this bit indicates that pair A in"
        "put task is oveloaded.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLB",
        "Pair B Input Task Overload When set, this bit indicates that pair B in"
        "put task is oveloaded.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLC",
        "Pair C Input Task Overload When set, this bit indicates that pair C in"
        "put task is oveloaded.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLA",
        "Pair A Output Task Overload When set, this bit indicates that pair A o"
        "utput task is oveloaded.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLB",
        "Pair B Output Task Overload When set, this bit indicates that pair B o"
        "utput task is oveloaded.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLC",
        "Pair C Output Task Overload When set, this bit indicates that pair C o"
        "utput task is oveloaded.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ATQOL",
        "Task Queue FIFO overload When set, this bit indicates that task queue "
        "FIFO logic is oveloaded.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DSLCNT",
        "DSL Counter Input to FIFO ready When set, this bit indicates that new "
        "DSL counter information is stored in the internal ASRC FIFO.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn1.
static const field_t hw_asrc_asrpmn1[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn2.
static const field_t hw_asrc_asrpmn2[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn3.
static const field_t hw_asrc_asrpmn3[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn4.
static const field_t hw_asrc_asrpmn4[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn5.
static const field_t hw_asrc_asrpmn5[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRTFR1.
static const field_t hw_asrc_asrtfr1[] =
{
    {
        "TF_BASE",
        "Base address for task queue FIFO.",
        6, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF_FILL",
        "Current number of entries in task queue FIFO.",
        13, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCCR.
static const field_t hw_asrc_asrccr[] =
{
    {
        "ACIA",
        "The channel counter for Pair A's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair A"
        "'s input FIFO's usage.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIB",
        "The channel counter for Pair B's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair B"
        "'s input FIFO's usage.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIC",
        "The channel counter for Pair C's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair C"
        "'s input FIFO's usage.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOA",
        "The channel counter for Pair A's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "A's output FIFO's usage.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOB",
        "The channel counter for Pair B's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "B's output FIFO's usage.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOC",
        "The channel counter for Pair C's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "C's output FIFO's usage.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIA.
static const field_t hw_asrc_asrdia[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOA.
static const field_t hw_asrc_asrdoa[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIB.
static const field_t hw_asrc_asrdib[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOB.
static const field_t hw_asrc_asrdob[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIC.
static const field_t hw_asrc_asrdic[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOC.
static const field_t hw_asrc_asrdoc[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHA.
static const field_t hw_asrc_asridrha[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLA.
static const field_t hw_asrc_asridrla[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHB.
static const field_t hw_asrc_asridrhb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLB.
static const field_t hw_asrc_asridrlb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHC.
static const field_t hw_asrc_asridrhc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLC.
static const field_t hw_asrc_asridrlc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR76K.
static const field_t hw_asrc_asr76k[] =
{
    {
        "ASR76K",
        "Value for the period of the 76kHz sampling clock.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR56K.
static const field_t hw_asrc_asr56k[] =
{
    {
        "ASR56K",
        "Value for the period of the 56kHz sampling clock",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRA.
static const field_t hw_asrc_asrmcra[] =
{
    {
        "INFIFO_THRESHOLDA",
        "The threshold for Pair A's input FIFO per channel These bits stand for"
        " the threshold for Pair A's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFA",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOA=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFA",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIA=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDA",
        "The threshold for Pair A's output FIFO per channel These bits stand fo"
        "r the threshold for Pair A's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYA",
        "Bypass Polyphase Filtering for Pair A This bit will determine whether "
        "the polyphase filtering part of Pair A conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLA",
        "Stall Pair A conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair A.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHA",
        "Use external thresholds for FIFO control of Pair A This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair A.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFA",
        "Initialize buf of Pair A when pair A is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTA.
static const field_t hw_asrc_asrfsta[] =
{
    {
        "INFIFO_FILLA",
        "The fillings for Pair A's input FIFO per channel These bits stand for "
        "the fillings for Pair A's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEA",
        "Input FIFO is near Empty for Pair A This bit is to indicate whether th"
        "e input FIFO of Pair A is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLA",
        "The fillings for Pair A's output FIFO per channel These bits stand for"
        " the fillings for Pair A's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFA",
        "Output FIFO is near Full for Pair A This bit is to indicate whether th"
        "e output FIFO of Pair A is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRB.
static const field_t hw_asrc_asrmcrb[] =
{
    {
        "INFIFO_THRESHOLDB",
        "The threshold for Pair B's input FIFO per channel These bits stand for"
        " the threshold for Pair B's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFB",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOB=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFB",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIB=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDB",
        "The threshold for Pair B's output FIFO per channel These bits stand fo"
        "r the threshold for Pair B's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYB",
        "Bypass Polyphase Filtering for Pair B This bit will determine whether "
        "the polyphase filtering part of Pair B conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLB",
        "Stall Pair B conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair B.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHB",
        "Use external thresholds for FIFO control of Pair B This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair B.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFB",
        "Initialize buf of Pair B when pair B is enabled This bit is used to co"
        "ntrol whether the buffer is to be zeroized when pair B is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTB.
static const field_t hw_asrc_asrfstb[] =
{
    {
        "INFIFO_FILLB",
        "The fillings for Pair B's input FIFO per channel These bits stand for "
        "the fillings for Pair B's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEB",
        "Input FIFO is near Empty for Pair B This bit is to indicate whether th"
        "e input FIFO of Pair B is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLB",
        "The fillings for Pair B's output FIFO per channel These bits stand for"
        " the fillings for Pair B's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFB",
        "Output FIFO is near Full for Pair B This bit is to indicate whether th"
        "e output FIFO of Pair B is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRC.
static const field_t hw_asrc_asrmcrc[] =
{
    {
        "INFIFO_THRESHOLDC",
        "The threshold for Pair C's input FIFO per channel These bits stand for"
        " the threshold for Pair C's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFC",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOC=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFC",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIC=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDC",
        "The threshold for Pair C's output FIFO per channel These bits stand fo"
        "r the threshold for Pair C's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYC",
        "Bypass Polyphase Filtering for Pair C This bit will determine whether "
        "the polyphase filtering part of Pair C conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLC",
        "Stall Pair C conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair C.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHC",
        "Use external thresholds for FIFO control of Pair C This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair C.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFC",
        "Initialize buf of Pair C when pair C is enabled This bit is used to co"
        "ntrol whether the buffer is to be zeroized when pair C is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTC.
static const field_t hw_asrc_asrfstc[] =
{
    {
        "INFIFO_FILLC",
        "The fillings for Pair C's input FIFO per channel These bits stand for "
        "the fillings for Pair C's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEC",
        "Input FIFO is near Empty for Pair C This bit is to indicate whether th"
        "e input FIFO of Pair C is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLC",
        "The fillings for Pair C's output FIFO per channel These bits stand for"
        " the fillings for Pair C's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFC",
        "Output FIFO is near Full for Pair C This bit is to indicate whether th"
        "e output FIFO of Pair C is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1A.
static const field_t hw_asrc_asrmcr1a[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1B.
static const field_t hw_asrc_asrmcr1b[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1C.
static const field_t hw_asrc_asrmcr1c[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ASRC module.
static const reg_t hw_asrc[] =
{
    {
        "ASRCTR",
        "The ASRC control register (ASRCTR) is a 24-bit read/write register tha"
        "t controls the ASRC operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_asrc_asrctr
    },
    {
        "ASRIER",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrier
    },
    {
        "ASRCNCR",
        "The ASRC channel number configuration register (ASRCNCR) is a 24-bit r"
        "ead/write register that sets the number of channels used by each ASRC "
        "conversion pair.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_asrc_asrcncr
    },
    {
        "ASRCFG",
        "The ASRC configuration status register (ASRCFG) is a 24-bit read/write"
        " register that sets and/or automatically senses the ASRC operations.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_asrc_asrcfg
    },
    {
        "ASRCSR",
        "The ASRC clock source register (ASRCSR) is a 24-bit read/write registe"
        "r that controls the sources of the input and output clocks of the ASRC"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrcsr
    },
    {
        "ASRCDR1",
        "The ASRC clock divider register (ASRCDR1) is a 24-bit read/write regis"
        "ter that controls the division factors of the ASRC input and output cl"
        "ock sources.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrcdr1
    },
    {
        "ASRCDR2",
        "The ASRC clock divider register (ASRCDR2) is a 24-bit read/write regis"
        "ter that controls the division factors of the ASRC input and output cl"
        "ock sources.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_asrc_asrcdr2
    },
    {
        "ASRSTR",
        "The ASRC status register (ASRSTR) is a 24-bit read-write register used"
        " by the processor core to examine the status of the ASRC block and cle"
        "ar the overload interrupt request and AOLE flag bit.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        22, // Number of bitfields
        hw_asrc_asrstr
    },
    {
        "ASRPMn1",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn1
    },
    {
        "ASRPMn2",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn2
    },
    {
        "ASRPMn3",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn3
    },
    {
        "ASRPMn4",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn4
    },
    {
        "ASRPMn5",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn5
    },
    {
        "ASRTFR1",
        "The register defines and shows the parameters for ASRC inner task queu"
        "e FIFOs.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrtfr1
    },
    {
        "ASRCCR",
        "The ASRC channel counter register (ASRCCR) is a 24-bit read/write regi"
        "ster that sets and reflects the current specific input/output FIFO bei"
        "ng accessed through shared peripheral bus for each ASRC conversion pai"
        "r.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrccr
    },
    {
        "ASRDIA",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000060, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdia
    },
    {
        "ASRDOA",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdoa
    },
    {
        "ASRDIB",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000068, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdib
    },
    {
        "ASRDOB",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdob
    },
    {
        "ASRDIC",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000070, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdic
    },
    {
        "ASRDOC",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdoc
    },
    {
        "ASRIDRHA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrha
    },
    {
        "ASRIDRLA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrla
    },
    {
        "ASRIDRHB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrhb
    },
    {
        "ASRIDRLB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrlb
    },
    {
        "ASRIDRHC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrhc
    },
    {
        "ASRIDRLC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrlc
    },
    {
        "ASR76K",
        "The register (ASR76K) holds the period of the 76kHz sampling clock in "
        "terms of the ASRC processing clock with frequency FsASRC.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asr76k
    },
    {
        "ASR56K",
        "The register (ASR56K) holds the period of the 56kHz sampling clock in "
        "terms of the ASRC processing clock with frequency FsASRC.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asr56k
    },
    {
        "ASRMCRA",
        "The register (ASRMCRA) is used to control Pair A internal logic.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcra
    },
    {
        "ASRFSTA",
        "The register (ASRFSTA) is used to show Pair A internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfsta
    },
    {
        "ASRMCRB",
        "The register (ASRMCRB) is used to control Pair B internal logic.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcrb
    },
    {
        "ASRFSTB",
        "The register (ASRFSTB) is used to show Pair B internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfstb
    },
    {
        "ASRMCRC",
        "The register (ASRMCRC) is used to control Pair C internal logic.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcrc
    },
    {
        "ASRFSTC",
        "The register (ASRFSTC) is used to show Pair C internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfstc
    },
    {
        "ASRMCR1A",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1a
    },
    {
        "ASRMCR1B",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1b
    },
    {
        "ASRMCR1C",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1c
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark BCH
#endif

// Bitfields in register BCH_CTRL.
static const field_t hw_bch_ctrl[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_SET.
static const field_t hw_bch_ctrl_set[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_CLR.
static const field_t hw_bch_ctrl_clr[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_TOG.
static const field_t hw_bch_ctrl_tog[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0.
static const field_t hw_bch_status0[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_SET.
static const field_t hw_bch_status0_set[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_CLR.
static const field_t hw_bch_status0_clr[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_TOG.
static const field_t hw_bch_status0_tog[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE.
static const field_t hw_bch_mode[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_SET.
static const field_t hw_bch_mode_set[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_CLR.
static const field_t hw_bch_mode_clr[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_TOG.
static const field_t hw_bch_mode_tog[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR.
static const field_t hw_bch_encodeptr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_SET.
static const field_t hw_bch_encodeptr_set[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_CLR.
static const field_t hw_bch_encodeptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_TOG.
static const field_t hw_bch_encodeptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR.
static const field_t hw_bch_dataptr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_SET.
static const field_t hw_bch_dataptr_set[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_CLR.
static const field_t hw_bch_dataptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_TOG.
static const field_t hw_bch_dataptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR.
static const field_t hw_bch_metaptr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_SET.
static const field_t hw_bch_metaptr_set[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_CLR.
static const field_t hw_bch_metaptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_TOG.
static const field_t hw_bch_metaptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT.
static const field_t hw_bch_layoutselect[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_SET.
static const field_t hw_bch_layoutselect_set[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_CLR.
static const field_t hw_bch_layoutselect_clr[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_TOG.
static const field_t hw_bch_layoutselect_tog[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0.
static const field_t hw_bch_flash0layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_SET.
static const field_t hw_bch_flash0layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_CLR.
static const field_t hw_bch_flash0layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_TOG.
static const field_t hw_bch_flash0layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1.
static const field_t hw_bch_flash0layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_SET.
static const field_t hw_bch_flash0layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_CLR.
static const field_t hw_bch_flash0layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_TOG.
static const field_t hw_bch_flash0layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0.
static const field_t hw_bch_flash1layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_SET.
static const field_t hw_bch_flash1layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_CLR.
static const field_t hw_bch_flash1layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_TOG.
static const field_t hw_bch_flash1layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1.
static const field_t hw_bch_flash1layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_SET.
static const field_t hw_bch_flash1layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_CLR.
static const field_t hw_bch_flash1layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_TOG.
static const field_t hw_bch_flash1layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0.
static const field_t hw_bch_flash2layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_SET.
static const field_t hw_bch_flash2layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_CLR.
static const field_t hw_bch_flash2layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_TOG.
static const field_t hw_bch_flash2layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1.
static const field_t hw_bch_flash2layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_SET.
static const field_t hw_bch_flash2layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_CLR.
static const field_t hw_bch_flash2layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_TOG.
static const field_t hw_bch_flash2layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0.
static const field_t hw_bch_flash3layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_SET.
static const field_t hw_bch_flash3layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_CLR.
static const field_t hw_bch_flash3layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_TOG.
static const field_t hw_bch_flash3layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1.
static const field_t hw_bch_flash3layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_SET.
static const field_t hw_bch_flash3layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_CLR.
static const field_t hw_bch_flash3layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_TOG.
static const field_t hw_bch_flash3layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0.
static const field_t hw_bch_debug0[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_SET.
static const field_t hw_bch_debug0_set[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_CLR.
static const field_t hw_bch_debug0_clr[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_TOG.
static const field_t hw_bch_debug0_tog[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD.
static const field_t hw_bch_dbgkesread[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_SET.
static const field_t hw_bch_dbgkesread_set[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_CLR.
static const field_t hw_bch_dbgkesread_clr[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_TOG.
static const field_t hw_bch_dbgkesread_tog[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD.
static const field_t hw_bch_dbgcsferead[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_SET.
static const field_t hw_bch_dbgcsferead_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_CLR.
static const field_t hw_bch_dbgcsferead_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_TOG.
static const field_t hw_bch_dbgcsferead_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD.
static const field_t hw_bch_dbgsyndgenread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_SET.
static const field_t hw_bch_dbgsyndgenread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_CLR.
static const field_t hw_bch_dbgsyndgenread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_TOG.
static const field_t hw_bch_dbgsyndgenread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD.
static const field_t hw_bch_dbgahbmread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_SET.
static const field_t hw_bch_dbgahbmread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_CLR.
static const field_t hw_bch_dbgahbmread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_TOG.
static const field_t hw_bch_dbgahbmread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME.
static const field_t hw_bch_blockname[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_SET.
static const field_t hw_bch_blockname_set[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_CLR.
static const field_t hw_bch_blockname_clr[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_TOG.
static const field_t hw_bch_blockname_tog[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION.
static const field_t hw_bch_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_SET.
static const field_t hw_bch_version_set[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_CLR.
static const field_t hw_bch_version_clr[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_TOG.
static const field_t hw_bch_version_tog[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1.
static const field_t hw_bch_debug1[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_SET.
static const field_t hw_bch_debug1_set[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_CLR.
static const field_t hw_bch_debug1_clr[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_TOG.
static const field_t hw_bch_debug1_tog[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a BCH module.
static const reg_t hw_bch[] =
{
    {
        "CTRL",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl
    },
    {
        "CTRL_SET",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_set
    },
    {
        "CTRL_CLR",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_clr
    },
    {
        "CTRL_TOG",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_tog
    },
    {
        "STATUS0",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0
    },
    {
        "STATUS0_SET",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_set
    },
    {
        "STATUS0_CLR",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_clr
    },
    {
        "STATUS0_TOG",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_tog
    },
    {
        "MODE",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode
    },
    {
        "MODE_SET",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_set
    },
    {
        "MODE_CLR",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_clr
    },
    {
        "MODE_TOG",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_tog
    },
    {
        "ENCODEPTR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr
    },
    {
        "ENCODEPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_set
    },
    {
        "ENCODEPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_clr
    },
    {
        "ENCODEPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_tog
    },
    {
        "DATAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr
    },
    {
        "DATAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_set
    },
    {
        "DATAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_clr
    },
    {
        "DATAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_tog
    },
    {
        "METAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr
    },
    {
        "METAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_set
    },
    {
        "METAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_clr
    },
    {
        "METAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_tog
    },
    {
        "LAYOUTSELECT",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect
    },
    {
        "LAYOUTSELECT_SET",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_set
    },
    {
        "LAYOUTSELECT_CLR",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_clr
    },
    {
        "LAYOUTSELECT_TOG",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_tog
    },
    {
        "FLASH0LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0
    },
    {
        "FLASH0LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_set
    },
    {
        "FLASH0LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_clr
    },
    {
        "FLASH0LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_tog
    },
    {
        "FLASH0LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1
    },
    {
        "FLASH0LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_set
    },
    {
        "FLASH0LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_clr
    },
    {
        "FLASH0LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_tog
    },
    {
        "FLASH1LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0
    },
    {
        "FLASH1LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_set
    },
    {
        "FLASH1LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_clr
    },
    {
        "FLASH1LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_tog
    },
    {
        "FLASH1LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1
    },
    {
        "FLASH1LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_set
    },
    {
        "FLASH1LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_clr
    },
    {
        "FLASH1LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000bc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_tog
    },
    {
        "FLASH2LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0
    },
    {
        "FLASH2LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_set
    },
    {
        "FLASH2LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_clr
    },
    {
        "FLASH2LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_tog
    },
    {
        "FLASH2LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1
    },
    {
        "FLASH2LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_set
    },
    {
        "FLASH2LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_clr
    },
    {
        "FLASH2LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000dc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_tog
    },
    {
        "FLASH3LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0
    },
    {
        "FLASH3LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_set
    },
    {
        "FLASH3LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_clr
    },
    {
        "FLASH3LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_tog
    },
    {
        "FLASH3LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1
    },
    {
        "FLASH3LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_set
    },
    {
        "FLASH3LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_clr
    },
    {
        "FLASH3LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_tog
    },
    {
        "DEBUG0",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0
    },
    {
        "DEBUG0_SET",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_set
    },
    {
        "DEBUG0_CLR",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_clr
    },
    {
        "DEBUG0_TOG",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_tog
    },
    {
        "DBGKESREAD",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread
    },
    {
        "DBGKESREAD_SET",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_set
    },
    {
        "DBGKESREAD_CLR",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_clr
    },
    {
        "DBGKESREAD_TOG",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_tog
    },
    {
        "DBGCSFEREAD",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead
    },
    {
        "DBGCSFEREAD_SET",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_set
    },
    {
        "DBGCSFEREAD_CLR",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000128, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_clr
    },
    {
        "DBGCSFEREAD_TOG",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000012c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_tog
    },
    {
        "DBGSYNDGENREAD",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread
    },
    {
        "DBGSYNDGENREAD_SET",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000134, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_set
    },
    {
        "DBGSYNDGENREAD_CLR",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000138, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_clr
    },
    {
        "DBGSYNDGENREAD_TOG",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000013c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_tog
    },
    {
        "DBGAHBMREAD",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread
    },
    {
        "DBGAHBMREAD_SET",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_set
    },
    {
        "DBGAHBMREAD_CLR",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000148, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_clr
    },
    {
        "DBGAHBMREAD_TOG",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000014c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_tog
    },
    {
        "BLOCKNAME",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname
    },
    {
        "BLOCKNAME_SET",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_set
    },
    {
        "BLOCKNAME_CLR",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_clr
    },
    {
        "BLOCKNAME_TOG",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_tog
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version
    },
    {
        "VERSION_SET",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_set
    },
    {
        "VERSION_CLR",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_clr
    },
    {
        "VERSION_TOG",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_tog
    },
    {
        "DEBUG1",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1
    },
    {
        "DEBUG1_SET",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_set
    },
    {
        "DEBUG1_CLR",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_clr
    },
    {
        "DEBUG1_TOG",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM
#endif

// Bitfields in register CCM_CCR.
static const field_t hw_ccm_ccr[] =
{
    {
        "OSCNT",
        "Oscillator ready counter value.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_EN",
        "On chip oscillator enable bit - this bit value is reflected on the out"
        "put cosc_en.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG_BYPASS_COUNT",
        "Counter for analog_reg_bypass signal assertion after standby voltage r"
        "equest by PMIC_STBY_REQ.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBC_EN",
        "Enable for REG_BYPASS_COUNTER.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCDR.
static const field_t hw_ccm_ccdr[] =
{
    {
        "MMDC_MASK",
        "During divider ratio mmdc_axi_podf change or sync mux periph2_clk_sel "
        "change (but not jtag) or SRC request during warm reset, mask handshake"
        " with mmdc module.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSR.
static const field_t hw_ccm_csr[] =
{
    {
        "REF_EN_B",
        "Status of the value of CCM_REF_EN_B output of ccm",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COSC_READY",
        "Status indication of on board oscillator.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCSR.
static const field_t hw_ccm_ccsr[] =
{
    {
        "PLL3_SW_CLK_SEL",
        "Selects source to generate pll3_sw_clk.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL1_SW_CLK_SEL",
        "Selects source to generate pll1_sw_clk.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SECONDARY_CLK_SEL",
        "Select source to generate secondary_clk",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STEP_SEL",
        "Selects the option to be chosen for the step frequency when shifting A"
        "RM frequency.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CACRR.
static const field_t hw_ccm_cacrr[] =
{
    {
        "ARM_PODF",
        "Divider for ARM clock root.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCDR.
static const field_t hw_ccm_cbcdr[] =
{
    {
        "PERIPH2_CLK2_PODF",
        "Divider for periph2_clk2 podf.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FABRIC_MMDC_PODF",
        "Post divider for fabric / mmdc clock.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_CLK_SEL",
        "AXI clock source select",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_ALT_CLK_SEL",
        "AXI alternative clock select",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPG_PODF",
        "Divider for ipg podf.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF",
        "Divider for AHB PODF.",
        10, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF",
        "Post divider for axi clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL",
        "Selector for peripheral main clock (source of MMDC_CLK_ROOT).",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL",
        "Selector for peripheral2 main clock (source of mmdc_clk_root ).",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_PODF",
        "Divider for periph2 clock podf.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCMR.
static const field_t hw_ccm_cbcmr[] =
{
    {
        "PERIPH_CLK2_SEL",
        "Selector for peripheral clk2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH_CLK_SEL",
        "Selector for pre_periph clock multiplexer",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK2_SEL",
        "Selector for periph2_clk2 clock multiplexer",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH2_CLK_SEL",
        "Selector for pre_periph2 clock multiplexer",
        21, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PODF",
        "Post-divider for lcdif1 clock.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR1.
static const field_t hw_ccm_cscmr1[] =
{
    {
        "PERCLK_PODF",
        "Divider for perclk podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERCLK_CLK_SEL",
        "Selector for the perclk clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI1_CLK_SEL",
        "QSPI1 clock select",
        7, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI1_CLK_SEL",
        "Selector for sai1 clock multiplexer",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI2_CLK_SEL",
        "Selector for sai2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI3_CLK_SEL",
        "Selector for sai3 clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_CLK_SEL",
        "Selector for usdhc1 clock multiplexer",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_CLK_SEL",
        "Selector for usdhc2 clock multiplexer",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_CLK_SEL",
        "Selector for bch clock multiplexer",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_CLK_SEL",
        "Selector for gpmi clock multiplexer",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EIM_SLOW_PODF",
        "Divider for aclk_eim_slow clock root.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI1_PODF",
        "Divider for QSPI1 clock root",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EIM_SLOW_SEL",
        "Selector for aclk_eim_slow root clock multiplexer",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR2.
static const field_t hw_ccm_cscmr2[] =
{
    {
        "CAN_CLK_PODF",
        "Divider for can clock podf.",
        2, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN_CLK_SEL",
        "Selector for FlexCAN clock multiplexer",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_DIV",
        "Control for divider of ldb clock for di0",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_DIV",
        "Control for divider of ldb clock for di1",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_SEL",
        "Selector for the ESAI clock",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_SEL",
        "Selector for vid clock multiplexer",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_PRE_PODF",
        "Post-divider for vid clock root",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_PODF",
        "Post-divider for vid clock root",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR1.
static const field_t hw_ccm_cscdr1[] =
{
    {
        "UART_CLK_PODF",
        "Divider for uart clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UART_CLK_SEL",
        "Selector for the UART clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_PODF",
        "Divider for usdhc1 clock podf.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_PODF",
        "Divider for usdhc2 clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_PODF",
        "Divider for bch clock podf.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_PODF",
        "Divider for gpmi clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS1CDR.
static const field_t hw_ccm_cs1cdr[] =
{
    {
        "SAI1_CLK_PODF",
        "Divider for sai1 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI1_CLK_PRED",
        "Divider for sai1 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_PRED",
        "",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI3_CLK_PODF",
        "Divider for sai3 clock podf.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI3_CLK_PRED",
        "Divider for sai3 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_PODF",
        "",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS2CDR.
static const field_t hw_ccm_cs2cdr[] =
{
    {
        "SAI2_CLK_PODF",
        "Divider for sai2 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI2_CLK_PRED",
        "Divider for sai2 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_CLK_SEL",
        "Selector for ldb_di0 clock multiplexerMultiplexor should be updated wh"
        "en both input and output clocks are gated.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_SEL",
        "Selector for enfc clock multiplexer Multiplexor should be updated when"
        " output clock is gated.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_PRED",
        "Divider for enfc clock pred divider.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_PODF",
        "Divider for enfc clock divider.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CDCDR.
static const field_t hw_ccm_cdcdr[] =
{
    {
        "SPDIF0_CLK_SEL",
        "Selector for spdif0 clock multiplexer",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PODF",
        "Divider for spdif0 clock podf.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PRED",
        "Divider for spdif0 clock pred.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CHSCCDR.
static const field_t hw_ccm_chsccdr[] =
{
    {
        "EPDC_CLK_SEL",
        "",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_PODF",
        "Divider for EPDC clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EPDC_PRE_CLK_SEL",
        "",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR2.
static const field_t hw_ccm_cscdr2[] =
{
    {
        "LCDIF1_CLK_SEL",
        "Selector for lcdif1 root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PRED",
        "Pre-divider for lcdif1 clock.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PRE_CLK_SEL",
        "Selector for lcdif1 root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_SEL",
        "Selector for the ECSPI clock multiplexor",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_PODF",
        "Divider for ecspi clock podf.",
        19, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR3.
static const field_t hw_ccm_cscdr3[] =
{
    {
        "CSI_CLK_SEL",
        "Selector for csi clock multiplexer",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_PODF",
        "Post divider for csi_core clock.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CWDR.
static const field_t hw_ccm_cwdr[] =
{
    { 0 } // Terminator
};

// Bitfields in register CCM_CDHIPR.
static const field_t hw_ccm_cdhipr[] =
{
    {
        "AXI_PODF_BUSY",
        "Busy indicator for axi_podf.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AHB_PODF_BUSY",
        "Busy indicator for ahb_podf.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_PODF_BUSY",
        "Busy indicator for mmdc_axi_podf.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_BUSY",
        "Busy indicator for periph2_clk_sel mux control.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH_CLK_SEL_BUSY",
        "Busy indicator for periph_clk_sel mux control.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_PODF_BUSY",
        "Busy indicator for arm_podf.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CLPCR.
static const field_t hw_ccm_clpcr[] =
{
    {
        "LPM",
        "Setting the low power mode that system will enter on next assertion of"
        " dsm_request signal.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_CLK_DIS_ON_LPM",
        "Define if ARM clocks (arm_clk, soc_mxclk, soc_pclk, soc_dbg_pclk, vl_w"
        "rck) will be disabled on wait mode.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SBYOS",
        "Standby clock oscillator bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_REF_OSC",
        "dis_ref_osc - in run mode, software can manually control closing of ex"
        "ternal reference oscillator clock, i.e.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSTBY",
        "Voltage standby request bit.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STBY_COUNT",
        "Standby counter definition.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_PWRDOWN",
        "In run mode, software can manually control powering down of on chip os"
        "cillator, i.e.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_LPM_HS",
        "Bypass handshake with mmdc on next entrance to low power mode (STOP or"
        " WAIT).",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE0_WFI",
        "Mask WFI of core0 for entering low power mode Assertion of all bits[27"
        ":22] will generate low power mode request",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_SCU_IDLE",
        "Mask SCU IDLE for entering low power mode Assertion of all bits[27:22]"
        " will generate low power mode request",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_L2CC_IDLE",
        "Mask L2CC IDLE for entering low power mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CISR.
static const field_t hw_ccm_cisr[] =
{
    {
        "LRF_PLL",
        "CCM interrupt request 2 generated due to lock of all enabled and not b"
        "ypaseed PLLs",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_READY",
        "CCM interrupt request 2 generated due to on board oscillator ready, i."
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of axi_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL_LOADED",
        "CCM interrupt request 1 generated due to frequency change of periph2_c"
        "lk_sel",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of mmdc_podf"
        "_ loaded",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL_LOADED",
        "CCM interrupt request 1 generated due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of arm_podf.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CIMR.
static const field_t hw_ccm_cimr[] =
{
    {
        "MASK_LRF_PLL",
        "mask interrupt generation due to lrf of PLLs",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_COSC_READY",
        "mask interrupt generation due to on board oscillator ready",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AXI_PODF_LOADED",
        "mask interrupt generation due to frequency change of axi_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH2_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph2_clk_sel.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AHB_PODF_LOADED",
        "mask interrupt generation due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_podf",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "mask interrupt generation due to frequency change of arm_podf",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCOSR.
static const field_t hw_ccm_ccosr[] =
{
    {
        "CLKO_SEL",
        "Selection of the clock to be generated on CCM_CLKO1",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_DIV",
        "Setting the divider of CCM_CLKO1",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_EN",
        "Enable of CCM_CLKO1 clock",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK_OUT_SEL",
        "CCM_CLKO1 output to reflect CCM_CLKO1 or CCM_CLKO2 clocks",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_SEL",
        "Selection of the clock to be generated on CCM_CLKO2",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_DIV",
        "Setting the divider of CCM_CLKO2",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_EN",
        "Enable of CCM_CLKO2 clock",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CGPR.
static const field_t hw_ccm_cgpr[] =
{
    {
        "PMIC_DELAY_SCALER",
        "Defines clock dividion of clock for stby_count (pmic delay counter)",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_EXT_CLK_DIS",
        "Disable external clock driver of MMDC during STOP mode",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EFUSE_PROG_SUPPLY_GATE",
        "Defines the value of the output signal cgpr_dout[4].",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYS_MEM_DS_CTRL",
        "System memory DS control",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPL",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT_MEM_CLK_LPM",
        "Control for the Deep Sleep signal to the ARM Platform memories with ad"
        "ditional control logic based on the ARM WFI signal.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0.
static const field_t hw_ccm_ccgr0[] =
{
    {
        "CG0",
        "aips_tz1 clocks (aips_tz1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "aips_tz2 clocks (aips_tz2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "apbhdma hclk clock (apbhdma_hclk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "asrc clock (asrc_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "dcp clock (dcp_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "enet clock (enet_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "can1 clock (can1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "can1_serial clock (can1_serial_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "can2 clock (can2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "can2_serial clock (can2_serial_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "CPU debug clocks (arm_dbg_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "dcic1 clocks (dcic1_clk_enable) gpt2 bus clocks (gpt2_bus_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpt2 serial clocks (gpt2_serial_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "uart2 clock (uart2_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "gpio2_clocks (gpio2_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1.
static const field_t hw_ccm_ccgr1[] =
{
    {
        "CG0",
        "ecspi1 clocks (ecspi1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "ecspi2 clocks (ecspi2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "ecspi3 clocks (ecspi3_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "ecspi4 clocks (ecspi4_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "adc2 clock (adc2_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "uart3 clock (uart3_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "epit1 clocks (epit1_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "epit2 clocks (epit2_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "adc1 clock (adc1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "sim_s clock (sim_s_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "gpt bus clock (gpt_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "gpt serial clock (gpt_serial_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart4 clock (uart4_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpio1 clock (gpio1_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "csu clock (csu_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "gpio5 clock (gpio5_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2.
static const field_t hw_ccm_ccgr2[] =
{
    {
        "CG0",
        "esai clock (esai_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "csi clock (csi_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "iomuxc_snvs clock (iomuxc_snvs_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "i2c1_serial clock (i2c1_serial_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "i2c2_serial clock (i2c2_serial_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "i2c3_serial clock (i2c3_serial_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "OCOTP_CTRL clock (iim_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "iomux_ipt_clk_io clock (iomux_ipt_clk_io_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "ipmux1 clock (ipmux1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ipmux2 clock (ipmux2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ipmux3 clock (ipmux3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ipsync_ip2apb_tzasc1_ipg clocks (ipsync_ip2apb_tzasc1_ipg_master_clk_e"
        "nable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpio3 clock (gpio3_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "lcd clocks (lcd_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "pxp clocks (pxp_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3.
static const field_t hw_ccm_ccgr3[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "uart5 clock (uart5_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "epdc clock (epdc_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "uart6 clock (uart6_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "CA7 CCM DAP clock (ccm_dap_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "lcdif1 pix clock (lcdif1_pix_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "gpio4 clock (gpio4_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "qspi1 clock (qspi1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "wdog1 clock (wdog1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "a7 clkdiv patch clock (a7_clkdiv_patch_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "mmdc_core_aclk_fast_core_p0 clock (mmdc_core_aclk_fast_core_p0_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "Reserved",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "mmdc_core_ipg_clk_p0 clock (mmdc_core_ipg_clk_p0_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "mmdc_core_ipg_clk_p1 clock (mmdc_core_ipg_clk_p1_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "axi clock (axi_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "iomuxc_snvs_gpr clock (iomuxc_snvs_gpr_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4.
static const field_t hw_ccm_ccgr4[] =
{
    {
        "CG0",
        "pcie clock (pcie_root_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "iomuxc clock (iomuxc_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "iomuxc gpr clock (iomuxc_gpr_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sim_cpu clock (sim_cpu_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "cxapbsyncbridge slave clock (cxapbsyncbridge_slave_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "tsc_dig clock (tsc_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "pl301_mx6qper1_bch clocks (pl301_mx6qper1_bchclk_enable) This gates bc"
        "h_clk_root to sim_m fabric.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "pl301_mx6qper2_mainclk_enable (pl301_mx6qper2_mainclk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm1 clocks (pwm1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "pwm2 clocks (pwm2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "pwm3 clocks (pwm3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "pwm4 clocks (pwm4_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "rawnand_u_bch_input_apb clock (rawnand_u_bch_input_apb_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "rawnand_u_gpmi_bch_input_bch clock (rawnand_u_gpmi_bch_input_bch_clk_e"
        "nable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "rawnand_u_gpmi_bch_input_gpmi_io clock (rawnand_u_gpmi_bch_input_gpmi_"
        "io_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "rawnand_u_gpmi_input_apb clock (rawnand_u_gpmi_input_apb_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5.
static const field_t hw_ccm_ccgr5[] =
{
    {
        "CG0",
        "rom clock (rom_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "stcr clock (stcr_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "snvs dryice clock (snvs_dryice_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sdma clock (sdma_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "kpp clock (kpp_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "wdog2 clock (wdog2_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "spba clock (spba_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "spdif / audio clock (spdif_clk_enable, audio_clk_root)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "sim_main clock (sim_main_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "snvs_hp clock (snvs_hp_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "snvs_lp clock (snvs_lp_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "sai3 clock (sai3_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart1 clock (uart1_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "uart7 clock (uart7_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "sai1 clock (sai1_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "sai2 clock (sai2_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6.
static const field_t hw_ccm_ccgr6[] =
{
    {
        "CG0",
        "usboh3 clock (usboh3_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "usdhc1 clocks (usdhc1_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "usdhc2 clocks (usdhc2_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "Reserved",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "ipmux4 clock (ipmux4_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "eim_slow clocks (eim_slow_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "Reserved",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "uart8 clocks (uart8_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm8 clocks (pwm8_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "aips_tz3 clock (aips_tz3_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "wdog3 clock (wdog3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "anadig clocks (anadig_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "i2c4 serial clock (i2c4_serial_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "pwm5 clocks (pwm5_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "pwm6 clocks (pwm6_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "pwm7 clocks (pwm7_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CMEOR.
static const field_t hw_ccm_cmeor[] =
{
    {
        "MOD_EN_OV_GPT",
        "Overide clock enable signal from GPT - clock will not be gated based o"
        "n GPT's signal 'ipg_enable_clk' .",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_EPIT",
        "Overide clock enable signal from EPIT - clock will not be gated based "
        "on EPIT's signal 'ipg_enable_clk' .",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_USDHC",
        "overide clock enable signal from USDHC.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN2_CPI",
        "Overide clock enable signal from CAN2 - clock will not be gated based "
        "on CAN's signal 'enable_clk_cpi'.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN1_CPI",
        "Overide clock enable signal from CAN1 - clock will not be gated based "
        "on CAN's signal 'enable_clk_cpi'.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM module.
static const reg_t hw_ccm[] =
{
    {
        "CCR",
        "The figure below represents the CCM Control Register (CCR), which cont"
        "ains bits to control general operation of CCM.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ccr
    },
    {
        "CCDR",
        "The figure below represents the CCM Control Divider Register (CCDR), w"
        "hich contains bits that control the loading of the dividers that need "
        "handshake with the modules they affect.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_ccdr
    },
    {
        "CSR",
        "The figure below represents the CCM status Register (CSR).",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_ccm_csr
    },
    {
        "CCSR",
        "The figure below represents the CCM Clock Switcher register (CCSR).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ccsr
    },
    {
        "CACRR",
        "The figure below represents the CCM Arm Clock Root register (CACRR).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_cacrr
    },
    {
        "CBCDR",
        "The figure below represents the CCM Bus Clock Divider Register (CBCDR)"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cbcdr
    },
    {
        "CBCMR",
        "The figure below represents the CCM Bus Clock Multiplexer Register (CB"
        "CMR).",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cbcmr
    },
    {
        "CSCMR1",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "1 (CSCMR1).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_ccm_cscmr1
    },
    {
        "CSCMR2",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "2 (CSCMR2).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cscmr2
    },
    {
        "CSCDR1",
        "The figure below represents the CCM Serial Clock Divider Register 1 (C"
        "SCDR1).",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cscdr1
    },
    {
        "CS1CDR",
        "The figure below represents the CCM SAI1, and SAI3 Clock Divider Regis"
        "ter (CS1CDR).",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cs1cdr
    },
    {
        "CS2CDR",
        "The figure below represents the CCM SAI2, LDB Clock Divider Register ("
        "CS2CDR).",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cs2cdr
    },
    {
        "CDCDR",
        "The figure below represents the CCM DI Clock Divider Register (CDCDR).",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_cdcdr
    },
    {
        "CHSCCDR",
        "The figure below represents the CCM HSC Clock Divider Register (CHSCCD"
        "R).",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_chsccdr
    },
    {
        "CSCDR2",
        "The figure below represents the CCM Serial Clock Divider Register 2(CS"
        "CDR2).",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cscdr2
    },
    {
        "CSCDR3",
        "The figure below represents the CCM Serial Clock Divider Register 3(CS"
        "CDR3).",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_ccm_cscdr3
    },
    {
        "CWDR",
        "The figure below represents the CCM Wakeup Detector Register (CWDR).",
        4, // Width in bytes
        0x00000044, // Base address offset
        false, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_ccm_cwdr
    },
    {
        "CDHIPR",
        "The figure below represents the CCM Divider Handshake In-Process Regis"
        "ter (CDHIPR).",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_ccm_cdhipr
    },
    {
        "CLPCR",
        "The figure below represents the CCM Low Power Control Register (CLPCR)"
        ".",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_clpcr
    },
    {
        "CISR",
        "The figure below represents the CCM Interrupt Status Register (CISR).",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cisr
    },
    {
        "CIMR",
        "The figure below represents the CCM Interrupt Mask Register (CIMR).",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cimr
    },
    {
        "CCOSR",
        "The figure below represents the CCM Clock Output Source Register (CCOS"
        "R).",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_ccosr
    },
    {
        "CGPR",
        "Fast PLL enable.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cgpr
    },
    {
        "CCGR0",
        "CG(i) bits CCGR 0-6 These bits are used to turn on/off the clock to ea"
        "ch module independently.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr0
    },
    {
        "CCGR1",
        "The figure below represents the CCM Clock Gating Register 1(CCM_CCGR1)"
        ".",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr1
    },
    {
        "CCGR2",
        "The figure below represents the CCM Clock Gating Register 2 (CCM_CCGR2"
        ").",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr2
    },
    {
        "CCGR3",
        "The figure below represents the CCM Clock Gating Register 3 (CCM_CCGR3"
        ").",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr3
    },
    {
        "CCGR4",
        "The figure below represents the CCM Clock Gating Register 4 (CCM_CCGR4"
        ").",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr4
    },
    {
        "CCGR5",
        "The figure below represents the CCM Clock Gating Register 5 (CCM_CCGR5"
        ").",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr5
    },
    {
        "CCGR6",
        "The figure below represents the CCM Clock Gating Register 6 (CCM_CCGR6"
        ").",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr6
    },
    {
        "CMEOR",
        "The follow figure represents the CCM Module Enable Override Register ("
        "CMEOR).",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cmeor
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM_ANALOG
#endif

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM.
static const field_t hw_ccm_analog_analog_pll_arm[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_SET.
static const field_t hw_ccm_analog_analog_pll_arm_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_CLR.
static const field_t hw_ccm_analog_analog_pll_arm_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_TOG.
static const field_t hw_ccm_analog_analog_pll_arm_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1.
static const field_t hw_ccm_analog_analog_pll_usb1[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_SET.
static const field_t hw_ccm_analog_analog_pll_usb1_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_CLR.
static const field_t hw_ccm_analog_analog_pll_usb1_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_TOG.
static const field_t hw_ccm_analog_analog_pll_usb1_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2.
static const field_t hw_ccm_analog_analog_pll_usb2[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_SET.
static const field_t hw_ccm_analog_analog_pll_usb2_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_CLR.
static const field_t hw_ccm_analog_analog_pll_usb2_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_TOG.
static const field_t hw_ccm_analog_analog_pll_usb2_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS.
static const field_t hw_ccm_analog_analog_pll_sys[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_SET.
static const field_t hw_ccm_analog_analog_pll_sys_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_CLR.
static const field_t hw_ccm_analog_analog_pll_sys_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_TOG.
static const field_t hw_ccm_analog_analog_pll_sys_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_SS.
static const field_t hw_ccm_analog_analog_pll_sys_ss[] =
{
    {
        "STEP",
        "Frequency change step = step/CCM_ANALOG_PLL_SYS_DENOM[B]*24MHz.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP",
        "Frequency change = stop/CCM_ANALOG_PLL_SYS_DENOM[B]*24MHz.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_NUM.
static const field_t hw_ccm_analog_analog_pll_sys_num[] =
{
    {
        "A",
        "30 bit numerator (A) of fractional loop divider (signed integer).",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_DENOM.
static const field_t hw_ccm_analog_analog_pll_sys_denom[] =
{
    {
        "B",
        "30 bit Denominator (B) of fractional loop divider (unsigned integer).",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO.
static const field_t hw_ccm_analog_analog_pll_audio[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_SET.
static const field_t hw_ccm_analog_analog_pll_audio_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_CLR.
static const field_t hw_ccm_analog_analog_pll_audio_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_TOG.
static const field_t hw_ccm_analog_analog_pll_audio_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_NUM.
static const field_t hw_ccm_analog_analog_pll_audio_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_DENOM.
static const field_t hw_ccm_analog_analog_pll_audio_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO.
static const field_t hw_ccm_analog_analog_pll_video[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_SET.
static const field_t hw_ccm_analog_analog_pll_video_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_CLR.
static const field_t hw_ccm_analog_analog_pll_video_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_TOG.
static const field_t hw_ccm_analog_analog_pll_video_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_NUM.
static const field_t hw_ccm_analog_analog_pll_video_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider(Signed number), absolute v"
        "alue should be less than denominator",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_DENOM.
static const field_t hw_ccm_analog_analog_pll_video_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET.
static const field_t hw_ccm_analog_analog_pll_enet[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_SET.
static const field_t hw_ccm_analog_analog_pll_enet_set[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_CLR.
static const field_t hw_ccm_analog_analog_pll_enet_clr[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_TOG.
static const field_t hw_ccm_analog_analog_pll_enet_tog[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480.
static const field_t hw_ccm_analog_analog_pfd_480[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_SET.
static const field_t hw_ccm_analog_analog_pfd_480_set[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_CLR.
static const field_t hw_ccm_analog_analog_pfd_480_clr[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_TOG.
static const field_t hw_ccm_analog_analog_pfd_480_tog[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528.
static const field_t hw_ccm_analog_analog_pfd_528[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_SET.
static const field_t hw_ccm_analog_analog_pfd_528_set[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_CLR.
static const field_t hw_ccm_analog_analog_pfd_528_clr[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_TOG.
static const field_t hw_ccm_analog_analog_pfd_528_tog[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0.
static const field_t hw_ccm_analog_analog_misc0[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_SET.
static const field_t hw_ccm_analog_analog_misc0_set[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_CLR.
static const field_t hw_ccm_analog_analog_misc0_clr[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_TOG.
static const field_t hw_ccm_analog_analog_misc0_tog[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1.
static const field_t hw_ccm_analog_analog_misc1[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk1/1b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_SET.
static const field_t hw_ccm_analog_analog_misc1_set[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk1/1b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_CLR.
static const field_t hw_ccm_analog_analog_misc1_clr[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk1/1b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_TOG.
static const field_t hw_ccm_analog_analog_misc1_tog[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk1/1b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2.
static const field_t hw_ccm_analog_analog_misc2[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_SET.
static const field_t hw_ccm_analog_analog_misc2_set[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_CLR.
static const field_t hw_ccm_analog_analog_misc2_clr[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_TOG.
static const field_t hw_ccm_analog_analog_misc2_tog[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM_ANALOG module.
static const reg_t hw_ccm_analog[] =
{
    {
        "ANALOG_PLL_ARM",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm
    },
    {
        "ANALOG_PLL_ARM_SET",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_set
    },
    {
        "ANALOG_PLL_ARM_CLR",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_clr
    },
    {
        "ANALOG_PLL_ARM_TOG",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_tog
    },
    {
        "ANALOG_PLL_USB1",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1
    },
    {
        "ANALOG_PLL_USB1_SET",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_set
    },
    {
        "ANALOG_PLL_USB1_CLR",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_clr
    },
    {
        "ANALOG_PLL_USB1_TOG",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_tog
    },
    {
        "ANALOG_PLL_USB2",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2
    },
    {
        "ANALOG_PLL_USB2_SET",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_set
    },
    {
        "ANALOG_PLL_USB2_CLR",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_clr
    },
    {
        "ANALOG_PLL_USB2_TOG",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_tog
    },
    {
        "ANALOG_PLL_SYS",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys
    },
    {
        "ANALOG_PLL_SYS_SET",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_set
    },
    {
        "ANALOG_PLL_SYS_CLR",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_clr
    },
    {
        "ANALOG_PLL_SYS_TOG",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_tog
    },
    {
        "ANALOG_PLL_SYS_SS",
        "This register contains the 528 PLL spread spectrum controls.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_ss
    },
    {
        "ANALOG_PLL_SYS_NUM",
        "This register contains the numerator of 528MHz PLL fractional loop div"
        "ider (signed number).",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_num
    },
    {
        "ANALOG_PLL_SYS_DENOM",
        "This register contains the Denominator of 528MHz PLL fractional loop d"
        "ivider.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_denom
    },
    {
        "ANALOG_PLL_AUDIO",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio
    },
    {
        "ANALOG_PLL_AUDIO_SET",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_set
    },
    {
        "ANALOG_PLL_AUDIO_CLR",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_clr
    },
    {
        "ANALOG_PLL_AUDIO_TOG",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_tog
    },
    {
        "ANALOG_PLL_AUDIO_NUM",
        "This register contains the numerator (A) of Audio PLL fractional loop "
        "divider.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_num
    },
    {
        "ANALOG_PLL_AUDIO_DENOM",
        "This register contains the Denominator (B) of Audio PLL fractional loo"
        "p divider.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_denom
    },
    {
        "ANALOG_PLL_VIDEO",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video
    },
    {
        "ANALOG_PLL_VIDEO_SET",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_set
    },
    {
        "ANALOG_PLL_VIDEO_CLR",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_clr
    },
    {
        "ANALOG_PLL_VIDEO_TOG",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_tog
    },
    {
        "ANALOG_PLL_VIDEO_NUM",
        "This register contains the numerator (A) of Video PLL fractional loop "
        "divider.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_video_num
    },
    {
        "ANALOG_PLL_VIDEO_DENOM",
        "This register contains the Denominator (B) of Video PLL fractional loo"
        "p divider.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_video_denom
    },
    {
        "ANALOG_PLL_ENET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet
    },
    {
        "ANALOG_PLL_ENET_SET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_set
    },
    {
        "ANALOG_PLL_ENET_CLR",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_clr
    },
    {
        "ANALOG_PLL_ENET_TOG",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_tog
    },
    {
        "ANALOG_PFD_480",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480
    },
    {
        "ANALOG_PFD_480_SET",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_set
    },
    {
        "ANALOG_PFD_480_CLR",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_clr
    },
    {
        "ANALOG_PFD_480_TOG",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_tog
    },
    {
        "ANALOG_PFD_528",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528
    },
    {
        "ANALOG_PFD_528_SET",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_set
    },
    {
        "ANALOG_PFD_528_CLR",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_clr
    },
    {
        "ANALOG_PFD_528_TOG",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_tog
    },
    {
        "ANALOG_MISC0",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0
    },
    {
        "ANALOG_MISC0_SET",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_set
    },
    {
        "ANALOG_MISC0_CLR",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_clr
    },
    {
        "ANALOG_MISC0_TOG",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_tog
    },
    {
        "ANALOG_MISC1",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_analog_analog_misc1
    },
    {
        "ANALOG_MISC1_SET",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_analog_analog_misc1_set
    },
    {
        "ANALOG_MISC1_CLR",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_analog_analog_misc1_clr
    },
    {
        "ANALOG_MISC1_TOG",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_analog_analog_misc1_tog
    },
    {
        "ANALOG_MISC2",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2
    },
    {
        "ANALOG_MISC2_SET",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_set
    },
    {
        "ANALOG_MISC2_CLR",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_clr
    },
    {
        "ANALOG_MISC2_TOG",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSI
#endif

// Bitfields in register CSI_CSICR1.
static const field_t hw_csi_csicr1[] =
{
    {
        "PIXEL_BIT",
        "Pixel Bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REDGE",
        "Valid Pixel Clock Edge Select.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_PCLK",
        "Invert Pixel Clock Input.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_DATA",
        "Invert Data Input.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GCLK_MODE",
        "Gated Clock Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_RXFIFO",
        "Asynchronous RXFIFO Clear.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_STATFIFO",
        "Asynchronous STATFIFO Clear.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PACK_DIR",
        "Data Packing Direction.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCC",
        "FIFO Clear Control.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CCIR_EN",
        "CCIR656 Interface Enable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "HSYNC Polarity Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INTEN",
        "Start Of Frame (SOF) Interrupt Enable.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_POL",
        "SOF Interrupt Polarity.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INTEN",
        "RxFIFO Full Interrupt Enable.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB1_DMA_DONE_INTEN",
        "Frame Buffer1 DMA Transfer Done Interrupt Enable.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB2_DMA_DONE_INTEN",
        "Frame Buffer2 DMA Transfer Done Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INTEN",
        "STATFIFO Full Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFF_DMA_DONE_INTEN",
        "STATFIFO DMA Transfer Done Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INTEN",
        "RxFIFO Overrun Interrupt Enable.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INTEN",
        "STAT FIFO Overrun Interrupt Enable.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT_EN",
        "Change Of Image Field (COF) Interrupt Enable.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_MODE",
        "Video mode select.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRP_IF_EN",
        "CSI-PrP Interface Enable.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT_EN",
        "End-of-Frame Interrupt Enable.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXT_VSYNC",
        "External VSYNC Enable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWAP16_EN",
        "SWAP 16-Bit Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR2.
static const field_t hw_csi_csicr2[] =
{
    {
        "HSC",
        "Horizontal Skip Count.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSC",
        "Vertical Skip Count.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVRM",
        "Live View Resolution Mode.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BTS",
        "Bayer Tile Start.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCE",
        "Skip Count Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFS",
        "Auto Focus Spread.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRM",
        "Double Resolution Mode.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_SFF",
        "Burst Type of DMA Transfer from STATFIFO.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_RFF",
        "Burst Type of DMA Transfer from RxFIFO.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR3.
static const field_t hw_csi_csicr3[] =
{
    {
        "ECC_AUTO_EN",
        "Automatic Error Correction Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT_EN",
        "Error Detection Interrupt Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZERO_PACK_EN",
        "Dummy Zero Packing Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWO_8BIT_SENSOR",
        "Two 8-bit Sensor Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_LEVEL",
        "RxFIFO Full Level.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_EN",
        "Hresponse Error Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_LEVEL",
        "STATFIFO Full Level.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_SFF",
        "DMA Request Enable for STATFIFO.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_RFF",
        "DMA Request Enable for RxFIFO.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_SFF",
        "Reflash DMA Controller for STATFIFO.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_RFF",
        "Reflash DMA Controller for RxFIFO.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT_RST",
        "Frame Count Reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT",
        "Frame Counter.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISTATFIFO.
static const field_t hw_csi_csistatfifo[] =
{
    {
        "STAT",
        "Static data from sensor",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRFIFO.
static const field_t hw_csi_csirfifo[] =
{
    {
        "IMAGE",
        "Received image data",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRXCNT.
static const field_t hw_csi_csirxcnt[] =
{
    {
        "RXCNT",
        "RxFIFO Count.",
        0, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISR.
static const field_t hw_csi_csisr[] =
{
    {
        "DRDY",
        "RXFIFO Data Ready.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT",
        "CCIR Error Interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_INT",
        "Hresponse Error Interrupt Status.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT",
        "Change Of Field Interrupt Status.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F1_INT",
        "CCIR Field 1 Interrupt Status.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F2_INT",
        "CCIR Field 2 Interrupt Status.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INT",
        "Start of Frame Interrupt Status.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT",
        "End of Frame (EOF) Interrupt Status.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INT",
        "RXFIFO Full Interrupt Status.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB1",
        "DMA Transfer Done in Frame Buffer1.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB2",
        "DMA Transfer Done in Frame Buffer2.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INT",
        "STATFIFO Full Interrupt Status.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_SFF",
        "DMA Transfer Done from StatFIFO.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INT",
        "RxFIFO Overrun Interrupt Status.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INT",
        "STATFIFO Overrun Interrupt Status.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD1_DONE",
        "When DMA field 0 is complete, this bit will be set to 1(clear by writi"
        "ng 1).",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD0_DONE",
        "When DMA field 0 is complete, this bit will be set to 1(clear by writi"
        "ng 1).",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_CHHANGE_ERROR",
        "When using base address switching enable, this bit will be 1 when swit"
        "ching occur before DMA complete.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_STATFIFO.
static const field_t hw_csi_csidmasa_statfifo[] =
{
    {
        "DMA_START_ADDR_SFF",
        "DMA Start Address for STATFIFO.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMATS_STATFIFO.
static const field_t hw_csi_csidmats_statfifo[] =
{
    {
        "DMA_TSF_SIZE_SFF",
        "DMA Transfer Size for STATFIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB1.
static const field_t hw_csi_csidmasa_fb1[] =
{
    {
        "DMA_START_ADDR_FB1",
        "DMA Start Address in Frame Buffer1.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB2.
static const field_t hw_csi_csidmasa_fb2[] =
{
    {
        "DMA_START_ADDR_FB2",
        "DMA Start Address in Frame Buffer2.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIFBUF_PARA.
static const field_t hw_csi_csifbuf_para[] =
{
    {
        "FBUF_STRIDE",
        "Frame Buffer Parameter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEINTERLACE_STRIDE",
        "DEINTERLACE_STRIDE is only used in the deinterlace mode.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIIMAG_PARA.
static const field_t hw_csi_csiimag_para[] =
{
    {
        "IMAGE_HEIGHT",
        "Image Height.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMAGE_WIDTH",
        "Image Width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR18.
static const field_t hw_csi_csicr18[] =
{
    {
        "NTSC_EN",
        "This bit is used to select NTSC/PAL mode When input is TVDECODER or st"
        "andard CCIR656 video.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEINTERLACE_EN",
        "This bit is used to select the output method When input is standard CC"
        "IR656 video.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PARALLEL24_EN",
        "When input is parallel rgb888/yuv444 24bit, this bit can be enabled.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_SWITCH_EN",
        "When this bit is enabled, CSI DMA will switch the base address accordi"
        "ng to BASEADDR_SWITCH_SEL rather than atomically by DMA completed.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_SWITCH_SEL",
        "CSI 2 base addresses switching method.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIELD0_DONE_IE",
        "In interlace mode, fileld 0 means interrupt enabled.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD1_DONE_IE",
        "When in interlace mode, field 1 done interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LAST_DMA_REQ_SEL",
        "Choosing the last DMA request condition.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_CHANGE_ERROR_IE",
        "Base address change error interrupt enable signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RGB888A_FORMAT_SEL",
        "Output is 32-bit format.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_HPROT",
        "Hprot value in AHB bus protocol.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_LCDIF_BUFFER_LINES",
        "The number of lines are used in handshake mode with LCDIF.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_OPTION",
        "These bits used to choose the method to mask the CSI input.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_ENABLE",
        "CSI global enable signal.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSI module.
static const reg_t hw_csi[] =
{
    {
        "CSICR1",
        "This register controls the sensor interface timing and interrupt gener"
        "ation.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_csi_csicr1
    },
    {
        "CSICR2",
        "This register provides the statistic block with data about which live "
        "view resolution is being used, and the starting sensor pixel of the Ba"
        "yer pattern.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_csi_csicr2
    },
    {
        "CSICR3",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1, adding additional control and features.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_csi_csicr3
    },
    {
        "CSISTATFIFO",
        "The StatFIFO is a read-only register containing statistic data from th"
        "e sensor.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csistatfifo
    },
    {
        "CSIRFIFO",
        "This read-only register contains received image data.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csirfifo
    },
    {
        "CSIRXCNT",
        "This register works for EOF interrupt generation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csirxcnt
    },
    {
        "CSISR",
        "This read/write register shows sensor interface status, and which kind"
        " of interrupt is being generated.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csi_csisr
    },
    {
        "CSIDMASA_STATFIFO",
        "This register provides the start address for the embedded DMA controll"
        "er of STATFIFO.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_statfifo
    },
    {
        "CSIDMATS_STATFIFO",
        "This register provides the total transfer size for the embedded DMA co"
        "ntroller of STATFIFO.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmats_statfifo
    },
    {
        "CSIDMASA_FB1",
        "This register provides the start address in the frame buffer1 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb1
    },
    {
        "CSIDMASA_FB2",
        "This register provides the start address in the frame buffer2 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb2
    },
    {
        "CSIFBUF_PARA",
        "This register provides the stride of the frame buffer to show how many"
        " words to skip before starting to write the next row of the image.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csi_csifbuf_para
    },
    {
        "CSIIMAG_PARA",
        "This register provides the width and the height of the image from the "
        "sensor.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csi_csiimag_para
    },
    {
        "CSICR18",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_csi_csicr18
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DCP
#endif

// Bitfields in register DCP_CTRL.
static const field_t hw_dcp_ctrl[] =
{
    {
        "CHANNEL_INTERRUPT_ENABLE",
        "Per-channel interrupt enable bit.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD_CSC_INTERRUPT_ENABLE",
        "Reserved, always set to zero.",
        8, // LSB
        8, // MSB
        false, // Readable
        false // Writable
    },
    {
        "ENABLE_CONTEXT_SWITCHING",
        "Enable automatic context switching for the channels.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_CONTEXT_CACHING",
        "Software should set this bit to enable caching of contexts between ope"
        "rations.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GATHER_RESIDUAL_WRITES",
        "Software should set this bit to enable ragged writes to unaligned buff"
        "ers to be gathered between multiple write operations.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESENT_SHA",
        "Indicates whether the SHA1/SHA2 functions are present.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PRESENT_CRYPTO",
        "Indicates whether the crypto (Cipher/Hash) functions are present.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal DCP operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_STAT.
static const field_t hw_dcp_stat[] =
{
    {
        "IRQ",
        "Indicates which channels have pending interrupt requests.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD_IRQ",
        "Reserved, always set to zero.",
        8, // LSB
        8, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY_CHANNELS",
        "Indicates which channels are ready to proceed with a transfer (active "
        "channel also included).",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CUR_CHANNEL",
        "Current (active) channel (encoded).",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OTP_KEY_READY",
        "When set, indicates that the OTP key has been shifted from the fuse bl"
        "ock and is ready for use.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CHANNELCTRL.
static const field_t hw_dcp_channelctrl[] =
{
    {
        "ENABLE_CHANNEL",
        "Setting a bit in this field will enabled the DMA channel associated wi"
        "th it.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HIGH_PRIORITY_CHANNEL",
        "Setting a bit in this field causes the corresponding channel to have h"
        "igh-priority arbitration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_IRQ_MERGED",
        "Indicates that the interrupt for channel 0 should be merged with the o"
        "ther interrupts on the shared dcp_irq interrupt.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        17, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CAPABILITY0.
static const field_t hw_dcp_capability0[] =
{
    {
        "NUM_KEYS",
        "Encoded value indicating the number of key storage locations implement"
        "ed in the design.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_CHANNELS",
        "Encoded value indicating the number of channels implemented in the des"
        "ign.",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        12, // LSB
        28, // MSB
        false, // Readable
        false // Writable
    },
    {
        "DISABLE_UNIQUE_KEY",
        "Write to a 1 disable the per-device unique key.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_DECRYPT",
        "Write to a 1 to disable decryption.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CAPABILITY1.
static const field_t hw_dcp_capability1[] =
{
    {
        "CIPHER_ALGORITHMS",
        "One-hot field indicating which cipher algorithms are available.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_ALGORITHMS",
        "One-hot field indicating which hashing features are implemented in HW.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CONTEXT.
static const field_t hw_dcp_context[] =
{
    {
        "ADDR",
        "Context pointer address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_KEY.
static const field_t hw_dcp_key[] =
{
    {
        "SUBWORD",
        "Key subword pointer.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD_SUBWORD",
        "Reserved, always set to zero.",
        2, // LSB
        3, // MSB
        false, // Readable
        false // Writable
    },
    {
        "INDEX",
        "Key index pointer.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD_INDEX",
        "Reserved, always set to zero.",
        6, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        8, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_KEYDATA.
static const field_t hw_dcp_keydata[] =
{
    {
        "DATA",
        "Word 0 data for key.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET0.
static const field_t hw_dcp_packet0[] =
{
    {
        "ADDR",
        "Next Pointer Register,",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET1.
static const field_t hw_dcp_packet1[] =
{
    {
        "INTERRUPT",
        "Reflects whether the channel should issue an interrupt upon completion"
        " of the packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DECR_SEMAPHORE",
        "Reflects whether the channel's semaphore should be decremented at the "
        "end of the current operation.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "Reflects whether the next command pointer register should be loaded in"
        "to the channel's current descriptor pointer.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN_CONTIGUOUS",
        "Reflects whether the next packet's address is located following this p"
        "acket's payload.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_MEMCOPY",
        "Reflects whether the selected hashing function should be enabled for t"
        "his operation.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_CIPHER",
        "Reflects whether the selected cipher function should be enabled for th"
        "is operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_HASH",
        "Reflects whether the selected hashing function should be enabled for t"
        "his operation.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENABLE_BLIT",
        "Reflects whether the DCP should perform a blit operation.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_ENCRYPT",
        "When the cipher block is enabled, this bit indicates whether the opera"
        "tion is encryption or decryption.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_INIT",
        "Reflects whether the cipher block should load the initialization vecto"
        "r from the payload for this operation.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OTP_KEY",
        "Reflects whether a hardware-based key should be used.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PAYLOAD_KEY",
        "When set, indicates the payload contains the key.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_INIT",
        "Reflects whether the current hashing block is the initial block in the"
        " hashing operation, so the hash registers should be initialized before"
        " the operation.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_TERM",
        "Reflects whether the current hashing block is the final block in the h"
        "ashing operation, so the hash padding should be applied by hardware.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHECK_HASH",
        "Reflects whether the calculated hash value should be compared against "
        "the hash provided in the payload.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_OUTPUT",
        "When hashing is enabled, this bit controls whether the input or output"
        " data is hashed.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CONSTANT_FILL",
        "When this bit is set (MEMCOPY and BLIT modes only), the DCP will simpl"
        "y fill the destination buffer with the value found in the Source Addre"
        "ss field.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEST_SEMA_IRQ",
        "This bit is used to test the channel semaphore transition to 0.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KEY_BYTESWAP",
        "Reflects whether the DCP engine will swap key bytes (big-endian key).",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KEY_WORDSWAP",
        "Reflects whether the DCP engine will swap key words (big-endian key).",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INPUT_BYTESWAP",
        "Reflects whether the DCP engine will byteswap input data (big-endian d"
        "ata).",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INPUT_WORDSWAP",
        "Reflects whether the DCP engine will wordswap input data (big-endian d"
        "ata).",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTPUT_BYTESWAP",
        "Reflects whether the DCP engine will byteswap output data (big-endian "
        "data).",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTPUT_WORDSWAP",
        "Reflects whether the DCP engine will wordswap output data (big-endian "
        "data).",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TAG",
        "Packet Tag",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET2.
static const field_t hw_dcp_packet2[] =
{
    {
        "CIPHER_SELECT",
        "Cipher Selection Field",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CIPHER_MODE",
        "Cipher Mode Selection Field.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KEY_SELECT",
        "Key Selection Field.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HASH_SELECT",
        "Hash Selection Field",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        20, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CIPHER_CFG",
        "Cipher configuration bits.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET3.
static const field_t hw_dcp_packet3[] =
{
    {
        "ADDR",
        "Source Buffer Address Pointer.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET4.
static const field_t hw_dcp_packet4[] =
{
    {
        "ADDR",
        "Destination Buffer Address Pointer.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET5.
static const field_t hw_dcp_packet5[] =
{
    {
        "COUNT",
        "Byte Count register.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PACKET6.
static const field_t hw_dcp_packet6[] =
{
    {
        "ADDR",
        "This regiser reflects the payload pointer for the current control pack"
        "et.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0CMDPTR.
static const field_t hw_dcp_ch0cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 0.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0SEMA.
static const field_t hw_dcp_ch0sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0STAT.
static const field_t hw_dcp_ch0stat[] =
{
    {
        "RSVD_COMPLETE",
        "This bit will always read 0 in the status register, but will be set to"
        " 1 in the packet status field after processing of the packet has compl"
        "eted.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware has detected an invalid programmi"
        "ng configuration such as a buffer length that is not a multiple of the"
        " natural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a a bus error occurred when reading the packet"
        " or payload or when writing status back to the packet payload.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH0OPTS.
static const field_t hw_dcp_ch0opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        16, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1CMDPTR.
static const field_t hw_dcp_ch1cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 1.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1SEMA.
static const field_t hw_dcp_ch1sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1STAT.
static const field_t hw_dcp_ch1stat[] =
{
    {
        "RSVD_COMPLETE",
        "This bit will always read 0 in the status register, but will be set to"
        " 1 in the packet status field after processing of the packet has compl"
        "eted.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware detected an invalid programming c"
        "onfiguration such as a buffer length that is not a multiple of the nat"
        "ural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a bus error occurs when reading the packet or "
        "payload or when writing status back to the packet paylaod.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH1OPTS.
static const field_t hw_dcp_ch1opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        16, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2CMDPTR.
static const field_t hw_dcp_ch2cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 2.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2SEMA.
static const field_t hw_dcp_ch2sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2STAT.
static const field_t hw_dcp_ch2stat[] =
{
    {
        "RSVD_COMPLETE",
        "This bit will always read 0 in the status register, but will be set to"
        " 1 in the packet status field after processing of the packet has compl"
        "eted.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware detected an invalid programming c"
        "onfiguration such as a buffer length that is not a multiple of the nat"
        "ural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a bus error occurred when reading the packet o"
        "r payload or when writing status back to the packet paylaod.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH2OPTS.
static const field_t hw_dcp_ch2opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        16, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3CMDPTR.
static const field_t hw_dcp_ch3cmdptr[] =
{
    {
        "ADDR",
        "Pointer to descriptor structure to be processed for channel 3.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3SEMA.
static const field_t hw_dcp_ch3sema[] =
{
    {
        "INCREMENT",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DCP hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3STAT.
static const field_t hw_dcp_ch3stat[] =
{
    {
        "RSVD_COMPLETE",
        "This bit will always read 0 in the status register, but will be set to"
        " 1 in the packet status field after processing of the packet has compl"
        "eted.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "HASH_MISMATCH",
        "The bit indicates that a hashing check operation mismatched for contro"
        "l packets that enable the HASH_CHECK bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SETUP",
        "This bit indicates that the hardware detected an invalid programming c"
        "onfiguration such as a buffer length that is not a multiple of the nat"
        "ural data size for the operation.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PACKET",
        "This bit indicates that a bus error occurred when reading the packet o"
        "r payload or when writing status back to the packet paylaod.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_SRC",
        "This bit indicates a bus error occurred when reading from the source b"
        "uffer.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_DST",
        "This bit indicates a bus error occurred when storing to the destinatio"
        "n buffer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_PAGEFAULT",
        "This bit indicates a page fault occurred while converting a virtual ad"
        "dress to a physical address..",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_CODE",
        "Indicates additional error codes for some error conditions.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TAG",
        "Indicates the tag from the last completed packet in the command struct"
        "ure",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_CH3OPTS.
static const field_t hw_dcp_ch3opts[] =
{
    {
        "RECOVERY_TIMER",
        "This field indicates the recovery time for the channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        16, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_DBGSELECT.
static const field_t hw_dcp_dbgselect[] =
{
    {
        "INDEX",
        "Selects a value to read via the debug data register.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        8, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_DBGDATA.
static const field_t hw_dcp_dbgdata[] =
{
    {
        "DATA",
        "Debug Data",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_PAGETABLE.
static const field_t hw_dcp_pagetable[] =
{
    {
        "ENABLE",
        "Page Table Enable control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FLUSH",
        "Page Table Flush control.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASE",
        "Page Table Base Address.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCP_VERSION.
static const field_t hw_dcp_version[] =
{
    {
        "STEP",
        "Fixed read-onlyl value reflecting the stepping of version of the desig"
        "n implementation.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-onlyl value reflecting the MINOR version of the design impl"
        "ementation.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-onlyl value reflecting the MAJOR version of the design impl"
        "ementation.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DCP module.
static const reg_t hw_dcp[] =
{
    {
        "CTRL",
        "The CTRL register contains controls for the DCP module.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_dcp_ctrl
    },
    {
        "STAT",
        "The DCP Interrupt Status register provides channel interrupt status in"
        "formation.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_dcp_stat
    },
    {
        "CHANNELCTRL",
        "The DCP Channel Control register provides controls for channel arbitra"
        "tion and channel enables.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcp_channelctrl
    },
    {
        "CAPABILITY0",
        "This register contains additional information about the DCP module imp"
        "lementation parameters.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_dcp_capability0
    },
    {
        "CAPABILITY1",
        "This register contains information about the algorithms available on t"
        "he implementation.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_dcp_capability1
    },
    {
        "CONTEXT",
        "This register contains a pointer to the memory region to be used for D"
        "CP context swap operations.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_context
    },
    {
        "KEY",
        "This register contains a pointer to the key location to be written.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_dcp_key
    },
    {
        "KEYDATA",
        "This register provides write access to the key/key subword specified b"
        "y the Key Index Register.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_keydata
    },
    {
        "PACKET0",
        "This register displays the values for the current work packet offset 0"
        "x00 (Next Command) field.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet0
    },
    {
        "PACKET1",
        "This register displays the values for the current work packet offset 0"
        "x04 (control) field.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        false, // Writable
        25, // Number of bitfields
        hw_dcp_packet1
    },
    {
        "PACKET2",
        "This register displays the values for the current work packet offset 0"
        "x08 (Control1) field.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_dcp_packet2
    },
    {
        "PACKET3",
        "This register displays the values for the current work packet offset 0"
        "x0C (Source Address) field.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet3
    },
    {
        "PACKET4",
        "This register displays the values for the current work packet offset 0"
        "x10 (Destination Address) field.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet4
    },
    {
        "PACKET5",
        "This register displays the values for the current work packet offset 0"
        "x14 (Buffer Size) field.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet5
    },
    {
        "PACKET6",
        "This register displays the values for the current work packet offset 0"
        "x1C (Payload Pointer) field.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_packet6
    },
    {
        "CH0CMDPTR",
        "The DCP channel 0 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch0cmdptr
    },
    {
        "CH0SEMA",
        "The DCP Channel 0 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch0sema
    },
    {
        "CH0STAT",
        "The DCP Channel 0 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_dcp_ch0stat
    },
    {
        "CH0OPTS",
        "The DCP Channel 0 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch0opts
    },
    {
        "CH1CMDPTR",
        "The DCP channel 1 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch1cmdptr
    },
    {
        "CH1SEMA",
        "The DCP Channel 1 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch1sema
    },
    {
        "CH1STAT",
        "The DCP Channel 1 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_dcp_ch1stat
    },
    {
        "CH1OPTS",
        "The DCP Channel 1 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch1opts
    },
    {
        "CH2CMDPTR",
        "The DCP channel 2 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch2cmdptr
    },
    {
        "CH2SEMA",
        "The DCP Channel 2 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch2sema
    },
    {
        "CH2STAT",
        "The DCP Channel 2 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_dcp_ch2stat
    },
    {
        "CH2OPTS",
        "The DCP Channel 2 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch2opts
    },
    {
        "CH3CMDPTR",
        "The DCP channel 3 current command address register points to the multi"
        "word descriptor that is to be executed (or currently being executed).",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcp_ch3cmdptr
    },
    {
        "CH3SEMA",
        "The DCP Channel 3 semaphore register is used to synchronize the ARM pl"
        "atform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch3sema
    },
    {
        "CH3STAT",
        "The DCP Channel 3 Interrupt Status register contains the interrupt sta"
        "tus bit and the tag of the last completed operation from the command c"
        "hain.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_dcp_ch3stat
    },
    {
        "CH3OPTS",
        "The DCP Channel 3 Options Status register contains optional control in"
        "formation that may be used to further tune the behavior of the channel"
        ".",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_ch3opts
    },
    {
        "DBGSELECT",
        "This register selects a debug register to view.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcp_dbgselect
    },
    {
        "DBGDATA",
        "Reading this register returns the debug data value from the selected i"
        "ndex.",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcp_dbgdata
    },
    {
        "PAGETABLE",
        "The DCP Page Table register controls the virtual memory functionality "
        "of the DCP.",
        4, // Width in bytes
        0x00000420, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dcp_pagetable
    },
    {
        "VERSION",
        "Read-only register indicating implemented version of the DCP.",
        4, // Width in bytes
        0x00000430, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_dcp_version
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ECSPI
#endif

// Bitfields in register ECSPI_RXDATA.
static const field_t hw_ecspi_rxdata[] =
{
    {
        "ECSPI_RXDATA",
        "Receive Data.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TXDATA.
static const field_t hw_ecspi_txdata[] =
{
    {
        "ECSPI_TXDATA",
        "Transmit Data.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONREG.
static const field_t hw_ecspi_conreg[] =
{
    {
        "EN",
        "SPI Block Enable Control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT",
        "Hardware Trigger Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XCH",
        "SPI Exchange Bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMC",
        "Start Mode Control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_MODE",
        "SPI CHANNEL MODE selects the mode for each SPI channel.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIVIDER",
        "SPI Post Divider.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_DIVIDER",
        "SPI Pre Divider.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRCTL",
        "SPI Data Ready Control.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_SELECT",
        "SPI CHANNEL SELECT bits.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_LENGTH",
        "Burst Length.",
        20, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONFIGREG.
static const field_t hw_ecspi_configreg[] =
{
    {
        "SCLK_PHA",
        "SPI Clock/Data Phase Control.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_POL",
        "SPI Clock Polarity Control.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_CTL",
        "SPI SS Wave Form Select.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_POL",
        "SPI SS Polarity Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_CTL",
        "DATA CTL.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_CTL",
        "SCLK CTL.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT_LENGTH",
        "HT LENGTH.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_INTREG.
static const field_t hw_ecspi_intreg[] =
{
    {
        "TEEN",
        "TXFIFO Empty Interrupt enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDREN",
        "TXFIFO Data Request Interrupt enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFEN",
        "TXFIFO Full Interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RREN",
        "RXFIFO Ready Interrupt enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDREN",
        "RXFIFO Data Request Interrupt enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "RXFIFO Full Interrupt enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROEN",
        "RXFIFO Overflow Interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCEN",
        "Transfer Completed Interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_DMAREG.
static const field_t hw_ecspi_dmareg[] =
{
    {
        "TX_THRESHOLD",
        "TX THRESHOLD.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDEN",
        "TXFIFO Empty DMA Request Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_THRESHOLD",
        "RX THRESHOLD.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDEN",
        "RXFIFO DMA Request Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DMA_LENGTH",
        "RX DMA LENGTH.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXTDEN",
        "RXFIFO TAIL DMA Request Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_STATREG.
static const field_t hw_ecspi_statreg[] =
{
    {
        "TE",
        "TXFIFO Empty.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDR",
        "TXFIFO Data Request.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TF",
        "TXFIFO Full.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RR",
        "RXFIFO Ready.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDR",
        "RXFIFO Data Request.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RF",
        "RXFIFO Full.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RO",
        "RXFIFO Overflow.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TC",
        "Transfer Completed Status bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_PERIODREG.
static const field_t hw_ecspi_periodreg[] =
{
    {
        "SAMPLE_PERIOD",
        "Sample Period Control.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSRC",
        "Clock Source Control.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSD_CTL",
        "Chip Select Delay Control bits.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TESTREG.
static const field_t hw_ecspi_testreg[] =
{
    {
        "TXCNT",
        "TXFIFO Counter.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXCNT",
        "RXFIFO Counter.",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBC",
        "Loop Back Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_MSGDATA.
static const field_t hw_ecspi_msgdata[] =
{
    {
        "ECSPI_MSGDATA",
        "ECSPI_MSGDATA holds the top word of MSG Data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a ECSPI module.
static const reg_t hw_ecspi[] =
{
    {
        "RXDATA",
        "The Receive Data register (ECSPI_RXDATA) is a read-only register that "
        "forms the top word of the 64 x 32 receive FIFO.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_rxdata
    },
    {
        "TXDATA",
        "The Transmit Data (ECSPI_TXDATA) register is a write-only data registe"
        "r that forms the bottom word of the 64 x 32 TXFIFO.",
        4, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_txdata
    },
    {
        "CONREG",
        "The Control Register (ECSPI_CONREG) allows software to enable the ECSP"
        "I , configure its operating modes, specify the divider value, and SPI_"
        "RDY control signal, and define the transfer length.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ecspi_conreg
    },
    {
        "CONFIGREG",
        "The Config Register (ECSPI_CONFIGREG) allows software to configure eac"
        "h SPI channel, configure its operating modes, specify the phase and po"
        "larity of the clock, configure the Chip Select (SS), and define the HT"
        " transfer length.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ecspi_configreg
    },
    {
        "INTREG",
        "The Interrupt Control Register (ECSPI_INTREG) enables the generation o"
        "f interrupts to the host processor.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_intreg
    },
    {
        "DMAREG",
        "The Direct Memory Access Control Register (ECSPI_DMAREG) provides soft"
        "ware a way to use an on-chip DMA controller for ECSPI data.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ecspi_dmareg
    },
    {
        "STATREG",
        "The ECSPI Status Register (ECSPI_STATREG) reflects the status of the E"
        "CSPI's operating condition.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_statreg
    },
    {
        "PERIODREG",
        "The Sample Period Control Register (ECSPI_PERIODREG) provides software"
        " a way to insert delays (wait states) between consecutive SPI transfer"
        "s.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_periodreg
    },
    {
        "TESTREG",
        "The Test Control Register (ECSPI_TESTREG) provides software a mechanis"
        "m to internally connect the receive and transmit devices of the ECSPI "
        ", and monitor the contents of the receive and transmit FIFOs.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_testreg
    },
    {
        "MSGDATA",
        "The Message Data Register (ECSPI_MSGDATA) forms the top word of the 16"
        " x 32 MSG Data FIFO.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_msgdata
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EIM
#endif

// Bitfields in register EIM_CS0GCR1.
static const field_t hw_eim_cs0gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0GCR2.
static const field_t hw_eim_cs0gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR1.
static const field_t hw_eim_cs0rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR2.
static const field_t hw_eim_cs0rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR1.
static const field_t hw_eim_cs0wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR2.
static const field_t hw_eim_cs0wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR1.
static const field_t hw_eim_cs1gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR2.
static const field_t hw_eim_cs1gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR1.
static const field_t hw_eim_cs1rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR2.
static const field_t hw_eim_cs1rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR1.
static const field_t hw_eim_cs1wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR2.
static const field_t hw_eim_cs1wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR1.
static const field_t hw_eim_cs2gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR2.
static const field_t hw_eim_cs2gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR1.
static const field_t hw_eim_cs2rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR2.
static const field_t hw_eim_cs2rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR1.
static const field_t hw_eim_cs2wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR2.
static const field_t hw_eim_cs2wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR1.
static const field_t hw_eim_cs3gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR2.
static const field_t hw_eim_cs3gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR1.
static const field_t hw_eim_cs3rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR2.
static const field_t hw_eim_cs3rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR1.
static const field_t hw_eim_cs3wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR2.
static const field_t hw_eim_cs3wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR1.
static const field_t hw_eim_cs4gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR2.
static const field_t hw_eim_cs4gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR1.
static const field_t hw_eim_cs4rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR2.
static const field_t hw_eim_cs4rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR1.
static const field_t hw_eim_cs4wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR2.
static const field_t hw_eim_cs4wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR1.
static const field_t hw_eim_cs5gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR2.
static const field_t hw_eim_cs5gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR1.
static const field_t hw_eim_cs5rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR2.
static const field_t hw_eim_cs5rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR1.
static const field_t hw_eim_cs5wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR2.
static const field_t hw_eim_cs5wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WCR.
static const field_t hw_eim_wcr[] =
{
    {
        "BCM",
        "Burst Clock Mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBCD",
        "General Burst Clock Divisor.",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CONT_BCLK_SEL",
        "When this bit is set BCLK pin output continuous clock.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTEN",
        "Interrupt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTPOL",
        "Interrupt Polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_EN",
        "Memory WDOG enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_LIMIT",
        "Memory Watchdog (WDOG) cycle limit.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRUN_ACLK_EN",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EIM module.
static const reg_t hw_eim[] =
{
    {
        "CS0GCR1",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs0gcr1
    },
    {
        "CS0GCR2",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs0gcr2
    },
    {
        "CS0RCR1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs0rcr1
    },
    {
        "CS0RCR2",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs0rcr2
    },
    {
        "CS0WCR1",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs0wcr1
    },
    {
        "CS0WCR2",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs0wcr2
    },
    {
        "CS1GCR1",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs1gcr1
    },
    {
        "CS1GCR2",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs1gcr2
    },
    {
        "CS1RCR1",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs1rcr1
    },
    {
        "CS1RCR2",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs1rcr2
    },
    {
        "CS1WCR1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs1wcr1
    },
    {
        "CS1WCR2",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs1wcr2
    },
    {
        "CS2GCR1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs2gcr1
    },
    {
        "CS2GCR2",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs2gcr2
    },
    {
        "CS2RCR1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs2rcr1
    },
    {
        "CS2RCR2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs2rcr2
    },
    {
        "CS2WCR1",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs2wcr1
    },
    {
        "CS2WCR2",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs2wcr2
    },
    {
        "CS3GCR1",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs3gcr1
    },
    {
        "CS3GCR2",
        "",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs3gcr2
    },
    {
        "CS3RCR1",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs3rcr1
    },
    {
        "CS3RCR2",
        "",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs3rcr2
    },
    {
        "CS3WCR1",
        "",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs3wcr1
    },
    {
        "CS3WCR2",
        "",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs3wcr2
    },
    {
        "CS4GCR1",
        "",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs4gcr1
    },
    {
        "CS4GCR2",
        "",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs4gcr2
    },
    {
        "CS4RCR1",
        "",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs4rcr1
    },
    {
        "CS4RCR2",
        "",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs4rcr2
    },
    {
        "CS4WCR1",
        "",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs4wcr1
    },
    {
        "CS4WCR2",
        "",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs4wcr2
    },
    {
        "CS5GCR1",
        "",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs5gcr1
    },
    {
        "CS5GCR2",
        "",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs5gcr2
    },
    {
        "CS5RCR1",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs5rcr1
    },
    {
        "CS5RCR2",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs5rcr2
    },
    {
        "CS5WCR1",
        "",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs5wcr1
    },
    {
        "CS5WCR2",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs5wcr2
    },
    {
        "WCR",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_wcr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ENET
#endif

// Bitfields in register ENET_EIR.
static const field_t hw_enet_eir[] =
{
    {
        "TS_TIMER",
        "The adjustable timer reached the period event.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Indicates that the timestamp of the last transmitted timing frame is a"
        "vailable in the ATSTMP register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Read-only status bit to indicate that a magic packet has been detected"
        ".",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Indicates a frame was received with a payload length error.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Indicates the transmit FIFO became empty before the complete frame was"
        " transmitted.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Indicates a collision occurred on each of 16 successive attempts to tr"
        "ansmit the frame.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Indicates a collision occurred beyond the collision window (slot time)"
        " in half-duplex mode.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Indicates a system bus error occurred when a uDMA transaction is under"
        "way.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Indicates that the MII has completed the data transfer requested.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Indicates a receive buffer descriptor is not the last in the frame has"
        " been updated.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Indicates a frame has been received and the last corresponding buffer "
        "descriptor has been updated.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Indicates a transmit buffer descriptor has been updated.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Indicates a frame has been transmitted and the last corresponding buff"
        "er descriptor has been updated.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "This interrupt is asserted after the transmitter is put into a pause s"
        "tate after completion of the frame currently being transmitted.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Indicates the transmitted frame length exceeds RCR[MAX_FL] bytes.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Indicates a frame was received with length in excess of RCR[MAX_FL] by"
        "tes.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_EIMR.
static const field_t hw_enet_eimr[] =
{
    {
        "TS_TIMER",
        "Corresponds to interrupt source EIR[TS_TIMER] register and determines "
        "whether an interrupt condition can generate an interrupt.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Corresponds to interrupt source EIR[TS_AVAIL] register and determines "
        "whether an interrupt condition can generate an interrupt.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Corresponds to interrupt source EIR[WAKEUP] register and determines wh"
        "ether an interrupt condition can generate an interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Corresponds to interrupt source EIR[PLR] and determines whether an int"
        "errupt condition can generate an interrupt.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Corresponds to interrupt source EIR[UN] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Corresponds to interrupt source EIR[RL] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Corresponds to interrupt source EIR[LC] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Corresponds to interrupt source EIR[EBERR] and determines whether an i"
        "nterrupt condition can generate an interrupt.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Corresponds to interrupt source EIR[MII] and determines whether an int"
        "errupt condition can generate an interrupt.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Corresponds to interrupt source EIR[RXB] and determines whether an int"
        "errupt condition can generate an interrupt.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Corresponds to interrupt source EIR[RXF] and determines whether an int"
        "errupt condition can generate an interrupt.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Corresponds to interrupt source EIR[TXB] and determines whether an int"
        "errupt condition can generate an interrupt.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Corresponds to interrupt source EIR[TXF] and determines whether an int"
        "errupt condition can generate an interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "Corresponds to interrupt source EIR[GRA] and determines whether an int"
        "errupt condition can generate an interrupt.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Corresponds to interrupt source EIR[BABT] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Corresponds to interrupt source EIR[BABR] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDAR.
static const field_t hw_enet_rdar[] =
{
    {
        "RDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDAR.
static const field_t hw_enet_tdar[] =
{
    {
        "TDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ECR.
static const field_t hw_enet_ecr[] =
{
    {
        "RESET",
        "When this field is set, it clears the ETHEREN field.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETHEREN",
        "Enables/disables the Ethernet MAC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAGICEN",
        "Enables/disables magic packet detection.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLEEP",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN1588",
        "Enables enhanced functionality of the MAC.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "Enables the MAC to enter hardware freeze mode when the device enters d"
        "ebug mode.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBSWP",
        "Swaps the byte locations of the buffer descriptors.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MMFR.
static const field_t hw_enet_mmfr[] =
{
    {
        "DATA",
        "This is the field for data to be written to or read from the PHY regis"
        "ter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TA",
        "This field must be programmed to 10 to generate a valid MII management"
        " frame.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RA",
        "See (Clause 22) or (Clause 45) for correct value.",
        18, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PA",
        "See (Clause 22) or (Clause 45) for correct value.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OP",
        "See (Clause 22) or (Clause 45) for correct value.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ST",
        "See (Clause 22) or (Clause 45) for correct value.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MSCR.
static const field_t hw_enet_mscr[] =
{
    {
        "MII_SPEED",
        "Controls the frequency of the MII management interface clock (MDC) rel"
        "ative to the internal module clock.",
        1, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_PRE",
        "Enables/disables prepending a preamble to the MII management frame.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLDTIME",
        "IEEE802.3 clause 22 defines a minimum of 10 ns for the hold time on th"
        "e MDIO output.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MIBC.
static const field_t hw_enet_mibc[] =
{
    {
        "MIB_CLEAR",
        "This field is not self-clearing.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIB_IDLE",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIB_DIS",
        "If this control field is set,",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RCR.
static const field_t hw_enet_rcr[] =
{
    {
        "LOOP",
        "This is an MII internal loopback, therefore MII_MODE must be written t"
        "o 1 and RMII_MODE must be written to 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRT",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII_MODE",
        "This field must always be set.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROM",
        "All frames are accepted regardless of address matching.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC_REJ",
        "If set, frames with destination address (DA) equal to 0xFFFF_FFFF_FFFF"
        " are rejected unless the PROM field is set.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCE",
        "If set, the receiver detects PAUSE frames.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_MODE",
        "Specifies whether the MAC is configured for MII mode or RMII operation"
        " .",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_10T",
        "Enables 10-Mbit/s mode of the RMII .",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PADEN",
        "Specifies whether the MAC removes padding from received frames.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUFWD",
        "Specifies whether pause frames are terminated or forwarded.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "Specifies whether the CRC field of received frames is transmitted or s"
        "tripped.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFEN",
        "Enables/disables the MAC control frame.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAX_FL",
        "Resets to decimal 1518.",
        16, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NLC",
        "Enables/disables a payload length check.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRS",
        "Read-only status indicating that the MAC receive datapath is stopped.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCR.
static const field_t hw_enet_tcr[] =
{
    {
        "GTS",
        "When this field is set, MAC stops transmission after any frame current"
        "ly transmitted is complete and EIR[GRA] is set.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FDEN",
        "If this field is set, frames transmit independent of carrier sense and"
        " collision inputs.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFC_PAUSE",
        "Pauses frame transmission.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFC_PAUSE",
        "This status field is set when a full-duplex flow control pause frame i"
        "s received and the transmitter pauses for the duration defined in this"
        " pause frame.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ADDSEL",
        "If ADDINS is set, indicates the MAC address that overwrites the source"
        " MAC address.",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDINS",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PALR.
static const field_t hw_enet_palr[] =
{
    {
        "PADDR1",
        "Bytes 0 (bits 31:24), 1 (bits 23:16), 2 (bits 15:8), and 3 (bits 7:0) "
        "of the 6-byte individual address are used for exact match and the sour"
        "ce address field in PAUSE frames.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PAUR.
static const field_t hw_enet_paur[] =
{
    {
        "TYPE",
        "These fields have a constant value of 0x8808.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PADDR2",
        "Bytes 4 (bits 31:24) and 5 (bits 23:16) of the 6-byte individual addre"
        "ss used for exact match, and the source address field in PAUSE frames.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_OPD.
static const field_t hw_enet_opd[] =
{
    {
        "PAUSE_DUR",
        "Pause duration field used in PAUSE frames.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE",
        "These fields have a constant value of 0x0001.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TXIC.
static const field_t hw_enet_txic[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be transmitted fo"
        "r raising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RXIC.
static const field_t hw_enet_rxic[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be received for r"
        "aising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IAUR.
static const field_t hw_enet_iaur[] =
{
    {
        "IADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IALR.
static const field_t hw_enet_ialr[] =
{
    {
        "IADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GAUR.
static const field_t hw_enet_gaur[] =
{
    {
        "GADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GALR.
static const field_t hw_enet_galr[] =
{
    {
        "GADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TFWR.
static const field_t hw_enet_tfwr[] =
{
    {
        "TFWR",
        "If TFWR[STRFWD] is cleared, this field indicates the number of bytes, "
        "in steps of 64 bytes, written to the transmit FIFO before transmission"
        " of a frame begins.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STRFWD",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDSR.
static const field_t hw_enet_rdsr[] =
{
    {
        "R_DES_START",
        "Pointer to the beginning of the receive buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDSR.
static const field_t hw_enet_tdsr[] =
{
    {
        "X_DES_START",
        "Pointer to the beginning of the transmit buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MRBR.
static const field_t hw_enet_mrbr[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size in bytes.",
        4, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSFL.
static const field_t hw_enet_rsfl[] =
{
    {
        "RX_SECTION_FULL",
        "Value, in 64-bit words, of the receive FIFO section full threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSEM.
static const field_t hw_enet_rsem[] =
{
    {
        "RX_SECTION_EMPTY",
        "Value, in 64-bit words, of the receive FIFO section empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STAT_SECTION_EMPTY",
        "Defines number of frames in the receive FIFO, independent of its size,"
        " that can be accepted.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RAEM.
static const field_t hw_enet_raem[] =
{
    {
        "RX_ALMOST_EMPTY",
        "Value, in 64-bit words, of the receive FIFO almost empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RAFL.
static const field_t hw_enet_rafl[] =
{
    {
        "RX_ALMOST_FULL",
        "Value, in 64-bit words, of the receive FIFO almost full threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TSEM.
static const field_t hw_enet_tsem[] =
{
    {
        "TX_SECTION_EMPTY",
        "Value, in 64-bit words, of the transmit FIFO section empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TAEM.
static const field_t hw_enet_taem[] =
{
    {
        "TX_ALMOST_EMPTY",
        "Value, in 64-bit words, of the transmit FIFO almost empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TAFL.
static const field_t hw_enet_tafl[] =
{
    {
        "TX_ALMOST_FULL",
        "Value, in 64-bit words, of the transmit FIFO almost full threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TIPG.
static const field_t hw_enet_tipg[] =
{
    {
        "IPG",
        "Indicates the IPG, in bytes, between transmitted frames.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_FTRL.
static const field_t hw_enet_ftrl[] =
{
    {
        "TRUNC_FL",
        "Indicates the value a receive frame is truncated, if it is greater tha"
        "n this value.",
        0, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TACC.
static const field_t hw_enet_tacc[] =
{
    {
        "SHIFT16",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPCHK",
        "Enables insertion of IP header checksum.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROCHK",
        "Enables insertion of protocol checksum.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RACC.
static const field_t hw_enet_racc[] =
{
    {
        "PADREM",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPDIS",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRODIS",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINEDIS",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SHIFT16",
        "When this field is set, the actual frame data starts at bit 16 of the "
        "first word read from the RX FIFO aligning the Ethernet payload on a 32"
        "-bit boundary.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_DROP.
static const field_t hw_enet_rmon_t_drop[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_PACKETS.
static const field_t hw_enet_rmon_t_packets[] =
{
    {
        "TXPKTS",
        "Transmit packet count",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_BC_PKT.
static const field_t hw_enet_rmon_t_bc_pkt[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_MC_PKT.
static const field_t hw_enet_rmon_t_mc_pkt[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_CRC_ALIGN.
static const field_t hw_enet_rmon_t_crc_align[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_UNDERSIZE.
static const field_t hw_enet_rmon_t_undersize[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_OVERSIZE.
static const field_t hw_enet_rmon_t_oversize[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_FRAG.
static const field_t hw_enet_rmon_t_frag[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_JAB.
static const field_t hw_enet_rmon_t_jab[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_COL.
static const field_t hw_enet_rmon_t_col[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P64.
static const field_t hw_enet_rmon_t_p64[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P65TO127.
static const field_t hw_enet_rmon_t_p65to127[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P128TO255.
static const field_t hw_enet_rmon_t_p128to255[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P256TO511.
static const field_t hw_enet_rmon_t_p256to511[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P512TO1023.
static const field_t hw_enet_rmon_t_p512to1023[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P1024TO2047.
static const field_t hw_enet_rmon_t_p1024to2047[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P_GTE2048.
static const field_t hw_enet_rmon_t_p_gte2048[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_OCTETS.
static const field_t hw_enet_rmon_t_octets[] =
{
    {
        "TXOCTS",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_DROP.
static const field_t hw_enet_ieee_t_drop[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_FRAME_OK.
static const field_t hw_enet_ieee_t_frame_ok[] =
{
    {
        "COUNT",
        "Does not increment for the broadcast frames when broadcast reject is e"
        "nabled and promiscuous mode is disabled within the receive control reg"
        "ister (RCR).",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_1COL.
static const field_t hw_enet_ieee_t_1col[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_MCOL.
static const field_t hw_enet_ieee_t_mcol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_DEF.
static const field_t hw_enet_ieee_t_def[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_LCOL.
static const field_t hw_enet_ieee_t_lcol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_EXCOL.
static const field_t hw_enet_ieee_t_excol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_MACERR.
static const field_t hw_enet_ieee_t_macerr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_CSERR.
static const field_t hw_enet_ieee_t_cserr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_SQE.
static const field_t hw_enet_ieee_t_sqe[] =
{
    {
        "COUNT",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_FDXFC.
static const field_t hw_enet_ieee_t_fdxfc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_OCTETS_OK.
static const field_t hw_enet_ieee_t_octets_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_PACKETS.
static const field_t hw_enet_rmon_r_packets[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_BC_PKT.
static const field_t hw_enet_rmon_r_bc_pkt[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_MC_PKT.
static const field_t hw_enet_rmon_r_mc_pkt[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_CRC_ALIGN.
static const field_t hw_enet_rmon_r_crc_align[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_UNDERSIZE.
static const field_t hw_enet_rmon_r_undersize[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_OVERSIZE.
static const field_t hw_enet_rmon_r_oversize[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_FRAG.
static const field_t hw_enet_rmon_r_frag[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_JAB.
static const field_t hw_enet_rmon_r_jab[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_RESVD_0.
static const field_t hw_enet_rmon_r_resvd_0[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P64.
static const field_t hw_enet_rmon_r_p64[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P65TO127.
static const field_t hw_enet_rmon_r_p65to127[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P128TO255.
static const field_t hw_enet_rmon_r_p128to255[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P256TO511.
static const field_t hw_enet_rmon_r_p256to511[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P512TO1023.
static const field_t hw_enet_rmon_r_p512to1023[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P1024TO2047.
static const field_t hw_enet_rmon_r_p1024to2047[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P_GTE2048.
static const field_t hw_enet_rmon_r_p_gte2048[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_OCTETS.
static const field_t hw_enet_rmon_r_octets[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_DROP.
static const field_t hw_enet_ieee_r_drop[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_FRAME_OK.
static const field_t hw_enet_ieee_r_frame_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_CRC.
static const field_t hw_enet_ieee_r_crc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_ALIGN.
static const field_t hw_enet_ieee_r_align[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_MACERR.
static const field_t hw_enet_ieee_r_macerr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_FDXFC.
static const field_t hw_enet_ieee_r_fdxfc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_OCTETS_OK.
static const field_t hw_enet_ieee_r_octets_ok[] =
{
    {
        "COUNT",
        "Counts total octets (includes header and FCS fields).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCR.
static const field_t hw_enet_atcr[] =
{
    {
        "EN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFEN",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFRST",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PEREN",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPER",
        "Enables event signal output assertion on period event.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESTART",
        "Resets the timer to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAPTURE",
        "When this field is set, all other fields are ignored during a write.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLAVE",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATVR.
static const field_t hw_enet_atvr[] =
{
    {
        "ATIME",
        "A write sets the timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATOFF.
static const field_t hw_enet_atoff[] =
{
    {
        "OFFSET",
        "Offset value for one-shot event generation.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATPER.
static const field_t hw_enet_atper[] =
{
    {
        "PERIOD",
        "Value for generating periodic events.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCOR.
static const field_t hw_enet_atcor[] =
{
    {
        "COR",
        "Defines after how many timer clock cycles (ts_clk) the correction coun"
        "ter should be reset and trigger a correction increment on the timer.",
        0, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATINC.
static const field_t hw_enet_atinc[] =
{
    {
        "INC",
        "The timer increments by this amount each clock cycle.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_CORR",
        "This value is added every time the correction timer expires (every clo"
        "ck cycle given in ATCOR).",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATSTMP.
static const field_t hw_enet_atstmp[] =
{
    {
        "TIMESTAMP",
        "Timestamp of the last frame transmitted by the core that had TxBD[TS] "
        "set .",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TGSR.
static const field_t hw_enet_tgsr[] =
{
    {
        "TF0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR0.
static const field_t hw_enet_tcsr0[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR0.
static const field_t hw_enet_tccr0[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR1.
static const field_t hw_enet_tcsr1[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR1.
static const field_t hw_enet_tccr1[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR2.
static const field_t hw_enet_tcsr2[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR2.
static const field_t hw_enet_tccr2[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR3.
static const field_t hw_enet_tcsr3[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR3.
static const field_t hw_enet_tccr3[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ENET module.
static const reg_t hw_enet[] =
{
    {
        "EIR",
        "When an event occurs that sets a bit in EIR, an interrupt occurs if th"
        "e corresponding bit in the interrupt mask register (EIMR) is also set.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_eir
    },
    {
        "EIMR",
        "EIMR controls which interrupt events are allowed to generate actual in"
        "terrupts.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_eimr
    },
    {
        "RDAR",
        "RDAR is a command register, written by the user, to indicate that the "
        "receive descriptor ring has been updated, that is, that the driver pro"
        "duced empty receive buffers with the empty bit set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdar
    },
    {
        "TDAR",
        "The TDAR is a command register that the user writes to indicate that t"
        "he transmit descriptor ring has been updated, that is, that transmit b"
        "uffers have been produced by the driver with the ready bit set in the "
        "buffer descriptor.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdar
    },
    {
        "ECR",
        "ECR is a read/write user register, though hardware may also alter fiel"
        "ds in this register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_ecr
    },
    {
        "MMFR",
        "Writing to MMFR triggers a management frame transaction to the PHY dev"
        "ice unless MSCR is programmed to zero.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_enet_mmfr
    },
    {
        "MSCR",
        "MSCR provides control of the MII clock (MDC pin) frequency and allows "
        "a preamble drop on the MII management frame.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mscr
    },
    {
        "MIBC",
        "MIBC is a read/write register controlling and observing the state of t"
        "he MIB block.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mibc
    },
    {
        "RCR",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_enet_rcr
    },
    {
        "TCR",
        "TCR is read/write and configures the transmit block.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_tcr
    },
    {
        "PALR",
        "PALR contains the lower 32 bits (bytes 0, 1, 2, 3) of the 48-bit addre"
        "ss used in the address recognition process to compare with the destina"
        "tion address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_palr
    },
    {
        "PAUR",
        "PAUR contains the upper 16 bits (bytes 4 and 5) of the 48-bit address "
        "used in the address recognition process to compare with the destinatio"
        "n address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_paur
    },
    {
        "OPD",
        "OPD is read/write accessible.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_opd
    },
    {
        "TXIC",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_txic
    },
    {
        "RXIC",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_rxic
    },
    {
        "IAUR",
        "IAUR contains the upper 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_iaur
    },
    {
        "IALR",
        "IALR contains the lower 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ialr
    },
    {
        "GAUR",
        "GAUR contains the upper 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_gaur
    },
    {
        "GALR",
        "GALR contains the lower 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_galr
    },
    {
        "TFWR",
        "If TFWR[STRFWD] is cleared, TFWR[TFWR] controls the amount of data req"
        "uired in the transmit FIFO before transmission of a frame can begin.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_tfwr
    },
    {
        "RDSR",
        "RDSR points to the beginning of the circular receive buffer descriptor"
        " queue in external memory.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdsr
    },
    {
        "TDSR",
        "TDSR provides a pointer to the beginning of the circular transmit buff"
        "er descriptor queue in external memory.",
        4, // Width in bytes
        0x00000184, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdsr
    },
    {
        "MRBR",
        "The MRBR is a user-programmable register that dictates the maximum siz"
        "e of all receive buffers.",
        4, // Width in bytes
        0x00000188, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_mrbr
    },
    {
        "RSFL",
        "",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rsfl
    },
    {
        "RSEM",
        "",
        4, // Width in bytes
        0x00000194, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_rsem
    },
    {
        "RAEM",
        "",
        4, // Width in bytes
        0x00000198, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_raem
    },
    {
        "RAFL",
        "",
        4, // Width in bytes
        0x0000019c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rafl
    },
    {
        "TSEM",
        "",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tsem
    },
    {
        "TAEM",
        "",
        4, // Width in bytes
        0x000001a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_taem
    },
    {
        "TAFL",
        "",
        4, // Width in bytes
        0x000001a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tafl
    },
    {
        "TIPG",
        "",
        4, // Width in bytes
        0x000001ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tipg
    },
    {
        "FTRL",
        "",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ftrl
    },
    {
        "TACC",
        "TACC controls accelerator actions when sending frames.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_tacc
    },
    {
        "RACC",
        "",
        4, // Width in bytes
        0x000001c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_racc
    },
    {
        "RMON_T_DROP",
        "",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_enet_rmon_t_drop
    },
    {
        "RMON_T_PACKETS",
        "",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_packets
    },
    {
        "RMON_T_BC_PKT",
        "RMON Tx Broadcast Packets",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_bc_pkt
    },
    {
        "RMON_T_MC_PKT",
        "",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_mc_pkt
    },
    {
        "RMON_T_CRC_ALIGN",
        "",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_crc_align
    },
    {
        "RMON_T_UNDERSIZE",
        "",
        4, // Width in bytes
        0x00000214, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_undersize
    },
    {
        "RMON_T_OVERSIZE",
        "",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_oversize
    },
    {
        "RMON_T_FRAG",
        ".",
        4, // Width in bytes
        0x0000021c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_frag
    },
    {
        "RMON_T_JAB",
        "",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_jab
    },
    {
        "RMON_T_COL",
        "",
        4, // Width in bytes
        0x00000224, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_col
    },
    {
        "RMON_T_P64",
        ".",
        4, // Width in bytes
        0x00000228, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p64
    },
    {
        "RMON_T_P65TO127",
        "",
        4, // Width in bytes
        0x0000022c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p65to127
    },
    {
        "RMON_T_P128TO255",
        "",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p128to255
    },
    {
        "RMON_T_P256TO511",
        "",
        4, // Width in bytes
        0x00000234, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p256to511
    },
    {
        "RMON_T_P512TO1023",
        ".",
        4, // Width in bytes
        0x00000238, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p512to1023
    },
    {
        "RMON_T_P1024TO2047",
        "",
        4, // Width in bytes
        0x0000023c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p1024to2047
    },
    {
        "RMON_T_P_GTE2048",
        "",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p_gte2048
    },
    {
        "RMON_T_OCTETS",
        "",
        4, // Width in bytes
        0x00000244, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_octets
    },
    {
        "IEEE_T_DROP",
        "",
        4, // Width in bytes
        0x00000248, // Base address offset
        true, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_enet_ieee_t_drop
    },
    {
        "IEEE_T_FRAME_OK",
        "",
        4, // Width in bytes
        0x0000024c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_frame_ok
    },
    {
        "IEEE_T_1COL",
        "",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_1col
    },
    {
        "IEEE_T_MCOL",
        "",
        4, // Width in bytes
        0x00000254, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_mcol
    },
    {
        "IEEE_T_DEF",
        "",
        4, // Width in bytes
        0x00000258, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_def
    },
    {
        "IEEE_T_LCOL",
        "",
        4, // Width in bytes
        0x0000025c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_lcol
    },
    {
        "IEEE_T_EXCOL",
        "",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_excol
    },
    {
        "IEEE_T_MACERR",
        "",
        4, // Width in bytes
        0x00000264, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_macerr
    },
    {
        "IEEE_T_CSERR",
        "",
        4, // Width in bytes
        0x00000268, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_cserr
    },
    {
        "IEEE_T_SQE",
        "",
        4, // Width in bytes
        0x0000026c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_sqe
    },
    {
        "IEEE_T_FDXFC",
        "",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_fdxfc
    },
    {
        "IEEE_T_OCTETS_OK",
        "",
        4, // Width in bytes
        0x00000274, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_octets_ok
    },
    {
        "RMON_R_PACKETS",
        "",
        4, // Width in bytes
        0x00000284, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_packets
    },
    {
        "RMON_R_BC_PKT",
        "",
        4, // Width in bytes
        0x00000288, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_bc_pkt
    },
    {
        "RMON_R_MC_PKT",
        "",
        4, // Width in bytes
        0x0000028c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_mc_pkt
    },
    {
        "RMON_R_CRC_ALIGN",
        "",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_crc_align
    },
    {
        "RMON_R_UNDERSIZE",
        "",
        4, // Width in bytes
        0x00000294, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_undersize
    },
    {
        "RMON_R_OVERSIZE",
        "",
        4, // Width in bytes
        0x00000298, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_oversize
    },
    {
        "RMON_R_FRAG",
        "",
        4, // Width in bytes
        0x0000029c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_frag
    },
    {
        "RMON_R_JAB",
        "",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_jab
    },
    {
        "RMON_R_RESVD_0",
        "",
        4, // Width in bytes
        0x000002a4, // Base address offset
        false, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_enet_rmon_r_resvd_0
    },
    {
        "RMON_R_P64",
        "",
        4, // Width in bytes
        0x000002a8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p64
    },
    {
        "RMON_R_P65TO127",
        "",
        4, // Width in bytes
        0x000002ac, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p65to127
    },
    {
        "RMON_R_P128TO255",
        "",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p128to255
    },
    {
        "RMON_R_P256TO511",
        "",
        4, // Width in bytes
        0x000002b4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p256to511
    },
    {
        "RMON_R_P512TO1023",
        "",
        4, // Width in bytes
        0x000002b8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p512to1023
    },
    {
        "RMON_R_P1024TO2047",
        "",
        4, // Width in bytes
        0x000002bc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p1024to2047
    },
    {
        "RMON_R_P_GTE2048",
        "",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p_gte2048
    },
    {
        "RMON_R_OCTETS",
        "",
        4, // Width in bytes
        0x000002c4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_octets
    },
    {
        "IEEE_R_DROP",
        "Counter increments if a frame with invalid or missing SFD character is"
        " detected and has been dropped.",
        4, // Width in bytes
        0x000002c8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_drop
    },
    {
        "IEEE_R_FRAME_OK",
        "",
        4, // Width in bytes
        0x000002cc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_frame_ok
    },
    {
        "IEEE_R_CRC",
        "",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_crc
    },
    {
        "IEEE_R_ALIGN",
        "",
        4, // Width in bytes
        0x000002d4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_align
    },
    {
        "IEEE_R_MACERR",
        "",
        4, // Width in bytes
        0x000002d8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_macerr
    },
    {
        "IEEE_R_FDXFC",
        "",
        4, // Width in bytes
        0x000002dc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_fdxfc
    },
    {
        "IEEE_R_OCTETS_OK",
        "",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_octets_ok
    },
    {
        "ATCR",
        "ATCR command fields can trigger the corresponding events directly.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_enet_atcr
    },
    {
        "ATVR",
        "",
        4, // Width in bytes
        0x00000404, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atvr
    },
    {
        "ATOFF",
        "",
        4, // Width in bytes
        0x00000408, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atoff
    },
    {
        "ATPER",
        "",
        4, // Width in bytes
        0x0000040c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atper
    },
    {
        "ATCOR",
        "",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atcor
    },
    {
        "ATINC",
        "",
        4, // Width in bytes
        0x00000414, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_atinc
    },
    {
        "ATSTMP",
        "",
        4, // Width in bytes
        0x00000418, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_atstmp
    },
    {
        "TGSR",
        "",
        4, // Width in bytes
        0x00000604, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tgsr
    },
    {
        "TCSR0",
        "",
        4, // Width in bytes
        0x00000608, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr0
    },
    {
        "TCCR0",
        "",
        4, // Width in bytes
        0x0000060c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr0
    },
    {
        "TCSR1",
        "",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr1
    },
    {
        "TCCR1",
        "",
        4, // Width in bytes
        0x00000614, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr1
    },
    {
        "TCSR2",
        "",
        4, // Width in bytes
        0x00000618, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr2
    },
    {
        "TCCR2",
        "",
        4, // Width in bytes
        0x0000061c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr2
    },
    {
        "TCSR3",
        "",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr3
    },
    {
        "TCCR3",
        "",
        4, // Width in bytes
        0x00000624, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EPDC
#endif

// Bitfields in register EPDC_CTRL.
static const field_t hw_epdc_ctrl[] =
{
    {
        "LUT_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the LUT data before store to LUTRA"
        "M.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the UPD data before the WB constru"
        "ction.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal EPDC operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_CTRL_SET.
static const field_t hw_epdc_ctrl_set[] =
{
    {
        "LUT_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the LUT data before store to LUTRA"
        "M.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the UPD data before the WB constru"
        "ction.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal EPDC operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_CTRL_CLR.
static const field_t hw_epdc_ctrl_clr[] =
{
    {
        "LUT_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the LUT data before store to LUTRA"
        "M.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the UPD data before the WB constru"
        "ction.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal EPDC operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_CTRL_TOG.
static const field_t hw_epdc_ctrl_tog[] =
{
    {
        "LUT_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the LUT data before store to LUTRA"
        "M.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DATA_SWIZZLE",
        "Specifies how to swap the bytes for the UPD data before the WB constru"
        "ction.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal EPDC operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_ADDR_TCE.
static const field_t hw_epdc_wb_addr_tce[] =
{
    {
        "ADDR",
        "Address for EPDC working buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WVADDR.
static const field_t hw_epdc_wvaddr[] =
{
    {
        "ADDR",
        "Start address of waveform tables.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_ADDR.
static const field_t hw_epdc_wb_addr[] =
{
    {
        "ADDR",
        "Address for EPDC working buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_RES.
static const field_t hw_epdc_res[] =
{
    {
        "HORIZONTAL",
        "Horizontal Resolution (in pixels)",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VERTICAL",
        "Vertical Resoltion (in pixels)",
        16, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FORMAT.
static const field_t hw_epdc_format[] =
{
    {
        "TFT_PIXEL_FORMAT",
        "EPDC TFT Pixel Format.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_FORMAT",
        "EPDC Input Buffer Pixel format.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_COMPRESS",
        "whether the working buffer is compressed, only avilable on WB_FORMAT=E"
        "XTERNAL16/32 mode",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_TYPE",
        "",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_ADDR_NO_COPY",
        "1 means do not automatically copy WB_ADDR to WB_ADDR_TCE before starti"
        "ng every frame",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEFAULT_TFT_PIXEL",
        "Default TFT pixel value.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_SCALE",
        "Selects method of conversion from 8-bit input",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FORMAT_SET.
static const field_t hw_epdc_format_set[] =
{
    {
        "TFT_PIXEL_FORMAT",
        "EPDC TFT Pixel Format.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_FORMAT",
        "EPDC Input Buffer Pixel format.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_COMPRESS",
        "whether the working buffer is compressed, only avilable on WB_FORMAT=E"
        "XTERNAL16/32 mode",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_TYPE",
        "",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_ADDR_NO_COPY",
        "1 means do not automatically copy WB_ADDR to WB_ADDR_TCE before starti"
        "ng every frame",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEFAULT_TFT_PIXEL",
        "Default TFT pixel value.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_SCALE",
        "Selects method of conversion from 8-bit input",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FORMAT_CLR.
static const field_t hw_epdc_format_clr[] =
{
    {
        "TFT_PIXEL_FORMAT",
        "EPDC TFT Pixel Format.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_FORMAT",
        "EPDC Input Buffer Pixel format.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_COMPRESS",
        "whether the working buffer is compressed, only avilable on WB_FORMAT=E"
        "XTERNAL16/32 mode",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_TYPE",
        "",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_ADDR_NO_COPY",
        "1 means do not automatically copy WB_ADDR to WB_ADDR_TCE before starti"
        "ng every frame",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEFAULT_TFT_PIXEL",
        "Default TFT pixel value.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_SCALE",
        "Selects method of conversion from 8-bit input",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FORMAT_TOG.
static const field_t hw_epdc_format_tog[] =
{
    {
        "TFT_PIXEL_FORMAT",
        "EPDC TFT Pixel Format.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_FORMAT",
        "EPDC Input Buffer Pixel format.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_COMPRESS",
        "whether the working buffer is compressed, only avilable on WB_FORMAT=E"
        "XTERNAL16/32 mode",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_TYPE",
        "",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_ADDR_NO_COPY",
        "1 means do not automatically copy WB_ADDR to WB_ADDR_TCE before starti"
        "ng every frame",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEFAULT_TFT_PIXEL",
        "Default TFT pixel value.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF_PIXEL_SCALE",
        "Selects method of conversion from 8-bit input",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_FIELD0.
static const field_t hw_epdc_wb_field0[] =
{
    {
        "LEN",
        "Field length minus 1 (0x0 means length=1, 0xf means length=16)",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TO",
        "Target Field's LSB",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FROM",
        "Source Field's LSB",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USAGE",
        "",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "usage of the FIXED value",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXED",
        "used to either force field into a fixed value, or compare to wb field "
        "to mask off the pixel",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_FIELD1.
static const field_t hw_epdc_wb_field1[] =
{
    {
        "LEN",
        "Field length minus 1 (0x0 means length=1, 0xf means length=16)",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TO",
        "Target Field's LSB",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FROM",
        "Source Field's LSB",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USAGE",
        "",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "usage of the FIXED value",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXED",
        "used to either force field into a fixed value, or compare to wb field "
        "to mask off the pixel",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_FIELD2.
static const field_t hw_epdc_wb_field2[] =
{
    {
        "LEN",
        "Field length minus 1 (0x0 means length=1, 0xf means length=16)",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TO",
        "Target Field's LSB",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FROM",
        "Source Field's LSB",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USAGE",
        "",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "usage of the FIXED value",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXED",
        "used to either force field into a fixed value, or compare to wb field "
        "to mask off the pixel",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_WB_FIELD3.
static const field_t hw_epdc_wb_field3[] =
{
    {
        "LEN",
        "Field length minus 1 (0x0 means length=1, 0xf means length=16)",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TO",
        "Target Field's LSB",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FROM",
        "Source Field's LSB",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USAGE",
        "",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "usage of the FIXED value",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXED",
        "used to either force field into a fixed value, or compare to wb field "
        "to mask off the pixel",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FIFOCTRL.
static const field_t hw_epdc_fifoctrl[] =
{
    {
        "FIFO_L_LEVEL",
        "Lower level value of FIFO watermark.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_H_LEVEL",
        "Upper level value of FIFO watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_INIT_LEVEL",
        "This register sets the watermark for the pixel-fifo.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PRIORITY",
        "Enable watermark-based priority elevation mechanism.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FIFOCTRL_SET.
static const field_t hw_epdc_fifoctrl_set[] =
{
    {
        "FIFO_L_LEVEL",
        "Lower level value of FIFO watermark.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_H_LEVEL",
        "Upper level value of FIFO watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_INIT_LEVEL",
        "This register sets the watermark for the pixel-fifo.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PRIORITY",
        "Enable watermark-based priority elevation mechanism.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FIFOCTRL_CLR.
static const field_t hw_epdc_fifoctrl_clr[] =
{
    {
        "FIFO_L_LEVEL",
        "Lower level value of FIFO watermark.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_H_LEVEL",
        "Upper level value of FIFO watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_INIT_LEVEL",
        "This register sets the watermark for the pixel-fifo.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PRIORITY",
        "Enable watermark-based priority elevation mechanism.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_FIFOCTRL_TOG.
static const field_t hw_epdc_fifoctrl_tog[] =
{
    {
        "FIFO_L_LEVEL",
        "Lower level value of FIFO watermark.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_H_LEVEL",
        "Upper level value of FIFO watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_INIT_LEVEL",
        "This register sets the watermark for the pixel-fifo.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_PRIORITY",
        "Enable watermark-based priority elevation mechanism.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_ADDR.
static const field_t hw_epdc_upd_addr[] =
{
    {
        "ADDR",
        "Address for incoming region update.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_STRIDE.
static const field_t hw_epdc_upd_stride[] =
{
    {
        "STRIDE",
        "line stride for incoming region update",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CORD.
static const field_t hw_epdc_upd_cord[] =
{
    {
        "XCORD",
        "X co-ordinate for incoming region update",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YCORD",
        "Y co-ordinate for incoming region update",
        16, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_SIZE.
static const field_t hw_epdc_upd_size[] =
{
    {
        "WIDTH",
        "Width (in pixels)",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HEIGHT",
        "Height (in pixels)",
        16, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CTRL.
static const field_t hw_epdc_upd_ctrl[] =
{
    {
        "UPDATE_MODE",
        "Update Mode",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRY_RUN",
        "Enable Dry Run mode(set to 1).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTOWV",
        "enable automatical waveform mode selection",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NO_LUT_CANCEL",
        "EPDC will cancel LUT loading for void update (no real update needed be"
        "cause of partial or collision), set this bit to 1 to disable this feat"
        "ure",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STANDBY",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAVEFORM_MODE",
        "Waveform Mode 0-255",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_SEL",
        "LUT select 0-63",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "Use fixed pixel values (requires programming of EPDC_UPD_FIXED)",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CTRL_SET.
static const field_t hw_epdc_upd_ctrl_set[] =
{
    {
        "UPDATE_MODE",
        "Update Mode",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRY_RUN",
        "Enable Dry Run mode(set to 1).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTOWV",
        "enable automatical waveform mode selection",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NO_LUT_CANCEL",
        "EPDC will cancel LUT loading for void update (no real update needed be"
        "cause of partial or collision), set this bit to 1 to disable this feat"
        "ure",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STANDBY",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAVEFORM_MODE",
        "Waveform Mode 0-255",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_SEL",
        "LUT select 0-63",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "Use fixed pixel values (requires programming of EPDC_UPD_FIXED)",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CTRL_CLR.
static const field_t hw_epdc_upd_ctrl_clr[] =
{
    {
        "UPDATE_MODE",
        "Update Mode",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRY_RUN",
        "Enable Dry Run mode(set to 1).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTOWV",
        "enable automatical waveform mode selection",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NO_LUT_CANCEL",
        "EPDC will cancel LUT loading for void update (no real update needed be"
        "cause of partial or collision), set this bit to 1 to disable this feat"
        "ure",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STANDBY",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAVEFORM_MODE",
        "Waveform Mode 0-255",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_SEL",
        "LUT select 0-63",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "Use fixed pixel values (requires programming of EPDC_UPD_FIXED)",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_CTRL_TOG.
static const field_t hw_epdc_upd_ctrl_tog[] =
{
    {
        "UPDATE_MODE",
        "Update Mode",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRY_RUN",
        "Enable Dry Run mode(set to 1).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTOWV",
        "enable automatical waveform mode selection",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NO_LUT_CANCEL",
        "EPDC will cancel LUT loading for void update (no real update needed be"
        "cause of partial or collision), set this bit to 1 to disable this feat"
        "ure",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STANDBY",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAVEFORM_MODE",
        "Waveform Mode 0-255",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_SEL",
        "LUT select 0-63",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USE_FIXED",
        "Use fixed pixel values (requires programming of EPDC_UPD_FIXED)",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_FIXED.
static const field_t hw_epdc_upd_fixed[] =
{
    {
        "FIXCP",
        "CP value if fixecp_en is set to 1.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP",
        "NP value if fixenp_en is set to 1.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXCP_EN",
        "If set to 1, current updated region has the CP value defined by FIXCP",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP_EN",
        "If set to 1, current updated region has the NP value defined by FIXNP",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_FIXED_SET.
static const field_t hw_epdc_upd_fixed_set[] =
{
    {
        "FIXCP",
        "CP value if fixecp_en is set to 1.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP",
        "NP value if fixenp_en is set to 1.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXCP_EN",
        "If set to 1, current updated region has the CP value defined by FIXCP",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP_EN",
        "If set to 1, current updated region has the NP value defined by FIXNP",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_FIXED_CLR.
static const field_t hw_epdc_upd_fixed_clr[] =
{
    {
        "FIXCP",
        "CP value if fixecp_en is set to 1.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP",
        "NP value if fixenp_en is set to 1.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXCP_EN",
        "If set to 1, current updated region has the CP value defined by FIXCP",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP_EN",
        "If set to 1, current updated region has the NP value defined by FIXNP",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_FIXED_TOG.
static const field_t hw_epdc_upd_fixed_tog[] =
{
    {
        "FIXCP",
        "CP value if fixecp_en is set to 1.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP",
        "NP value if fixenp_en is set to 1.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXCP_EN",
        "If set to 1, current updated region has the CP value defined by FIXCP",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIXNP_EN",
        "If set to 1, current updated region has the NP value defined by FIXNP",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TEMP.
static const field_t hw_epdc_temp[] =
{
    {
        "TEMPERATURE",
        "Temperature Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_AUTOWV_LUT.
static const field_t hw_epdc_autowv_lut[] =
{
    {
        "ADDR",
        "ADDR",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA",
        "DATA",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY1.
static const field_t hw_epdc_lut_standby1[] =
{
    {
        "LUTN",
        "LUT 0~31 standby control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY1_SET.
static const field_t hw_epdc_lut_standby1_set[] =
{
    {
        "LUTN",
        "LUT 0~31 standby control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY1_CLR.
static const field_t hw_epdc_lut_standby1_clr[] =
{
    {
        "LUTN",
        "LUT 0~31 standby control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY1_TOG.
static const field_t hw_epdc_lut_standby1_tog[] =
{
    {
        "LUTN",
        "LUT 0~31 standby control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY2.
static const field_t hw_epdc_lut_standby2[] =
{
    {
        "LUTN",
        "LUT 32~64 Standby Control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY2_SET.
static const field_t hw_epdc_lut_standby2_set[] =
{
    {
        "LUTN",
        "LUT 32~64 Standby Control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY2_CLR.
static const field_t hw_epdc_lut_standby2_clr[] =
{
    {
        "LUTN",
        "LUT 32~64 Standby Control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_LUT_STANDBY2_TOG.
static const field_t hw_epdc_lut_standby2_tog[] =
{
    {
        "LUTN",
        "LUT 32~64 Standby Control",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_CTRL.
static const field_t hw_epdc_tce_ctrl[] =
{
    {
        "PIXELS_PER_SDCLK",
        "Number of TFT pixels per SDCLK period.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_WIDTH",
        "Selects either 8 or 16 bit SDDO bus format",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_0",
        "Determines scan direction for each half of the TFT panel",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_1",
        "Determines scan direction for each half of the TFT panel",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE",
        "If set, the upper 8-bit of the SDDO bus are used for LVDS differential"
        " signalling.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE_CE",
        "If set (together with LVDS_MODE=1), SDCE[9:5] shall be driven as the d"
        "ifferential inverse of SDCE[4:0].",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_MODE",
        "If set, SDDO data is driven on both positive and negative edges of SDC"
        "LK.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_MODE",
        "This field determines the method used to drive the VCOM signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_VAL",
        "When VCOM_MODE = MANUAL, this value is used to manually set the VCOM v"
        "alue for the VCOM[1:0] pins",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSCAN_HOLDOFF",
        "This period (expressed in vertical lines), sets the portion of the ver"
        "tical blanking available for new LUTs to be activated.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_CTRL_SET.
static const field_t hw_epdc_tce_ctrl_set[] =
{
    {
        "PIXELS_PER_SDCLK",
        "Number of TFT pixels per SDCLK period.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_WIDTH",
        "Selects either 8 or 16 bit SDDO bus format",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_0",
        "Determines scan direction for each half of the TFT panel",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_1",
        "Determines scan direction for each half of the TFT panel",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE",
        "If set, the upper 8-bit of the SDDO bus are used for LVDS differential"
        " signalling.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE_CE",
        "If set (together with LVDS_MODE=1), SDCE[9:5] shall be driven as the d"
        "ifferential inverse of SDCE[4:0].",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_MODE",
        "If set, SDDO data is driven on both positive and negative edges of SDC"
        "LK.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_MODE",
        "This field determines the method used to drive the VCOM signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_VAL",
        "When VCOM_MODE = MANUAL, this value is used to manually set the VCOM v"
        "alue for the VCOM[1:0] pins",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSCAN_HOLDOFF",
        "This period (expressed in vertical lines), sets the portion of the ver"
        "tical blanking available for new LUTs to be activated.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_CTRL_CLR.
static const field_t hw_epdc_tce_ctrl_clr[] =
{
    {
        "PIXELS_PER_SDCLK",
        "Number of TFT pixels per SDCLK period.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_WIDTH",
        "Selects either 8 or 16 bit SDDO bus format",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_0",
        "Determines scan direction for each half of the TFT panel",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_1",
        "Determines scan direction for each half of the TFT panel",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE",
        "If set, the upper 8-bit of the SDDO bus are used for LVDS differential"
        " signalling.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE_CE",
        "If set (together with LVDS_MODE=1), SDCE[9:5] shall be driven as the d"
        "ifferential inverse of SDCE[4:0].",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_MODE",
        "If set, SDDO data is driven on both positive and negative edges of SDC"
        "LK.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_MODE",
        "This field determines the method used to drive the VCOM signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_VAL",
        "When VCOM_MODE = MANUAL, this value is used to manually set the VCOM v"
        "alue for the VCOM[1:0] pins",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSCAN_HOLDOFF",
        "This period (expressed in vertical lines), sets the portion of the ver"
        "tical blanking available for new LUTs to be activated.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_CTRL_TOG.
static const field_t hw_epdc_tce_ctrl_tog[] =
{
    {
        "PIXELS_PER_SDCLK",
        "Number of TFT pixels per SDCLK period.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_WIDTH",
        "Selects either 8 or 16 bit SDDO bus format",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_0",
        "Determines scan direction for each half of the TFT panel",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCAN_DIR_1",
        "Determines scan direction for each half of the TFT panel",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE",
        "If set, the upper 8-bit of the SDDO bus are used for LVDS differential"
        " signalling.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_MODE_CE",
        "If set (together with LVDS_MODE=1), SDCE[9:5] shall be driven as the d"
        "ifferential inverse of SDCE[4:0].",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DDR_MODE",
        "If set, SDDO data is driven on both positive and negative edges of SDC"
        "LK.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_MODE",
        "This field determines the method used to drive the VCOM signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCOM_VAL",
        "When VCOM_MODE = MANUAL, this value is used to manually set the VCOM v"
        "alue for the VCOM[1:0] pins",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSCAN_HOLDOFF",
        "This period (expressed in vertical lines), sets the portion of the ver"
        "tical blanking available for new LUTs to be activated.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_SDCFG.
static const field_t hw_epdc_tce_sdcfg[] =
{
    {
        "PIXELS_PER_CE",
        "Number of pixels (outputs) per source-driver IC.",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_INVERT",
        "Setting this bit to 1 reverses the polarity of each SDDO bit so 0xAAAA"
        " in 16-bit mode for example becomes 0x5555.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_REFORMAT",
        "This register defines the various re-formatting options to enable more"
        " flexibility in the source-driver interface:",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUM_CE",
        "Number of source driver IC chip-enables.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDSHR",
        "Value for source-driver shift direction output port",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_HOLD",
        "Setting this bit to 1 holds the SDCLK low during LINE_BEGIN",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_SDCFG_SET.
static const field_t hw_epdc_tce_sdcfg_set[] =
{
    {
        "PIXELS_PER_CE",
        "Number of pixels (outputs) per source-driver IC.",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_INVERT",
        "Setting this bit to 1 reverses the polarity of each SDDO bit so 0xAAAA"
        " in 16-bit mode for example becomes 0x5555.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_REFORMAT",
        "This register defines the various re-formatting options to enable more"
        " flexibility in the source-driver interface:",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUM_CE",
        "Number of source driver IC chip-enables.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDSHR",
        "Value for source-driver shift direction output port",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_HOLD",
        "Setting this bit to 1 holds the SDCLK low during LINE_BEGIN",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_SDCFG_CLR.
static const field_t hw_epdc_tce_sdcfg_clr[] =
{
    {
        "PIXELS_PER_CE",
        "Number of pixels (outputs) per source-driver IC.",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_INVERT",
        "Setting this bit to 1 reverses the polarity of each SDDO bit so 0xAAAA"
        " in 16-bit mode for example becomes 0x5555.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_REFORMAT",
        "This register defines the various re-formatting options to enable more"
        " flexibility in the source-driver interface:",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUM_CE",
        "Number of source driver IC chip-enables.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDSHR",
        "Value for source-driver shift direction output port",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_HOLD",
        "Setting this bit to 1 holds the SDCLK low during LINE_BEGIN",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_SDCFG_TOG.
static const field_t hw_epdc_tce_sdcfg_tog[] =
{
    {
        "PIXELS_PER_CE",
        "Number of pixels (outputs) per source-driver IC.",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_INVERT",
        "Setting this bit to 1 reverses the polarity of each SDDO bit so 0xAAAA"
        " in 16-bit mode for example becomes 0x5555.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDDO_REFORMAT",
        "This register defines the various re-formatting options to enable more"
        " flexibility in the source-driver interface:",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUM_CE",
        "Number of source driver IC chip-enables.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDSHR",
        "Value for source-driver shift direction output port",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_HOLD",
        "Setting this bit to 1 holds the SDCLK low during LINE_BEGIN",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_GDCFG.
static const field_t hw_epdc_tce_gdcfg[] =
{
    {
        "GDSP_MODE",
        "Selects method for driving GDSP pulse.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_MODE",
        "Selects method for driving GDOE signal.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDRL",
        "Value for gate-driver right/left shift output port",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIOD_VSCAN",
        "when vscan state is splited, this reg defines the counter period",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_GDCFG_SET.
static const field_t hw_epdc_tce_gdcfg_set[] =
{
    {
        "GDSP_MODE",
        "Selects method for driving GDSP pulse.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_MODE",
        "Selects method for driving GDOE signal.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDRL",
        "Value for gate-driver right/left shift output port",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIOD_VSCAN",
        "when vscan state is splited, this reg defines the counter period",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_GDCFG_CLR.
static const field_t hw_epdc_tce_gdcfg_clr[] =
{
    {
        "GDSP_MODE",
        "Selects method for driving GDSP pulse.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_MODE",
        "Selects method for driving GDOE signal.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDRL",
        "Value for gate-driver right/left shift output port",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIOD_VSCAN",
        "when vscan state is splited, this reg defines the counter period",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_GDCFG_TOG.
static const field_t hw_epdc_tce_gdcfg_tog[] =
{
    {
        "GDSP_MODE",
        "Selects method for driving GDSP pulse.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_MODE",
        "Selects method for driving GDOE signal.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDRL",
        "Value for gate-driver right/left shift output port",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIOD_VSCAN",
        "when vscan state is splited, this reg defines the counter period",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN1.
static const field_t hw_epdc_tce_hscan1[] =
{
    {
        "LINE_SYNC",
        "Number of PIXCLK cycles for line sync duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_SYNC_WIDTH",
        "Number of PIXCLK cycles for the SDLE active time.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN1_SET.
static const field_t hw_epdc_tce_hscan1_set[] =
{
    {
        "LINE_SYNC",
        "Number of PIXCLK cycles for line sync duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_SYNC_WIDTH",
        "Number of PIXCLK cycles for the SDLE active time.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN1_CLR.
static const field_t hw_epdc_tce_hscan1_clr[] =
{
    {
        "LINE_SYNC",
        "Number of PIXCLK cycles for line sync duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_SYNC_WIDTH",
        "Number of PIXCLK cycles for the SDLE active time.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN1_TOG.
static const field_t hw_epdc_tce_hscan1_tog[] =
{
    {
        "LINE_SYNC",
        "Number of PIXCLK cycles for line sync duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_SYNC_WIDTH",
        "Number of PIXCLK cycles for the SDLE active time.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN2.
static const field_t hw_epdc_tce_hscan2[] =
{
    {
        "LINE_BEGIN",
        "Number of PIXCLK cycles for line begin duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_END",
        "Number of PIXCLK cycles for line end duration.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN2_SET.
static const field_t hw_epdc_tce_hscan2_set[] =
{
    {
        "LINE_BEGIN",
        "Number of PIXCLK cycles for line begin duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_END",
        "Number of PIXCLK cycles for line end duration.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN2_CLR.
static const field_t hw_epdc_tce_hscan2_clr[] =
{
    {
        "LINE_BEGIN",
        "Number of PIXCLK cycles for line begin duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_END",
        "Number of PIXCLK cycles for line end duration.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_HSCAN2_TOG.
static const field_t hw_epdc_tce_hscan2_tog[] =
{
    {
        "LINE_BEGIN",
        "Number of PIXCLK cycles for line begin duration.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINE_END",
        "Number of PIXCLK cycles for line end duration.",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_VSCAN.
static const field_t hw_epdc_tce_vscan[] =
{
    {
        "FRAME_SYNC",
        "Number of lines for frame sync duration.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_BEGIN",
        "Number of lines for frame begin duration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END",
        "Number of lines for frame end duration.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_VSCAN_SET.
static const field_t hw_epdc_tce_vscan_set[] =
{
    {
        "FRAME_SYNC",
        "Number of lines for frame sync duration.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_BEGIN",
        "Number of lines for frame begin duration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END",
        "Number of lines for frame end duration.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_VSCAN_CLR.
static const field_t hw_epdc_tce_vscan_clr[] =
{
    {
        "FRAME_SYNC",
        "Number of lines for frame sync duration.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_BEGIN",
        "Number of lines for frame begin duration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END",
        "Number of lines for frame end duration.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_VSCAN_TOG.
static const field_t hw_epdc_tce_vscan_tog[] =
{
    {
        "FRAME_SYNC",
        "Number of lines for frame sync duration.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_BEGIN",
        "Number of lines for frame begin duration.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END",
        "Number of lines for frame end duration.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_OE.
static const field_t hw_epdc_tce_oe[] =
{
    {
        "SDOEZ_DLY",
        "Number of PIXCLK cycles from SDLE falling edge to SDOEZ rising (Must b"
        "e greater than 0)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOEZ_WIDTH",
        "Number of PIXCLK cycles from SDOEZ high to SDOEZ falling (Must be grea"
        "ter than 0)",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_DLY",
        "Number of PIXCLK cycles from SDOEZ low to SDOED rising (Must be greate"
        "r than 0)",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_WIDTH",
        "Number of PIXCLK cycles from SDOED high to SDOED falling (Must be grea"
        "ter than 0)",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_OE_SET.
static const field_t hw_epdc_tce_oe_set[] =
{
    {
        "SDOEZ_DLY",
        "Number of PIXCLK cycles from SDLE falling edge to SDOEZ rising (Must b"
        "e greater than 0)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOEZ_WIDTH",
        "Number of PIXCLK cycles from SDOEZ high to SDOEZ falling (Must be grea"
        "ter than 0)",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_DLY",
        "Number of PIXCLK cycles from SDOEZ low to SDOED rising (Must be greate"
        "r than 0)",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_WIDTH",
        "Number of PIXCLK cycles from SDOED high to SDOED falling (Must be grea"
        "ter than 0)",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_OE_CLR.
static const field_t hw_epdc_tce_oe_clr[] =
{
    {
        "SDOEZ_DLY",
        "Number of PIXCLK cycles from SDLE falling edge to SDOEZ rising (Must b"
        "e greater than 0)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOEZ_WIDTH",
        "Number of PIXCLK cycles from SDOEZ high to SDOEZ falling (Must be grea"
        "ter than 0)",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_DLY",
        "Number of PIXCLK cycles from SDOEZ low to SDOED rising (Must be greate"
        "r than 0)",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_WIDTH",
        "Number of PIXCLK cycles from SDOED high to SDOED falling (Must be grea"
        "ter than 0)",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_OE_TOG.
static const field_t hw_epdc_tce_oe_tog[] =
{
    {
        "SDOEZ_DLY",
        "Number of PIXCLK cycles from SDLE falling edge to SDOEZ rising (Must b"
        "e greater than 0)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOEZ_WIDTH",
        "Number of PIXCLK cycles from SDOEZ high to SDOEZ falling (Must be grea"
        "ter than 0)",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_DLY",
        "Number of PIXCLK cycles from SDOEZ low to SDOED rising (Must be greate"
        "r than 0)",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOED_WIDTH",
        "Number of PIXCLK cycles from SDOED high to SDOED falling (Must be grea"
        "ter than 0)",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_POLARITY.
static const field_t hw_epdc_tce_polarity[] =
{
    {
        "SDCE_POL",
        "0 = Active Low, 1 = Active High.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_POL",
        "0 = Active Low, 1 = Active High.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOE_POL",
        "0 = Active Low, 1 = Active High.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_POL",
        "0 = Active Low, 1 = Active High.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDSP_POL",
        "0 = Active Low, 1 = Active High.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_POLARITY_SET.
static const field_t hw_epdc_tce_polarity_set[] =
{
    {
        "SDCE_POL",
        "0 = Active Low, 1 = Active High.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_POL",
        "0 = Active Low, 1 = Active High.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOE_POL",
        "0 = Active Low, 1 = Active High.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_POL",
        "0 = Active Low, 1 = Active High.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDSP_POL",
        "0 = Active Low, 1 = Active High.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_POLARITY_CLR.
static const field_t hw_epdc_tce_polarity_clr[] =
{
    {
        "SDCE_POL",
        "0 = Active Low, 1 = Active High.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_POL",
        "0 = Active Low, 1 = Active High.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOE_POL",
        "0 = Active Low, 1 = Active High.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_POL",
        "0 = Active Low, 1 = Active High.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDSP_POL",
        "0 = Active Low, 1 = Active High.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_POLARITY_TOG.
static const field_t hw_epdc_tce_polarity_tog[] =
{
    {
        "SDCE_POL",
        "0 = Active Low, 1 = Active High.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_POL",
        "0 = Active Low, 1 = Active High.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDOE_POL",
        "0 = Active Low, 1 = Active High.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_POL",
        "0 = Active Low, 1 = Active High.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDSP_POL",
        "0 = Active Low, 1 = Active High.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING1.
static const field_t hw_epdc_tce_timing1[] =
{
    {
        "SDCLK_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 4 cycle"
        "s",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_INVERT",
        "Invert phase of SDCLK",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 3 PIXCL"
        "K cycles",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING1_SET.
static const field_t hw_epdc_tce_timing1_set[] =
{
    {
        "SDCLK_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 4 cycle"
        "s",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_INVERT",
        "Invert phase of SDCLK",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 3 PIXCL"
        "K cycles",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING1_CLR.
static const field_t hw_epdc_tce_timing1_clr[] =
{
    {
        "SDCLK_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 4 cycle"
        "s",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_INVERT",
        "Invert phase of SDCLK",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 3 PIXCL"
        "K cycles",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING1_TOG.
static const field_t hw_epdc_tce_timing1_tog[] =
{
    {
        "SDCLK_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 4 cycle"
        "s",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDCLK_INVERT",
        "Invert phase of SDCLK",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDLE_SHIFT",
        "This register can be used to implement additional timing setup/hold ad"
        "justment of source driver signals by adjusting the SDCLK up to 3 PIXCL"
        "K cycles",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING2.
static const field_t hw_epdc_tce_timing2[] =
{
    {
        "GDSP_OFFSET",
        "This register allows the user to shift the GDSP pulse by N PIXCLKs whe"
        "re N=1 to 65535.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDCLK_HP",
        "This register controls the GDCLK high-pulse width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING2_SET.
static const field_t hw_epdc_tce_timing2_set[] =
{
    {
        "GDSP_OFFSET",
        "This register allows the user to shift the GDSP pulse by N PIXCLKs whe"
        "re N=1 to 65535.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDCLK_HP",
        "This register controls the GDCLK high-pulse width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING2_CLR.
static const field_t hw_epdc_tce_timing2_clr[] =
{
    {
        "GDSP_OFFSET",
        "This register allows the user to shift the GDSP pulse by N PIXCLKs whe"
        "re N=1 to 65535.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDCLK_HP",
        "This register controls the GDCLK high-pulse width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING2_TOG.
static const field_t hw_epdc_tce_timing2_tog[] =
{
    {
        "GDSP_OFFSET",
        "This register allows the user to shift the GDSP pulse by N PIXCLKs whe"
        "re N=1 to 65535.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDCLK_HP",
        "This register controls the GDCLK high-pulse width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING3.
static const field_t hw_epdc_tce_timing3[] =
{
    {
        "GDCLK_OFFSET",
        "This register allows the user to shift the GDCLK from the line time by"
        " N PIXCLK cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_OFFSET",
        "When using GDOE_MODE=1, this register sets the delay from GDCLK to the"
        " GDOE in terms of N PIXCLK cycles",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING3_SET.
static const field_t hw_epdc_tce_timing3_set[] =
{
    {
        "GDCLK_OFFSET",
        "This register allows the user to shift the GDCLK from the line time by"
        " N PIXCLK cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_OFFSET",
        "When using GDOE_MODE=1, this register sets the delay from GDCLK to the"
        " GDOE in terms of N PIXCLK cycles",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING3_CLR.
static const field_t hw_epdc_tce_timing3_clr[] =
{
    {
        "GDCLK_OFFSET",
        "This register allows the user to shift the GDCLK from the line time by"
        " N PIXCLK cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_OFFSET",
        "When using GDOE_MODE=1, this register sets the delay from GDCLK to the"
        " GDOE in terms of N PIXCLK cycles",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_TCE_TIMING3_TOG.
static const field_t hw_epdc_tce_timing3_tog[] =
{
    {
        "GDCLK_OFFSET",
        "This register allows the user to shift the GDCLK from the line time by"
        " N PIXCLK cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GDOE_OFFSET",
        "When using GDOE_MODE=1, this register sets the delay from GDCLK to the"
        " GDOE in terms of N PIXCLK cycles",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL0.
static const field_t hw_epdc_pigeon_ctrl0[] =
{
    {
        "FD_PERIOD",
        "period of line counter during FD phase",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LD_PERIOD",
        "period of pclk counter during LD phase",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL0_SET.
static const field_t hw_epdc_pigeon_ctrl0_set[] =
{
    {
        "FD_PERIOD",
        "period of line counter during FD phase",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LD_PERIOD",
        "period of pclk counter during LD phase",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL0_CLR.
static const field_t hw_epdc_pigeon_ctrl0_clr[] =
{
    {
        "FD_PERIOD",
        "period of line counter during FD phase",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LD_PERIOD",
        "period of pclk counter during LD phase",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL0_TOG.
static const field_t hw_epdc_pigeon_ctrl0_tog[] =
{
    {
        "FD_PERIOD",
        "period of line counter during FD phase",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LD_PERIOD",
        "period of pclk counter during LD phase",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL1.
static const field_t hw_epdc_pigeon_ctrl1[] =
{
    {
        "FRAME_CNT_PERIOD",
        "period of frame counter",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_CNT_CYCLES",
        "max cycles of frame counter",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL1_SET.
static const field_t hw_epdc_pigeon_ctrl1_set[] =
{
    {
        "FRAME_CNT_PERIOD",
        "period of frame counter",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_CNT_CYCLES",
        "max cycles of frame counter",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL1_CLR.
static const field_t hw_epdc_pigeon_ctrl1_clr[] =
{
    {
        "FRAME_CNT_PERIOD",
        "period of frame counter",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_CNT_CYCLES",
        "max cycles of frame counter",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_CTRL1_TOG.
static const field_t hw_epdc_pigeon_ctrl1_tog[] =
{
    {
        "FRAME_CNT_PERIOD",
        "period of frame counter",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_CNT_CYCLES",
        "max cycles of frame counter",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK1.
static const field_t hw_epdc_irq_mask1[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT0~31 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK1_SET.
static const field_t hw_epdc_irq_mask1_set[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT0~31 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK1_CLR.
static const field_t hw_epdc_irq_mask1_clr[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT0~31 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK1_TOG.
static const field_t hw_epdc_irq_mask1_tog[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT0~31 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK2.
static const field_t hw_epdc_irq_mask2[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT32~64 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK2_SET.
static const field_t hw_epdc_irq_mask2_set[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT32~64 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK2_CLR.
static const field_t hw_epdc_irq_mask2_clr[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT32~64 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK2_TOG.
static const field_t hw_epdc_irq_mask2_tog[] =
{
    {
        "LUTN_CMPLT_IRQ_EN",
        "LUT32~64 Complete Interrupt Enable",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ1.
static const field_t hw_epdc_irq1[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 0~31 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ1_SET.
static const field_t hw_epdc_irq1_set[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 0~31 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ1_CLR.
static const field_t hw_epdc_irq1_clr[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 0~31 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ1_TOG.
static const field_t hw_epdc_irq1_tog[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 0~31 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ2.
static const field_t hw_epdc_irq2[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 32~64 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ2_SET.
static const field_t hw_epdc_irq2_set[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 32~64 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ2_CLR.
static const field_t hw_epdc_irq2_clr[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 32~64 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ2_TOG.
static const field_t hw_epdc_irq2_tog[] =
{
    {
        "LUTN_CMPLT_IRQ",
        "LUT 32~64 Complete Interrupt",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK.
static const field_t hw_epdc_irq_mask[] =
{
    {
        "WB_CMPLT_IRQ_EN",
        "Enable WB complete interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COL_IRQ_EN",
        "Enable collision detection interrupts for all LUTs",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ_EN",
        "Enable pixel FIFO under-run condition detection.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ_EN",
        "If this bit is set, EPDC will assert the current frame end interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ_EN",
        "Enable AXI BUS ERROR interrupt detection.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ_EN",
        "Enable TCE Idle interrupt detection.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ_EN",
        "Enable UPD complete interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ_EN",
        "Enable power interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK_SET.
static const field_t hw_epdc_irq_mask_set[] =
{
    {
        "WB_CMPLT_IRQ_EN",
        "Enable WB complete interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COL_IRQ_EN",
        "Enable collision detection interrupts for all LUTs",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ_EN",
        "Enable pixel FIFO under-run condition detection.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ_EN",
        "If this bit is set, EPDC will assert the current frame end interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ_EN",
        "Enable AXI BUS ERROR interrupt detection.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ_EN",
        "Enable TCE Idle interrupt detection.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ_EN",
        "Enable UPD complete interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ_EN",
        "Enable power interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK_CLR.
static const field_t hw_epdc_irq_mask_clr[] =
{
    {
        "WB_CMPLT_IRQ_EN",
        "Enable WB complete interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COL_IRQ_EN",
        "Enable collision detection interrupts for all LUTs",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ_EN",
        "Enable pixel FIFO under-run condition detection.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ_EN",
        "If this bit is set, EPDC will assert the current frame end interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ_EN",
        "Enable AXI BUS ERROR interrupt detection.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ_EN",
        "Enable TCE Idle interrupt detection.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ_EN",
        "Enable UPD complete interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ_EN",
        "Enable power interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_MASK_TOG.
static const field_t hw_epdc_irq_mask_tog[] =
{
    {
        "WB_CMPLT_IRQ_EN",
        "Enable WB complete interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COL_IRQ_EN",
        "Enable collision detection interrupts for all LUTs",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ_EN",
        "Enable pixel FIFO under-run condition detection.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ_EN",
        "If this bit is set, EPDC will assert the current frame end interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ_EN",
        "Enable AXI BUS ERROR interrupt detection.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ_EN",
        "Enable TCE Idle interrupt detection.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ_EN",
        "Enable UPD complete interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ_EN",
        "Enable power interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ.
static const field_t hw_epdc_irq[] =
{
    {
        "WB_CMPLT_IRQ",
        "Working buffer process complete Interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_COL_IRQ",
        "Collision detection interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ",
        "Interrupt to indicate that a pixel FIFO under-run has occured.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ",
        "Interrupt to indicate EPDC has completed the current frame and is in t"
        "he vertical blanking period.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ",
        "Interrupt to indicate AXI BUS error occurs.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ",
        "Interrupt to indicate that the TCE has completed TFT frame scans and i"
        "s in an idle state.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ",
        "Working buffer process complete Interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ",
        "Power Interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_SET.
static const field_t hw_epdc_irq_set[] =
{
    {
        "WB_CMPLT_IRQ",
        "Working buffer process complete Interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_COL_IRQ",
        "Collision detection interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ",
        "Interrupt to indicate that a pixel FIFO under-run has occured.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ",
        "Interrupt to indicate EPDC has completed the current frame and is in t"
        "he vertical blanking period.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ",
        "Interrupt to indicate AXI BUS error occurs.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ",
        "Interrupt to indicate that the TCE has completed TFT frame scans and i"
        "s in an idle state.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ",
        "Working buffer process complete Interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ",
        "Power Interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_CLR.
static const field_t hw_epdc_irq_clr[] =
{
    {
        "WB_CMPLT_IRQ",
        "Working buffer process complete Interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_COL_IRQ",
        "Collision detection interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ",
        "Interrupt to indicate that a pixel FIFO under-run has occured.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ",
        "Interrupt to indicate EPDC has completed the current frame and is in t"
        "he vertical blanking period.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ",
        "Interrupt to indicate AXI BUS error occurs.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ",
        "Interrupt to indicate that the TCE has completed TFT frame scans and i"
        "s in an idle state.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ",
        "Working buffer process complete Interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ",
        "Power Interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_IRQ_TOG.
static const field_t hw_epdc_irq_tog[] =
{
    {
        "WB_CMPLT_IRQ",
        "Working buffer process complete Interrupt",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LUT_COL_IRQ",
        "Collision detection interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_UNDERRUN_IRQ",
        "Interrupt to indicate that a pixel FIFO under-run has occured.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_END_IRQ",
        "Interrupt to indicate EPDC has completed the current frame and is in t"
        "he vertical blanking period.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUS_ERROR_IRQ",
        "Interrupt to indicate AXI BUS error occurs.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE_IDLE_IRQ",
        "Interrupt to indicate that the TCE has completed TFT frame scans and i"
        "s in an idle state.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPD_DONE_IRQ",
        "Working buffer process complete Interrupt",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWR_IRQ",
        "Power Interrupt",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS1.
static const field_t hw_epdc_status_luts1[] =
{
    {
        "LUTN_STS",
        "LUT 0~31 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS1_SET.
static const field_t hw_epdc_status_luts1_set[] =
{
    {
        "LUTN_STS",
        "LUT 0~31 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS1_CLR.
static const field_t hw_epdc_status_luts1_clr[] =
{
    {
        "LUTN_STS",
        "LUT 0~31 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS1_TOG.
static const field_t hw_epdc_status_luts1_tog[] =
{
    {
        "LUTN_STS",
        "LUT 0~31 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS2.
static const field_t hw_epdc_status_luts2[] =
{
    {
        "LUTN_STS",
        "LUT 32~63 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS2_SET.
static const field_t hw_epdc_status_luts2_set[] =
{
    {
        "LUTN_STS",
        "LUT 32~63 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS2_CLR.
static const field_t hw_epdc_status_luts2_clr[] =
{
    {
        "LUTN_STS",
        "LUT 32~63 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_LUTS2_TOG.
static const field_t hw_epdc_status_luts2_tog[] =
{
    {
        "LUTN_STS",
        "LUT 32~63 Status : 1=ACTIVE, 0=IDLE",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_NEXTLUT.
static const field_t hw_epdc_status_nextlut[] =
{
    {
        "NEXT_LUT",
        "Next available LUT value",
        0, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXT_LUT_VALID",
        "This bitfield can be used to check against a LUTs full condition",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL1.
static const field_t hw_epdc_status_col1[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL1_SET.
static const field_t hw_epdc_status_col1_set[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL1_CLR.
static const field_t hw_epdc_status_col1_clr[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL1_TOG.
static const field_t hw_epdc_status_col1_tog[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL2.
static const field_t hw_epdc_status_col2[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL2_SET.
static const field_t hw_epdc_status_col2_set[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL2_CLR.
static const field_t hw_epdc_status_col2_clr[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_COL2_TOG.
static const field_t hw_epdc_status_col2_tog[] =
{
    {
        "LUTN_COL_STS",
        "LUTn Collision Status",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS.
static const field_t hw_epdc_status[] =
{
    {
        "WB_BUSY",
        "Working buffer process is busy cannot accept new update requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_BUSY",
        "Provides a summary status of LUTs.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_UNDERRUN",
        "Provides a summary status of LUT fill.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UPD_VOID",
        "Indicates that the update buffer is void.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HISTOGRAM_NP",
        "Indicates which histogram matched the processed bitmap(NP).",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HISTOGRAM_CP",
        "Indicates which histogram matched the existing bitmap(CP).",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_SET.
static const field_t hw_epdc_status_set[] =
{
    {
        "WB_BUSY",
        "Working buffer process is busy cannot accept new update requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_BUSY",
        "Provides a summary status of LUTs.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_UNDERRUN",
        "Provides a summary status of LUT fill.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UPD_VOID",
        "Indicates that the update buffer is void.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HISTOGRAM_NP",
        "Indicates which histogram matched the processed bitmap(NP).",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HISTOGRAM_CP",
        "Indicates which histogram matched the existing bitmap(CP).",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_CLR.
static const field_t hw_epdc_status_clr[] =
{
    {
        "WB_BUSY",
        "Working buffer process is busy cannot accept new update requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_BUSY",
        "Provides a summary status of LUTs.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_UNDERRUN",
        "Provides a summary status of LUT fill.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UPD_VOID",
        "Indicates that the update buffer is void.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HISTOGRAM_NP",
        "Indicates which histogram matched the processed bitmap(NP).",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HISTOGRAM_CP",
        "Indicates which histogram matched the existing bitmap(CP).",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_STATUS_TOG.
static const field_t hw_epdc_status_tog[] =
{
    {
        "WB_BUSY",
        "Working buffer process is busy cannot accept new update requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_BUSY",
        "Provides a summary status of LUTs.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LUTS_UNDERRUN",
        "Provides a summary status of LUT fill.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UPD_VOID",
        "Indicates that the update buffer is void.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HISTOGRAM_NP",
        "Indicates which histogram matched the processed bitmap(NP).",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HISTOGRAM_CP",
        "Indicates which histogram matched the existing bitmap(CP).",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_COL_CORD.
static const field_t hw_epdc_upd_col_cord[] =
{
    {
        "XCORD",
        "X co-ordinate for collision region of the latest completed update",
        0, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YCORD",
        "Y co-ordinate for collision region of the latest completed update",
        16, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_UPD_COL_SIZE.
static const field_t hw_epdc_upd_col_size[] =
{
    {
        "WIDTH",
        "Width (in pixels)",
        0, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HEIGHT",
        "Height (in pixels)",
        16, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST1_PARAM.
static const field_t hw_epdc_hist1_param[] =
{
    {
        "VALUE0",
        "value for 1-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        5, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST2_PARAM.
static const field_t hw_epdc_hist2_param[] =
{
    {
        "VALUE0",
        "Black value for 2-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "White value for 2-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set to zero.",
        16, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST4_PARAM.
static const field_t hw_epdc_hist4_param[] =
{
    {
        "VALUE0",
        "GRAY0 (Black) value for 4-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "GRAY1 value for 4-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE2",
        "GRAY2 value for 4-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE3",
        "GRAY3 (White) value for 4-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST8_PARAM0.
static const field_t hw_epdc_hist8_param0[] =
{
    {
        "VALUE0",
        "GRAY0 (Black) value for 8-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "GRAY1 value for 8-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE2",
        "GRAY2 value for 8-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE3",
        "GRAY3 value for 8-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST8_PARAM1.
static const field_t hw_epdc_hist8_param1[] =
{
    {
        "VALUE4",
        "GRAY4 value for 8-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE5",
        "GRAY5 value for 8-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE6",
        "GRAY6 value for 8-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE7",
        "GRAY7 (White) value for 8-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM0.
static const field_t hw_epdc_hist16_param0[] =
{
    {
        "VALUE0",
        "GRAY0 (Black) value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE1",
        "GRAY1 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE2",
        "GRAY2 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE3",
        "GRAY3 value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM1.
static const field_t hw_epdc_hist16_param1[] =
{
    {
        "VALUE4",
        "GRAY4 value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE5",
        "GRAY5 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE6",
        "GRAY6 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE7",
        "GRAY7 value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM2.
static const field_t hw_epdc_hist16_param2[] =
{
    {
        "VALUE8",
        "GRAY8 value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE9",
        "GRAY9 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE10",
        "GRAY10 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE11",
        "GRAY11 value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_HIST16_PARAM3.
static const field_t hw_epdc_hist16_param3[] =
{
    {
        "VALUE12",
        "GRAY12 value for 16-level histogram",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE13",
        "GRAY13 value for 16-level histogram",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE14",
        "GRAY14 value for 16-level histogram",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VALUE15",
        "GRAY15 (White) value for 16-level histogram",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_GPIO.
static const field_t hw_epdc_gpio[] =
{
    {
        "BDR",
        "Controls ipp_epdc_bdr[1:0] output",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCTRL",
        "Controls ipp_epdc_pwrctrl[3:0] output",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCOM",
        "Controls ipp_epdc_pwrcom output",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRWAKE",
        "Controls ipp_epdc_pwrwake output",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRSTAT",
        "reflect ipp_epdc_pwrstat input",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_GPIO_SET.
static const field_t hw_epdc_gpio_set[] =
{
    {
        "BDR",
        "Controls ipp_epdc_bdr[1:0] output",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCTRL",
        "Controls ipp_epdc_pwrctrl[3:0] output",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCOM",
        "Controls ipp_epdc_pwrcom output",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRWAKE",
        "Controls ipp_epdc_pwrwake output",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRSTAT",
        "reflect ipp_epdc_pwrstat input",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_GPIO_CLR.
static const field_t hw_epdc_gpio_clr[] =
{
    {
        "BDR",
        "Controls ipp_epdc_bdr[1:0] output",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCTRL",
        "Controls ipp_epdc_pwrctrl[3:0] output",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCOM",
        "Controls ipp_epdc_pwrcom output",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRWAKE",
        "Controls ipp_epdc_pwrwake output",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRSTAT",
        "reflect ipp_epdc_pwrstat input",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_GPIO_TOG.
static const field_t hw_epdc_gpio_tog[] =
{
    {
        "BDR",
        "Controls ipp_epdc_bdr[1:0] output",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCTRL",
        "Controls ipp_epdc_pwrctrl[3:0] output",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRCOM",
        "Controls ipp_epdc_pwrcom output",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRWAKE",
        "Controls ipp_epdc_pwrwake output",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRSTAT",
        "reflect ipp_epdc_pwrstat input",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_VERSION.
static const field_t hw_epdc_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_0_0.
static const field_t hw_epdc_pigeon_0_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_0_1.
static const field_t hw_epdc_pigeon_0_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_0_2.
static const field_t hw_epdc_pigeon_0_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_1_0.
static const field_t hw_epdc_pigeon_1_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_1_1.
static const field_t hw_epdc_pigeon_1_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_1_2.
static const field_t hw_epdc_pigeon_1_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_2_0.
static const field_t hw_epdc_pigeon_2_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_2_1.
static const field_t hw_epdc_pigeon_2_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_2_2.
static const field_t hw_epdc_pigeon_2_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_3_0.
static const field_t hw_epdc_pigeon_3_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_3_1.
static const field_t hw_epdc_pigeon_3_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_3_2.
static const field_t hw_epdc_pigeon_3_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_4_0.
static const field_t hw_epdc_pigeon_4_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_4_1.
static const field_t hw_epdc_pigeon_4_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_4_2.
static const field_t hw_epdc_pigeon_4_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_5_0.
static const field_t hw_epdc_pigeon_5_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_5_1.
static const field_t hw_epdc_pigeon_5_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_5_2.
static const field_t hw_epdc_pigeon_5_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_6_0.
static const field_t hw_epdc_pigeon_6_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_6_1.
static const field_t hw_epdc_pigeon_6_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_6_2.
static const field_t hw_epdc_pigeon_6_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_7_0.
static const field_t hw_epdc_pigeon_7_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_7_1.
static const field_t hw_epdc_pigeon_7_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_7_2.
static const field_t hw_epdc_pigeon_7_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_8_0.
static const field_t hw_epdc_pigeon_8_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_8_1.
static const field_t hw_epdc_pigeon_8_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_8_2.
static const field_t hw_epdc_pigeon_8_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_9_0.
static const field_t hw_epdc_pigeon_9_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_9_1.
static const field_t hw_epdc_pigeon_9_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_9_2.
static const field_t hw_epdc_pigeon_9_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_10_0.
static const field_t hw_epdc_pigeon_10_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_10_1.
static const field_t hw_epdc_pigeon_10_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_10_2.
static const field_t hw_epdc_pigeon_10_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_11_0.
static const field_t hw_epdc_pigeon_11_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_11_1.
static const field_t hw_epdc_pigeon_11_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_11_2.
static const field_t hw_epdc_pigeon_11_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_12_0.
static const field_t hw_epdc_pigeon_12_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POL",
        "polarity of signal output",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_SEL",
        "event to incrment local counter",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET",
        "offset on pclk unit.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT_SEL",
        "select global counters as mask condition, use together with MASK_CNT",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CNT",
        "When the global counter selected through MASK_CNT_SEL matches value in"
        " this reg, pigeon local counter start ticking.",
        12, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATE_MASK",
        "state_mask = (FS|FB|FD|FE) and (LS|LB|LD|LE) , select any combination "
        "of scan states as reference point for local counter to start ticking",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_12_1.
static const field_t hw_epdc_pigeon_12_1[] =
{
    {
        "SET_CNT",
        "assert signal output when counter match this value",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_CNT",
        "deassert signal output when counter match this value",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_12_2.
static const field_t hw_epdc_pigeon_12_2[] =
{
    {
        "SIG_LOGIC",
        "logic operation with another signal sigout : final output signal of th"
        "is generator mask : final mask of this generator this_sig : intermedia"
        "te signal of this generator before logic operation other_masks : inter"
        "mediate mask result of this generator before logic operation sig_anoth"
        "er : signal selected other generators",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIG_ANOTHER",
        "select another signal for logic operation or as mask or counter tick e"
        "vent",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPDC_PIGEON_13_0.
static const field_t hw_epdc_pigeon_13_0[] =
{
    {
        "EN",
        "enable pigeon mode on this signal",
        0, // 