/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
/***************************************************************************
*
* File Name: MPC5744P_appconfig.h
*
* Description: Header file for static configuration of the MPC5744P device
*
* Last Updated By: Daniel Diamont (nxf46153)
* Date of Last Update: 8/15/2018
*
****************************************************************************.*/

#ifndef __MPC5744P_CONFIG_SETUP_H
#define __MPC5744P_CONFIG_SETUP_H

/*
SIUL registers configuration - MSCR
--------------------------------------
*/

//APPLICATION LEDs
#define SIUL_MSCR6					0x02840000UL	/* GPIO6 output - APP_LED_1 */
#define SIUL_MSCR7					0x02840000UL	/* GPIO7 output - APP_LED_2 */
#define SIUL_MSCR8					0x02840000UL	/* GPIO8 output - APP_LED_3 */
#define SIUL_MSCR56					0x02840000UL	/* GPIO56 output - APP_LED_4 */
#define SIUL_MSCR78					0x02840000UL	/* GPIO78 output - APP_LED_5 */
#define SIUL_MSCR83					0x02840000UL	/* GPIO83 output - APP_LED_6 */

//ANALOG-TO-DIGITAL CONVERTERS
//Motor 1
#define SIUL_MSCR23         		0x00480000UL    /* ADC0_0 input Resolver sin input */
#define SIUL_MSCR25         		0x00400000UL    /* ADC0/1_11 input I_phA */
#define SIUL_MSCR26         		0x00400000UL    /* ADC0/1_12 input I_phB */
#define SIUL_MSCR27         		0x00400000UL    /* ADC0/1_13 input I_phC */
#define SIUL_MSCR28         		0x00400000UL    /* ADC0/1_14 input UDC Bus Voltage */
#define SIUL_MSCR29         		0x00480000UL    /* ADC1_0 input Resolver cos input */
//Motor 2
#define SIUL_MSCR151				0x00480000UL 	/* ADC2/3_2 input Resolver sin */
#define SIUL_MSCR75					0x00480000UL	/* ADC1/3_4 input Resolver cos */
#define SIUL_MSCR73					0x00480000UL	/* ADC1/3_7 input DCBI */
#define SIUL_MSCR149				0x00400000UL	/* ADC2/3_0 input I_phA  */
#define SIUL_MSCR150				0x00400000UL	/* ADC2/3_1 input I_phB */
#define SIUL_MSCR64					0x00400000UL	/* ADC1/3_5 input I_phC */
#define SIUL_MSCR76					0x00400000UL	/* ADC1/3_6 input DCBV */

// MC33937 PRE-DRIVER SPI
#define SIUL_MSCR10					0x028A0000UL	/* GPIO10 output - Motor 1 Pre-Driver Reset 33937_/RST */
#define SIUL_MSCR49					0x028A0000UL	/* GPIO49 output - Motor 2 Pre-Driver Reset 33937_/RST */
#define SIUL_MSCR13					0x008C0000UL	/* GPIO13 input w/ interrupt - M1_DRV_INT  */
#define SIUL_MSCR14					0x008C0000UL	/* GPIO14 input w/ interrupt - M2_DRV_INT */
#define SIUL_MSCR36					0x02840001UL	/* DSPI0 /CS0 output    - AD2S_CS */
#define SIUL_MSCR37					0x02840001UL	/* DSPI0 SCK output     - AD2S_SCLK */
#define SIUL_MSCR38					0x02840001UL	/* DSPI0 SOUT output    - AD2S_SDO */
#define SIUL_MSCR39					0x008C0000UL	/* DSPI0 SIN input      - AD2S_SDI */
#define SIUL_MSCR53					0x02840001UL	/* GPIO53 output - DSPI0 /CS3 */
#define SIUL_MSCR54					0x02840001UL	/* GPIO54 output - DSPI0 /CS2 */
#define SIUL_MSCR79					0x02840001UL	/* GPIO79 output - DSPI0 /CS1 */


//CAN COMMUNICATION (NOT USED)
#define SIUL_MSCR16					0x02840001UL	/* GPIO16 output - CAN0_TX */
#define SIUL_MSCR17					0x008C0000UL	/* GPIO17 input - CAN0_RX */

//LIN COMMUNICATION
//Motor 1
#define SIUL_MSCR18					0x02840001UL	/* LIN0 TX */
#define SIUL_MSCR19					0x008C0000UL	/* LIN0 RX */
//Motor 2
#define SIUL_MSCR94					0x02840001UL	/* GPIO94 output - LIN1_TX */
#define SIUL_MSCR95					0x008C0000UL	/* GPIO95 input - LIN1_RX */

//USER INPUT BUTTONS
//Motor 1
#define SIUL_MSCR48					0x008F0000UL	/* GPIO48 input - M1_SW_UP */
#define SIUL_MSCR92					0x008C0000UL	/* GPIO92 input - M1_SW_DOWN */
//Motor 2
#define SIUL_MSCR42         		0x008C0000UL    /* GPIO42 input - M2_SW_DOWN */
#define SIUL_MSCR77					0x008C0000UL	/* GPIO77 input - M2_SW_UP */

//USER INPUT SWITCH
#define SIUL_MSCR12					0x008C0000UL	/* GPIO12 input  - SW_APP_RUN_L for motor 1*/
#define SIUL_MSCR15					0x008C0000UL	/* GPIO15 input  - SW_APP_RUN_L for motor 2 */

//RESOLVER EXCITATION SIGNALS
//Motor 1
#define SIUL_MSCR44         		0x02840001UL    /* GPIO44 output - TMR0_CH5 Resolver Excitation Signal */
//Motor 2
#define SIUL_MSCR52					0x02840002UL    /* GPIO52 output - TMR1_CH5 Resolver Excitation Signal */

// ENCODER SIGNALS (NOT USED)
//Motor 1
//#define SIUL_MSCR0				0x008C0001UL	/* GPIO0 input ENC1_PHA 	*/
//#define SIUL_MSCR1				0x008C0001UL	/* GPIO1 input ENC1_PHB 	*/
//#define SIUL_MSCR2				0x008C0000UL	/* GPIO2 input ENC1_INDEX 	*/
//Motor 2
//#define SIUL_MSCR47				0x008C0000UL	/* GPIO47 input ENC2_PHA 	*/
//#define SIUL_MSCR45				0x008C0000UL	/* GPIO45 input ENC2_PHB 	*/
//#define SIUL_MSCR46				0x008C0000UL	/* GPIO46 input ENC2_INDEX  */

// APPLICATION PWM MODULES
//Motor 1
#define SIUL_MSCR57					0x008C0001UL	/* GPIO57 input   - M1-PWM_X0 */
#define SIUL_MSCR58					0x02840001UL	/* GPIO58 output  - M1-PWM_A0 */
#define SIUL_MSCR59					0x02840001UL	/* GPIO59 output  - M1-PWM_B0 */
#define SIUL_MSCR60					0x008C0001UL	/* GPIO60 input   - M1-PWM_X1 */
#define SIUL_MSCR80					0x02840001UL	/* GPIO80 output  - M1-PWM_A1 */
#define SIUL_MSCR62					0x02840001UL	/* GPIO62 output  - M1-PWM_B1 */
#define SIUL_MSCR98					0x008C0001UL	/* GPIO98 input   - M1-PWM_X2 */
#define SIUL_MSCR99					0x02840001UL	/* GPIO99 output  - M1-PWM_A2 */
#define SIUL_MSCR100				0x02840001UL	/* GPIO100 output - M1-PWM_B2 */
//Motor 2
#define SIUL_MSCR116				0x008C0001UL	/* GPIO116 input  - M2-PWM_X0 */
#define SIUL_MSCR117				0x02840001UL	/* GPIO117 output - M2-PWM_A0 */
#define SIUL_MSCR118				0x02840001UL	/* GPIO118 output - M2-PWM_B0 */
#define SIUL_MSCR119				0x008C0001UL	/* GPIO119 input  - M2-PWM_X1 */
#define SIUL_MSCR120				0x02840001UL	/* GPIO120 output - M2-PWM_A1 */
#define SIUL_MSCR121				0x02840001UL	/* GPIO121 output - M2-PWM_B1 */
#define SIUL_MSCR122				0x008C0001UL	/* GPIO122 input  - M2-PWM_X2 */
#define SIUL_MSCR123				0x02840001UL	/* GPIO123 output - M2-PWM_A2 */
#define SIUL_MSCR124				0x02840001UL	/* GPIO124 output - M2-PWM_B2 */

//PWM BRAKING (NOT USED)
//#define SIUL_MSCR103				0x02840000UL	/* GPIO103 output - M1_BRAKE */
//#define SIUL_MSCR127				0x02840000UL	/* GPIO127 output - M2_BRAKE */

//FAULT DETECTION
//Motor 1
#define SIUL_MSCR104				0x008C0000UL	/* GPIO104 input - M1_FLT0 */
#define SIUL_MSCR105				0x008C0000UL	/* GPIO105 input - M1_FLT1 */
#define SIUL_MSCR106				0x008C0000UL	/* GPIO106 input - M1_FLT2 */
#define SIUL_MSCR107				0x008C0000UL	/* GPIO107 input - M1_FLT3 */
//Motor 2
#define SIUL_MSCR128				0x008C0000UL	/* GPIO128 input - M2_FLT0 */
#define SIUL_MSCR129				0x008C0000UL	/* GPIO129 input - M2_FLT1 */
//#define SIUL_MSCR130				0x008C0000UL	/* GPIO130 input - M2_FLT2 */
//#define SIUL_MSCR131				0x008C0000UL	/* GPIO131 input - M2_FLT3 */

//CTU EXTERNAL TRIGGER (DEBUG)
#define SIUL_MSCR46					0x02840002UL	/* GPIO46 output  HDR_CTU0_TRG */
#define SIUL_MSCR141				0x02840001UL	/* GPIO141 output HDR_CTU1_TRG */

//CLK_OUT (DEBUG)
#define SIUL_MSCR22					0x02840001UL	/* CLK_OUT output */

//SINE WAVE GEN OUT
#define SIUL_MSCR55					0x00400000UL	/* GPIO55 output - SWG_OUT */


//MOTOR ENABLE
#define SIUL_MSCR11					0x028A0000UL	/* GPIO11 output - M1_EN - AD2S_A0 */
#define SIUL_MSCR132				0x028A0000UL	/* GPIO11 output - M2_EN */


/*
SIUL registers configuration - IMCR
--------------------------------------
*/

//FAULT DETECTION
//Motor 1
#define	SIUL_IMCR83					0x00000003UL	/* GPIO104 input - M1_FLT0 */
#define	SIUL_IMCR84					0x00000003UL	/* GPIO105 input - M1_FLT1 */
//Motor 2
#define	SIUL_IMCR100				0x00000001UL	/* GPIO128 input - M2_FLT0 */
#define	SIUL_IMCR101				0x00000001UL	/* GPIO129 input - M2_FLT1 */

// MC33937 PRE-DRIVER SPI
#define	SIUL_IMCR41					0x00000001UL	/* DSPI0 SIN input */

// LIN COMMUNICATION
#define	SIUL_IMCR165				0x00000001UL	/* LIN1_TX */
#define	SIUL_IMCR166				0x00000003UL	/* LIN1_RX */

// MC33937 PRE-DRIVER EXTERNAL INTERRUPT
//Motor 1
#define	SIUL_IMCR185				0x00000001UL	/* A13 - IMCR[185] - SIUL ext. interrupt source 12*/
//Motor 2
#define SIUL_IMCR186				0x00000001UL	/* A14 - IMCR[186] - SIUL ext. interrupt source 13*/

// ENCODER (NOT USED)
//Motor 1
//#define	SIUL_IMCR59					0x00000002UL	/* Encoder PhA  PCIe J1 */
//#define	SIUL_IMCR60					0x00000002UL	/* Encoder PhB  PCIe J1 */

//Motor 2
//#define SIUL_IMCR65					0x00000002UL /* Encoder PhA PCIe J200 */
//#define SIUL_IMCR66					0x00000002UL /* Encoder PhB PCIe J200 */

// CAN COMMUNICATION (NOT USED)
//#define	SIUL_IMCR32					0x00000002UL	/* GPIO17 input - CAN0_RX */


/*
FlexPWM0 registers configuration
--------------------------------------

Center-aligned PWM signals.

PWM clock 160 MHz set by MC_CGM (MPC5744P Clock Generation Module) on MOTC_CLK bus.

20 kHz PWM output and 100 us PWM reload period
*/
#define FlexPWM0_OUTEN                 0x0770 /* enable PWM submodule 0,1,2 */
#define FlexPWM0_MASK                  0x0770 /* mask for PWM submodule 0,1,2 */
#define FlexPWM0_MCTRL                 0x0700 /* run PWM submodule 0,1,2 */
#define FlexPWM0_FCTRL                 0xC0F0 /* Fault level logic 1 and fail safe mode for all submodules */
#define FlexPWM0_FSTS				   0x0000 /* zero out fault status register */
#define FlexPWM0_FFILT                 0x0001 /* sampling period for fault filter - 1 clock cycle */
#define FlexPWM0_INIT_sub0             0xF060 /* Initial count value in PWM clock periods -- - 4000 DEC */
#define FlexPWM0_CTRL2_sub0            0xC0A0 /* debug enable, complementary pair, synced to master reload signal */
#define FlexPWM0_CTRL1_sub0            0x1400 /* reload every 2 PWM opportunities, Full cycle reload */
#define FlexPWM0_VAL1_sub0             0x0FA0 /* modulo count value for submodule counter -- 3999 DEC */
#define FlexPWM0_VAL2_sub0             0xF830 /* Count value set to PWM23 high */
#define FlexPWM0_VAL3_sub0             0x07D0 /* Count value set to PWM23 low */
#define FlexPWM0_OCTRL_sub0            0x0410 /* Output cntrl -- enable PWMA inverted output; PWMB not inverted output; PWMX not inverted input */
#define FlexPWM0_DTCNT0_sub0           0x005A /* deadtime count -- 90 PWM clock cycles */
#define FlexPWM0_DTCNT1_sub0           0x005A /* deadtime count -- 90 PWM clock cycles */
#define FlexPWM0_INIT_sub1             0xF060
#define FlexPWM0_CTRL2_sub1            0xC2AE /* debug enable, complementary pair, synced to local reload signal */
#define FlexPWM0_CTRL1_sub1            0x1400
#define FlexPWM0_VAL1_sub1             0x0FA0
#define FlexPWM0_VAL2_sub1             0xF830
#define FlexPWM0_VAL3_sub1             0x07D0
#define FlexPWM0_OCTRL_sub1            0x0410
#define FlexPWM0_DTCNT0_sub1           0x005A
#define FlexPWM0_DTCNT1_sub1           0x005A
#define FlexPWM0_INIT_sub2             0xF060
#define FlexPWM0_CTRL2_sub2            0xC2AE /* debug enable, complementary pair, synced to local reload signal */
#define FlexPWM0_CTRL1_sub2            0x1400
#define FlexPWM0_VAL1_sub2             0x0FA0
#define FlexPWM0_VAL2_sub2             0xF830
#define FlexPWM0_VAL3_sub2             0x07D0
#define FlexPWM0_OCTRL_sub2            0x0410
#define FlexPWM0_DTCNT0_sub2           0x005A
#define FlexPWM0_DTCNT1_sub2           0x005A

/*
FlexPWM1 registers configuration
--------------------------------------
Center-aligned PWM signals.

PWM clock 160 MHz set by MC_CGM (MPC5744P Clock Generation Module) on MOTC_CLK bus.

20 kHz PWM output and 100 us PWM reload period
*/
#define FlexPWM1_OUTEN                 0x0770 /* enable PWM submodule 0,1,2 */
#define FlexPWM1_MASK                  0x0770 /* mask for PWM submodule 0,1,2 */
#define FlexPWM1_MCTRL                 0x0700 /* run PWM submodule 0,1,2 */
#define FlexPWM1_FCTRL                 0xC0F0 /* Fault level logic 1 and fail safe mode for all submodules */
#define FlexPWM1_FSTS				   0x0000 /* zero out fault status register */
#define FlexPWM1_FFILT                 0x0001 /* sampling period for fault filter - 1 clock cycle */
#define FlexPWM1_INIT_sub0             0xF060 /* Initial count value in PWM clock periods -- - 4000 DEC */
#define FlexPWM1_CTRL2_sub0            0xC0A0 /* debug enable, complementary pair, synced to master reload signal */
#define FlexPWM1_CTRL1_sub0            0x1400 /* reload every 2 PWM opportunities, Full cycle reload */
#define FlexPWM1_VAL1_sub0             0x0FA0 /* modulo count value for submodule counter -- 3999 DEC */
#define FlexPWM1_VAL2_sub0             0xF830 /* Count value set to PWM23 high */
#define FlexPWM1_VAL3_sub0             0x07D0 /* Count value set to PWM23 low */
#define FlexPWM1_OCTRL_sub0            0x0410 /* Output cntrl -- enable PWMA inverted output; PWMB not inverted output; PWMX not inverted input */
#define FlexPWM1_DTCNT0_sub0           0x005A /* deadtime count -- 90 PWM clock cycles */
#define FlexPWM1_DTCNT1_sub0           0x005A /* deadtime count -- 90 PWM clock cycles */
#define FlexPWM1_INIT_sub1             0xF060
#define FlexPWM1_CTRL2_sub1            0xC2AE /* debug enable, complementary pair, synced to local reload signal */
#define FlexPWM1_CTRL1_sub1            0x1400
#define FlexPWM1_VAL1_sub1             0x0FA0
#define FlexPWM1_VAL2_sub1             0xF830
#define FlexPWM1_VAL3_sub1             0x07D0
#define FlexPWM1_OCTRL_sub1            0x0410
#define FlexPWM1_DTCNT0_sub1           0x005A
#define FlexPWM1_DTCNT1_sub1           0x005A
#define FlexPWM1_INIT_sub2             0xF060
#define FlexPWM1_CTRL2_sub2            0xC2AE /* debug enable, complementary pair, synced to local reload signal */
#define FlexPWM1_CTRL1_sub2            0x1400
#define FlexPWM1_VAL1_sub2             0x0FA0
#define FlexPWM1_VAL2_sub2             0xF830
#define FlexPWM1_VAL3_sub2             0x07D0
#define FlexPWM1_OCTRL_sub2            0x0410
#define FlexPWM1_DTCNT0_sub2           0x005A
#define FlexPWM1_DTCNT1_sub2           0x005A


/*
CTU0 registers configuration
--------------------------------------
*/

/* Enable Input */
#define CTU0_TGSISR						0x00000001 //Enable flexPWM0 A0 (MRS) for rising edge trigger; I0_RE

/* Compare Registers */
#define CTU0_T0CR                       0x00A0 	/* For triggering conversion on ADC0/1
 	 	 	 	 	 	 	 	 	 	 	 	 determines delay */
#define CTU0_T1CR                       0x1D4C	//8000 bus cycles between T1CR and T2CR
#define CTU0_T2CR                       0x3C8C

/* Counter */
#define CTU0_TGSCR                      0x0100 /* toggle EXT_TRG for debugging */
#define CTU0_TGSCCR                     0x3E80 /* 16000 bus cycles

/* Enable Triggers */
#define CTU0_THCR1                      0x00424261	/* Enable Trigger 0 and set to ADC
										 * Enable Trigger 1 and set to eTimer0
										 * Enable Trigger 2 and set to eTimer0
										 */

/* ADC commands */
#define CTU0_CLR0                       0x618B /* Command 0 - first command, sample ADC0/1_AN11/12 */
#define CTU0_CLR1                       0x21CD /* Command 1 - sample ADC0/1_AN13/14 */
#define CTU0_CLR2                       0x2000 /* Command 2 - sample ADC0/1_AN0/0 */
#define CTU0_CLR3                       0xA02F /* Command 3 - last command, sample ADC1_AN15 */

#define CTU0_CLCR1                      0x00000000
#define CTU0_COTR                       0x0064
#define CTU0_CTU0CR                     0x0003


/*
CTU1 registers configuration
--------------------------------------
*/

/* Enable input */
#define CTU1_TGSISR						0x00000001 //Enable flexPWM1 A0 (MRS) for rising edge trigger; I0_RE

/* Compare registers */
#define CTU1_T0CR                       0x00A0 /* For triggering conversion on ADC2/3
 	 	 	 	 	 	 	 	 	 	 	 	 determines delay */
#define CTU1_T1CR                       0x1D4C //8000 cycles between T1CR and T2CR
#define CTU1_T2CR                       0x3C8C

/* Counter */
#define CTU1_TGSCR                      0x0100 /* toggle EXT_TRG for debugging */
#define CTU1_TGSCCR                     0x3E80 //16000 DEC

/* Enable triggers */
#define CTU1_THCR1                      0x00505061
										/* Enable Trigger 0 and set to ADC
										 * Enable Trigger 1 and set to eTimer1
										 * Enable Trigger 2 and set to eTimer1
										 */
/* Set ADC messages */
#define CTU1_CLR0                       0x6020 /* Command 0 - first command, sample ADC2/3_AN0/1 */
#define CTU1_CLR1						0x2089 /* Command 1 - sample ADC3_AN4 */
#define CTU1_CLR2                       0x20A6 /* Command 2 - sample ADC3_AN5 */
#define CTU1_CLR3                       0x2062 /* Command 3 - sample ADC2/3_AN2/3 */
#define CTU1_CLR4                       0xA0E8 /* Command 4 - last command, sample ADC2/3_AN7/8 */

#define CTU1_CLCR1                      0x00000000

#define CTU1_COTR                       0x0064
#define CTU1_CTU1CR                     0x0003

/*
ADC0 registers configuration
--------------------------------------
*/
#define ADC0_MCR                       0x80020000UL
#define ADC0_CTR0                      0x00000016UL

/*
ADC1 registers configuration
--------------------------------------
*/
#define ADC1_MCR                       0x80020000UL
#define ADC1_CTR0                      0x00000016UL

/*
ADC2 registers configuration
--------------------------------------
*/
#define ADC2_MCR                       0x80020000UL
#define ADC2_CTR0                      0x00000016UL

/*
ADC3 registers configuration
--------------------------------------
*/
#define ADC3_MCR                       0x80020000UL
#define ADC3_CTR0                      0x00000016UL

/*
eTimer0 registers configuration
--------------------------------------
*/

/*
 * encoder set-up (not used)
 *
 * example using encoder sensor with 1024 pulses
 */
/*
#define eTimer0_CTRL1_CH0               0x8041
#define eTimer0_CCCTRL_CH0              0xDE00
#define eTimer0_COMP1_CH0		            0x07FF
#define eTimer0_COMP2_CH0		            0xF800
#define eTimer0_CMPLD1_CH0		          0x07FF
#define eTimer0_CMPLD2_CH0		          0XF800
*/


/*
 * resolver excitation signal set-up
 */
#define eTimer0_CTRL1_CH5               0xD848		/* Resolver excitation - PCIe J1*/
#define eTimer0_CTRL2_CH5              	0x8403		/* Resolver excitation - PCIe J1*/
#define eTimer0_ENBL                   	0x003F		// Enable all channels in eTimer0 module

/*
eTimer1 registers configuration
--------------------------------------
*/

/*
 * encoder set-up (not used)
 */
 /*
 #define eTimer1_CTRL1_CH0               0x8041
 #define eTimer1_CCCTRL_CH0              0xDE00
 #define eTimer1_COMP1_CH0		            0x07FF
 #define eTimer1_COMP2_CH0		            0xF800
 #define eTimer1_CMPLD1_CH0		          0x07FF
 #define eTimer1_CMPLD2_CH0		          0XF800
 */

/*
 * resolver excitation signal set-up
 */
#define eTimer1_CTRL1_CH5               0xD84B		/* Resolver excitation - PCIe J200*/
#define eTimer1_CTRL2_CH5              	0x8403		/* Resolver excitation - PCIe J200*/
#define eTimer1_ENBL                   	0x003F		// Enable all channels in eTimer1 module

/*
eTimer2 registers configuration
--------------------------------------
*/

/*
DSPI0 registers configuration
--------------------------------------
*/
#define SPI0_MCR                      0x803F0000
#define SPI0_CTAR0                    0x3A003373
#define SPI0_CTAR1                    0x7A541133

/*
DSPI1 registers configuration
--------------------------------------
*/

/*
DSPI2 registers configuration
--------------------------------------
*/

/*
DSPI3 registers configuration
--------------------------------------
*/

/*
PIT registers configuration
--------------------------------------
*/
#define PIT_PITMCR                 	   0x00000004

/*
SWG registers configuration
--------------------------------------
*/
#define SWG_CTRL                 	   0x00000000UL
#define SWG_TRIG_EN                    0	// 0 - Dis, 1-EN
#define SWG_TRIG_SEL                   0
#define SWG_TRIG_IOAMPL				   8	// 1.136 Sine wave amplitude (V)
#define SWG_TRIG_IOFREQ				   524	// IOFREQ(dec) = freq*1048576/InFreq = 10KHz*1048576/20MHz = 524.288
										  	// BW freq. recalc: freal = 9994.5Hz


/*         End of code
***********************************************************************/
#endif
