/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* Global variables*/
var xmlDoc     = loadXMLDoc("FreeMASTER_interface.xml");
var MotorPrefix;
var Mx;
var in_MethodCtrlVal;

/* ---- Initialization ------------------------*/
function Init() {

    //read the Active motor status from MCAT
    MotorPrefix = getActiveMotor();
    // if Control page is not used within MCAT use default setting for prefix = M1_
    if(MotorPrefix==='')   {Mx = 'M1_';}
    else                   {Mx = MotorPrefix;}

    // Gauge, Buttons control - subscribed FreeMASTER variables for onChange detection
    reference_val = xmlDoc.getElementsByTagName([Mx+ "swSensor"])[0];

    reference_val_6 = xmlDoc.getElementsByTagName([Mx+ "states"])[0].getAttribute('FreemasterName');
    pcm.SubscribeVariable(reference_val_6, 200);

    if(reference_val.childNodes[0] !== null){
        reference_val_1 = reference_val.childNodes[0].nodeValue;
        pcm.SubscribeVariable(reference_val_1, 1500);
    }
    else{
        reference_val_1 = null;
    }


    reference_val = xmlDoc.getElementsByTagName([Mx+ "onoff"])[0];
    reference_val_2 = reference_val.childNodes[0].nodeValue;
    pcm.SubscribeVariable(reference_val_2, 1500);

    reference_val = xmlDoc.getElementsByTagName([Mx+ "ActualVoltage"])[0];
    reference_val_3 = reference_val.childNodes[0].nodeValue;
    pcm.SubscribeVariable(reference_val_3, 250);

    reference_val = xmlDoc.getElementsByTagName([Mx+ "ActualSpeed"])[0];
    reference_val_4 = reference_val.childNodes[0].nodeValue;
    pcm.SubscribeVariable(reference_val_4, 250);

    reference_val = xmlDoc.getElementsByTagName([Mx+ "RequiredSpeed"])[0];
    reference_val_5 = reference_val.childNodes[0].nodeValue;
    pcm.SubscribeVariable(reference_val_5, 2500);

    reference_val_6 = xmlDoc.getElementsByTagName([Mx+ "states"])[0].getAttribute('FreemasterName');
    pcm.SubscribeVariable(reference_val_6, 200);

    // read the active control method
    var MethodCtrlVal = xmlDoc.getElementsByTagName([MotorPrefix]+"ControlStructureMethod")[0];
    if(MethodCtrlVal.childNodes[0]!==null)
        if(pcm.ReadVariable(MethodCtrlVal.childNodes[0].nodeValue))
             in_MethodCtrlVal = pcm.LastVariable_vValue;
        else in_MethodCtrlVal = 3; // dafault value for Speed control

    // Set colors according to the Control Page Object
    var cpObject = document.getElementById('control_page');
    var x   =  cpObject.style.backgroundColor;
    var rgb = /rgb\((\d+), (\d+), (\d+)\)/.exec(x);
    console.log(rgb);

    var r = rgb[1];
    var g = rgb[2];
    var b = rgb[3];
    var dec = rgbToDec(r,g,b);

    //  Speed/Udc bus gauges Color/Font initialisation
    gaugeSPEED.BackColor  = dec;
    gaugeVdcBUS.BackColor = dec;

    gaugeSPEED.FontID = 1;
    gaugeSPEED.Font = 'Verdana';

    gaugeVdcBUS.FontID = 1;
    gaugeVdcBUS.Font = 'Verdana';

    // generates the table with permanent/pending fault flags
    Errors();

    // Control Page components initialisation at the page onload
    powerClickInput(reference_val_2);
    Speed_Gauge_real_speed(reference_val_4);
    StateMachine(reference_val_6);

    ErrorsCheck();
    //Speed_Gauge_reference_speed(reference_val_5);

    sensorTypeSelectInit();

    if(MotorPrefix!=='')
    {
        // the following routine performs the color setting of the Tab Sheet in MCAT environment
        var motorTab = MotorPrefix;

        // Check which motor is being tuned
        if (motorTab==="M1_")   motorTab = "tabMotor1";
        if (motorTab==="M2_")   motorTab = "tabMotor2";
        if (motorTab==="M3_")   motorTab = "tabMotor3";

        var liObject = parent.document.getElementById(motorTab).getElementsByTagName('a');


        // Set the background color of the sheet according to the displayed page
        liObject[9].className = "active";
        liObject[9].style.background = 'none';
        liObject[9].style.backgroundColor = cpObject.style.backgroundColor;
    }


 }

//OnVariableChanged event generated by FreeMASTER
function Event_OnVariableChanged(IDsubscribedVariable)
{
    StateMachine(reference_val_6);
    ErrorsCheck();

    switch(IDsubscribedVariable){
        case reference_val_1:
            // sensor type changed in FreeMASTER
            sensorTypeInput(IDsubscribedVariable);
            break;
        case reference_val_2:
            powerClickInput(IDsubscribedVariable);
            break;
        case reference_val_3:
            // DC Bus voltage sensing
            Voltage_Gauge(IDsubscribedVariable);
            break;
        case reference_val_4:
            // Speed feedback sensing
            Speed_Gauge_real_speed(IDsubscribedVariable);
            break;
        case reference_val_5:
            // event on speed reference change
            Speed_Gauge_reference_speed(IDsubscribedVariable);
            break;
        case reference_val_6:
            // Application state update
            StateMachine(IDsubscribedVariable);
            break;
        default:
    }
}

/* ------------------ On-Off toggle button routine - ------------------------- */
    function powerClickInput(elementId){
      var object1     = document.getElementById('OnOff_button');

      if(pcm.ReadVariable(elementId)){
      var ValueState  = pcm.LastVariable_vValue;

        if(ValueState){
            object1.className = 'OnOff_button_on';
            object1.value = 'ON';
        }
        else{
            object1.className = 'OnOff_button_off';
            object1.value = 'OFF';
        }
      }
    }

   function powerClickOutput(){
      var object1     = document.getElementById('OnOff_button');
      var retMsg;
      var on_off      = xmlDoc.getElementsByTagName(Mx+"onoff");

      if(pcm.ReadVariable(on_off[0].childNodes[0].nodeValue)){
         var onoffvar = pcm.LastVariable_vValue;

            if(onoffvar === 0){
                onoffvar = 1;
                object1.className = 'OnOff_button_on';
                object1.value = 'ON';
            }
            else{
                onoffvar = 0;
                object1.className = 'OnOff_button_off';
                object1.value = 'OFF';
            }
        }

    succ = pcm.WriteVariable(on_off[0].childNodes[0].nodeValue, onoffvar, retMsg);
    }
/* ---------------- EOF On-Off toggle button routine ------------------------- */

/* ------------------------ Sensor Option init routine --------------------------- */
// initialisation of dropdown menu according to MCAT settings
function sensorTypeSelectInit(){
 var optionObject;
 var selectedSensor;
 var j = 0;
 var pospeArray  =   new Array(4);


 for(var i=0;i<5;i++){ pospeArray[i] = i;}
   // read from main page table
   selectedSensor =  parent.document.getElementById(MotorPrefix+'PospeFbck').innerHTML;
   // read object by ID from CtrlStructurePage
   optionObject = document.getElementById(MotorPrefix + "PoSpeSensorType");

   for(var i=0;i<5;i++)
   {
     pospeArray[i] = j;
     if (((selectedSensor>>>[i])&1) !== 1){
         optionObject.remove(j);}
     else{
         j++;}
   }

   // disable sensor dropdown if only one sensor available
   if(j===1){
      optionObject.disabled = true;
      optionObject.className = 'SensorOff';
   }
}
/* ------------------------ Sensor Option init routine --------------------------- */

/* ------------------------ Sensor Option pop-up menu routines --------------------------- */
   function sensorTypeInput(elementId){
      // Change the sensor type in Cntrl page in case the sensor has been changed in FreeMASTER
      if(pcm.ReadVariable(elementId))
         document.getElementById(Mx+'PoSpeSensorType').selectedIndex = pcm.LastVariable_vValue;
   }

   function sensorTypeOutput(selectedIndex){
      var retMsg;
      var sensorType=xmlDoc.getElementsByTagName(Mx+"swSensor");

      if(reference_val_1)
        // Change the sensor type in FreeMASTER (in target CPU)
        succ = pcm.WriteVariable(sensorType[0].childNodes[0].nodeValue, selectedIndex, retMsg);
      else
        alert('Error! \n Double-check FreeMASTER_Interface.xml and fill the tag <'+MotorPrefix+'_swSensor> ??? <'+MotorPrefix+'_swSensor>');

   }
/* ----------------- End of Sensor Option pop-up menu routines --------------------------- */

/* --------------- DC Bus voltage sensing - gauge setting routine ------------------------- */
    function Voltage_Gauge(elementId){
      if(pcm.ReadVariable(elementId))
      {
        var ValueVoltage = pcm.LastVariable_vValue;
        gaugeVdcBUS.NeedleID = 0;
        gaugeVdcBUS.NeedleValue = ValueVoltage;
      }

    }
/* --------------------- End of Voltage Gauge routine ----------------------- */
/* ------------------------ Speed Gauge routine ----------------------------- */
    function Speed_Gauge_real_speed(elementId){
      if(pcm.ReadVariable(elementId))
      {
        var ValueSpeed = pcm.LastVariable_vValue;
        gaugeSPEED.NeedleID = 0;
        gaugeSPEED.NeedleValue = ValueSpeed;
      }
    }

    function Speed_Gauge_reference_speed(elementId){
       if(in_MethodCtrlVal!==3)
           alert('You cannot control the speed.' + '\n'+ ' Speed Control mode is not selected!');
       //alert(parent.document.getElementById(MotorPrefix+'pospe_ctrl_Select'));

      if(pcm.ReadVariable(elementId))
      {
        var ValueSpeed = pcm.LastVariable_vValue;
        gaugeSPEED.NeedleID = 1;
        gaugeSPEED.NeedleValue = ValueSpeed;
      }
    }
/* --------------------- End of Speed Gauge routine ------------------------- */
/* ---------- Speed Gauge routine - Reference speed given by gauge ---------- */
    function Speed_Gauge_SetUp(){
      var retMsg;
      //xmlDoc=loadXMLDoc("check_list.xml");
      var RequestedSpeed=xmlDoc.getElementsByTagName(Mx+"RequiredSpeed");

      gaugeSPEED.NeedleID = 1;
      succ = pcm.WriteVariable(RequestedSpeed[0].childNodes[0].nodeValue, gaugeSPEED.NeedleValue, retMsg);

    }
/* ---------- Speed Gauge routine - Reference speed given by gauge ---------- */
/* ------------------------ State machine for both motors ------------------- */
function StateMachine(elementId){

      if(pcm.ReadVariable(elementId))
      {
        var ValueState  = pcm.LastVariable_vValue;
        var states      = xmlDoc.getElementsByTagName(Mx+"state");
        // state machine button
        var object1     = document.getElementById('State_machine');
        // state machine label field
        var object2     = document.getElementById('appStateLabel');
        // lOAD BUTTON OBJECT
        var object3     = document.getElementById('Load_button');

        // update text in the state machine button
        object1.value =  states[ValueState].childNodes[0].nodeValue;

        // If FAULT - change the State Machine text field to button / CSS formating
        if(object1.value === 'FAULT' || object1.value === 'Fault')
        {
          object1.className = 'State_machine_button';
          object1.disabled  = false;

          object2.className = 'controlPanelLabel_red';
          object2.innerHTML = 'Clear FAULT';

          // Check Fault status and set all flags
         // ErrorsCheck();
         powerClickInput(reference_val_2);
        }
        else
        {
          object1.className = 'State_machine_text';
          object1.disabled  = true;

          object2.className = 'controlPanelLabel';
          object2.innerHTML = 'Application State';
        }

        if(object1.value === 'Ready' || object1.value === 'READY')
        {
          object3.className = 'Load_button';
          object3.disabled  = false;
        }
        else{
          object3.className = 'Load_button_off';
          object3.disabled  = true;

        }
      }
}
/* ------------------------ State machine for both motors ------------------- */
function ClearFault() {
    var retMsg;
    var object1 = document.getElementById('State_machine');
    var object2 = document.getElementById('appStateLabel');

    object2.innerHTML = "Application State";
    object2.className = "controlPanelLabel";
    object1.disabled = true;
    object1.className = "State_machine_text";
    object1.value = "READY";

    var ClearFaultClick=xmlDoc.getElementsByTagName(Mx+"clrFltvar");

    succ = pcm.WriteVariable(ClearFaultClick[0].childNodes[0].nodeValue,1, retMsg);

    ErrorsCheck();
}

/* ------------------------ State machine for both motors ------------------- */
function loadClick() {
    var retMsg;
    var LoadSettClick=xmlDoc.getElementsByTagName(Mx+"loadSetting");

    succ = pcm.WriteVariable(LoadSettClick[0].childNodes[0].nodeValue,1, retMsg);
}


function build_PoSpe_selector(varID){
    var string = "";

    //get active motor to select with related prefix
    var prefixM = getActiveMotor();

    //add prefix to var ID
    if (prefixM !== '')  var   varIDprefix = prefixM + varID;
    else                 var   varIDprefix = 'M1_' + varID;

    string = string + "<select id=\"" + varIDprefix + "\" class = \"Sensor\" size=\"1\" onChange =\"sensorTypeOutput(this.selectedIndex)\">";
    string = string + "<option value=\"0\">Encoder</option>";
    string = string + "<option value=\"1\">Resolver</option>";
    string = string + "<option value=\"2\">Sensorless</option>";
    string = string + "</select>";

    return string;
}

/* -------------------- Application Faults table generation ------------------------- */
function Errors() {
    var InitText = "";
  //  xmlDoc = loadXMLDoc("check_list.xml");
    errorTag = xmlDoc.getElementsByTagName("error");
    Ername = xmlDoc.getElementsByTagName("errorname");
    fmname = xmlDoc.getElementsByTagName(Mx + "FMNAME");
    states = xmlDoc.getElementsByTagName(Mx + "state");

    InitText += "<table>";

    for (i = 0; i < errorTag.length; i++)
    {

        InitText += "<tr>";

        InitText += "<td id='" + Mx + Ername[i].childNodes[0].nodeValue + "' class='error_off'>" + Ername[i].childNodes[0].nodeValue + "</td>";
        InitText += "<td id='" + Mx + "run_" + Ername[i].childNodes[0].nodeValue + "' class='run_off'></td>";
        i++;

        if (i < errorTag.length)
        {
            InitText += "<td id='" + Mx + Ername[i].childNodes[0].nodeValue + "' class='error_off'>" + Ername[i].childNodes[0].nodeValue + "</td>";
            InitText += "<td id='" + Mx + "run_" + Ername[i].childNodes[0].nodeValue + "' class='run_off'></td>";
        }

        i++;

        if (i < errorTag.length)
        {
            InitText += "<td id='" + Mx + Ername[i].childNodes[0].nodeValue + "' class='error_off'>" + Ername[i].childNodes[0].nodeValue + "</td>";
            InitText += "<td id='" + Mx + "run_" + Ername[i].childNodes[0].nodeValue + "' class='run_off'></td>";
        }
        InitText += "</tr>";
    }

    InitText += "</table>";

    document.getElementById("errors_tab").innerHTML = InitText;
}
/* ----------------- End of application faults table M1 --------------------- */

/* -------------------------- Errors check function ------------------------- */
    function ErrorsCheck(){
      error=    xmlDoc.getElementsByTagName("error");
      fmname=   xmlDoc.getElementsByTagName(Mx+"FMNAME");
      Ername=   xmlDoc.getElementsByTagName("errorname");
      fmrunname=xmlDoc.getElementsByTagName(Mx+"FMRUNNAME");

      for (var i=0;i<error.length;i++)
      {
        if(pcm.ReadVariable(fmname[i].childNodes[0].nodeValue)){
    		  var ValueState = pcm.LastVariable_vValue;
          		if(ValueState === 0){
                document.getElementById(Mx + Ername[i].childNodes[0].nodeValue).className = "error_off";
              }
              else{
                document.getElementById(Mx + Ername[i].childNodes[0].nodeValue).className = "error_on";
              }
	     }
      	else{
                  //window.document.getElementById("txtErrMsg").innerHTML = pcm.LastRetMsg;
                  // bSucc = fmstr.ReadMemory("var32inc", 4);
      	}

        if(pcm.ReadVariable(fmrunname[i].childNodes[0].nodeValue)){
            		var ValueState = pcm.LastVariable_vValue;
            		if(ValueState === 0){
                    document.getElementById(Mx+"run_" + Ername[i].childNodes[0].nodeValue).className = "run_off";
                    }
                else{
                    document.getElementById(Mx+"run_" + Ername[i].childNodes[0].nodeValue).className = "run_on";
                    }
        }
      	else{
                  //window.document.getElementById("txtErrMsg").innerHTML = pcm.LastRetMsg;
            }
      }
    }

    function clearErrorFlags(){
      error=    xmlDoc.getElementsByTagName("error");
      fmname=   xmlDoc.getElementsByTagName(Mx+"FMNAME");
      Ername=   xmlDoc.getElementsByTagName("errorname");
      fmrunname=xmlDoc.getElementsByTagName(Mx+"FMRUNNAME");

      var errorFlag = 0;

      for (var i=0;i<error.length;i++)
      {
        if(pcm.ReadVariable(fmname[i].childNodes[0].nodeValue)){
		var ValueState = pcm.LastVariable_vValue;
		if(ValueState == 0){
                    document.getElementById(Mx + Ername[i].childNodes[0].nodeValue).className = "error_off";
                    }
                else{
                    document.getElementById(Mx + Ername[i].childNodes[0].nodeValue).className = "error_on";
                    errorFlag = 1;
                    }
	}
	else{
            //window.document.getElementById("txtErrMsg").innerHTML = pcm.LastRetMsg;
	}

        if(pcm.ReadVariable(fmrunname[i].childNodes[0].nodeValue)){
		var ValueState = pcm.LastVariable_vValue;
		if(ValueState == 0){
                    document.getElementById(Mx+"run_" + Ername[i].childNodes[0].nodeValue).className = "run_off";
                    }
                else{
                    document.getElementById(Mx+"run_" + Ername[i].childNodes[0].nodeValue).className = "run_on";
                    errorFlag = 1;
                    }
        }
	else{
            //window.document.getElementById("txtErrMsg").innerHTML = pcm.LastRetMsg;
        }
      }

     return errorFlag;
    }
/* -------------------- End of Errors check function  ----------------------- */



/***************************************************************************//*!
 *
 * @brief   The function return number of active motor
 * @param
 * @return  motor number
 * @remarks
 ******************************************************************************/
function getActiveMotor()
{
    var object1 = null;
    var object2 = null;
    var object3 = null;

    object1 = parent.document.getElementById("Motor1Radio");
    object2 = parent.document.getElementById("Motor2Radio");
    object3 = parent.document.getElementById("Motor3Radio");


    if (object1){
        if (object1.checked){
            return 'M1_';
        }
        else if (object2.checked){
            return 'M2_';
        }
        else if (object3.checked){
            return 'M3_';
        }
    }
    else
    {
        return '';
    }
}

//////////////////////////////
function rgbToDec(r,g,b)
{
    var x = (Number(b)*65536 + Number(g)*256 + Number(r));

    return (x);
}

function LeaveCntrPage(){
    var motorTab = getActiveMotor();

    if (motorTab!==''){
        if (motorTab==="M1_")     motorTab = "tabMotor1";
        if (motorTab==="M2_")     motorTab = "tabMotor2";
        if (motorTab==="M3_")     motorTab = "tabMotor3";

        var liObject = parent.document.getElementById(motorTab).getElementsByTagName('a');
        liObject[9].style.backgroundColor = liObject[1].style.backgroundColor;
    }
}

/* -----------------------  loadXMLDoc() routine -----------------------------*/
function loadXMLDoc(dname)
{
    try //Internet Explorer
    {
        xmlDoc = new ActiveXObject("Msxml2.DOMDocument.3.0");
    }
    catch (e)
    {
        try //Firefox, Mozilla, Opera, etc.
        {
            xmlDoc = document.implementation.createDocument("", "", null);
        }
        catch (e) {
            alert(e.message)
        }
    }
    try
    {
        xmlDoc.async = false;
        xmlDoc.load(dname);
        return(xmlDoc);
    }
    catch (e) {
        alert(e.message)
    }
    return(null);
}

/* -----------------------  Voltage Gauge routine -----------------------------*/
function loadVoltageGauge()
{
    //Get the necessary parameters
    var UDCmax = getParentHtmlValue('UDC_max');
    var UDCtrip = getParentHtmlValue('UDC_trip');
    var UDCunder = getParentHtmlValue('UDC_under');
    var UDCover = getParentHtmlValue('UDC_over');
    var UDCtick = 0;
    var UDCtickNo = 5;

    if(UDCtrip > UDCmax)  { UDCtrip = UDCmax;}
    if(UDCunder > UDCmax)  { UDCunder = UDCmax;}
    if(UDCover > UDCmax)  { UDCover = UDCmax;}
    if(UDCtrip > UDCover)  { UDCtrip = UDCover;}

    //Calculate the number of ticks
    var UDCnumerator = 1000;
    while(UDCtick === 0)
    {
        if((UDCmax === 0)||(UDCmax === undefined))
        {
          alert("Error");
          UDCtick = 6;
          UDCmax = 25;
          break;
        }
        UDCtick= Math.round(UDCmax/UDCnumerator/UDCtickNo)*(UDCnumerator);

        UDCnumerator = UDCnumerator / 10;
    }
    if((UDCtick*UDCtickNo)>UDCmax)
        UDCtick = UDCtick/2;

    // alert("Values: UDCmax = " + UDCmax + ", UDCtick = " + UDCtick+ ", UDCtickNo = " + UDCtickNo);

    document.write("<OBJECT  id=\"gaugeVdcBUS\" width=\"220\" height=\"88\" codeBase=\"agauge.cab\" classid=\"clsid:B2E0C2EA-A543-11CF-BC8C-207402C10627\">");
    document.write("<param name=\"_Version\" value=\"131082\">");
    document.write("<param name=\"_ExtentX\" value=\"8000\">");
    document.write("<param name=\"_ExtentY\" value=\"2461\">");
    document.write("<param name=\"_StockProps\" value=\"70\">");
    document.write("<param name=\"Caption\" value>");
    document.write("<param name=\"Enabled\" value=\"-1\">");
    document.write("<param name=\"BackColor\" value=\"14540253\">");
    document.write("<param name=\"AutoRedraw\" value=\"-1\">");
    document.write("<param name=\"BevelInner\" value=\"0\">");
    document.write("<param name=\"BevelOuter\" value=\"1\">");
    document.write("<param name=\"BevelWidth\" value=\"0\">");
    document.write("<param name=\"BorderWidth\" value=\"0\">");
    document.write("<param name=\"BorderType\" value=\"1\">");
    document.write("<param name=\"Outline\" value=\"0\">");
    document.write("<param name=\"OutlineAlign\" value=\"0\">");
    document.write("<param name=\"OutlineColor\" value=\"0\">");
    document.write("<param name=\"OutlineTitle\" value=\"PMSM\">");
    document.write("<param name=\"OutlineWidth\" value=\"1\">");
    document.write("<param name=\"FocusOutline\" value=\"0\">");
    document.write("<param name=\"FrameBottom\" value=\"1.15\">");
    document.write("<param name=\"FrameColor\" value=\"8421440\">");
    document.write("<param name=\"FrameLeft\" value=\"-0.95\">");
    document.write("<param name=\"FrameRight\" value=\"1.15\">");
    document.write("<param name=\"FrameShape??0\" value=\"0,100, 100,0, 900,0, 1000,100, 1000,900, 900,1000, 100,1000, 0,900\">");
    document.write("<param name=\"FrameStyle\" value=\"0\">");
    document.write("<param name=\"FrameTop\" value=\"-1.15\">");
    document.write("<param name=\"ScaleSize\" value=\"1\">");
    document.write("<param name=\"ScaleDirection0\" value=\"0\">");
    document.write("<param name=\"ScaleMaxValue0\" value=\""+UDCmax+"\">");
    document.write("<param name=\"ScaleMinValue0\" value=\"0\">");
    document.write("<param name=\"ScaleOriginX0\" value=\"-0.07\">");
    document.write("<param name=\"ScaleOriginY0\" value=\"-5.5\">");
    document.write("<param name=\"ScaleStartAngle0\" value=\"335\">");
    document.write("<param name=\"ScaleStopAngle0\" value=\"25\">");
    document.write("<param name=\"FontSize\" value=\"2\">");
    document.write("<param name=\"CaptionSize\" value=\"2\">");
    document.write("<param name=\"CaptionColor0\" value=\"0\">");
    document.write("<param name=\"CaptionFontID0\" value=\"1\">");
    document.write("<param name=\"Caption0\" value=\"DC Bus Voltage\">");
    document.write("<param name=\"CaptionX0\" value=\"0\">");
    document.write("<param name=\"CaptionY0\" value=\"-0.28\">");
    document.write("<param name=\"CaptionAlign0\" value=\"2\">");
    document.write("<param name=\"CaptionVisible0\" value=\"-1\">");
    document.write("<param name=\"CaptionFlag0\" value=\"0\">");
    document.write("<param name=\"CaptionColor1\" value=\"0\">");
    document.write("<param name=\"CaptionFontID1\" value=\"1\">");
    document.write("<param name=\"Caption1\" value=\"[V]\">");
    document.write("<param name=\"CaptionX1\" value=\"0\">");
    document.write("<param name=\"CaptionY1\" value=\"-0.68\">");
    document.write("<param name=\"CaptionAlign1\" value=\"2\">");
    document.write("<param name=\"CaptionVisible1\" value=\"-1\">");
    document.write("<param name=\"CaptionFlag1\" value=\"0\">");
    document.write("<param name=\"CaptionFlag2\" value=\"0\">");

    document.write("<param name=\"AnnularSize\" value=\"5\">");

    document.write("<param name=\"AnnularColor0\" value=\"8454143\">");
    document.write("<param name=\"AnnularFloat0\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset0\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius0\" value=\"5.75\">");
    document.write("<param name=\"AnnularOuterRadius0\" value=\"6\">");
    document.write("<param name=\"AnnularScaleID0\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue0\" value=\""+UDCunder+"\">");
    document.write("<param name=\"AnnularStopValue0\" value=\""+(UDCunder/0.91)+"\">");
    document.write("<param name=\"AnnularVisible0\" value=\"-1\">");

    document.write("<param name=\"AnnularColor1\" value=\"6348713\">");
    document.write("<param name=\"AnnularFloat1\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset1\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius1\" value=\"5.75\">");
    document.write("<param name=\"AnnularOuterRadius1\" value=\"6\">");
    document.write("<param name=\"AnnularScaleID1\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue1\" value=\""+(UDCunder/0.91)+"\">");
    document.write("<param name=\"AnnularStopValue1\" value=\""+UDCtrip+"\">");
    document.write("<param name=\"AnnularVisible1\" value=\"-1\">");

    document.write("<param name=\"AnnularColor2\" value=\"8454143\">");
    document.write("<param name=\"AnnularFloat2\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset2\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius2\" value=\"5.75\">");
    document.write("<param name=\"AnnularOuterRadius2\" value=\"6\">");
    document.write("<param name=\"AnnularScaleID2\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue2\" value=\""+UDCtrip+"\">");
    document.write("<param name=\"AnnularStopValue2\" value=\""+UDCover+"\">");
    document.write("<param name=\"AnnularVisible2\" value=\"-1\">");

    document.write("<param name=\"AnnularColor3\" value=\"500\">");
    document.write("<param name=\"AnnularFloat3\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset3\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius3\" value=\"5.75\">");
    document.write("<param name=\"AnnularOuterRadius3\" value=\"6\">");
    document.write("<param name=\"AnnularScaleID3\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue3\" value=\""+UDCover+"\">");
    document.write("<param name=\"AnnularStopValue3\" value=\""+UDCmax+"\">");
    document.write("<param name=\"AnnularVisible3\" value=\"-1\">");

    document.write("<param name=\"AnnularColor4\" value=\"500\">");
    document.write("<param name=\"AnnularFloat4\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset4\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius4\" value=\"5.75\">");
    document.write("<param name=\"AnnularOuterRadius4\" value=\"6\">");
    document.write("<param name=\"AnnularScaleID4\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue4\" value=\"0\">");
    document.write("<param name=\"AnnularStopValue4\" value=\""+(UDCunder)+"\">");
    document.write("<param name=\"AnnularVisible4\" value=\"-1\">");

    document.write("<param name=\"HubSize\" value=\"0\">");
    document.write("<param name=\"NeedleSize\" value=\"1\">");
    document.write("<param name=\"NeedleColor0\" value=\"9072936\">");
    document.write("<param name=\"NeedleDigital0\" value=\"0\">");
    document.write("<param name=\"NeedleDigitalColor0\" value=\"0\">");
    document.write("<param name=\"NeedleDigitalDecimals0\" value=\"0\">");
    document.write("<param name=\"NeedleDigitalFontID0\" value=\"0\">");
    document.write("<param name=\"NeedleDigitalX0\" value=\"0\">");
    document.write("<param name=\"NeedleDigitalY0\" value=\"0\">");
    document.write("<param name=\"NeedleLength0\" value=\"5.60\">");
    document.write("<param name=\"NeedleMouseControl0\" value=\"0\">");
    document.write("<param name=\"NeedleScaleID0\" value=\"0\">");
    document.write("<param name=\"NeedleShape??0\" value>");
    document.write("<param name=\"NeedleStyle0\" value=\"0\">");
    document.write("<param name=\"NeedleValue0\" value=\"0\">");
    document.write("<param name=\"NeedleWidth0\" value=\"0.04\">");
    document.write("<param name=\"NeedleVisible0\" value=\"-1\">");
    document.write("<param name=\"NeedleClip0\" value=\"-1\">");
    document.write("<param name=\"TicSize\" value=\"5\">");
    document.write("<param name=\"TicColor0\" value=\"0\">");
    document.write("<param name=\"TicFloat0\" value=\"0\">");
    document.write("<param name=\"TicDeltaValue0\" value=\""+UDCtick+"\">");
    document.write("<param name=\"TicFloatOffset0\" value=\"0\">");
    document.write("<param name=\"TicFontID0\" value=\"0\">");
    document.write("<param name=\"TicInnerRadius0\" value=\"5.75\">");
    document.write("<param name=\"TicLabel0\" value=\"-1\">");
    document.write("<param name=\"TicLabelRadius0\" value=\"6.5\">");
    document.write("<param name=\"TicLabelRotated0\" value=\"0\">");
    document.write("<param name=\"TicOuterRadius0\" value=\"6.2\">");
    document.write("<param name=\"TicScaleID0\" value=\"0\">");
    document.write("<param name=\"TicStartValue0\" value=\"0\">");
    document.write("<param name=\"TicStopValue0\" value=\""+UDCmax+"\">");
    document.write("<param name=\"TicStyle0\" value=\"0\">");
    document.write("<param name=\"TicWidth0\" value=\"0\">");
    document.write("<param name=\"TicVisible0\" value=\"-1\">");
    document.write("<param name=\"TicAutoTic0\" value=\"0\">");
    document.write("<param name=\"TicCount0\" value=\""+UDCtickNo+"\">");
    document.write("<param name=\"TicSubCount0\" value=\"0\">");
    document.write("<param name=\"TicColor1\" value=\"0\">");
    document.write("<param name=\"TicFloat1\" value=\"0\">");
    document.write("<param name=\"TicDeltaValue1\" value=\""+(UDCtick/UDCtickNo)+"\">");
    document.write("<param name=\"TicFloatOffset1\" value=\"0\">");
    document.write("<param name=\"TicFontID1\" value=\"0\">");
    document.write("<param name=\"TicInnerRadius1\" value=\"5.75\">");
    document.write("<param name=\"TicLabel1\" value=\"0\">");
    document.write("<param name=\"TicLabelRadius1\" value=\"1\">");
    document.write("<param name=\"TicLabelRotated1\" value=\"0\">");
    document.write("<param name=\"TicOuterRadius1\" value=\"6\">");
    document.write("<param name=\"TicScaleID1\" value=\"0\">");
    document.write("<param name=\"TicStartValue1\" value=\"0\">");
    document.write("<param name=\"TicStopValue1\" value=\""+UDCmax+"\">");
    document.write("<param name=\"TicStyle1\" value=\"0\">");
    document.write("<param name=\"TicWidth1\" value=\"0\">");
    document.write("<param name=\"TicVisible1\" value=\"-1\">");
    document.write("<param name=\"TicAutoTic1\" value=\"0\">");
    document.write("<param name=\"TicCount1\" value=\""+UDCtickNo+"\">");
    document.write("<param name=\"TicSubCount1\" value=\"0\">");
    document.write("</OBJECT>");

}

/* -----------------------  Speed Gauge routine -----------------------------*/
function loadSpeedGauge()
{
    //Get the necessary parameters
    var Nnom = getParentHtmlValue('N_nom');
    var Nmax = getParentHtmlValue('N_max');
    var Ntick = 0;
    var NtickNo = 6;
    var Nmerge2 = getParentHtmlValue('STARTUP_MERG_SPEED_2');


    var Nmax_MCAT = Nmax;

    if(Nnom > Nmax)
      Nnom = Nmax;

    //Calculate the number of ticks
    var Nnumerator = 100000;
    while(Ntick === 0)
    {
        if((Nmax === 0)||(Nmax === undefined))
        {
          alert("Error");
          Ntick = 1000;
          Nmax = 10000;
          break;
        }
        // Round-up Nmax
        Nmax = Math.ceil(Nmax/1000)*1000;;
        Ntick = Math.round(Nmax/Nnumerator/NtickNo)*(Nnumerator);
        Nnumerator = Nnumerator / 10;
    }

	var isSensorless = 0;
	var valDec = new Array(4);
	valDec[1] = 0;
	valDec[2] = 0;
	valDec[3] = 0;

	var activeMotor = getActiveMotor()[1] - '0';

	// valDec[activeMotor]  = parent.document.getElementById('M'+[activeMotor]+'_TabManager').innerHTML ;
	// if(((valDec[activeMotor])>>>6)&1)
	// {
	// 	isSensorless = 1;
	// 	//alert(activeMotor + ": Sensorless enabled");
	// }

    document.write("<OBJECT width=\"220\" height=\"176\" id=\"gaugeSPEED\" codeBase=\"agauge.cab\" classid=\"clsid:B2E0C2EA-A543-11CF-BC8C-207402C10627\">");
    document.write("<param name=\"_Version\" value=\"131082\">");
    document.write("<param name=\"_ExtentX\" value=\"8000\">");
    document.write("<param name=\"_ExtentY\" value=\"5371\">");
    document.write("<param name=\"_StockProps\" value=\"70\">");
    document.write("<param name=\"Caption\" value>");
    document.write("<param name=\"Enabled\" value=\"-1\">");
    document.write("<param name=\"BackColor\" value=\"14540253\">");
    document.write("<param name=\"AutoRedraw\" value=\"-1\">");
    document.write("<param name=\"BevelInner\" value=\"0\">");
    document.write("<param name=\"BevelOuter\" value=\"1\">");
    document.write("<param name=\"BevelWidth\" value=\"0\">");
    document.write("<param name=\"BorderWidth\" value=\"0\">");
    document.write("<param name=\"BorderType\" value=\"1\">");
    document.write("<param name=\"Outline\" value=\"0\">");
    document.write("<param name=\"OutlineAlign\" value=\"2\">");
    document.write("<param name=\"OutlineColor\" value=\"0\">");
    document.write("<param name=\"OutlineTitle\" value>");
    document.write("<param name=\"OutlineWidth\" value=\"1\">");
    document.write("<param name=\"FocusOutline\" value=\"0\">");
    document.write("<param name=\"FrameBottom\" value=\"1.29\">");
    document.write("<param name=\"FrameColor\" value=\"8421440\">");
    document.write("<param name=\"FrameLeft\" value=\"-2.25\">");
    document.write("<param name=\"FrameRight\" value=\"2.25\">");
    document.write("<param name=\"FrameShape??0\" value=\"0,180, 100,0, 900,0, 1000,180, 1000,820, 900,1000, 100,1000, 0,820\">");
    document.write("<param name=\"FrameStyle\" value=\"0\">");
    document.write("<param name=\"FrameTop\" value=\"-1.5\">");
    document.write("<param name=\"ScaleSize\" value=\"1\">");
    document.write("<param name=\"ScaleDirection0\" value=\"0\">");
    document.write("<param name=\"ScaleMaxValue0\" value=\""+Nmax+"\">");
    document.write("<param name=\"ScaleMinValue0\" value=\"-"+Nmax+"\">");
    document.write("<param name=\"ScaleOriginX0\" value=\"0\">");
    document.write("<param name=\"ScaleOriginY0\" value=\"-0.45\">");
    document.write("<param name=\"ScaleStartAngle0\" value=\"245\">");
    document.write("<param name=\"ScaleStopAngle0\" value=\"115\">");
    document.write("<param name=\"FontSize\" value=\"2\">");
    document.write("<param name=\"CaptionSize\" value=\"2\">");
    document.write("<param name=\"CaptionColor0\" value=\"#450000\">");
    document.write("<param name=\"CaptionFontID0\" value=\"1\">");
    document.write("<param name=\"Caption0\" value=\"Speed\">");
    document.write("<param name=\"CaptionX0\" value=\"0\">");
    document.write("<param name=\"CaptionY0\" value=\"-0.7\">");
    document.write("<param name=\"CaptionAlign0\" value=\"2\">");
    document.write("<param name=\"CaptionVisible0\" value=\"-1\">");
    document.write("<param name=\"CaptionFlag0\" value=\"0\">");
    document.write("<param name=\"CaptionColor1\" value=\"#450000\">");
    document.write("<param name=\"CaptionFontID1\" value=\"1\">");
    document.write("<param name=\"Caption1\" value=\"[rpm]\">");
    document.write("<param name=\"CaptionX1\" value=\"0\">");
    document.write("<param name=\"CaptionY1\" value=\"-0.9\">");
    document.write("<param name=\"CaptionAlign1\" value=\"2\">");
    document.write("<param name=\"CaptionVisible1\" value=\"-1\">");
    document.write("<param name=\"CaptionFlag1\" value=\"0\">");

    if((Nmerge2 != null)&&(isSensorless == 1))
      document.write("<param name=\"AnnularSize\" value=\"4\">");
    else
      document.write("<param name=\"AnnularSize\" value=\"3\">");

    //red - App. max speed round up to 1000
    document.write("<param name=\"AnnularColor0\" value=\"500\">");
    document.write("<param name=\"AnnularFloat0\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset0\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius0\" value=\"0.90\">");
    document.write("<param name=\"AnnularOuterRadius0\" value=\"1\">");
    document.write("<param name=\"AnnularScaleID0\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue0\" value=\"-"+Nmax+"\">");
    document.write("<param name=\"AnnularStopValue0\" value=\""+Nmax+"\">");
    document.write("<param name=\"AnnularVisible0\" value=\"-1\">");

    //yellow - nominal speed up to Application Nmax speed
    document.write("<param name=\"AnnularColor1\" value=\"8454143\">");
    document.write("<param name=\"AnnularFloat1\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset1\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius1\" value=\"0.90\">");
    document.write("<param name=\"AnnularOuterRadius1\" value=\"1\">");
    document.write("<param name=\"AnnularScaleID1\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue1\" value=\"-"+Nmax_MCAT+"\">");
    document.write("<param name=\"AnnularStopValue1\" value=\""+Nmax_MCAT+"\">");
    document.write("<param name=\"AnnularVisible1\" value=\"-1\">");

    //green - nominal speed range
    document.write("<param name=\"AnnularColor2\" value=\"6348713\">");
    document.write("<param name=\"AnnularFloat2\" value=\"0\">");
    document.write("<param name=\"AnnularFloatOffset2\" value=\"0\">");
    document.write("<param name=\"AnnularInnerRadius2\" value=\"0.90\">");
    document.write("<param name=\"AnnularOuterRadius2\" value=\"1\">");
    document.write("<param name=\"AnnularScaleID2\" value=\"0\">");
    document.write("<param name=\"AnnularStartValue2\" value=\"-"+Nnom+"\">");
    document.write("<param name=\"AnnularStopValue2\" value=\""+Nnom+"\">");
    document.write("<param name=\"AnnularVisible2\" value=\"-1\">");

    if((Nmerge2 != null)&&(isSensorless == 1))
    {
      //yellow - open-loop speed up to Merge 2 speed
      document.write("<param name=\"AnnularColor3\" value=\"8454143\">");
      document.write("<param name=\"AnnularFloat3\" value=\"0\">");
      document.write("<param name=\"AnnularFloatOffset3\" value=\"0\">");
      document.write("<param name=\"AnnularInnerRadius3\" value=\"0.90\">");
      document.write("<param name=\"AnnularOuterRadius3\" value=\"1\">");
      document.write("<param name=\"AnnularScaleID3\" value=\"0\">");
      document.write("<param name=\"AnnularStartValue3\" value=\"-"+Nmerge2+"\">");
      document.write("<param name=\"AnnularStopValue3\" value=\""+Nmerge2+"\">");
      document.write("<param name=\"AnnularVisible3\" value=\"-1\">");
    }

    document.write("<param name=\"HubSize\" value=\"2\">");
    document.write("<param name=\"HubColor0\" value=\"9072936\">");
    document.write("<param name=\"HubRadius0\" value=\"0.06\">");
    document.write("<param name=\"HubScaleID0\" value=\"0\">");
    document.write("<param name=\"HubStyle0\" value=\"0\">");
    document.write("<param name=\"HubVisible0\" value=\"-1\">");
    document.write("<param name=\"HubColor1\" value=\"470\">");
    document.write("<param name=\"HubRadius1\" value=\"0.03\">");
    document.write("<param name=\"HubScaleID1\" value=\"0\">");
    document.write("<param name=\"HubStyle1\" value=\"1\">");
    document.write("<param name=\"HubVisible1\" value=\"-1\">");
    document.write("<PARAM NAME=\"NeedleSize\" VALUE=\"2\">");
    document.write("<PARAM NAME=\"NeedleDigitalFontID0\" VALUE=\"1\">");
    document.write("<PARAM NAME=\"NeedleDigitalY0\" VALUE=\"-0.68\">");
    document.write("<PARAM NAME=\"NeedleLength0\" VALUE=\"0.8\">");
    document.write("<PARAM NAME=\"NeedleWidth0\" VALUE=\"0.03\">");
    document.write("<PARAM NAME=\"NeedleStyle0\" VALUE=\"0\">");
    document.write("<PARAM NAME=\"NeedleVisible0\" VALUE=\"-1\">");
    document.write("<PARAM NAME=\"NeedleColor0\" VALUE=\"9072936\">");
    document.write("<PARAM NAME=\"NeedleColor1\" VALUE=\"470\">");
    document.write("<PARAM NAME=\"NeedleLength1\" VALUE=\"0.8\">");
    document.write("<PARAM NAME=\"NeedleWidth1\" VALUE=\"0.03\">");
    document.write("<PARAM NAME=\"NeedleMouseControl1\" VALUE=\"2\">");
    document.write("<PARAM NAME=\"NeedleValue1\" VALUE=\"0\">");
    document.write("<PARAM NAME=\"NeedleWidth1\" VALUE=\"0.05\">");
    document.write("<PARAM NAME=\"NeedleVisible1\" VALUE=\"-1\">");
    document.write("<PARAM NAME=\"NeedleClip1\" VALUE=\"-1\">");
    document.write("<param name=\"TicSize\" value=\"2\">");
    document.write("<param name=\"TicColor0\" value=\"0\">");
    document.write("<param name=\"TicFloat0\" value=\"0\">");
    document.write("<param name=\"TicDeltaValue0\" value=\""+Ntick+"\">");
    document.write("<param name=\"TicFloatOffset0\" value=\"0\">");
    document.write("<param name=\"TicFontID0\" value=\"0\">");
    document.write("<param name=\"TicInnerRadius0\" value=\"0.9\">");
    document.write("<param name=\"TicLabel0\" value=\"-1\">");
    document.write("<param name=\"TicLabelRadius0\" value=\"1.30\">");
    document.write("<param name=\"TicLabelRotated0\" value=\"0\">");
    document.write("<param name=\"TicOuterRadius0\" value=\"1.10\">");
    document.write("<param name=\"TicScaleID0\" value=\"0\">");
    document.write("<param name=\"TicStartValue0\" value=\"-"+Nmax+"\">");
    document.write("<param name=\"TicStopValue0\" value=\""+Nmax+"\">");
    document.write("<param name=\"TicStyle0\" value=\"0\">");
    document.write("<param name=\"TicWidth0\" value=\"0.0\">");
    document.write("<param name=\"TicVisible0\" value=\"-1\">");
    document.write("<param name=\"TicAutoTic0\" value=\"0\">");
    document.write("<param name=\"TicCount0\" value=\""+NtickNo+"\">");
    document.write("<param name=\"TicSubCount0\" value=\"0\">");
    document.write("<param name=\"TicColor1\" value=\"0\">");
    document.write("<param name=\"TicFloat1\" value=\"0\">");
    document.write("<param name=\"TicDeltaValue1\" value=\""+(Ntick/4)+"\">");
    document.write("<param name=\"TicFloatOffset1\" value=\"0\">");
    document.write("<param name=\"TicFontID1\" value=\"0\">");
    document.write("<param name=\"TicInnerRadius1\" value=\"0.9\">");
    document.write("<param name=\"TicLabel1\" value=\"0\">");
    document.write("<param name=\"TicLabelRadius1\" value=\"0.8\">");
    document.write("<param name=\"TicLabelRotated1\" value=\"0\">");
    document.write("<param name=\"TicOuterRadius1\" value=\"1.00\">");
    document.write("<param name=\"TicScaleID1\" value=\"0\">");
    document.write("<param name=\"TicStartValue1\" value=\"-"+Nmax+"\">");
    document.write("<param name=\"TicStopValue1\" value=\""+Nmax+"\">");
    document.write("<param name=\"TicStyle1\" value=\"0\">");
    document.write("<param name=\"TicWidth1\" value=\"0\">");
    document.write("<param name=\"TicVisible1\" value=\"-1\">");
    document.write("<param name=\"TicAutoTic1\" value=\"0\">");
    document.write("<param name=\"TicCount1\" value=\""+NtickNo+"\">");
    document.write("<param name=\"TicSubCount1\" value=\"0\">");
    document.write("</OBJECT>");

//alert("NtickNo = " + NtickNo + ", Nmax = " + Nmax + ", Ntik = " + Ntick);;
}

function getParentHtmlValue(valueId)
{
    var object      = null;

    if((document.getElementById("settingTab") != undefined)||(document.getElementById("mainPageTab") != undefined))
    {
        // add prefix to var ID
        object = parent.document.getElementById(valueId).innerHTML;
    }
    else
    {
      //get active motor to select proper prefix
      var prefixM = getActiveMotor();
      // add prefix to var ID
      try{
        object = Number(parent.document.getElementById(prefixM + valueId).innerHTML);
      }
      catch(err){
        //window.alert(("getParentHtmlValue: " + prefixM + valueId).toString());
        window.alert(err + "\n" + ("getParentHtmlValue: " + prefixM + valueId).toString());
      };
    }

    return (object);
    }
