/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	ATO.h
*
* @author:	B34195
*
* @date: 	June, 2017
*
* @brief: 	Header file containing the structure with ATO variables and parameters
*
***************************************************************************/
#ifndef BSP_ATO_H_
#define BSP_ATO_H_

#include "SWLIBS_Typedefs.h"
#include "gflib.h"
#include "gdflib.h"
#include "amclib.h"

#include "Resolver.h"
#include "Encoder.h"

/*------------------------------------------------------------------------*//*!
@brief  Structure defines the raw and filtered value
*//*-------------------------------------------------------------------------*/
typedef struct
{
    tFloat    raw;   /*! raw value */
    tFloat    filt;  /*! filtered value */
}filtSpeed_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ATO position/speed variables, PIr, Integrator, Filter
*//*-------------------------------------------------------------------------*/
typedef struct
{
	tFloat          fltThRotErr;		// Position (theta) error entering the ATO algorithm
	tFloat          fltThRotMec;		// Mechanical (0-360deg) position
	tFloat          fltThRotEl;			// Electrical position of the motor

	tFloat          fltThRotElOffset;	// Electrical position of the motor

	filtSpeed_t     wRotMec;			// Angular mechanical speed [rads-1] of the motor
	filtSpeed_t     wRotEl;				// Angular electrical speed [rads-1] of the motor

	tFloat			fltmotorPP;			// number of motor pole-pairs
    tFrac32			s32motorPPscale;            // Scale of motor pole pairs - fixed point interpretation
    tS16			s16motorPPscaleShift;       // Scale of motor pole pairs - fixed point interpretation

    AMCLIB_TRACK_OBSRV_T_FLT    ATO;		// Angle tracking observer
    GDFLIB_FILTER_MA_T          filterMA;	// Moving average filter setting

} ATO_observer_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool ATO_clear_module(ATO_observer_t *ptr);
extern tBool ATO_calculation(ATO_observer_t *ptr);
extern tBool ATO_get_position_el(ATO_observer_t *ptr);
extern tBool ATO_get_w_speed_el(ATO_observer_t *ptr);

extern tBool ATO_theta_err_calc_resolver(ATO_observer_t *ato_ptr, resolver_data_t *ptr );
extern tBool ATO_theta_err_calc_encoder(ATO_observer_t *ato_ptr, encoder_data_t *ptr);
//extern tBool ATO_ThErrCalcBemfObs(ATO_observer_t *ato_ptr); // TBD

#endif /* BSP_ATO_H_ */
