/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Current_meas.h
*
* @author:	B34195
*
* @date: 	Aug 15, 2016
*
* @brief: 	Header file containing definition of current (phase, DcBus) sensor
*           hardware dependent layer software component, with hw-configuration
*           and data structures
*
***************************************************************************/
#ifndef BSP_CURRENT_MEAS_H_
#define BSP_CURRENT_MEAS_H_

#include "SWLIBS_Typedefs.h"
#include "mlib.h"
#include "gdflib.h"

/******************************************************************************
| defines and macros
|----------------------------------------------------------------------------*/

    /*  ADC base address
     *  resAdc0 = 0xFBE00000
     *  resAdc1 = 0xFFE04000
     *  resAdc2 = 0xFBE08000
     *  resAdc3 = 0xFFE0C000
     *
     *  ADC Channel Data Register offset
     *  ADC_CDRn	= 0x100
     */

/*! Different HW configuration available */
#define CURR_HW_PCIe_J1			1
#define CURR_HW_PCIe_J200		2

/*! Macro containing the base address of all ADC modules */
#define CURR_ADC0_BASE			0xFBE00000
#define CURR_ADC1_BASE			0xFFE04000
#define CURR_ADC2_BASE			0xFBE08000
#define CURR_ADC3_BASE			0xFFE0C000

/*! Macro containing the offset address of ADC channel data register */
#define ADC_CDRn_OFFSET			0x100

/*! Macro containing the ADC channel number	*/
#define CURR_ADC_CH0				0
#define CURR_ADC_CH1				1
#define CURR_ADC_CH4				4
#define CURR_ADC_CH5				5

#define CURR_ADC_CH10			10
#define CURR_ADC_CH11			11
#define CURR_ADC_CH12			12
#define CURR_ADC_CH13			13
#define CURR_ADC_CH15			15

/*! Macro containing current measurement calibration counter 	*/
#define CURR_CALIB_CNTR			1000

/*------------------------------------------------------------------------*//*!
@brief  Structure of pointers to related phase current ADC data register
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU32	* pAdcIphAdata;
    volatile tU32	* pAdcIphBdata;
    volatile tU32	* pAdcIphCdata;
}ph_current_meas_hw_cfg_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure of pointer to related DC-bus current ADC data register
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU32	* pAdcIdcdata;
}dcb_current_meas_hw_cfg_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... calibration parameters
*//*-------------------------------------------------------------------------*/
typedef struct{
	volatile tU16	calibCntr;
	volatile tU16	calibDone;
	volatile tU16	calibInitDone;
}phCurrent_calib_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure contains data of measured phase currents, DC offsets and MA filter
*//*-------------------------------------------------------------------------*/
typedef struct{
	SWLIBS_3Syst_FLT 	raw;
	SWLIBS_3Syst_FLT 	filt;
	SWLIBS_3Syst_FLT 	dcOffset;

	phCurrent_calib_t 	calib;

	tU32				svmSector;   // Space Vector Modulation sector

    GDFLIB_FILTER_MA_T  MAF_PhA;	 // Moving average filter setting
    GDFLIB_FILTER_MA_T  MAF_PhB;	 // Moving average filter setting
    GDFLIB_FILTER_MA_T  MAF_PhC;	 // Moving average filter setting

}ph_current_meas_data_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure contains data of measured DC-bus currents
*//*-------------------------------------------------------------------------*/
typedef struct{
	volatile tFloat I_dcb;

}dcb_current_meas_data_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/

extern tBool PhCurrent_meas_hw_init(ph_current_meas_hw_cfg_t *hw_ptr, tU16 currentID);
extern tBool DcbCurrent_meas_hw_init(dcb_current_meas_hw_cfg_t *hw_ptr, tU16 currentID);

extern tBool PhCurrent3Ph_get_data(ph_current_meas_hw_cfg_t *hw_ptr ,ph_current_meas_data_t *d_ptr, tFloat Imax);
extern tBool PhCurrent2Ph_get_data(ph_current_meas_hw_cfg_t *hw_ptr ,ph_current_meas_data_t *d_ptr, tFloat Imax);

extern tBool PhCurrent_calibration(ph_current_meas_hw_cfg_t *hw_ptr, ph_current_meas_data_t *d_ptr);

//extern tBool PhCurrent2Ph_calibration(ph_current_meas_hw_cfg_t *hw_ptr, ph_current_meas_data_t *d_ptr);


extern tBool DcbCurrent_get_data(dcb_current_meas_hw_cfg_t *hw_ptr ,dcb_current_meas_data_t *d_ptr, tFloat Imax);

extern tBool PhCurrent_module_clear(ph_current_meas_data_t *ptr);

#endif /* BSP_CURRENT_MEAS_H_ */
