/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Encoder.c
*
* @author:	B34195
*
* @date: 	Aug 11, 2016
*
* @brief: 	Source file with implementation of encoder initializing, interfacing
* 			on-chip eTimer counter register and reading/evaluating  encoder position
*
***************************************************************************/

#include "Encoder.h"

/***************************************************************************//*!
@brief          Function for configuration the HW for encoder pulses counting
				utilizing the eTimer

@param[in,out]  hw_ptr	Pointer to encoder HW configuration structure
				encoderID - select one of two available HW configurations

@return         tBool

@details
******************************************************************************/
tBool Encoder_hw_init(encoder_hw_cfg_t *hw_ptr, tU16 encoderID){
    switch (encoderID)
    {
        case ENC_HW_PCIe_J1:
        	hw_ptr->pEtmrCntrData	= (volatile tU16 *)(ENC_ETIMER0_BASE + ENC_CNTR_OFFSET + (0x20 * ENC_J1_PHA_CHNL));
        	hw_ptr->pEtmrCmpld1Data = (volatile tU16 *)(ENC_ETIMER0_BASE + ENC_CMPLD1_OFFSET + (0x20 * ENC_J1_PHA_CHNL));

            break;
        case ENC_HW_PCIe_J200:
        	hw_ptr->pEtmrCntrData	= (volatile tU16 *)(ENC_ETIMER1_BASE + ENC_CNTR_OFFSET + (0x20 * ENC_J200_PHA_CHNL));
        	hw_ptr->pEtmrCmpld1Data = (volatile tU16 *)(ENC_ETIMER1_BASE + ENC_CMPLD1_OFFSET + (0x20 * ENC_J200_PHA_CHNL));

            break;
        default:
        	hw_ptr->pEtmrCntrData	= (volatile tU16 *)(ENC_ETIMER0_BASE + ENC_CNTR_OFFSET + (0x20 * ENC_J1_PHA_CHNL));
        	hw_ptr->pEtmrCmpld1Data = (volatile tU16 *)(ENC_ETIMER0_BASE + ENC_CMPLD1_OFFSET + (0x20 * ENC_J1_PHA_CHNL));
            break;
    }
	return(TRUE);
}

/***************************************************************************//*!
@brief          Function for reading the eTimer counter value that represents
				rotor mechanical position

@param[in,out]  hw_ptr	Pointer to encoder HW configuration structure
				d_ptr	Pointer to encoder data structure

@return         tBool

@details
******************************************************************************/
tBool Encoder_read_count(encoder_hw_cfg_t *hw_ptr ,encoder_data_t *d_ptr){

    static tS16 f16TimerValue;
    static tS16 f16CMPLD1Value;

    f16TimerValue	= (tS16)*hw_ptr->pEtmrCntrData;
	f16CMPLD1Value	= (tS16)*hw_ptr->pEtmrCmpld1Data;

	d_ptr->encEtmrCounts = f16TimerValue;
	d_ptr->encEtmrCompare = f16CMPLD1Value;

    // Mechanical rotor position acquired from eTimer - float point <-pi,pi>
	d_ptr->encEtmrRotorPosition = MLIB_Mul(MLIB_Div((tFloat)f16TimerValue,(tFloat)f16CMPLD1Value),FLOAT_PI);

	return(TRUE);
}
