/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Encoder.h
*
* @author:	B34195
*
* @date: 	Aug 11, 2016
*
* @brief: 	Header file containing class definition of encoder position sensor
*           hardware dependent layer software component
*
***************************************************************************/
#ifndef BSP_ENCODER_H_
#define BSP_ENCODER_H_

#include "SWLIBS_Typedefs.h"
#include "mlib.h"

/******************************************************************************
| defines and macros
|----------------------------------------------------------------------------*/

/*! Different HW configuration available */
#define ENC_HW_PCIe_J1			1
#define ENC_HW_PCIe_J200		2

/*! Macro containing the base address of all eTimer 0 & 1 modules */
#define ENC_ETIMER0_BASE		0xFBC20000
#define ENC_ETIMER1_BASE		0xFFC24000

/*! Macro containing the offset address of eTimer CNTR and CMPLD1 registers */
#define ENC_CNTR_OFFSET			0xC
#define ENC_CMPLD1_OFFSET		0x18

/*! Macro containing the encoder channel number	according to selected PCIe MC connector*/
#define ENC_J1_PHA_CHNL			0
#define ENC_J1_PHB_CHNL			1
#define ENC_J200_PHA_CHNL		0
#define ENC_J200_PHB_CHNL		1

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... encoder hw layer configuration
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU16	* pEtmrCntrData;
    volatile tU16	* pEtmrCmpld1Data;
}encoder_hw_cfg_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... encoder data
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tS16	encEtmrCounts;
    volatile tS16	encEtmrCompare;
    volatile tFloat	encEtmrRotorPosition;
}encoder_data_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool Encoder_hw_init(encoder_hw_cfg_t *hw_ptr, tU16 hwID);
extern tBool Encoder_read_count(encoder_hw_cfg_t *hw_ptr ,encoder_data_t *d_ptr);

#endif /* BSP_ENCODER_H_ */
