/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file     MC33907_routines.h
*
* @author   B15651
* 
* @version  1.0.4.0
* 
* @date     Aug-29-2012
* 
* @brief    Header file for MC33907/8 SBC driver.
*
*******************************************************************************
*
* This file includes MACRO and user type definitions of MC33907/8 SBC driver
* for MPC56xx devices.
*
******************************************************************************/
#ifndef MC33907_ROUTINES_H  /* Prevent duplicated includes */
#define MC33907_ROUTINES_H

#include "SWLIBS_Typedefs.h"
#include "DRV_CFG.h"

#ifdef	MPC5643L
	#include "MPC5643L.h"
#endif

#ifdef	MPC5675K
	#include "MPC5675K_qs.h"
#endif
#ifdef	MPC5744P
	#include "MPC5744P_qs.h"
#endif

/******************************************************************************
* DSPI register offset definition
******************************************************************************/
#define DSPI_MCR_OFFSET                 0x0
#define DSPI_TCR_OFFSET                 0x8
#define DSPI_CTAR_0_OFFSET              0xc
#define DSPI_CTAR_1_OFFSET              0x10
#define DSPI_CTAR_2_OFFSET              0x14
#define DSPI_CTAR_3_OFFSET              0x18
#define DSPI_SR_OFFSET                  0x2c
#define DSPI_RSER_OFFSET                0x30
#define DSPI_PUSHR_OFFSET               0x34
#define DSPI_POPR_OFFSET				0x38

#define DSPI_TCF                        0x80000000

#define SBC_CS0              			0
#define	SBC_CS3							3
#define SBC_CSPCR           			36
#define	SBC_CSPCR55						55
#define	SBC_CSPCR36						36

#ifdef	MPC5744P
	#define MC33907_DSPI0_BASE				0xFFE70000UL
	#define MC33907_ADC0_BASE				0xFBE00000UL
//	#define MC33907_ADC1_BASE				0xFFE04000
#endif

#ifdef	MPC5643L
	#define MC33907_DSPI0_BASE				0xFFF90000
	#define MC33907_DSPI1_BASE     			0xFFF94000
	#define MC33907_ADC0_BASE				0xFFE00000
	#define MC33907_ADC1_BASE				0xFFE04000
#endif


#define MC33907_ASSERT_CS0      		0x00010000
#define MC33907_ASSERT_CS1      		0x00020000
#define MC33907_ASSERT_CS2      		0x00040000
#define MC33907_ASSERT_CS3      		0x00080000
#define MC33907_ASSERT_CS4      		0x00100000
#define MC33907_ASSERT_CS5      		0x00200000
#define MC33907_ASSERT_CS6      		0x00400000
#define MC33907_ASSERT_CS7      		0x00800000

#define MC33907_ASSERT_CTAR0    		0x00000000
#define MC33907_ASSERT_CTAR1    		0x10000000
#define MC33907_ASSERT_CTAR2    		0x20000000
#define MC33907_ASSERT_CTAR3    		0x30000000
#define MC33907_ASSERT_CTAR4    		0x40000000
#define MC33907_ASSERT_CTAR5    		0x50000000
#define MC33907_ASSERT_CTAR6    		0x60000000
#define MC33907_ASSERT_CTAR7    		0x70000000

#define MC33907_ADC_CDR0_OFFSET         0x100
#define MC33907_ADC_CDR1_OFFSET         0x104
#define MC33907_ADC_CDR2_OFFSET         0x108
#define MC33907_ADC_CDR3_OFFSET         0x10C
#define MC33907_ADC_CDR4_OFFSET         0x110
#define MC33907_ADC_CDR5_OFFSET         0x114
#define MC33907_ADC_CDR6_OFFSET         0x118
#define MC33907_ADC_CDR7_OFFSET         0x11C
#define MC33907_ADC_CDR8_OFFSET         0x120
#define MC33907_ADC_CDR9_OFFSET         0x124
#define MC33907_ADC_CDR10_OFFSET        0x128
#define MC33907_ADC_CDR11_OFFSET        0x12C
#define MC33907_ADC_CDR12_OFFSET        0x130
#define MC33907_ADC_CDR13_OFFSET        0x134
#define MC33907_ADC_CDR14_OFFSET        0x138
#define MC33907_ADC_CDR15_OFFSET        0x13C

/* **************************************************************************\
 * Definition of the default parameters dedicated to controller board
 */
#define MPC5643L_TQFP144_EPSCB_SBC_DEFAULT  \
	{SBC_CS0,SBC_CSPCR, (MC33907_ASSERT_CS0 | MC33907_ASSERT_CTAR1),0 ,0 ,0 , MC33907_DSPI0_BASE, MC33907_ADC0_BASE, MC33907_ADC_CDR0_OFFSET}

#define	MPC5675K_BGA257_CB_SBC_DEFAULT	\
	{SBC_CS3,SBC_CSPCR55, (MC33907_ASSERT_CS3 | MC33907_ASSERT_CTAR1),0 ,0 ,0 , MC33907_DSPI1_BASE, MC33907_ADC0_BASE, MC33907_ADC_CDR0_OFFSET}

#define	MPC5744P_BGA257_CB_SBC_DEFAULT	\
	{SBC_CS0,SBC_CSPCR36, (MC33907_ASSERT_CS0 | MC33907_ASSERT_CTAR1),0 ,0 ,0 , MC33907_DSPI0_BASE, MC33907_ADC0_BASE, MC33907_ADC_CDR5_OFFSET}

/****************************************************************************\
* IO_OUT / AMUX
\****************************************************************************/
#define	AMUX_VREF					0x0
#define	AMUX_VSNS_WIDE				0x1
#define	AMUX_IO0_WIDE				0x2
#define	AMUX_IO1_WIDE				0x3
#define	AMUX_VSNS_TIGHT				0x4
#define	AMUX_IO0_TIGHT				0x5
#define	AMUX_IO1_TIGHT				0x6
#define	AMUX_TEMP					0x7

/****************************************************************************\
* CAN/LIN mode
\****************************************************************************/
#define	CAN_SLEEP					0x0
#define	CAN_RX						0x1
#define	CAN_SLEEP_WU				0x2
#define	CAN_NORMAL					0x3
#define	LIN_SLEEP					0x0
#define	LIN_RX						0x1
#define	LIN_SLEEP_WU				0x2
#define	LIN_NORMAL					0x3

/****************************************************************************\
* WD_window
\****************************************************************************/
#define	WD_DISABLE					0x0
#define	WD_WIN_1					0x1
#define	WD_WIN_2					0x2
#define	WD_WIN_3					0x3
#define	WD_WIN_4					0x4
#define	WD_WIN_6					0x5
#define	WD_WIN_8					0x6
#define	WD_WIN_12					0x7
#define	WD_WIN_16					0x8
#define	WD_WIN_24					0x9
#define	WD_WIN_32					0xA
#define	WD_WIN_64					0xB
#define	WD_WIN_128					0xC
#define	WD_WIN_256					0xD
#define	WD_WIN_512					0xE
#define	WD_WIN_1024					0xF

/****************************************************************************\
* Addresses of the PwSBC registers
\****************************************************************************/
#define	INIT_VREG1_ADR				0x01//0b000001
#define	INIT_VREG2_ADR				0x02//0b000010
#define	INIT_CAN_LIN_ADR			0x03//0b000011
#define	INIT_IO_WU1_ADR				0x04//0b000100
#define	INIT_IO_WU2_ADR				0x05//0b000101
#define	INIT_INT_ADR				0x06//0b000110
#define	HW_CONFIG_ADR				0x08//0b001000
#define	WU_SOURCE_ADR				0x09//0b001001
#define	IO_INPUT_STATE_ADR			0x0B//0b001011
#define	STATUS_VREG1_ADR			0x0C//0b001100
#define	STATUS_VREG2_ADR			0x0D//0b001101
#define	DIAG_VREG1_ADR				0x0E//0b001110
#define	DIAG_VREG2_ADR				0x0F//0b001111
#define	DIAG_VREG3_ADR				0x10//0b010000
#define	DIAG_CAN_ADR				0x11//0b010001
#define	DIAG_CAN_LIN_ADR			0x12//0b010010
#define	DIAG_SPI_ADR				0x13//0b010011
#define	MODE_ADR					0x15//0b010101
#define	VREG_MODE_ADR				0x16//0b010110
#define	IO_OUT_AMUX_ADR				0x17//0b010111
#define	CAN_LIN_MODE_ADR			0x18//0b011000
#define	VREG_LPON_ADR				0x19//0b011001

#define	INIT_SUPERVISOR1_ADR		0x21//0b100001
#define	INIT_SUPERVISOR2_ADR		0x22//0b100010
#define	INIT_SUPERVISOR3_ADR		0x23//0b100011
#define	INIT_FSSM1_ADR				0x24//0b100100
#define	INIT_FSSM2_ADR				0x25//0b100101
#define	WD_WINDOW_ADR				0x26//0b100110
#define	WD_LFSR_ADR					0x27//0b100111
#define	WD_ANSWER_ADR				0x28//0b101000
#define	FS_OUT_ADR					0x29//0b101001
#define	RSTB_REQUEST_ADR			0x2A//0b101010
#define	DIAG_FS1_ADR				0x2C//0b101100
#define	WD_COUNTER_ADR				0x2D//0b101101
#define	DIAG_FS2_ADR				0x2E//0b101110

/****************************************************************************\
* DEFAULT setting of the Writable registers
\****************************************************************************/
#define	INIT_VREG1_DEF				0x8200		//8342 Vcore second bridge enabled
#define	INIT_VREG2_DEF				0x8444
#define	INIT_CAN_LIN_DEF			0x8600
#define	INIT_IO_WU1_DEF				0x8800	//8900
#define	INIT_IO_WU2_DEF				0x8A00  // default 8B02
#define	INIT_INT_DEF				0x8C00
#define	MODE_DEF					0xAB8E
#define	VREG_MODE_DEF				0xACF0
#define	IO_OUT_AMUX_DEF				0xAF00 //AE00
#define	CAN_LIN_MODE_DEF			0xB0D8 //B0B4
#define	VREG_LPON_DEF				0x0000B3E7
#define	INIT_SUPERVISOR1_DEF		0x0000C200	//C2F3
#define	INIT_SUPERVISOR2_DEF		0x0000C400	//C4CF
#define	INIT_SUPERVISOR3_DEF		0x0000C700
#define	INIT_FSSM1_DEF				0x0000C800 //C80C //C84D SC
#define	INIT_FSSM2_DEF				0x0000CB00 //CB4D	 //IO2_3 safety_crit	//	//CB0C	//C80C//D60C  //D64D
#define	WD_WINDOW_DEF				0x0000CD30  //CD0C
#define	WD_LFSR_DEF					0x0000CF10
#define	WD_ANSWER_DEF				0x00000000
#define	FS_OUT_DEF					0x00000000
#define	RSTB_REQUEST_DEF			0x0000D50C

/****************************************************************************\
* PIT parameters
\****************************************************************************/
#define PIT_FS_DELAY	0.000004	///delay between two fail safe commends in seconds

/****************************************************************************\
* ADC parameters
\****************************************************************************/
#define	ADC_RESOLUTION	4095	///ADC resolution 2^12
#define	ADC_RATIO	(ADC_SOURCE_CALIB / ADC_RESOLUTION)	///Ratio necessary for ADC computations
#define	VAMUX_WD_5 	5	///Divider Ratio wide input voltage range with 5V reference
#define	VAMUX_WD_33 	7	///Divider Ratio wide input voltage range with 3.3V reference
#define	VAMUX_TG_5	2	///Divider Ratio tight input voltage range with 5V reference
#define	VAMUX_TG_33 	3	///Divider Ratio tight input voltage range with 3.3V reference
#define	VAMUX_TP_CO	10	///Internal temp sensor coefficient in mV/C
#define	VAMUX_TP_0	850	///Temp sensor  mux output voltage for 0 C in mV  ->   Vamux_tp - Tj*V_amux_tp_co = (2500mV) - (165C)*(10mV/C) = 850 mV

/****************************************************************************\
* UART parameters
\****************************************************************************/
#define	MSG_FRAME_SIZE	4	///defines number of bytes for each frame of the UART communication (1 - 4)

/****************************************************************************\
* INTC parameters
\****************************************************************************/
#define	INT_CEIL_PRIORITY	12	///ceil priority has to be equal to the highest priority of interrupts sharing DSPI to communicate with PwSBC
#define	INT_WD_PRIORITY	12	///priority for WD refresh interrupt caused by PIT
#define	INT_SIUL_PRIORITY	10	///priority for interrupt caused by INT pin
#define	INT_UART_RX_PRIORITY	8	///priority for commands receiving from PC
#define	INT_ADC_PRIORITY	6	///priority for end of conversion of ADC
#define	INT_UART_TX_PRIORITY	4	///priority for PIT interrupt, which sends data to PC via UART

/****************************************************************************\
* ERROR codes
\****************************************************************************/
#define ERR_SPI_NO_COMMUN	10		///when received 0 from SPI, SPI is probably disconnected
#define	ERR_SPI_NO_REFRESH	12	///when 20 times unsuccessfully tried to refresh WD, SPI_G error always active

/****************************************************************************\
* EVENT codes
\****************************************************************************/
#define	EV_SPI	100	///SPI_G event

/****************************************************************************\
* MESSAGE codes
\****************************************************************************/
#define	MSG_STD	200	 ///standard message - register refresh only

/****************************************************************************\
* PowerSBC global structures
\****************************************************************************/
typedef union
{
    volatile tU8 R;
    struct {
    	volatile tU8 spiG			:1;	// RESERVED
        volatile tU8 wu          	:1;	// RESERVED
        volatile tU8 canG         	:1;	// RESERVED
        volatile tU8 linG          	:1;	// RESERVED
        volatile tU8 ioG          	:1;	// RESERVED
        volatile tU8 vPreG          :1;	// RESERVED
        volatile tU8 vCoreG			:1; // DC offset calibration done
        volatile tU8 vOthersG		:1; // initial setup for DC offset calibration done
    } B;
}devFixStat_t;

/****************************************************************************\
* Write registers
\****************************************************************************/

	typedef union { //INIT_Vreg1
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16     						: 1;
			volatile tU16 Vpre_WU_conf				: 1;
			volatile tU16 IpFF_DIS					: 1;
			volatile tU16 Vpre_DIS					: 1;
			volatile tU16     						: 2;
			volatile tU16 Vcore_wu_conf				: 1;
			volatile tU16 Vcore_FB					: 1;
		} B;
	} INIT_VREG1_TX_tag;

	typedef union { ///INIT_Vreg2
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16     						: 1;
			volatile tU16 Tcca_lim_off				: 1;
			volatile tU16 Icca_lim					: 1;
			volatile tU16     						: 1;
			volatile tU16 Iaux_lim					: 1;
			volatile tU16 Taux_lim_off				: 1;
			volatile tU16 Vaux_trk_EN 				: 1;
			volatile tU16 Vaux_trk					: 1;
		} B;
	} INIT_VREG2_TX_tag;

	typedef union { ///INIT_CAN_LIN
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16     						: 1;
			volatile tU16 CAN_WU_conf				: 1;
			volatile tU16 CAN_CMBF					: 1;
			volatile tU16 CAN_TOY					: 1;
			volatile tU16 CAN_WU_TO					: 1;
			volatile tU16 LIN_J2602_DIS				: 1;
			volatile tU16 LIN_SR       				: 2;
		} B;
	} INIT_CAN_LIN_TX_tag;

	typedef union { ///INIT_IO_WU1
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 WU_0						: 2;
			volatile tU16 WU_1						: 2;
			volatile tU16 WU_2						: 2;
			volatile tU16 INT_inh_IO				: 2;
		} B;
	} INIT_IO_WU1_TX_tag;

	typedef union { ///INIT_IO_WU2
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 WU_3						: 2;
			volatile tU16 WU_4						: 2;
			volatile tU16 WU_5						: 2;
			volatile tU16 INT_inh_IO_23	  			: 1;
			volatile tU16 INT_inh_IO_45				: 1;
		} B;
	} INIT_IO_WU2_TX_tag;

	typedef union { ///INIT_INT
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 INT_duration				: 1;
			volatile tU16     						: 1;
			volatile tU16 INT_inh_all		  		: 1;
			volatile tU16 INT_inh_Vsns				: 1;
			volatile tU16 INT_inh_Vpre				: 1;
			volatile tU16 INT_inh_Vcore	  			: 1;
			volatile tU16 INT_inh_Voth				: 1;
			volatile tU16     						: 1;
		} B;
	} INIT_INT_TX_tag;

	typedef union { ///MODE_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 Normal					: 1;
			volatile tU16 LPON						: 1;
			volatile tU16 LPOFF						: 1;
			volatile tU16 INT_request		  		: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} MODE_TX_tag;

	typedef union { ///Vreg_mode_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 Vcore_EN					: 1;
			volatile tU16 Vcca_EN					: 1;
			volatile tU16 Vaux_EN					: 1;
			volatile tU16 Vcan_EN					: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} VREG_MODE_TX_tag;

	typedef union { ///IO_OUT_AMUX
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 IO_out_4_EN				: 1;
			volatile tU16 IO_out_4					: 1;
			volatile tU16 IO_out_5_EN				: 1;
			volatile tU16 IO_out_5					: 1;
			volatile tU16 Reserved					: 1;
			volatile tU16 Amux    					: 3;
		} B;
	} IO_OUT_AMUX_TX_tag;

	typedef union { ///CAN_LIN_mode_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 CAN_mode					: 2;
			volatile tU16 CAN_auto_dis				: 1;
			volatile tU16 LIN_mode					: 2;
			volatile tU16 LIN_auto_dis				: 1;
			volatile tU16             				: 2;
		} B;
	} CAN_LIN_MODE_TX_tag;

	typedef union { ///Vreg_LPON_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 Vcore_LP					: 1;
			volatile tU16 Vcca_LP					: 1;
			volatile tU16 Vaux_LP					: 1;
			volatile tU16     						: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;

		} B;
	} VREG_LP_TX_tag;

	typedef union { ///INIT_Supervisor1_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 Vcore_FS					: 2;
			volatile tU16 Vcca_FS				  	: 2;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} INIT_SUPERVISOR1_TX_tag;

	typedef union { ///INIT_Supervisor2_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 Vaux_FS				  	: 2;
			volatile tU16     						: 1;
			volatile tU16 DIS_8s					: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} INIT_SUPERVISOR2_TX_tag;

	typedef union { ///INIT_Supervisor3_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 Vcore_5D					: 1;
			volatile tU16 Vcca_5D					: 1;
			volatile tU16 Vaux_5D					: 1;
			volatile tU16     						: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} INIT_SUPERVISOR3_TX_tag;

	typedef union { ///INIT_FSSM1_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 IO_01_FS					: 1;
			volatile tU16 IO_1_FS					: 1;
			volatile tU16 IO_45_FS					: 1;
			volatile tU16 RSTb_low					: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} INIT_FSSM1_TX_tag;

	typedef union { ///INIT_FSSM2_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 RSTb_err_FS	  			: 1;
			volatile tU16 IO_23_FS					: 1;
			volatile tU16 PS						: 1;
			volatile tU16 F_FS1						: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} INIT_FSSM2_TX_tag;

	typedef union { ///WD_window_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 WD_window		  			: 4;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} WD_WINDOW_TX_tag;

	typedef union { ///WD_LFSR_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 WD_LFSR	 				: 8;
		} B;
	} WD_LFSR_TX_tag;

	typedef union { ///WD_answer_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 WD_answer					: 8;
		} B;
	} WD_ANSWER_TX_tag;

	typedef union { ///FS_OUT_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 FS_out_7					: 1;
			volatile tU16 FS_out_6					: 1;
			volatile tU16 FS_out_5					: 1;
			volatile tU16 FS_out_4					: 1;
			volatile tU16 FS_out_3					: 1;
			volatile tU16 FS_out_2					: 1;
			volatile tU16 FS_out_1					: 1;
			volatile tU16 FS_out_0					: 1;
		} B;
	} FS_OUT_TX_tag;

	typedef union { ///RSTb_request_Tx
		volatile tU16 R;
		struct {
			volatile tU16 RW						: 1;
			volatile tU16 ADR						: 6;
			volatile tU16 P							: 1;
			volatile tU16 							: 2;
			volatile tU16 RSTb_request				: 1;
			volatile tU16 							: 1;
			volatile tU16 Secure_3					: 1;
			volatile tU16 Secure_2					: 1;
			volatile tU16 Secure_1					: 1;
			volatile tU16 Secure_0					: 1;
		} B;
	} RSTB_REQUEST_TX_tag;

/****************************************************************************\
* Read registers
\****************************************************************************/

typedef union { ///INIT_Vreg1
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16     							: 1;
		volatile tU16		Vpre_WU_conf			: 1;
		volatile tU16		IpFF_DIS				: 1;
		volatile tU16		Vpre_DIS				: 1;
		volatile tU16     							: 2;
		volatile tU16		Vcore_wu_conf			: 1;
		volatile tU16		Vcore_FB				: 1;
	} B;
} INIT_VREG1_RX_tag;

typedef union { ///INIT_Vreg2
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16     							: 1;
		volatile tU16		Tcca_lim_off			: 1;
		volatile tU16		Icca_lim				: 1;
		volatile tU16     							: 1;
		volatile tU16		Iaux_lim				: 1;
		volatile tU16		Taux_lim_off			: 1;
		volatile tU16		Vaux_trk_EN 			: 1;
		volatile tU16		Vaux_trk				: 1;
	} B;
} INIT_VREG2_RX_tag;

typedef union { ///INIT_CAN_LIN
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16     							: 1;
		volatile tU16		CAN_WU_conf				: 1;
		volatile tU16		CAN_CMBF				: 1;
		volatile tU16		CAN_TOY					: 1;
		volatile tU16		CAN_WU_TO				: 1;
		volatile tU16		LIN_J2602_DIS			: 1;
		volatile tU16		LIN_SR       			: 2;
	} B;
} INIT_CAN_LIN_RX_tag;

typedef union { ///INIT_IO_WU1
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		WU_0					: 2;
		volatile tU16		WU_1					: 2;
		volatile tU16		WU_2					: 2;
		volatile tU16		INT_inh_IO				: 2;
	} B;
} INIT_IO_WU1_RX_tag;

typedef union { ///INIT_IO_WU2
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		WU_3					: 2;
		volatile tU16		WU_4					: 2;
		volatile tU16		WU_5					: 2;
		volatile tU16		INT_inh_IO_23	  		: 1;
		volatile tU16		INT_inh_IO_45			: 1;
	} B;
} INIT_IO_WU2_RX_tag;

typedef union { ///INIT_INT
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		INT_duration			: 1;
		volatile tU16     							: 1;
		volatile tU16		INT_inh_all		  		: 1;
		volatile tU16		INT_inh_Vsns			: 1;
		volatile tU16		INT_inh_Vpre			: 1;
		volatile tU16		INT_inh_Vcore	  		: 1;
		volatile tU16		INT_inh_Voth			: 1;
		volatile tU16     							: 1;
	} B;
} INIT_INT_RX_tag;

typedef union { ///HW_Config_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		LS_detect				: 1;
		volatile tU16     							: 1;
		volatile tU16		PNP_detect				: 1;
		volatile tU16		Vcca_HW					: 1;
		volatile tU16		Vaux_HW					: 2;
		volatile tU16     							: 1;
		volatile tU16		DBG						: 1;
	} B;
} HW_CONFIG_tag;

typedef union { ///WU_source_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		IO_5_WU					: 1;
		volatile tU16		IO_4_WU					: 1;
		volatile tU16		IO_3_WU					: 1;
		volatile tU16		IO_2_WU					: 1;
		volatile tU16		IO_1_WU					: 1;
		volatile tU16		IO_0_WU					: 1;
		volatile tU16		Vreg_WU					: 1;
		volatile tU16		Phy_WU					: 1;
	} B;
} WU_SOURCE_tag;


typedef union { ///IO_input state_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		IO_5					: 1;
		volatile tU16		IO_4					: 1;
		volatile tU16     							: 1;
		volatile tU16		IO_3					: 1;
		volatile tU16		IO_2					: 1;
		volatile tU16     							: 1;
		volatile tU16		IO_1					: 1;
		volatile tU16		IO_0					: 1;
	} B;
} IO_INPUT_STATE_tag;

typedef union { ///Status_Vreg1_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		IpFF					: 1;
		volatile tU16		Ilim_pre				: 1;
		volatile tU16		Twarn_pre				: 1;
		volatile tU16		BoB						: 1;
		volatile tU16		Vpre_state				: 1;
		volatile tU16     							: 1;
		volatile tU16		Vpre_WU					: 1;
		volatile tU16		Vcore_WU				: 1;
	} B;
} STATUS_VREG1_tag;

typedef union { ///Status_Vreg2_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Ilim_core				: 1;
		volatile tU16		Twarn_core				: 1;
		volatile tU16		Vcore_state			  	: 1;
		volatile tU16		Twarn_cca			  	: 1;
		volatile tU16		Ilim_cca				: 1;
		volatile tU16		Ilim_aux				: 1;
		volatile tU16		Ilim_can				: 1;
		volatile tU16     							: 1;
	} B;
} STATUS_VREG2_tag;

typedef union { ///Diag_Vreg1_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Vsns_uv					: 1;
		volatile tU16		Vsup_uv_H			  	: 1;
		volatile tU16		Tsd_pre					: 1;
		volatile tU16		Vpre_OV					: 1;
		volatile tU16		Vpre_UV					: 1;
		volatile tU16		Tsd_core				: 1;
		volatile tU16		Vcore_OV				: 1;
		volatile tU16		Vcore_UV				: 1;
	} B;
} DIAG_VREG1_tag;

typedef union { ///Diag_Vreg2_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Tsd_can					: 1;
		volatile tU16		Vcan_ov					: 1;
		volatile tU16		Vcan_uv					: 1;
		volatile tU16     							: 1;
		volatile tU16		Tsd_aux					: 1;
		volatile tU16		Ilim_aux_off			: 1;
		volatile tU16		Vaux_OV					: 1;
		volatile tU16		Vaux_UV					: 1;
	} B;
} DIAG_VREG2_tag;

typedef union { ///Diag_Vreg3_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Tsd_cca					: 1;
		volatile tU16     							: 1;
		volatile tU16		Ilim_cca_off			: 1;
		volatile tU16     							: 1;
		volatile tU16		Vcca_OV					: 1;
		volatile tU16     							: 1;
		volatile tU16		Vcca_UV					: 1;
		volatile tU16     							: 1;
	} B;
} DIAG_VREG3_tag;

typedef union { ///Diag_CAN_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		CANH_batt				: 1;
		volatile tU16		CANH_gnd				: 1;
		volatile tU16		CANL_batt				: 1;
		volatile tU16		CANL_gnd				: 1;
		volatile tU16		CAN_dominant			: 1;
		volatile tU16     							: 1;
		volatile tU16		RXD_recessive			: 1;
		volatile tU16		TXD_dominant			: 1;
	} B;
} DIAG_CAN_tag;

typedef union { ///Diag_CAN_LIN_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		LIN_dominant			: 1;
		volatile tU16		TXDL_dominant	  		: 1;
		volatile tU16     							: 1;
		volatile tU16		RXDL_recessive			: 1;
		volatile tU16		LIN_OT					: 1;
		volatile tU16     							: 1;
		volatile tU16		CAN_OT					: 1;
		volatile tU16		CAN_OC					: 1;
	} B;
} DIAG_CAN_LIN_tag;

typedef union { ///Diag_SPI_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		SPI_err					: 1;
		volatile tU16		bit6    				: 1;
		volatile tU16		SPI_CLK					: 1;
		volatile tU16		bit4    				: 1;
		volatile tU16		SPI_Req					: 1;
		volatile tU16		bit2    				: 1;
		volatile tU16		SPI_Parity				: 1;
		volatile tU16		bit0    				: 1;
	} B;
} DIAG_SPI_tag;

typedef union { ///MODE_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Reserved				: 5;
		volatile tU16		Normal					: 1;
		volatile tU16		LPON					: 1;
		volatile tU16		LPOFF					: 1;
	} B;
} MODE_RX_tag;

typedef union { ///Vreg_mode_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Reserved				: 4;
		volatile tU16		Vcore_EN				: 1;
		volatile tU16		Vcca_EN					: 1;
		volatile tU16		Vaux_EN					: 1;
		volatile tU16		Vcan_EN					: 1;
	} B;
} VREG_MODE_RX_tag;

typedef union { ///CAN_LIN mode_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		CAN_mode				: 2;
		volatile tU16		CAN_auto_dis			: 1;
		volatile tU16		LIN_mode				: 2;
		volatile tU16		LIN_auto_dis			: 1;
		volatile tU16		CAN_wu					: 1;
		volatile tU16		LIN_wu					: 1;
	} B;
} IO_OUT_RX_tag;

typedef union { ///CAN_LIN mode_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		CAN_mode				: 2;
		volatile tU16		CAN_auto_dis			: 1;
		volatile tU16		LIN_mode				: 2;
		volatile tU16		LIN_auto_dis			: 1;
		volatile tU16		CAN_wu					: 1;
		volatile tU16		LIN_wu					: 1;
	} B;
} CAN_LIN_MODE_RX_tag;

typedef union { ///Vreg_LPON_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		Reserved				: 5;
		volatile tU16		Vcore_LP				: 1;
		volatile tU16		Vcca_LP					: 1;
		volatile tU16		Vaux_LP					: 1;
	} B;
} VREG_LPON_RX_tag;


typedef union { ///INIT_Supervisor1_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		SPI_FS_err				: 1;
		volatile tU16		SPI_FS_CLK				: 1;
		volatile tU16		SPI_FS_Req				: 1;
		volatile tU16		SPI_FS_Parity			: 1;
		volatile tU16		Vcore_FS				: 2;
		volatile tU16		Vcca_FS 				: 2;
	} B;
} INIT_SUPERVISOR1_RX_tag;

typedef union { ///INIT_Supervisor2_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		SPI_FS_err				: 1;
		volatile tU16		SPI_FS_CLK				: 1;
		volatile tU16		SPI_FS_Req				: 1;
		volatile tU16		SPI_FS_Parity	    	: 1;
		volatile tU16     							: 1;
		volatile tU16		DIS_8s					: 1;
		volatile tU16		Vaux_FS			  		: 2;
	} B;
} INIT_SUPERVISOR2_RX_tag;

typedef union { ///INIT_Supervisor3_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		SPI_FS_err				: 1;
		volatile tU16		SPI_FS_CLK				: 1;
		volatile tU16		SPI_FS_Req				: 1;
		volatile tU16		SPI_FS_Parity	  		: 1;
		volatile tU16     							: 1;
		volatile tU16		Vcore_5D				: 1;
		volatile tU16		Vcca_5D					: 1;
		volatile tU16		Vaux_5D					: 1;
	} B;
} INIT_SUPERVISOR3_RX_tag;

typedef union { ///INIT_FSSM1_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		SPI_FS_err				: 1;
		volatile tU16 		SPI_FS_CLK				: 1;
		volatile tU16		SPI_FS_Req				: 1;
		volatile tU16		SPI_FS_Parity			: 1;
		volatile tU16		IO_01_FS				: 1;
		volatile tU16		IO_1_FS					: 1;
		volatile tU16		IO_45_FS				: 1;
		volatile tU16		RSTb_low				: 1;
	} B;
} INIT_FSSM1_RX_tag;

typedef union { ///INIT_FSSM2_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		SPI_FS_err				: 1;
		volatile tU16 		SPI_FS_CLK				: 1;
		volatile tU16 		SPI_FS_Req				: 1;
		volatile tU16 		SPI_FS_Parity	  		: 1;
		volatile tU16 		RSTb_err_FS		  		: 1;
		volatile tU16	 	IO_23_FS			 	: 1;
		volatile tU16		PS						: 1;
		volatile tU16		F_FS1					: 1;
	} B;
} INIT_FSSM2_RX_tag;

typedef union { ///WD_window_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		SPI_FS_err				: 1;
		volatile tU16 		SPI_FS_CLK				: 1;
		volatile tU16 		SPI_FS_Req				: 1;
		volatile tU16 		SPI_FS_Parity		  	: 1;
		volatile tU16 		WD_window   		  	: 4;
	} B;
} WD_WINDOW_RX_tag;

typedef union { ///WD_LFSR_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		WD_LFSR_7		  		: 1;
		volatile tU16 		WD_LFSR_6		  		: 1;
		volatile tU16 		WD_LFSR_5		  		: 1;
		volatile tU16 		WD_LFSR_4		  		: 1;
		volatile tU16 		WD_LFSR_3		  		: 1;
		volatile tU16 		WD_LFSR_2		  		: 1;
		volatile tU16 		WD_LFSR_1		  		: 1;
		volatile tU16 		WD_LFSR_0		  		: 1;
	} B;
} WD_LFSR_RX_tag;

typedef union { ///WD_answer_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		RSTb					: 1;
		volatile tU16 		FSx						: 1;
		volatile tU16 		WD						: 1;
		volatile tU16 		FSO_G					: 1;
		volatile tU16 		IO_FS_G					: 1;
		volatile tU16 		SPI_FS_G				: 1;
		volatile tU16 		FS_ECC					: 1;
		volatile tU16 		FS_reg_ECC				: 1;
	} B;
} WD_ANSWER_RX_tag;

typedef union { ///Diag_FS1_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		RSTb_ext				: 1;
		volatile tU16 		RSTb_diag				: 1;
		volatile tU16     							: 1;
		volatile tU16 		FS0b_diag				: 2;
		volatile tU16     							: 1;
		volatile tU16 		FS1_diag    		  	: 2;
	} B;
} DIAG_FS1_tag;

typedef union { ///WD_counter_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16 		WD_err					: 3;
		volatile tU16     							: 1;
		volatile tU16 		WD_refresh				: 3;
		volatile tU16     							: 1;
	} B;
} WD_COUNTER_tag;

typedef union { ///Diag_FS2_Rx
	volatile tU16 R;
	struct {
		devFixStat_t	devFixStatus;
		volatile tU16		RSTb_err				: 3;
		volatile tU16     							: 1;
		volatile tU16		IO_45_fail				: 1;
		volatile tU16		IO_23_fail				: 1;
		volatile tU16		IO_1_fail				: 1;
		volatile tU16		IO_01_fail				: 1;
	} B;
} DIAG_FS2_tag;

typedef union { /* register16_struct */
	tU16 R;
	struct {
		tU16	bit15	:	1;
		tU16	bit14	:	1;
		tU16	bit13	:	1;
		tU16	bit12	:	1;
		tU16	bit11	:	1;
		tU16	bit10	:	1;
		tU16	bit9	:	1;
		tU16	bit8	:	1;
		tU16	bit7	:	1;
		tU16	bit6	:	1;
		tU16	bit5	:	1;
		tU16	bit4	:	1;
		tU16	bit3	:	1;
		tU16	bit2	:	1;
		tU16	bit1	:	1;
		tU16	bit0	:	1;
	} B;
} REG16_T;

typedef union { /* PowerSBC general status register */
	tU16 R;
	struct {
		tU16	SPI_G				:1;		//SPI error
		tU16	WU					:1;		//Wake-up event
		tU16	CAN_G				:1;		//CAN event
		tU16	LIN_G				:1;		//LIN event
		tU16	IO_G				:1;		//event on I/Os
		tU16	Vpre_G				:1;		//Vpre event
		tU16	Vcore_G				:1;		//Vcore event
		tU16	Vothers_G			:1;		//Vcca, Vaux or Vcan event
		tU16						:8;
	} B;
} Status_16B_tag;

/*------------------------------------------------------------------------*//*!
@struct MC33907_DRV_SET_T "\MPC5643L_DSPI_LLD.h"

@brief  Structure containing configuration setup for the DSPI module
*//*-------------------------------------------------------------------------*/
typedef struct
{
    tU8			dspiCsSignal;   /*!< define number of the CS signal used for communication */
    tU8         csPcrNb;        /*!< define number of the PCR register used for CS signal on the CB */
    tU32        txCmd;          /*!< define transmit command */
    tU16		transmitData;	/*!< define data for transmit from MCU */
    tU16        receivedData;   /*!< define read data from Device */
    tU16		devStatus;		/*!< define fixed and extended device status */
    volatile tU32		dspiBaseAdr;    /*!< define base address of used DSPI module */
    volatile tU32       adcBaseAdr;		/*!< define base address of used ADC module */
    tU16                adcChnl;		/*!< define ADC channel offset used for AMUX output */
}MC33907_DRV_SET_T;

/*------------------------------------------------------------------------*//*!
@struct MC33907_REGVAL_T "\MC33907_routines.h"

@brief  Structure containing received data from MC33907 device
*//*-------------------------------------------------------------------------*/
typedef struct
{
	INIT_VREG1_RX_tag				initVreg1;			/*! INIT_VREG1 register, write during INIT phase, then read only */
	INIT_VREG2_RX_tag				initVreg2;			/*! INIT_VREG2 register, write during INIT phase, then read only */
	INIT_CAN_LIN_RX_tag				initCanLin;			/*! INIT_CAN/LIN register, write during INIT phase, then read only */
	INIT_IO_WU1_RX_tag				initIoWu1;			/*! INIT_IO_WU1 register, write during INIT phase, then read only */
	INIT_IO_WU2_RX_tag				initIoWu2;			/*! INIT_IO_WU2 register, write during INIT phase, then read only */
	INIT_INT_RX_tag					initInt;			/*! INIT_INT register, write during INIT phase, then read only */
	HW_CONFIG_tag					hwConfig;			/*! HW config register, read only */
	WU_SOURCE_tag					wuSource;			/*! WU source register, read only */
	IO_INPUT_STATE_tag				ioInputState;		/*! IO input state register, read only */
	STATUS_VREG1_tag				statusVreg1;		/*! Status VREG1 register, read only */
	STATUS_VREG2_tag				statusVreg2;		/*! Status VREG2 register, read only */
	DIAG_VREG1_tag					diagVreg1;			/*! Diag VREG1 register, read only */
	DIAG_VREG2_tag					diagVreg2;			/*! Diag VREG2 register, read only */
	DIAG_VREG3_tag					diagVreg3;			/*! Diag VREG3 register, read only */
	DIAG_CAN_tag					diagCan;			/*! Diag CAN register, read only */
	DIAG_CAN_LIN_tag				diagCanLin;			/*! Diag CAN/LIN register, read only */
	DIAG_SPI_tag					diagSpi;			/*! Diag SPI register, read only */
	MODE_RX_tag						mode;				/*! MODE register, write during Normal/LPON phase and read */
	VREG_MODE_RX_tag				vregMode;			/*! Vreg_mode register, write during Normal/LPON phase and read */
	IO_OUT_RX_tag					ioOutAmux;			/*! IO_OUT/AMUX register, write during Normal/LPON phase and read */
	CAN_LIN_MODE_RX_tag				canLinMode;			/*! CAN/LIN Mode register, write during Normal/LPON phase and read */
	VREG_LPON_RX_tag				vregLpOn;			/*! Vreg_LPON register, write during Normal/LPON phase and read */
	INIT_SUPERVISOR1_RX_tag			initSupervisor1;	/*! INIT_Supervisor1 register, write during INIT phase, then read only */
	INIT_SUPERVISOR2_RX_tag			initSupervisor2;	/*! INIT_Supervisor2 register, write during INIT phase, then read only */
	INIT_SUPERVISOR3_RX_tag			initSupervisor3;	/*! INIT_Supervisor3 register, write during INIT phase, then read only */
	INIT_FSSM1_RX_tag				initFssm1;			/*! INIT_FSSM1 register, write during INIT phase, then read only */
	INIT_FSSM2_RX_tag				initFssm2;			/*! INIT_FSSM2 register, write during INIT phase, then read only */
	WD_WINDOW_RX_tag				wdWindow;			/*! WD_Window register, write (no restriction) and read */
	WD_LFSR_RX_tag					wdLfsr;				/*! WD_LFSR register, write (no restriction) and read */
	WD_ANSWER_RX_tag				wdAnswer;			/*! WD_ansfer register, write (no restriction) and read */
	DIAG_FS1_tag					diagFs1;			/*! Diag FS1 register, read only */
	WD_COUNTER_tag					wdCounter;			/*! WD_Counter register, read only */
	DIAG_FS2_tag					diagFs2;			/*! Diag FS2 register, read only */
}MC33907_REGVAL_T;

/*------------------------------------------------------------------------*//*!
@struct MC33907_SETREG_T "\MC33907_routines.h"

@brief  Structure containing configuration data for MC33907 device
*//*-------------------------------------------------------------------------*/
typedef struct
{
	INIT_VREG1_TX_tag				initVreg1;			/*! INIT_VREG1 register, write during INIT phase, then read only */
	INIT_VREG2_TX_tag				initVreg2;			/*! INIT_VREG2 register, write during INIT phase, then read only */
	INIT_CAN_LIN_TX_tag				initCanLin;			/*! INIT_CAN/LIN register, write during INIT phase, then read only */
	INIT_IO_WU1_TX_tag				initIoWu1;			/*! INIT_IO_WU1 register, write during INIT phase, then read only */
	INIT_IO_WU2_TX_tag				initIoWu2;			/*! INIT_IO_WU2 register, write during INIT phase, then read only */
	INIT_INT_TX_tag					initInt;			/*! INIT_INT register, write during INIT phase, then read only */
	MODE_TX_tag						mode;				/*! MODE register, write during Normal/LPON phase and read */
	VREG_MODE_TX_tag				vregMode;			/*! Vreg_mode register, write during Normal/LPON phase and read */
	IO_OUT_AMUX_TX_tag				ioOutAmux;			/*! IO_OUT/AMUX register, write during Normal/LPON phase and read */
	CAN_LIN_MODE_TX_tag				canLinMode;			/*! CAN/LIN Mode register, write during Normal/LPON phase and read */
	VREG_LP_TX_tag					vregLpOn;			/*! Vreg_LPON register, write during Normal/LPON phase and read */
	INIT_SUPERVISOR1_TX_tag			initSupervisor1;	/*! INIT_Supervisor1 register, write during INIT phase, then read only */
	INIT_SUPERVISOR2_TX_tag			initSupervisor2;	/*! INIT_Supervisor2 register, write during INIT phase, then read only */
	INIT_SUPERVISOR3_TX_tag			initSupervisor3;	/*! INIT_Supervisor3 register, write during INIT phase, then read only */
	INIT_FSSM1_TX_tag				initFssm1;			/*! INIT_FSSM1 register, write during INIT phase, then read only */
	INIT_FSSM2_TX_tag				initFssm2;			/*! INIT_FSSM2 register, write during INIT phase, then read only */
	WD_WINDOW_TX_tag				wdWindow;			/*! WD_Window register, write (no restriction) and read */
	WD_LFSR_TX_tag					wdLfsr;				/*! WD_LFSR register, write (no restriction) and read */
	WD_ANSWER_TX_tag				wdAnswer;			/*! WD_ansfer register, write (no restriction) and read */
	FS_OUT_TX_tag					fsOut;				/*! FS_OUT register, write (no restriction) */
	RSTB_REQUEST_TX_tag				rstb;				/*! RSTb register, write (no restriction) */
}MC33907_SETREG_T;
/*------------------------------------------------------------------------*//*!
@struct MC33907_SET_T "\MC33907_routines.h"

@brief  Structure containing module settings and registers image of the MC33907 device
*//*-------------------------------------------------------------------------*/
typedef struct
{
	MC33907_DRV_SET_T      			dspiSet;    		/*!< Module settings */
    MC33907_REGVAL_T				pwrSbcRegValues;	/*!< Power SBC Status */
    MC33907_SETREG_T				RegConfigData;		/*!< Power SBC configuration data */
}MC33907_SET_T;


/****************************************************************************\
* Function prototypes
\****************************************************************************/
extern tU16 pwSbc_SetNormalMode(MC33907_SET_T *ptr);
extern tU16 pwSbc_ActivateLpOnMode(MC33907_SET_T *ptr);
extern tU16 pwSbc_ActivateLpOffMode(MC33907_SET_T *ptr);
extern void pwSbc_RequestIntPuls(MC33907_SET_T *ptr);

extern tU16 PwSBC_EnableVcore(MC33907_SET_T *ptr);
extern tU16 PwSBC_DisableVcore();
extern tU16 pwSbc_EnableVcca(MC33907_SET_T *ptr);
extern tU16 pwSbc_DisableVcca(MC33907_SET_T *ptr);
extern tU16 pwSbc_EnableVaux(MC33907_SET_T *ptr);
extern tU16 pwSbc_DisableVaux(MC33907_SET_T *ptr);
extern tU16 PwSBC_EnableVcan();
extern tU16 PwSBC_DisableVcan();

extern tU16 pwSbc_EnableOut4(MC33907_SET_T *ptr);
extern tU16 pwSbc_SetOut4(MC33907_SET_T *ptr);
extern tU16 pwSbc_ClearOut4(MC33907_SET_T *ptr);
extern tU16 pwSbc_EnableOut5(MC33907_SET_T *ptr);
extern tU16 pwSbc_SetOut5(MC33907_SET_T *ptr);
extern tU16 pwSbc_ClearOut5(MC33907_SET_T *ptr);

extern tU16 pwSbc_switchAmuxChannel(MC33907_SET_T *ptr, tU16 nbChannel);
extern tU16 pwSbc_SetCanMode(MC33907_SET_T *ptr, tU16 mode);
extern tU16 pwSbc_SetAutoCanTxDisable(MC33907_SET_T *ptr);
extern tU16 pwSbc_ClearAutoCanTxDisable(MC33907_SET_T *ptr);
extern tU16 pwSbc_SetLinMode(MC33907_SET_T *ptr, tU16 mode);

extern tU16 PwSBC_EnableVcoreLowPower();
extern tU16 PwSBC_DisableVcoreLowPower();
extern tU16 PwSBC_EnableVccaLowPower();
extern tU16 PwSBC_DisableVccaLowPower();
extern tU16 PwSBC_EnableVauxLowPower();
extern tU16 PwSBC_DisableVauxLowPower();

extern tU16 pwSbc_ChangeWdWindow(MC33907_SET_T *ptr, tU16 duration);
extern tU16 pwSbc_SendSeed(MC33907_SET_T *ptr, tU16 seed);
extern tU16 pwSbc_RefreshWd(MC33907_SET_T *ptr);
//extern tU16 PwSBC_GenerateLFSR();
extern tU16 pwSbc_ComputeLFSR(tU16	actualLFSR);

extern void pwSbc_ReleaseFsOut(MC33907_SET_T *ptr);
extern void pwSbc_RequestReset(MC33907_SET_T *ptr);

extern tU16 PwSBC_GetInitVreg1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitVreg2(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitCANLIN(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitIOWU1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitIOWU2(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitINT(MC33907_SET_T *ptr);

extern tU16 PwSBC_GetHWconfig(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetWUsource(MC33907_SET_T *ptr);

extern tU16 PwSBC_GetIOinputState(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetStatusVreg1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetStatusVreg2(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagVreg1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagVreg2(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagVreg3(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagCAN(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagCANLIN(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagSPI(MC33907_SET_T *ptr);

extern tU16 PwSBC_GetMode(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetVregMode(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetIOAMUX(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetCANLINmode(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetVregLP(MC33907_SET_T *ptr);

extern tU16 PwSBC_GetInitSupervisor1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitSupervisor2(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitSupervisor3(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitFSSM1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetInitFSSM2(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetWDwindow(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetWDLFSR(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetWDanswer(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetFSout(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetRSTbRequest(MC33907_SET_T *ptr);

extern tU16 PwSBC_GetDiagFS1(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetWDcounter(MC33907_SET_T *ptr);
extern tU16 PwSBC_GetDiagFS2(MC33907_SET_T *ptr);

extern tU16 PwSBC_ComputeParity(tU16);
extern tU16 PwSBC_ComputeSecurityBits(tU16);
extern void PwSBC_DelayFScmd();
extern void PwSBC_StoreRegister(tU32);
extern float PwSBC_GetVoltageTight();
extern float PwSBC_GetVoltageWide();
extern float PwSBC_GetVoltage();
extern float PwSBC_GetTemperature();
extern void PwSBC_ClearIntFlags();
extern tU16 PwSBC_SendCmdR(MC33907_SET_T *ptr);
extern tU16 PwSBC_SendCmdW(MC33907_SET_T *ptr);
extern tU16 PwSBC_SendCmdRW(MC33907_SET_T *ptr);
extern tU16 PwSBC_SendSecureCmdRW(MC33907_SET_T *ptr);
extern tU16 PwSBC_SendSecureCmdW(MC33907_SET_T *ptr);

extern tU16 PwSBC_SetInitVreg1(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitVreg2(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitCANLIN(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitIOWU1(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitIOWU2(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitINT(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitSupervisor1(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitSupervisor2(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitSupervisor3(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitFSSM1(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetInitFSSM2(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetMode(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetVregMode(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetIOAMUX(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetCANLINmode(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetVregLP(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetWDwindow(MC33907_SET_T *ptr);
extern tU16 PwSBC_SetWDLFSR(MC33907_SET_T *ptr);

extern tU16 MC33907_Init(MC33907_SET_T *ptr);

extern void PwSBC_IsrPIT_WD();
extern void PwSBC_IsrPIT_UART();

extern void PwSBC_IsrSIUL();
extern void PwSBC_IsrADC();

extern void	PwSBC_UpdateRegisters(MC33907_SET_T *ptr);
extern tU16 mc33907SpiSendWord(MC33907_DRV_SET_T *ptr, tU16 u16DspiOut, tU16 *ptDspiIn);

#endif
/* MC33905_ROUTINES_H */

