/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MC33937_pit_routines.c
*
* @author:	B34195
*
* @date: 	Aug 19, 2016
*
* @brief: 	
*
***************************************************************************/

#include "MC33937_pit_routines.h"

/***************************************************************************//*!
@brief          Function for configuration the HW for phase currents measurement

@param[in,out]  hw_ptr	Pointer to ph-current measurement HW configuration structure
				currentID - select one of two available HW configurations

@return         tBool

@details		Initialize the HW configuration according the selected PICe
 	 	 	 	motor connector. 3 phase currents measurement
******************************************************************************/
tBool MC33937_PIT_hw_init(MC33937_PIT_hw_cfg_t *hw_ptr, tU32 pitFreqMHZ){

	hw_ptr->pPitMCR 	= (volatile tU32 *)(PIT0_BASE);
	hw_ptr->pPitCVAL 	= (volatile tU32 *)(PIT0_BASE + PIT0_CVAL_OFFSET);
	hw_ptr->pPitLDVAL 	= (volatile tU32 *)(PIT0_BASE + PIT0_LDVAL_OFFSET);
	hw_ptr->pPitTCTRL0 	= (volatile tU32 *)(PIT0_BASE + PIT0_TCTRL_OFFSET);

	hw_ptr->scaleToNs    = (tU32)((tU32)1000000000/((tU32)(pitFreqMHZ*1000000)));

	return(TRUE);
}

/***************************************************************************//*!
@brief

@param[in,out]  this    Pointer to the current object.

@return         tU32

@details
******************************************************************************/
tU32 ReadValueNs_PIT(MC33937_PIT_hw_cfg_t * ptr)
{
	//static volatile tU32 temp;

	//temp = *(ptr->pPitCVAL );
    return((tU32)0xFFFFFFFF - (*(ptr->pPitCVAL )) * ptr->scaleToNs);
}

/***************************************************************************//*!
@brief

@param[in,out]  this    Pointer to the current object.

@return         tU32

@details
******************************************************************************/
extern tBool GetStatus_PIT(MC33937_PIT_hw_cfg_t * ptr){
    tBool statusPass = TRUE;

    statusPass = (tBool)(*(ptr->pPitTCTRL0) & 0x1);

    return(statusPass);
}

/***************************************************************************//*!
@brief

@param[in,out]  this    Pointer to the current object.

@return         tBool

@details
******************************************************************************/
tBool Start_PIT(MC33937_PIT_hw_cfg_t * ptr)
{
    tBool statusPass = TRUE;

    /* Disable PIT 0 timer (TCTRL.TEN = 0) */
    *(ptr->pPitTCTRL0) = (*(ptr->pPitTCTRL0) & (~0x00000001)) | ((0x0));

    /* Enable clock to PIT timers (MCR.MDIS = 0) */
    *(ptr->pPitMCR) = (tU32)0x0;

    /* Set LDVAL to max 32bit number */
    *(ptr->pPitLDVAL) = (tU32)0xFFFFFFFF;

    /* Enable PIT 0 timer (TCTRL.TEN = 1) */
    *(ptr->pPitTCTRL0) = (*(ptr->pPitTCTRL0) & (~0x00000001)) | ((0x1));


    return(statusPass);
}


















