/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MC33937_pit_routines.h
*
* @author:	B34195
*
* @date: 	Aug 19, 2016
*
* @brief: 	
*
***************************************************************************/
#ifndef BSP_MC33937_PIT_ROUTINES_H_
#define BSP_MC33937_PIT_ROUTINES_H_

#include "SWLIBS_Typedefs.h"

#define PIT0_BASE			0xFFF84000
#define PIT0_LDVAL_OFFSET	0x100
#define PIT0_CVAL_OFFSET	0x104
#define PIT0_TCTRL_OFFSET	0x108

typedef struct {
	volatile tU32 * pPitCVAL;
    volatile tU32 * pPitLDVAL;
    volatile tU32 * pPitMCR;
    volatile tU32 * pPitTCTRL0;

    volatile tU32   scaleToNs;
}MC33937_PIT_hw_cfg_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool MC33937_PIT_hw_init(MC33937_PIT_hw_cfg_t *hw_ptr, tU32 pitFreqMHZ);

extern tBool Start_PIT(MC33937_PIT_hw_cfg_t * ptr);
extern tU32 ReadValueNs_PIT(MC33937_PIT_hw_cfg_t * ptr);
extern tBool GetStatus_PIT(MC33937_PIT_hw_cfg_t * ptr);

#endif /* BSP_MC33937_PIT_ROUTINES_H_ */
