/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MC33937_spi_routines.c
*
* @author:	B34195
*
* @date: 	Aug 17, 2016
*
* @brief: 	Source file to configure the HW DSPI
*
***************************************************************************/

#include "MC33937_spi_routines.h"

/***************************************************************************//*!
@brief          Function for configuration the dspi periphery to communicate/configure
				MC33937 pre-driver

@param[in,out]  hw_ptr	Pointer to dspi HW configuration structure
				dspiID - select one of two available HW configurations

@return         tBool

@details		Initialize the HW configuration according the selected PICe
 	 	 	 	motor connector.
******************************************************************************/
tBool MC33937_dspi_hw_init(MC33937_SPI_hw_cfg_t *hw_ptr, tU16 spiID){
    switch (spiID)
    {
        case MC33937_DSPI_HW_PCIe_J1:
        	hw_ptr->pDspiSR 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_SR_OFFSET);
        	hw_ptr->pDspiPUSH 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_PUSH_OFFSET);
        	hw_ptr->pDspiPOP 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_POP_OFFSET);
        	hw_ptr->pDspiCTAR 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_CTAR_OFFSET + (4*MC33937_DSPI_CTAR0));

        	hw_ptr->pushCsCtarMask = ASSERT_CS1 | ASSERT_CTAR0;
            break;
        case MC33937_DSPI_HW_PCIe_J200:
        	hw_ptr->pDspiSR 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_SR_OFFSET);
        	hw_ptr->pDspiPUSH 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_PUSH_OFFSET);
        	hw_ptr->pDspiPOP 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_POP_OFFSET);
        	hw_ptr->pDspiCTAR 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_CTAR_OFFSET + (4*MC33937_DSPI_CTAR0));

        	hw_ptr->pushCsCtarMask = ASSERT_CS2 | ASSERT_CTAR0;
            break;
        default:
        	hw_ptr->pDspiSR 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_SR_OFFSET);
        	hw_ptr->pDspiPUSH 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_PUSH_OFFSET);
        	hw_ptr->pDspiPOP 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_POP_OFFSET);
        	hw_ptr->pDspiCTAR 	= (volatile tU32 *)(DSPI0_BASE + MC33937_DSPI_CTAR_OFFSET + (4*MC33937_DSPI_CTAR0));

        	hw_ptr->pushCsCtarMask = ASSERT_CS1 | ASSERT_CTAR0;
            break;
    }
	return(TRUE);
}

/***************************************************************************//*!
@brief			Send 8-bit command

@param[in,out]  this    Pointer to the current object.

@return         tBool

@details
******************************************************************************/
tBool SendCommand(MC33937_SPI_hw_cfg_t *hw_ptr, volatile tU8 * pTxData, volatile tU8 * pRxData)
{
   // volatile MC33937DSPI_T * module = (MC33937DSPI_T *)this;
    volatile tU8  txData8;
    volatile tU32 txData;

    tBool statusPass = TRUE;

    txData8 = *pTxData;

    txData = (0xFF) & ((tU32)txData8);

    txData |= hw_ptr->pushCsCtarMask;

    /* Clear TCF (Transfer Complete Flag) by writing 1 to it */
    *((volatile tU32 *)(hw_ptr->pDspiSR)) = 0x80000000;

    /* Write data to PUSH register */
    *((volatile tU32 *)(hw_ptr->pDspiPUSH)) = txData;

    /* Wait till TCF is true */
    while ((*((volatile tU32 *)(hw_ptr->pDspiSR)) & (0x80000000)) == 0);

    /* Read POP register */
    *pRxData = (tU8)(*((volatile tU32 *)(hw_ptr->pDspiPOP)));

    return(statusPass);
}
