/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MC33937_spi_routines.h
*
* @author:	B34195
*
* @date: 	Aug 17, 2016
*
* @brief: 	Header file to define the HW DSPI
*
***************************************************************************/
#ifndef BSP_MC33937_SPI_ROUTINES_H_
#define BSP_MC33937_SPI_ROUTINES_H_

#include "SWLIBS_Typedefs.h"
  /*
     * DSPI0 = 0xFFE70000
     * DSPI1 = 0xFFE74000
     * DSPI2 = 0xFBE70000
     *
     * DSPI0_CS0 MSCR number = 36
     * DSPI0_CS1 MSCR number = 79
     *
     * PUSH register mask - CS0 = 0x00010000
     * PUSH register mask - CS1 = 0x00020000
     * PUSH register mask - CS2 = 0x00040000
     * PUSH register mask - CS3 = 0x00080000
     * PUSH register mask - CS4 = 0x00100000
     * PUSH register mask - CS5 = 0x00200000
     * PUSH register mask - CS6 = 0x00400000
     * PUSH register mask - CS7 = 0x00800000
     *
     * PUSH register mask - CTAR0 = 0x00000000
     * PUSH register mask - CTAR1 = 0x10000000
     * PUSH register mask - CTAR2 = 0x20000000
     * PUSH register mask - CTAR3 = 0x30000000
     * PUSH register mask - CTAR4 = 0x40000000
     * PUSH register mask - CTAR5 = 0x50000000
     * PUSH register mask - CTAR6 = 0x60000000
     * PUSH register mask - CTAR7 = 0x70000000
     */

/*! Different HW configuration available */
#define MC33937_DSPI_HW_PCIe_J1			1
#define MC33937_DSPI_HW_PCIe_J200		2

/*! Macro containing the base address of DSPI 0 module */
#define DSPI0_BASE						0xFFE70000

/*! Macro containing the offset address of DSPI registers */
#define MC33937_DSPI_SR_OFFSET			0x2C
#define MC33937_DSPI_PUSH_OFFSET		0x34
#define MC33937_DSPI_POP_OFFSET			0x38
#define MC33937_DSPI_MCR_OFFSET			0x0
#define MC33937_DSPI_CTAR_OFFSET		0xC0

#define MC33937_DSPI_CTAR0				0
#define MC33937_DSPI_CTAR1				1

#define ASSERT_CS1      				0x00020000
#define ASSERT_CS2      				0x00040000

#define ASSERT_CTAR0    				0x00000000

/*------------------------------------------------------------------------*//*!
@brief  Structure of pointers to related DSPI registers
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU32       * pDspiSR;
    volatile tU32       * pDspiPUSH;
    volatile tU32       * pDspiPOP;
    volatile tU32       * pDspiCTAR;

    volatile tU32       pushCsCtarMask;

}MC33937_SPI_hw_cfg_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool MC33937_dspi_hw_init(MC33937_SPI_hw_cfg_t *hw_ptr, tU16 dspiID);
extern tBool SendCommand(MC33937_SPI_hw_cfg_t *hw_ptr, volatile tU8 * pTxData, volatile tU8 * pRxData);


#endif /* BSP_MC33937_SPI_ROUTINES_H_ */
