/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MPC5744P_BSP_Faults.c
*
* @author:	B34195
*
* @date: 	Mar 21, 2016
*
* @brief: 	
*
***************************************************************************/

#include "MPC5744P_BSP_Faults.h"

tU16 get_flexpwm_fault(tU16 faultNo, tU8 motorID){

	if(motorID == 0)
		return(((pPWM0->FSTS.B.FFPIN)>>faultNo)&0x1);

	return (((pPWM1->FSTS.B.FFPIN)>>faultNo)&0x1);
}

tU16 get_flexpwm_fault_flag(tU16 faultNo, tU8 motorID){

	if(motorID == 0)
		return(((pPWM0->FSTS.B.FFLAG)>>faultNo)&0x1);

	return(((pPWM1->FSTS.B.FFLAG)>>faultNo)&0x1);
}

tBool clear_flexpwm_fault_flag_manual(tU16 fflag, tU8 motorID){

	if(motorID == 0)
		pPWM0->FSTS.B.FFLAG = fflag;
	if(motorID == 1)
		pPWM1->FSTS.B.FFLAG = fflag;

	return(TRUE);
}
