/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MPC5744P_CB.c
*
* @author:	B34195
*
* @date: 	Feb 29, 2016
*
* @brief: 	Source file with implementation of the functions for board LEDs,
* 			user buttons and Flip/Flop switch, interfacing on-chip GPIO registers
*
***************************************************************************/

#include "MPC5744P_CB.h"

// LEDs initialization
tBool Led_indicator_init(userLedConfig_t *ptr){
	ptr->Led_D1 	= APP_LED_D1;
	ptr->Led_D2 	= APP_LED_D2;
	ptr->Led_D3 	= APP_LED_D3;
	ptr->Led_D18 	= APP_LED_D18;
	ptr->Led_D19 	= APP_LED_D19;
	ptr->Led_D20 	= APP_LED_D20;

    ptr->flashCounter = LED_FLASH_PERIOD;

	return(TRUE);
}

// User button/ On_Off switch init
tBool User_button_init(userButtonConfig_t *ptr, tU16 hwID){
    switch (hwID)
    {
        case buttons_GPDI_HW_J1:
        	ptr->upButton 	= M1_SW_UP_BUTT;
        	ptr->downButton = M1_SW_DOWN_BUTT;
        	ptr->flipFlop 	= M1_SW_RUN;
            break;
        case buttons_GPDI_HW_J200:
        	ptr->upButton 	= M2_SW_UP_BUTT;
        	ptr->downButton = M2_SW_DOWN_BUTT;
        	ptr->flipFlop 	= M2_SW_RUN;
            break;
        default:
        	ptr->upButton 	= M1_SW_UP_BUTT;
        	ptr->downButton = M1_SW_DOWN_BUTT;
        	ptr->flipFlop 	= M1_SW_RUN;
            break;
    }
	return(TRUE);
}

// Read state of input GP pin according to MSCR number
tU8 GPDI_read(volatile tU16 mscrNo){
	return(pSIUL->GPDI[mscrNo].B.PDI);
}

// Set the output of GPIO pin according to MSCR number
tBool GPDO_set(volatile tU16 mscrNo){
	pSIUL->GPDO[mscrNo].B.PDO = 1;
	return(TRUE);
}

// Clear the output of GPIO pin according to MSCR number
tBool GPDO_clear(volatile tU16 mscrNo){
	pSIUL->GPDO[mscrNo].B.PDO = 0;
	return(TRUE);
}

// Toggle the output of GPIO pin according to MSCR number
tBool GPDO_toogle(volatile tU16 mscrNo){
	pSIUL->GPDO[mscrNo].B.PDO ^= 1;
	return(TRUE);
}


// application LEDs control - all three LEDs are off
void stateLedsOFF(userLedConfig_t *ptr, uint8_t motor_id){
	if(motor_id == 0){
		GPDO_clear(ptr->Led_D1);
		GPDO_clear(ptr->Led_D2);
		GPDO_clear(ptr->Led_D3);
	}
	if(motor_id == 1){
		GPDO_clear(ptr->Led_D18);
		GPDO_clear(ptr->Led_D19);
		GPDO_clear(ptr->Led_D20);
	}
}

// application LEDs control - all three LEDs are on
void stateLedsON(userLedConfig_t *ptr, uint8_t motor_id){
	if(motor_id == 0){
		GPDO_set(ptr->Led_D1);
		GPDO_set(ptr->Led_D2);
		GPDO_set(ptr->Led_D3);
	}
	if(motor_id == 1){
		GPDO_set(ptr->Led_D18);
		GPDO_set(ptr->Led_D19);
		GPDO_set(ptr->Led_D20);
	}
}

// application LEDs control - all three LEDs are flashing slow
void stateLedFLASHING_SLOW(userLedConfig_t *ptr, uint8_t motor_id){
	static volatile tU16 runningCounter_M1;
	static volatile tU16 runningCounter_M2;

	if(motor_id == 0){
		runningCounter_M1 += 1;

		if(runningCounter_M1>((ptr->flashCounter)>>1))
		{
			GPDO_toogle(ptr->Led_D1);
			GPDO_toogle(ptr->Led_D2);
			GPDO_toogle(ptr->Led_D3);

			runningCounter_M1 = 0;
		}
	}
	if(motor_id == 1){
		runningCounter_M2 += 1;

		if(runningCounter_M2>((ptr->flashCounter)>>1))
		{
			GPDO_toogle(ptr->Led_D18);
			GPDO_toogle(ptr->Led_D19);
			GPDO_toogle(ptr->Led_D20);

			runningCounter_M2 = 0;
		}
	}
}

// application LEDs control - all three LEDs are flashing fast
void stateLedFLASHING_FAST(userLedConfig_t *ptr, uint8_t motor_id){
	static volatile tU16 runningCounter_M1;
	static volatile tU16 runningCounter_M2;

	if(motor_id == 0){
		runningCounter_M1 += 1;

		if(runningCounter_M1>((ptr->flashCounter)>>3))
		{
			GPDO_toogle(ptr->Led_D1);
			GPDO_toogle(ptr->Led_D2);
			GPDO_toogle(ptr->Led_D3);

			runningCounter_M1 = 0;
		}
	}
	if(motor_id == 1){
		runningCounter_M2 += 1;

		if(runningCounter_M2>((ptr->flashCounter)>>3))
		{
			GPDO_toogle(ptr->Led_D18);
			GPDO_toogle(ptr->Led_D19);
			GPDO_toogle(ptr->Led_D20);

			runningCounter_M2 = 0;
		}
	}
}

// application LEDs control - two LEDs are off, while one is flashing slow
void stateLedFLASHING_READY(userLedConfig_t *ptr, uint8_t motor_id){
	static volatile tU16 runningCounter_M1;
	static volatile tU16 runningCounter_M2;

	if(motor_id == 0){
		runningCounter_M1 += 1;

		if(runningCounter_M1>((ptr->flashCounter)>>1))
		{
			GPDO_toogle(ptr->Led_D1);
			runningCounter_M1 = 0;
		}
	}
	if(motor_id == 1){
		runningCounter_M2 += 1;

		if(runningCounter_M2>((ptr->flashCounter)>>1))
		{
			GPDO_toogle(ptr->Led_D18);
			runningCounter_M2 = 0;
		}
	}

}

/* Actual state ->         								'Reset'		  'Init'			'Fault'			   		'Ready'         	'Calib'					'Align'	          'Run'*/
extern PFCN_VOID_LED state_LED[7] = {stateLedsOFF, stateLedsOFF, stateLedFLASHING_FAST, stateLedFLASHING_READY, stateLedFLASHING_SLOW, stateLedFLASHING_SLOW, stateLedsON};
