/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	MPC5744P_CB.h
*
* @author:	B34195
*
* @date: 	Feb 29, 2016
*
* @brief:	Header file containing definition of user buttons, switch and
* 			LED indicators hardware dependent layer software component,
* 			with hw-configuration
*
***************************************************************************/

#ifndef MPC5744P_CB_H_
#define MPC5744P_CB_H_

#include "SWLIBS_Typedefs.h"
#include "siul.h"

/******************************************************************************
| defines and macros
|----------------------------------------------------------------------------*/
#define buttons_GPDI_HW_J1		1
#define buttons_GPDI_HW_J200	2

/*! Macro containing the MSCR register number of the FlipFlop switch */
#define M1_SW_RUN				12
#define M2_SW_RUN				15
/*! Macro containing the MSCR register number of the UP button */
#define M1_SW_UP_BUTT			48
#define M2_SW_UP_BUTT			77
/*! Macro containing the MSCR register number of the DOWN button */
#define M1_SW_DOWN_BUTT			92
#define M2_SW_DOWN_BUTT			42

/*! Macro containing the MSCR register number of the BRAKE_GATE signal */
#define BRAKE_GATE_J1			103
#define BRAKE_GATE_J200			127

/*! Macro containing the MSCR register numbers of the LED indicators */
#define APP_LED_D1				6
#define APP_LED_D2				7
#define APP_LED_D3				8
#define APP_LED_D18				56
#define APP_LED_D19				78
#define APP_LED_D20				83

#define LED_FLASH_PERIOD		5000 // stateLedFLASHING_SLOW = 2Hz @ 10KHz of FOC_Fast_ISR

/*NOTE! MSCR registers have to be set manually in the SUIL register config. in MPC5744P_appconfig.h*/

/*------------------------------------------------------------------------*//*!
@brief  Structure defines controller board available LED indicators
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU16   Led_D1;			//
    volatile tU16   Led_D2;			//
    volatile tU16   Led_D3;			//
    volatile tU16   Led_D18;		//
    volatile tU16   Led_D19;		//
    volatile tU16   Led_D20;		//

    volatile tU16	flashCounter; // LED flashing period
}userLedConfig_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure defines controller board available user buttons and switch
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU16   upButton;	// SW2 button
    volatile tU16   downButton;	// SW3 button
    volatile tU16   flipFlop;	// SW Run
}userButtonConfig_t;

// pointer to function with parameter
typedef void (*PFCN_VOID_LED)(userLedConfig_t *ptr, uint8_t motor_id); /* pointer to function with parameters*/
extern PFCN_VOID_LED state_LED[7];

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool User_button_init(userButtonConfig_t *ptr, tU16 hwID);
extern tBool Led_indicator_init(userLedConfig_t *ptr);

extern tU8 GPDI_read(volatile tU16 mscrNo);

extern tBool GPDO_set(volatile tU16 mscrNo);
extern tBool GPDO_clear(volatile tU16 mscrNo);
extern tBool GPDO_toogle(volatile tU16 mscrNo);

/* LED application user control*/
extern void stateLedsOFF(userLedConfig_t *ptr, uint8_t motor_id);
extern void stateLedsON(userLedConfig_t *ptr, uint8_t motor_id);
extern void stateLedFLASHING_SLOW(userLedConfig_t *ptr, uint8_t motor_id);
extern void stateLedFLASHING_FAST(userLedConfig_t *ptr, uint8_t motor_id);
extern void stateLedFLASHING_READY(userLedConfig_t *ptr, uint8_t motor_id);

#endif /* MPC5744P_CB_H_ */
