/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Resolver.h
*
* @author:	B34195
*
* @date: 	Aug 9, 2016
*
* @brief: 	Header file containing class definition of resolver position sensor
*           hardware dependent layer software component, with utilization of
*           on-chip ADC periphery.
*
***************************************************************************/
#ifndef BSP_RESOLVER_H_
#define BSP_RESOLVER_H_

#include "SWLIBS_Typedefs.h"
#include "mlib.h"
#include "gdflib.h"

/******************************************************************************
| defines and macros
|----------------------------------------------------------------------------*/

    /*  ADC base address
     *  resAdc0 = 0xFBE00000
     *  resAdc1 = 0xFFE04000
     *  resAdc2 = 0xFBE08000
     *  resAdc3 = 0xFFE0C000
     *
     *  ADC Channel Data Registers
     *  ADC_CDRn	= 0x100
     *
	 *	encETimer0 	= 0xFBC20000
	 *	encETimer1 	= 0xFFC24000
	 * 	encETimer2 	= 0xFBC28000	*/

/*! Different HW configuration available */
#define RES_HW_PCIe_J1			1
#define RES_HW_PCIe_J200		2

/*! Macro containing the base address of all ADC modules */
#define RES_ADC0_BASE			0xFBE00000
#define RES_ADC1_BASE			0xFFE04000
#define RES_ADC2_BASE			0xFBE08000
#define RES_ADC3_BASE			0xFFE0C000

/*! Macro containing the offset address of ADC channel data register */
#define ADC_CDRn_OFFSET			0x100

/*! Macro containing the ADC channel number	*/
#define RES_ADC_CH0				0
#define RES_ADC_CH2				2
#define RES_ADC_CH3				3
#define RES_ADC_CH4				4

/*! Macro containing the base address of all eTimer 0 & 1 modules */
#define RES_ETIMER0_BASE		0xFBC20000
#define RES_ETIMER1_BASE		0xFFC24000

/*! Macro containing the offset address of eTimer Enable register */
#define RES_ETIMER_ENBL			0x10C
/*! Macro containing the eTimer channel number	*/
#define RES_ETIMER_CH5			5

/*! Macro containing resolver calibration counter 	*/
#define RES_CALIB_CNTR			1000

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... resolver hw layer configuration
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU32	* pAdcSinData;
    volatile tU32	* pAdcCosData;

    volatile tU16	* pResExcitEtimer;
    volatile tU16	eTimerChannel;
}resolver_hw_cfg_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... calibration parameters
*//*-------------------------------------------------------------------------*/
typedef struct{
	volatile tU16	calibCntr;
	volatile tU16	calibDone;
	volatile tU16	calibInitDone;
}resolver_calib_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... resolver output data Sin/Cos status
	raw - raw value from ADC CDR register
	filt - after ADC DC offset calibration
*//*-------------------------------------------------------------------------*/
typedef struct{
	volatile tFloat	raw;
	volatile tFloat filt;
}res_filt_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing ... resolver data
*//*-------------------------------------------------------------------------*/
typedef struct{
	res_filt_t		ResSin;
	res_filt_t		ResCos;

    volatile tFloat ResSinDcOffset;
    volatile tFloat ResCosDcOffset;

    resolver_calib_t	calib;

    GDFLIB_FILTER_MA_T  MAF_Sin;	 // Moving average filter setting
    GDFLIB_FILTER_MA_T	MAF_Cos;	 // Moving average filter setting
}resolver_data_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool Resolver_hw_init(resolver_hw_cfg_t *hw_ptr, tU16 hwID);
extern tBool Resolver_get_data(resolver_hw_cfg_t *hw_ptr ,resolver_data_t *d_ptr);

extern tBool Resolver_enable_excitation(resolver_hw_cfg_t *hw_ptr);
extern tBool Resolver_disable_excitation(resolver_hw_cfg_t *hw_ptr);

extern tBool Resolver_inputs_calibration(resolver_hw_cfg_t *hw_ptr, resolver_data_t *d_ptr);

#endif /* BSP_RESOLVER_H_ */
