/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Voltage_gener.h
*
* @author:	B34195
*
* @date: 	Aug 22, 2016
*
* @brief: 	Header file containing definition of voltage actuator hardware dependent
* 			layer software component, with FlexPWM hw-configuration
*           and DutyCycle update registers structures
*
*
***************************************************************************/
#ifndef BSP_VOLTAGE_GENER_H_
#define BSP_VOLTAGE_GENER_H_


#include "SWLIBS_Typedefs.h"
#include "mlib.h"

/*! Different HW configuration available */
#define FLEXPWM_HW_PCIe_J1		1
#define FLEXPWM_HW_PCIe_J200	2

/*! Macro containing the base address of both FlexPWM modules */
#define FLEXPWM_0_BASE			0xFBC00000
#define FLEXPWM_1_BASE			0xFFC04000

/*! Macro containing the offset address of FlexPWM Init and Val registers */
#define FLEXPWM_INIT_OFFSET		0x2
#define FLEXPWM_VAL0_OFFSET		0x8
#define FLEXPWM_VAL1_OFFSET		0xA
#define FLEXPWM_VAL2_OFFSET		0xC
#define FLEXPWM_VAL3_OFFSET		0xE
#define FLEXPWM_VAL4_OFFSET		0x10
#define FLEXPWM_VAL5_OFFSET		0x12

/*! Macro containing the offset address of FlexPWM registers */
#define FLEXPWM_OUTEN_OFFSET	0x140
#define FLEXPWM_MASK_OFFSET		0x142
#define FLEXPWM_MCTRL_OFFSET	0x148

/*! Macro containing the FlexPWM subunit number	*/
#define FLEXPWM_SUB_0			0
#define FLEXPWM_SUB_1			1
#define FLEXPWM_SUB_2			2
#define FLEXPWM_SUB_3			3


/*------------------------------------------------------------------------*//*!
@brief  Structure containing
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tS16       * pFlexPwmINIT;
    volatile tS16       * pFlexPwmVAL0;
    volatile tS16       * pFlexPwmVAL1;
    volatile tS16       * pFlexPwmVAL2;
    volatile tS16       * pFlexPwmVAL3;
    volatile tS16       * pFlexPwmVAL4;
    volatile tS16       * pFlexPwmVAL5;
}flexPWM_val_compl;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing
*//*-------------------------------------------------------------------------*/
typedef struct{
	flexPWM_val_compl    s16Sub0;
	flexPWM_val_compl    s16Sub1;
	flexPWM_val_compl    s16Sub2;
	flexPWM_val_compl    s16Sub3;

	volatile tS16       * pFlexPwmOUTEN;
	volatile tS16       * pFlexPwmMASK;
	volatile tS16       * pFlexPwmMCTRL;

}flexPWM_hw_cfg_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing
*//*-------------------------------------------------------------------------*/
typedef struct{
    tU16    u16Sub0;
    tU16    u16Sub1;
    tU16    u16Sub2;
    tU16    u16Sub3;
}flexPWM_submodules;

/*------------------------------------------------------------------------*//*!
@brief  Structure containing
*//*-------------------------------------------------------------------------*/
typedef struct{
	SWLIBS_3Syst_FLT		PhABC;
	flexPWM_submodules		DutyCycle;

	volatile tS16			moduloSub0;
	volatile tS16			moduloSub1;
	volatile tS16			moduloSub2;

}flexPWM_sw_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
extern tBool FLEXPWM_hw_init(flexPWM_hw_cfg_t * hw_ptr, tU16 flexPwmID);
extern tBool FLEXPWM_get_modulo(flexPWM_hw_cfg_t * hw_ptr,flexPWM_sw_t * sw_ptr);
extern tBool FLEXPWM_set_LDOK(flexPWM_hw_cfg_t * hw_ptr);
extern tBool FLEXPWM_calc_3ph_DutyCycles(flexPWM_hw_cfg_t * hw_ptr,flexPWM_sw_t * sw_ptr);
extern tBool FLEXPWM_set_3ph_pwmVal(flexPWM_hw_cfg_t * hw_ptr,flexPWM_sw_t * sw_ptr);
extern tBool FLEXPWM_enable_output(flexPWM_hw_cfg_t * hw_ptr);
extern tBool FLEXPWM_disable_output(flexPWM_hw_cfg_t * hw_ptr);

extern tBool apply_voltages(flexPWM_hw_cfg_t * hw_ptr,flexPWM_sw_t * sw_ptr);


#endif /* BSP_VOLTAGE_GENER_H_ */
