/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Voltage_meas.c
*
* @author:	B34195
*
* @date: 	Aug 17, 2016
*
* @brief: 	Source file with implementation of functions initializing, interfacing
* 			on-chip ADC data registers to read dc-bus voltage
*
***************************************************************************/

#include "Voltage_meas.h"

/***************************************************************************//*!
@brief          Function for configuration the HW for DC bus volatge measurement

@param[in,out]  hw_ptr	Pointer to DC bus voltage measurement HW configuration structure
				currentID - select one of two available HW configurations

@return         tBool

@details		Initialize the HW configuration according the selected PICe
 	 	 	 	motor connector. DC bus voltage measurement.
******************************************************************************/
tBool DcbVoltage_meas_hw_init(dcb_voltage_meas_hw_cfg_t *hw_ptr, tU16 voltageID){
    switch (voltageID)
    {
        case VOLT_HW_PCIe_J1:
        	hw_ptr->pAdcUdcbAdata = (volatile tU32 *)(VOLT_ADC1_BASE + ADC_CDRn_OFFSET + (4 * VOLT_ADC_CH14));
            break;
        case VOLT_HW_PCIe_J200:
        	hw_ptr->pAdcUdcbAdata = (volatile tU32 *)(VOLT_ADC3_BASE + ADC_CDRn_OFFSET + (4 * VOLT_ADC_CH5));
            break;
        default:
        	hw_ptr->pAdcUdcbAdata = (volatile tU32 *)(VOLT_ADC1_BASE + ADC_CDRn_OFFSET + (4 * VOLT_ADC_CH14));
            break;
    }
	return(TRUE);
}

/***************************************************************************//*!
@brief          Function for reading ADC data registers containing converted
                values of dc-bus voltage signal.

@param[in,out]  hw_ptr	Pointer to dc-bus voltage measurement HW configuration structure
				d_ptr	Pointer to dc-bus voltage measurement data structure

@return         tBool

@details
******************************************************************************/
tBool DcbVoltage_get_data(dcb_voltage_meas_hw_cfg_t *hw_ptr ,dcb_voltage_meas_data_t *d_ptr, tFloat Umax){

	d_ptr->raw = MLIB_Mul(((tFloat)MLIB_Div((tFloat)((*(hw_ptr->pAdcUdcbAdata)) & 0x00000FFF), (tFloat)0x00000FFF)),Umax);

	d_ptr->filt = GDFLIB_FilterIIR1(d_ptr->raw,&d_ptr->IIR1_UdcbFilt);
	return(TRUE);
}
