/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
***************************************************************************//*
*
* @file:	Voltage_meas.h
*
* @author:	B34195
*
* @date: 	Aug 17, 2016
*
* @brief: 	Header file containing definition of dc-bus voltage sensor
*           hardware dependent layer software component, with hw-configuration
*           and data structures
*
***************************************************************************/
#ifndef BSP_VOLTAGE_MEAS_H_
#define BSP_VOLTAGE_MEAS_H_

#include "SWLIBS_Typedefs.h"
#include "mlib.h"
#include "gdflib.h"

/******************************************************************************
| defines and macros
|----------------------------------------------------------------------------*/

    /*  ADC base address
     *  resAdc0 = 0xFBE00000
     *  resAdc1 = 0xFFE04000
     *  resAdc2 = 0xFBE08000
     *  resAdc3 = 0xFFE0C000
     *
     *  ADC Channel Data Register offset
     *  ADC_CDRn	= 0x100
     */

/*! Different HW configuration available */
#define VOLT_HW_PCIe_J1			1
#define VOLT_HW_PCIe_J200		2

/*! Macro containing the base address of all ADC modules */
#define VOLT_ADC0_BASE			0xFBE00000
#define VOLT_ADC1_BASE			0xFFE04000
#define VOLT_ADC2_BASE			0xFBE08000
#define VOLT_ADC3_BASE			0xFFE0C000

/*! Macro containing the offset address of ADC channel data register */
#define ADC_CDRn_OFFSET			0x100

/*! Macro containing the ADC channel number	*/
#define VOLT_ADC_CH5			5
#define VOLT_ADC_CH6			6
#define VOLT_ADC_CH14			14

/*------------------------------------------------------------------------*//*!
@brief  Structure of pointers to related DC-bus voltage ADC data register
*//*-------------------------------------------------------------------------*/
typedef struct{
    volatile tU32	* pAdcUdcbAdata;
}dcb_voltage_meas_hw_cfg_t;

/*------------------------------------------------------------------------*//*!
@brief  Structure contains data of measured DC-bus voltage and MA filter
*//*-------------------------------------------------------------------------*/
typedef struct{
    tFloat    raw;   /*! raw value */
    tFloat    filt;  /*! filtered value */

	GDFLIB_FILTER_IIR1_T  IIR1_UdcbFilt;	 // DC bus voltage filter settings

}dcb_voltage_meas_data_t;

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/

extern tBool DcbVoltage_meas_hw_init(dcb_voltage_meas_hw_cfg_t *hw_ptr, tU16 voltageID);
extern tBool DcbVoltage_get_data(dcb_voltage_meas_hw_cfg_t *hw_ptr ,dcb_voltage_meas_data_t *d_ptr, tFloat Umax);

#endif /* BSP_VOLTAGE_MEAS_H_ */
