/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     adc.c
*
* @author   r63172
* 
* @version  1.0.1.0
* 
* @date     Nov-15-2010
* 
* @brief    ADC - Analog to Digital Converter for MPC5643L
*
*******************************************************************************
*
* This file includes initial setting function of MPC5643L ADC peripheral module.
*
******************************************************************************/
#include "adc.h"

/******************************************************************************
* ADC functions
*****************************************************************************/
//volatile struct ADC_tag *pADC_0;
volatile struct ADC_tag *pADC_0;
volatile struct ADC_tag *pADC_1;
volatile struct ADC_tag *pADC_2;
volatile struct ADC_tag *pADC_3;

/***************************************************************************//*!
@brief          ADC0 init function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes basic start-up setting of the ADC0
                converter.

@note           

@warning        
******************************************************************************/
void adc0_init(void)
{
    // initialization of peripheral base address
    pADC_0	= &ADC_0;
    
    pADC_0->MCR.R       	= 0x00000000UL;		/* Disable power down mode */
    pADC_0->CEOCFR0.R		= 0x000FU;
    pADC_0->IMR.R       	= 0x0U;
    pADC_0->CIMR0.R     	= 0x00000000UL;
    pADC_0->WTIMR.R     	= 0x00000000UL;
    pADC_0->DMAE.R      	= 0x00000000UL;
    pADC_0->DMAR0.R     	= 0x00000000UL;
    pADC_0->THRHLR0.R   	= 0x0FFF0000UL;
    pADC_0->THRHLR1.R   	= 0x0FFF0000UL;
    pADC_0->THRHLR2.R   	= 0x0FFF0000UL;
    pADC_0->THRHLR3.R   	= 0x0FFF0000UL;
    pADC_0->PSCR.R      	= 0x00000000UL;
    pADC_0->PSR0.R      	= 0x00000000UL;
    pADC_0->CTR0.R      	= 0x00000016UL;
    pADC_0->CTR1.R      	= 0x00000016UL;
    pADC_0->NCMR0.R     	= 0x00000000UL;
    pADC_0->JCMR0.R     	= 0x00000000UL;
    pADC_0->PDEDR.R     	= 0x00000000UL;
    pADC_0->THRHLR4.R		= 0x0FFF0000UL;
    pADC_0->THRHLR5.R		= 0x0FFF0000UL;
    pADC_0->THRHLR6.R		= 0x0FFF0000UL;
    pADC_0->THRHLR7.R		= 0x0FFF0000UL;
    pADC_0->THRHLR8.R		= 0x0FFF0000UL;
    pADC_0->THRHLR9.R		= 0x0FFF0000UL;
    pADC_0->THRHLR10.R		= 0x0FFF0000UL;
    pADC_0->THRHLR11.R		= 0x0FFF0000UL;
    pADC_0->THRHLR12.R		= 0x0FFF0000UL;
    pADC_0->THRHLR13.R		= 0x0FFF0000UL;
    pADC_0->THRHLR14.R		= 0x0FFF0000UL;
    pADC_0->THRHLR15.R		= 0x0FFF0000UL;
    pADC_0->CWSELR0.R		= 0x00000000UL;
    pADC_0->CWSELR1.R		= 0x00000000UL;
    pADC_0->CWENR0.R		= 0x00000000UL;
    pADC_0->AWORR0.R		= 0x00000000UL;
    pADC_0->STSR1.R			= 0x18182507UL;
    pADC_0->STCR2.R			= 0x00000005UL;
    pADC_0->STCR3.R			= 0x00000300UL;
    pADC_0->STBRR.R			= 0x00050000UL;
    pADC_0->STAW0R.R		= 0x072704C5UL;
    pADC_0->STAW1AR.R		= 0x00030001UL;
    pADC_0->STAW1BR.R		= 0x03E80ED0UL;
    pADC_0->STAW2R.R		= 0x00000FF9UL;
    pADC_0->STAW4R.R		= 0x00100FF0UL;
    pADC_0->STAW5R.R		= 0x00100FF0UL;
    pADC_0->CALBISTREG.R	= 0x003706F0UL;
    pADC_0->OFSGNUSR.R		= 0x00000000UL;
   // pADC_0->ALTR.R			= 0x00000000UL;

    #ifdef ADC0_MCR                                 /* MCR register */
    	pADC_0->MCR.R       = 0x00000001UL;		/* Enable power down mode */
        pADC_0->MCR.R       = ADC0_MCR;
    #endif

	#ifdef ADC0_CEOCFR0                             /* CEOCFR0 register */
        pADC_0->CEOCFR0.R	= ADC0_CEOCFR0;
	#endif

    #ifdef ADC0_IMR                                 /* IMR register */
        pADC_0->IMR.R       = ADC0_IMR;
    #endif
    
    #ifdef ADC0_CIMR0                               /* CIMR0 register */
        pADC_0->CIMR0.R     = ADC0_CIMR0;
    #endif
    
    #ifdef ADC0_WTIMR                               /* WTIMR register */
        pADC_0->WTIMR.R     = ADC0_WTIMR;
    #endif
    
    #ifdef ADC0_DMAE                                /* DMAE register */
        pADC_0->DMAE.R      = ADC0_DMAE;
    #endif
    
    #ifdef ADC0_DMAR0                               /* DMAR0 register */
        pADC_0->DMAR0.R     = ADC0_DMAR0;
    #endif
    
    #ifdef ADC0_THRHLR0                             /* THRHLR0 register */
        pADC_0->THRHLR0.R   = ADC0_THRHLR0;
    #endif
    
    #ifdef ADC0_THRHLR1                             /* THRHLR1 register */
        pADC_0->THRHLR1.R   = ADC0_THRHLR1;
    #endif
    
    #ifdef ADC0_THRHLR2                             /* THRHLR2 register */
        pADC_0->THRHLR2.R   = ADC0_THRHLR2;
    #endif
    
    #ifdef ADC0_THRHLR3                             /* THRHLR3 register */
        pADC_0->THRHLR3.R   = ADC0_THRHLR3;
    #endif
    
    #ifdef ADC0_PSCR                                /* PSCR register */
        pADC_0->PSCR.R      = ADC0_PSCR;
    #endif
    
    #ifdef ADC0_PSR0                                /* PSR0 register */
        pADC_0->PSR0.R      = ADC0_PSR0;
    #endif
    
    #ifdef ADC0_CTR0                                /* CTR0 register */
        pADC_0->CTR0.R      = ADC0_CTR0;
    #endif
    
    #ifdef ADC0_CTR1                                /* CTR1 register */
        pADC_0->CTR1.R      = ADC0_CTR1;
    #endif
    
    #ifdef ADC0_NCMR0                               /* NCMR0 register */
        pADC_0->NCMR0.R     = ADC0_NCMR0;
    #endif
    
    #ifdef ADC0_JCMR0                               /* JCMR0 register */
        pADC_0->JCMR0.R     = ADC0_JCMR0;
    #endif
    
    #ifdef ADC0_PDEDR                               /* PDEDR register */
        pADC_0->PDEDR.R     = ADC0_PDEDR;
    #endif

    #ifdef ADC0_THRHLR4                               /* THRHLR4 register */
		pADC_0->THRHLR4.R	= ADC0_THRHLR4;
	#endif

	#ifdef ADC0_THRHLR5                               /* THRHLR5 register */
		pADC_0->THRHLR5.R	= ADC0_THRHLR5;
	#endif

	#ifdef ADC0_THRHLR6                               /* THRHLR6 register */
		pADC_0->THRHLR6.R	= ADC0_THRHLR6;
	#endif

	#ifdef ADC0_THRHLR7                               /* THRHLR7 register */
		pADC_0->THRHLR7.R	= ADC0_THRHLR7;
	#endif

	#ifdef ADC0_THRHLR8                               /* THRHLR8 register */
		pADC_0->THRHLR8.R	= ADC0_THRHLR8;
	#endif

	#ifdef ADC0_THRHLR9                               /* THRHLR9 register */
		pADC_0->THRHLR9.R	= ADC0_THRHLR9;
	#endif

	#ifdef ADC0_THRHLR10                               /* THRHLR10 register */
		pADC_0->THRHLR10.R	= ADC0_THRHLR10;
	#endif

	#ifdef ADC0_THRHLR11                               /* THRHLR11 register */
		pADC_0->THRHLR11.R	= ADC0_THRHLR11;
	#endif

	#ifdef ADC0_THRHLR12                               /* THRHLR12 register */
		pADC_0->THRHLR12.R	= ADC0_THRHLR12;
	#endif

	#ifdef ADC0_THRHLR13                              /* THRHLR13 register */
		pADC_0->THRHLR13.R	= ADC0_THRHLR13;
	#endif

	#ifdef ADC0_THRHLR14                              /* THRHLR14 register */
		pADC_0->THRHLR14.R	= ADC0_THRHLR14;
	#endif

	#ifdef ADC0_THRHLR15                               /* THRHLR15 register */
		pADC_0->THRHLR15.R	= ADC0_THRHLR15;
	#endif
}

/***************************************************************************//*!
@brief          ADC1 initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes basic start-up setting of the ADC1
                converter.

@note           

@warning        
******************************************************************************/
void adc1_init(void)
{
    // initialization of peripheral base address
    pADC_1	= &ADC_1;
    
    pADC_1->MCR.R       	= 0x00000000UL;
    pADC_1->CEOCFR0.R		= 0x000FU;
    pADC_1->IMR.R       	= 0x0U;
    pADC_1->CIMR0.R     	= 0x00000000UL;
    pADC_1->WTIMR.R     	= 0x00000000UL;
    pADC_1->DMAE.R      	= 0x00000000UL;
    pADC_1->DMAR0.R     	= 0x00000000UL;
    pADC_1->THRHLR0.R   	= 0x0FFF0000UL;
    pADC_1->THRHLR1.R   	= 0x0FFF0000UL;
    pADC_1->THRHLR2.R   	= 0x0FFF0000UL;
    pADC_1->THRHLR3.R   	= 0x0FFF0000UL;
    pADC_1->PSCR.R      	= 0x00000000UL;
    pADC_1->PSR0.R      	= 0x00000000UL;
    pADC_1->CTR0.R      	= 0x00000016UL;
    pADC_1->CTR1.R      	= 0x00000016UL;
    pADC_1->NCMR0.R     	= 0x00000000UL;
    pADC_1->JCMR0.R     	= 0x00000000UL;
    pADC_1->PDEDR.R     	= 0x00000000UL;
    pADC_1->THRHLR4.R		= 0x0FFF0000UL;
    pADC_1->THRHLR5.R		= 0x0FFF0000UL;
    pADC_1->THRHLR6.R		= 0x0FFF0000UL;
    pADC_1->THRHLR7.R		= 0x0FFF0000UL;
    pADC_1->THRHLR8.R		= 0x0FFF0000UL;
    pADC_1->THRHLR9.R		= 0x0FFF0000UL;
    pADC_1->THRHLR10.R		= 0x0FFF0000UL;
    pADC_1->THRHLR11.R		= 0x0FFF0000UL;
    pADC_1->THRHLR12.R		= 0x0FFF0000UL;
    pADC_1->THRHLR13.R		= 0x0FFF0000UL;
    pADC_1->THRHLR14.R		= 0x0FFF0000UL;
    pADC_1->THRHLR15.R		= 0x0FFF0000UL;
    pADC_1->CWSELR0.R		= 0x00000000UL;
    pADC_1->CWSELR1.R		= 0x00000000UL;
    pADC_1->CWENR0.R		= 0x00000000UL;
    pADC_1->AWORR0.R		= 0x00000000UL;
    pADC_1->STSR1.R			= 0x18182507UL;
    pADC_1->STCR2.R			= 0x00000005UL;
    pADC_1->STCR3.R			= 0x00000300UL;
    pADC_1->STBRR.R			= 0x00050000UL;
    pADC_1->STAW0R.R		= 0x072704C5UL;
    pADC_1->STAW1AR.R		= 0x00030001UL;
    pADC_1->STAW1BR.R		= 0x03E80ED0UL;
    pADC_1->STAW2R.R		= 0x00000FF9UL;
    pADC_1->STAW4R.R		= 0x00100FF0UL;
    pADC_1->STAW5R.R		= 0x00100FF0UL;
    pADC_1->CALBISTREG.R	= 0x003706F0UL;
    pADC_1->OFSGNUSR.R		= 0x00000000UL;
    //pADC_1->ALTR.R			= 0x00000000UL;

    #ifdef ADC1_MCR                                 /* MCR register */
        pADC_1->MCR.R       = ADC1_MCR;
    #endif
    
	#ifdef ADC1_CEOCFR0                             /* CEOCFR0 register */
        pADC_1->CEOCFR0.R	= ADC1_CEOCFR0;
	#endif

    #ifdef ADC1_IMR                                 /* IMR register */
        pADC_1->IMR.R       = ADC1_IMR;
    #endif
    
    #ifdef ADC1_CIMR0                               /* CIMR0 register */
        pADC_1->CIMR0.R     = ADC1_CIMR0;
    #endif
    
    #ifdef ADC1_WTIMR                               /* WTIMR register */
        pADC_1->WTIMR.R     = ADC1_WTIMR;
    #endif
    
    #ifdef ADC1_DMAE                                /* DMAE register */
        pADC_1->DMAE.R      = ADC1_DMAE;
    #endif
    
    #ifdef ADC1_DMAR0                               /* DMAR0 register */
        pADC_1->DMAR0.R     = ADC1_DMAR0;
    #endif
    
    #ifdef ADC1_THRHLR0                             /* THRHLR0 register */
        pADC_1->THRHLR0.R   = ADC1_THRHLR0;
    #endif

    #ifdef ADC1_THRHLR1                             /* THRHLR1 register */
        pADC_1->THRHLR1.R   = ADC1_THRHLR1;
    #endif

    #ifdef ADC1_THRHLR2                             /* THRHLR2 register */
        pADC_1->THRHLR2.R   = ADC1_THRHLR2;
    #endif

    #ifdef ADC1_THRHLR3                             /* THRHLR3 register */
        pADC_1->THRHLR3.R   = ADC1_THRHLR3;
    #endif

    #ifdef ADC1_PSCR                                /* PSCR register */
        pADC_1->PSCR.R      = ADC1_PSCR;
    #endif

    #ifdef ADC1_PSR0                                /* PSR0 register */
        pADC_1->PSR0.R      = ADC1_PSR0;
    #endif

    #ifdef ADC1_CTR0                                /* CTR0 register */
        pADC_1->CTR0.R      = ADC1_CTR0;
    #endif

    #ifdef ADC1_CTR1                                /* CTR1 register */
        pADC_1->CTR1.R      = ADC1_CTR1;
    #endif

    #ifdef ADC1_NCMR0                               /* NCMR0 register */
        pADC_1->NCMR0.R     = ADC1_NCMR0;
    #endif

    #ifdef ADC1_JCMR0                               /* JCMR0 register */
        pADC_1->JCMR0.R     = ADC1_JCMR0;
    #endif

    #ifdef ADC1_PDEDR                               /* PDEDR register */
        pADC_1->PDEDR.R     = ADC1_PDEDR;
    #endif

    #ifdef ADC1_THRHLR4                               /* THRHLR4 register */
		pADC_1->THRHLR4.R	= ADC1_THRHLR4;
	#endif

	#ifdef ADC1_THRHLR5                               /* THRHLR5 register */
		pADC_1->THRHLR5.R	= ADC1_THRHLR5;
	#endif

	#ifdef ADC1_THRHLR6                               /* THRHLR6 register */
		pADC_1->THRHLR6.R	= ADC1_THRHLR6;
	#endif

	#ifdef ADC1_THRHLR7                               /* THRHLR7 register */
		pADC_1->THRHLR7.R	= ADC1_THRHLR7;
	#endif

	#ifdef ADC1_THRHLR8                               /* THRHLR8 register */
		pADC_1->THRHLR8.R	= ADC1_THRHLR8;
	#endif

	#ifdef ADC1_THRHLR9                               /* THRHLR9 register */
		pADC_1->THRHLR9.R	= ADC1_THRHLR9;
	#endif

	#ifdef ADC1_THRHLR10                               /* THRHLR10 register */
		pADC_1->THRHLR10.R	= ADC1_THRHLR10;
	#endif

	#ifdef ADC1_THRHLR11                               /* THRHLR11 register */
		pADC_1->THRHLR11.R	= ADC1_THRHLR11;
	#endif

	#ifdef ADC1_THRHLR12                               /* THRHLR12 register */
		pADC_1->THRHLR12.R	= ADC1_THRHLR12;
	#endif

	#ifdef ADC1_THRHLR13                              /* THRHLR13 register */
		pADC_1->THRHLR13.R	= ADC1_THRHLR13;
	#endif

	#ifdef ADC1_THRHLR14                              /* THRHLR14 register */
		pADC_1->THRHLR14.R	= ADC1_THRHLR14;
	#endif

	#ifdef ADC1_THRHLR15                               /* THRHLR15 register */
		pADC_1->THRHLR15.R	= ADC1_THRHLR15;
	#endif
}

/***************************************************************************//*!
@brief          ADC2 init function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes basic start-up setting of the ADC2
                converter.

@note

@warning
******************************************************************************/
void adc2_init(void)
{
    // initialization of peripheral base address
    pADC_2	= &ADC_2;

    pADC_2->MCR.R       	= 0x00000000UL;
    pADC_2->CEOCFR0.R		= 0x000FU;
    pADC_2->IMR.R       	= 0x0U;
    pADC_2->CIMR0.R     	= 0x00000000UL;
    pADC_2->WTIMR.R     	= 0x00000000UL;
    pADC_2->DMAE.R      	= 0x00000000UL;
    pADC_2->DMAR0.R     	= 0x00000000UL;
    pADC_2->THRHLR0.R   	= 0x0FFF0000UL;
    pADC_2->THRHLR1.R   	= 0x0FFF0000UL;
    pADC_2->THRHLR2.R   	= 0x0FFF0000UL;
    pADC_2->THRHLR3.R   	= 0x0FFF0000UL;
    pADC_2->PSCR.R      	= 0x00000000UL;
    pADC_2->PSR0.R      	= 0x00000000UL;
    pADC_2->CTR0.R      	= 0x00000016UL;
    pADC_2->CTR1.R      	= 0x00000016UL;
    pADC_2->NCMR0.R     	= 0x00000000UL;
    pADC_2->JCMR0.R     	= 0x00000000UL;
    pADC_2->PDEDR.R     	= 0x00000000UL;
    pADC_2->THRHLR4.R		= 0x0FFF0000UL;
    pADC_2->THRHLR5.R		= 0x0FFF0000UL;
    pADC_2->THRHLR6.R		= 0x0FFF0000UL;
    pADC_2->THRHLR7.R		= 0x0FFF0000UL;
    pADC_2->THRHLR8.R		= 0x0FFF0000UL;
    pADC_2->THRHLR9.R		= 0x0FFF0000UL;
    pADC_2->THRHLR10.R		= 0x0FFF0000UL;
    pADC_2->THRHLR11.R		= 0x0FFF0000UL;
    pADC_2->THRHLR12.R		= 0x0FFF0000UL;
    pADC_2->THRHLR13.R		= 0x0FFF0000UL;
    pADC_2->THRHLR14.R		= 0x0FFF0000UL;
    pADC_2->THRHLR15.R		= 0x0FFF0000UL;
    pADC_2->CWSELR0.R		= 0x00000000UL;
    pADC_2->CWSELR1.R		= 0x00000000UL;
    pADC_2->CWENR0.R		= 0x00000000UL;
    pADC_2->AWORR0.R		= 0x00000000UL;
    pADC_2->STSR1.R			= 0x18182507UL;
    pADC_2->STCR2.R			= 0x00000005UL;
    pADC_2->STCR3.R			= 0x00000300UL;
    pADC_2->STBRR.R			= 0x00050000UL;
    pADC_2->STAW0R.R		= 0x072704C5UL;
    pADC_2->STAW1AR.R		= 0x00030001UL;
    pADC_2->STAW1BR.R		= 0x03E80ED0UL;
    pADC_2->STAW2R.R		= 0x00000FF9UL;
    pADC_2->STAW4R.R		= 0x00100FF0UL;
    pADC_2->STAW5R.R		= 0x00100FF0UL;
    pADC_2->CALBISTREG.R	= 0x003706F0UL;
    pADC_2->OFSGNUSR.R		= 0x00000000UL;
    //pADC_2->ALTR.R			= 0x00000000UL;

    #ifdef ADC2_MCR                                 /* MCR register */
        pADC_2->MCR.R       = ADC2_MCR;
    #endif

	#ifdef ADC2_CEOCFR0                             /* CEOCFR0 register */
        pADC_2->CEOCFR0.R	= ADC2_CEOCFR0;
	#endif

    #ifdef ADC2_IMR                                 /* IMR register */
        pADC_2->IMR.R       = ADC2_IMR;
    #endif

    #ifdef ADC2_CIMR0                               /* CIMR0 register */
        pADC_2->CIMR0.R     = ADC2_CIMR0;
    #endif

    #ifdef ADC2_WTIMR                               /* WTIMR register */
        pADC_2->WTIMR.R     = ADC2_WTIMR;
    #endif

    #ifdef ADC2_DMAE                                /* DMAE register */
        pADC_2->DMAE.R      = ADC2_DMAE;
    #endif
    
    #ifdef ADC2_DMAR0                               /* DMAR0 register */
        pADC_2->DMAR0.R     = ADC2_DMAR0;
    #endif
    
    #ifdef ADC2_THRHLR0                             /* THRHLR0 register */
        pADC_2->THRHLR0.R   = ADC2_THRHLR0;
    #endif
    
    #ifdef ADC2_THRHLR1                             /* THRHLR1 register */
        pADC_2->THRHLR1.R   = ADC2_THRHLR1;
    #endif
    
    #ifdef ADC2_THRHLR2                             /* THRHLR2 register */
        pADC_2->THRHLR2.R   = ADC2_THRHLR2;
    #endif
    
    #ifdef ADC2_THRHLR3                             /* THRHLR3 register */
        pADC_2->THRHLR3.R   = ADC2_THRHLR3;
    #endif
    
    #ifdef ADC2_PSCR                                /* PSCR register */
        pADC_2->PSCR.R      = ADC2_PSCR;
    #endif
    
    #ifdef ADC2_PSR0                                /* PSR0 register */
        pADC_2->PSR0.R      = ADC2_PSR0;
    #endif
    
    #ifdef ADC2_CTR0                                /* CTR0 register */
        pADC_2->CTR0.R      = ADC2_CTR0;
    #endif
    
    #ifdef ADC2_CTR1                                /* CTR1 register */
        pADC_2->CTR1.R      = ADC2_CTR1;
    #endif
    
    #ifdef ADC2_NCMR0                               /* NCMR0 register */
        pADC_2->NCMR0.R     = ADC2_NCMR0;
    #endif
    
    #ifdef ADC2_JCMR0                               /* JCMR0 register */
        pADC_2->JCMR0.R     = ADC2_JCMR0;
    #endif
    
    #ifdef ADC2_PDEDR                               /* PDEDR register */
        pADC_2->PDEDR.R     = ADC2_PDEDR;
    #endif

    #ifdef ADC2_THRHLR4                               /* THRHLR4 register */
		pADC_2->THRHLR4.R	= ADC2_THRHLR4;
	#endif

	#ifdef ADC2_THRHLR5                               /* THRHLR5 register */
		pADC_2->THRHLR5.R	= ADC2_THRHLR5;
	#endif

	#ifdef ADC2_THRHLR6                               /* THRHLR6 register */
		pADC_2->THRHLR6.R	= ADC2_THRHLR6;
	#endif

	#ifdef ADC2_THRHLR7                               /* THRHLR7 register */
		pADC_2->THRHLR7.R	= ADC2_THRHLR7;
	#endif

	#ifdef ADC2_THRHLR8                               /* THRHLR8 register */
		pADC_2->THRHLR8.R	= ADC2_THRHLR8;
	#endif

	#ifdef ADC2_THRHLR9                               /* THRHLR9 register */
		pADC_2->THRHLR9.R	= ADC2_THRHLR9;
	#endif

	#ifdef ADC2_THRHLR10                               /* THRHLR10 register */
		pADC_2->THRHLR10.R	= ADC2_THRHLR10;
	#endif

	#ifdef ADC2_THRHLR11                               /* THRHLR11 register */
		pADC_2->THRHLR11.R	= ADC2_THRHLR11;
	#endif

	#ifdef ADC2_THRHLR12                               /* THRHLR12 register */
		pADC_2->THRHLR12.R	= ADC2_THRHLR12;
	#endif

	#ifdef ADC2_THRHLR13                              /* THRHLR13 register */
		pADC_2->THRHLR13.R	= ADC2_THRHLR13;
	#endif

	#ifdef ADC2_THRHLR14                              /* THRHLR14 register */
		pADC_2->THRHLR14.R	= ADC2_THRHLR14;
	#endif

	#ifdef ADC2_THRHLR15                               /* THRHLR15 register */
		pADC_2->THRHLR15.R	= ADC2_THRHLR15;
	#endif
}

/***************************************************************************//*!
@brief          ADC3 init function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes basic start-up setting of the ADC3
                converter.

@note

@warning
******************************************************************************/
void adc3_init(void)
{
    // initialization of peripheral base address
    pADC_3	= &ADC_3;
    
    pADC_3->MCR.R       	= 0x00000000UL;
    pADC_3->CEOCFR0.R		= 0x000FU;
    pADC_3->IMR.R       	= 0x0U;
    pADC_3->CIMR0.R     	= 0x00000000UL;
    pADC_3->WTIMR.R     	= 0x00000000UL;
    pADC_3->DMAE.R      	= 0x00000000UL;
    pADC_3->DMAR0.R     	= 0x00000000UL;
    pADC_3->THRHLR0.R   	= 0x0FFF0000UL;
    pADC_3->THRHLR1.R   	= 0x0FFF0000UL;
    pADC_3->THRHLR2.R   	= 0x0FFF0000UL;
    pADC_3->THRHLR3.R   	= 0x0FFF0000UL;
    pADC_3->PSCR.R      	= 0x00000000UL;
    pADC_3->PSR0.R      	= 0x00000000UL;
    pADC_3->CTR0.R      	= 0x00000016UL;
    pADC_3->CTR1.R      	= 0x00000016UL;
    pADC_3->NCMR0.R     	= 0x00000000UL;
    pADC_3->JCMR0.R     	= 0x00000000UL;
    pADC_3->PDEDR.R     	= 0x00000000UL;
    pADC_3->THRHLR4.R		= 0x0FFF0000UL;
    pADC_3->THRHLR5.R		= 0x0FFF0000UL;
    pADC_3->THRHLR6.R		= 0x0FFF0000UL;
    pADC_3->THRHLR7.R		= 0x0FFF0000UL;
    pADC_3->THRHLR8.R		= 0x0FFF0000UL;
    pADC_3->THRHLR9.R		= 0x0FFF0000UL;
    pADC_3->THRHLR10.R		= 0x0FFF0000UL;
    pADC_3->THRHLR11.R		= 0x0FFF0000UL;
    pADC_3->THRHLR12.R		= 0x0FFF0000UL;
    pADC_3->THRHLR13.R		= 0x0FFF0000UL;
    pADC_3->THRHLR14.R		= 0x0FFF0000UL;
    pADC_3->THRHLR15.R		= 0x0FFF0000UL;
    pADC_3->CWSELR0.R		= 0x00000000UL;
    pADC_3->CWSELR1.R		= 0x00000000UL;
    pADC_3->CWENR0.R		= 0x00000000UL;
    pADC_3->AWORR0.R		= 0x00000000UL;
    pADC_3->STSR1.R			= 0x18182507UL;
    pADC_3->STCR2.R			= 0x00000005UL;
    pADC_3->STCR3.R			= 0x00000300UL;
    pADC_3->STBRR.R			= 0x00050000UL;
    pADC_3->STAW0R.R		= 0x072704C5UL;
    pADC_3->STAW1AR.R		= 0x00030001UL;
    pADC_3->STAW1BR.R		= 0x03E80ED0UL;
    pADC_3->STAW2R.R		= 0x00000FF9UL;
    pADC_3->STAW4R.R		= 0x00100FF0UL;
    pADC_3->STAW5R.R		= 0x00100FF0UL;
    pADC_3->CALBISTREG.R	= 0x003706F0UL;
    pADC_3->OFSGNUSR.R		= 0x00000000UL;
    //pADC_3->ALTR.R			= 0x00000000UL;

    #ifdef ADC3_MCR                                 /* MCR register */
        pADC_3->MCR.R       = ADC3_MCR;
    #endif
    
	#ifdef ADC3_CEOCFR0                             /* CEOCFR0 register */
        pADC_3->CEOCFR0.R	= ADC3_CEOCFR0;
	#endif

    #ifdef ADC3_IMR                                 /* IMR register */
        pADC_3->IMR.R       = ADC3_IMR;
    #endif
    
    #ifdef ADC3_CIMR0                               /* CIMR0 register */
        pADC_3->CIMR0.R     = ADC3_CIMR0;
    #endif
    
    #ifdef ADC3_WTIMR                               /* WTIMR register */
        pADC_3->WTIMR.R     = ADC3_WTIMR;
    #endif
    
    #ifdef ADC3_DMAE                                /* DMAE register */
        pADC_3->DMAE.R      = ADC3_DMAE;
    #endif
    
    #ifdef ADC3_DMAR0                               /* DMAR0 register */
        pADC_3->DMAR0.R     = ADC3_DMAR0;
    #endif
    
    #ifdef ADC3_THRHLR0                             /* THRHLR0 register */
        pADC_3->THRHLR0.R   = ADC3_THRHLR0;
    #endif
    
    #ifdef ADC3_THRHLR1                             /* THRHLR1 register */
        pADC_3->THRHLR1.R   = ADC3_THRHLR1;
    #endif
    
    #ifdef ADC3_THRHLR2                             /* THRHLR2 register */
        pADC_3->THRHLR2.R   = ADC3_THRHLR2;
    #endif
    
    #ifdef ADC3_THRHLR3                             /* THRHLR3 register */
        pADC_3->THRHLR3.R   = ADC3_THRHLR3;
    #endif
    
    #ifdef ADC3_PSCR                                /* PSCR register */
        pADC_3->PSCR.R      = ADC3_PSCR;
    #endif
    
    #ifdef ADC3_PSR0                                /* PSR0 register */
        pADC_3->PSR0.R      = ADC3_PSR0;
    #endif
    
    #ifdef ADC3_CTR0                                /* CTR0 register */
        pADC_3->CTR0.R      = ADC3_CTR0;
    #endif
    
    #ifdef ADC3_CTR1                                /* CTR1 register */
        pADC_3->CTR1.R      = ADC3_CTR1;
    #endif
    
    #ifdef ADC3_NCMR0                               /* NCMR0 register */
        pADC_3->NCMR0.R     = ADC3_NCMR0;
    #endif
    
    #ifdef ADC3_JCMR0                               /* JCMR0 register */
        pADC_3->JCMR0.R     = ADC3_JCMR0;
    #endif
    
    #ifdef ADC3_PDEDR                               /* PDEDR register */
        pADC_3->PDEDR.R     = ADC3_PDEDR;
    #endif

    #ifdef ADC3_THRHLR4                               /* THRHLR4 register */
		pADC_3->THRHLR4.R	= ADC3_THRHLR4;
	#endif

	#ifdef ADC3_THRHLR5                               /* THRHLR5 register */
		pADC_3->THRHLR5.R	= ADC3_THRHLR5;
	#endif

	#ifdef ADC3_THRHLR6                               /* THRHLR6 register */
		pADC_3->THRHLR6.R	= ADC3_THRHLR6;
	#endif

	#ifdef ADC3_THRHLR7                               /* THRHLR7 register */
		pADC_3->THRHLR7.R	= ADC3_THRHLR7;
	#endif

	#ifdef ADC3_THRHLR8                               /* THRHLR8 register */
		pADC_3->THRHLR8.R	= ADC3_THRHLR8;
	#endif

	#ifdef ADC3_THRHLR9                               /* THRHLR9 register */
		pADC_3->THRHLR9.R	= ADC3_THRHLR9;
	#endif

	#ifdef ADC3_THRHLR10                               /* THRHLR10 register */
		pADC_3->THRHLR10.R	= ADC3_THRHLR10;
	#endif

	#ifdef ADC3_THRHLR11                               /* THRHLR11 register */
		pADC_3->THRHLR11.R	= ADC3_THRHLR11;
	#endif

	#ifdef ADC3_THRHLR12                               /* THRHLR12 register */
		pADC_3->THRHLR12.R	= ADC3_THRHLR12;
	#endif

	#ifdef ADC3_THRHLR13                              /* THRHLR13 register */
		pADC_3->THRHLR13.R	= ADC3_THRHLR13;
	#endif

	#ifdef ADC3_THRHLR14                              /* THRHLR14 register */
		pADC_3->THRHLR14.R	= ADC3_THRHLR14;
	#endif

	#ifdef ADC3_THRHLR15                               /* THRHLR15 register */
		pADC_3->THRHLR15.R	= ADC3_THRHLR15;
	#endif
}

/***************************************************************************//*!
@brief          ADC hw offset cancelation function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function performs hardware offset cancellation. It is used 
                to cancel the offset built up on the ADC capacitor bank and
                hence to increase the accuracy of conversion basic start-up
                setting of the ADC. Internal voltage is sampled and result
                is captured in OFFWR register.

@note           

@warning        
******************************************************************************/
void adc_off_canc(volatile struct ADC_tag *pADC)
{
//    vuint32_t   ctuen;
//
//    ctuen   = pADC->MCR.B.CTUEN;      // save current value of CTUEN bit
//    pADC->MCR.B.CTUEN     = 0x0;      // disable CTU control mode
//
//    while(pADC->MSR.B.CTUSTART){}     // wait until there is no conversion started by CTU
//
//    pADC->MCR.B.PWDN      = 0x1;      // Analog module in power down mode
//    pADC->MCR.B.OFFCANC   = 0x1;      // offset cancellation phase is enabled
//    pADC->MCR.B.PWDN      = 0x0;      // Exit power down mode to enable offset cancellation
//
//    while (pADC->MCR.B.OFFCANC);      // wait until Offset cancellation is over
//
//    pADC->MCR.B.CTUEN     = ctuen;    // restore CTUEN bit
}
