/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     adc.h
*
* @author   r63172
* 
* @version  1.0.1.0
* 
* @date     Nov-15-2010
* 
* @brief    ADC - Analog to Digital Converter for MPC5643L
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5643L ADC
* peripheral module.
*
******************************************************************************/
#ifndef _ADC_H_
#define _ADC_H_

#include "MPC5744P.h"
#include "MPC5744P_appconfig.h"

/******************************************************************************
* Global ADC variables definition
******************************************************************************/
// Pointer to ADC structure
extern volatile struct ADC_tag *pADC_0;
extern volatile struct ADC_tag *pADC_1;
extern volatile struct ADC_tag *pADC_2;
extern volatile struct ADC_tag *pADC_3;


/******************************************************************************
* ADC MACRO definitions
******************************************************************************/

/******************************************************************************
* ADC registers bit definition
******************************************************************************/

/******************************************************************************
* Exported functions
*******************************************************************************/
extern void adc0_init(void);
extern void adc1_init(void);
extern void adc2_init(void);
extern void adc3_init(void);
extern void adc_off_canc(volatile struct ADC_tag *pADC);

#endif /* _ADC_H_ */
