/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     ctu.h
*
* @author   b15651
* 
* @version  1.0.1.0
* 
* @date     Aug-29-2013
* 
* @brief    CTU - Cross Triggering Units for MPC5744P
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5744P CTU
* peripheral modules.
*
******************************************************************************/
#ifndef _CTU_H_
#define _CTU_H_

#include "MPC5744P.h"
#include "MPC5744P_appconfig.h"

/******************************************************************************
* Global CTU variables definition
******************************************************************************/
// Pointer to CTU structure
extern volatile struct CTU_tag *pCTU_0;
extern volatile struct CTU_tag *pCTU_1;

/******************************************************************************
* CTU MACRO definitions
******************************************************************************/

/******************************************************************************
* CTU registers bit definition
******************************************************************************/

/******************************************************************************
* Exported functions
*******************************************************************************/
extern void ctu0_init(void);
extern void ctu1_init(void);

/******************************************************************************
* Inline functions
*******************************************************************************/
/*inline void ctu0_disable(void)
{
    pCTU_0->CR.B.CTU_ODIS       = 0x1;      // Disable CTU output
    pCTU_0->CR.B.CTU_ADC_R		= 0x1;      // Reset CTU/ADC state machine
}

inline void ctu_enable(void)
{
   pCTU_0->CR.B.CTU_ODIS   = 0x0;          // Enable CTU output
}*/

#endif /* _CTU_H_ */
