/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     flexpwm.h
*
* @author   b15651
*
* @version  1.0.1.0
*
* @date     Aug-30-2013
*
* @brief    flexPWM - flexPWM module on MPC5744P
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5744P flexPWM
* peripheral module.
*
******************************************************************************/
#ifndef _FLEXPWM_H_
#define _FLEXPWM_H_

#include "MPC5744P.h"
#include "MPC5744P_appconfig.h"


/******************************************************************************
* Global flexPWM variables definition
******************************************************************************/
// Pointer to flexPWM structure
extern volatile struct FlexPWM_tag *pPWM0;
extern volatile struct FlexPWM_tag *pPWM1;

//typedef struct{
//    uint16_t    s16A;
//    uint16_t    s16B;
//    uint16_t    s16C;
//}FLEXPWM_VAL_COMPL;

/******************************************************************************
* flexPWM MACRO definitions
******************************************************************************/
#define SUB_0                                   0x0     // Sub module 0
#define SUB_1                                   0x1     // Sub module 1
#define SUB_2                                   0x2     // Sub module 2
#define SUB_3                                   0x3     // Sub module 3

#define RUN_SUB0                                0x0100
#define RUN_SUB1                                0x0200
#define RUN_SUB2                                0x0400
#define RUN_SUB3                                0x0800

#define LDOK_SUB0                               0x0001
#define LDOK_SUB1                               0x0002
#define LDOK_SUB2                               0x0004
#define LDOK_SUB3                               0x0008

/******************************************************************************
* Exported functions
*******************************************************************************/
extern void flexpwm0_init(void);
extern void flexpwm1_init(void);
//void flexpwm_update_val_compl(volatile mcPWM_tag *ptrPWM, FLEXPWM_VAL_COMPL *pPwmVal);

/******************************************************************************
* Inline functions
*******************************************************************************/
/*------------------------------------------------------------------------*//*!
@brief        Inline function for enabling PWM outputs

@return       void
*//*-------------------------------------------------------------------------*/
/*inline void flexpwm_enable_outputs(volatile struct FlexPWM_tag *ptrPWM)
{
    ptrPWM->MASK.R = 0x0;
}

/*------------------------------------------------------------------------*//*!
@brief      Inline function for disabling PWM outputs

@return     void

@note       PWM outputs are disabled by internal masking out of generated
            PWM signals
*//*-------------------------------------------------------------------------*
inline void flexpwm_disable_outputs(volatile struct FlexPWM_tag *ptrPWM)
{
    ptrPWM->MASK.R = 0x0FFF;
}*/

#endif /* _FLEXPWM_H_ */
