/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     pit.c
*
* @author   b15651
* 
* @version  1.0.1.0
* 
* @date     Aug-30-2013
* 
* @brief    PIT - Periodic Interupt Timer for MPC5744P
*
*******************************************************************************
*
* This file includes initial setting function of MPC5744P PIT peripheral module.
*
******************************************************************************/
#include "pit.h"

/******************************************************************************
* PIT variables definition
******************************************************************************/
// Pointer to PIT structure
volatile struct PIT_tag *pPIT;

/******************************************************************************
* PIT timer functions
*****************************************************************************/

/***************************************************************************//*!
@brief          Periodic Interupt Timer init function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes basic start-up setting of the PIT
                timers.

@note           

@warning        
******************************************************************************/
void pit_init(void)
{
    // initialization of peripheral base address
    pPIT                            = &PIT_0;

    // clock for PIT disabled
    pPIT->MCR.R 					= 0x00000002UL;;
    pPIT->TIMER[0].LDVAL.R			= 0x00000000UL;
    pPIT->TIMER[0].TCTRL.R			= 0x00000000UL;
    pPIT->TIMER[0].TFLG.R			= 0x00000001UL;

    pPIT->TIMER[1].LDVAL.R			= 0x00000000UL;
    pPIT->TIMER[1].TCTRL.R			= 0x00000000UL;
    pPIT->TIMER[1].TFLG.R			= 0x00000001UL;

    pPIT->TIMER[2].LDVAL.R			= 0x00000000UL;
    pPIT->TIMER[2].TCTRL.R			= 0x00000000UL;
    pPIT->TIMER[2].TFLG.R			= 0x00000001UL;

    pPIT->TIMER[3].LDVAL.R			= 0x00000000UL;
    pPIT->TIMER[3].TCTRL.R			= 0x00000000UL;
    pPIT->TIMER[3].TFLG.R			= 0x00000001UL;

    /*-------------------------------------------------------------------------
     * PIT channel 0 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH0_LDVAL                  /* LDVAL register */
        pPIT->TIMER[0].LDVAL.R              = PIT_CH0_LDVAL;
    #endif

    #ifdef PIT_CH0_TCTRL                  /* TCTRL register */
        pPIT->TIMER[0].TCTRL.R              = PIT_CH0_TCTRL;
    #endif

    /*-------------------------------------------------------------------------
     * PIT channel 1 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH1_LDVAL                  /* LDVAL register */
        pPIT->TIMER[1].LDVAL.R              = PIT_CH1_LDVAL;
    #endif

    #ifdef PIT_CH1_TCTRL                  /* TCTRL register */
        pPIT->TIMER[1].TCTRL.R              = PIT_CH1_TCTRL;
    #endif

    /*-------------------------------------------------------------------------
     * PIT channel 2 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH2_LDVAL                  /* LDVAL register */
        pPIT->TIMER[2].LDVAL.R              = PIT_CH2_LDVAL;
    #endif

    #ifdef PIT_CH2_TCTRL                  /* TCTRL register */
        pPIT->TIMER[2].TCTRL.R              = PIT_CH2_TCTRL;
    #endif

    /*-------------------------------------------------------------------------
     * PIT channel 3 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH3_LDVAL                  /* LDVAL register */
        pPIT->TIMER[3].LDVAL.R              = PIT_CH3_LDVAL;
    #endif

    #ifdef PIT_CH3_TCTRL                  /* TCTRL register */
        pPIT->TIMER[3].TCTRL.R              = PIT_CH3_TCTRL;
    #endif

    /*-------------------------------------------------------------------------
     * PIT Control registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_PITMCR                  /* MCR register */
        pPIT->MCR.R              = PIT_PITMCR;
    #endif
}
