/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     pit.h
*
* @author   r63172
* 
* @version  1.0.1.0
* 
* @date     Nov-15-2010
* 
* @brief    PIT - Periodic Interupt Timer for MPC5604P
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5604P PIT
* peripheral module.
*
******************************************************************************/
#ifndef _PIT_H_
#define _PIT_H_

#include "MPC5744P.h"
#include "MPC5744P_appconfig.h"

/******************************************************************************
* Global PIT variables definition
******************************************************************************/
// Pointer to PIT structure
extern volatile struct PIT_tag *pPIT;

/******************************************************************************
* PIT MACRO definitions
******************************************************************************/
// PIT channels definition
#define PIT0                    0x0
#define PIT1                    0x1
#define PIT2                    0x2
#define PIT3                    0x3

// PIT channel interrupt priority definition
#define PIT_ISR_PRIORITY_0      0x0
#define PIT_ISR_PRIORITY_1      0x1
#define PIT_ISR_PRIORITY_2      0x2
#define PIT_ISR_PRIORITY_3      0x3
#define PIT_ISR_PRIORITY_4      0x4
#define PIT_ISR_PRIORITY_5      0x5
#define PIT_ISR_PRIORITY_6      0x6
#define PIT_ISR_PRIORITY_7      0x7
#define PIT_ISR_PRIORITY_8      0x8
#define PIT_ISR_PRIORITY_9      0x9
#define PIT_ISR_PRIORITY_10     0xa
#define PIT_ISR_PRIORITY_11     0xb
#define PIT_ISR_PRIORITY_12     0xc
#define PIT_ISR_PRIORITY_13     0xd
#define PIT_ISR_PRIORITY_14     0xe
#define PIT_ISR_PRIORITY_15     0xf

/******************************************************************************
* PIT registers bit definition
******************************************************************************/

/******************************************************************************
* Exported functions
*******************************************************************************/
extern void pit_init(void);
//extern void pit_init_bckp(void);

#endif /* _PIT_H_ */
