/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     siul.c
*
* @author   b15651
* 
* @version  1.0.1.0
* 
* @date     Aug-30-2013
* 
* @brief    SIUL - System Integration Unit for MPC5744P
*
*******************************************************************************
*
* This file includes initial setting function of MPC5744P SIUL2 peripheral module.
* The port settings are valid for TQFP100, TQFP144, MAPBGA257 package.
*
******************************************************************************/
#include "siul.h"

volatile struct SIUL2_tag *pSIUL;

/******************************************************************************
* SIUL init function
*****************************************************************************/
void siul_init(void)
{
    static uint8_t  i;
    
    // initialization of peripheral base address
    pSIUL 	= &SIUL2;

    /*-------------------------------------------------------------------------
     * SIU reset
    --------------------------------------------------------------------------*/
    /* Reset DMA/Interrupt flags */
    pSIUL->DISR0.R		= 0xFFFFFFFFUL;
    pSIUL->DIRER0.R		= 0x00000000UL;
    pSIUL->DIRSR0.R		= 0x00000000UL;
    pSIUL->IREER0.R		= 0x00000000UL;
    pSIUL->IFEER0.R		= 0x00000000UL;
    pSIUL->IFER0.R		= 0x00000000UL;

    for (i=0;i<=31;i++)
    	pSIUL->IFMCR[i].R	= 0x00000000UL;

    pSIUL->IFCPR.R		= 0x00000000UL;

    for (i=0;i<=154;i++)
    	if (i == 20){
    		pSIUL->MSCR[i].R	= 0x00000001UL;

    	}else
    	{
    		if (i != 21)
    			pSIUL->MSCR[i].R	= 0x00000000UL;
    	}
    for (i=32;i<=233;i++)
    	pSIUL->IMCR[i].R	= 0x00000000UL;

    for (i=0;i<=155;i++)
    {
        pSIUL->GPDO[i].R    = 0x00000000UL;
        pSIUL->GPDI[i].R	= 0x00000000UL;
    }

    for (i=0;i<=9;i++)
    {
        pSIUL->PGPDO[i].R	= 0x00000000UL;
        pSIUL->PGPDI[i].R	= 0x00000000UL;
        pSIUL->MPGPDO[i].R	= 0x00000000UL;
    }
    
	#ifdef SIUL_DIRER0              /* DIRER0 */
	   pSIUL->DIRER0.R = SIUL_DIRER0;
	#endif

	#ifdef SIUL_DIRSR0              /* DIRSR0 */
	   pSIUL->DIRSR0.R = SIUL_DIRSR0;
	#endif

	#ifdef SIUL_IREER0              /* IREER0 */
	   pSIUL->IREER0.R = SIUL_IREER0;
	#endif

	#ifdef SIUL_IFEER0              /* IFEER0 */
	   pSIUL->IFEER0.R = SIUL_IFEER0;
	#endif

	#ifdef SIUL_IFER0              /* IFER0 */
	   pSIUL->IFER0.R = SIUL_IFER0;
	#endif

	#ifdef SIUL_IFMCR0              /* IFMCR0 */
		   pSIUL->IFMCR[0].R = SIUL_IFMCR0;
	#endif

	#ifdef SIUL_IFMCR1              /* IFMCR1 */
		   pSIUL->IFMCR[1].R = SIUL_IFMCR1;
	#endif

	#ifdef SIUL_IFMCR2              /* IFMCR2 */
		   pSIUL->IFMCR[2].R = SIUL_IFMCR2;
	#endif

	#ifdef SIUL_IFMCR3              /* IFMCR3 */
		   pSIUL->IFMCR[3].R = SIUL_IFMCR3;
	#endif

	#ifdef SIUL_IFMCR4              /* IFMCR4 */
		   pSIUL->IFMCR[4].R = SIUL_IFMCR4;
	#endif

	#ifdef SIUL_IFMCR5              /* IFMCR5 */
		   pSIUL->IFMCR[5].R = SIUL_IFMCR5;
	#endif

	#ifdef SIUL_IFMCR6              /* IFMCR6 */
		   pSIUL->IFMCR[6].R = SIUL_IFMCR6;
	#endif

	#ifdef SIUL_IFMCR7              /* IFMCR7 */
		   pSIUL->IFMCR[7].R = SIUL_IFMCR7;
	#endif

	#ifdef SIUL_IFMCR8              /* IFMCR8 */
		   pSIUL->IFMCR[8].R = SIUL_IFMCR8;
	#endif

	#ifdef SIUL_IFMCR9              /* IFMCR9 */
		   pSIUL->IFMCR[9].R = SIUL_IFMCR9;
	#endif

	#ifdef SIUL_IFMCR10              /* IFMCR10 */
		   pSIUL->IFMCR[10].R = SIUL_IFMCR10;
	#endif

	#ifdef SIUL_IFMCR11              /* IFMCR11 */
		   pSIUL->IFMCR[11].R = SIUL_IFMCR11;
	#endif

	#ifdef SIUL_IFMCR12              /* IFMCR12 */
		   pSIUL->IFMCR[12].R = SIUL_IFMCR12;
	#endif

	#ifdef SIUL_IFMCR13              /* IFMCR13 */
		   pSIUL->IFMCR[13].R = SIUL_IFMCR13;
	#endif

	#ifdef SIUL_IFMCR14              /* IFMCR14 */
		   pSIUL->IFMCR[14].R = SIUL_IFMCR14;
	#endif

	#ifdef SIUL_IFMCR15              /* IFMCR15 */
		   pSIUL->IFMCR[15].R = SIUL_IFMCR15;
	#endif

	#ifdef SIUL_IFMCR16              /* IFMCR16 */
		   pSIUL->IFMCR[16].R = SIUL_IFMCR16;
	#endif

	#ifdef SIUL_IFMCR17              /* IFMCR17 */
		   pSIUL->IFMCR[17].R = SIUL_IFMCR17;
	#endif

	#ifdef SIUL_IFMCR18              /* IFMCR18 */
		   pSIUL->IFMCR[18].R = SIUL_IFMCR18;
	#endif

	#ifdef SIUL_IFMCR19              /* IFMCR19 */
		   pSIUL->IFMCR[19].R = SIUL_IFMCR19;
	#endif

	#ifdef SIUL_IFMCR20              /* IFMCR20 */
		   pSIUL->IFMCR[20].R = SIUL_IFMCR20;
	#endif

	#ifdef SIUL_IFMCR21              /* IFMCR21 */
		   pSIUL->IFMCR[21].R = SIUL_IFMCR21;
	#endif

	#ifdef SIUL_IFMCR22              /* IFMCR22 */
		   pSIUL->IFMCR[22].R = SIUL_IFMCR22;
	#endif

	#ifdef SIUL_IFMCR23              /* IFMCR23 */
		   pSIUL->IFMCR[23].R = SIUL_IFMCR23;
	#endif

	#ifdef SIUL_IFMCR24              /* IFMCR24 */
		   pSIUL->IFMCR[24].R = SIUL_IFMCR24;
	#endif

	#ifdef SIUL_IFMCR25              /* IFMCR25 */
		   pSIUL->IFMCR[25].R = SIUL_IFMCR25;
	#endif

	#ifdef SIUL_IFMCR26              /* IFMCR26 */
		   pSIUL->IFMCR[26].R = SIUL_IFMCR26;
	#endif

	#ifdef SIUL_IFMCR27              /* IFMCR27 */
		   pSIUL->IFMCR[27].R = SIUL_IFMCR27;
	#endif

	#ifdef SIUL_IFMCR28              /* IFMCR28 */
		   pSIUL->IFMCR[28].R = SIUL_IFMCR28;
	#endif

	#ifdef SIUL_IFMCR29              /* IFMCR29 */
		   pSIUL->IFMCR[29].R = SIUL_IFMCR29;
	#endif

	#ifdef SIUL_IFMCR30              /* IFMCR30 */
		   pSIUL->IFMCR[30].R = SIUL_IFMCR30;
	#endif

	#ifdef SIUL_IFMCR31              /* IFMCR31 */
		   pSIUL->IFMCR[31].R = SIUL_IFMCR31;
	#endif

	#ifdef SIUL_IFCPR             	/* IFCPR */
		   pSIUL->IFCPR.R = SIUL_IFCPR;
	#endif

	/*-------------------------------------------------------------------------
     * SIU MSCR registers
    --------------------------------------------------------------------------*/
    #ifdef SIUL_MSCR0              /* SIU 0 */
       pSIUL->MSCR[0].R = SIUL_MSCR0;
    #endif
    #ifdef SIUL_MSCR1              /* SIU 1 */
       pSIUL->MSCR[1].R = SIUL_MSCR1;
    #endif
    #ifdef SIUL_MSCR2              /* SIU 2 */
       pSIUL->MSCR[2].R = SIUL_MSCR2;
    #endif
    #ifdef SIUL_MSCR3              /* SIU 3 */
       pSIUL->MSCR[3].R = SIUL_MSCR3;
    #endif
    #ifdef SIUL_MSCR4              /* SIU 4 */
       pSIUL->MSCR[4].R = SIUL_MSCR4;
    #endif
    #ifdef SIUL_MSCR5              /* SIU 5 */
       pSIUL->MSCR[5].R = SIUL_MSCR5;
    #endif
    #ifdef SIUL_MSCR6              /* SIU 6 */
       pSIUL->MSCR[6].R = SIUL_MSCR6;
    #endif
    #ifdef SIUL_MSCR7              /* SIU 7 */
       pSIUL->MSCR[7].R = SIUL_MSCR7;
    #endif
    #ifdef SIUL_MSCR8              /* SIU 8 */
       pSIUL->MSCR[8].R = SIUL_MSCR8;
    #endif
    #ifdef SIUL_MSCR9              /* SIU 9 */
       pSIUL->MSCR[9].R = SIUL_MSCR9;
    #endif
    #ifdef SIUL_MSCR10             /* SIU 10 */
       pSIUL->MSCR[10].R = SIUL_MSCR10;
    #endif
    #ifdef SIUL_MSCR11             /* SIU 11 */
       pSIUL->MSCR[11].R = SIUL_MSCR11;
    #endif
    #ifdef SIUL_MSCR12             /* SIU 12 */
       pSIUL->MSCR[12].R = SIUL_MSCR12;
    #endif
    #ifdef SIUL_MSCR13             /* SIU 13 */
       pSIUL->MSCR[13].R = SIUL_MSCR13;
    #endif
    #ifdef SIUL_MSCR14             /* SIU 14 */
       pSIUL->MSCR[14].R = SIUL_MSCR14;
    #endif
    #ifdef SIUL_MSCR15             /* SIU 15 */
       pSIUL->MSCR[15].R = SIUL_MSCR15;
    #endif
    #ifdef SIUL_MSCR16             /* SIU 16 */
       pSIUL->MSCR[16].R = SIUL_MSCR16;
    #endif
    #ifdef SIUL_MSCR17             /* SIU 17 */
       pSIUL->MSCR[17].R = SIUL_MSCR17;
    #endif
    #ifdef SIUL_MSCR18             /* SIU 18 */
       pSIUL->MSCR[18].R = SIUL_MSCR18;
    #endif
    #ifdef SIUL_MSCR19             /* SIU 19 */
       pSIUL->MSCR[19].R = SIUL_MSCR19;
    #endif
    #ifdef SIUL_MSCR20             /* SIU 20 */
       pSIUL->MSCR[20].R = SIUL_MSCR20;
    #endif
    #ifdef SIUL_MSCR21             /* SIU 21 */
       pSIUL->MSCR[21].R = SIUL_MSCR21;
    #endif
    #ifdef SIUL_MSCR22             /* SIU 22 */
       pSIUL->MSCR[22].R = SIUL_MSCR22;
    #endif
    #ifdef SIUL_MSCR23             /* SIU 23 */
       pSIUL->MSCR[23].R = SIUL_MSCR23;
    #endif
    #ifdef SIUL_MSCR24             /* SIU 24 */
       pSIUL->MSCR[24].R = SIUL_MSCR24;
    #endif
    #ifdef SIUL_MSCR25             /* SIU 25 */
       pSIUL->MSCR[25].R = SIUL_MSCR25;
    #endif
    #ifdef SIUL_MSCR26             /* SIU 26 */
       pSIUL->MSCR[26].R = SIUL_MSCR26;
    #endif
    #ifdef SIUL_MSCR27             /* SIU 27 */
       pSIUL->MSCR[27].R = SIUL_MSCR27;
    #endif
    #ifdef SIUL_MSCR28             /* SIU 28 */
       pSIUL->MSCR[28].R = SIUL_MSCR28;
    #endif
    #ifdef SIUL_MSCR29             /* SIU 29 */
       pSIUL->MSCR[29].R = SIUL_MSCR29;
    #endif
    #ifdef SIUL_MSCR30             /* SIU 30 */
       pSIUL->MSCR[30].R = SIUL_MSCR30;
    #endif
    #ifdef SIUL_MSCR31             /* SIU 31 */
       pSIUL->MSCR[31].R = SIUL_MSCR31;
    #endif
    #ifdef SIUL_MSCR32             /* SIU 32 */
       pSIUL->MSCR[32].R = SIUL_MSCR32;
    #endif
    #ifdef SIUL_MSCR33             /* SIU 33 */
       pSIUL->MSCR[33].R = SIUL_MSCR33;
    #endif
    #ifdef SIUL_MSCR34             /* SIU 34 */
       pSIUL->MSCR[34].R = SIUL_MSCR34;
    #endif



    #ifdef SIUL_MSCR36             /* SIU 36 */
       pSIUL->MSCR[36].R = SIUL_MSCR36;
    #endif
    #ifdef SIUL_MSCR37             /* SIU 37 */
       pSIUL->MSCR[37].R = SIUL_MSCR37;
    #endif
    #ifdef SIUL_MSCR38             /* SIU 38 */
       pSIUL->MSCR[38].R = SIUL_MSCR38;
    #endif
    #ifdef SIUL_MSCR39             /* SIU 39 */
       pSIUL->MSCR[39].R = SIUL_MSCR39;
    #endif






    #ifdef SIUL_MSCR42             /* SIU 42 */
       pSIUL->MSCR[42].R = SIUL_MSCR42;
    #endif
    #ifdef SIUL_MSCR43             /* SIU 43 */
       pSIUL->MSCR[43].R = SIUL_MSCR43;
    #endif
    #ifdef SIUL_MSCR44             /* SIU 44 */
       pSIUL->MSCR[44].R = SIUL_MSCR44;
    #endif
    #ifdef SIUL_MSCR45             /* SIU 45 */
       pSIUL->MSCR[45].R = SIUL_MSCR45;
    #endif
    #ifdef SIUL_MSCR46             /* SIU 46 */
       pSIUL->MSCR[46].R = SIUL_MSCR46;
    #endif
    #ifdef SIUL_MSCR47             /* SIU 47 */
       pSIUL->MSCR[47].R = SIUL_MSCR47;
    #endif
    #ifdef SIUL_MSCR48             /* SIU 48 */
       pSIUL->MSCR[48].R = SIUL_MSCR48;
    #endif
    #ifdef SIUL_MSCR49             /* SIU 49 */
       pSIUL->MSCR[49].R = SIUL_MSCR49;
    #endif
    #ifdef SIUL_MSCR50             /* SIU 50 */
       pSIUL->MSCR[50].R = SIUL_MSCR50;
    #endif
    #ifdef SIUL_MSCR51             /* SIU 51 */
       pSIUL->MSCR[51].R = SIUL_MSCR51;
    #endif
    #ifdef SIUL_MSCR52             /* SIU 52 */
       pSIUL->MSCR[52].R = SIUL_MSCR52;
    #endif
    #ifdef SIUL_MSCR53             /* SIU 53 */
       pSIUL->MSCR[53].R = SIUL_MSCR53;
    #endif
    #ifdef SIUL_MSCR54             /* SIU 54 */
       pSIUL->MSCR[54].R = SIUL_MSCR54;
    #endif
    #ifdef SIUL_MSCR55             /* SIU 55 */
       pSIUL->MSCR[55].R = SIUL_MSCR55;
    #endif
    #ifdef SIUL_MSCR56             /* SIU 56 */
       pSIUL->MSCR[56].R = SIUL_MSCR56;
    #endif
    #ifdef SIUL_MSCR57             /* SIU 57 */
       pSIUL->MSCR[57].R = SIUL_MSCR57;
    #endif
    #ifdef SIUL_MSCR58             /* SIU 58 */
       pSIUL->MSCR[58].R = SIUL_MSCR58;
    #endif
    #ifdef SIUL_MSCR59             /* SIU 59 */
       pSIUL->MSCR[59].R = SIUL_MSCR59;
    #endif
    #ifdef SIUL_MSCR60             /* SIU 60 */
       pSIUL->MSCR[60].R = SIUL_MSCR60;
    #endif



    #ifdef SIUL_MSCR62             /* SIU 62 */
       pSIUL->MSCR[62].R = SIUL_MSCR62;
    #endif



    #ifdef SIUL_MSCR64             /* SIU 64 */
       pSIUL->MSCR[64].R = SIUL_MSCR64;
    #endif



    #ifdef SIUL_MSCR66             /* SIU 66 */
       pSIUL->MSCR[66].R = SIUL_MSCR66;
    #endif



    #ifdef SIUL_MSCR68             /* SIU 68 */
       pSIUL->MSCR[68].R = SIUL_MSCR68;
    #endif
    #ifdef SIUL_MSCR69             /* SIU 69 */
       pSIUL->MSCR[69].R = SIUL_MSCR69;
    #endif
    #ifdef SIUL_MSCR70             /* SIU 70 */
       pSIUL->MSCR[70].R = SIUL_MSCR70;
    #endif
    #ifdef SIUL_MSCR71             /* SIU 71 */
       pSIUL->MSCR[71].R = SIUL_MSCR71;
    #endif



    #ifdef SIUL_MSCR73             /* SIU 73 */
       pSIUL->MSCR[73].R = SIUL_MSCR73;
    #endif
    #ifdef SIUL_MSCR74             /* SIU 74 */
       pSIUL->MSCR[74].R = SIUL_MSCR74;
    #endif
    #ifdef SIUL_MSCR75             /* SIU 75 */
       pSIUL->MSCR[75].R = SIUL_MSCR75;
    #endif
    #ifdef SIUL_MSCR76             /* SIU 76 */
       pSIUL->MSCR[76].R = SIUL_MSCR76;
    #endif
    #ifdef SIUL_MSCR77             /* SIU 77 */
       pSIUL->MSCR[77].R = SIUL_MSCR77;
    #endif
    #ifdef SIUL_MSCR78             /* SIU 78 */
       pSIUL->MSCR[78].R = SIUL_MSCR78;
    #endif
    #ifdef SIUL_MSCR79             /* SIU 79 */
       pSIUL->MSCR[79].R = SIUL_MSCR79;
    #endif
    #ifdef SIUL_MSCR80             /* SIU 80 */
       pSIUL->MSCR[80].R = SIUL_MSCR80;
    #endif






    #ifdef SIUL_MSCR83             /* SIU 83 */
       pSIUL->MSCR[83].R = SIUL_MSCR83;
    #endif
    #ifdef SIUL_MSCR84             /* SIU 84 */
       pSIUL->MSCR[84].R = SIUL_MSCR84;
    #endif
    #ifdef SIUL_MSCR85             /* SIU 85 */
       pSIUL->MSCR[85].R = SIUL_MSCR85;
    #endif
    #ifdef SIUL_MSCR86             /* SIU 86 */
       pSIUL->MSCR[86].R = SIUL_MSCR86;
    #endif
    #ifdef SIUL_MSCR87             /* SIU 87 */
       pSIUL->MSCR[87].R = SIUL_MSCR87;
    #endif
    #ifdef SIUL_MSCR88             /* SIU 88 */
       pSIUL->MSCR[88].R = SIUL_MSCR88;
    #endif
    #ifdef SIUL_MSCR89             /* SIU 89 */
       pSIUL->MSCR[89].R = SIUL_MSCR89;
    #endif
    #ifdef SIUL_MSCR90             /* SIU 90 */
       pSIUL->MSCR[90].R = SIUL_MSCR90;
    #endif
    #ifdef SIUL_MSCR91             /* SIU 91 */
       pSIUL->MSCR[91].R = SIUL_MSCR91;
    #endif
    #ifdef SIUL_MSCR92             /* SIU 92 */
       pSIUL->MSCR[92].R = SIUL_MSCR92;
    #endif
    #ifdef SIUL_MSCR93             /* SIU 93 */
       pSIUL->MSCR[93].R = SIUL_MSCR93;
    #endif
    #ifdef SIUL_MSCR94             /* SIU 94 */
       pSIUL->MSCR[94].R = SIUL_MSCR94;
    #endif
    #ifdef SIUL_MSCR95             /* SIU 95 */
       pSIUL->MSCR[95].R = SIUL_MSCR95;
    #endif






    #ifdef SIUL_MSCR98             /* SIU 98 */
       pSIUL->MSCR[98].R = SIUL_MSCR98;
    #endif
    #ifdef SIUL_MSCR99             /* SIU 99 */
       pSIUL->MSCR[99].R = SIUL_MSCR99;
    #endif
    #ifdef SIUL_MSCR100            /* SIU 100 */
       pSIUL->MSCR[100].R = SIUL_MSCR100;
    #endif
    #ifdef SIUL_MSCR101            /* SIU 101 */
       pSIUL->MSCR[101].R = SIUL_MSCR101;
    #endif
    #ifdef SIUL_MSCR102            /* SIU 102 */
       pSIUL->MSCR[102].R = SIUL_MSCR102;
    #endif
    #ifdef SIUL_MSCR103            /* SIU 103 */
       pSIUL->MSCR[103].R = SIUL_MSCR103;
    #endif
    #ifdef SIUL_MSCR104            /* SIU 104 */
       pSIUL->MSCR[104].R = SIUL_MSCR104;
    #endif
    #ifdef SIUL_MSCR105            /* SIU 105 */
       pSIUL->MSCR[105].R = SIUL_MSCR105;
    #endif
    #ifdef SIUL_MSCR106            /* SIU 106 */
       pSIUL->MSCR[106].R = SIUL_MSCR106;
    #endif
    #ifdef SIUL_MSCR107            /* SIU 107 */
       pSIUL->MSCR[107].R = SIUL_MSCR107;
    #endif
























    #ifdef SIUL_MSCR116            /* SIU 116 */
       pSIUL->MSCR[116].R = SIUL_MSCR116;
    #endif
    #ifdef SIUL_MSCR117            /* SIU 117 */
       pSIUL->MSCR[117].R = SIUL_MSCR117;
    #endif
    #ifdef SIUL_MSCR118            /* SIU 118 */
       pSIUL->MSCR[118].R = SIUL_MSCR118;
    #endif
    #ifdef SIUL_MSCR119            /* SIU 119 */
       pSIUL->MSCR[119].R = SIUL_MSCR119;
    #endif
    #ifdef SIUL_MSCR120            /* SIU 120 */
       pSIUL->MSCR[120].R = SIUL_MSCR120;
    #endif
    #ifdef SIUL_MSCR121            /* SIU 121 */
       pSIUL->MSCR[121].R = SIUL_MSCR121;
    #endif
    #ifdef SIUL_MSCR122            /* SIU 122 */
       pSIUL->MSCR[122].R = SIUL_MSCR122;
    #endif
    #ifdef SIUL_MSCR123            /* SIU 123 */
       pSIUL->MSCR[123].R = SIUL_MSCR123;
    #endif
    #ifdef SIUL_MSCR124            /* SIU 124 */
       pSIUL->MSCR[124].R = SIUL_MSCR124;
    #endif
    #ifdef SIUL_MSCR125            /* SIU 125 */
       pSIUL->MSCR[125].R = SIUL_MSCR125;
    #endif
    #ifdef SIUL_MSCR126            /* SIU 126 */
       pSIUL->MSCR[126].R = SIUL_MSCR126;
    #endif
    #ifdef SIUL_MSCR127            /* SIU 127 */
       pSIUL->MSCR[127].R = SIUL_MSCR127;
    #endif
    #ifdef SIUL_MSCR128            /* SIU 128 */
       pSIUL->MSCR[128].R = SIUL_MSCR128;
    #endif
    #ifdef SIUL_MSCR129            /* SIU 129 */
       pSIUL->MSCR[129].R = SIUL_MSCR129;
    #endif
    #ifdef SIUL_MSCR130            /* SIU 130 */
       pSIUL->MSCR[130].R = SIUL_MSCR130;
    #endif
    #ifdef SIUL_MSCR131            /* SIU 131 */
       pSIUL->MSCR[131].R = SIUL_MSCR131;
    #endif
	#ifdef SIUL_MSCR132            /* SIU 132 */
	   pSIUL->MSCR[132].R = SIUL_MSCR132;
	#endif
	#ifdef SIUL_MSCR133            /* SIU 133 */
	   pSIUL->MSCR[133].R = SIUL_MSCR133;
	#endif
	#ifdef SIUL_MSCR134            /* SIU 134 */
	   pSIUL->MSCR[134].R = SIUL_MSCR134;
	#endif
	#ifdef SIUL_MSCR135            /* SIU 135 */
	   pSIUL->MSCR[135].R = SIUL_MSCR135;
	#endif
	#ifdef SIUL_MSCR136            /* SIU 136 */
	   pSIUL->MSCR[136].R = SIUL_MSCR136;
	#endif
	#ifdef SIUL_MSCR137            /* SIU 137 */
	   pSIUL->MSCR[137].R = SIUL_MSCR137;
	#endif
	#ifdef SIUL_MSCR138            /* SIU 138 */
	   pSIUL->MSCR[138].R = SIUL_MSCR138;
	#endif
	#ifdef SIUL_MSCR139            /* SIU 139 */
	   pSIUL->MSCR[139].R = SIUL_MSCR139;
	#endif
	#ifdef SIUL_MSCR140            /* SIU 140 */
	   pSIUL->MSCR[140].R = SIUL_MSCR140;
	#endif
	#ifdef SIUL_MSCR141            /* SIU 141 */
	   pSIUL->MSCR[141].R = SIUL_MSCR141;
	#endif
	#ifdef SIUL_MSCR142            /* SIU 142 */
	   pSIUL->MSCR[142].R = SIUL_MSCR142;
	#endif
	#ifdef SIUL_MSCR143            /* SIU 143 */
	   pSIUL->MSCR[143].R = SIUL_MSCR143;
	#endif
	#ifdef SIUL_MSCR144            /* SIU 144 */
	   pSIUL->MSCR[144].R = SIUL_MSCR144;
	#endif
	#ifdef SIUL_MSCR145            /* SIU 145 */
	   pSIUL->MSCR[145].R = SIUL_MSCR145;
	#endif
	#ifdef SIUL_MSCR146            /* SIU 146 */
	   pSIUL->MSCR[146].R = SIUL_MSCR146;
	#endif
	#ifdef SIUL_MSCR147            /* SIU 147 */
	   pSIUL->MSCR[147].R = SIUL_MSCR147;
	#endif
	#ifdef SIUL_MSCR148            /* SIU 148 */
	   pSIUL->MSCR[148].R = SIUL_MSCR148;
	#endif
	#ifdef SIUL_MSCR149            /* SIU 149 */
	   pSIUL->MSCR[149].R = SIUL_MSCR149;
	#endif
	#ifdef SIUL_MSCR150            /* SIU 150 */
	   pSIUL->MSCR[150].R = SIUL_MSCR150;
	#endif
	#ifdef SIUL_MSCR151            /* SIU 151 */
	   pSIUL->MSCR[151].R = SIUL_MSCR151;
	#endif
	#ifdef SIUL_MSCR152            /* SIU 152 */
	   pSIUL->MSCR[152].R = SIUL_MSCR152;
	#endif
	#ifdef SIUL_MSCR153            /* SIU 153 */
	   pSIUL->MSCR[153].R = SIUL_MSCR153;
	#endif
	#ifdef SIUL_MSCR154            /* SIU 154 */
	   pSIUL->MSCR[154].R = SIUL_MSCR154;
	#endif

    /*-------------------------------------------------------------------------
     * SIU IMCR registers
    --------------------------------------------------------------------------*/
	#ifdef SIUL_IMCR32             /* SIU 32 */
	   pSIUL->IMCR[32].R = SIUL_IMCR32;
	#endif
	#ifdef SIUL_IMCR33             /* SIU 33 */
	   pSIUL->IMCR[33].R = SIUL_IMCR33;
	#endif
	#ifdef SIUL_IMCR34             /* SIU 34 */
	   pSIUL->IMCR[34].R = SIUL_IMCR34;
	#endif









	#ifdef SIUL_IMCR38             /* SIU 38 */
	   pSIUL->IMCR[38].R = SIUL_IMCR38;
	#endif
	#ifdef SIUL_IMCR39             /* SIU 39 */
	   pSIUL->IMCR[39].R = SIUL_IMCR39;
	#endif



	#ifdef SIUL_IMCR41             /* SIU 41 */
	   pSIUL->IMCR[41].R = SIUL_IMCR41;
	#endif






	#ifdef SIUL_IMCR44             /* SIU 44 */
	   pSIUL->IMCR[44].R = SIUL_IMCR44;
	#endif






	#ifdef SIUL_IMCR47             /* SIU 47 */
	   pSIUL->IMCR[47].R = SIUL_IMCR47;
	#endif
	#ifdef SIUL_IMCR48             /* SIU 48 */
	   pSIUL->IMCR[48].R = SIUL_IMCR48;
	#endif
	#ifdef SIUL_IMCR49             /* SIU 49 */
	   pSIUL->IMCR[49].R = SIUL_IMCR49;
	#endif
	#ifdef SIUL_IMCR50             /* SIU 50 */
	   pSIUL->IMCR[50].R = SIUL_IMCR50;
	#endif
	#ifdef SIUL_IMCR51             /* SIU 51 */
	   pSIUL->IMCR[51].R = SIUL_IMCR51;
	#endif





















	#ifdef SIUL_IMCR59             /* SIU 59 */
	   pSIUL->IMCR[59].R = SIUL_IMCR59;
	#endif
	#ifdef SIUL_IMCR60             /* SIU 60 */
	   pSIUL->IMCR[60].R = SIUL_IMCR60;
	#endif
	#ifdef SIUL_IMCR61             /* SIU 61 */
	   pSIUL->IMCR[61].R = SIUL_IMCR61;
	#endif
	#ifdef SIUL_IMCR62             /* SIU 62 */
	   pSIUL->IMCR[62].R = SIUL_IMCR62;
	#endif
	#ifdef SIUL_IMCR63             /* SIU 63 */
	   pSIUL->IMCR[63].R = SIUL_IMCR63;
	#endif
	#ifdef SIUL_IMCR64             /* SIU 64 */
	   pSIUL->IMCR[64].R = SIUL_IMCR64;
	#endif
	#ifdef SIUL_IMCR65             /* SIU 65 */
	   pSIUL->IMCR[65].R = SIUL_IMCR65;
	#endif
	#ifdef SIUL_IMCR66             /* SIU 66 */
	   pSIUL->IMCR[66].R = SIUL_IMCR66;
	#endif
	#ifdef SIUL_IMCR67             /* SIU 67 */
	   pSIUL->IMCR[67].R = SIUL_IMCR67;
	#endif
	#ifdef SIUL_IMCR68             /* SIU 68 */
	   pSIUL->IMCR[68].R = SIUL_IMCR68;
	#endif
	#ifdef SIUL_IMCR69             /* SIU 69 */
	   pSIUL->IMCR[69].R = SIUL_IMCR69;
	#endif
	#ifdef SIUL_IMCR70             /* SIU 70 */
	   pSIUL->IMCR[70].R = SIUL_IMCR70;
	#endif
	#ifdef SIUL_IMCR71             /* SIU 71 */
	   pSIUL->IMCR[71].R = SIUL_IMCR71;
	#endif
	#ifdef SIUL_IMCR72             /* SIU 72 */
	   pSIUL->IMCR[72].R = SIUL_IMCR72;
	#endif
	#ifdef SIUL_IMCR73             /* SIU 73 */
	   pSIUL->IMCR[73].R = SIUL_IMCR73;
	#endif
	#ifdef SIUL_IMCR74             /* SIU 74 */
	   pSIUL->IMCR[74].R = SIUL_IMCR74;
	#endif
	#ifdef SIUL_IMCR75             /* SIU 75 */
	   pSIUL->IMCR[75].R = SIUL_IMCR75;
	#endif
	#ifdef SIUL_IMCR76             /* SIU 76 */
	   pSIUL->IMCR[76].R = SIUL_IMCR76;
	#endif


















	#ifdef SIUL_IMCR83             /* SIU 83 */
	   pSIUL->IMCR[83].R = SIUL_IMCR83;
	#endif
	#ifdef SIUL_IMCR84             /* SIU 84 */
	   pSIUL->IMCR[84].R = SIUL_IMCR84;
	#endif
	#ifdef SIUL_IMCR85             /* SIU 85 */
	   pSIUL->IMCR[85].R = SIUL_IMCR85;
	#endif
	#ifdef SIUL_IMCR86             /* SIU 86 */
	   pSIUL->IMCR[86].R = SIUL_IMCR86;
	#endif
	#ifdef SIUL_IMCR87             /* SIU 87 */
	   pSIUL->IMCR[87].R = SIUL_IMCR87;
	#endif
	#ifdef SIUL_IMCR88             /* SIU 88 */
	   pSIUL->IMCR[88].R = SIUL_IMCR88;
	#endif
	#ifdef SIUL_IMCR89             /* SIU 89 */
	   pSIUL->IMCR[89].R = SIUL_IMCR89;
	#endif



	#ifdef SIUL_IMCR91             /* SIU 91 */
	   pSIUL->IMCR[91].R = SIUL_IMCR91;
	#endif
	#ifdef SIUL_IMCR92             /* SIU 92 */
	   pSIUL->IMCR[92].R = SIUL_IMCR92;
	#endif
	#ifdef SIUL_IMCR93             /* SIU 93 */
	   pSIUL->IMCR[93].R = SIUL_IMCR93;
	#endif
	#ifdef SIUL_IMCR94             /* SIU 94 */
	   pSIUL->IMCR[94].R = SIUL_IMCR94;
	#endif
	#ifdef SIUL_IMCR95             /* SIU 95 */
	   pSIUL->IMCR[95].R = SIUL_IMCR95;
	#endif
	#ifdef SIUL_IMCR96             /* SIU 96 */
	   pSIUL->IMCR[96].R = SIUL_IMCR96;
	#endif
	#ifdef SIUL_IMCR97             /* SIU 97 */
	   pSIUL->IMCR[97].R = SIUL_IMCR97;
	#endif
	#ifdef SIUL_IMCR98             /* SIU 98 */
	   pSIUL->IMCR[98].R = SIUL_IMCR98;
	#endif
	#ifdef SIUL_IMCR99             /* SIU 99 */
	   pSIUL->IMCR[99].R = SIUL_IMCR99;
	#endif
	#ifdef SIUL_IMCR100            /* SIU 100 */
	   pSIUL->IMCR[100].R = SIUL_IMCR100;
	#endif
	#ifdef SIUL_IMCR101            /* SIU 101 */
	   pSIUL->IMCR[101].R = SIUL_IMCR101;
	#endif
	#ifdef SIUL_IMCR102            /* SIU 102 */
	   pSIUL->IMCR[102].R = SIUL_IMCR102;
	#endif
	#ifdef SIUL_IMCR103            /* SIU 103 */
	   pSIUL->IMCR[103].R = SIUL_IMCR103;
	#endif



	#ifdef SIUL_IMCR105            /* SIU 105 */
	   pSIUL->IMCR[105].R = SIUL_IMCR105;
	#endif
	#ifdef SIUL_IMCR106            /* SIU 106 */
	   pSIUL->IMCR[106].R = SIUL_IMCR106;
	#endif






	#ifdef SIUL_IMCR109            /* SIU 109 */
	   pSIUL->IMCR[109].R = SIUL_IMCR109;
	#endif
	#ifdef SIUL_IMCR110            /* SIU 110 */
	   pSIUL->IMCR[110].R = SIUL_IMCR110;
	#endif



	#ifdef SIUL_IMCR112            /* SIU 112 */
	   pSIUL->IMCR[112].R = SIUL_IMCR112;
	#endif
	#ifdef SIUL_IMCR113            /* SIU 103 */
	   pSIUL->IMCR[113].R = SIUL_IMCR113;
	#endif


































































	#ifdef SIUL_IMCR136            /* SIU 136 */
	   pSIUL->IMCR[136].R = SIUL_IMCR136;
	#endif
	#ifdef SIUL_IMCR137            /* SIU 137 */
	   pSIUL->IMCR[137].R = SIUL_IMCR137;
	#endif

















































































	#ifdef SIUL_IMCR165             /* SIU 65 */
	   pSIUL->IMCR[165].R = SIUL_IMCR165;
	#endif
	#ifdef SIUL_IMCR166             /* SIU 66 */
	   pSIUL->IMCR[166].R = SIUL_IMCR166;
	#endif





	#ifdef SIUL_IMCR169             /* SIU 69 */
	   pSIUL->IMCR[169].R = SIUL_IMCR169;
	#endif



	#ifdef SIUL_IMCR171             /* SIU 71 */
	   pSIUL->IMCR[171].R = SIUL_IMCR171;
	#endif
	#ifdef SIUL_IMCR172             /* SIU 72 */
	   pSIUL->IMCR[172].R = SIUL_IMCR172;
	#endif
	#ifdef SIUL_IMCR173             /* SIU 73 */
	   pSIUL->IMCR[173].R = SIUL_IMCR173;
	#endif
	#ifdef SIUL_IMCR174             /* SIU 74 */
	   pSIUL->IMCR[174].R = SIUL_IMCR174;
	#endif
	#ifdef SIUL_IMCR175             /* SIU 75 */
	   pSIUL->IMCR[175].R = SIUL_IMCR175;
	#endif
	#ifdef SIUL_IMCR176             /* SIU 76 */
	   pSIUL->IMCR[176].R = SIUL_IMCR176;
	#endif
	#ifdef SIUL_IMCR177             /* SIU 77 */
	   pSIUL->IMCR[177].R = SIUL_IMCR177;
	#endif
	#ifdef SIUL_IMCR178             /* SIU 78 */
	   pSIUL->IMCR[178].R = SIUL_IMCR178;
	#endif
	#ifdef SIUL_IMCR179             /* SIU 79 */
	   pSIUL->IMCR[179].R = SIUL_IMCR179;
	#endif
	#ifdef SIUL_IMCR180             /* SIU 80 */
	   pSIUL->IMCR[180].R = SIUL_IMCR180;
	#endif
	#ifdef SIUL_IMCR181             /* SIU 81 */
	   pSIUL->IMCR[181].R = SIUL_IMCR181;
	#endif
	#ifdef SIUL_IMCR182             /* SIU 82 */
	   pSIUL->IMCR[182].R = SIUL_IMCR182;
	#endif
	#ifdef SIUL_IMCR183             /* SIU 83 */
	   pSIUL->IMCR[183].R = SIUL_IMCR183;
	#endif
	#ifdef SIUL_IMCR184             /* SIU 84 */
	   pSIUL->IMCR[184].R = SIUL_IMCR184;
	#endif
	#ifdef SIUL_IMCR185             /* SIU 85 */
	   pSIUL->IMCR[185].R = SIUL_IMCR185;
	#endif
	#ifdef SIUL_IMCR186             /* SIU 86 */
	   pSIUL->IMCR[186].R = SIUL_IMCR186;
	#endif
	#ifdef SIUL_IMCR187             /* SIU 87 */
	   pSIUL->IMCR[187].R = SIUL_IMCR187;
	#endif
	#ifdef SIUL_IMCR188             /* SIU 88 */
	   pSIUL->IMCR[188].R = SIUL_IMCR188;
	#endif
	#ifdef SIUL_IMCR189             /* SIU 89 */
	   pSIUL->IMCR[189].R = SIUL_IMCR189;
	#endif
	#ifdef SIUL_IMCR190             /* SIU 90 */
	   pSIUL->IMCR[190].R = SIUL_IMCR190;
	#endif
	#ifdef SIUL_IMCR191             /* SIU 91 */
	   pSIUL->IMCR[191].R = SIUL_IMCR191;
	#endif
	#ifdef SIUL_IMCR192             /* SIU 92 */
	   pSIUL->IMCR[192].R = SIUL_IMCR192;
	#endif
	#ifdef SIUL_IMCR193             /* SIU 93 */
	   pSIUL->IMCR[193].R = SIUL_IMCR193;
	#endif
	#ifdef SIUL_IMCR194             /* SIU 94 */
	   pSIUL->IMCR[194].R = SIUL_IMCR194;
	#endif
	#ifdef SIUL_IMCR195             /* SIU 95 */
	   pSIUL->IMCR[195].R = SIUL_IMCR195;
	#endif
	#ifdef SIUL_IMCR196             /* SIU 96 */
	   pSIUL->IMCR[196].R = SIUL_IMCR196;
	#endif
	#ifdef SIUL_IMCR197             /* SIU 97 */
	   pSIUL->IMCR[197].R = SIUL_IMCR197;
	#endif
	#ifdef SIUL_IMCR198             /* SIU 98 */
	   pSIUL->IMCR[198].R = SIUL_IMCR198;
	#endif
	#ifdef SIUL_IMCR199             /* SIU 99 */
	   pSIUL->IMCR[199].R = SIUL_IMCR199;
	#endif
	#ifdef SIUL_IMCR200            /* SIU 100 */
	   pSIUL->IMCR[200].R = SIUL_IMCR200;
	#endif
	#ifdef SIUL_IMCR201            /* SIU 101 */
	   pSIUL->IMCR[201].R = SIUL_IMCR201;
	#endif
	#ifdef SIUL_IMCR202            /* SIU 102 */
	   pSIUL->IMCR[202].R = SIUL_IMCR202;
	#endif
	#ifdef SIUL_IMCR203            /* SIU 103 */
	   pSIUL->IMCR[203].R = SIUL_IMCR203;
	#endif
	#ifdef SIUL_IMCR204            /* SIU 104 */
	   pSIUL->IMCR[204].R = SIUL_IMCR204;
	#endif
	#ifdef SIUL_IMCR205            /* SIU 105 */
	   pSIUL->IMCR[205].R = SIUL_IMCR205;
	#endif
	#ifdef SIUL_IMCR206            /* SIU 106 */
	   pSIUL->IMCR[206].R = SIUL_IMCR206;
	#endif


















	#ifdef SIUL_IMCR213            /* SIU 103 */
	   pSIUL->IMCR[213].R = SIUL_IMCR213;
	#endif
	#ifdef SIUL_IMCR214            /* SIU 114 */
	   pSIUL->IMCR[214].R = SIUL_IMCR214;
	#endif



























	#ifdef SIUL_IMCR224            /* SIU 124 */
	   pSIUL->IMCR[224].R = SIUL_IMCR224;
	#endif
	#ifdef SIUL_IMCR225            /* SIU 125 */
	   pSIUL->IMCR[225].R = SIUL_IMCR225;
	#endif
	#ifdef SIUL_IMCR226            /* SIU 126 */
	   pSIUL->IMCR[226].R = SIUL_IMCR226;
	#endif
	#ifdef SIUL_IMCR227            /* SIU 127 */
	   pSIUL->IMCR[227].R = SIUL_IMCR227;
	#endif
	#ifdef SIUL_IMCR228            /* SIU 128 */
	   pSIUL->IMCR[228].R = SIUL_IMCR228;
	#endif
	#ifdef SIUL_IMCR229            /* SIU 129 */
	   pSIUL->IMCR[229].R = SIUL_IMCR229;
	#endif
	#ifdef SIUL_IMCR230            /* SIU 130 */
	   pSIUL->IMCR[230].R = SIUL_IMCR230;
	#endif
	#ifdef SIUL_IMCR231            /* SIU 131 */
	   pSIUL->IMCR[231].R = SIUL_IMCR231;
	#endif
	#ifdef SIUL_IMCR232            /* SIU 132 */
	   pSIUL->IMCR[232].R = SIUL_IMCR232;
	#endif
	#ifdef SIUL_IMCR233            /* SIU 133 */
	   pSIUL->IMCR[233].R = SIUL_IMCR233;
	#endif
}
