 /******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     spi.c
*
* @author   b15651
*
* @version  1.0.1.0
*
* @date     Aug-30-2013
*
* @brief    SPI - SPI module on MPC5744P
*
*******************************************************************************
*
* This file includes initial setting functions of MPC5744P SPI module.
*
******************************************************************************/
#include "SPI.h"

/******************************************************************************
* SPI functions
*****************************************************************************/
volatile struct SPI_tag *pSPI0;
volatile struct SPI_tag *pSPI1;
volatile struct SPI_tag *pSPI2;
volatile struct SPI_tag *pSPI3;

/***************************************************************************//*!
@brief          SPi init function

@param[in,out]  void

@return         void

@details        This function initializes basic start-up setting of the SPI
                modules 0 to 3.

@note

@warning
******************************************************************************/
void SPI_init(void)
{
    pSPI0  = &SPI_0;
    pSPI1  = &SPI_1;
    pSPI2  = &SPI_2;
    pSPI3  = &SPI_3;

    /*-------------------------------------------------------------------------
     * SPI0 Reset
    --------------------------------------------------------------------------*/
    pSPI0->MCR.R            = 0x00004001UL;
    pSPI0->TCR.R			= 0x00000000UL;

    pSPI0->MODE.CTAR[0].R   = 0x78000000UL;
    pSPI0->MODE.CTAR[1].R   = 0x78000000UL;
    pSPI0->MODE.CTAR[2].R   = 0x78000000UL;
    pSPI0->MODE.CTAR[3].R   = 0x78000000UL;
    pSPI0->RSER.R           = 0x00000000UL;;
    /*-------------------------------------------------------------------------
     * SPI1 Reset
    --------------------------------------------------------------------------*/
    pSPI1->MCR.R            = 0x00004001UL;
    pSPI1->TCR.R			= 0x00000000UL;

    pSPI1->MODE.CTAR[0].R   = 0x78000000UL;
    pSPI1->MODE.CTAR[1].R   = 0x78000000UL;
    pSPI1->MODE.CTAR[2].R   = 0x78000000UL;
    pSPI1->MODE.CTAR[3].R   = 0x78000000UL;
    pSPI1->RSER.R           = 0x00000000UL;;
    /*-------------------------------------------------------------------------
     * SPI2 Reset
    --------------------------------------------------------------------------*/
    pSPI2->MCR.R            = 0x00004001UL;
    pSPI2->TCR.R			= 0x00000000UL;

    pSPI2->MODE.CTAR[0].R   = 0x78000000UL;
    pSPI2->MODE.CTAR[1].R   = 0x78000000UL;
    pSPI2->MODE.CTAR[2].R   = 0x78000000UL;
    pSPI2->MODE.CTAR[3].R   = 0x78000000UL;
    pSPI2->RSER.R           = 0x00000000UL;;
    /*-------------------------------------------------------------------------
     * SPI3 Reset
    --------------------------------------------------------------------------*/
    pSPI3->MCR.R            = 0x00004001UL;
    pSPI3->TCR.R			= 0x00000000UL;

    pSPI3->MODE.CTAR[0].R   = 0x78000000UL;
    pSPI3->MODE.CTAR[1].R   = 0x78000000UL;
    pSPI3->MODE.CTAR[2].R   = 0x78000000UL;
    pSPI3->MODE.CTAR[3].R   = 0x78000000UL;
    pSPI3->RSER.R           = 0x00000000UL;;
    /*-------------------------------------------------------------------------
     * SPI0 Control registers
    --------------------------------------------------------------------------*/
    #ifdef SPI0_MCR                  /* MCR register */
        pSPI0->MCR.R           = SPI0_MCR;
    #endif

    #ifdef SPI0_TCR                   /* TCR register */
        pSPI0->TCR.R           = SPI0_TCR;
    #endif

    #ifdef SPI0_CTAR0                   /* CTAR[0] register */
        pSPI0->MODE.CTAR[0].R       = SPI0_CTAR0;
    #endif

    #ifdef SPI0_CTAR1                   /* CTAR[1] register */
        pSPI0->MODE.CTAR[1].R       = SPI0_CTAR1;
    #endif

    #ifdef SPI0_CTAR2                   /* CTAR[2] register */
        pSPI0->MODE.CTAR[2].R       = SPI0_CTAR2;
    #endif

    #ifdef SPI0_CTAR3                   /* CTAR[3] register */
        pSPI0->MODE.CTAR[3].R       = SPI0_CTAR3;
    #endif

    #ifdef SPI0_RSER                   /* RSER register */
        pSPI0->RSER.R          = SPI0_RSER;
    #endif

	/*-------------------------------------------------------------------------
	 * SPI1 Control registers
	--------------------------------------------------------------------------*/
	#ifdef SPI1_MCR                  /* MCR register */
		pSPI1->MCR.R           = SPI1_MCR;
	#endif

	#ifdef SPI1_TCR                   /* TCR register */
		pSPI1->TCR.R           = SPI1_TCR;
	#endif

	#ifdef SPI1_CTAR0                   /* CTAR[0] register */
		pSPI1->MODE.CTAR[0].R       = SPI1_CTAR0;
	#endif

	#ifdef SPI1_CTAR1                   /* CTAR[1] register */
		pSPI1->MODE.CTAR[1].R       = SPI1_CTAR1;
	#endif

	#ifdef SPI1_CTAR2                   /* CTAR[2] register */
		pSPI1->MODE.CTAR[2].R       = SPI1_CTAR2;
	#endif

	#ifdef SPI1_CTAR3                   /* CTAR[3] register */
		pSPI1->MODE.CTAR[3].R       = SPI1_CTAR3;
	#endif

	#ifdef SPI1_RSER                   /* RSER register */
		pSPI1->RSER.R          = SPI1_RSER;
	#endif

	/*-------------------------------------------------------------------------
	 * SPI2 Control registers
	--------------------------------------------------------------------------*/
	#ifdef SPI2_MCR                  /* MCR register */
		pSPI2->MCR.R           = SPI2_MCR;
	#endif

	#ifdef SPI2_TCR                   /* TCR register */
		pSPI2->TCR.R           = SPI2_TCR;
	#endif

	#ifdef SPI2_CTAR0                   /* CTAR[0] register */
		pSPI2->MODE.CTAR[0].R       = SPI2_CTAR0;
	#endif

	#ifdef SPI2_CTAR1                   /* CTAR[1] register */
		pSPI2->MODE.CTAR[1].R       = SPI2_CTAR1;
	#endif

	#ifdef SPI2_CTAR2                   /* CTAR[2] register */
		pSPI2->MODE.CTAR[2].R       = SPI2_CTAR2;
	#endif

	#ifdef SPI2_CTAR3                   /* CTAR[3] register */
		pSPI2->MODE.CTAR[3].R       = SPI2_CTAR3;
	#endif

	#ifdef SPI2_RSER                   /* RSER register */
		pSPI2->RSER.R          = SPI2_RSER;
	#endif

	/*-------------------------------------------------------------------------
	 * SPI3 Control registers
	--------------------------------------------------------------------------*/
	#ifdef SPI3_MCR                  /* MCR register */
		pSPI3->MCR.R           = SPI3_MCR;
	#endif

	#ifdef SPI3_TCR                   /* TCR register */
		pSPI3->TCR.R           = SPI3_TCR;
	#endif

	#ifdef SPI3_CTAR0                   /* CTAR[0] register */
		pSPI3->MODE.CTAR[0].R       = SPI3_CTAR0;
	#endif

	#ifdef SPI3_CTAR1                   /* CTAR[1] register */
		pSPI3->MODE.CTAR[1].R       = SPI3_CTAR1;
	#endif

	#ifdef SPI3_CTAR2                   /* CTAR[2] register */
		pSPI3->MODE.CTAR[2].R       = SPI3_CTAR2;
	#endif

	#ifdef SPI3_CTAR3                   /* CTAR[3] register */
		pSPI3->MODE.CTAR[3].R       = SPI3_CTAR3;
	#endif

	#ifdef SPI3_RSER                   /* RSER register */
		pSPI3->RSER.R          = SPI3_RSER;
	#endif

}

