/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     SPI.h
*
* @author   b15651
* 
* @version  1.0.1.0
* 
* @date     Nov-15-2010
* 
* @brief    SPI - SPI module on MPC5604P
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5604P SPI
* peripheral module.
*
******************************************************************************/
//#include "typedefs.h"
//#include "MC33937_routines.h"

#ifndef _SPI_H_
#define _SPI_H_

#include "MPC5744P.h"
#include "MPC5744P_appconfig.h"

/******************************************************************************
* Global flexPWM variables definition
******************************************************************************/
// Pointer to flexPWM structure
extern volatile struct SPI_tag *pSPI0;
extern volatile struct SPI_tag *pSPI1;
extern volatile struct SPI_tag *pSPI2;

/******************************************************************************
* flexPWM MACRO definitions
******************************************************************************/
#define ASSERT_CS0      0x00010000
#define ASSERT_CS1      0x00020000
#define ASSERT_CS2      0x00040000
#define ASSERT_CS3      0x00080000
#define ASSERT_CS4      0x00100000
#define ASSERT_CS5      0x00200000
#define ASSERT_CS6      0x00400000
#define ASSERT_CS7      0x00800000

#define ASSERT_CTAR0    0x00000000
#define ASSERT_CTAR1    0x10000000
#define ASSERT_CTAR2    0x20000000
#define ASSERT_CTAR3    0x30000000
#define ASSERT_CTAR4    0x40000000
#define ASSERT_CTAR5    0x50000000
#define ASSERT_CTAR6    0x60000000
#define ASSERT_CTAR7    0x70000000

/******************************************************************************
* Exported functions
*******************************************************************************/
extern  void SPI_init(void);
//extern  tBool   SPI0_transmit_SPI_8(uint8_t u8DataOut, MC33937_SET_T *SetPtr, uint8_t *ptDataIn);
//extern  tBool   SPI1_transmit_SPI_8(uint8_t u8DataOut, MC33937_SET_T *SetPtr, uint8_t *ptDataIn);
//extern  tBool   SPI2_transmit_SPI_8(uint8_t u8DataOut, MC33937_SET_T *SetPtr, uint8_t *ptDataIn);
//
//extern  tBool   SPI0_transmit_SPI_16(uint16_t u16DataOut, uint16_t *ptDataIn);
//extern  tBool   SPI1_transmit_SPI_16(uint16_t u16DataOut, uint16_t *ptDataIn);
//extern  tBool   SPI2_transmit_SPI_16(uint16_t u16DataOut, uint16_t *ptDataIn);

#endif /* _SPI_H_ */
