/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2006 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file   uart_init.c
*
* @brief  FreeMASTER driver private declarations, used internally by the driver
*
* @version 1.0.1.0
* 
* @date Nov-15-2010
* 
*******************************************************************************/
#include "uart_init.h"

volatile struct LINFlexD_tag *linflex0;

void uart_init(void)
{
    linflex0 = &LINFlexD_0;
   
    // configure linflex1
    linflex0->LINCR1.B.SLEEP = 0x0;     // disable sleep mode
    linflex0->LINCR1.B.INIT  = 0x1;     // init mode
    linflex0->UARTCR.B.UART  = 0x1;     // UART mode
    
    linflex0->UARTCR.B.TDFL_TFC	= 0x0;      // bufer size = 1
    linflex0->UARTCR.B.RDFL_RFC	= 0x0;      // bufer size = 1
    linflex0->UARTCR.B.RxEn		= 0x1;      // reciever enable
    linflex0->UARTCR.B.TxEn		= 0x1;      // transmiter enable
    linflex0->UARTCR.B.PC0		= 0x1;      // parity is even
    linflex0->UARTCR.B.PCE		= 0x0;      // parity control disable
    linflex0->UARTCR.B.WL0		= 0x1;      // word length 8-bit data + parity bit

//    linflex0->LINIBRR.B.DIV_M	= 27;	// Baud rate = 115200, in case fipg_clock_lin = 50 MHz
//    linflex0->LINFBRR.B.DIV_F	= 2;	// Baud rate = 115200, in case fipg_clock_lin = 50 MHz
//    linflex0->LINIBRR.B.DIV_M	= 86;	// Baud rate = 115200, in case fipg_clock_lin = 160 MHz
//    linflex0->LINFBRR.B.DIV_F	= 13;	// Baud rate = 115200, in case fipg_clock_lin = 160 MHz
////    linflex0->LINIBRR.B.DIV_M	= 54;	// Baud rate = 115200, in case fipg_clock_lin = 100 MHz
////    linflex0->LINFBRR.B.DIV_F	= 4;	// Baud rate = 115200, in case fipg_clock_lin = 100 MHz

     linflex0->LINIBRR.B.IBR	= 54;	// Baud rate = 115200, in case fipg_clock_lin = 100 MHz
     linflex0->LINFBRR.B.FBR	= 4;	// Baud rate = 115200, in case fipg_clock_lin = 100 MHz



    // configure interupts - enable
//    linflex0->LINIER.B.DRIE  = 0x1;       // data reception complete interrupt
//    linflex0->LINIER.B.DTIE  = 0x1;       // data transmition complete interrupt  
//    linflex0->LINIER.B.DBFIE = 0x1;       // 
//    linflex0->LINIER.B.DBEIE = 0x1;       // 

    // or disable
    linflex0->LINIER.B.DRIE			= 0x0;     // data reception complete interrupt
    linflex0->LINIER.B.DTIE			= 0x0;     // data transmition complete interrupt
    linflex0->LINIER.B.DBFIE		= 0x0;     //
    linflex0->LINIER.B.DBEIETOIE	= 0x0;     //
    
    linflex0->LINCR1.B.INIT			= 0x0;      // normal mode
}

// for testing purpose
void uart_rx_isr()
{ 
	FMSTR_SCI_RDCLRSR(); 
	FMSTR_SCI_PUTCHAR(FMSTR_SCI_GETCHAR()); // output - input
}

void uart_tx_isr()
{ 
	FMSTR_SCI_RDCLRSR();  
	linflex0->UARTSR.B.DTFTFF		= 0x1;
}	    

// *****************************************************************************
