/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     sys.h
*
* @author   B15651
* 
* @version  1.0.1.0
* 
* @date     Aug-28-2013
* 
* @brief    Init header file for MPC5744P MCU reset and boot modules.
*
*******************************************************************************
*
* Detailed Description of the file.
*
******************************************************************************/

/*****************************************************************************
* External objects
******************************************************************************/
#include "MPC5744P_qs.h"

/*******************************************************************************
* Macro definitions
*******************************************************************************/
/* Define Board Variables */
#define XOSC40MHZ
#define PLL0_160MHZ
#define PLL1_200MHZ

//-----------------------------------------------------------------------------
// System Clock Source selection 
//-----------------------------------------------------------------------------
// SYSCLK bits !!! in ME_DRUN_MC register !!!
#define SYSCLK_SRC_INT              0x0      // 16MHz internal RC oscillator
#define SYSCLK_SRC_OSC              0x2      // 4MHz crystal oscillator
#define SYSCLK_SRC_SYSPLL           0x4      // system PLL
#define SYSCLK_SRC_SECPLL           0x5      // secondary PLL
#define SYSCLK_DISABLED             0xf      // system clock is disabled

// Divider Enable bit
#define DIVIDER_DISABLE       		0x0      /* Disable auxiliary clock x divider */
#define DIVIDER_ENABLE        		0x1      /* Enable auxiliary clock x divider */

//-----------------------------------------------------------------------------
// Auxiliary CLOCK 0 is used for Motor Control Peripherals (PWM,CTU,ADC)
// Auxiliary CLOCK 0 Select Control Register (AC0SC)
//-----------------------------------------------------------------------------
// SELCTL bits
#define AC0SC_SELCTL_IRC            0x0      // 16MHz internal RC oscillator
#define AC0SC_SELCTL_XOSC           0x1      // 4MHz crystal oscillator
#define AC0SC_SELCTL_PLL0			0x2      // PLL0
#define AC0SC_SELCTL_PLL1			0x3      // PLL1

//-----------------------------------------------------------------------------
// Auxiliary CLOCK 1 Select Control Register (AC1SC)
//-----------------------------------------------------------------------------
// SELCTL bits
#define AC1SC_CLKSRC_SECPLL         0x0      // secondary PLL
// DE0 bit
#define AC1DC_DIVIDER_DISABLE       0x0      // Disable auxiliary clock 1 div 0
#define AC1DC_DIVIDER_ENABLE        0x1      // Enable auxiliary clock 1 div 0

//-----------------------------------------------------------------------------
// Auxiliary CLOCK 2 is used for FlexRay
// Auxiliary CLOCK 2 Select Control Register (AC2SC)
//-----------------------------------------------------------------------------
// SELCTL bits
#define AC2SC_CLKSRC_INT            0x0      // 16MHz internal RC oscillator
#define AC2SC_CLKSRC_OSC            0x2      // 4MHz crystal oscillator
#define AC2SC_CLKSRC_SYSPLL         0x4      // system PLL
#define AC2SC_CLKSRC_SECPLL         0x5      // secondary PLL
// DE0 bit
#define AC2DC_DIVIDER_DISABLE       0x0      // Disable auxiliary clock 2 div 0
#define AC2DC_DIVIDER_ENABLE        0x1      // Enable auxiliary clock 2 div 0
// DE1 bit
#define AC2DC1_DIVIDER_DISABLE      0x0      // Disable auxiliary clock 2 div 1
#define AC2DC1_DIVIDER_ENABLE       0x1      // Enable auxiliary clock 2 div 1

//-----------------------------------------------------------------------------
// Auxiliary Clock 6 Registers - CLKOUT pin clock (AC6_SC)
//-----------------------------------------------------------------------------
// AC6_SC register - SELCTL bits - clock source selection
#define AC6_SC_CLKOUT_SRC_IRC   	0x0     // 16MHz internal RC oscillator
#define AC6_SC_CLKOUT_SRC_OSC       0x1     // 8-40MHz external crystal oscillator
#define AC6_SC_CLKOUT_SRC_PLL0		0x2     // PLL0
#define AC6_SC_CLKOUT_SRC_temp3		0x3     // reserved
#define AC6_SC_CLKOUT_SRC_PLL1		0x4     // PLL1
#define AC6_SC_CLKOUT_SRC_temp5		0x5     // reserved
#define AC6_SC_CLKOUT_SRC_temp6		0x6     // reserved
#define AC6_SC_CLKOUT_SRC_temp7		0x7     // reserved

/*-----------------------------------------------------------------------------
* Auxiliary Clock 6 Divider 0 Configuration Register (AC6_DC0)
* -----------------------------------------------------------------------------*/
/* DE divider enable register */
#define CLKOUT_DISABLE              0x0     // output clock is disabled
#define CLKOUT_ENABLE               0x1     // output clock is enabled
// DIV bits - select division
#define AC6_DC0_CLKOUT_NODIV         0x0     // output clock without division
#define AC6_DC0_CLKOUT_DIVBY_2       0x1     // output clock divided by 2
#define AC6_DC0_CLKOUT_DIVBY_3       0x2     // output clock divided by 3
#define AC6_DC0_CLKOUT_DIVBY_4       0x3     // output clock divided by 4
#define AC6_DC0_CLKOUT_DIVBY_5       0x4     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_6       0x5     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_7       0x6     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_8       0x7     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_9       0x8     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_10      0x9     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_11      0xA     // output clock divided by 5
#define AC6_DC0_CLKOUT_DIVBY_12      0xB     // output clock divided by 5

//-----------------------------------------------------------------------------
// Mode Enable register (ME_ME)
//-----------------------------------------------------------------------------
#define ME_MODE_STOP0_DISABLED      0x0     // STOP0 mode is disabled
#define ME_MODE_STOP0_ENABLED       0x1     // STOP0 mode is enabled
#define ME_MODE_HALT0_DISABLED      0x0     // HALT0 mode is disabled
#define ME_MODE_HALT0_ENABLED       0x1     // HALT0 mode is enabled
#define ME_MODE_RUN3_DISABLED       0x0     // RUN3 mode is disabled
#define ME_MODE_RUN3_ENABLED        0x1     // RUN3 mode is enabled
#define ME_MODE_RUN2_DISABLED       0x0     // RUN2 mode is disabled
#define ME_MODE_RUN2_ENABLED        0x1     // RUN2 mode is enabled
#define ME_MODE_RUN1_DISABLED       0x0     // RUN1 mode is disabled
#define ME_MODE_RUN1_ENABLED        0x1     // RUN1 mode is enabled
#define ME_MODE_RUN0_DISABLED       0x0     // RUN0 mode is disabled
#define ME_MODE_RUN0_ENABLED        0x1     // RUN0 mode is enabled
#define ME_MODE_DRUN_DISABLED       0x0     // DRUN mode is disabled
#define ME_MODE_DRUN_ENABLED        0x1     // DRUN mode is enabled
#define ME_MODE_SAFE_DISABLED       0x0     // SAFE mode is disabled
#define ME_MODE_SAFE_ENABLED        0x1     // SAFE mode is enabled
#define ME_MODE_TEST_DISABLED       0x0     // TEST mode is disabled
#define ME_MODE_TEST_ENABLED        0x1     // TEST mode is enabled
#define ME_MODE_RESET_DISABLED      0x0     // RESET mode is disabled
#define ME_MODE_RESET_ENABLED       0x1     // RESET mode is enabled

//-----------------------------------------------------------------------------
// DRUN mode configuration register (ME_DRUN_MC)
//-----------------------------------------------------------------------------
#define DRUN_VOLT_REG_OFF           0x0     // main voltage regulator is off
#define DRUN_VOLT_REG_ON            0x1     // main voltage regulator is on
#define DRUN_DFLASH_POWER_DOWN_MODE 0x1     // data flash is in power-down mode
#define DRUN_DFLASH_LOW_POWER_MODE  0x2     // data flash is in low-power mode
#define DRUN_DFLASH_NORMAL_MODE     0x3     // data flash is in normal mode
#define DRUN_CFLASH_POWER_DOWN_MODE 0x1     // code flash is in power-down mode
#define DRUN_CFLASH_LOW_POWER_MODE  0x2     // code flash is in low-power mode
#define DRUN_CFLASH_NORMAL_MODE     0x3     // code flash is in normal mode
#define DRUN_SECPLL_OFF             0x0     // secondary PLL is off
#define DRUN_SECPLL_ON              0x1     // secondary PLL is on
#define DRUN_SYSPLL_OFF             0x0     // system PLL is off
#define DRUN_SYSPLL_ON              0x1     // system PLL is on
#define DRUN_XOSC_OFF               0x0     // 4MHz crystal oscillator is off
#define DRUN_XOSC_ON                0x1     // 4MHz crystal oscillator is on
#define DRUN_INTOSC_OFF             0x0     // 16MHz internal RC oscillator is off
#define DRUN_INTOSC_ON              0x1     // 16MHz internal RC oscillator is on

/*******************************************************************************
* External variables
*******************************************************************************/
extern uint32_t IntcIsrVectorTable[];   // Reference the Vector Table

/*******************************************************************************
* External functions
*******************************************************************************/
//extern void enableIrq(void);
extern void sys_init(void);
