/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      state_machine.h
*
* @author    b15651
* 
* @version   1.0.1.0
* 
* @date      Jul-22-2011
* 
* @brief     Header file for StateMachineFrame "c" project
*
*******************************************************************************
*
* Detailed Description of the file. If not used, remove the separator above.
*
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/
#include "state_machine.h"

/******************************************************************************
| External declarations
-----------------------------------------------------------------------------*/

/******************************************************************************
| Defines and macros            (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Typedefs and structures       (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Global variable definitions   (scope: module-exported)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Global variable definitions   (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function prototypes           (scope: module-local)
-----------------------------------------------------------------------------*/


/******************************************************************************
| Function implementations      (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function implementations      (scope: module-exported)
-----------------------------------------------------------------------------*/
extern void stateFault(pmsmFOC_t *ptr);
extern void stateReset(pmsmFOC_t *ptr);
extern void stateInit(pmsmFOC_t *ptr);
extern void stateReady(pmsmFOC_t *ptr);
extern void stateCalib(pmsmFOC_t *ptr);
extern void stateAlign(pmsmFOC_t *ptr);
extern void stateRun(pmsmFOC_t *ptr);

extern PFCN_VOID_PARAM_PMSM state_table[13][7]={
    /* Actual state ->       'Reset'       'Init'           'Fault'         'Ready'         'Calib'         'Align'         'Run'*/
    /* e_reset          */ { stateReset,    stateReset,     stateFault,     stateReset,     stateReset,     stateReset,     stateReset},
    /* e_reset_done     */ { stateInit,     stateFault,     stateFault,     stateFault,     stateFault,     stateFault,     stateFault},
    /* e_fault          */ { stateFault,    stateFault,     stateFault,     stateFault,     stateFault,     stateFault,     stateFault},
    /* e_fault_clear    */ { stateFault,    stateFault,     stateInit,      stateFault,     stateFault,     stateFault,     stateFault},
    /* e_init_done      */ { stateFault,    stateReady,     stateFault,     stateFault,     stateFault,     stateFault,     stateFault},
    /* e_ready          */ { stateFault,    stateFault,     stateFault,     stateReady,     stateFault,     stateFault,     stateFault},
    /* e_app_on         */ { stateFault,    stateFault,     stateFault,     stateCalib,     stateFault,     stateFault,     stateFault},
    /* e_calib          */ { stateFault,    stateFault,     stateFault,     stateFault,     stateCalib,     stateFault,     stateFault},
    /* e_calib_done     */ { stateFault,    stateFault,     stateFault,     stateFault,     stateAlign,     stateFault,     stateFault},
    /* e_align          */ { stateFault,    stateFault,     stateFault,     stateFault,     stateFault,     stateAlign,     stateFault},
    /* e_align_done     */ { stateFault,    stateFault,     stateFault,     stateFault,     stateFault,     stateRun,       stateFault},
    /* e_run            */ { stateFault,    stateFault,     stateFault,     stateFault,     stateFault,     stateFault,     stateRun},
    /* e_app_off        */ { stateFault,    stateFault,     stateFault,     stateReady,     stateInit,      stateInit,      stateInit}
};

