/*******************************************************************************
* NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. NXP neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. IN NO EVENT
SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold NXP harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     NXA19261
* Version   1.0
* Date      Aug-17-2017
* Classification   General Business Information
* Brief     S12Z Flash routines header file.
********************************************************************************
* Detailed Description:
* S12Z Flash routines header file.
* 
********************************************************************************
Revision History:
Version  Date         Author    Description of Changes
1.0      Aug-17-2017  NXA19261  Initial version
*******************************************************************************/

#ifndef _FLASH_12Z_H
#define _FLASH_12Z_H

#include "Config.h"

//==============================================================================
// Definitions
//==============================================================================
#define FLASH_SECTOR_SIZE 512

/* Error codes */
#define OK          0
#define ERASED      1
#define NON_ERASED  2
#define MISALIGNED_ADDRESS  3
#define ACCESS_ERROR        4

//==============================================================================
// Function Prototypes
//============================================================================== 
#pragma CODE_SEG DEFAULT_RAM
extern void PFLASH_Send_Command(void);
#pragma CODE_SEG DEFAULT

#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT_RAM
#endif /* BOOTLODER_REWRITABLE */
extern unsigned char PFLASH_Erase_Verify_Section(unsigned long int address, unsigned int number_of_phrases);
extern unsigned char PFLASH_Program(unsigned long int address, unsigned int *ptr);
extern unsigned char PFLASH_Erase_Sector(unsigned long int address);
extern unsigned char PFLASH_EraseSectorBySector(unsigned long int addr_l, unsigned long int addr_h);
extern unsigned char PFLASH_Protection_Override(unsigned int comparison_key, unsigned char new_FPROT_value, unsigned char new_DPROT_value, unsigned char protection_update_selection);
extern unsigned char PFLASH_Read_Byte(unsigned long int address);
extern unsigned int PFLASH_Read_Word(unsigned long int address);
#if BOOTLODER_REWRITABLE 
#pragma CODE_SEG DEFAULT
#endif /* BOOTLODER_REWRITABLE */
extern void PFLASH_Init(unsigned char fdiv);
#endif /* _FLASH_12Z_H */

