/*******************************************************************************
* NXP Semiconductors
* (c) Copyright 2016 NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. 
IN NO EVENT SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THIS AGREEMENT. 
CUSTOMER agrees to hold NXP harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             main.c
* Owner:            b21190(Vlna Peter)
* Version:          1.0
* Date:             Oct-22-2014
* Classification:   General Business Information
* Brief:            DRUN mode with max core frequency(200MHz) generated from PPL0
*                   Demonstrate PMC software triggered single self-test
********************************************************************************
********************************************************************************
* Detailed Description:
*
* 
* ------------------------------------------------------------------------------
* Test HW:  MPC57xx
* Maskset:  1N15P and 0N15P
* Target :  internal_FLASH
* Fsys:     200 MHz PLL with 40 MHz crystal reference
*           
********************************************************************************
Revision History:
1.0     Apr-04-2016     b21190(Vlna Peter)  Initial Version
1.1     May-03-2017     b21190(Vlna Peter)  added software PMC signle self-test
1.2     Aug-31-2017     b21190(Vlna Peter)  added PMC configuration fix
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "MPC5744P.h"

/*******************************************************************************
* Constants and macros
*******************************************************************************/
#define 	DRUN_MODE 	0x3
#define		LVD_CORE	0x3
#define		HVD_CORE	0x4
#define		LVD_VDDREG	0x6
#define		LVD_FLASH	0x7
#define		LVD_ADC		0x8
#define		LVD_OSC 	0x9
#define		LVD_IO		0xA
#define		LVD_CORE_HOT	0xD


/*******************************************************************************
* External objects
*******************************************************************************/

/*******************************************************************************
* Global variables
*******************************************************************************/

/*******************************************************************************
* Local functions
*******************************************************************************/

/*******************************************************************************
Function Name : Sys_Init
Engineer      : b21190
Date          : Apr-04-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Clock settings
Issues        : NONE
*******************************************************************************/
void Sys_Init(void)
{
    //Enable external oscilator
    MC_ME.DRUN_MC.B.XOSCON = 1;

    // Set PLL0 to 200MHz
    PLLDIG.PLL0CR.B.CLKCFG = 1;		    //Bypass mode PLL0 on
    // RFDPHI1 = 10, RFDPHI = 1, PREDIV = 2, MFD = 28
    PLLDIG.PLL0DV.R = 0x50000000 |0x00010000 |0x00002000 |0x00A ; //predefined PLL0 divider register


    // Set PPL0 as system clock
    MC_ME.DRUN_MC.B.PLL0ON = 1;             //Enable PLL0 for DRUN mode
    MC_ME.DRUN_MC.B.SYSCLK = 0x2;
    
    //  System clock dividers //
    
    // Enable system clock divider /4 -> 50MHz
    // (PBRIDGE_0, PBRIDGE_1, SIPI, DMA_CH_MUX) - Use only odd DIV values(2,4,etc..)
    //            Enable divider | divide by 4
    MC_CGM.SC_DC0.R = 0x80000000 | 0x30000;

    
    //  AUX_0 clock dividers //
    
    MC_CGM.AC0_SC.B.SELCTL =0x2;		//connect PLL0 to AXU_0
    
    // MOTC_CLK clock devider = 3 -> 200MHz/2 = 100MHz
    //             Enable divider | divide by 2
    MC_CGM.AC0_DC0.R = 0x80000000 | 0x10000;

    // SGEN_CLK clock devider = 10 -> 200MHz/10 = 20MHz
    //             Enable divider | divide by 10  
    MC_CGM.AC0_DC1.R = 0x80000000 | 0xA0000;

    // SAR ADC clock devider = 3 -> 200MHz/3 = 66.6MHz
    //             Enable divider | divide by 3  
    MC_CGM.AC0_DC2.R = 0x80000000 | 0x20000;

    
    //  AUX_1 clock dividers //
    
    // FRAY_CLK clock devider = 5 -> 200MHz/5 = 40MHz
    //             Enable divider | divide by 5  
    MC_CGM.AC1_DC0.R = 0x80000000 | 0x40000;

    // SENT_CLK clock devider = 3 -> 200MHz/3 = 66.6MHz
    //             Enable divider | divide by 3  
    MC_CGM.AC1_DC1.R = 0x80000000 | 0x20000;


    //  AUX_2 clock dividers //

    // CAN_CLK clock devider = 5 -> 200MHz/5 = 40MHz
    //             Enable divider | divide by 5
    MC_CGM.AC2_DC0.R = 0x80000000 | 0x40000;


    //  AUX_3 clock dividers //

    //	AUX Clock Selector 3 setup - source for PLL0 module
    MC_CGM.AC3_SC.B.SELCTL =1;			//connect (8..40MHz) XTALL to the PLL0 input
                           //0=IRC   1=XOSC

    
    //  AUX_4 clock dividers //
    
    //AUX Clock Selector 4 setup - source for PLL1 module
    MC_CGM.AC4_SC.B.SELCTL =3;			//connect PLL0 to AUX4

    
    //  AUX_5 clock dividers //

    MC_CGM.AC5_SC.B.SELCTL =0x2;		//connect PLL0 to AXU_5
    
    // LFAST PLL clock devider = 10 -> 200MHz/10 = 20MHz
    //            Enable divider | divide by 10  
    MC_CGM.AC5_DC0.R = 0x80000000 | 0x90000;


    //  AUX_6 clock dividers //

    MC_CGM.AC6_SC.R = 0x02000000;           	//connect PPL0 to AUX_6
    // CLKOUT_0 clock devider = 20 -> 200MHz/20 = 10MHz
    //            Enable divider | divide by 20  
    MC_CGM.AC6_DC0.R = 0x80000000 | 0x140000;

    
    //  AUX_10 clock dividers //
    
    MC_CGM.AC10_SC.R = 0x02000000;           	//connect PPL0 to AUX_10
    
    // ENET_CLK clock devider = 4 -> 200MHz/4 = 50MHz
    //            Enable divider | divide by 4  
    MC_CGM.AC10_DC0.R = 0x80000000 | 0x30000;

    
    //  AUX_11 clock dividers //
    
    MC_CGM.AC11_SC.R = 0x02000000;           	//connect PPL0 to AUX_11
    
    // ENET_TIME_CLK clock devider = 4 -> 200MHz/4 = 50MHz
    //            Enable divider | divide by 4  
    MC_CGM.AC11_DC0.R = 0x80000000 | 0x30000;

    //Mode transition to apply the PLL0 setup and set Normal mode with PLL running
    MC_ME.MCTL.R = 0x30005AF0;              //DRUN Mode & Key 
    MC_ME.MCTL.R = 0x3000A50F;              //DRUN Mode & Key

    while(!MC_ME.GS.B.S_PLL0);              //ME_GS Wait for PLL stabilization.
    while(MC_ME.GS.B.S_MTRANS);             //Waiting for end of transaction
    while(MC_ME.GS.B.S_CURRENT_MODE != DRUN_MODE);  // ME_GS Check DRUN mode has successfully been entered
 
}//Sys_Init

/*******************************************************************************
Function Name : SUIL2_Init
Engineer      : b21190
Date          : Oct-22-2014
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : SIUL2 initialization (ports), setting PB6(B9) as output for clock measurement
Issues        : NONE
*******************************************************************************/
void SUIL2_Init(void)
{
   SIUL2.MSCR[22].R = 0x22800001;   	/* PB6 as CLK_OUT (on EVB it is B9)*/
}//SUIL2_Init

/*******************************************************************************
Function Name : PMC_prepare_test
Engineer      : b21190
Date          : Apr-20-2017
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : PMC single self-test preparation. (result clearing)
Issues        : NONE
*******************************************************************************/
void PMC_prepare_test(void)
{
     /* set mode to default */
    PMC.VD_UTST.B.ST_MODE = 0x0; 	/* default mode */
    /* clear result bit */
    PMC.VD_UTST.B.ST_RESULT = 0x1; 	/* clear results */
}//PMC_prepare_test

/*******************************************************************************
Function Name : PMC_single_self_test
Engineer      : b21190
Date          : Apr-20-2017
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : PMC software triggered single self-test
                PMC module analog part is clocked by IRC osc and digital by
		PBRIDGE clock. Reset reaction during PMC self-test is masked
		while STTW counter is active. If the test is not finished after
		wathdog expires then reaction is not masked anymore and reset is
		triggered.
Issues        : NONE
*******************************************************************************/
void PMC_single_self_test(void)
{
    /* Program DCF records to disable LVD reset reactions before test execution */
    /* PMC self-test is running from PBRIDGE_CLK */

    PMC_prepare_test();
    
    /* set watchdog timeout */
    /* 1 SW test last ~8us */
    /* PBRIDGE_CLK = 50MHz */ 
    /* 1 SW test => 8us * PBRIDGE_CLK = 8 * 50 = 400us = ~0x190h */
    /* this is dependent on power supply, it is always goo to have a slight reserve */
    /* Value in PMC STTW is valid for 1 SW test*/
    PMC.STTW.R = 0x19A;			/* 0x19Ah */          

    /* Select self-test */
    /* Single VD test as indicated by the VD_UTST bits */
    PMC.VD_UTST.B.VD_ST_CTRL = LVD_CORE;
    
    /* configure self-tet mode bits for testing Single VD test */
    PMC.VD_UTST.B.ST_MODE = 0x2; 	/* start Single VD self test */

  
}//PMC_single_self_test

/*******************************************************************************
* Global functions
*******************************************************************************/
void main (void)
{
  Sys_Init();
  SUIL2_Init();
  PMC_single_self_test();

  while(1);
}//main
