/* ###################################################################
**     Filename    : main.c
**     Processor   : S32K1xx
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.00
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including necessary module. Cpu.h contains other modules needed for compiling.*/
#include "Cpu.h"

  volatile int exit_code = 0;

#define BUFF_SIZE 16

  uint16_t Buffers[2][BUFF_SIZE] = {
      {0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234},
      {0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321, 0x4321}
  };

  uint8_t CurrentBuffer;
  uint8_t FreeBuffer=0;
  uint8_t BufferProcessing = BUFF_SIZE;
  uint16_t *ProcessingBuffferPtr = &Buffers[0][0];



  uint16_t* Buffer0[1] = {&(Buffers[0][0])};
  uint16_t* Buffer1[1] = {&(Buffers[1][0])};

  extern void DMA_Callback(void *parameter, edma_chn_status_t status);

  void DMA_Callback(void *parameter, edma_chn_status_t status)
  {
	  FreeBuffer^=1;
	  /* Buffer processing is started on first element */
	  BufferProcessing = 0;
	  /* Processing buffer ptr set to free Buffer */
	  ProcessingBuffferPtr = Buffers[FreeBuffer];

	  if (FreeBuffer)
	  {
		  SAI_DRV_Send(INST_SAI1, (const uint8_t**) &(Buffer0[0]), BUFF_SIZE);
	  }
	  else
	  {
		  SAI_DRV_Send(INST_SAI1, (const uint8_t**) &(Buffer1[0]), BUFF_SIZE);

	  }

  }

/* User includes (#include below this line is not maintained by Processor Expert) */

/*! 
  \brief The main function for the project.
  \details The startup initialization sequence is the following:
 * - startup asm routine
 * - main()
*/
int main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  #ifdef PEX_RTOS_INIT
    PEX_RTOS_INIT();                   /* Initialization of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  /* For example: for(;;) { } */

    /* Initialize and configure clocks
     *    -   see clock manager component for details
     */
    CLOCK_SYS_Init(g_clockManConfigsArr, CLOCK_MANAGER_CONFIG_CNT,
    		g_clockManCallbacksArr, CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(0U, CLOCK_MANAGER_POLICY_AGREEMENT);
    /* Initialize edma
     *    -   See edma component for more info
     */
    EDMA_DRV_Init (&dmaController1_State, &dmaController1_InitConfig0, edmaChnStateArray, edmaChnConfigArray, EDMA_CONFIGURED_CHANNELS_COUNT);
    /* Initialize pins
     *    -   See PinSettings component for more info
     */
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS, g_pin_mux_InitConfigArr);
    /* Enables system interrupt */
    INT_SYS_EnableIRQGlobal();

    SAI_DRV_TxInit(INST_SAI1, &sai1_InitConfig0, &sai1TxState);
    SAI_DRV_Send(INST_SAI1, (const uint8_t**) &(Buffer1[0]), BUFF_SIZE);

    while (1)
    {
        while(BufferProcessing < BUFF_SIZE)
        {
            ProcessingBuffferPtr[BufferProcessing++]++;
        }
    }


  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;) {
    if(exit_code != 0) {
      break;
    }
  }
  return exit_code;
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the NXP S32K series of microcontrollers.
**
** ###################################################################
*/
