/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "fsl_common.h"
#include "pin_mux.h"
#include "fsl_iocon.h"

#define PIN1_IDX                         1u   /*!< Pin number for pin 1 in a port 0 */
#define PIN2_IDX                         2u   /*!< Pin number for pin 2 in a port 0 */
#define PORT0_IDX                        0u   /*!< Port index */


/*FUNCTION**********************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 *END**************************************************************************/
void BOARD_InitPins(void)
{
    /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */
    CLOCK_EnableClock(kCLOCK_Iocon);

    const uint32_t port0_pin29_config = (/* Pin is configured as FC0_RXD_SDA_MOSI */
                                         IOCON_PIO_FUNC1 |
                                         /* No addition pin function */
                                         IOCON_PIO_MODE_INACT |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN29 (coords: B13) is configured as FC0_RXD_SDA_MOSI */
    IOCON_PinMuxSet(IOCON, 0U, 29U, port0_pin29_config);

    const uint32_t port0_pin30_config = (/* Pin is configured as FC0_TXD_SCL_MISO */
                                         IOCON_PIO_FUNC1 |
                                         /* No addition pin function */
                                         IOCON_PIO_MODE_INACT |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN30 (coords: A2) is configured as FC0_TXD_SCL_MISO */
    IOCON_PinMuxSet(IOCON, 0U, 30U, port0_pin30_config);


#if 0
    /* SPI */
    /* SPI_CLK         D13     PIO1_2 */
    IOCON_PinMuxSet(IOCON, 1u, 2u,  IOCON_PIO_FUNC(6) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_MISO        D12     PIO1_3 */
    IOCON_PinMuxSet(IOCON, 1u, 3u,  IOCON_PIO_FUNC(3) | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_MODE(2));
    /* SPI_MOSI        D11     PIO0_26 */
    IOCON_PinMuxSet(IOCON, 0u, 26u, IOCON_PIO_FUNC(9) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_CS_TFT      D10     PIO1_1 */
    IOCON_PinMuxSet(IOCON, 1u, 1u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* GPIO_LCD_BL     D9      PIO1_5 */
    IOCON_PinMuxSet(IOCON, 1u, 5u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* GPIO_LCD_DC     D7      PIO1_9 */
    IOCON_PinMuxSet(IOCON, 1u, 9u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_CS_SD       D5      PIO1_4 */
    IOCON_PinMuxSet(IOCON, 1u, 4u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_CS_TOUCH    D4      PIO1_7 */
    IOCON_PinMuxSet(IOCON, 1u, 7u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
#else
    /* SPI_CLK         D13     PIO1_2 */
    IOCON_PinMuxSet(IOCON, 1u, 2u,  IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_MISO        D12     PIO1_3 */
    IOCON_PinMuxSet(IOCON, 1u, 3u,  IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_MODE(2));
    /* SPI_MOSI        D11     PIO0_26 */
    IOCON_PinMuxSet(IOCON, 0u, 26u, IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_CS_TFT      D10     PIO1_1 */
    IOCON_PinMuxSet(IOCON, 1u, 1u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* GPIO_LCD_BL     D9      PIO1_5 */
    IOCON_PinMuxSet(IOCON, 1u, 5u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* GPIO_LCD_DC     D7      PIO1_9 */
    IOCON_PinMuxSet(IOCON, 1u, 9u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_CS_SD       D5      PIO1_4 */
    IOCON_PinMuxSet(IOCON, 1u, 4u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);
    /* SPI_CS_TOUCH    D4      PIO1_7 */
    IOCON_PinMuxSet(IOCON, 1u, 7u , IOCON_PIO_FUNC(0) | IOCON_PIO_DIGIMODE_MASK);

#endif

#if 1 /* SDIO SDCard. */
    IOCON_PinMuxSet(IOCON, 0u, 17u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT0 PIN10 (coords: P1) is configured as SD_CARD_DET_N */
    IOCON_PinMuxSet(IOCON, 0u,  7u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT0 PIN7 (coords: B1) is configured as SD_CLK */
    IOCON_PinMuxSet(IOCON, 0u,  8u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT2 PIN4 (coords: D3) is configured as SD_CMD */
    IOCON_PinMuxSet(IOCON, 0u,  9u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT2 PIN5 (coords: C1) is configured as SD_POW_EN */
    IOCON_PinMuxSet(IOCON, 0u, 24u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT2 PIN6 (coords: F3) is configured as SD_D(0) */
    IOCON_PinMuxSet(IOCON, 0u, 25u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT2 PIN7 (coords: J2) is configured as SD_D(1) */
    IOCON_PinMuxSet(IOCON, 0u, 31u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT2 PIN8 (coords: F4) is configured as SD_D(2) */
    IOCON_PinMuxSet(IOCON, 1u,  0u, IOCON_PIO_FUNC(2) | IOCON_PIO_DIGIMODE_MASK); /* PORT2 PIN9 (coords: K2) is configured as SD_D(3) */
#endif





}

/* EOF. */

