﻿#ifndef __BMP_H
#define __BMP_H
#include "app.h"

typedef enum
{
    eErrTypeBMP_NONE = 0,
    eErrTypeBMP_OPEN_FILE,
    eErrTypeBMP_FILE_HEAD,
    eErrTypeBMP_MALLOC,
    eErrTypeBMP_NOT_SUPPORT,
} BMP_ERR;

/*位图 = 文件头 + 信息头 + 调色板(可选) + 数据体 */

#pragma pack (1) /* pack_start */
/* 位图文件头 --结构体14字节*/
typedef struct tagBITMAP_FILE_HEADER
{
    uint16_t bfType;                                                            //--&H 4D42->ASCII_'BM'
    uint32_t bfSize;
    uint16_t bfReserved1;
    uint16_t bfReserved2;
    uint32_t bfOffBits;
} BITMAP_FILE_HEADER;

/* 位图信息头 --40字节*/
typedef struct tagBITMAP_INFO_HEADER{
    uint32_t biSize;                                                            //--位图信息头大小
    uint32_t biWidth;                                                           //--位图宽度，以像素为单元--行必须为4字节倍数？
    uint32_t biHeight;

    uint16_t biPlanes;
    uint16_t biBitCount;                                                        //--单位像素的位数，表示BMP图片的颜色位数(1/4/8/16/24/32)
    uint32_t biCompression;                                                     //--BMP不压缩 = 0；
    uint32_t biSizeImage;
    uint32_t biXPelsPerMeter;
    uint32_t biYPelsPerMeter;
    uint32_t biClrUsed;                                                         //--使用了多少个颜色索引表；(设为0 使用所有调色板？)
    uint32_t biClrImportant;
} BITMAP_INFO_HEADER;

/*--3.调色板结构体(所有颜色都是由RGB调色得到)*/
typedef struct tagRGBQUAD
{
    uint8_t rgbBlue;
    uint8_t rgbGreen;
    uint8_t rgbRed;
    uint8_t rgbReserved;
} RGBQUAD;

#pragma pack () /* pack_end */

//BMP_ERR_TypeDef APP_LCD_ShowBMP( uint16_t Start_y, const char *bmpPathPtr );
//int APP_Show_BMP_UsingBuffer(uint16_t * Buffer);

//int APP_FAT_Init(void);
extern uint8_t gAppBmpDisplayData[2 * LCD_HEIGHT * LCD_WIDTH]; /* display buff for LCD. */
BMP_ERR App_BmpDumpFromFile(char * filename, uint16_t * height, uint16_t * width, uint8_t * displaydata);

#endif
/************************ (C) COPYRIGHT STMicroelectronics **********END OF FILE*************************/