﻿/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _APP_H_
#define _APP_H_

#include <stdio.h>

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"

#include "fsl_common.h"
#include "fsl_clock.h"
#include "fsl_spi.h"
#include "fsl_gpio.h"
#include "fsl_powerquad.h"

#include "lcd.h"
#include "lcd_fonts.h"

#include "arm_math.h"
#include "arm_const_structs.h" /* for fft. */

/* for sdcard. */
#include "fsl_sd.h"
#include "ff.h"
#include "diskio.h"
#include "fsl_sd_disk.h"

#include "bmp.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define APP_USER_TASK_FFT_128_IDX    0u
#define APP_USER_TASK_FFT_256_IDX    1u
#define APP_USER_TASK_FFT_512_IDX    2u
#define APP_USER_TASK_MAT_ADD_IDX    3u
#define APP_USER_TASK_MAT_INV_IDX    4u
#define APP_USER_TASK_MAT_MUL_IDX    5u
#define APP_USER_TASK_FIR_HPS_IDX    6u
#define APP_USER_TASK_FIR_LPS_IDX    7u
#define APP_USER_TASK_RECORDS_IDX    8u /* only for displaying records. */
#define APP_USER_TASK_COUNT          9u



/* PQ FFT. */
#define APP_PQ_FFT_SAMPLE_COUNT_128   128u
#define APP_PQ_FFT_SAMPLE_COUNT_256   256u
#define APP_PQ_FFT_SAMPLE_COUNT_512   512u
#define APP_PQ_FFT_SAMPLE_COUNT_MAX   APP_PQ_FFT_SAMPLE_COUNT_512

#define APP_PQ_FIR_SAMPLE_COUNT_240   240u

#define APP_PQ_FFT_PERIOD_BASE        32.5f//64u  /* 64 points for a cycle. */


#define APP_CFG_USING_TIMING_CYCLES         0u /* or show the us. */

#if !APP_CFG_USING_TIMING_CYCLES
    #define APP_TIMER_CYCLE_PER_US   (98)
#endif /* APP_CFG_USING_TIMING_CYCLES */


/* Define a type of function pointer with no parameter. */
typedef void Func0_T(void);


/* TimerCount是基于单周期计数的精细计时
 * TickTimer是基于中断和定时器变量的粗略计时
 * 二者不能同时使用,因为二者工作时配置systick的超时时间不同.
 */
/* Systick Start */
#define TimerCount_Start()	do {\
							SysTick->LOAD  =  0xFFFFFF  ;	/* set reload register */\
							SysTick->VAL  =  0  ;			/* Clear Counter */		 \
							SysTick->CTRL  =  0x5 ;			/* Enable Counting*/	 \
							} while(0)

/* Systick Stop and retrieve CPU Clocks count */
#define TimerCount_Stop(Value) 	do {\
								SysTick->CTRL  =0;	/* Disable Counting */				 \
								Value = SysTick->VAL;/* Load the SysTick Counter Value */\
								Value = 0xFFFFFF - Value;/* Capture Counts in CPU Cycles*/\
								} while(0)

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

void BOARD_InitHardware(void);

void     App_StartTimer(void);
void     App_StopTimer(void);
uint32_t App_GetTime(void);

/* LCD. */
void lcd_print_waveform( uint16_t *dat, uint16_t len, uint16_t hwColor);
void lcd_print_waveform_fir( uint16_t *dat, uint16_t len, uint16_t hwColor);
void lcd_print_freqspec( uint16_t *dat, uint16_t len, uint16_t hwColor);
void lcd_print_text( uint8_t  lineIdx, uint8_t  *buf, uint16_t hwColor);
void lcd_print_waveform_text( uint8_t  *buf, uint16_t hwColor);
void lcd_print_freqspec_text( uint8_t  *buf, uint16_t hwColor);

/* Touch Key. */
void     App_InitUserKey(void);
void     App_DeinitUserKey(void);
uint32_t App_GetUserKeyValue(void);

#endif /* _APP_H_ */
