/* task_cmsis_dsp_mark.c */
#include "app.h"
#include "arm_fft_bin_data.h"

/* Keep the scores for each tested function. */
uint32_t gu32CmsisDspMarks[10];



/*
* Internal Functions.
*/
static uint32_t App_CmsisDsp_MatrixAdd_Mark(void);
static uint32_t App_CmsisDsp_FFT(void);

void App_CmsisDsp_MarkAll(void)
{
    gu32CmsisDspMarks[0] = App_CmsisDsp_MatrixAdd_Mark();
    gu32CmsisDspMarks[1] = App_CmsisDsp_FFT();
}

/* Matrix addition. */
static uint32_t App_CmsisDsp_MatrixAdd_Mark(void)
{
    return 0u;
}

/* FFT calculation. */
#define TEST_FFT_SIZE_1024  1024
#define TEST_LENGTH_SAMPLES 2048 /* TEST_FFT_SIZE_1024 * 2 */
static uint32_t App_CmsisDsp_FFT(void)
{
    float32_t testInput_f32_10khz[] = ARM_CMSIS_DSP_FFT_TEST_INPUT_F32_2048;
    float32_t testOutput[TEST_LENGTH_SAMPLES/2];
    float32_t maxValue;
    uint32_t  maxIndex;
    uint32_t  t;

    App_StartTimer();
    /* Process the data through the CFFT/CIFFT module, Complex FFT. */
    arm_cfft_f32(&arm_cfft_sR_f32_len1024,
                 testInput_f32_10khz,
                 0 /* ifftFlag */,
                 1 /*doBitReverse*/
                );
    t = App_GetTime();
    App_StopTimer();
    PRINTF("t1: %d.\r\n", t);

    App_StartTimer();
    /* Process the data through the Complex Magnitude Module for calculating the magnitude at each bin. */
    arm_cmplx_mag_f32(testInput_f32_10khz,
                      testOutput,
                      TEST_FFT_SIZE_1024);
    t = App_GetTime();
    App_StopTimer();
    PRINTF("t2: %d.\r\n", t);

    t = App_GetTime();
    arm_max_f32(testOutput, TEST_FFT_SIZE_1024, &maxValue, &maxIndex);
    t = App_GetTime();
    App_StopTimer();
    PRINTF("t3: %d.\r\n", t);

    PRINTF("maxIndex: %d\r\n", maxIndex);

    return 0;
}

/* EOF. */

