﻿/* task_lcd_show.c */
#include "app.h"

/* 使用打点法显示曲线 */
/* 如果硬件性能足够强,更方便的是刷屏+大显存的方式 */

/*
* LCD显示器的分辨率为320(行)x240,显示为竖屏,从上到下分为三个区域:
* - 第一区域:时域波形(144行)
* - 第二区域:频域频谱(144行)
* - 第三区域:字符显示( 32行),可显示两行
*/

#define LCD_LINE_WAVEFORM_COUNT  128u
#define LCD_LINE_WAVEFORM_START  8u
#define LCD_LINE_WAVEFOMR_END    (LCD_LINE_WAVEFORM_START + LCD_LINE_WAVEFORM_COUNT)

#define LCD_LINE_FREQSPEC_COUNT  128u
#define LCD_LINE_FREQSPEC_START  144u
#define LCD_LINE_FREQSPEC_END    (LCD_LINE_FREQSPEC_START + LCD_LINE_FREQSPEC_COUNT)

#define LCD_LINE_TEXT_COUNT      32u
#define LCD_LINE_TEXT_START      288u
#define LCD_LINE_TEXT_END        (LCD_LINE_TEXT_START+LCD_LINE_TEXT_COUNT-1)

/* 给任务函数使用,使用固定内存,取代堆栈开销 */
uint16_t gLcdWaveformDispBuf[LCD_WIDTH]; /* 显示时域波形曲线. */
uint16_t gLcdFreqSpecDispBuf[LCD_WIDTH]; /* 显示频域频谱图. */
uint8_t  gLcdTextDispBuf[LCD_WIDTH/8u];  /* 显示字符区域 */
/*
* 在第一区域显示时域波形
* 显示范围为8行 - 137行(128行),138-400行打底标线
*/
void lcd_print_waveform
(
    uint16_t *dat, /* 显示波形的Y坐标集合,有效值为0-127. */
    uint16_t len,  /* 显示波形的长度,在显示屏上从最x=0的位置开始 */
    uint16_t hwColor /* 显示波形点的颜色 */
)
{
    uint16_t x;
    uint16_t y;

    len = (len > LCD_WIDTH)?LCD_WIDTH:len; /* 实际显示长度不能超过显示屏宽度 */
    for (x=0u; x < len; x++)
    {
        y = (dat[x] > LCD_LINE_WAVEFORM_COUNT) ? LCD_LINE_WAVEFORM_COUNT : dat[x];
        y = LCD_LINE_WAVEFOMR_END - y;
        //lcd_draw_point(x, y, hwColor);
        //lcd_draw_point(x, y-1u, hwColor); /* 多画一个点,这样显得图线粗一些 */
        /* 打印一条线 */
        for (uint16_t yIdx = y; yIdx <= LCD_LINE_WAVEFOMR_END; yIdx++)
        {
            lcd_draw_point(x, yIdx, hwColor);
        }
    }
}


/*
* 在第二区域显示波形2
* 显示范围为144行 - 271行(128行),138-400行打底标线
*/
void lcd_print_waveform_fir
(
    uint16_t *dat, /* 显示波形的Y坐标集合,有效值为0-127. */
    uint16_t len,  /* 显示波形的长度,在显示屏上从最x=0的位置开始 */
    uint16_t hwColor /* 显示波形点的颜色 */
)
{
    uint16_t x;
    uint16_t y;

    len = (len > LCD_WIDTH)?LCD_WIDTH:len; /* 实际显示长度不能超过显示屏宽度 */
    for (x=0u; x < len; x++)
    {
        y = (dat[x] > LCD_LINE_FREQSPEC_COUNT) ? LCD_LINE_FREQSPEC_COUNT : dat[x];
        y = LCD_LINE_FREQSPEC_END - y;

        //lcd_draw_point(x, y, hwColor);

        /* 打印一条线 */
        for (uint16_t yIdx = y; yIdx <= LCD_LINE_FREQSPEC_END; yIdx++)
        {
            lcd_draw_point(x, yIdx, hwColor);
        }
    }
}

/*
* 在第二区域显示频谱波形
* 显示范围为144行 - 271行(128行),138-400行打底标线
*/
void lcd_print_freqspec
(
    uint16_t *dat, /* 显示波形的Y坐标集合,有效值为0-127. */
    uint16_t len,  /* 显示波形的长度,在显示屏上从最x=0的位置开始 */
    uint16_t hwColor /* 显示波形点的颜色 */
)
{
    uint16_t x;
    uint16_t y, yIdx;

    len = (len > LCD_WIDTH)?LCD_WIDTH:len; /* 实际显示长度不能超过显示屏宽度 */
    for (x=0u; x < len; x++)
    {
        y = (dat[x] > LCD_LINE_FREQSPEC_COUNT) ? LCD_LINE_FREQSPEC_COUNT : dat[x];
        y = LCD_LINE_FREQSPEC_END - y;

        /* 打印一条线 */
        for (yIdx = y; yIdx <= LCD_LINE_FREQSPEC_END; yIdx++)
        {
            lcd_draw_point(x, yIdx, hwColor);
        }
    }
}

/* 在显示屏幕底部打印1608字体 */
void lcd_print_text
(
    uint8_t  lineIdx, /* 行数, 目前只有两行有效, 有效值为0, 1 */
    uint8_t  *buf,    /* 显示字符串,建议使用sprintf格式化打印到buf中再显示 */
    uint16_t hwColor
)
{
    uint16_t y = LCD_LINE_TEXT_START;
    uint16_t x = 0u;

    lineIdx = (lineIdx > 1u) ? 1u : lineIdx;
    y += lineIdx * 16u;

    while (x < (LCD_WIDTH-8u) )
    {
        lcd_display_char(x, y, *buf++, LCD_FONT_1608, hwColor);
        if (*buf == '\0')
        {
            break;
        }
        else if ( (*buf == '\r') || (*buf == '\n') )
        {
            break;
        }
        else
        {
            x += 8u;
        }
    }
}


void lcd_print_waveform_text
(
    uint8_t  *buf,    /* 显示字符串,建议使用sprintf格式化打印到buf中再显示 */
    uint16_t hwColor /* 显示波形点的颜色 */
)
{
    uint16_t y = LCD_LINE_WAVEFORM_START;
    uint16_t x = 0u;


    while (x < (LCD_WIDTH-8u) )
    {
        lcd_display_char(x, y, *buf++, LCD_FONT_1206, hwColor);
        if (*buf == '\0')
        {
            break;
        }
        else if ( (*buf == '\r') || (*buf == '\n') )
        {
            break;
        }
        else
        {
            x += 8u;
        }
    }
}

void lcd_print_freqspec_text
(
    uint8_t  *buf,    /* 显示字符串,建议使用sprintf格式化打印到buf中再显示 */
    uint16_t hwColor /* 显示波形点的颜色 */
)
{
    uint16_t y = LCD_LINE_FREQSPEC_START;
    uint16_t x = 0u;


    while (x < (LCD_WIDTH-8u) )
    {
        lcd_display_char(x, y, *buf++, LCD_FONT_1206, hwColor);
        if (*buf == '\0')
        {
            break;
        }
        else if ( (*buf == '\r') || (*buf == '\n') )
        {
            break;
        }
        else
        {
            x += 8u;
        }
    }
}


/* EOF. */

