/* task_pq_matrix_mark.c */
#include "app.h"

#define PQ_ROW_COUNT_MAX 16u
#define PQ_COL_COUNT_MAX 16u

void TEST_PQ_Matrix_Addition(void)
{
    arm_matrix_instance_f32 matrixA;
    arm_matrix_instance_f32 matrixB;
    arm_matrix_instance_f32 matrixC;
    float32_t mDataA[PQ_ROW_COUNT_MAX][PQ_COL_COUNT_MAX];
    float32_t mDataB[PQ_ROW_COUNT_MAX][PQ_COL_COUNT_MAX];
    float32_t mDataC[PQ_ROW_COUNT_MAX][PQ_COL_COUNT_MAX];
    uint32_t i, j;
    uint32_t  calcTime;

    //PRINTF("%s()\r\n", __func__);

    /* Initialize the matrix. */
    for (i = 0u; i < PQ_ROW_COUNT_MAX; i++)
    {
        for (j = 0u; j < PQ_COL_COUNT_MAX; j++)
        {
            mDataA[i][j] = 1.0f * i * PQ_ROW_COUNT_MAX + j;
            mDataB[i][j] = 1.0f * i * PQ_ROW_COUNT_MAX + j;
        }
    }
    matrixA.numRows = PQ_ROW_COUNT_MAX;
    matrixA.numCols = PQ_COL_COUNT_MAX;
    matrixA.pData   = (float32_t *)mDataA;
    matrixB.numRows = PQ_ROW_COUNT_MAX;
    matrixB.numCols = PQ_COL_COUNT_MAX;
    matrixB.pData   = (float32_t *)mDataB;
    matrixC.numRows = PQ_ROW_COUNT_MAX;
    matrixC.numCols = PQ_COL_COUNT_MAX;
    matrixC.pData   = (float32_t *)mDataC;

    /* Calc & Measure. */
    TimerCount_Start();
    arm_mat_add_f32(&matrixA, &matrixB, &matrixC);
    TimerCount_Stop(calcTime);

    PRINTF("%s : %d cycles.\r\n", __func__, calcTime);

#if 0
    PRINTF("matrixC.numRows = %8d\r\n", matrixC.numRows);
    PRINTF("matrixC.numCols = %8d\r\n", matrixC.numCols);
    PRINTF("matrixC.pData  ->\r\n");
    for (i = 0u; i < PQ_ROW_COUNT_MAX; i++)
    {
        for (j = 0u; j < PQ_COL_COUNT_MAX; j++)
        {
            PRINTF("%8.2f ", mDataC[i][j]);
        }
        PRINTF("\r\n");
    }
#endif
}

void TEST_PQ_Matrix_Multiplication(void)
{
    arm_matrix_instance_f32 matrixA;
    arm_matrix_instance_f32 matrixB;
    arm_matrix_instance_f32 matrixC;
    float32_t mDataA[PQ_ROW_COUNT_MAX][PQ_COL_COUNT_MAX];
    float32_t mDataB[PQ_ROW_COUNT_MAX][PQ_COL_COUNT_MAX];
    float32_t mDataC[PQ_ROW_COUNT_MAX][PQ_COL_COUNT_MAX] = {0};
    uint32_t i, j;
    uint32_t  calcTime;

    //PRINTF("%s()\r\n", __func__);

    /* Initialize the matrix. */
    for (i = 0u; i < PQ_ROW_COUNT_MAX; i++)
    {
        for (j = 0u; j < PQ_COL_COUNT_MAX; j++)
        {
            mDataA[i][j] = 0.5f;
            mDataB[i][j] = 0.5f;
        }
    }
    matrixA.numRows = PQ_ROW_COUNT_MAX;
    matrixA.numCols = PQ_COL_COUNT_MAX;
    matrixA.pData   = (float32_t *)mDataA;
    matrixB.numRows = PQ_ROW_COUNT_MAX;
    matrixB.numCols = PQ_COL_COUNT_MAX;
    matrixB.pData   = (float32_t *)mDataB;
    matrixC.numRows = PQ_ROW_COUNT_MAX;
    matrixC.numCols = PQ_COL_COUNT_MAX;
    matrixC.pData   = (float32_t *)mDataC;

    /* Calc & Measure. */
    TimerCount_Start();
    arm_mat_mult_f32(&matrixA, &matrixB, &matrixC);
    TimerCount_Stop(calcTime);

    PRINTF("%s : %d cycles.\r\n", __func__, calcTime);
#if 0
    PRINTF("matrixC.numRows = %8d\r\n", matrixC.numRows);
    PRINTF("matrixC.numCols = %8d\r\n", matrixC.numCols);
    PRINTF("matrixC.pData  ->\r\n");
    for (i = 0u; i < PQ_ROW_COUNT_MAX; i++)
    {
        for (j = 0u; j < PQ_COL_COUNT_MAX; j++)
        {
            PRINTF("%8.2f ", mDataC[i][j]);
        }
        PRINTF("\r\n");
    }
#endif
}

#define PQ_MAT_INV_COL_ROW_COUNT   9u //11u

    //float32_t mDataA[PQ_MAT_INV_COL_ROW_COUNT][PQ_MAT_INV_COL_ROW_COUNT] = {0.0f};
    //float32_t mDataB[PQ_MAT_INV_COL_ROW_COUNT][PQ_MAT_INV_COL_ROW_COUNT] = {0.0f};

void TEST_PQ_Matrix_Inversion(void)
{
    arm_matrix_instance_f32 matrixA;
    arm_matrix_instance_f32 matrixB;
    float32_t mDataA[PQ_MAT_INV_COL_ROW_COUNT][PQ_MAT_INV_COL_ROW_COUNT] = {0.0f};
    float32_t mDataB[PQ_MAT_INV_COL_ROW_COUNT][PQ_MAT_INV_COL_ROW_COUNT] = {0.0f};
    uint32_t i;
    uint32_t  calcTime;

    //PRINTF("%s()\r\n", __func__);

    /* Initialize the matrix. */
    for (i = 0u; i < PQ_MAT_INV_COL_ROW_COUNT; i++)
    {
        mDataA[i][i] = 1.0f;
    }
    matrixA.numRows = PQ_MAT_INV_COL_ROW_COUNT;
    matrixA.numCols = PQ_MAT_INV_COL_ROW_COUNT;
    matrixA.pData   = (float32_t *)mDataA;
    matrixB.numRows = PQ_MAT_INV_COL_ROW_COUNT;
    matrixB.numCols = PQ_MAT_INV_COL_ROW_COUNT;
    matrixB.pData   = (float32_t *)mDataB;

    TimerCount_Start();
    arm_mat_inverse_f32(&matrixA, &matrixB);
    TimerCount_Stop(calcTime);

    PRINTF("%s : %d cycles.\r\n", __func__, calcTime);
#if 0
    PRINTF("matrixB.numRows = %8d\r\n", matrixB.numRows);
    PRINTF("matrixB.numCols = %8d\r\n", matrixB.numCols);
    PRINTF("matrixB.pData  ->\r\n");
    for (i = 0u; i < PQ_MAT_INV_COL_ROW_COUNT; i++)
    {
        for (j = 0u; j < PQ_MAT_INV_COL_ROW_COUNT; j++)
        {
            PRINTF("%8.2f ", mDataB[i][j]);
        }
        PRINTF("\r\n");
    }
#endif
}

/* EOF. */

