/* task_powerquad_mark.c */
#include "app.h"

#define EE_TICKS_PER_SEC  1000

volatile uint32_t gTicks; /* Systick counter var. */

#define SysTick_Counter_Disable    ((uint32_t)0xFFFFFFFE)
#define SysTick_Counter_Enable     ((uint32_t)0x00000001)
#define SysTick_Counter_Clear      ((uint32_t)0x00000000)

/* clear the counter and start the timer. */
void App_StartTimer(void)
{
    gTicks = 0;
    SysTick_Config(SystemCoreClock/EE_TICKS_PER_SEC);
}

/* stop the timer. */
void App_StopTimer(void)
{
    SysTick->CTRL &= SysTick_Counter_Disable; /* Stop the Timer and get the encoding time  */
    SysTick->VAL   = SysTick_Counter_Clear; /* Clear the SysTick Counter */
}

uint32_t App_GetTime(void)
{
    return gTicks;
}

/* ISR for SysTick. */
void SysTick_Handler(void)
{
    gTicks++;
}

/* EOF. */

