/* test_pq_sin.c */
#include "app.h"

#define TEST_PQ_SIN_DATA_LENGTH    36u

void TEST_PQ_Sin_F32(void)
{
    uint32_t i;
    float32_t f32In[TEST_PQ_SIN_DATA_LENGTH], f32Out[TEST_PQ_SIN_DATA_LENGTH];

    PRINTF("%s()\r\n", __func__);

    for (i = 0u; i < TEST_PQ_SIN_DATA_LENGTH; i++)
    {
        //f32In[i] = -1.0f + (0.1f * (i % 20u) );
        f32In[i] = -180.0f+ ( 10.0f * (i % 36) );
        /* Ƕֵתɻֵ */
        f32In[i] = PI * f32In[i] / 180.0f;
    }

    PRINTF("INPUT: \r\n");
    for (i = 0u; i < TEST_PQ_SIN_DATA_LENGTH; i++)
    {
        PRINTF("[%2d]: %f\r\n", i, f32In[i]);
    }

    /* powerquad calc. */
    for (i = 0u; i < TEST_PQ_SIN_DATA_LENGTH; i++)
    {
        //PRINTF("[%2d]: %f\r\n", i, f32In[i]);
        PQ_SinF32(&f32In[i], &f32Out[i]);
    }

    PRINTF("\r\n\r\nOUTPUT: \r\n");
    for (i = 0u; i < TEST_PQ_SIN_DATA_LENGTH; i++)
    {
        PRINTF("[%2d]: %f\r\n", i, f32Out[i]);
    }
}

/* EOF. */

