/*
****************************************************************************
* Copyright(c) 2014 NXP Semiconductors                                     *
* All rights are reserved.                                                 *
*                                                                          *
* Software that is described herein is for illustrative purposes only.     *
* This software is supplied "AS IS" without any warranties of any kind,    *
* and NXP Semiconductors disclaims any and all warranties, express or      *
* implied, including all implied warranties of merchantability,            *
* fitness for a particular purpose and non-infringement of intellectual    *
* property rights.  NXP Semiconductors assumes no responsibility           *
* or liability for the use of the software, conveys no license or          *
* rights under any patent, copyright, mask work right, or any other        *
* intellectual property rights in or to any products. NXP Semiconductors   *
* reserves the right to make changes in the software without notification. *
* NXP Semiconductors also makes no representation or warranty that such    *
* application will be suitable for the specified use without further       *
* testing or modification.                                                 *
*                                                                          *
* Permission to use, copy, modify, and distribute this software and its    *
* documentation is hereby granted, under NXP Semiconductors' relevant      *
* copyrights in the software, without fee, provided that it is used in     *
* conjunction with NXP Semiconductor products(UCODE I2C, NTAG I2C).        *
* This  copyright, permission, and disclaimer notice must appear in all    *
* copies of this code.                                                     *
****************************************************************************
*/
#ifndef _ISR_QN9080_INTERN_H_
#define _ISR_QN9080_INTERN_H_

/***********************************************************************/
/* INCLUDES                                                            */
/***********************************************************************/
#include <board.h>
/***********************************************************************/
/* DEFINES                                                             */
/***********************************************************************/
#define ISR_PIN_FUNC_INVALID    	0xFFFFFFFF

#define ISR_SEMAPHORE_GIVEN     	true
#define ISR_SEMAPHORE_TAKEN     	false

#define ISR_SEMAPHORE_INIT(x)         	do { x = ISR_SEMAPHORE_TAKEN; } while(0)
#define ISR_SEMAPHORE_GIVE(x)         	do { x = ISR_SEMAPHORE_GIVEN; } while(0)
#define ISR_SEMAPHORE_GIVE_FROM_ISR(x)	do { x = ISR_SEMAPHORE_GIVEN; } while(0)

#define ISR_SEMAPHORE_TAKE(x)   	do { x = false; } while(0)

#define ISR_SEMAPHORE_IS_GIVEN(x)	(x == ISR_SEMAPHORE_GIVEN)
#define ISR_SEMAPHORE_IS_TAKEN(x)	(x == ISR_SEMAPHORE_TAKEN)

#if defined(_QN9080M_)
#define ISR_WAIT_FOR_INTERRUPT() 	__WFI();
#endif

#if defined(_QN9080M_)
#define GPIO_PININT_NVIC(channel) ((IRQn_Type)(fdPortIrqId[channel]))
#define EXT_INT_FD_GPIO GPIOA
#define EXT_INT_FD_PIN 0U
#define EXT_INT_FD_PORT 0U
#endif /* _QN9080M_ */
/***********************************************************************/
/* TYPES                                                               */
/***********************************************************************/
typedef BOOL	ISR_SEMAPHORE_T;

/***********************************************************************/
/* GLOBAL VARIABLES                                                    */
/***********************************************************************/
/***********************************************************************/
/* GLOBAL FUNCTION PROTOTYPES                                          */
/***********************************************************************/
/*!
* @brief field detect pin callback
*        This callback be called in GPIOX_IRQHandler.
*		 GPIO interrupt will be close after this callback be executed.
*/
void fd_pint_callback(ISR_SOURCE_T source);


#endif /* _ISR_DRIVER_INTERN_H_ */
