/*
****************************************************************************
* Copyright(c) 2014 NXP Semiconductors                                     *
* All rights are reserved.                                                 *
*                                                                          *
* Software that is described herein is for illustrative purposes only.     *
* This software is supplied "AS IS" without any warranties of any kind,    *
* and NXP Semiconductors disclaims any and all warranties, express or      *
* implied, including all implied warranties of merchantability,            *
* fitness for a particular purpose and non-infringement of intellectual    *
* property rights.  NXP Semiconductors assumes no responsibility           *
* or liability for the use of the software, conveys no license or          *
* rights under any patent, copyright, mask work right, or any other        *
* intellectual property rights in or to any products. NXP Semiconductors   *
* reserves the right to make changes in the software without notification. *
* NXP Semiconductors also makes no representation or warranty that such    *
* application will be suitable for the specified use without further       *
* testing or modification.                                                 *
*                                                                          *
* Permission to use, copy, modify, and distribute this software and its    *
* documentation is hereby granted, under NXP Semiconductors' relevant      *
* copyrights in the software, without fee, provided that it is used in     *
* conjunction with NXP Semiconductor products(UCODE I2C, NTAG I2C).        *
* This  copyright, permission, and disclaimer notice must appear in all    *
* copies of this code.                                                     *
****************************************************************************
*/
/***********************************************************************/
/* INCLUDES                                                            */
/***********************************************************************/
#include "board.h"
#include "pin_mux.h"

#include "fsl_iocon.h"
#include "fsl_pint.h"
#include "fsl_inputmux.h"

#include "HAL_timer_driver.h"
#include "isr_driver_intern.h"
/***********************************************************************/
/* DEFINES                                                             */
/***********************************************************************/
#define PORTA_PINT_PIN0 kINPUTMUX_GpioPort0Pin0ToPintsel
#define PORT_IRQS GPIO_IRQS
/***********************************************************************/
/* GLOBAL VARIABLES                                                    */
/***********************************************************************/
/***********************************************************************/
/* LOCAL FUNCTION PROTOTYPES                                           */
/***********************************************************************/
static IRQn_Type fdPortIrqId[] = PORT_IRQS;
/***********************************************************************/
/* PROTOTYPES                                           */
/***********************************************************************/
#if defined(_QN9080M_)
/*!
* @brief Call back for GPIO PA0 interrupt.
*/
void fd_pint_callback(ISR_SOURCE_T source);
#endif

/***********************************************************************/
/* GLOBAL FUNCTIONS                                                    */
/***********************************************************************/
void HAL_ISR_Init(void)
{
    gpio_pin_config_t gpioConfig;
    gpioConfig.pinDirection = kGPIO_DigitalInput; //default pin direction
	size_t i = 0;

	for(i = 0; i < ISR_MAX_CALLBACKS; i++)
	{
        SELECT_CALLBACK(i);
        /* disable interrupt */
        DISABLE_INTERRUPT();
        /* setup interrupt mode */
        setupMode(EXT_INT_FD_GPIO, callback->pin_func, callback->mode);
	}

    /* initialize the GPIO pins for NTAG Field detect pin */
    BOARD_InitFDPin();
    IOCON_PullSet(IOCON, EXT_INT_FD_PORT, EXT_INT_FD_PIN, kIOCON_PullUp);
    IOCON_FuncSet(IOCON, EXT_INT_FD_PORT, EXT_INT_FD_PIN, 0);
    GPIO_PinInit (EXT_INT_FD_GPIO, EXT_INT_FD_PIN, &gpioConfig);
}

void setupMode(GPIO_Type *base, uint32_t pin, ISR_MODE_T mode)
{
	switch(mode)
	{
		case ISR_LEVEL_HI:
            GPIO_SetHighLevelInterrupt(base, (uint32_t)(1 << pin));
			break;
		case ISR_LEVEL_LO:
            GPIO_SetLowLevelInterrupt(base, (uint32_t)(1 << pin));
			break;
		case ISR_EDGE_RISE:
            GPIO_SetRisingEdgeInterrupt(base, (uint32_t)(1 << pin));
			break;
		case ISR_EDGE_FALL:
            GPIO_SetFallingEdgeInterrupt(base, (uint32_t)(1 << pin));
			break;
		default:
			break;
	}
}


void disableInterrupt(uint32_t channel)
{
	NVIC_DisableIRQ(GPIO_PININT_NVIC(channel));
}

void enableInterrupt(uint32_t channel)
{
	/* Enable interrupt in the NVIC */
	NVIC_ClearPendingIRQ(GPIO_PININT_NVIC(channel));
	NVIC_EnableIRQ(GPIO_PININT_NVIC(channel));
}

/***********************************************************************/
/* LOCAL FUNCTIONS                                                     */
/***********************************************************************/
/***********************************************************************/
/* INTERUPT SERVICE ROUTINES                                           */
/***********************************************************************/
#if defined(_QN9080M_)
/*!
* @brief field detect pin callback
*        This callback be called in GPIOX_IRQHandler.
*		 GPIO interrupt will be close after this callback be executed.
*/
void fd_pint_callback(ISR_SOURCE_T source)
{
    SELECT_CALLBACK(source);
    CHECK_VALID_AND_CALL_HANDLER();
    WAKEUP_TASKS();
    DISABLE_INTERRUPT();
    GPIO_ClearPinsInterruptFlags(EXT_INT_FD_GPIO, (1 << callback->pin_func));
}
#endif
