#include "sbl_api.h"
#include "memory.h"
#include "sbl_config.h"
#include "fsl_common.h"



#ifdef __ICCARM__
// IAR
__no_init uint32_t re_invoke_flag;
#elif defined(__GNUC__)
// GCC/MCUXpresso
uint32_t re_invoke_flag __attribute__((section(".noinit"))) = 0x00;
#elif defined(__CC_ARM) || defined(__ARMCC_VERSION)
// Keil
uint32_t re_invoke_flag __attribute__((zero_init));
#else
uint32_t re_invoke_flag = 0x00;
#endif

// 统一接口
uint32_t get_re_invoke_flag(void)
{
    return re_invoke_flag;
}

void set_re_invoke_flag(uint32_t value)
{
    re_invoke_flag = value;
}

void reinvoke(void)
{
    set_re_invoke_flag(REINVOKE_FLAG);

    __disable_irq();

    extern void JumpToImage(uint32_t addr);
    JumpToImage(BL_START);
}

void test(void)
{
    //printf("test\r\n");
}

#ifdef __ICCARM__
const sbl_api_t sbl_api @ 0x400 = 
#elif defined(__GNUC__)
const sbl_api_t sbl_api __attribute__((section(".bl_api"), used)) =
#else
const sbl_api_t sbl_api __attribute__((section(".ARM.__at_0x400"))) = 
#endif
{
    reinvoke,
    NULL,
    test,
};













