/*
** ###################################################################
**     Processors:          LPC55S69JBD100_cm33_core1
**                          LPC55S69JBD64_cm33_core1
**                          LPC55S69JEV98_cm33_core1
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    LPC55S6x/LPC55S2x/LPC552x User manual(UM11126) Rev.1.3  16 May 2019
**     Version:             rev. 1.1, 2019-05-16
**     Build:               b191017
**
**     Abstract:
**         CMSIS Peripheral Access Layer for LPC55S69_cm33_core1
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2019 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2018-08-22)
**         Initial version based on v0.2UM
**     - rev. 1.1 (2019-05-16)
**         Initial A1 version based on v1.3UM
**
** ###################################################################
*/

/*!
 * @file LPC55S69_cm33_core1.h
 * @version 1.1
 * @date 2019-05-16
 * @brief CMSIS Peripheral Access Layer for LPC55S69_cm33_core1
 *
 * CMSIS Peripheral Access Layer for LPC55S69_cm33_core1
 */

#ifndef _LPC55S69_CM33_CORE1_H_
#define _LPC55S69_CM33_CORE1_H_ /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0001U

/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 76 /**< Number of interrupts in the Vector table */

typedef enum IRQn
{
    /* Auxiliary constants */
    NotAvail_IRQn = -128, /**< Not available device specific interrupt */

    /* Core interrupts */
    NonMaskableInt_IRQn   = -14, /**< Non Maskable Interrupt */
    HardFault_IRQn        = -13, /**< Cortex-M33 SV Hard Fault Interrupt */
    MemoryManagement_IRQn = -12, /**< Cortex-M33 Memory Management Interrupt */
    BusFault_IRQn         = -11, /**< Cortex-M33 Bus Fault Interrupt */
    UsageFault_IRQn       = -10, /**< Cortex-M33 Usage Fault Interrupt */
    SecureFault_IRQn      = -9,  /**< Cortex-M33 Secure Fault Interrupt */
    SVCall_IRQn           = -5,  /**< Cortex-M33 SV Call Interrupt */
    DebugMonitor_IRQn     = -4,  /**< Cortex-M33 Debug Monitor Interrupt */
    PendSV_IRQn           = -2,  /**< Cortex-M33 Pend SV Interrupt */
    SysTick_IRQn          = -1,  /**< Cortex-M33 System Tick Interrupt */

    /* Device specific interrupts */
    WDT_BOD_IRQn             = 0,  /**< Windowed watchdog timer, Brownout detect, Flash interrupt */
    DMA0_IRQn                = 1,  /**< DMA0 controller */
    GINT0_IRQn               = 2,  /**< GPIO group 0 */
    GINT1_IRQn               = 3,  /**< GPIO group 1 */
    PIN_INT0_IRQn            = 4,  /**< Pin interrupt 0 or pattern match engine slice 0 */
    PIN_INT1_IRQn            = 5,  /**< Pin interrupt 1or pattern match engine slice 1 */
    PIN_INT2_IRQn            = 6,  /**< Pin interrupt 2 or pattern match engine slice 2 */
    PIN_INT3_IRQn            = 7,  /**< Pin interrupt 3 or pattern match engine slice 3 */
    UTICK0_IRQn              = 8,  /**< Micro-tick Timer */
    MRT0_IRQn                = 9,  /**< Multi-rate timer */
    CTIMER0_IRQn             = 10, /**< Standard counter/timer CTIMER0 */
    CTIMER1_IRQn             = 11, /**< Standard counter/timer CTIMER1 */
    SCT0_IRQn                = 12, /**< SCTimer/PWM */
    CTIMER3_IRQn             = 13, /**< Standard counter/timer CTIMER3 */
    FLEXCOMM0_IRQn           = 14, /**< Flexcomm Interface 0 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM1_IRQn           = 15, /**< Flexcomm Interface 1 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM2_IRQn           = 16, /**< Flexcomm Interface 2 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM3_IRQn           = 17, /**< Flexcomm Interface 3 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM4_IRQn           = 18, /**< Flexcomm Interface 4 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM5_IRQn           = 19, /**< Flexcomm Interface 5 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM6_IRQn           = 20, /**< Flexcomm Interface 6 (USART, SPI, I2C, I2S, FLEXCOMM) */
    FLEXCOMM7_IRQn           = 21, /**< Flexcomm Interface 7 (USART, SPI, I2C, I2S, FLEXCOMM) */
    ADC0_IRQn                = 22, /**< ADC0  */
    Reserved39_IRQn          = 23, /**< Reserved interrupt */
    ACMP_IRQn                = 24, /**< ACMP  interrupts */
    Reserved41_IRQn          = 25, /**< Reserved interrupt */
    Reserved42_IRQn          = 26, /**< Reserved interrupt */
    USB0_NEEDCLK_IRQn        = 27, /**< USB Activity Wake-up Interrupt */
    USB0_IRQn                = 28, /**< USB device */
    RTC_IRQn                 = 29, /**< RTC alarm and wake-up interrupts */
    Reserved46_IRQn          = 30, /**< Reserved interrupt */
    MAILBOX_IRQn             = 31, /**< WAKEUP,Mailbox interrupt (present on selected devices) */
    PIN_INT4_IRQn            = 32, /**< Pin interrupt 4 or pattern match engine slice 4 int */
    PIN_INT5_IRQn            = 33, /**< Pin interrupt 5 or pattern match engine slice 5 int */
    PIN_INT6_IRQn            = 34, /**< Pin interrupt 6 or pattern match engine slice 6 int */
    PIN_INT7_IRQn            = 35, /**< Pin interrupt 7 or pattern match engine slice 7 int */
    CTIMER2_IRQn             = 36, /**< Standard counter/timer CTIMER2 */
    CTIMER4_IRQn             = 37, /**< Standard counter/timer CTIMER4 */
    OS_EVENT_IRQn            = 38, /**< OSEVTIMER0 and OSEVTIMER0_WAKEUP interrupts */
    Reserved55_IRQn          = 39, /**< Reserved interrupt */
    Reserved56_IRQn          = 40, /**< Reserved interrupt */
    Reserved57_IRQn          = 41, /**< Reserved interrupt */
    SDIO_IRQn                = 42, /**< SD/MMC  */
    Reserved59_IRQn          = 43, /**< Reserved interrupt */
    Reserved60_IRQn          = 44, /**< Reserved interrupt */
    Reserved61_IRQn          = 45, /**< Reserved interrupt */
    USB1_PHY_IRQn            = 46, /**< USB1_PHY */
    USB1_IRQn                = 47, /**< USB1 interrupt */
    USB1_NEEDCLK_IRQn        = 48, /**< USB1 activity */
    SEC_HYPERVISOR_CALL_IRQn = 49, /**< SEC_HYPERVISOR_CALL interrupt */
    SEC_GPIO_INT0_IRQ0_IRQn  = 50, /**< SEC_GPIO_INT0_IRQ0 interrupt */
    SEC_GPIO_INT0_IRQ1_IRQn  = 51, /**< SEC_GPIO_INT0_IRQ1 interrupt */
    PLU_IRQn                 = 52, /**< PLU interrupt */
    SEC_VIO_IRQn             = 53, /**< SEC_VIO interrupt */
    HASHCRYPT_IRQn           = 54, /**< HASHCRYPT interrupt */
    CASER_IRQn               = 55, /**< CASPER interrupt */
    PUF_IRQn                 = 56, /**< PUF interrupt */
    PQ_IRQn                  = 57, /**< PQ interrupt */
    DMA1_IRQn                = 58, /**< DMA1 interrupt */
    FLEXCOMM8_IRQn           = 59  /**< Flexcomm Interface 8 (SPI, , FLEXCOMM) */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */

/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT 0          /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS 3       /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig 0 /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT 0          /**< Defines if an FPU is present or not */
#define __DSP_PRESENT 0          /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT 0    /**< Defines if an SAU is present or not */

#include "core_cm33.h"                  /* Core Peripheral Access Layer */
#include "system_LPC55S69_cm33_core1.h" /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */

/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup dma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDma0RequestHashCrypt      = 0U,  /**< HashCrypt */
    kDma1RequestHashCrypt      = 0U,  /**< HashCrypt */
    kDma0RequestNoDMARequest1  = 1U,  /**< No DMA request 1 */
    kDma1RequestNoDMARequest1  = 1U,  /**< No DMA request 1 */
    kDma0RequestFlexcomm8Rx    = 2U,  /**< Flexcomm Interface 8 RX */
    kDma1RequestFlexcomm8Rx    = 2U,  /**< Flexcomm Interface 8 RX */
    kDma0RequestFlexcomm8Tx    = 3U,  /**< Flexcomm Interface 8 TX */
    kDma1RequestFlexcomm8Tx    = 3U,  /**< Flexcomm Interface 8 TX */
    kDma0RequestFlexcomm0Rx    = 4U,  /**< Flexcomm Interface 0 RX/I2C Slave */
    kDma1RequestFlexcomm0Rx    = 4U,  /**< Flexcomm Interface 0 RX/I2C Slave */
    kDma0RequestFlexcomm0Tx    = 5U,  /**< Flexcomm Interface 0 TX/I2C Master */
    kDma1RequestFlexcomm0Tx    = 5U,  /**< Flexcomm Interface 0 TX/I2C Master */
    kDma0RequestFlexcomm1Rx    = 6U,  /**< Flexcomm Interface 1 RX/I2C Slave */
    kDma1RequestFlexcomm1Rx    = 6U,  /**< Flexcomm Interface 1 RX/I2C Slave */
    kDma0RequestFlexcomm1Tx    = 7U,  /**< Flexcomm Interface 1 TX/I2C Master */
    kDma1RequestFlexcomm1Tx    = 7U,  /**< Flexcomm Interface 1 TX/I2C Master */
    kDma0RequestFlexcomm3Rx    = 8U,  /**< Flexcomm Interface 3 RX/I2C Slave */
    kDma1RequestFlexcomm3Rx    = 8U,  /**< Flexcomm Interface 3 RX/I2C Slave */
    kDma0RequestFlexcomm3Tx    = 9U,  /**< Flexcomm Interface 3 TX/I2C Master */
    kDma1RequestFlexcomm3Tx    = 9U,  /**< Flexcomm Interface 3 TX/I2C Master */
    kDma0RequestFlexcomm2Rx    = 10U, /**< Flexcomm Interface 2 RX/I2C Slave */
    kDma0RequestFlexcomm2Tx    = 11U, /**< Flexcomm Interface 2 TX/I2C Master */
    kDma0RequestFlexcomm4Rx    = 12U, /**< Flexcomm Interface 4 RX/I2C Slave */
    kDma0RequestFlexcomm4Tx    = 13U, /**< Flexcomm Interface 4 TX/I2C Master */
    kDma0RequestFlexcomm5Rx    = 14U, /**< Flexcomm Interface 5 RX/I2C Slave */
    kDma0RequestFlexcomm5Tx    = 15U, /**< Flexcomm Interface 5 TX/I2C Master */
    kDma0RequestFlexcomm6Rx    = 16U, /**< Flexcomm Interface 6 RX/I2C Slave */
    kDma0RequestFlexcomm6Tx    = 17U, /**< Flexcomm Interface 6 TX/I2C Master */
    kDma0RequestFlexcomm7Rx    = 18U, /**< Flexcomm Interface 7 RX/I2C Slave */
    kDma0RequestFlexcomm7Tx    = 19U, /**< Flexcomm Interface 7 TX/I2C Master */
    kDma0RequestNoDMARequest20 = 20U, /**< No DMA request 20 */
    kDma0RequestADC0FIFO0      = 21U, /**< ADC0 FIFO 0 */
    kDma0RequestADC0FIFO1      = 22U, /**< ADC0 FIFO 1 */
} dma_request_source_t;

/* @} */

/*!
 * @}
 */ /* end of group Mapping_Information */

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */

/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
#if (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#else
#pragma push
#pragma anon_unions
#endif
#elif defined(__GNUC__)
/* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
#pragma language = extended
#else
#error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct
{
    __I uint32_t VERID; /**< Version ID Register, offset: 0x0 */
    __I uint32_t PARAM; /**< Parameter Register, offset: 0x4 */
    uint8_t RESERVED_0[8];
    __IO uint32_t CTRL;  /**< ADC Control Register, offset: 0x10 */
    __IO uint32_t STAT;  /**< ADC Status Register, offset: 0x14 */
    __IO uint32_t IE;    /**< Interrupt Enable Register, offset: 0x18 */
    __IO uint32_t DE;    /**< DMA Enable Register, offset: 0x1C */
    __IO uint32_t CFG;   /**< ADC Configuration Register, offset: 0x20 */
    __IO uint32_t PAUSE; /**< ADC Pause Register, offset: 0x24 */
    uint8_t RESERVED_1[12];
    __O uint32_t SWTRIG; /**< Software Trigger Register, offset: 0x34 */
    __IO uint32_t TSTAT; /**< Trigger Status Register, offset: 0x38 */
    uint8_t RESERVED_2[4];
    __IO uint32_t OFSTRIM; /**< ADC Offset Trim Register, offset: 0x40 */
    uint8_t RESERVED_3[92];
    __IO uint32_t TCTRL[16]; /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
    __IO uint32_t FCTRL[2];  /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
    uint8_t RESERVED_4[8];
    __I uint32_t GCC[2];  /**< Gain Calibration Control, array offset: 0xF0, array step: 0x4 */
    __IO uint32_t GCR[2]; /**< Gain Calculation Result, array offset: 0xF8, array step: 0x4 */
    struct
    {                       /* offset: 0x100, array step: 0x8 */
        __IO uint32_t CMDL; /**< ADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
        __IO uint32_t CMDH; /**< ADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
    } CMD[15];
    uint8_t RESERVED_5[136];
    __IO uint32_t CV[4]; /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
    uint8_t RESERVED_6[240];
    __I uint32_t RESFIFO[2]; /**< ADC Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
    uint8_t RESERVED_7[248];
    __IO uint32_t CAL_GAR[33]; /**< Calibration General A-Side Registers, array offset: 0x400, array step: 0x4 */
    uint8_t RESERVED_8[124];
    __IO uint32_t CAL_GBR[33]; /**< Calibration General B-Side Registers, array offset: 0x500, array step: 0x4 */
    uint8_t RESERVED_9[2680];
    __IO uint32_t TST; /**< ADC Test Register, offset: 0xFFC */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */
#define ADC_VERID_RES_MASK (0x1U)
#define ADC_VERID_RES_SHIFT (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential/12-bit single ended resolution supported.
 *  0b1..Up to 16-bit differential/16-bit single ended resolution supported.
 */
#define ADC_VERID_RES(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)
#define ADC_VERID_DIFFEN_MASK (0x2U)
#define ADC_VERID_DIFFEN_SHIFT (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported. CMDLa[CTYPE] controls fields implemented.
 */
#define ADC_VERID_DIFFEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)
#define ADC_VERID_MVI_MASK (0x8U)
#define ADC_VERID_MVI_SHIFT (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference high (VREFH) input supported.
 *  0b1..Multiple voltage reference high (VREFH) inputs supported.
 */
#define ADC_VERID_MVI(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)
#define ADC_VERID_CSW_MASK (0x70U)
#define ADC_VERID_CSW_SHIFT (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)
#define ADC_VERID_VR1RNGI_MASK (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)
#define ADC_VERID_IADCKI_MASK (0x200U)
#define ADC_VERID_IADCKI_SHIFT (9U)
/*! IADCKI - Internal ADC Clock implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)
#define ADC_VERID_CALOFSI_MASK (0x400U)
#define ADC_VERID_CALOFSI_SHIFT (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Calibration Not Implemented.
 *  0b1..Calibration Implemented.
 */
#define ADC_VERID_CALOFSI(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)
#define ADC_VERID_NUM_SEC_MASK (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT (11U)
/*! NUM_SEC - Number of Single Ended Outputs Supported
 *  0b0..This design supports one single ended conversion at a time.
 *  0b1..This design supports two simultanious single ended conversions.
 */
#define ADC_VERID_NUM_SEC(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)
#define ADC_VERID_NUM_FIFO_MASK (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..This design supports one result FIFO.
 *  0b010..This design supports two result FIFOs.
 *  0b011..This design supports three result FIFOs.
 *  0b100..This design supports four result FIFOs.
 */
#define ADC_VERID_NUM_FIFO(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)
#define ADC_VERID_MINOR_MASK (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT (16U)
/*! MINOR - Minor Version Number
 */
#define ADC_VERID_MINOR(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)
#define ADC_VERID_MAJOR_MASK (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT (24U)
/*! MAJOR - Major Version Number
 */
#define ADC_VERID_MAJOR(x) (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */
#define ADC_PARAM_TRIG_NUM_MASK (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT (0U)
/*! TRIG_NUM - Trigger Number
 */
#define ADC_PARAM_TRIG_NUM(x) (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)
#define ADC_PARAM_FIFOSIZE_MASK (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 1 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x) (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)
#define ADC_PARAM_CV_NUM_MASK (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT (16U)
/*! CV_NUM - Compare Value Number
 */
#define ADC_PARAM_CV_NUM(x) (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)
#define ADC_PARAM_CMD_NUM_MASK (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT (24U)
/*! CMD_NUM - Command Buffer Number
 */
#define ADC_PARAM_CMD_NUM(x) (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - ADC Control Register */
/*! @{ */
#define ADC_CTRL_ADCEN_MASK (0x1U)
#define ADC_CTRL_ADCEN_SHIFT (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)
#define ADC_CTRL_RST_MASK (0x2U)
#define ADC_CTRL_RST_SHIFT (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)
#define ADC_CTRL_DOZEN_MASK (0x4U)
#define ADC_CTRL_DOZEN_SHIFT (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in Doze mode.
 *  0b1..ADC is disabled in Doze mode.
 */
#define ADC_CTRL_DOZEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)
#define ADC_CTRL_CAL_REQ_MASK (0x8U)
#define ADC_CTRL_CAL_REQ_SHIFT (3U)
/*! CAL_REQ - Auto-Calibration Request
 *  0b0..No request for auto-calibration has been made.
 *  0b1..A request for auto-calibration has been made
 */
#define ADC_CTRL_CAL_REQ(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_REQ_SHIFT)) & ADC_CTRL_CAL_REQ_MASK)
#define ADC_CTRL_CALOFS_MASK (0x10U)
#define ADC_CTRL_CALOFS_SHIFT (4U)
/*! CALOFS - Configure for offset calibration function
 *  0b0..Calibration function disabled
 *  0b1..Request for offset calibration function
 */
#define ADC_CTRL_CALOFS(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALOFS_SHIFT)) & ADC_CTRL_CALOFS_MASK)
#define ADC_CTRL_RSTFIFO0_MASK (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)
#define ADC_CTRL_RSTFIFO1_MASK (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)
#define ADC_CTRL_CAL_AVGS_MASK (0x70000U)
#define ADC_CTRL_CAL_AVGS_SHIFT (16U)
/*! CAL_AVGS - Auto-Calibration Averages
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CTRL_CAL_AVGS(x) (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_AVGS_SHIFT)) & ADC_CTRL_CAL_AVGS_MASK)
/*! @} */

/*! @name STAT - ADC Status Register */
/*! @{ */
#define ADC_STAT_RDY0_MASK (0x1U)
#define ADC_STAT_RDY0_SHIFT (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Result FIFO 0 data level not above watermark level.
 *  0b1..Result FIFO 0 holding data above watermark level.
 */
#define ADC_STAT_RDY0(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)
#define ADC_STAT_FOF0_MASK (0x2U)
#define ADC_STAT_FOF0_SHIFT (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF0(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)
#define ADC_STAT_RDY1_MASK (0x4U)
#define ADC_STAT_RDY1_SHIFT (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Result FIFO1 data level not above watermark level.
 *  0b1..Result FIFO1 holding data above watermark level.
 */
#define ADC_STAT_RDY1(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)
#define ADC_STAT_FOF1_MASK (0x8U)
#define ADC_STAT_FOF1_SHIFT (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF1(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)
#define ADC_STAT_TEXC_INT_MASK (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT (8U)
/*! TEXC_INT - Interrupt Flag For High Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgement.
 */
#define ADC_STAT_TEXC_INT(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)
#define ADC_STAT_TCOMP_INT_MASK (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] is set to 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)
#define ADC_STAT_CAL_RDY_MASK (0x400U)
#define ADC_STAT_CAL_RDY_SHIFT (10U)
/*! CAL_RDY - Calibration Ready
 *  0b0..Calibration is incomplete or hasn't been ran.
 *  0b1..The ADC is calibrated.
 */
#define ADC_STAT_CAL_RDY(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CAL_RDY_SHIFT)) & ADC_STAT_CAL_RDY_MASK)
#define ADC_STAT_ADC_ACTIVE_MASK (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The ADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The ADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)
#define ADC_STAT_TRGACT_MASK (0xF0000U)
#define ADC_STAT_TRGACT_SHIFT (16U)
/*! TRGACT - Trigger Active
 *  0b0000..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b0001..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b0010..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b0011-0b1111..Command (sequence) from the associated Trigger number is currently being executed.
 */
#define ADC_STAT_TRGACT(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)
#define ADC_STAT_CMDACT_MASK (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x) (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */
#define ADC_IE_FWMIE0_MASK (0x1U)
#define ADC_IE_FWMIE0_SHIFT (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..FIFO 0 watermark interrupts are not enabled.
 *  0b1..FIFO 0 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE0(x) (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)
#define ADC_IE_FOFIE0_MASK (0x2U)
#define ADC_IE_FOFIE0_SHIFT (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..FIFO 0 overflow interrupts are not enabled.
 *  0b1..FIFO 0 overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE0(x) (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)
#define ADC_IE_FWMIE1_MASK (0x4U)
#define ADC_IE_FWMIE1_SHIFT (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..FIFO1 watermark interrupts are not enabled.
 *  0b1..FIFO1 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE1(x) (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)
#define ADC_IE_FOFIE1_MASK (0x8U)
#define ADC_IE_FOFIE1_SHIFT (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_IE_FOFIE1(x) (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)
#define ADC_IE_TEXC_IE_MASK (0x100U)
#define ADC_IE_TEXC_IE_SHIFT (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Trigger exception interrupts are disabled.
 *  0b1..Trigger exception interrupts are enabled.
 */
#define ADC_IE_TEXC_IE(x) (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)
#define ADC_IE_TCOMP_IE_MASK (0xFFFF0000U)
#define ADC_IE_TCOMP_IE_SHIFT (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000000000000000..Trigger completion interrupts are disabled.
 *  0b0000000000000001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0000000000000010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0000000000000011-0b1111111111111110..Associated trigger completion interrupts are enabled.
 *  0b1111111111111111..Trigger completion interrupts are enabled for every trigger source.
 */
#define ADC_IE_TCOMP_IE(x) (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */
#define ADC_DE_FWMDE0_MASK (0x1U)
#define ADC_DE_FWMDE0_SHIFT (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE0(x) (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)
#define ADC_DE_FWMDE1_MASK (0x2U)
#define ADC_DE_FWMDE1_SHIFT (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE1(x) (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - ADC Configuration Register */
/*! @{ */
#define ADC_CFG_TPRICTRL_MASK (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT (0U)
/*! TPRICTRL - ADC trigger priority control
 *  0b00..If a higher priority trigger is detected during command processing, the current conversion is aborted
 *        and the new command specified by the trigger is started.
 *  0b01..If a higher priority trigger is received during command processing, the current command is stopped after
 *        after completing the current conversion. If averaging is enabled, the averaging loop will be completed.
 *        However, CMDHa[LOOP] will be ignored and the higher priority trigger will be serviced.
 *  0b10..If a higher priority trigger is received during command processing, the current command will be
 *        completed (averaging, looping, compare) before servicing the higher priority trigger.
 *  0b11..RESERVED
 */
#define ADC_CFG_TPRICTRL(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)
#define ADC_CFG_PWRSEL_MASK (0x30U)
#define ADC_CFG_PWRSEL_SHIFT (4U)
/*! PWRSEL - Power Configuration Select
 *  0b00..Lowest power setting.
 *  0b01..Higher power setting than 0b0.
 *  0b10..Higher power setting than 0b1.
 *  0b11..Highest power setting.
 */
#define ADC_CFG_PWRSEL(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)
#define ADC_CFG_REFSEL_MASK (0xC0U)
#define ADC_CFG_REFSEL_SHIFT (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)
#define ADC_CFG_TRES_MASK (0x100U)
#define ADC_CFG_TRES_SHIFT (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Trigger sequences interrupted by a high priority trigger exception will not be automatically resumed or
 * restarted. 0b1..Trigger sequences interrupted by a high priority trigger exception will be automatically resumed or
 * restarted.
 */
#define ADC_CFG_TRES(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)
#define ADC_CFG_TCMDRES_MASK (0x200U)
#define ADC_CFG_TCMDRES_SHIFT (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequences interrupted by a high priority trigger exception will be automatically restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception will be resumed from the command executing
 * before the exception.
 */
#define ADC_CFG_TCMDRES(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)
#define ADC_CFG_HPT_EXDI_MASK (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT (10U)
/*! HPT_EXDI - High Priority Trigger Exception Disable
 *  0b0..High priority trigger exceptions are enabled.
 *  0b1..High priority trigger exceptions are disabled.
 */
#define ADC_CFG_HPT_EXDI(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)
#define ADC_CFG_PUDLY_MASK (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)
#define ADC_CFG_PWREN_MASK (0x10000000U)
#define ADC_CFG_PWREN_SHIFT (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog
 * startup delays. 0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at
 * the cost of higher DC current consumption). A single power up delay (CFG[PUDLY]) is executed immediately once PWREN
 *       is set, and any detected trigger does not begin ADC operation until the power up delay time has passed.
 *       After this initial delay expires the analog will remain pre-enabled, and no additional delays will be
 *       executed.
 */
#define ADC_CFG_PWREN(x) (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - ADC Pause Register */
/*! @{ */
#define ADC_PAUSE_PAUSEDLY_MASK (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x) (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)
#define ADC_PAUSE_PAUSEEN_MASK (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */
#define ADC_SWTRIG_SWT0_MASK (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)
#define ADC_SWTRIG_SWT1_MASK (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)
#define ADC_SWTRIG_SWT2_MASK (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)
#define ADC_SWTRIG_SWT3_MASK (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
#define ADC_SWTRIG_SWT4_MASK (0x10U)
#define ADC_SWTRIG_SWT4_SHIFT (4U)
/*! SWT4 - Software trigger 4 event
 *  0b0..No trigger 4 event generated.
 *  0b1..Trigger 4 event generated.
 */
#define ADC_SWTRIG_SWT4(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT4_SHIFT)) & ADC_SWTRIG_SWT4_MASK)
#define ADC_SWTRIG_SWT5_MASK (0x20U)
#define ADC_SWTRIG_SWT5_SHIFT (5U)
/*! SWT5 - Software trigger 5 event
 *  0b0..No trigger 5 event generated.
 *  0b1..Trigger 5 event generated.
 */
#define ADC_SWTRIG_SWT5(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT5_SHIFT)) & ADC_SWTRIG_SWT5_MASK)
#define ADC_SWTRIG_SWT6_MASK (0x40U)
#define ADC_SWTRIG_SWT6_SHIFT (6U)
/*! SWT6 - Software trigger 6 event
 *  0b0..No trigger 6 event generated.
 *  0b1..Trigger 6 event generated.
 */
#define ADC_SWTRIG_SWT6(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT6_SHIFT)) & ADC_SWTRIG_SWT6_MASK)
#define ADC_SWTRIG_SWT7_MASK (0x80U)
#define ADC_SWTRIG_SWT7_SHIFT (7U)
/*! SWT7 - Software trigger 7 event
 *  0b0..No trigger 7 event generated.
 *  0b1..Trigger 7 event generated.
 */
#define ADC_SWTRIG_SWT7(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT7_SHIFT)) & ADC_SWTRIG_SWT7_MASK)
#define ADC_SWTRIG_SWT8_MASK (0x100U)
#define ADC_SWTRIG_SWT8_SHIFT (8U)
/*! SWT8 - Software trigger 8 event
 *  0b0..No trigger 8 event generated.
 *  0b1..Trigger 8 event generated.
 */
#define ADC_SWTRIG_SWT8(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT8_SHIFT)) & ADC_SWTRIG_SWT8_MASK)
#define ADC_SWTRIG_SWT9_MASK (0x200U)
#define ADC_SWTRIG_SWT9_SHIFT (9U)
/*! SWT9 - Software trigger 9 event
 *  0b0..No trigger 9 event generated.
 *  0b1..Trigger 9 event generated.
 */
#define ADC_SWTRIG_SWT9(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT9_SHIFT)) & ADC_SWTRIG_SWT9_MASK)
#define ADC_SWTRIG_SWT10_MASK (0x400U)
#define ADC_SWTRIG_SWT10_SHIFT (10U)
/*! SWT10 - Software trigger 10 event
 *  0b0..No trigger 10 event generated.
 *  0b1..Trigger 10 event generated.
 */
#define ADC_SWTRIG_SWT10(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT10_SHIFT)) & ADC_SWTRIG_SWT10_MASK)
#define ADC_SWTRIG_SWT11_MASK (0x800U)
#define ADC_SWTRIG_SWT11_SHIFT (11U)
/*! SWT11 - Software trigger 11 event
 *  0b0..No trigger 11 event generated.
 *  0b1..Trigger 11 event generated.
 */
#define ADC_SWTRIG_SWT11(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT11_SHIFT)) & ADC_SWTRIG_SWT11_MASK)
#define ADC_SWTRIG_SWT12_MASK (0x1000U)
#define ADC_SWTRIG_SWT12_SHIFT (12U)
/*! SWT12 - Software trigger 12 event
 *  0b0..No trigger 12 event generated.
 *  0b1..Trigger 12 event generated.
 */
#define ADC_SWTRIG_SWT12(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT12_SHIFT)) & ADC_SWTRIG_SWT12_MASK)
#define ADC_SWTRIG_SWT13_MASK (0x2000U)
#define ADC_SWTRIG_SWT13_SHIFT (13U)
/*! SWT13 - Software trigger 13 event
 *  0b0..No trigger 13 event generated.
 *  0b1..Trigger 13 event generated.
 */
#define ADC_SWTRIG_SWT13(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT13_SHIFT)) & ADC_SWTRIG_SWT13_MASK)
#define ADC_SWTRIG_SWT14_MASK (0x4000U)
#define ADC_SWTRIG_SWT14_SHIFT (14U)
/*! SWT14 - Software trigger 14 event
 *  0b0..No trigger 14 event generated.
 *  0b1..Trigger 14 event generated.
 */
#define ADC_SWTRIG_SWT14(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT14_SHIFT)) & ADC_SWTRIG_SWT14_MASK)
#define ADC_SWTRIG_SWT15_MASK (0x8000U)
#define ADC_SWTRIG_SWT15_SHIFT (15U)
/*! SWT15 - Software trigger 15 event
 *  0b0..No trigger 15 event generated.
 *  0b1..Trigger 15 event generated.
 */
#define ADC_SWTRIG_SWT15(x) (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT15_SHIFT)) & ADC_SWTRIG_SWT15_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */
#define ADC_TSTAT_TEXC_NUM_MASK (0xFFFFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000000000000000..No triggers have been interrupted by a high priority exception. Or CFG[TRES] = 1.
 *  0b0000000000000001..Trigger 0 has been interrupted by a high priority exception.
 *  0b0000000000000010..Trigger 1 has been interrupted by a high priority exception.
 *  0b0000000000000011-0b1111111111111110..Associated trigger sequence has interrupted by a high priority exception.
 *  0b1111111111111111..Every trigger sequence has been interrupted by a high priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x) (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)
#define ADC_TSTAT_TCOMP_FLAG_MASK (0xFFFF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000000000000000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0000000000000001..Trigger 0 has been completed and triger 0 has enabled completion interrupts.
 *  0b0000000000000010..Trigger 1 has been completed and triger 1 has enabled completion interrupts.
 *  0b0000000000000011-0b1111111111111110..Associated trigger sequence has completed and has enabled completion
 * interrupts. 0b1111111111111111..Every trigger sequence has been completed and every trigger has enabled completion
 * interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name OFSTRIM - ADC Offset Trim Register */
/*! @{ */
#define ADC_OFSTRIM_OFSTRIM_A_MASK (0x1FU)
#define ADC_OFSTRIM_OFSTRIM_A_SHIFT (0U)
/*! OFSTRIM_A - Trim for offset
 */
#define ADC_OFSTRIM_OFSTRIM_A(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_A_SHIFT)) & ADC_OFSTRIM_OFSTRIM_A_MASK)
#define ADC_OFSTRIM_OFSTRIM_B_MASK (0x1F0000U)
#define ADC_OFSTRIM_OFSTRIM_B_SHIFT (16U)
/*! OFSTRIM_B - Trim for offset
 */
#define ADC_OFSTRIM_OFSTRIM_B(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_B_SHIFT)) & ADC_OFSTRIM_OFSTRIM_B_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */
#define ADC_TCTRL_HTEN_MASK (0x1U)
#define ADC_TCTRL_HTEN_SHIFT (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)
#define ADC_TCTRL_FIFO_SEL_A_MASK (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT (1U)
/*! FIFO_SEL_A - SAR Result Destination For Channel A
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)
#define ADC_TCTRL_FIFO_SEL_B_MASK (0x4U)
#define ADC_TCTRL_FIFO_SEL_B_SHIFT (2U)
/*! FIFO_SEL_B - SAR Result Destination For Channel B
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_B(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_B_SHIFT)) & ADC_TCTRL_FIFO_SEL_B_MASK)
#define ADC_TCTRL_TPRI_MASK (0xF00U)
#define ADC_TCTRL_TPRI_SHIFT (8U)
/*! TPRI - Trigger priority setting
 *  0b0000..Set to highest priority, Level 1
 *  0b0001-0b1110..Set to corresponding priority level
 *  0b1111..Set to lowest priority, Level 16
 */
#define ADC_TCTRL_TPRI(x) (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)
#define ADC_TCTRL_RSYNC_MASK (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT (15U)
/*! RSYNC - Trigger Resync
 */
#define ADC_TCTRL_RSYNC(x) (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)
#define ADC_TCTRL_TDLY_MASK (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x) (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)
#define ADC_TCTRL_TCMD_MASK (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x) (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT (16U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */
#define ADC_FCTRL_FCOUNT_MASK (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT (0U)
/*! FCOUNT - Result FIFO counter
 */
#define ADC_FCTRL_FCOUNT(x) (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)
#define ADC_FCTRL_FWMARK_MASK (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT (16U)
/*! FWMARK - Watermark level selection
 */
#define ADC_FCTRL_FWMARK(x) (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT (2U)

/*! @name GCC - Gain Calibration Control */
/*! @{ */
#define ADC_GCC_GAIN_CAL_MASK (0xFFFFU)
#define ADC_GCC_GAIN_CAL_SHIFT (0U)
/*! GAIN_CAL - Gain Calibration Value
 */
#define ADC_GCC_GAIN_CAL(x) (((uint32_t)(((uint32_t)(x)) << ADC_GCC_GAIN_CAL_SHIFT)) & ADC_GCC_GAIN_CAL_MASK)
#define ADC_GCC_RDY_MASK (0x1000000U)
#define ADC_GCC_RDY_SHIFT (24U)
/*! RDY - Gain Calibration Value Valid
 *  0b0..The gain calibration value is invalid. Run the auto-calibration routine for this value to be written.
 *  0b1..The gain calibration value is valid. It should be used to update the GCRa[GCALR] register field.
 */
#define ADC_GCC_RDY(x) (((uint32_t)(((uint32_t)(x)) << ADC_GCC_RDY_SHIFT)) & ADC_GCC_RDY_MASK)
/*! @} */

/* The count of ADC_GCC */
#define ADC_GCC_COUNT (2U)

/*! @name GCR - Gain Calculation Result */
/*! @{ */
#define ADC_GCR_GCALR_MASK (0xFFFFU)
#define ADC_GCR_GCALR_SHIFT (0U)
/*! GCALR - Gain Calculation Result
 */
#define ADC_GCR_GCALR(x) (((uint32_t)(((uint32_t)(x)) << ADC_GCR_GCALR_SHIFT)) & ADC_GCR_GCALR_MASK)
#define ADC_GCR_RDY_MASK (0x1000000U)
#define ADC_GCR_RDY_SHIFT (24U)
/*! RDY - Gain Calculation Ready
 *  0b0..The gain offset calculation value is invalid.
 *  0b1..The gain calibration value is valid.
 */
#define ADC_GCR_RDY(x) (((uint32_t)(((uint32_t)(x)) << ADC_GCR_RDY_SHIFT)) & ADC_GCR_RDY_MASK)
/*! @} */

/* The count of ADC_GCR */
#define ADC_GCR_COUNT (2U)

/*! @name CMDL - ADC Command Low Buffer Register */
/*! @{ */
#define ADC_CMDL_ADCH_MASK (0x1FU)
#define ADC_CMDL_ADCH_SHIFT (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)
#define ADC_CMDL_CTYPE_MASK (0x60U)
#define ADC_CMDL_CTYPE_SHIFT (5U)
/*! CTYPE - Conversion Type
 *  0b00..Single-Ended Mode. Only A side channel is converted.
 *  0b01..Single-Ended Mode. Only B side channel is converted.
 *  0b10..Differential Mode. A-B.
 *  0b11..Dual-Single-Ended Mode. Both A side and B side channels are converted independently.
 */
#define ADC_CMDL_CTYPE(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CTYPE_SHIFT)) & ADC_CMDL_CTYPE_MASK)
#define ADC_CMDL_MODE_MASK (0x80U)
#define ADC_CMDL_MODE_SHIFT (7U)
/*! MODE - Select resolution of conversions
 *  0b0..Standard resolution. Single-ended 12-bit conversion; Differential 13-bit conversion with 2's complement output.
 *  0b1..High resolution. Single-ended 16-bit conversion; Differential 16-bit conversion with 2's complement output.
 */
#define ADC_CMDL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_MODE_SHIFT)) & ADC_CMDL_MODE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT (15U)

/*! @name CMDH - ADC Command High Buffer Register */
/*! @{ */
#define ADC_CMDH_CMPEN_MASK (0x3U)
#define ADC_CMDH_CMPEN_SHIFT (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)
#define ADC_CMDH_WAIT_TRIG_MASK (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT (2U)
/*! WAIT_TRIG - Wait for trigger assertion before execution.
 *  0b0..This command will be automatically executed.
 *  0b1..The active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)
#define ADC_CMDH_LWI_MASK (0x80U)
#define ADC_CMDH_LWI_SHIFT (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)
#define ADC_CMDH_STS_MASK (0x700U)
#define ADC_CMDH_STS_SHIFT (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3 ADCK cycles.
 *  0b001..3 + 21 ADCK cycles; 5 ADCK cycles total sample time.
 *  0b010..3 + 22 ADCK cycles; 7 ADCK cycles total sample time.
 *  0b011..3 + 23 ADCK cycles; 11 ADCK cycles total sample time.
 *  0b100..3 + 24 ADCK cycles; 19 ADCK cycles total sample time.
 *  0b101..3 + 25 ADCK cycles; 35 ADCK cycles total sample time.
 *  0b110..3 + 26 ADCK cycles; 67 ADCK cycles total sample time.
 *  0b111..3 + 27 ADCK cycles; 131 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)
#define ADC_CMDH_AVGS_MASK (0x7000U)
#define ADC_CMDH_AVGS_SHIFT (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)
#define ADC_CMDH_LOOP_MASK (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)
#define ADC_CMDH_NEXT_MASK (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x) (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT (15U)

/*! @name CV - Compare Value Register */
/*! @{ */
#define ADC_CV_CVL_MASK (0xFFFFU)
#define ADC_CV_CVL_SHIFT (0U)
/*! CVL - Compare Value Low.
 */
#define ADC_CV_CVL(x) (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)
#define ADC_CV_CVH_MASK (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x) (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT (4U)

/*! @name RESFIFO - ADC Data Result FIFO Register */
/*! @{ */
#define ADC_RESFIFO_D_MASK (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x) (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)
#define ADC_RESFIFO_TSRC_MASK (0xF0000U)
#define ADC_RESFIFO_TSRC_SHIFT (16U)
/*! TSRC - Trigger Source
 *  0b0000..Trigger source 0 initiated this conversion.
 *  0b0001..Trigger source 1 initiated this conversion.
 *  0b0010-0b1110..Corresponding trigger source initiated this conversion.
 *  0b1111..Trigger source 15 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x) (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)
#define ADC_RESFIFO_LOOPCNT_MASK (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x) (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)
#define ADC_RESFIFO_CMDSRC_MASK (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x) (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)
#define ADC_RESFIFO_VALID_MASK (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x) (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT (2U)

/*! @name CAL_GAR - Calibration General A-Side Registers */
/*! @{ */
#define ADC_CAL_GAR_CAL_GAR_VAL_MASK (0xFFFFU)
#define ADC_CAL_GAR_CAL_GAR_VAL_SHIFT (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR_CAL_GAR_VAL(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR_CAL_GAR_VAL_MASK)
/*! @} */

/* The count of ADC_CAL_GAR */
#define ADC_CAL_GAR_COUNT (33U)

/*! @name CAL_GBR - Calibration General B-Side Registers */
/*! @{ */
#define ADC_CAL_GBR_CAL_GBR_VAL_MASK (0xFFFFU)
#define ADC_CAL_GBR_CAL_GBR_VAL_SHIFT (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR_CAL_GBR_VAL(x) \
    (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR_CAL_GBR_VAL_MASK)
/*! @} */

/* The count of ADC_CAL_GBR */
#define ADC_CAL_GBR_COUNT (33U)

/*! @name TST - ADC Test Register */
/*! @{ */
#define ADC_TST_CST_LONG_MASK (0x1U)
#define ADC_TST_CST_LONG_SHIFT (0U)
/*! CST_LONG - Calibration Sample Time Long
 *  0b0..Normal sample time. Minimum sample time of 3 ADCK cycles.
 *  0b1..Increased sample time. 67 ADCK cycles total sample time.
 */
#define ADC_TST_CST_LONG(x) (((uint32_t)(((uint32_t)(x)) << ADC_TST_CST_LONG_SHIFT)) & ADC_TST_CST_LONG_MASK)
#define ADC_TST_FOFFM_MASK (0x100U)
#define ADC_TST_FOFFM_SHIFT (8U)
/*! FOFFM - Force M-side positive offset
 *  0b0..Normal operation. No forced offset.
 *  0b1..Test configuration. Forced positive offset on MDAC.
 */
#define ADC_TST_FOFFM(x) (((uint32_t)(((uint32_t)(x)) << ADC_TST_FOFFM_SHIFT)) & ADC_TST_FOFFM_MASK)
#define ADC_TST_FOFFP_MASK (0x200U)
#define ADC_TST_FOFFP_SHIFT (9U)
/*! FOFFP - Force P-side positive offset
 *  0b0..Normal operation. No forced offset.
 *  0b1..Test configuration. Forced positive offset on PDAC.
 */
#define ADC_TST_FOFFP(x) (((uint32_t)(((uint32_t)(x)) << ADC_TST_FOFFP_SHIFT)) & ADC_TST_FOFFP_MASK)
#define ADC_TST_FOFFM2_MASK (0x400U)
#define ADC_TST_FOFFM2_SHIFT (10U)
/*! FOFFM2 - Force M-side negative offset
 *  0b0..Normal operation. No forced offset.
 *  0b1..Test configuration. Forced negative offset on MDAC.
 */
#define ADC_TST_FOFFM2(x) (((uint32_t)(((uint32_t)(x)) << ADC_TST_FOFFM2_SHIFT)) & ADC_TST_FOFFM2_MASK)
#define ADC_TST_FOFFP2_MASK (0x800U)
#define ADC_TST_FOFFP2_SHIFT (11U)
/*! FOFFP2 - Force P-side negative offset
 *  0b0..Normal operation. No forced offset.
 *  0b1..Test configuration. Forced negative offset on PDAC.
 */
#define ADC_TST_FOFFP2(x) (((uint32_t)(((uint32_t)(x)) << ADC_TST_FOFFP2_SHIFT)) & ADC_TST_FOFFP2_MASK)
#define ADC_TST_TESTEN_MASK (0x800000U)
#define ADC_TST_TESTEN_SHIFT (23U)
/*! TESTEN - Enable test configuration
 *  0b0..Normal operation. Test configuration not enabled.
 *  0b1..Hardware BIST Test in progress.
 */
#define ADC_TST_TESTEN(x) (((uint32_t)(((uint32_t)(x)) << ADC_TST_TESTEN_SHIFT)) & ADC_TST_TESTEN_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group ADC_Register_Masks */

/* ADC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral ADC0 base address */
#define ADC0_BASE (0x500A0000u)
/** Peripheral ADC0 base address */
#define ADC0_BASE_NS (0x400A0000u)
/** Peripheral ADC0 base pointer */
#define ADC0 ((ADC_Type *)ADC0_BASE)
/** Peripheral ADC0 base pointer */
#define ADC0_NS ((ADC_Type *)ADC0_BASE_NS)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS \
    {                  \
        ADC0_BASE      \
    }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS \
    {                 \
        ADC0          \
    }
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS_NS \
    {                     \
        ADC0_BASE_NS      \
    }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS_NS \
    {                    \
        ADC0_NS          \
    }
#else
/** Peripheral ADC0 base address */
#define ADC0_BASE (0x400A0000u)
/** Peripheral ADC0 base pointer */
#define ADC0 ((ADC_Type *)ADC0_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS \
    {                  \
        ADC0_BASE      \
    }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS \
    {                 \
        ADC0          \
    }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS  \
    {             \
        ADC0_IRQn \
    }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- AHB_SECURE_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHB_SECURE_CTRL_Peripheral_Access_Layer AHB_SECURE_CTRL Peripheral Access Layer
 * @{
 */

/** AHB_SECURE_CTRL - Register Layout Typedef */
typedef struct
{
    struct
    { /* offset: 0x0, array step: 0x30 */
        __IO uint32_t
            SLAVE_RULE; /**< Security access rules for Flash and ROM slaves., array offset: 0x0, array step: 0x30 */
        uint8_t RESERVED_0[12];
        __IO uint32_t SEC_CTRL_FLASH_MEM_RULE[3]; /**< Security access rules for FLASH sector 0 to sector 20. Each Flash
                                                     sector is 32 Kbytes. There are 20 FLASH sectors in total., array
                                                     offset: 0x10, array step: index*0x30, index2*0x4 */
        uint8_t RESERVED_1[4];
        __IO uint32_t SEC_CTRL_ROM_MEM_RULE[4]; /**< Security access rules for ROM sector 0 to sector 31. Each ROM
                                                   sector is 4 Kbytes. There are 32 ROM sectors in total., array offset:
                                                   0x20, array step: index*0x30, index2*0x4 */
    } SEC_CTRL_FLASH_ROM[1];
    struct
    {                             /* offset: 0x30, array step: 0x14 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for RAMX slaves., array offset: 0x30, array step: 0x14 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[1]; /**< Security access rules for RAMX slaves., array offset: 0x40, array step:
                                      index*0x14, index2*0x4 */
    } SEC_CTRL_RAMX[1];
    uint8_t RESERVED_0[12];
    struct
    {                             /* offset: 0x50, array step: 0x18 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for RAM0 slaves., array offset: 0x50, array step: 0x18 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[2]; /**< Security access rules for RAM0 slaves., array offset: 0x60, array step:
                                      index*0x18, index2*0x4 */
    } SEC_CTRL_RAM0[1];
    uint8_t RESERVED_1[8];
    struct
    {                             /* offset: 0x70, array step: 0x18 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for RAM1 slaves., array offset: 0x70, array step: 0x18 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[2]; /**< Security access rules for RAM1 slaves., array offset: 0x80, array step:
                                      index*0x18, index2*0x4 */
    } SEC_CTRL_RAM1[1];
    uint8_t RESERVED_2[8];
    struct
    {                             /* offset: 0x90, array step: 0x18 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for RAM2 slaves., array offset: 0x90, array step: 0x18 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[2]; /**< Security access rules for RAM2 slaves., array offset: 0xA0, array step:
                                      index*0x18, index2*0x4 */
    } SEC_CTRL_RAM2[1];
    uint8_t RESERVED_3[8];
    struct
    {                             /* offset: 0xB0, array step: 0x18 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for RAM3 slaves., array offset: 0xB0, array step: 0x18 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[2]; /**< Security access rules for RAM3 slaves., array offset: 0xC0, array step:
                                      index*0x18, index2*0x4 */
    } SEC_CTRL_RAM3[1];
    uint8_t RESERVED_4[8];
    struct
    {                             /* offset: 0xD0, array step: 0x14 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for RAM4 slaves., array offset: 0xD0, array step: 0x14 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[1]; /**< Security access rules for RAM4 slaves., array offset: 0xE0, array step:
                                      index*0x14, index2*0x4 */
    } SEC_CTRL_RAM4[1];
    uint8_t RESERVED_5[12];
    struct
    { /* offset: 0xF0, array step: 0x30 */
        __IO uint32_t
            SLAVE_RULE; /**< Security access rules for both APB Bridges slaves., array offset: 0xF0, array step: 0x30 */
        uint8_t RESERVED_0[12];
        __IO uint32_t SEC_CTRL_APB_BRIDGE0_MEM_CTRL0; /**< Security access rules for APB Bridge 0 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 0 sectors in
                                                         total., array offset: 0x100, array step: 0x30 */
        __IO uint32_t SEC_CTRL_APB_BRIDGE0_MEM_CTRL1; /**< Security access rules for APB Bridge 0 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 0 sectors in
                                                         total., array offset: 0x104, array step: 0x30 */
        __IO uint32_t SEC_CTRL_APB_BRIDGE0_MEM_CTRL2; /**< Security access rules for APB Bridge 0 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 0 sectors in
                                                         total., array offset: 0x108, array step: 0x30 */
        uint8_t RESERVED_1[4];
        __IO uint32_t SEC_CTRL_APB_BRIDGE1_MEM_CTRL0; /**< Security access rules for APB Bridge 1 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 1 sectors in
                                                         total., array offset: 0x110, array step: 0x30 */
        __IO uint32_t SEC_CTRL_APB_BRIDGE1_MEM_CTRL1; /**< Security access rules for APB Bridge 1 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 1 sectors in
                                                         total., array offset: 0x114, array step: 0x30 */
        __IO uint32_t SEC_CTRL_APB_BRIDGE1_MEM_CTRL2; /**< Security access rules for APB Bridge 1 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 1 sectors in
                                                         total., array offset: 0x118, array step: 0x30 */
        __IO uint32_t SEC_CTRL_APB_BRIDGE1_MEM_CTRL3; /**< Security access rules for APB Bridge 1 peripherals. Each APB
                                                         bridge sector is 4 Kbytes. There are 32 APB Bridge 1 sectors in
                                                         total., array offset: 0x11C, array step: 0x30 */
    } SEC_CTRL_APB_BRIDGE[1];
    __IO uint32_t SEC_CTRL_AHB_PORT8_SLAVE0_RULE; /**< Security access rules for AHB peripherals., offset: 0x120 */
    __IO uint32_t SEC_CTRL_AHB_PORT8_SLAVE1_RULE; /**< Security access rules for AHB peripherals., offset: 0x124 */
    uint8_t RESERVED_6[8];
    __IO uint32_t SEC_CTRL_AHB_PORT9_SLAVE0_RULE; /**< Security access rules for AHB peripherals., offset: 0x130 */
    __IO uint32_t SEC_CTRL_AHB_PORT9_SLAVE1_RULE; /**< Security access rules for AHB peripherals., offset: 0x134 */
    uint8_t RESERVED_7[8];
    struct
    { /* offset: 0x140, array step: 0x14 */
        __IO uint32_t
            SLAVE0_RULE; /**< Security access rules for AHB peripherals., array offset: 0x140, array step: 0x14 */
        __IO uint32_t
            SLAVE1_RULE; /**< Security access rules for AHB peripherals., array offset: 0x144, array step: 0x14 */
        uint8_t RESERVED_0[8];
        __IO uint32_t SEC_CTRL_AHB_SEC_CTRL_MEM_RULE[1]; /**< Security access rules for AHB_SEC_CTRL_AHB., array offset:
                                                            0x150, array step: index*0x14, index2*0x4 */
    } SEC_CTRL_AHB_PORT10[1];
    uint8_t RESERVED_8[12];
    struct
    {                             /* offset: 0x160, array step: 0x14 */
        __IO uint32_t SLAVE_RULE; /**< Security access rules for USB High speed RAM slaves., array offset: 0x160, array
                                     step: 0x14 */
        uint8_t RESERVED_0[12];
        __IO uint32_t MEM_RULE[1]; /**< Security access rules for RAM_USB_HS., array offset: 0x170, array step:
                                      index*0x14, index2*0x4 */
    } SEC_CTRL_USB_HS[1];
    uint8_t RESERVED_9[3212];
    __I uint32_t SEC_VIO_ADDR[12]; /**< most recent security violation address for AHB port n, array offset: 0xE00,
                                      array step: 0x4 */
    uint8_t RESERVED_10[80];
    __I uint32_t SEC_VIO_MISC_INFO[12]; /**< most recent security violation miscellaneous information for AHB port n,
                                           array offset: 0xE80, array step: 0x4 */
    uint8_t RESERVED_11[80];
    __IO uint32_t
        SEC_VIO_INFO_VALID; /**< security violation address/information registers valid flags, offset: 0xF00 */
    uint8_t RESERVED_12[124];
    __IO uint32_t SEC_GPIO_MASK0; /**< Secure GPIO mask for port 0 pins., offset: 0xF80 */
    __IO uint32_t SEC_GPIO_MASK1; /**< Secure GPIO mask for port 1 pins., offset: 0xF84 */
    uint8_t RESERVED_13[8];
    __IO uint32_t SEC_CPU_INT_MASK0; /**< Secure Interrupt mask for CPU1, offset: 0xF90 */
    __IO uint32_t SEC_CPU_INT_MASK1; /**< Secure Interrupt mask for CPU1, offset: 0xF94 */
    uint8_t RESERVED_14[36];
    __IO uint32_t SEC_MASK_LOCK; /**< Security General Purpose register access control., offset: 0xFBC */
    uint8_t RESERVED_15[16];
    __IO uint32_t MASTER_SEC_LEVEL;        /**< master secure level register, offset: 0xFD0 */
    __IO uint32_t MASTER_SEC_ANTI_POL_REG; /**< master secure level anti-pole register, offset: 0xFD4 */
    uint8_t RESERVED_16[20];
    __IO uint32_t CPU0_LOCK_REG; /**< Miscalleneous control signals for in Cortex M33 (CPU0), offset: 0xFEC */
    __IO uint32_t CPU1_LOCK_REG; /**< Miscalleneous control signals for in micro-Cortex M33 (CPU1), offset: 0xFF0 */
    uint8_t RESERVED_17[4];
    __IO uint32_t MISC_CTRL_DP_REG; /**< secure control duplicate register, offset: 0xFF8 */
    __IO uint32_t MISC_CTRL_REG;    /**< secure control register, offset: 0xFFC */
} AHB_SECURE_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- AHB_SECURE_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHB_SECURE_CTRL_Register_Masks AHB_SECURE_CTRL Register Masks
 * @{
 */

/*! @name SEC_CTRL_FLASH_ROM_SLAVE_RULE - Security access rules for Flash and ROM slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_FLASH_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_FLASH_RULE_SHIFT (0U)
/*! FLASH_RULE - Security access rules for the whole FLASH : 0x0000_0000 - 0x0009_FFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_FLASH_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_FLASH_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_FLASH_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_ROM_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_ROM_RULE_SHIFT (4U)
/*! ROM_RULE - Security access rules for the whole ROM : 0x0300_0000 - 0x0301_FFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_ROM_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_ROM_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_ROM_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_ROM_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_FLASH_MEM_RULE - Security access rules for FLASH sector 0 to sector 20. Each Flash sector is 32
 * Kbytes. There are 20 FLASH sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_FLASH_MEM_RULE_COUNT2 (3U)

/*! @name SEC_CTRL_ROM_MEM_RULE - Security access rules for ROM sector 0 to sector 31. Each ROM sector is 4 Kbytes.
 * There are 32 ROM sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_ROM_MEM_RULE_COUNT2 (4U)

/*! @name SEC_CTRL_RAMX_SLAVE_RULE - Security access rules for RAMX slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE_RAMX_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE_RAMX_RULE_SHIFT (0U)
/*! RAMX_RULE - Security access rules for the whole RAMX : 0x0400_0000 - 0x0400_7FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE_RAMX_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE_RAMX_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE_RAMX_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_RAMX_MEM_RULE - Security access rules for RAMX slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAMX_MEM_RULE_COUNT2 (1U)

/*! @name SEC_CTRL_RAM0_SLAVE_RULE - Security access rules for RAM0 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE_RAM0_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE_RAM0_RULE_SHIFT (0U)
/*! RAM0_RULE - Security access rules for the whole RAM0 : 0x2000_0000 - 0x2000_FFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE_RAM0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE_RAM0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE_RAM0_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_RAM0_MEM_RULE - Security access rules for RAM0 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM0_MEM_RULE_COUNT2 (2U)

/*! @name SEC_CTRL_RAM1_SLAVE_RULE - Security access rules for RAM1 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE_RAM1_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE_RAM1_RULE_SHIFT (0U)
/*! RAM1_RULE - Security access rules for the whole RAM1 : 0x2001_0000 - 0x2001_FFFF" name="0
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE_RAM1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE_RAM1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE_RAM1_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_RAM1_MEM_RULE - Security access rules for RAM1 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM1_MEM_RULE_COUNT2 (2U)

/*! @name SEC_CTRL_RAM2_SLAVE_RULE - Security access rules for RAM2 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE_RAM2_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE_RAM2_RULE_SHIFT (0U)
/*! RAM2_RULE - Security access rules for the whole RAM2 : 0x2002_0000 - 0x2002_FFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE_RAM2_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE_RAM2_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE_RAM2_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_RAM2_MEM_RULE - Security access rules for RAM2 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM2_MEM_RULE_COUNT2 (2U)

/*! @name SEC_CTRL_RAM3_SLAVE_RULE - Security access rules for RAM3 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE_RAM3_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE_RAM3_RULE_SHIFT (0U)
/*! RAM3_RULE - Security access rules for the whole RAM3: 0x2003_0000 - 0x2003_FFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE_RAM3_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE_RAM3_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE_RAM3_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_RAM3_MEM_RULE - Security access rules for RAM3 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - secure control rule4. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - secure control rule5. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - secure control rule6. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - secure control rule7. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM3_MEM_RULE_COUNT2 (2U)

/*! @name SEC_CTRL_RAM4_SLAVE_RULE - Security access rules for RAM4 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE_RAM4_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE_RAM4_RULE_SHIFT (0U)
/*! RAM4_RULE - Security access rules for the whole RAM4 : 0x2004_0000 - 0x2004_3FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE_RAM4_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE_RAM4_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE_RAM4_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_RAM4_MEM_RULE - Security access rules for RAM4 slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - secure control rule0. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - secure control rule1. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - secure control rule2. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - secure control rule3. it can be set when check_reg's write_lock is '0'
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_RULE3_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_RAM4_MEM_RULE_COUNT2 (1U)

/*! @name SEC_CTRL_APB_BRIDGE_SLAVE_RULE - Security access rules for both APB Bridges slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE0_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE0_RULE_SHIFT (0U)
/*! APBBRIDGE0_RULE - Security access rules for the whole APB Bridge 0
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE1_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE1_RULE_SHIFT (4U)
/*! APBBRIDGE1_RULE - Security access rules for the whole APB Bridge 1
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_APBBRIDGE1_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE0_MEM_CTRL0 - Security access rules for APB Bridge 0 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 0 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SYSCON_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SYSCON_RULE_SHIFT (0U)
/*! SYSCON_RULE - System Configuration
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SYSCON_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SYSCON_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SYSCON_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_IOCON_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_IOCON_RULE_SHIFT (4U)
/*! IOCON_RULE - I/O Configuration
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_IOCON_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_IOCON_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_IOCON_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT0_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT0_RULE_SHIFT (8U)
/*! GINT0_RULE - GPIO input Interrupt 0
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT1_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT1_RULE_SHIFT (12U)
/*! GINT1_RULE - GPIO input Interrupt 1
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_GINT1_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_PINT_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_PINT_RULE_SHIFT (16U)
/*! PINT_RULE - Pin Interrupt and Pattern match
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_PINT_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_PINT_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_PINT_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SEC_PINT_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SEC_PINT_RULE_SHIFT (20U)
/*! SEC_PINT_RULE - Secure Pin Interrupt and Pattern match
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SEC_PINT_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SEC_PINT_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_SEC_PINT_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_INPUTMUX_RULE_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_INPUTMUX_RULE_SHIFT (24U)
/*! INPUTMUX_RULE - Peripheral input multiplexing
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_INPUTMUX_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_INPUTMUX_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_INPUTMUX_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL0_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE0_MEM_CTRL1 - Security access rules for APB Bridge 0 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 0 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER0_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER0_RULE_SHIFT (0U)
/*! CTIMER0_RULE - Standard counter/Timer 0
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER1_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER1_RULE_SHIFT (4U)
/*! CTIMER1_RULE - Standard counter/Timer 1
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_CTIMER1_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_WWDT_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_WWDT_RULE_SHIFT (16U)
/*! WWDT_RULE - Windiwed wtachdog Timer
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_WWDT_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_WWDT_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_WWDT_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_MRT_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_MRT_RULE_SHIFT (20U)
/*! MRT_RULE - Multi-rate Timer
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_MRT_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_MRT_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_MRT_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_UTICK_RULE_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_UTICK_RULE_SHIFT (24U)
/*! UTICK_RULE - Micro-Timer
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_UTICK_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_UTICK_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_UTICK_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL1_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE0_MEM_CTRL2 - Security access rules for APB Bridge 0 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 0 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2_ANACTRL_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2_ANACTRL_RULE_SHIFT (12U)
/*! ANACTRL_RULE - Analog Modules controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2_ANACTRL_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2_ANACTRL_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2_ANACTRL_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE0_MEM_CTRL2_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE1_MEM_CTRL0 - Security access rules for APB Bridge 1 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 1 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_PMC_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_PMC_RULE_SHIFT (0U)
/*! PMC_RULE - Power Management Controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_PMC_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_PMC_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_PMC_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_SYSCTRL_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_SYSCTRL_RULE_SHIFT (12U)
/*! SYSCTRL_RULE - System Controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_SYSCTRL_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_SYSCTRL_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_SYSCTRL_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL0_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE1_MEM_CTRL1 - Security access rules for APB Bridge 1 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 1 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER2_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER2_RULE_SHIFT (0U)
/*! CTIMER2_RULE - Standard counter/Timer 2
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER2_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER2_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER2_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER3_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER3_RULE_SHIFT (4U)
/*! CTIMER3_RULE - Standard counter/Timer 3
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER3_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER3_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER3_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER4_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER4_RULE_SHIFT (8U)
/*! CTIMER4_RULE - Standard counter/Timer 4
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER4_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER4_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_CTIMER4_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_RTC_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_RTC_RULE_SHIFT (16U)
/*! RTC_RULE - Real Time Counter
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_RTC_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_RTC_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_RTC_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_OSEVENT_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_OSEVENT_RULE_SHIFT (20U)
/*! OSEVENT_RULE - OS Event Timer
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_OSEVENT_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_OSEVENT_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_OSEVENT_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL1_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE1_MEM_CTRL2 - Security access rules for APB Bridge 1 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 1 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_FLASH_CTRL_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_FLASH_CTRL_RULE_SHIFT (16U)
/*! FLASH_CTRL_RULE - Flash Controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_FLASH_CTRL_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_FLASH_CTRL_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_FLASH_CTRL_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_PRINCE_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_PRINCE_RULE_SHIFT (20U)
/*! PRINCE_RULE - Prince
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_PRINCE_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_PRINCE_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_PRINCE_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL2_COUNT (1U)

/*! @name SEC_CTRL_APB_BRIDGE1_MEM_CTRL3 - Security access rules for APB Bridge 1 peripherals. Each APB bridge sector is
 * 4 Kbytes. There are 32 APB Bridge 1 sectors in total. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_USBHPHY_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_USBHPHY_RULE_SHIFT (0U)
/*! USBHPHY_RULE - USB High Speed Phy controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_USBHPHY_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_USBHPHY_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_USBHPHY_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_RNG_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_RNG_RULE_SHIFT (8U)
/*! RNG_RULE - True Random Number Generator
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_RNG_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_RNG_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_RNG_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PUF_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PUF_RULE_SHIFT (12U)
/*! PUF_RULE - PUF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PUF_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PUF_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PUF_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PLU_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PLU_RULE_SHIFT (20U)
/*! PLU_RULE - Programmable Look-Up logic
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PLU_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PLU_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_PLU_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3 */
#define AHB_SECURE_CTRL_SEC_CTRL_APB_BRIDGE1_MEM_CTRL3_COUNT (1U)

/*! @name SEC_CTRL_AHB_PORT8_SLAVE0_RULE - Security access rules for AHB peripherals. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_DMA0_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_DMA0_RULE_SHIFT (8U)
/*! DMA0_RULE - DMA Controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_DMA0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_DMA0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_DMA0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FS_USB_DEV_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FS_USB_DEV_RULE_SHIFT (16U)
/*! FS_USB_DEV_RULE - USB Full-speed device
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FS_USB_DEV_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FS_USB_DEV_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FS_USB_DEV_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_SCT_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_SCT_RULE_SHIFT (20U)
/*! SCT_RULE - SCTimer
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_SCT_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_SCT_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_SCT_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM0_RULE_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM0_RULE_SHIFT (24U)
/*! FLEXCOMM0_RULE - Flexcomm interface 0
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM1_RULE_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM1_RULE_SHIFT (28U)
/*! FLEXCOMM1_RULE - Flexcomm interface 1
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE0_RULE_FLEXCOMM1_RULE_MASK)
/*! @} */

/*! @name SEC_CTRL_AHB_PORT8_SLAVE1_RULE - Security access rules for AHB peripherals. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM2_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM2_RULE_SHIFT (0U)
/*! FLEXCOMM2_RULE - Flexcomm interface 2
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM2_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM2_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM2_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM3_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM3_RULE_SHIFT (4U)
/*! FLEXCOMM3_RULE - Flexcomm interface 3
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM3_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM3_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM3_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM4_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM4_RULE_SHIFT (8U)
/*! FLEXCOMM4_RULE - Flexcomm interface 4
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM4_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM4_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_FLEXCOMM4_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_MAILBOX_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_MAILBOX_RULE_SHIFT (12U)
/*! MAILBOX_RULE - Inter CPU communication Mailbox
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_MAILBOX_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_MAILBOX_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_MAILBOX_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_GPIO0_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_GPIO0_RULE_SHIFT (16U)
/*! GPIO0_RULE - High Speed GPIO
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_GPIO0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_GPIO0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT8_SLAVE1_RULE_GPIO0_RULE_MASK)
/*! @} */

/*! @name SEC_CTRL_AHB_PORT9_SLAVE0_RULE - Security access rules for AHB peripherals. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_USB_HS_DEV_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_USB_HS_DEV_RULE_SHIFT (16U)
/*! USB_HS_DEV_RULE - USB high Speed device registers
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_USB_HS_DEV_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_USB_HS_DEV_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_USB_HS_DEV_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_CRC_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_CRC_RULE_SHIFT (20U)
/*! CRC_RULE - CRC engine
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_CRC_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_CRC_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_CRC_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM5_RULE_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM5_RULE_SHIFT (24U)
/*! FLEXCOMM5_RULE - Flexcomm interface 5
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM5_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM5_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM5_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM6_RULE_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM6_RULE_SHIFT (28U)
/*! FLEXCOMM6_RULE - Flexcomm interface 6
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM6_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM6_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE0_RULE_FLEXCOMM6_RULE_MASK)
/*! @} */

/*! @name SEC_CTRL_AHB_PORT9_SLAVE1_RULE - Security access rules for AHB peripherals. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_FLEXCOMM7_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_FLEXCOMM7_RULE_SHIFT (0U)
/*! FLEXCOMM7_RULE - Flexcomm interface 7
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_FLEXCOMM7_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_FLEXCOMM7_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_FLEXCOMM7_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_SDIO_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_SDIO_RULE_SHIFT (12U)
/*! SDIO_RULE - SDMMC card interface
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_SDIO_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_SDIO_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_SDIO_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_DBG_MAILBOX_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_DBG_MAILBOX_RULE_SHIFT (16U)
/*! DBG_MAILBOX_RULE - Debug mailbox (aka ISP-AP)
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_DBG_MAILBOX_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_DBG_MAILBOX_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_DBG_MAILBOX_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_HS_LSPI_RULE_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_HS_LSPI_RULE_SHIFT (28U)
/*! HS_LSPI_RULE - High Speed SPI
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_HS_LSPI_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_HS_LSPI_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT9_SLAVE1_RULE_HS_LSPI_RULE_MASK)
/*! @} */

/*! @name SEC_CTRL_AHB_PORT10_SLAVE0_RULE - Security access rules for AHB peripherals. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_ADC_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_ADC_RULE_SHIFT (0U)
/*! ADC_RULE - ADC
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_ADC_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_ADC_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_ADC_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_FS_HOST_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_FS_HOST_RULE_SHIFT (8U)
/*! USB_FS_HOST_RULE - USB Full Speed Host registers.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_FS_HOST_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_FS_HOST_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_FS_HOST_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_HS_HOST_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_HS_HOST_RULE_SHIFT (12U)
/*! USB_HS_HOST_RULE - USB High speed host registers
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_HS_HOST_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_HS_HOST_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_USB_HS_HOST_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_HASH_RULE_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_HASH_RULE_SHIFT (16U)
/*! HASH_RULE - SHA-2 crypto registers
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_HASH_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_HASH_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_HASH_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_CASPER_RULE_MASK (0x300000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_CASPER_RULE_SHIFT (20U)
/*! CASPER_RULE - RSA/ECC crypto accelerator
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_CASPER_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_CASPER_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_CASPER_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_PQ_RULE_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_PQ_RULE_SHIFT (24U)
/*! PQ_RULE - Power Quad (CPU0 processor hardware accelerator)
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_PQ_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_PQ_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_PQ_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_DMA1_RULE_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_DMA1_RULE_SHIFT (28U)
/*! DMA1_RULE - DMA Controller (Secure)
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_DMA1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_DMA1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_DMA1_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE0_RULE_COUNT (1U)

/*! @name SEC_CTRL_AHB_PORT10_SLAVE1_RULE - Security access rules for AHB peripherals. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_GPIO1_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_GPIO1_RULE_SHIFT (0U)
/*! GPIO1_RULE - Secure High Speed GPIO
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_GPIO1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_GPIO1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_GPIO1_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_AHB_SEC_CTRL_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_AHB_SEC_CTRL_RULE_SHIFT (4U)
/*! AHB_SEC_CTRL_RULE - AHB Secure Controller
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_AHB_SEC_CTRL_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_AHB_SEC_CTRL_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_AHB_SEC_CTRL_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_PORT10_SLAVE1_RULE_COUNT (1U)

/*! @name SEC_CTRL_AHB_SEC_CTRL_MEM_RULE - Security access rules for AHB_SEC_CTRL_AHB. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_0_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_0_RULE_SHIFT (0U)
/*! AHB_SEC_CTRL_SECT_0_RULE - Address space: 0x400A_0000 - 0x400A_CFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_1_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_1_RULE_SHIFT (4U)
/*! AHB_SEC_CTRL_SECT_1_RULE - Address space: 0x400A_D000 - 0x400A_DFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_1_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_2_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_2_RULE_SHIFT (8U)
/*! AHB_SEC_CTRL_SECT_2_RULE - Address space: 0x400A_E000 - 0x400A_EFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_2_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_2_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_2_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_3_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_3_RULE_SHIFT (12U)
/*! AHB_SEC_CTRL_SECT_3_RULE - Address space: 0x400A_F000 - 0x400A_FFFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_3_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_3_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_AHB_SEC_CTRL_SECT_3_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_AHB_SEC_CTRL_MEM_RULE_COUNT2 (1U)

/*! @name SEC_CTRL_USB_HS_SLAVE_RULE - Security access rules for USB High speed RAM slaves. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE_RAM_USB_HS_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE_RAM_USB_HS_RULE_SHIFT (0U)
/*! RAM_USB_HS_RULE - Security access rules for the whole USB High Speed RAM : 0x4010_0000 - 0x4010_3FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE_RAM_USB_HS_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE_RAM_USB_HS_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE_RAM_USB_HS_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_SLAVE_RULE_COUNT (1U)

/*! @name SEC_CTRL_USB_HS_MEM_RULE - Security access rules for RAM_USB_HS. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_0_RULE_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_0_RULE_SHIFT (0U)
/*! SRAM_SECT_0_RULE - Address space: 0x4010_0000 - 0x4010_0FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_0_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_0_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_0_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_1_RULE_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_1_RULE_SHIFT (4U)
/*! SRAM_SECT_1_RULE - Address space: 0x4010_1000 - 0x4010_1FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_1_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_1_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_1_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_2_RULE_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_2_RULE_SHIFT (8U)
/*! SRAM_SECT_2_RULE - Address space: 0x4010_2000 - 0x4010_2FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_2_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_2_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_2_RULE_MASK)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_3_RULE_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_3_RULE_SHIFT (12U)
/*! SRAM_SECT_3_RULE - Address space: 0x4010_3000 - 0x4010_3FFF
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_3_RULE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_3_RULE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_SRAM_SECT_3_RULE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_COUNT (1U)

/* The count of AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE */
#define AHB_SECURE_CTRL_SEC_CTRL_USB_HS_MEM_RULE_COUNT2 (1U)

/*! @name SEC_VIO_ADDR - most recent security violation address for AHB port n */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK (0xFFFFFFFFU)
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT (0U)
/*! SEC_VIO_ADDR - security violation address for AHB port
 */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_VIO_ADDR */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_COUNT (12U)

/*! @name SEC_VIO_MISC_INFO - most recent security violation miscellaneous information for AHB port n */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT (0U)
/*! SEC_VIO_INFO_WRITE - security violation access read/write indicator.
 *  0b0..Read access.
 *  0b1..Write access.
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT (1U)
/*! SEC_VIO_INFO_DATA_ACCESS - security violation access data/code indicator.
 *  0b0..Code access.
 *  0b1..Data access.
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK (0xF0U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT (4U)
/*! SEC_VIO_INFO_MASTER_SEC_LEVEL - bit [5:4]: master sec level and privilege level bit [7:6]: anti-pol value for master
 * sec level and privilege level
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK (0xF00U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT (8U)
/*! SEC_VIO_INFO_MASTER - security violation master number
 *  0b0000..CPU0 Code.
 *  0b0001..CPU0 System.
 *  0b0010..CPU1 Data.
 *  0b0011..CPU1 System.
 *  0b0100..USB-HS Device.
 *  0b0101..SDMA0.
 *  0b1000..SDIO.
 *  0b1001..PowerQuad.
 *  0b1010..HASH.
 *  0b1011..USB-FS Host.
 *  0b1100..SDMA1.
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_VIO_MISC_INFO */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_COUNT (12U)

/*! @name SEC_VIO_INFO_VALID - security violation address/information registers valid flags */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT (0U)
/*! VIO_INFO_VALID0 - violation information valid flag for AHB port 0. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT (1U)
/*! VIO_INFO_VALID1 - violation information valid flag for AHB port 1. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT (2U)
/*! VIO_INFO_VALID2 - violation information valid flag for AHB port 2. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT (3U)
/*! VIO_INFO_VALID3 - violation information valid flag for AHB port 3. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT (4U)
/*! VIO_INFO_VALID4 - violation information valid flag for AHB port 4. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT (5U)
/*! VIO_INFO_VALID5 - violation information valid flag for AHB port 5. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT (6U)
/*! VIO_INFO_VALID6 - violation information valid flag for AHB port 6. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT (7U)
/*! VIO_INFO_VALID7 - violation information valid flag for AHB port 7. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT (8U)
/*! VIO_INFO_VALID8 - violation information valid flag for AHB port 8. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT (9U)
/*! VIO_INFO_VALID9 - violation information valid flag for AHB port 9. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT (10U)
/*! VIO_INFO_VALID10 - violation information valid flag for AHB port 10. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT (11U)
/*! VIO_INFO_VALID11 - violation information valid flag for AHB port 11. Write 1 to clear.
 *  0b0..Not valid.
 *  0b1..Valid (violation occurred).
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK0 - Secure GPIO mask for port 0 pins. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO0_PIN0_SEC_MASK - Secure mask for pin P0_0
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO0_PIN1_SEC_MASK - Secure mask for pin P0_1
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO0_PIN2_SEC_MASK - Secure mask for pin P0_2
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO0_PIN3_SEC_MASK - Secure mask for pin P0_3
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO0_PIN4_SEC_MASK - Secure mask for pin P0_4
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO0_PIN5_SEC_MASK - Secure mask for pin P0_5
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO0_PIN6_SEC_MASK - Secure mask for pin P0_6
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO0_PIN7_SEC_MASK - Secure mask for pin P0_7
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO0_PIN8_SEC_MASK - Secure mask for pin P0_8
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO0_PIN9_SEC_MASK - Secure mask for pin P0_9
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO0_PIN10_SEC_MASK - Secure mask for pin P0_10
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO0_PIN11_SEC_MASK - Secure mask for pin P0_11
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO0_PIN12_SEC_MASK - Secure mask for pin P0_12
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO0_PIN13_SEC_MASK - Secure mask for pin P0_13
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO0_PIN14_SEC_MASK - Secure mask for pin P0_14
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO0_PIN15_SEC_MASK - Secure mask for pin P0_15
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO0_PIN16_SEC_MASK - Secure mask for pin P0_16
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO0_PIN17_SEC_MASK - Secure mask for pin P0_17
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO0_PIN18_SEC_MASK - Secure mask for pin P0_18
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO0_PIN19_SEC_MASK - Secure mask for pin P0_19
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO0_PIN20_SEC_MASK - Secure mask for pin P0_20
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO0_PIN21_SEC_MASK - Secure mask for pin P0_21
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO0_PIN22_SEC_MASK - Secure mask for pin P0_22
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO0_PIN23_SEC_MASK - Secure mask for pin P0_23
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO0_PIN24_SEC_MASK - Secure mask for pin P0_24
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO0_PIN25_SEC_MASK - Secure mask for pin P0_25
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO0_PIN26_SEC_MASK - Secure mask for pin P0_26
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO0_PIN27_SEC_MASK - Secure mask for pin P0_27
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO0_PIN28_SEC_MASK - Secure mask for pin P0_28
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO0_PIN29_SEC_MASK - Secure mask for pin P0_29
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO0_PIN30_SEC_MASK - Secure mask for pin P0_30
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO0_PIN31_SEC_MASK - Secure mask for pin P0_31
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK1 - Secure GPIO mask for port 1 pins. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO1_PIN0_SEC_MASK - Secure mask for pin P1_0
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO1_PIN1_SEC_MASK - Secure mask for pin P1_1
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO1_PIN2_SEC_MASK - Secure mask for pin P1_2
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO1_PIN3_SEC_MASK - Secure mask for pin P1_3
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO1_PIN4_SEC_MASK - Secure mask for pin P1_4
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO1_PIN5_SEC_MASK - Secure mask for pin P1_5
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO1_PIN6_SEC_MASK - Secure mask for pin P1_6
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO1_PIN7_SEC_MASK - Secure mask for pin P1_7
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO1_PIN8_SEC_MASK - Secure mask for pin P1_8
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO1_PIN9_SEC_MASK - Secure mask for pin P1_9
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO1_PIN10_SEC_MASK - Secure mask for pin P1_10
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO1_PIN11_SEC_MASK - Secure mask for pin P1_11
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO1_PIN12_SEC_MASK - Secure mask for pin P1_12
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO1_PIN13_SEC_MASK - Secure mask for pin P1_13
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO1_PIN14_SEC_MASK - Secure mask for pin P1_14
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO1_PIN15_SEC_MASK - Secure mask for pin P1_15
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO1_PIN16_SEC_MASK - Secure mask for pin P1_16
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO1_PIN17_SEC_MASK - Secure mask for pin P1_17
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO1_PIN18_SEC_MASK - Secure mask for pin P1_18
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO1_PIN19_SEC_MASK - Secure mask for pin P1_19
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO1_PIN20_SEC_MASK - Secure mask for pin P1_20
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO1_PIN21_SEC_MASK - Secure mask for pin P1_21
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO1_PIN22_SEC_MASK - Secure mask for pin P1_22
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO1_PIN23_SEC_MASK - Secure mask for pin P1_23
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO1_PIN24_SEC_MASK - Secure mask for pin P1_24
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO1_PIN25_SEC_MASK - Secure mask for pin P1_25
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO1_PIN26_SEC_MASK - Secure mask for pin P1_26
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO1_PIN27_SEC_MASK - Secure mask for pin P1_27
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO1_PIN28_SEC_MASK - Secure mask for pin P1_28
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO1_PIN29_SEC_MASK - Secure mask for pin P1_29
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO1_PIN30_SEC_MASK - Secure mask for pin P1_30
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO1_PIN31_SEC_MASK - Secure mask for pin P1_31
 *  0b1..Pin state is readable by non-secure world.
 *  0b0..Pin state is blocked to non-secure world.
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name SEC_CPU_INT_MASK0 - Secure Interrupt mask for CPU1 */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SYS_IRQ_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SYS_IRQ_SHIFT (0U)
/*! SYS_IRQ - Watchdog Timer, Brown Out Detectors and Flash Controller interrupts
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SYS_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SYS_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SYS_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SDMA0_IRQ_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SDMA0_IRQ_SHIFT (1U)
/*! SDMA0_IRQ - System DMA 0 (non-secure) interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SDMA0_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SDMA0_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SDMA0_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT0_IRQ_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT0_IRQ_SHIFT (2U)
/*! GPIO_GLOBALINT0_IRQ - GPIO Group 0 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT0_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT0_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT0_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT1_IRQ_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT1_IRQ_SHIFT (3U)
/*! GPIO_GLOBALINT1_IRQ - GPIO Group 1 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT1_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT1_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_GLOBALINT1_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ0_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ0_SHIFT (4U)
/*! GPIO_INT0_IRQ0 - Pin interrupt 0 or pattern match engine slice 0 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ0_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ1_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ1_SHIFT (5U)
/*! GPIO_INT0_IRQ1 - Pin interrupt 1 or pattern match engine slice 1 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ1_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ2_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ2_SHIFT (6U)
/*! GPIO_INT0_IRQ2 - Pin interrupt 2 or pattern match engine slice 2 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ2_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ3_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ3_SHIFT (7U)
/*! GPIO_INT0_IRQ3 - Pin interrupt 3 or pattern match engine slice 3 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_GPIO_INT0_IRQ3_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_UTICK_IRQ_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_UTICK_IRQ_SHIFT (8U)
/*! UTICK_IRQ - Micro Tick Timer interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_UTICK_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_UTICK_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_UTICK_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MRT_IRQ_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MRT_IRQ_SHIFT (9U)
/*! MRT_IRQ - Multi-Rate Timer interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MRT_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MRT_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MRT_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER0_IRQ_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER0_IRQ_SHIFT (10U)
/*! CTIMER0_IRQ - Standard counter/timer 0 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER0_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER0_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER0_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER1_IRQ_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER1_IRQ_SHIFT (11U)
/*! CTIMER1_IRQ - Standard counter/timer 1 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER1_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER1_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER1_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SCT_IRQ_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SCT_IRQ_SHIFT (12U)
/*! SCT_IRQ - SCTimer/PWM interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SCT_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SCT_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_SCT_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER3_IRQ_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER3_IRQ_SHIFT (13U)
/*! CTIMER3_IRQ - Standard counter/timer 3 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER3_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER3_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_CTIMER3_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM0_IRQ_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM0_IRQ_SHIFT (14U)
/*! FLEXCOMM0_IRQ - Flexcomm 0 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM0_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM0_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM0_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM1_IRQ_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM1_IRQ_SHIFT (15U)
/*! FLEXCOMM1_IRQ - Flexcomm 1 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM1_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM1_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM1_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM2_IRQ_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM2_IRQ_SHIFT (16U)
/*! FLEXCOMM2_IRQ - Flexcomm 2 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM2_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM2_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM2_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM3_IRQ_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM3_IRQ_SHIFT (17U)
/*! FLEXCOMM3_IRQ - Flexcomm 3 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM3_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM3_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM3_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM4_IRQ_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM4_IRQ_SHIFT (18U)
/*! FLEXCOMM4_IRQ - Flexcomm 4 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM4_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM4_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM4_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM5_IRQ_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM5_IRQ_SHIFT (19U)
/*! FLEXCOMM5_IRQ - Flexcomm 5 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM5_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM5_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM5_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM6_IRQ_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM6_IRQ_SHIFT (20U)
/*! FLEXCOMM6_IRQ - Flexcomm 6 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM6_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM6_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM6_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM7_IRQ_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM7_IRQ_SHIFT (21U)
/*! FLEXCOMM7_IRQ - Flexcomm 7 interrupt (USART, SPI, I2C, I2S).
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM7_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM7_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_FLEXCOMM7_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ADC_IRQ_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ADC_IRQ_SHIFT (22U)
/*! ADC_IRQ - General Purpose ADC interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ADC_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ADC_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ADC_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED0_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED0_SHIFT (23U)
/*! RESERVED0 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED0_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ACMP_IRQ_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ACMP_IRQ_SHIFT (24U)
/*! ACMP_IRQ - Analog Comparator interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ACMP_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ACMP_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_ACMP_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED1_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED1_SHIFT (25U)
/*! RESERVED1 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED1_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED2_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED2_SHIFT (26U)
/*! RESERVED2 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED2_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_NEEDCLK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_NEEDCLK_SHIFT (27U)
/*! USB0_NEEDCLK - USB Full Speed Controller Clock request interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_NEEDCLK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_NEEDCLK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_NEEDCLK_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_IRQ_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_IRQ_SHIFT (28U)
/*! USB0_IRQ - USB Full Speed Controller interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_USB0_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RTC_IRQ_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RTC_IRQ_SHIFT (29U)
/*! RTC_IRQ - RTC_LITE0_ALARM_IRQ, RTC_LITE0_WAKEUP_IRQ
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RTC_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RTC_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RTC_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED3_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED3_SHIFT (30U)
/*! RESERVED3 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_RESERVED3_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MAILBOX_IRQ_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MAILBOX_IRQ_SHIFT (31U)
/*! MAILBOX_IRQ - Mailbox interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MAILBOX_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MAILBOX_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK0_MAILBOX_IRQ_MASK)
/*! @} */

/*! @name SEC_CPU_INT_MASK1 - Secure Interrupt mask for CPU1 */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ4_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ4_SHIFT (0U)
/*! GPIO_INT0_IRQ4 - Pin interrupt 4 or pattern match engine slice 4 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ4_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ5_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ5_SHIFT (1U)
/*! GPIO_INT0_IRQ5 - Pin interrupt 5 or pattern match engine slice 5 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ5_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ6_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ6_SHIFT (2U)
/*! GPIO_INT0_IRQ6 - Pin interrupt 6 or pattern match engine slice 6 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ6(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ6_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ6_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ7_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ7_SHIFT (3U)
/*! GPIO_INT0_IRQ7 - Pin interrupt 7 or pattern match engine slice 7 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ7(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ7_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_GPIO_INT0_IRQ7_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER2_IRQ_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER2_IRQ_SHIFT (4U)
/*! CTIMER2_IRQ - Standard counter/timer 2 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER2_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER2_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER2_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER4_IRQ_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER4_IRQ_SHIFT (5U)
/*! CTIMER4_IRQ - Standard counter/timer 4 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER4_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER4_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CTIMER4_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_OS_EVENT_TIMER_IRQ_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_OS_EVENT_TIMER_IRQ_SHIFT (6U)
/*! OS_EVENT_TIMER_IRQ - OS Event Timer and OS Event Timer Wakeup interrupts
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_OS_EVENT_TIMER_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_OS_EVENT_TIMER_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_OS_EVENT_TIMER_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED0_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED0_SHIFT (7U)
/*! RESERVED0 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED0_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED1_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED1_SHIFT (8U)
/*! RESERVED1 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED1_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED2_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED2_SHIFT (9U)
/*! RESERVED2 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED2_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED2_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDIO_IRQ_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDIO_IRQ_SHIFT (10U)
/*! SDIO_IRQ - SDIO Controller interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDIO_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDIO_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDIO_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED3_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED3_SHIFT (11U)
/*! RESERVED3 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED3(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED3_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED3_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED4_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED4_SHIFT (12U)
/*! RESERVED4 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED4(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED4_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED4_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED5_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED5_SHIFT (13U)
/*! RESERVED5 - Reserved. Read value is undefined, only zero should be written.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED5(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED5_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_RESERVED5_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_PHY_IRQ_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_PHY_IRQ_SHIFT (14U)
/*! USB1_PHY_IRQ - USB High Speed PHY Controller interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_PHY_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_PHY_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_PHY_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_IRQ_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_IRQ_SHIFT (15U)
/*! USB1_IRQ - USB High Speed Controller interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_NEEDCLK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_NEEDCLK_SHIFT (16U)
/*! USB1_NEEDCLK - USB High Speed Controller Clock request interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_NEEDCLK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_NEEDCLK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_USB1_NEEDCLK_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_HYPERVISOR_CALL_IRQ_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_HYPERVISOR_CALL_IRQ_SHIFT (17U)
/*! SEC_HYPERVISOR_CALL_IRQ - Secure fault Hyper Visor call interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_HYPERVISOR_CALL_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_HYPERVISOR_CALL_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_HYPERVISOR_CALL_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ0_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ0_SHIFT (18U)
/*! SEC_GPIO_INT0_IRQ0 - Secure Pin interrupt 0 or pattern match engine slice 0 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ0_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ0_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ1_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ1_SHIFT (19U)
/*! SEC_GPIO_INT0_IRQ1 - Secure Pin interrupt 1 or pattern match engine slice 1 interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ1_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_GPIO_INT0_IRQ1_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PLU_IRQ_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PLU_IRQ_SHIFT (20U)
/*! PLU_IRQ - Programmable Look-Up Controller interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PLU_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PLU_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PLU_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_VIO_IRQ_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_VIO_IRQ_SHIFT (21U)
/*! SEC_VIO_IRQ - Security Violation interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_VIO_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_VIO_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SEC_VIO_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SHA_IRQ_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SHA_IRQ_SHIFT (22U)
/*! SHA_IRQ - HASH-AES interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SHA_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SHA_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SHA_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CASPER_IRQ_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CASPER_IRQ_SHIFT (23U)
/*! CASPER_IRQ - CASPER interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CASPER_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CASPER_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_CASPER_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PUFKEY_IRQ_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PUFKEY_IRQ_SHIFT (24U)
/*! PUFKEY_IRQ - PUF interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PUFKEY_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PUFKEY_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PUFKEY_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PQ_IRQ_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PQ_IRQ_SHIFT (25U)
/*! PQ_IRQ - Power Quad interrupt.
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PQ_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PQ_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_PQ_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDMA1_IRQ_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDMA1_IRQ_SHIFT (26U)
/*! SDMA1_IRQ - System DMA 1 (Secure) interrupt
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDMA1_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDMA1_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_SDMA1_IRQ_MASK)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_LSPI_HS_IRQ_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_LSPI_HS_IRQ_SHIFT (27U)
/*! LSPI_HS_IRQ - High Speed SPI interrupt
 *  0b0..
 *  0b1..
 */
#define AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_LSPI_HS_IRQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_LSPI_HS_IRQ_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_CPU_INT_MASK1_LSPI_HS_IRQ_MASK)
/*! @} */

/*! @name SEC_MASK_LOCK - Security General Purpose register access control. */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_SHIFT (0U)
/*! SEC_GPIO_MASK0_LOCK - SEC_GPIO_MASK0 register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_MASK (0xCU)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_SHIFT (2U)
/*! SEC_GPIO_MASK1_LOCK - SEC_GPIO_MASK1 register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK0_LOCK_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK0_LOCK_SHIFT (8U)
/*! SEC_CPU1_INT_MASK0_LOCK - SEC_CPU_INT_MASK0 register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK0_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK0_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK0_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK1_LOCK_MASK (0xC00U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK1_LOCK_SHIFT (10U)
/*! SEC_CPU1_INT_MASK1_LOCK - SEC_CPU_INT_MASK1 register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK1_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK1_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_CPU1_INT_MASK1_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_LEVEL - master secure level register */
/*! @{ */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1C_MASK (0x30U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1C_SHIFT (4U)
/*! CPU1C - Micro-Cortex M33 (CPU1) Code bus.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1C(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1C_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1C_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1S_MASK (0xC0U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1S_SHIFT (6U)
/*! CPU1S - Micro-Cortex M33 (CPU1) System bus.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1S(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1S_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_CPU1S_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSD_MASK (0x300U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSD_SHIFT (8U)
/*! USBFSD - USB Full Speed Device.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSD_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSD_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA0_MASK (0xC00U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA0_SHIFT (10U)
/*! SDMA0 - System DMA 0.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA0_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA0_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_MASK (0x30000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_SHIFT (16U)
/*! SDIO - SDIO.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_MASK (0xC0000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_SHIFT (18U)
/*! PQ - Power Quad.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_HASH_MASK (0x300000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_HASH_SHIFT (20U)
/*! HASH - Hash.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_HASH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_HASH_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_HASH_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSH_MASK (0xC00000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSH_SHIFT (22U)
/*! USBFSH - USB Full speed Host.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSH_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_USBFSH_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA1_MASK (0x3000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA1_SHIFT (24U)
/*! SDMA1 - System DMA 1 security level.
 *  0b00..Non-secure and Non-priviledge user access allowed.
 *  0b01..Non-secure and Privilege access allowed.
 *  0b10..Secure and Non-priviledge user access allowed.
 *  0b11..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA1_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA1_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_LOCK - MASTER_SEC_LEVEL write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_ANTI_POL_REG - master secure level anti-pole register */
/*! @{ */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1C_MASK (0x30U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1C_SHIFT (4U)
/*! CPU1C - Micro-Cortex M33 (CPU1) Code bus. Must be equal to NOT(MASTER_SEC_LEVEL.CPU1C)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1C(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1C_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1C_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1S_MASK (0xC0U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1S_SHIFT (6U)
/*! CPU1S - Micro-Cortex M33 (CPU1) System bus. Must be equal to NOT(MASTER_SEC_LEVEL.CPU1S)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1S(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1S_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_CPU1S_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSD_MASK (0x300U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSD_SHIFT (8U)
/*! USBFSD - USB Full Speed Device. Must be equal to NOT(MASTER_SEC_LEVEL.USBFSD)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSD_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSD_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA0_MASK (0xC00U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA0_SHIFT (10U)
/*! SDMA0 - System DMA 0. Must be equal to NOT(MASTER_SEC_LEVEL.SDMA0)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA0_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA0_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO_MASK (0x30000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO_SHIFT (16U)
/*! SDIO - SDIO. Must be equal to NOT(MASTER_SEC_LEVEL.SDIO)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_MASK (0xC0000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_SHIFT (18U)
/*! PQ - Power Quad. Must be equal to NOT(MASTER_SEC_LEVEL.PQ)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_HASH_MASK (0x300000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_HASH_SHIFT (20U)
/*! HASH - Hash. Must be equal to NOT(MASTER_SEC_LEVEL.HASH)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_HASH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_HASH_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_HASH_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSH_MASK (0xC00000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSH_SHIFT (22U)
/*! USBFSH - USB Full speed Host. Must be equal to NOT(MASTER_SEC_LEVEL.USBFSH)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSH_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_USBFSH_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA1_MASK (0x3000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA1_SHIFT (24U)
/*! SDMA1 - System DMA 1 security level. Must be equal to NOT(MASTER_SEC_LEVEL.SDMA1)
 *  0b11..Non-secure and Non-priviledge user access allowed.
 *  0b10..Non-secure and Privilege access allowed.
 *  0b01..Secure and Non-priviledge user access allowed.
 *  0b00..Secure and Priviledge user access allowed.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA1_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA1_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_ANTIPOL_LOCK - MASTER_SEC_ANTI_POL_REG register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK)
/*! @} */

/*! @name CPU0_LOCK_REG - Miscalleneous control signals for in Cortex M33 (CPU0) */
/*! @{ */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_VTOR_MASK (0x3U)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_VTOR_SHIFT (0U)
/*! LOCK_NS_VTOR - Cortex M33 (CPU0) VTOR_NS register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_VTOR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & \
     AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_VTOR_MASK)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_MPU_MASK (0xCU)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_MPU_SHIFT (2U)
/*! LOCK_NS_MPU - Cortex M33 (CPU0) non-secure MPU register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_MPU(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_MPU_SHIFT)) & \
     AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_NS_MPU_MASK)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_VTAIRCR_MASK (0x30U)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_VTAIRCR_SHIFT (4U)
/*! LOCK_S_VTAIRCR - Cortex M33 (CPU0) VTOR_S, AIRCR.PRIS, IRCR.BFHFNMINS registers write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_VTAIRCR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_VTAIRCR_SHIFT)) & \
     AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_VTAIRCR_MASK)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_MPU_MASK (0xC0U)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_MPU_SHIFT (6U)
/*! LOCK_S_MPU - Cortex M33 (CPU0) Secure MPU registers write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_MPU(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_MPU_SHIFT)) & \
     AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_S_MPU_MASK)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_SAU_MASK (0x300U)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_SAU_SHIFT (8U)
/*! LOCK_SAU - Cortex M33 (CPU0) SAU registers write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_SAU(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_SAU_SHIFT)) & \
     AHB_SECURE_CTRL_CPU0_LOCK_REG_LOCK_SAU_MASK)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_CPU0_LOCK_REG_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_CPU0_LOCK_REG_LOCK_SHIFT (30U)
/*! CPU0_LOCK_REG_LOCK - CPU0_LOCK_REG write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU0_LOCK_REG_CPU0_LOCK_REG_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU0_LOCK_REG_CPU0_LOCK_REG_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_CPU0_LOCK_REG_CPU0_LOCK_REG_LOCK_MASK)
/*! @} */

/*! @name CPU1_LOCK_REG - Miscalleneous control signals for in micro-Cortex M33 (CPU1) */
/*! @{ */
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_VTOR_MASK (0x3U)
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_VTOR_SHIFT (0U)
/*! LOCK_NS_VTOR - micro-Cortex M33 (CPU1) VTOR_NS register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_VTOR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & \
     AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_VTOR_MASK)
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_MPU_MASK (0xCU)
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_MPU_SHIFT (2U)
/*! LOCK_NS_MPU - micro-Cortex M33 (CPU1) non-secure MPU register write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_MPU(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_MPU_SHIFT)) & \
     AHB_SECURE_CTRL_CPU1_LOCK_REG_LOCK_NS_MPU_MASK)
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_CPU1_LOCK_REG_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_CPU1_LOCK_REG_LOCK_SHIFT (30U)
/*! CPU1_LOCK_REG_LOCK - CPU1_LOCK_REG write-lock.
 *  0b10..Writable.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_CPU1_LOCK_REG_CPU1_LOCK_REG_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CPU1_LOCK_REG_CPU1_LOCK_REG_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_CPU1_LOCK_REG_CPU1_LOCK_REG_LOCK_MASK)
/*! @} */

/*! @name MISC_CTRL_DP_REG - secure control duplicate register */
/*! @{ */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT (0U)
/*! WRITE_LOCK - Write lock.
 *  0b10..Secure control registers can be written.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable secure check for AHB matrix.
 *  0b10..Disable check.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable secure privilege check for AHB matrix.
 *  0b10..Disable check.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable non-secure privilege check for AHB matrix.
 *  0b10..Disable check.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable secure violation abort.
 *  0b10..Enable abort fort secure checker.
 *  0b01..Disable abort fort secure checker.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK (0xC00U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT (10U)
/*! DISABLE_SIMPLE_MASTER_STRICT_MODE - Disable simple master strict mode.
 *  0b10..Simple master in strict mode.
 *  0b01..Simple master in tier mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK (0x3000U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT (12U)
/*! DISABLE_SMART_MASTER_STRICT_MODE - Disable smart master strict mode.
 *  0b10..Smart master in strict mode.
 *  0b01..Smart master in tier mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK (0xC000U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT (14U)
/*! IDAU_ALL_NS - Disable IDAU.
 *  0b10..IDAU is enabled.
 *  0b01..IDAU is disable.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK)
/*! @} */

/*! @name MISC_CTRL_REG - secure control register */
/*! @{ */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_SHIFT (0U)
/*! WRITE_LOCK - Write lock.
 *  0b10..Secure control registers can be written.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable secure check for AHB matrix.
 *  0b10..Disable check.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable secure privilege check for AHB matrix.
 *  0b10..Disable check.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable non-secure privilege check for AHB matrix.
 *  0b10..Disable check.
 *  0b01..Restricted mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable secure violation abort.
 *  0b10..Enable abort fort secure checker.
 *  0b01..Disable abort fort secure checker.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK (0xC00U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT (10U)
/*! DISABLE_SIMPLE_MASTER_STRICT_MODE - Disable simple master strict mode.
 *  0b10..Simple master in strict mode.
 *  0b01..Simple master in tier mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK (0x3000U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT (12U)
/*! DISABLE_SMART_MASTER_STRICT_MODE - Disable smart master strict mode.
 *  0b10..Smart master in strict mode.
 *  0b01..Smart master in tier mode.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_MASK (0xC000U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT (14U)
/*! IDAU_ALL_NS - Disable IDAU.
 *  0b10..IDAU is enabled.
 *  0b01..IDAU is disable.
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT)) & \
     AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group AHB_SECURE_CTRL_Register_Masks */

/* AHB_SECURE_CTRL - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral AHB_SECURE_CTRL base address */
#define AHB_SECURE_CTRL_BASE (0x500AC000u)
/** Peripheral AHB_SECURE_CTRL base address */
#define AHB_SECURE_CTRL_BASE_NS (0x400AC000u)
/** Peripheral AHB_SECURE_CTRL base pointer */
#define AHB_SECURE_CTRL ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE)
/** Peripheral AHB_SECURE_CTRL base pointer */
#define AHB_SECURE_CTRL_NS ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE_NS)
/** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
#define AHB_SECURE_CTRL_BASE_ADDRS \
    {                              \
        AHB_SECURE_CTRL_BASE       \
    }
/** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
#define AHB_SECURE_CTRL_BASE_PTRS \
    {                             \
        AHB_SECURE_CTRL           \
    }
/** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
#define AHB_SECURE_CTRL_BASE_ADDRS_NS \
    {                                 \
        AHB_SECURE_CTRL_BASE_NS       \
    }
/** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
#define AHB_SECURE_CTRL_BASE_PTRS_NS \
    {                                \
        AHB_SECURE_CTRL_NS           \
    }
#else
/** Peripheral AHB_SECURE_CTRL base address */
#define AHB_SECURE_CTRL_BASE (0x400AC000u)
/** Peripheral AHB_SECURE_CTRL base pointer */
#define AHB_SECURE_CTRL ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE)
/** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
#define AHB_SECURE_CTRL_BASE_ADDRS \
    {                              \
        AHB_SECURE_CTRL_BASE       \
    }
/** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
#define AHB_SECURE_CTRL_BASE_PTRS \
    {                             \
        AHB_SECURE_CTRL           \
    }
#endif

/*!
 * @}
 */ /* end of group AHB_SECURE_CTRL_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- ANACTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANACTRL_Peripheral_Access_Layer ANACTRL Peripheral Access Layer
 * @{
 */

/** ANACTRL - Register Layout Typedef */
typedef struct
{
    uint8_t RESERVED_0[4];
    __I uint32_t ANALOG_CTRL_STATUS; /**< Analog Macroblock Identity registers, Flash Status registers, offset: 0x4 */
    uint8_t RESERVED_1[4];
    __IO uint32_t FREQ_ME_CTRL;  /**< Frequency Measure function control register, offset: 0xC */
    __IO uint32_t FRO192M_CTRL;  /**< 192MHz Free Running OScillator (FRO) Control register, offset: 0x10 */
    __I uint32_t FRO192M_STATUS; /**< 192MHz Free Running OScillator (FRO) Status register, offset: 0x14 */
    uint8_t RESERVED_2[8];
    __IO uint32_t XO32M_CTRL;  /**< High speed Crystal Oscillator Control register, offset: 0x20 */
    __I uint32_t XO32M_STATUS; /**< High speed Crystal Oscillator Status register, offset: 0x24 */
    uint8_t RESERVED_3[8];
    __IO uint32_t BOD_DCDC_INT_CTRL;  /**< Brown Out Detectors (BoDs) & DCDC interrupts generation control register,
                                         offset: 0x30 */
    __I uint32_t BOD_DCDC_INT_STATUS; /**< BoDs & DCDC interrupts status register, offset: 0x34 */
    uint8_t RESERVED_4[8];
    __IO uint32_t RINGO0_CTRL; /**< First Ring Oscillator module control register., offset: 0x40 */
    __IO uint32_t RINGO1_CTRL; /**< Second Ring Oscillator module control register., offset: 0x44 */
    __IO uint32_t RINGO2_CTRL; /**< Third Ring Oscillator module control register., offset: 0x48 */
    uint8_t RESERVED_5[180];
    __IO uint32_t USBHS_PHY_CTRL; /**< USB High Speed Phy Control, offset: 0x100 */
} ANACTRL_Type;

/* ----------------------------------------------------------------------------
   -- ANACTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANACTRL_Register_Masks ANACTRL Register Masks
 * @{
 */

/*! @name ANALOG_CTRL_STATUS - Analog Macroblock Identity registers, Flash Status registers */
/*! @{ */
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_MASK (0x1000U)
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_SHIFT (12U)
/*! FLASH_PWRDWN - Flash Power Down status.
 *  0b0..Flash is not in power down mode.
 *  0b1..Flash is in power down mode.
 */
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_SHIFT)) & \
     ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_MASK)
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_MASK (0x2000U)
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_SHIFT (13U)
/*! FLASH_INIT_ERROR - Flash initialization error status.
 *  0b0..No error.
 *  0b1..At least one error occured during flash initialization..
 */
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_SHIFT)) & \
     ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_MASK)
/*! @} */

/*! @name FREQ_ME_CTRL - Frequency Measure function control register */
/*! @{ */
#define ANACTRL_FREQ_ME_CTRL_CAPVAL_SCALE_MASK (0x7FFFFFFFU)
#define ANACTRL_FREQ_ME_CTRL_CAPVAL_SCALE_SHIFT (0U)
/*! CAPVAL_SCALE - Frequency measure result /Frequency measur scale
 */
#define ANACTRL_FREQ_ME_CTRL_CAPVAL_SCALE(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FREQ_ME_CTRL_CAPVAL_SCALE_SHIFT)) & ANACTRL_FREQ_ME_CTRL_CAPVAL_SCALE_MASK)
#define ANACTRL_FREQ_ME_CTRL_PROG_MASK (0x80000000U)
#define ANACTRL_FREQ_ME_CTRL_PROG_SHIFT (31U)
/*! PROG - Set this bit to one to initiate a frequency measurement cycle. Hardware clears this bit
 *    when the measurement cycle has completed and there is valid capture data in the CAPVAL field
 *    (bits 30:0).
 */
#define ANACTRL_FREQ_ME_CTRL_PROG(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FREQ_ME_CTRL_PROG_SHIFT)) & ANACTRL_FREQ_ME_CTRL_PROG_MASK)
/*! @} */

/*! @name FRO192M_CTRL - 192MHz Free Running OScillator (FRO) Control register */
/*! @{ */
#define ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_MASK (0x4000U)
#define ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_SHIFT (14U)
/*! ENA_12MHZCLK - 12 MHz clock control.
 *  0b0..12 MHz clock is disabled.
 *  0b1..12 MHz clock is enabled.
 */
#define ANACTRL_FRO192M_CTRL_ENA_12MHZCLK(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_SHIFT)) & ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_MASK)
#define ANACTRL_FRO192M_CTRL_ENA_48MHZCLK_MASK (0x8000U)
#define ANACTRL_FRO192M_CTRL_ENA_48MHZCLK_SHIFT (15U)
/*! ENA_48MHZCLK - 48 MHz clock control.
 *  0b0..Reserved.
 *  0b1..48 MHz clock is enabled.
 */
#define ANACTRL_FRO192M_CTRL_ENA_48MHZCLK(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_ENA_48MHZCLK_SHIFT)) & ANACTRL_FRO192M_CTRL_ENA_48MHZCLK_MASK)
#define ANACTRL_FRO192M_CTRL_DAC_TRIM_MASK (0xFF0000U)
#define ANACTRL_FRO192M_CTRL_DAC_TRIM_SHIFT (16U)
/*! DAC_TRIM - Frequency trim.
 */
#define ANACTRL_FRO192M_CTRL_DAC_TRIM(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_DAC_TRIM_SHIFT)) & ANACTRL_FRO192M_CTRL_DAC_TRIM_MASK)
#define ANACTRL_FRO192M_CTRL_USBCLKADJ_MASK (0x1000000U)
#define ANACTRL_FRO192M_CTRL_USBCLKADJ_SHIFT (24U)
/*! USBCLKADJ - If this bit is set and the USB peripheral is enabled into full speed device mode,
 *    the USB block will provide FRO clock adjustments to lock it to the host clock using the SOF
 *    packets.
 */
#define ANACTRL_FRO192M_CTRL_USBCLKADJ(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_USBCLKADJ_SHIFT)) & ANACTRL_FRO192M_CTRL_USBCLKADJ_MASK)
#define ANACTRL_FRO192M_CTRL_USBMODCHG_MASK (0x2000000U)
#define ANACTRL_FRO192M_CTRL_USBMODCHG_SHIFT (25U)
/*! USBMODCHG - If it reads as 1 when reading the DAC_TRIM field and USBCLKADJ=1, it should be re-read until it is 0.
 */
#define ANACTRL_FRO192M_CTRL_USBMODCHG(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_USBMODCHG_SHIFT)) & ANACTRL_FRO192M_CTRL_USBMODCHG_MASK)
#define ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_MASK (0x40000000U)
#define ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_SHIFT (30U)
/*! ENA_96MHZCLK - 96 MHz clock control.
 *  0b0..96 MHz clock is disabled.
 *  0b1..96 MHz clock is enabled.
 */
#define ANACTRL_FRO192M_CTRL_ENA_96MHZCLK(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_SHIFT)) & ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_MASK)
/*! @} */

/*! @name FRO192M_STATUS - 192MHz Free Running OScillator (FRO) Status register */
/*! @{ */
#define ANACTRL_FRO192M_STATUS_CLK_VALID_MASK (0x1U)
#define ANACTRL_FRO192M_STATUS_CLK_VALID_SHIFT (0U)
/*! CLK_VALID - Output clock valid signal. Indicates that CCO clock has settled.
 *  0b0..No output clock present (None of 12 MHz, 48 MHz or 96 MHz clock is available).
 *  0b1..Clock is present (12 MHz, 48 MHz or 96 MHz can be output if they are enable respectively by
 *       FRO192M_CTRL.ENA_12MHZCLK/ENA_48MHZCLK/ENA_96MHZCLK).
 */
#define ANACTRL_FRO192M_STATUS_CLK_VALID(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_STATUS_CLK_VALID_SHIFT)) & ANACTRL_FRO192M_STATUS_CLK_VALID_MASK)
#define ANACTRL_FRO192M_STATUS_ATB_VCTRL_MASK (0x2U)
#define ANACTRL_FRO192M_STATUS_ATB_VCTRL_SHIFT (1U)
/*! ATB_VCTRL - CCO threshold voltage detector output (signal vcco_ok). Once the CCO voltage crosses
 *    the threshold voltage of a SLVT transistor, this output signal will go high. It is also
 *    possible to observe the clk_valid signal.
 */
#define ANACTRL_FRO192M_STATUS_ATB_VCTRL(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_STATUS_ATB_VCTRL_SHIFT)) & ANACTRL_FRO192M_STATUS_ATB_VCTRL_MASK)
/*! @} */

/*! @name XO32M_CTRL - High speed Crystal Oscillator Control register */
/*! @{ */
#define ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_MASK (0x400000U)
#define ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_SHIFT (22U)
/*! ACBUF_PASS_ENABLE - Bypass enable of XO AC buffer enable in pll and top level.
 *  0b0..XO AC buffer bypass is disabled.
 *  0b1..XO AC buffer bypass is enabled.
 */
#define ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_SHIFT)) & \
     ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_MASK)
#define ANACTRL_XO32M_CTRL_ENABLE_PLL_USB_OUT_MASK (0x800000U)
#define ANACTRL_XO32M_CTRL_ENABLE_PLL_USB_OUT_SHIFT (23U)
/*! ENABLE_PLL_USB_OUT - Enable High speed Crystal oscillator output to USB HS PLL.
 *  0b0..High speed Crystal oscillator output to USB HS PLL is disabled.
 *  0b1..High speed Crystal oscillator output to USB HS PLL is enabled.
 */
#define ANACTRL_XO32M_CTRL_ENABLE_PLL_USB_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_ENABLE_PLL_USB_OUT_SHIFT)) & \
     ANACTRL_XO32M_CTRL_ENABLE_PLL_USB_OUT_MASK)
#define ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_MASK (0x1000000U)
#define ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_SHIFT (24U)
/*! ENABLE_SYSTEM_CLK_OUT - Enable XO 32 MHz output to CPU system.
 *  0b0..High speed Crystal oscillator output to CPU system is disabled.
 *  0b1..High speed Crystal oscillator output to CPU system is enabled.
 */
#define ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_SHIFT)) & \
     ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_MASK)
/*! @} */

/*! @name XO32M_STATUS - High speed Crystal Oscillator Status register */
/*! @{ */
#define ANACTRL_XO32M_STATUS_XO_READY_MASK (0x1U)
#define ANACTRL_XO32M_STATUS_XO_READY_SHIFT (0U)
/*! XO_READY - Indicates XO out frequency statibilty.
 *  0b0..XO output frequency is not yet stable.
 *  0b1..XO output frequency is stable.
 */
#define ANACTRL_XO32M_STATUS_XO_READY(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_STATUS_XO_READY_SHIFT)) & ANACTRL_XO32M_STATUS_XO_READY_MASK)
/*! @} */

/*! @name BOD_DCDC_INT_CTRL - Brown Out Detectors (BoDs) & DCDC interrupts generation control register */
/*! @{ */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_ENABLE_MASK (0x1U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_ENABLE_SHIFT (0U)
/*! BODVBAT_INT_ENABLE - BOD VBAT interrupt control.
 *  0b0..BOD VBAT interrupt is disabled.
 *  0b1..BOD VBAT interrupt is enabled.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_ENABLE_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_ENABLE_MASK)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_CLEAR_MASK (0x2U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_CLEAR_SHIFT (1U)
/*! BODVBAT_INT_CLEAR - BOD VBAT interrupt clear.1: Clear the interrupt. Self-cleared bit.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_CLEAR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_CLEAR_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_CTRL_BODVBAT_INT_CLEAR_MASK)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_MASK (0x4U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_SHIFT (2U)
/*! BODCORE_INT_ENABLE - BOD CORE interrupt control.
 *  0b0..BOD CORE interrupt is disabled.
 *  0b1..BOD CORE interrupt is enabled.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_MASK)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_MASK (0x8U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_SHIFT (3U)
/*! BODCORE_INT_CLEAR - BOD CORE interrupt clear.1: Clear the interrupt. Self-cleared bit.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_MASK)
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_MASK (0x10U)
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_SHIFT (4U)
/*! DCDC_INT_ENABLE - DCDC interrupt control.
 *  0b0..DCDC interrupt is disabled.
 *  0b1..DCDC interrupt is enabled.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_MASK)
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_MASK (0x20U)
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_SHIFT (5U)
/*! DCDC_INT_CLEAR - DCDC interrupt clear.1: Clear the interrupt. Self-cleared bit.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_MASK)
/*! @} */

/*! @name BOD_DCDC_INT_STATUS - BoDs & DCDC interrupts status register */
/*! @{ */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_STATUS_MASK (0x1U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_STATUS_SHIFT (0U)
/*! BODVBAT_STATUS - BOD VBAT Interrupt status before Interrupt Enable.
 *  0b0..No interrupt pending..
 *  0b1..Interrupt pending..
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_STATUS_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_STATUS_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_INT_STATUS_MASK (0x2U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_INT_STATUS_SHIFT (1U)
/*! BODVBAT_INT_STATUS - BOD VBAT Interrupt status after Interrupt Enable.
 *  0b0..No interrupt pending..
 *  0b1..Interrupt pending..
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_INT_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_INT_STATUS_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_INT_STATUS_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_VAL_MASK (0x4U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_VAL_SHIFT (2U)
/*! BODVBAT_VAL - Current value of BOD VBAT power status output.
 *  0b0..VBAT voltage level is below the threshold.
 *  0b1..VBAT voltage level is above the threshold.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_VAL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_VAL_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_BODVBAT_VAL_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_MASK (0x8U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_SHIFT (3U)
/*! BODCORE_STATUS - BOD CORE Interrupt status before Interrupt Enable.
 *  0b0..No interrupt pending..
 *  0b1..Interrupt pending..
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_MASK (0x10U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_SHIFT (4U)
/*! BODCORE_INT_STATUS - BOD CORE Interrupt status after Interrupt Enable.
 *  0b0..No interrupt pending..
 *  0b1..Interrupt pending..
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_MASK (0x20U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_SHIFT (5U)
/*! BODCORE_VAL - Current value of BOD CORE power status output.
 *  0b0..CORE voltage level is below the threshold.
 *  0b1..CORE voltage level is above the threshold.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_MASK (0x40U)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_SHIFT (6U)
/*! DCDC_STATUS - DCDC Interrupt status before Interrupt Enable.
 *  0b0..No interrupt pending..
 *  0b1..Interrupt pending..
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_MASK (0x80U)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_SHIFT (7U)
/*! DCDC_INT_STATUS - DCDC Interrupt status after Interrupt Enable.
 *  0b0..No interrupt pending..
 *  0b1..Interrupt pending..
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_MASK)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_MASK (0x100U)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_SHIFT (8U)
/*! DCDC_VAL - Current value of DCDC power status output.
 *  0b0..DCDC output Voltage is below the targeted regulation level.
 *  0b1..DCDC output Voltage is above the targeted regulation level.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_SHIFT)) & \
     ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_MASK)
/*! @} */

/*! @name RINGO0_CTRL - First Ring Oscillator module control register. */
/*! @{ */
#define ANACTRL_RINGO0_CTRL_SL_MASK (0x1U)
#define ANACTRL_RINGO0_CTRL_SL_SHIFT (0U)
/*! SL - Select short or long ringo (for all ringos types).
 *  0b0..Select short ringo (few elements).
 *  0b1..Select long ringo (many elements).
 */
#define ANACTRL_RINGO0_CTRL_SL(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_SL_SHIFT)) & ANACTRL_RINGO0_CTRL_SL_MASK)
#define ANACTRL_RINGO0_CTRL_FS_MASK (0x2U)
#define ANACTRL_RINGO0_CTRL_FS_SHIFT (1U)
/*! FS - Ringo frequency output divider.
 *  0b0..High frequency output (frequency lower than 100 MHz).
 *  0b1..Low frequency output (frequency lower than 10 MHz).
 */
#define ANACTRL_RINGO0_CTRL_FS(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_FS_SHIFT)) & ANACTRL_RINGO0_CTRL_FS_MASK)
#define ANACTRL_RINGO0_CTRL_SWN_SWP_MASK (0xCU)
#define ANACTRL_RINGO0_CTRL_SWN_SWP_SHIFT (2U)
/*! SWN_SWP - PN-Ringos (P-Transistor and N-Transistor processing) control.
 *  0b00..Normal mode.
 *  0b01..P-Monitor mode. Measure with weak P transistor.
 *  0b10..P-Monitor mode. Measure with weak N transistor.
 *  0b11..Don't use.
 */
#define ANACTRL_RINGO0_CTRL_SWN_SWP(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_SWN_SWP_SHIFT)) & ANACTRL_RINGO0_CTRL_SWN_SWP_MASK)
#define ANACTRL_RINGO0_CTRL_PD_MASK (0x10U)
#define ANACTRL_RINGO0_CTRL_PD_SHIFT (4U)
/*! PD - Ringo module Power control.
 *  0b0..The Ringo module is enabled.
 *  0b1..The Ringo module is disabled.
 */
#define ANACTRL_RINGO0_CTRL_PD(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_PD_SHIFT)) & ANACTRL_RINGO0_CTRL_PD_MASK)
#define ANACTRL_RINGO0_CTRL_E_ND0_MASK (0x20U)
#define ANACTRL_RINGO0_CTRL_E_ND0_SHIFT (5U)
/*! E_ND0 - First NAND2-based ringo control.
 *  0b0..First NAND2-based ringo is disabled.
 *  0b1..First NAND2-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_ND0(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_ND0_SHIFT)) & ANACTRL_RINGO0_CTRL_E_ND0_MASK)
#define ANACTRL_RINGO0_CTRL_E_ND1_MASK (0x40U)
#define ANACTRL_RINGO0_CTRL_E_ND1_SHIFT (6U)
/*! E_ND1 - Second NAND2-based ringo control.
 *  0b0..Second NAND2-based ringo is disabled.
 *  0b1..Second NAND2-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_ND1(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_ND1_SHIFT)) & ANACTRL_RINGO0_CTRL_E_ND1_MASK)
#define ANACTRL_RINGO0_CTRL_E_NR0_MASK (0x80U)
#define ANACTRL_RINGO0_CTRL_E_NR0_SHIFT (7U)
/*! E_NR0 - First NOR2-based ringo control.
 *  0b0..First NOR2-based ringo is disabled.
 *  0b1..First NOR2-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_NR0(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_NR0_SHIFT)) & ANACTRL_RINGO0_CTRL_E_NR0_MASK)
#define ANACTRL_RINGO0_CTRL_E_NR1_MASK (0x100U)
#define ANACTRL_RINGO0_CTRL_E_NR1_SHIFT (8U)
/*! E_NR1 - Second NOR2-based ringo control.
 *  0b0..Second NORD2-based ringo is disabled.
 *  0b1..Second NORD2-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_NR1(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_NR1_SHIFT)) & ANACTRL_RINGO0_CTRL_E_NR1_MASK)
#define ANACTRL_RINGO0_CTRL_E_IV0_MASK (0x200U)
#define ANACTRL_RINGO0_CTRL_E_IV0_SHIFT (9U)
/*! E_IV0 - First Inverter-based ringo control.
 *  0b0..First INV-based ringo is disabled.
 *  0b1..First INV-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_IV0(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_IV0_SHIFT)) & ANACTRL_RINGO0_CTRL_E_IV0_MASK)
#define ANACTRL_RINGO0_CTRL_E_IV1_MASK (0x400U)
#define ANACTRL_RINGO0_CTRL_E_IV1_SHIFT (10U)
/*! E_IV1 - Second Inverter-based ringo control.
 *  0b0..Second INV-based ringo is disabled.
 *  0b1..Second INV-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_IV1(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_IV1_SHIFT)) & ANACTRL_RINGO0_CTRL_E_IV1_MASK)
#define ANACTRL_RINGO0_CTRL_E_PN0_MASK (0x800U)
#define ANACTRL_RINGO0_CTRL_E_PN0_SHIFT (11U)
/*! E_PN0 - First PN (P-Transistor and N-Transistor processing) monitor control.
 *  0b0..First PN-based ringo is disabled.
 *  0b1..First PN-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_PN0(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_PN0_SHIFT)) & ANACTRL_RINGO0_CTRL_E_PN0_MASK)
#define ANACTRL_RINGO0_CTRL_E_PN1_MASK (0x1000U)
#define ANACTRL_RINGO0_CTRL_E_PN1_SHIFT (12U)
/*! E_PN1 - Second PN (P-Transistor and N-Transistor processing) monitor control.
 *  0b0..Second PN-based ringo is disabled.
 *  0b1..Second PN-based ringo is enabled.
 */
#define ANACTRL_RINGO0_CTRL_E_PN1(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_E_PN1_SHIFT)) & ANACTRL_RINGO0_CTRL_E_PN1_MASK)
#define ANACTRL_RINGO0_CTRL_DIVISOR_MASK (0xF0000U)
#define ANACTRL_RINGO0_CTRL_DIVISOR_SHIFT (16U)
/*! DIVISOR - Ringo out Clock divider value. Frequency Output = Frequency input / (DIViSOR+1). (minimum = Frequency
 * input / 16)
 */
#define ANACTRL_RINGO0_CTRL_DIVISOR(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_DIVISOR_SHIFT)) & ANACTRL_RINGO0_CTRL_DIVISOR_MASK)
#define ANACTRL_RINGO0_CTRL_DIV_UPDATE_REQ_MASK (0x80000000U)
#define ANACTRL_RINGO0_CTRL_DIV_UPDATE_REQ_SHIFT (31U)
/*! DIV_UPDATE_REQ - Ringo clock out Divider status flag. Set when a change is made to the divider
 *    value, cleared when the change is complete.
 */
#define ANACTRL_RINGO0_CTRL_DIV_UPDATE_REQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO0_CTRL_DIV_UPDATE_REQ_SHIFT)) & \
     ANACTRL_RINGO0_CTRL_DIV_UPDATE_REQ_MASK)
/*! @} */

/*! @name RINGO1_CTRL - Second Ring Oscillator module control register. */
/*! @{ */
#define ANACTRL_RINGO1_CTRL_S_MASK (0x1U)
#define ANACTRL_RINGO1_CTRL_S_SHIFT (0U)
/*! S - Select short or long ringo (for all ringos types).
 *  0b0..Select short ringo (few elements).
 *  0b1..Select long ringo (many elements).
 */
#define ANACTRL_RINGO1_CTRL_S(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_S_SHIFT)) & ANACTRL_RINGO1_CTRL_S_MASK)
#define ANACTRL_RINGO1_CTRL_FS_MASK (0x2U)
#define ANACTRL_RINGO1_CTRL_FS_SHIFT (1U)
/*! FS - Ringo frequency output divider.
 *  0b0..High frequency output (frequency lower than 100 MHz).
 *  0b1..Low frequency output (frequency lower than 10 MHz).
 */
#define ANACTRL_RINGO1_CTRL_FS(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_FS_SHIFT)) & ANACTRL_RINGO1_CTRL_FS_MASK)
#define ANACTRL_RINGO1_CTRL_PD_MASK (0x4U)
#define ANACTRL_RINGO1_CTRL_PD_SHIFT (2U)
/*! PD - Ringo module Power control.
 *  0b0..The Ringo module is enabled.
 *  0b1..The Ringo module is disabled.
 */
#define ANACTRL_RINGO1_CTRL_PD(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_PD_SHIFT)) & ANACTRL_RINGO1_CTRL_PD_MASK)
#define ANACTRL_RINGO1_CTRL_E_R24_MASK (0x8U)
#define ANACTRL_RINGO1_CTRL_E_R24_SHIFT (3U)
/*! E_R24 - .
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO1_CTRL_E_R24(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_E_R24_SHIFT)) & ANACTRL_RINGO1_CTRL_E_R24_MASK)
#define ANACTRL_RINGO1_CTRL_E_R35_MASK (0x10U)
#define ANACTRL_RINGO1_CTRL_E_R35_SHIFT (4U)
/*! E_R35 - .
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO1_CTRL_E_R35(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_E_R35_SHIFT)) & ANACTRL_RINGO1_CTRL_E_R35_MASK)
#define ANACTRL_RINGO1_CTRL_E_M2_MASK (0x20U)
#define ANACTRL_RINGO1_CTRL_E_M2_SHIFT (5U)
/*! E_M2 - Metal 2 (M2) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO1_CTRL_E_M2(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_E_M2_SHIFT)) & ANACTRL_RINGO1_CTRL_E_M2_MASK)
#define ANACTRL_RINGO1_CTRL_E_M3_MASK (0x40U)
#define ANACTRL_RINGO1_CTRL_E_M3_SHIFT (6U)
/*! E_M3 - Metal 3 (M3) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO1_CTRL_E_M3(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_E_M3_SHIFT)) & ANACTRL_RINGO1_CTRL_E_M3_MASK)
#define ANACTRL_RINGO1_CTRL_E_M4_MASK (0x80U)
#define ANACTRL_RINGO1_CTRL_E_M4_SHIFT (7U)
/*! E_M4 - Metal 4 (M4) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO1_CTRL_E_M4(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_E_M4_SHIFT)) & ANACTRL_RINGO1_CTRL_E_M4_MASK)
#define ANACTRL_RINGO1_CTRL_E_M5_MASK (0x100U)
#define ANACTRL_RINGO1_CTRL_E_M5_SHIFT (8U)
/*! E_M5 - Metal 5 (M5) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO1_CTRL_E_M5(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_E_M5_SHIFT)) & ANACTRL_RINGO1_CTRL_E_M5_MASK)
#define ANACTRL_RINGO1_CTRL_DIVISOR_MASK (0xF0000U)
#define ANACTRL_RINGO1_CTRL_DIVISOR_SHIFT (16U)
/*! DIVISOR - Ringo out Clock divider value. Frequency Output = Frequency input / (DIViSOR+1). (minimum = Frequency
 * input / 16)
 */
#define ANACTRL_RINGO1_CTRL_DIVISOR(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_DIVISOR_SHIFT)) & ANACTRL_RINGO1_CTRL_DIVISOR_MASK)
#define ANACTRL_RINGO1_CTRL_DIV_UPDATE_REQ_MASK (0x80000000U)
#define ANACTRL_RINGO1_CTRL_DIV_UPDATE_REQ_SHIFT (31U)
/*! DIV_UPDATE_REQ - Ringo clock out Divider status flag. Set when a change is made to the divider
 *    value, cleared when the change is complete.
 */
#define ANACTRL_RINGO1_CTRL_DIV_UPDATE_REQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO1_CTRL_DIV_UPDATE_REQ_SHIFT)) & \
     ANACTRL_RINGO1_CTRL_DIV_UPDATE_REQ_MASK)
/*! @} */

/*! @name RINGO2_CTRL - Third Ring Oscillator module control register. */
/*! @{ */
#define ANACTRL_RINGO2_CTRL_S_MASK (0x1U)
#define ANACTRL_RINGO2_CTRL_S_SHIFT (0U)
/*! S - Select short or long ringo (for all ringos types).
 *  0b0..Select short ringo (few elements).
 *  0b1..Select long ringo (many elements).
 */
#define ANACTRL_RINGO2_CTRL_S(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_S_SHIFT)) & ANACTRL_RINGO2_CTRL_S_MASK)
#define ANACTRL_RINGO2_CTRL_FS_MASK (0x2U)
#define ANACTRL_RINGO2_CTRL_FS_SHIFT (1U)
/*! FS - Ringo frequency output divider.
 *  0b0..High frequency output (frequency lower than 100 MHz).
 *  0b1..Low frequency output (frequency lower than 10 MHz).
 */
#define ANACTRL_RINGO2_CTRL_FS(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_FS_SHIFT)) & ANACTRL_RINGO2_CTRL_FS_MASK)
#define ANACTRL_RINGO2_CTRL_PD_MASK (0x4U)
#define ANACTRL_RINGO2_CTRL_PD_SHIFT (2U)
/*! PD - Ringo module Power control.
 *  0b0..The Ringo module is enabled.
 *  0b1..The Ringo module is disabled.
 */
#define ANACTRL_RINGO2_CTRL_PD(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_PD_SHIFT)) & ANACTRL_RINGO2_CTRL_PD_MASK)
#define ANACTRL_RINGO2_CTRL_E_R24_MASK (0x8U)
#define ANACTRL_RINGO2_CTRL_E_R24_SHIFT (3U)
/*! E_R24 - .
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO2_CTRL_E_R24(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_E_R24_SHIFT)) & ANACTRL_RINGO2_CTRL_E_R24_MASK)
#define ANACTRL_RINGO2_CTRL_E_R35_MASK (0x10U)
#define ANACTRL_RINGO2_CTRL_E_R35_SHIFT (4U)
/*! E_R35 - .
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO2_CTRL_E_R35(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_E_R35_SHIFT)) & ANACTRL_RINGO2_CTRL_E_R35_MASK)
#define ANACTRL_RINGO2_CTRL_E_M2_MASK (0x20U)
#define ANACTRL_RINGO2_CTRL_E_M2_SHIFT (5U)
/*! E_M2 - Metal 2 (M2) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO2_CTRL_E_M2(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_E_M2_SHIFT)) & ANACTRL_RINGO2_CTRL_E_M2_MASK)
#define ANACTRL_RINGO2_CTRL_E_M3_MASK (0x40U)
#define ANACTRL_RINGO2_CTRL_E_M3_SHIFT (6U)
/*! E_M3 - Metal 3 (M3) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO2_CTRL_E_M3(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_E_M3_SHIFT)) & ANACTRL_RINGO2_CTRL_E_M3_MASK)
#define ANACTRL_RINGO2_CTRL_E_M4_MASK (0x80U)
#define ANACTRL_RINGO2_CTRL_E_M4_SHIFT (7U)
/*! E_M4 - Metal 4 (M4) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO2_CTRL_E_M4(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_E_M4_SHIFT)) & ANACTRL_RINGO2_CTRL_E_M4_MASK)
#define ANACTRL_RINGO2_CTRL_E_M5_MASK (0x100U)
#define ANACTRL_RINGO2_CTRL_E_M5_SHIFT (8U)
/*! E_M5 - Metal 5 (M5) monitor control.
 *  0b0..Ringo is disabled.
 *  0b1..Ringo is enabled.
 */
#define ANACTRL_RINGO2_CTRL_E_M5(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_E_M5_SHIFT)) & ANACTRL_RINGO2_CTRL_E_M5_MASK)
#define ANACTRL_RINGO2_CTRL_DIVISOR_MASK (0xF0000U)
#define ANACTRL_RINGO2_CTRL_DIVISOR_SHIFT (16U)
/*! DIVISOR - Ringo out Clock divider value. Frequency Output = Frequency input / (DIViSOR+1). (minimum = Frequency
 * input / 16)
 */
#define ANACTRL_RINGO2_CTRL_DIVISOR(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_DIVISOR_SHIFT)) & ANACTRL_RINGO2_CTRL_DIVISOR_MASK)
#define ANACTRL_RINGO2_CTRL_DIV_UPDATE_REQ_MASK (0x80000000U)
#define ANACTRL_RINGO2_CTRL_DIV_UPDATE_REQ_SHIFT (31U)
/*! DIV_UPDATE_REQ - Ringo clock out Divider status flag. Set when a change is made to the divider
 *    value, cleared when the change is complete.
 */
#define ANACTRL_RINGO2_CTRL_DIV_UPDATE_REQ(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_RINGO2_CTRL_DIV_UPDATE_REQ_SHIFT)) & \
     ANACTRL_RINGO2_CTRL_DIV_UPDATE_REQ_MASK)
/*! @} */

/*! @name USBHS_PHY_CTRL - USB High Speed Phy Control */
/*! @{ */
#define ANACTRL_USBHS_PHY_CTRL_usb_vbusvalid_ext_MASK (0x1U)
#define ANACTRL_USBHS_PHY_CTRL_usb_vbusvalid_ext_SHIFT (0U)
/*! usb_vbusvalid_ext - Override value for Vbus if using external detectors.
 */
#define ANACTRL_USBHS_PHY_CTRL_usb_vbusvalid_ext(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_USBHS_PHY_CTRL_usb_vbusvalid_ext_SHIFT)) & \
     ANACTRL_USBHS_PHY_CTRL_usb_vbusvalid_ext_MASK)
#define ANACTRL_USBHS_PHY_CTRL_usb_id_ext_MASK (0x2U)
#define ANACTRL_USBHS_PHY_CTRL_usb_id_ext_SHIFT (1U)
/*! usb_id_ext - Override value for ID if using external detectors.
 */
#define ANACTRL_USBHS_PHY_CTRL_usb_id_ext(x) \
    (((uint32_t)(((uint32_t)(x)) << ANACTRL_USBHS_PHY_CTRL_usb_id_ext_SHIFT)) & ANACTRL_USBHS_PHY_CTRL_usb_id_ext_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group ANACTRL_Register_Masks */

/* ANACTRL - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral ANACTRL base address */
#define ANACTRL_BASE (0x50013000u)
/** Peripheral ANACTRL base address */
#define ANACTRL_BASE_NS (0x40013000u)
/** Peripheral ANACTRL base pointer */
#define ANACTRL ((ANACTRL_Type *)ANACTRL_BASE)
/** Peripheral ANACTRL base pointer */
#define ANACTRL_NS ((ANACTRL_Type *)ANACTRL_BASE_NS)
/** Array initializer of ANACTRL peripheral base addresses */
#define ANACTRL_BASE_ADDRS \
    {                      \
        ANACTRL_BASE       \
    }
/** Array initializer of ANACTRL peripheral base pointers */
#define ANACTRL_BASE_PTRS \
    {                     \
        ANACTRL           \
    }
/** Array initializer of ANACTRL peripheral base addresses */
#define ANACTRL_BASE_ADDRS_NS \
    {                         \
        ANACTRL_BASE_NS       \
    }
/** Array initializer of ANACTRL peripheral base pointers */
#define ANACTRL_BASE_PTRS_NS \
    {                        \
        ANACTRL_NS           \
    }
#else
/** Peripheral ANACTRL base address */
#define ANACTRL_BASE (0x40013000u)
/** Peripheral ANACTRL base pointer */
#define ANACTRL ((ANACTRL_Type *)ANACTRL_BASE)
/** Array initializer of ANACTRL peripheral base addresses */
#define ANACTRL_BASE_ADDRS \
    {                      \
        ANACTRL_BASE       \
    }
/** Array initializer of ANACTRL peripheral base pointers */
#define ANACTRL_BASE_PTRS \
    {                     \
        ANACTRL           \
    }
#endif

/*!
 * @}
 */ /* end of group ANACTRL_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CASPER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CASPER_Peripheral_Access_Layer CASPER Peripheral Access Layer
 * @{
 */

/** CASPER - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL0;    /**< Contains the offsets of AB and CD in the RAM., offset: 0x0 */
    __IO uint32_t CTRL1;    /**< Contains the opcode mode, iteration count, and result offset (in RAM) and also launches
                               the accelerator. Note: with CP version: CTRL0 and CRTL1 can be written in one go with MCRR.,
                               offset: 0x4 */
    __IO uint32_t LOADER;   /**< Contains an optional loader to load into CTRL0/1 in steps to perform a set of
                               operations., offset: 0x8 */
    __IO uint32_t STATUS;   /**< Indicates operational status and would contain the carry bit if used., offset: 0xC */
    __IO uint32_t INTENSET; /**< Sets interrupts, offset: 0x10 */
    __IO uint32_t INTENCLR; /**< Clears interrupts, offset: 0x14 */
    __I uint32_t INTSTAT;   /**< Interrupt status bits (mask of INTENSET and STATUS), offset: 0x18 */
    uint8_t RESERVED_0[4];
    __IO uint32_t AREG; /**< A register, offset: 0x20 */
    __IO uint32_t BREG; /**< B register, offset: 0x24 */
    __IO uint32_t CREG; /**< C register, offset: 0x28 */
    __IO uint32_t DREG; /**< D register, offset: 0x2C */
    __IO uint32_t RES0; /**< Result register 0, offset: 0x30 */
    __IO uint32_t RES1; /**< Result register 1, offset: 0x34 */
    __IO uint32_t RES2; /**< Result register 2, offset: 0x38 */
    __IO uint32_t RES3; /**< Result register 3, offset: 0x3C */
    uint8_t RESERVED_1[32];
    __IO uint32_t MASK;   /**< Optional mask register, offset: 0x60 */
    __IO uint32_t REMASK; /**< Optional re-mask register, offset: 0x64 */
    uint8_t RESERVED_2[24];
    __IO uint32_t LOCK; /**< Security lock register, offset: 0x80 */
} CASPER_Type;

/* ----------------------------------------------------------------------------
   -- CASPER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CASPER_Register_Masks CASPER Register Masks
 * @{
 */

/*! @name CTRL0 - Contains the offsets of AB and CD in the RAM. */
/*! @{ */
#define CASPER_CTRL0_ABBPAIR_MASK (0x1U)
#define CASPER_CTRL0_ABBPAIR_SHIFT (0U)
/*! ABBPAIR - Which bank-pair the offset ABOFF is within. This must be 0 if only 2-up
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL0_ABBPAIR(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_ABBPAIR_SHIFT)) & CASPER_CTRL0_ABBPAIR_MASK)
#define CASPER_CTRL0_ABOFF_MASK (0x4U)
#define CASPER_CTRL0_ABOFF_SHIFT (2U)
/*! ABOFF - Word or DWord Offset of AB values, with B at [2]=0 and A at [2]=1 as far as the code
 *    sees (normally will be an interleaved bank so only sequential to AHB). Word offset only allowed
 *    if 32 bit operation. Ideally not in the same RAM as the CD values if 4-up
 */
#define CASPER_CTRL0_ABOFF(x) (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_ABOFF_SHIFT)) & CASPER_CTRL0_ABOFF_MASK)
#define CASPER_CTRL0_CDBPAIR_MASK (0x10000U)
#define CASPER_CTRL0_CDBPAIR_SHIFT (16U)
/*! CDBPAIR - Which bank-pair the offset CDOFF is within. This must be 0 if only 2-up
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL0_CDBPAIR(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_CDBPAIR_SHIFT)) & CASPER_CTRL0_CDBPAIR_MASK)
#define CASPER_CTRL0_CDOFF_MASK (0x1FFC0000U)
#define CASPER_CTRL0_CDOFF_SHIFT (18U)
/*! CDOFF - Word or DWord Offset of CD, with D at [2]=0 and C at [2]=1 as far as the code sees
 *    (normally will be an interleaved bank so only sequential to AHB). Word offset only allowed if 32
 *    bit operation. Ideally not in the same RAM as the AB values
 */
#define CASPER_CTRL0_CDOFF(x) (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_CDOFF_SHIFT)) & CASPER_CTRL0_CDOFF_MASK)
/*! @} */

/*! @name CTRL1 - Contains the opcode mode, iteration count, and result offset (in RAM) and also launches the
 * accelerator. Note: with CP version: CTRL0 and CRTL1 can be written in one go with MCRR. */
/*! @{ */
#define CASPER_CTRL1_ITER_MASK (0xFFU)
#define CASPER_CTRL1_ITER_SHIFT (0U)
/*! ITER - Iteration counter. Is number_cycles - 1. write 0 means Does one cycle - does not iterate.
 */
#define CASPER_CTRL1_ITER(x) (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_ITER_SHIFT)) & CASPER_CTRL1_ITER_MASK)
#define CASPER_CTRL1_MODE_MASK (0xFF00U)
#define CASPER_CTRL1_MODE_SHIFT (8U)
/*! MODE - Operation mode to perform. write 0 means Accelerator is inactive. write others means accelerator is active.
 */
#define CASPER_CTRL1_MODE(x) (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_MODE_SHIFT)) & CASPER_CTRL1_MODE_MASK)
#define CASPER_CTRL1_RESBPAIR_MASK (0x10000U)
#define CASPER_CTRL1_RESBPAIR_SHIFT (16U)
/*! RESBPAIR - Which bank-pair the offset RESOFF is within. This must be 0 if only 2-up. Ideally
 *    this is not the same bank as ABBPAIR (when 4-up supported)
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL1_RESBPAIR(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_RESBPAIR_SHIFT)) & CASPER_CTRL1_RESBPAIR_MASK)
#define CASPER_CTRL1_RESOFF_MASK (0x1FFC0000U)
#define CASPER_CTRL1_RESOFF_SHIFT (18U)
/*! RESOFF - Word or DWord Offset of result. Word offset only allowed if 32 bit operation. Ideally
 *    not in the same RAM as the AB and CD values
 */
#define CASPER_CTRL1_RESOFF(x) (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_RESOFF_SHIFT)) & CASPER_CTRL1_RESOFF_MASK)
#define CASPER_CTRL1_CSKIP_MASK (0xC0000000U)
#define CASPER_CTRL1_CSKIP_SHIFT (30U)
/*! CSKIP - Skip rules on Carry if needed. This operation will be skipped based on Carry value (from previous operation)
 * if not 0: 0b00..No Skip 0b01..Skip if Carry is 1 0b10..Skip if Carry is 0 0b11..Set CTRLOFF to CDOFF and Skip
 */
#define CASPER_CTRL1_CSKIP(x) (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_CSKIP_SHIFT)) & CASPER_CTRL1_CSKIP_MASK)
/*! @} */

/*! @name LOADER - Contains an optional loader to load into CTRL0/1 in steps to perform a set of operations. */
/*! @{ */
#define CASPER_LOADER_COUNT_MASK (0xFFU)
#define CASPER_LOADER_COUNT_SHIFT (0U)
/*! COUNT - Number of control pairs to load 0 relative (so 1 means load 1). write 1 means Does one
 *    op - does not iterate, write N means N control pairs to load
 */
#define CASPER_LOADER_COUNT(x) (((uint32_t)(((uint32_t)(x)) << CASPER_LOADER_COUNT_SHIFT)) & CASPER_LOADER_COUNT_MASK)
#define CASPER_LOADER_CTRLBPAIR_MASK (0x10000U)
#define CASPER_LOADER_CTRLBPAIR_SHIFT (16U)
/*! CTRLBPAIR - Which bank-pair the offset CTRLOFF is within. This must be 0 if only 2-up. Does not
 *    matter which bank is used as this is loaded when not performing an operation.
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_LOADER_CTRLBPAIR(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_LOADER_CTRLBPAIR_SHIFT)) & CASPER_LOADER_CTRLBPAIR_MASK)
#define CASPER_LOADER_CTRLOFF_MASK (0x1FFC0000U)
#define CASPER_LOADER_CTRLOFF_SHIFT (18U)
/*! CTRLOFF - DWord Offset of CTRL pair to load next.
 */
#define CASPER_LOADER_CTRLOFF(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_LOADER_CTRLOFF_SHIFT)) & CASPER_LOADER_CTRLOFF_MASK)
/*! @} */

/*! @name STATUS - Indicates operational status and would contain the carry bit if used. */
/*! @{ */
#define CASPER_STATUS_DONE_MASK (0x1U)
#define CASPER_STATUS_DONE_SHIFT (0U)
/*! DONE - Indicates if the accelerator has finished an operation. Write 1 to clear, or write CTRL1 to clear.
 *  0b0..Busy or just cleared
 *  0b1..Completed last operation
 */
#define CASPER_STATUS_DONE(x) (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_DONE_SHIFT)) & CASPER_STATUS_DONE_MASK)
#define CASPER_STATUS_CARRY_MASK (0x10U)
#define CASPER_STATUS_CARRY_SHIFT (4U)
/*! CARRY - Last carry value if operation produced a carry bit
 *  0b0..Carry was 0 or no carry
 *  0b1..Carry was 1
 */
#define CASPER_STATUS_CARRY(x) (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_CARRY_SHIFT)) & CASPER_STATUS_CARRY_MASK)
#define CASPER_STATUS_BUSY_MASK (0x20U)
#define CASPER_STATUS_BUSY_SHIFT (5U)
/*! BUSY - Indicates if the accelerator is busy performing an operation
 *  0b0..Not busy - is idle
 *  0b1..Is busy
 */
#define CASPER_STATUS_BUSY(x) (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_BUSY_SHIFT)) & CASPER_STATUS_BUSY_MASK)
/*! @} */

/*! @name INTENSET - Sets interrupts */
/*! @{ */
#define CASPER_INTENSET_DONE_MASK (0x1U)
#define CASPER_INTENSET_DONE_SHIFT (0U)
/*! DONE - Set if the accelerator should interrupt when done.
 *  0b0..Do not interrupt when done
 *  0b1..Interrupt when done
 */
#define CASPER_INTENSET_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_INTENSET_DONE_SHIFT)) & CASPER_INTENSET_DONE_MASK)
/*! @} */

/*! @name INTENCLR - Clears interrupts */
/*! @{ */
#define CASPER_INTENCLR_DONE_MASK (0x1U)
#define CASPER_INTENCLR_DONE_SHIFT (0U)
/*! DONE - Written to clear an interrupt set with INTENSET.
 *  0b0..If written 0, ignored
 *  0b1..If written 1, do not Interrupt when done
 */
#define CASPER_INTENCLR_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_INTENCLR_DONE_SHIFT)) & CASPER_INTENCLR_DONE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status bits (mask of INTENSET and STATUS) */
/*! @{ */
#define CASPER_INTSTAT_DONE_MASK (0x1U)
#define CASPER_INTSTAT_DONE_SHIFT (0U)
/*! DONE - If set, interrupt is caused by accelerator being done.
 *  0b0..Not caused by accelerator being done
 *  0b1..Caused by accelerator being done
 */
#define CASPER_INTSTAT_DONE(x) (((uint32_t)(((uint32_t)(x)) << CASPER_INTSTAT_DONE_SHIFT)) & CASPER_INTSTAT_DONE_MASK)
/*! @} */

/*! @name AREG - A register */
/*! @{ */
#define CASPER_AREG_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_AREG_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to be fed into Multiplier. Is not normally written or read by application,
 *    but is available when accelerator not busy.
 */
#define CASPER_AREG_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_AREG_REG_VALUE_SHIFT)) & CASPER_AREG_REG_VALUE_MASK)
/*! @} */

/*! @name BREG - B register */
/*! @{ */
#define CASPER_BREG_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_BREG_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to be fed into Multiplier. Is not normally written or read by application,
 *    but is available when accelerator not busy.
 */
#define CASPER_BREG_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_BREG_REG_VALUE_SHIFT)) & CASPER_BREG_REG_VALUE_MASK)
/*! @} */

/*! @name CREG - C register */
/*! @{ */
#define CASPER_CREG_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_CREG_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to be fed into Multiplier. Is not normally written or read by application,
 *    but is available when accelerator not busy.
 */
#define CASPER_CREG_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_CREG_REG_VALUE_SHIFT)) & CASPER_CREG_REG_VALUE_MASK)
/*! @} */

/*! @name DREG - D register */
/*! @{ */
#define CASPER_DREG_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_DREG_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to be fed into Multiplier. Is not normally written or read by application,
 *    but is available when accelerator not busy.
 */
#define CASPER_DREG_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_DREG_REG_VALUE_SHIFT)) & CASPER_DREG_REG_VALUE_MASK)
/*! @} */

/*! @name RES0 - Result register 0 */
/*! @{ */
#define CASPER_RES0_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_RES0_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to hold working result (from multiplier, adder/xor, etc). Is not normally
 *    written or read by application, but is available when accelerator not busy.
 */
#define CASPER_RES0_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_RES0_REG_VALUE_SHIFT)) & CASPER_RES0_REG_VALUE_MASK)
/*! @} */

/*! @name RES1 - Result register 1 */
/*! @{ */
#define CASPER_RES1_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_RES1_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to hold working result (from multiplier, adder/xor, etc). Is not normally
 *    written or read by application, but is available when accelerator not busy.
 */
#define CASPER_RES1_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_RES1_REG_VALUE_SHIFT)) & CASPER_RES1_REG_VALUE_MASK)
/*! @} */

/*! @name RES2 - Result register 2 */
/*! @{ */
#define CASPER_RES2_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_RES2_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to hold working result (from multiplier, adder/xor, etc). Is not normally
 *    written or read by application, but is available when accelerator not busy.
 */
#define CASPER_RES2_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_RES2_REG_VALUE_SHIFT)) & CASPER_RES2_REG_VALUE_MASK)
/*! @} */

/*! @name RES3 - Result register 3 */
/*! @{ */
#define CASPER_RES3_REG_VALUE_MASK (0xFFFFFFFFU)
#define CASPER_RES3_REG_VALUE_SHIFT (0U)
/*! REG_VALUE - Register to hold working result (from multiplier, adder/xor, etc). Is not normally
 *    written or read by application, but is available when accelerator not busy.
 */
#define CASPER_RES3_REG_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << CASPER_RES3_REG_VALUE_SHIFT)) & CASPER_RES3_REG_VALUE_MASK)
/*! @} */

/*! @name MASK - Optional mask register */
/*! @{ */
#define CASPER_MASK_MASK_MASK (0xFFFFFFFFU)
#define CASPER_MASK_MASK_SHIFT (0U)
/*! MASK - Mask to apply as side channel countermeasure. 0: No mask to be used. N: Mask to XOR onto values
 */
#define CASPER_MASK_MASK(x) (((uint32_t)(((uint32_t)(x)) << CASPER_MASK_MASK_SHIFT)) & CASPER_MASK_MASK_MASK)
/*! @} */

/*! @name REMASK - Optional re-mask register */
/*! @{ */
#define CASPER_REMASK_MASK_MASK (0xFFFFFFFFU)
#define CASPER_REMASK_MASK_SHIFT (0U)
/*! MASK - Mask to apply as side channel countermeasure. 0: No mask to be used. N: Mask to XOR onto values
 */
#define CASPER_REMASK_MASK(x) (((uint32_t)(((uint32_t)(x)) << CASPER_REMASK_MASK_SHIFT)) & CASPER_REMASK_MASK_MASK)
/*! @} */

/*! @name LOCK - Security lock register */
/*! @{ */
#define CASPER_LOCK_LOCK_MASK (0x1U)
#define CASPER_LOCK_LOCK_SHIFT (0U)
/*! LOCK - Reads back with security level locked to, or 0. Writes as 0 to unlock, 1 to lock.
 *  0b0..unlock
 *  0b1..Lock to current security level
 */
#define CASPER_LOCK_LOCK(x) (((uint32_t)(((uint32_t)(x)) << CASPER_LOCK_LOCK_SHIFT)) & CASPER_LOCK_LOCK_MASK)
#define CASPER_LOCK_KEY_MASK (0x1FFF0U)
#define CASPER_LOCK_KEY_SHIFT (4U)
/*! KEY - Must be written as 0x73D to change the register.
 *  0b0011100111101..If set during write, will allow lock or unlock
 */
#define CASPER_LOCK_KEY(x) (((uint32_t)(((uint32_t)(x)) << CASPER_LOCK_KEY_SHIFT)) & CASPER_LOCK_KEY_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group CASPER_Register_Masks */

/* CASPER - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral CASPER base address */
#define CASPER_BASE (0x500A5000u)
/** Peripheral CASPER base address */
#define CASPER_BASE_NS (0x400A5000u)
/** Peripheral CASPER base pointer */
#define CASPER ((CASPER_Type *)CASPER_BASE)
/** Peripheral CASPER base pointer */
#define CASPER_NS ((CASPER_Type *)CASPER_BASE_NS)
/** Array initializer of CASPER peripheral base addresses */
#define CASPER_BASE_ADDRS \
    {                     \
        CASPER_BASE       \
    }
/** Array initializer of CASPER peripheral base pointers */
#define CASPER_BASE_PTRS \
    {                    \
        CASPER           \
    }
/** Array initializer of CASPER peripheral base addresses */
#define CASPER_BASE_ADDRS_NS \
    {                        \
        CASPER_BASE_NS       \
    }
/** Array initializer of CASPER peripheral base pointers */
#define CASPER_BASE_PTRS_NS \
    {                       \
        CASPER_NS           \
    }
#else
/** Peripheral CASPER base address */
#define CASPER_BASE (0x400A5000u)
/** Peripheral CASPER base pointer */
#define CASPER ((CASPER_Type *)CASPER_BASE)
/** Array initializer of CASPER peripheral base addresses */
#define CASPER_BASE_ADDRS \
    {                     \
        CASPER_BASE       \
    }
/** Array initializer of CASPER peripheral base pointers */
#define CASPER_BASE_PTRS \
    {                    \
        CASPER           \
    }
#endif

/*!
 * @}
 */ /* end of group CASPER_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct
{
    __IO uint32_t MODE; /**< CRC mode register, offset: 0x0 */
    __IO uint32_t SEED; /**< CRC seed register, offset: 0x4 */
    union
    {                         /* offset: 0x8 */
        __I uint32_t SUM;     /**< CRC checksum register, offset: 0x8 */
        __O uint32_t WR_DATA; /**< CRC data register, offset: 0x8 */
    };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name MODE - CRC mode register */
/*! @{ */
#define CRC_MODE_CRC_POLY_MASK (0x3U)
#define CRC_MODE_CRC_POLY_SHIFT (0U)
/*! CRC_POLY - CRC polynomial: 1X = CRC-32 polynomial 01 = CRC-16 polynomial 00 = CRC-CCITT polynomial
 */
#define CRC_MODE_CRC_POLY(x) (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CRC_POLY_SHIFT)) & CRC_MODE_CRC_POLY_MASK)
#define CRC_MODE_BIT_RVS_WR_MASK (0x4U)
#define CRC_MODE_BIT_RVS_WR_SHIFT (2U)
/*! BIT_RVS_WR - Data bit order: 1 = Bit order reverse for CRC_WR_DATA (per byte) 0 = No bit order reverse for
 * CRC_WR_DATA (per byte)
 */
#define CRC_MODE_BIT_RVS_WR(x) (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_WR_SHIFT)) & CRC_MODE_BIT_RVS_WR_MASK)
#define CRC_MODE_CMPL_WR_MASK (0x8U)
#define CRC_MODE_CMPL_WR_SHIFT (3U)
/*! CMPL_WR - Data complement: 1 = 1's complement for CRC_WR_DATA 0 = No 1's complement for CRC_WR_DATA
 */
#define CRC_MODE_CMPL_WR(x) (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_WR_SHIFT)) & CRC_MODE_CMPL_WR_MASK)
#define CRC_MODE_BIT_RVS_SUM_MASK (0x10U)
#define CRC_MODE_BIT_RVS_SUM_SHIFT (4U)
/*! BIT_RVS_SUM - CRC sum bit order: 1 = Bit order reverse for CRC_SUM 0 = No bit order reverse for CRC_SUM
 */
#define CRC_MODE_BIT_RVS_SUM(x) \
    (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_SUM_SHIFT)) & CRC_MODE_BIT_RVS_SUM_MASK)
#define CRC_MODE_CMPL_SUM_MASK (0x20U)
#define CRC_MODE_CMPL_SUM_SHIFT (5U)
/*! CMPL_SUM - CRC sum complement: 1 = 1's complement for CRC_SUM 0 = No 1's complement for CRC_SUM
 */
#define CRC_MODE_CMPL_SUM(x) (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_SUM_SHIFT)) & CRC_MODE_CMPL_SUM_MASK)
/*! @} */

/*! @name SEED - CRC seed register */
/*! @{ */
#define CRC_SEED_CRC_SEED_MASK (0xFFFFFFFFU)
#define CRC_SEED_CRC_SEED_SHIFT (0U)
/*! CRC_SEED - A write access to this register will load CRC seed value to CRC_SUM register with
 *    selected bit order and 1's complement pre-processes. A write access to this register will
 *    overrule the CRC calculation in progresses.
 */
#define CRC_SEED_CRC_SEED(x) (((uint32_t)(((uint32_t)(x)) << CRC_SEED_CRC_SEED_SHIFT)) & CRC_SEED_CRC_SEED_MASK)
/*! @} */

/*! @name SUM - CRC checksum register */
/*! @{ */
#define CRC_SUM_CRC_SUM_MASK (0xFFFFFFFFU)
#define CRC_SUM_CRC_SUM_SHIFT (0U)
/*! CRC_SUM - The most recent CRC sum can be read through this register with selected bit order and 1's complement
 * post-processes.
 */
#define CRC_SUM_CRC_SUM(x) (((uint32_t)(((uint32_t)(x)) << CRC_SUM_CRC_SUM_SHIFT)) & CRC_SUM_CRC_SUM_MASK)
/*! @} */

/*! @name WR_DATA - CRC data register */
/*! @{ */
#define CRC_WR_DATA_CRC_WR_DATA_MASK (0xFFFFFFFFU)
#define CRC_WR_DATA_CRC_WR_DATA_SHIFT (0U)
/*! CRC_WR_DATA - Data written to this register will be taken to perform CRC calculation with
 *    selected bit order and 1's complement pre-process. Any write size 8, 16 or 32-bit are allowed and
 *    accept back-to-back transactions.
 */
#define CRC_WR_DATA_CRC_WR_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << CRC_WR_DATA_CRC_WR_DATA_SHIFT)) & CRC_WR_DATA_CRC_WR_DATA_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group CRC_Register_Masks */

/* CRC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral CRC_ENGINE base address */
#define CRC_ENGINE_BASE (0x50095000u)
/** Peripheral CRC_ENGINE base address */
#define CRC_ENGINE_BASE_NS (0x40095000u)
/** Peripheral CRC_ENGINE base pointer */
#define CRC_ENGINE ((CRC_Type *)CRC_ENGINE_BASE)
/** Peripheral CRC_ENGINE base pointer */
#define CRC_ENGINE_NS ((CRC_Type *)CRC_ENGINE_BASE_NS)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS  \
    {                   \
        CRC_ENGINE_BASE \
    }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS \
    {                 \
        CRC_ENGINE    \
    }
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS_NS  \
    {                      \
        CRC_ENGINE_BASE_NS \
    }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS_NS \
    {                    \
        CRC_ENGINE_NS    \
    }
#else
/** Peripheral CRC_ENGINE base address */
#define CRC_ENGINE_BASE (0x40095000u)
/** Peripheral CRC_ENGINE base pointer */
#define CRC_ENGINE ((CRC_Type *)CRC_ENGINE_BASE)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS  \
    {                   \
        CRC_ENGINE_BASE \
    }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS \
    {                 \
        CRC_ENGINE    \
    }
#endif

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct
{
    __IO uint32_t IR; /**< Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify
                         which of eight possible interrupt sources are pending., offset: 0x0 */
    __IO uint32_t TCR; /**< Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer
                          Counter can be disabled or reset through the TCR., offset: 0x4 */
    __IO uint32_t TC;  /**< Timer Counter, offset: 0x8 */
    __IO uint32_t PR;  /**< Prescale Register, offset: 0xC */
    __IO uint32_t PC;  /**< Prescale Counter, offset: 0x10 */
    __IO uint32_t MCR; /**< Match Control Register, offset: 0x14 */
    __IO uint32_t
        MR[4]; /**< Match Register . MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or
                  generate an interrupt every time MR matches the TC., array offset: 0x18, array step: 0x4 */
    __IO uint32_t CCR;  /**< Capture Control Register. The CCR controls which edges of the capture inputs are used to
                           load the Capture Registers and whether or not an interrupt is generated when a capture takes
                           place., offset: 0x28 */
    __I uint32_t CR[4]; /**< Capture Register . CR is loaded with the value of TC when there is an event on the CAPn.
                           input., array offset: 0x2C, array step: 0x4 */
    __IO uint32_t EMR;  /**< External Match Register. The EMR controls the match function and the external match pins.,
                           offset: 0x3C */
    uint8_t RESERVED_0[48];
    __IO uint32_t CTCR; /**< Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter
                           mode selects the signal and edge(s) for counting., offset: 0x70 */
    __IO uint32_t
        PWMC; /**< PWM Control Register. This register enables PWM mode for the external match pins., offset: 0x74 */
    __IO uint32_t MSR[4]; /**< Match Shadow Register, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of
 * eight possible interrupt sources are pending. */
/*! @{ */
#define CTIMER_IR_MR0INT_MASK (0x1U)
#define CTIMER_IR_MR0INT_SHIFT (0U)
/*! MR0INT - Interrupt flag for match channel 0.
 */
#define CTIMER_IR_MR0INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)
#define CTIMER_IR_MR1INT_MASK (0x2U)
#define CTIMER_IR_MR1INT_SHIFT (1U)
/*! MR1INT - Interrupt flag for match channel 1.
 */
#define CTIMER_IR_MR1INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)
#define CTIMER_IR_MR2INT_MASK (0x4U)
#define CTIMER_IR_MR2INT_SHIFT (2U)
/*! MR2INT - Interrupt flag for match channel 2.
 */
#define CTIMER_IR_MR2INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)
#define CTIMER_IR_MR3INT_MASK (0x8U)
#define CTIMER_IR_MR3INT_SHIFT (3U)
/*! MR3INT - Interrupt flag for match channel 3.
 */
#define CTIMER_IR_MR3INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)
#define CTIMER_IR_CR0INT_MASK (0x10U)
#define CTIMER_IR_CR0INT_SHIFT (4U)
/*! CR0INT - Interrupt flag for capture channel 0 event.
 */
#define CTIMER_IR_CR0INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)
#define CTIMER_IR_CR1INT_MASK (0x20U)
#define CTIMER_IR_CR1INT_SHIFT (5U)
/*! CR1INT - Interrupt flag for capture channel 1 event.
 */
#define CTIMER_IR_CR1INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)
#define CTIMER_IR_CR2INT_MASK (0x40U)
#define CTIMER_IR_CR2INT_SHIFT (6U)
/*! CR2INT - Interrupt flag for capture channel 2 event.
 */
#define CTIMER_IR_CR2INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)
#define CTIMER_IR_CR3INT_MASK (0x80U)
#define CTIMER_IR_CR3INT_SHIFT (7U)
/*! CR3INT - Interrupt flag for capture channel 3 event.
 */
#define CTIMER_IR_CR3INT(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be
 * disabled or reset through the TCR. */
/*! @{ */
#define CTIMER_TCR_CEN_MASK (0x1U)
#define CTIMER_TCR_CEN_SHIFT (0U)
/*! CEN - Counter enable.
 *  0b0..Disabled.The counters are disabled.
 *  0b1..Enabled. The Timer Counter and Prescale Counter are enabled.
 */
#define CTIMER_TCR_CEN(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)
#define CTIMER_TCR_CRST_MASK (0x2U)
#define CTIMER_TCR_CRST_SHIFT (1U)
/*! CRST - Counter reset.
 *  0b0..Disabled. Do nothing.
 *  0b1..Enabled. The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of
 *       the APB bus clock. The counters remain reset until TCR[1] is returned to zero.
 */
#define CTIMER_TCR_CRST(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */
#define CTIMER_TC_TCVAL_MASK (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT (0U)
/*! TCVAL - Timer counter value.
 */
#define CTIMER_TC_TCVAL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale Register */
/*! @{ */
#define CTIMER_PR_PRVAL_MASK (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT (0U)
/*! PRVAL - Prescale counter value.
 */
#define CTIMER_PR_PRVAL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter */
/*! @{ */
#define CTIMER_PC_PCVAL_MASK (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT (0U)
/*! PCVAL - Prescale counter value.
 */
#define CTIMER_PC_PCVAL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control Register */
/*! @{ */
#define CTIMER_MCR_MR0I_MASK (0x1U)
#define CTIMER_MCR_MR0I_SHIFT (0U)
/*! MR0I - Interrupt on MR0: an interrupt is generated when MR0 matches the value in the TC.
 */
#define CTIMER_MCR_MR0I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)
#define CTIMER_MCR_MR0R_MASK (0x2U)
#define CTIMER_MCR_MR0R_SHIFT (1U)
/*! MR0R - Reset on MR0: the TC will be reset if MR0 matches it.
 */
#define CTIMER_MCR_MR0R(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)
#define CTIMER_MCR_MR0S_MASK (0x4U)
#define CTIMER_MCR_MR0S_SHIFT (2U)
/*! MR0S - Stop on MR0: the TC and PC will be stopped and TCR[0] will be set to 0 if MR0 matches the TC.
 */
#define CTIMER_MCR_MR0S(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)
#define CTIMER_MCR_MR1I_MASK (0x8U)
#define CTIMER_MCR_MR1I_SHIFT (3U)
/*! MR1I - Interrupt on MR1: an interrupt is generated when MR1 matches the value in the TC.
 */
#define CTIMER_MCR_MR1I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)
#define CTIMER_MCR_MR1R_MASK (0x10U)
#define CTIMER_MCR_MR1R_SHIFT (4U)
/*! MR1R - Reset on MR1: the TC will be reset if MR1 matches it.
 */
#define CTIMER_MCR_MR1R(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)
#define CTIMER_MCR_MR1S_MASK (0x20U)
#define CTIMER_MCR_MR1S_SHIFT (5U)
/*! MR1S - Stop on MR1: the TC and PC will be stopped and TCR[0] will be set to 0 if MR1 matches the TC.
 */
#define CTIMER_MCR_MR1S(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)
#define CTIMER_MCR_MR2I_MASK (0x40U)
#define CTIMER_MCR_MR2I_SHIFT (6U)
/*! MR2I - Interrupt on MR2: an interrupt is generated when MR2 matches the value in the TC.
 */
#define CTIMER_MCR_MR2I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)
#define CTIMER_MCR_MR2R_MASK (0x80U)
#define CTIMER_MCR_MR2R_SHIFT (7U)
/*! MR2R - Reset on MR2: the TC will be reset if MR2 matches it.
 */
#define CTIMER_MCR_MR2R(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)
#define CTIMER_MCR_MR2S_MASK (0x100U)
#define CTIMER_MCR_MR2S_SHIFT (8U)
/*! MR2S - Stop on MR2: the TC and PC will be stopped and TCR[0] will be set to 0 if MR2 matches the TC.
 */
#define CTIMER_MCR_MR2S(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)
#define CTIMER_MCR_MR3I_MASK (0x200U)
#define CTIMER_MCR_MR3I_SHIFT (9U)
/*! MR3I - Interrupt on MR3: an interrupt is generated when MR3 matches the value in the TC.
 */
#define CTIMER_MCR_MR3I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)
#define CTIMER_MCR_MR3R_MASK (0x400U)
#define CTIMER_MCR_MR3R_SHIFT (10U)
/*! MR3R - Reset on MR3: the TC will be reset if MR3 matches it.
 */
#define CTIMER_MCR_MR3R(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)
#define CTIMER_MCR_MR3S_MASK (0x800U)
#define CTIMER_MCR_MR3S_SHIFT (11U)
/*! MR3S - Stop on MR3: the TC and PC will be stopped and TCR[0] will be set to 0 if MR3 matches the TC.
 */
#define CTIMER_MCR_MR3S(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)
#define CTIMER_MCR_MR0RL_MASK (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT (24U)
/*! MR0RL - Reload MR0 with the contents of the Match 0 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR0RL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)
#define CTIMER_MCR_MR1RL_MASK (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT (25U)
/*! MR1RL - Reload MR1 with the contents of the Match 1 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR1RL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)
#define CTIMER_MCR_MR2RL_MASK (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT (26U)
/*! MR2RL - Reload MR2 with the contents of the Match 2 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR2RL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)
#define CTIMER_MCR_MR3RL_MASK (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT (27U)
/*! MR3RL - Reload MR3 with the contents of the Match 3 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR3RL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match Register . MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or
 * generate an interrupt every time MR matches the TC. */
/*! @{ */
#define CTIMER_MR_MATCH_MASK (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT (0U)
/*! MATCH - Timer counter match value.
 */
#define CTIMER_MR_MATCH(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT (4U)

/*! @name CCR - Capture Control Register. The CCR controls which edges of the capture inputs are used to load the
 * Capture Registers and whether or not an interrupt is generated when a capture takes place. */
/*! @{ */
#define CTIMER_CCR_CAP0RE_MASK (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT (0U)
/*! CAP0RE - Rising edge of capture channel 0: a sequence of 0 then 1 causes CR0 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP0RE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)
#define CTIMER_CCR_CAP0FE_MASK (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT (1U)
/*! CAP0FE - Falling edge of capture channel 0: a sequence of 1 then 0 causes CR0 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP0FE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)
#define CTIMER_CCR_CAP0I_MASK (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT (2U)
/*! CAP0I - Generate interrupt on channel 0 capture event: a CR0 load generates an interrupt.
 */
#define CTIMER_CCR_CAP0I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)
#define CTIMER_CCR_CAP1RE_MASK (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT (3U)
/*! CAP1RE - Rising edge of capture channel 1: a sequence of 0 then 1 causes CR1 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP1RE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)
#define CTIMER_CCR_CAP1FE_MASK (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT (4U)
/*! CAP1FE - Falling edge of capture channel 1: a sequence of 1 then 0 causes CR1 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP1FE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)
#define CTIMER_CCR_CAP1I_MASK (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT (5U)
/*! CAP1I - Generate interrupt on channel 1 capture event: a CR1 load generates an interrupt.
 */
#define CTIMER_CCR_CAP1I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)
#define CTIMER_CCR_CAP2RE_MASK (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT (6U)
/*! CAP2RE - Rising edge of capture channel 2: a sequence of 0 then 1 causes CR2 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP2RE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)
#define CTIMER_CCR_CAP2FE_MASK (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT (7U)
/*! CAP2FE - Falling edge of capture channel 2: a sequence of 1 then 0 causes CR2 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP2FE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)
#define CTIMER_CCR_CAP2I_MASK (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT (8U)
/*! CAP2I - Generate interrupt on channel 2 capture event: a CR2 load generates an interrupt.
 */
#define CTIMER_CCR_CAP2I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)
#define CTIMER_CCR_CAP3RE_MASK (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT (9U)
/*! CAP3RE - Rising edge of capture channel 3: a sequence of 0 then 1 causes CR3 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP3RE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)
#define CTIMER_CCR_CAP3FE_MASK (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT (10U)
/*! CAP3FE - Falling edge of capture channel 3: a sequence of 1 then 0 causes CR3 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP3FE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)
#define CTIMER_CCR_CAP3I_MASK (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT (11U)
/*! CAP3I - Generate interrupt on channel 3 capture event: a CR3 load generates an interrupt.
 */
#define CTIMER_CCR_CAP3I(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture Register . CR is loaded with the value of TC when there is an event on the CAPn. input. */
/*! @{ */
#define CTIMER_CR_CAP_MASK (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT (0U)
/*! CAP - Timer counter capture value.
 */
#define CTIMER_CR_CAP(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT (4U)

/*! @name EMR - External Match Register. The EMR controls the match function and the external match pins. */
/*! @{ */
#define CTIMER_EMR_EM0_MASK (0x1U)
#define CTIMER_EMR_EM0_SHIFT (0U)
/*! EM0 - External Match 0. This bit reflects the state of output MAT0, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR0, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[5:4]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM0(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)
#define CTIMER_EMR_EM1_MASK (0x2U)
#define CTIMER_EMR_EM1_SHIFT (1U)
/*! EM1 - External Match 1. This bit reflects the state of output MAT1, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR1, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[7:6]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM1(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)
#define CTIMER_EMR_EM2_MASK (0x4U)
#define CTIMER_EMR_EM2_SHIFT (2U)
/*! EM2 - External Match 2. This bit reflects the state of output MAT2, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR2, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[9:8]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM2(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)
#define CTIMER_EMR_EM3_MASK (0x8U)
#define CTIMER_EMR_EM3_SHIFT (3U)
/*! EM3 - External Match 3. This bit reflects the state of output MAT3, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR3, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by MR[11:10]. This bit is driven to the MAT pins
 *    if the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM3(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)
#define CTIMER_EMR_EMC0_MASK (0x30U)
#define CTIMER_EMR_EMC0_SHIFT (4U)
/*! EMC0 - External Match Control 0. Determines the functionality of External Match 0.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC0(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)
#define CTIMER_EMR_EMC1_MASK (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT (6U)
/*! EMC1 - External Match Control 1. Determines the functionality of External Match 1.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC1(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)
#define CTIMER_EMR_EMC2_MASK (0x300U)
#define CTIMER_EMR_EMC2_SHIFT (8U)
/*! EMC2 - External Match Control 2. Determines the functionality of External Match 2.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC2(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)
#define CTIMER_EMR_EMC3_MASK (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT (10U)
/*! EMC3 - External Match Control 3. Determines the functionality of External Match 3.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC3(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects
 * the signal and edge(s) for counting. */
/*! @{ */
#define CTIMER_CTCR_CTMODE_MASK (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT (0U)
/*! CTMODE - Counter/Timer Mode This field selects which rising APB bus clock edges can increment
 *    Timer's Prescale Counter (PC), or clear PC and increment Timer Counter (TC). Timer Mode: the TC
 *    is incremented when the Prescale Counter matches the Prescale Register.
 *  0b00..Timer Mode. Incremented every rising APB bus clock edge.
 *  0b01..Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
 *  0b10..Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
 *  0b11..Counter Mode dual edge. TC is incremented on both edges on the CAP input selected by bits 3:2.
 */
#define CTIMER_CTCR_CTMODE(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)
#define CTIMER_CTCR_CINSEL_MASK (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT (2U)
/*! CINSEL - Count Input Select When bits 1:0 in this register are not 00, these bits select which
 *    CAP pin is sampled for clocking. Note: If Counter mode is selected for a particular CAPn input
 *    in the CTCR, the 3 bits for that input in the Capture Control Register (CCR) must be
 *    programmed as 000. However, capture and/or interrupt can be selected for the other 3 CAPn inputs in the
 *    same timer.
 *  0b00..Channel 0. CAPn.0 for CTIMERn
 *  0b01..Channel 1. CAPn.1 for CTIMERn
 *  0b10..Channel 2. CAPn.2 for CTIMERn
 *  0b11..Channel 3. CAPn.3 for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)
#define CTIMER_CTCR_ENCC_MASK (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT (4U)
/*! ENCC - Setting this bit to 1 enables clearing of the timer and the prescaler when the
 *    capture-edge event specified in bits 7:5 occurs.
 */
#define CTIMER_CTCR_ENCC(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)
#define CTIMER_CTCR_SELCC_MASK (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT (5U)
/*! SELCC - Edge select. When bit 4 is 1, these bits select which capture input edge will cause the
 *    timer and prescaler to be cleared. These bits have no effect when bit 4 is low. Values 0x2 to
 *    0x3 and 0x6 to 0x7 are reserved.
 *  0b000..Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b001..Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b010..Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b011..Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b100..Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 *  0b101..Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 */
#define CTIMER_CTCR_SELCC(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control Register. This register enables PWM mode for the external match pins. */
/*! @{ */
#define CTIMER_PWMC_PWMEN0_MASK (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT (0U)
/*! PWMEN0 - PWM mode enable for channel0.
 *  0b0..Match. CTIMERn_MAT0 is controlled by EM0.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT0.
 */
#define CTIMER_PWMC_PWMEN0(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)
#define CTIMER_PWMC_PWMEN1_MASK (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT (1U)
/*! PWMEN1 - PWM mode enable for channel1.
 *  0b0..Match. CTIMERn_MAT01 is controlled by EM1.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT1.
 */
#define CTIMER_PWMC_PWMEN1(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)
#define CTIMER_PWMC_PWMEN2_MASK (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT (2U)
/*! PWMEN2 - PWM mode enable for channel2.
 *  0b0..Match. CTIMERn_MAT2 is controlled by EM2.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT2.
 */
#define CTIMER_PWMC_PWMEN2(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)
#define CTIMER_PWMC_PWMEN3_MASK (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT (3U)
/*! PWMEN3 - PWM mode enable for channel3. Note: It is recommended to use match channel 3 to set the PWM cycle.
 *  0b0..Match. CTIMERn_MAT3 is controlled by EM3.
 *  0b1..PWM. PWM mode is enabled for CT132Bn_MAT3.
 */
#define CTIMER_PWMC_PWMEN3(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow Register */
/*! @{ */
#define CTIMER_MSR_SHADOW_MASK (0xFFFFFFFFU)
#define CTIMER_MSR_SHADOW_SHIFT (0U)
/*! SHADOW - Timer counter match shadow value.
 */
#define CTIMER_MSR_SHADOW(x) (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_SHADOW_SHIFT)) & CTIMER_MSR_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT (4U)

/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */

/* CTIMER - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE (0x50008000u)
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE_NS (0x40008000u)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0 ((CTIMER_Type *)CTIMER0_BASE)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0_NS ((CTIMER_Type *)CTIMER0_BASE_NS)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE (0x50009000u)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE_NS (0x40009000u)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1 ((CTIMER_Type *)CTIMER1_BASE)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1_NS ((CTIMER_Type *)CTIMER1_BASE_NS)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE (0x50028000u)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE_NS (0x40028000u)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2 ((CTIMER_Type *)CTIMER2_BASE)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2_NS ((CTIMER_Type *)CTIMER2_BASE_NS)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE (0x50029000u)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE_NS (0x40029000u)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3 ((CTIMER_Type *)CTIMER3_BASE)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3_NS ((CTIMER_Type *)CTIMER3_BASE_NS)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE (0x5002A000u)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE_NS (0x4002A000u)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4 ((CTIMER_Type *)CTIMER4_BASE)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4_NS ((CTIMER_Type *)CTIMER4_BASE_NS)
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS                                                    \
    {                                                                        \
        CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE \
    }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS                            \
    {                                               \
        CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 \
    }
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS_NS                                                                \
    {                                                                                       \
        CTIMER0_BASE_NS, CTIMER1_BASE_NS, CTIMER2_BASE_NS, CTIMER3_BASE_NS, CTIMER4_BASE_NS \
    }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS_NS                                        \
    {                                                              \
        CTIMER0_NS, CTIMER1_NS, CTIMER2_NS, CTIMER3_NS, CTIMER4_NS \
    }
#else
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE (0x40008000u)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0 ((CTIMER_Type *)CTIMER0_BASE)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE (0x40009000u)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1 ((CTIMER_Type *)CTIMER1_BASE)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE (0x40028000u)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2 ((CTIMER_Type *)CTIMER2_BASE)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE (0x40029000u)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3 ((CTIMER_Type *)CTIMER3_BASE)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE (0x4002A000u)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4 ((CTIMER_Type *)CTIMER4_BASE)
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS                                                    \
    {                                                                        \
        CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE \
    }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS                            \
    {                                               \
        CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 \
    }
#endif
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                                                          \
    {                                                                        \
        CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn \
    }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- DBGMAILBOX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DBGMAILBOX_Peripheral_Access_Layer DBGMAILBOX Peripheral Access Layer
 * @{
 */

/** DBGMAILBOX - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CSW;     /**< CRC mode register, offset: 0x0 */
    __IO uint32_t REQUEST; /**< CRC seed register, offset: 0x4 */
    __IO uint32_t RETURN;  /**< Return value from ROM., offset: 0x8 */
    uint8_t RESERVED_0[240];
    __I uint32_t ID; /**< Identification register, offset: 0xFC */
} DBGMAILBOX_Type;

/* ----------------------------------------------------------------------------
   -- DBGMAILBOX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DBGMAILBOX_Register_Masks DBGMAILBOX Register Masks
 * @{
 */

/*! @name CSW - CRC mode register */
/*! @{ */
#define DBGMAILBOX_CSW_RESYNCH_REQ_MASK (0x1U)
#define DBGMAILBOX_CSW_RESYNCH_REQ_SHIFT (0U)
/*! RESYNCH_REQ - Debugger will set this bit to 1 to request a resynchronrisation
 */
#define DBGMAILBOX_CSW_RESYNCH_REQ(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_CSW_RESYNCH_REQ_SHIFT)) & DBGMAILBOX_CSW_RESYNCH_REQ_MASK)
#define DBGMAILBOX_CSW_REQ_PENDING_MASK (0x2U)
#define DBGMAILBOX_CSW_REQ_PENDING_SHIFT (1U)
/*! REQ_PENDING - Request is pending from debugger (i.e unread value in REQUEST)
 */
#define DBGMAILBOX_CSW_REQ_PENDING(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_CSW_REQ_PENDING_SHIFT)) & DBGMAILBOX_CSW_REQ_PENDING_MASK)
#define DBGMAILBOX_CSW_DBG_OR_ERR_MASK (0x4U)
#define DBGMAILBOX_CSW_DBG_OR_ERR_SHIFT (2U)
/*! DBG_OR_ERR - Debugger overrun error (previous REQUEST overwritten before being picked up by ROM)
 */
#define DBGMAILBOX_CSW_DBG_OR_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_CSW_DBG_OR_ERR_SHIFT)) & DBGMAILBOX_CSW_DBG_OR_ERR_MASK)
#define DBGMAILBOX_CSW_AHB_OR_ERR_MASK (0x8U)
#define DBGMAILBOX_CSW_AHB_OR_ERR_SHIFT (3U)
/*! AHB_OR_ERR - AHB overrun Error (Return value overwritten by ROM)
 */
#define DBGMAILBOX_CSW_AHB_OR_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_CSW_AHB_OR_ERR_SHIFT)) & DBGMAILBOX_CSW_AHB_OR_ERR_MASK)
#define DBGMAILBOX_CSW_SOFT_RESET_MASK (0x10U)
#define DBGMAILBOX_CSW_SOFT_RESET_SHIFT (4U)
/*! SOFT_RESET - Soft Reset for DM (write-only from AHB, not readable and selfclearing). A write to
 *    this bit will cause a soft reset for DM.
 */
#define DBGMAILBOX_CSW_SOFT_RESET(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_CSW_SOFT_RESET_SHIFT)) & DBGMAILBOX_CSW_SOFT_RESET_MASK)
#define DBGMAILBOX_CSW_CHIP_RESET_REQ_MASK (0x20U)
#define DBGMAILBOX_CSW_CHIP_RESET_REQ_SHIFT (5U)
/*! CHIP_RESET_REQ - Write only bit. Once written will cause the chip to reset (note that the DM is
 *    not reset by this reset as it is only resettable by a SOFT reset or a POR/BOD event)
 */
#define DBGMAILBOX_CSW_CHIP_RESET_REQ(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_CSW_CHIP_RESET_REQ_SHIFT)) & DBGMAILBOX_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - CRC seed register */
/*! @{ */
#define DBGMAILBOX_REQUEST_REQ_MASK (0xFFFFFFFFU)
#define DBGMAILBOX_REQUEST_REQ_SHIFT (0U)
/*! REQ - Request Value
 */
#define DBGMAILBOX_REQUEST_REQ(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_REQUEST_REQ_SHIFT)) & DBGMAILBOX_REQUEST_REQ_MASK)
/*! @} */

/*! @name RETURN - Return value from ROM. */
/*! @{ */
#define DBGMAILBOX_RETURN_RET_MASK (0xFFFFFFFFU)
#define DBGMAILBOX_RETURN_RET_SHIFT (0U)
/*! RET - The Return value from ROM.
 */
#define DBGMAILBOX_RETURN_RET(x) \
    (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_RETURN_RET_SHIFT)) & DBGMAILBOX_RETURN_RET_MASK)
/*! @} */

/*! @name ID - Identification register */
/*! @{ */
#define DBGMAILBOX_ID_ID_MASK (0xFFFFFFFFU)
#define DBGMAILBOX_ID_ID_SHIFT (0U)
/*! ID - Identification value.
 */
#define DBGMAILBOX_ID_ID(x) (((uint32_t)(((uint32_t)(x)) << DBGMAILBOX_ID_ID_SHIFT)) & DBGMAILBOX_ID_ID_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group DBGMAILBOX_Register_Masks */

/* DBGMAILBOX - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral DBGMAILBOX base address */
#define DBGMAILBOX_BASE (0x5009C000u)
/** Peripheral DBGMAILBOX base address */
#define DBGMAILBOX_BASE_NS (0x4009C000u)
/** Peripheral DBGMAILBOX base pointer */
#define DBGMAILBOX ((DBGMAILBOX_Type *)DBGMAILBOX_BASE)
/** Peripheral DBGMAILBOX base pointer */
#define DBGMAILBOX_NS ((DBGMAILBOX_Type *)DBGMAILBOX_BASE_NS)
/** Array initializer of DBGMAILBOX peripheral base addresses */
#define DBGMAILBOX_BASE_ADDRS \
    {                         \
        DBGMAILBOX_BASE       \
    }
/** Array initializer of DBGMAILBOX peripheral base pointers */
#define DBGMAILBOX_BASE_PTRS \
    {                        \
        DBGMAILBOX           \
    }
/** Array initializer of DBGMAILBOX peripheral base addresses */
#define DBGMAILBOX_BASE_ADDRS_NS \
    {                            \
        DBGMAILBOX_BASE_NS       \
    }
/** Array initializer of DBGMAILBOX peripheral base pointers */
#define DBGMAILBOX_BASE_PTRS_NS \
    {                           \
        DBGMAILBOX_NS           \
    }
#else
/** Peripheral DBGMAILBOX base address */
#define DBGMAILBOX_BASE (0x4009C000u)
/** Peripheral DBGMAILBOX base pointer */
#define DBGMAILBOX ((DBGMAILBOX_Type *)DBGMAILBOX_BASE)
/** Array initializer of DBGMAILBOX peripheral base addresses */
#define DBGMAILBOX_BASE_ADDRS \
    {                         \
        DBGMAILBOX_BASE       \
    }
/** Array initializer of DBGMAILBOX peripheral base pointers */
#define DBGMAILBOX_BASE_PTRS \
    {                        \
        DBGMAILBOX           \
    }
#endif

/*!
 * @}
 */ /* end of group DBGMAILBOX_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL;     /**< DMA control., offset: 0x0 */
    __I uint32_t INTSTAT;   /**< Interrupt status., offset: 0x4 */
    __IO uint32_t SRAMBASE; /**< SRAM address of the channel configuration table., offset: 0x8 */
    uint8_t RESERVED_0[20];
    struct
    { /* offset: 0x20, array step: 0x5C */
        __IO uint32_t
            ENABLESET; /**< Channel Enable read and Set for all DMA channels., array offset: 0x20, array step: 0x5C */
        uint8_t RESERVED_0[4];
        __O uint32_t ENABLECLR; /**< Channel Enable Clear for all DMA channels., array offset: 0x28, array step: 0x5C */
        uint8_t RESERVED_1[4];
        __I uint32_t ACTIVE; /**< Channel Active status for all DMA channels., array offset: 0x30, array step: 0x5C */
        uint8_t RESERVED_2[4];
        __I uint32_t BUSY; /**< Channel Busy status for all DMA channels., array offset: 0x38, array step: 0x5C */
        uint8_t RESERVED_3[4];
        __IO uint32_t ERRINT; /**< Error Interrupt status for all DMA channels., array offset: 0x40, array step: 0x5C */
        uint8_t RESERVED_4[4];
        __IO uint32_t
            INTENSET; /**< Interrupt Enable read and Set for all DMA channels., array offset: 0x48, array step: 0x5C */
        uint8_t RESERVED_5[4];
        __O uint32_t
            INTENCLR; /**< Interrupt Enable Clear for all DMA channels., array offset: 0x50, array step: 0x5C */
        uint8_t RESERVED_6[4];
        __IO uint32_t INTA; /**< Interrupt A status for all DMA channels., array offset: 0x58, array step: 0x5C */
        uint8_t RESERVED_7[4];
        __IO uint32_t INTB; /**< Interrupt B status for all DMA channels., array offset: 0x60, array step: 0x5C */
        uint8_t RESERVED_8[4];
        __O uint32_t
            SETVALID; /**< Set ValidPending control bits for all DMA channels., array offset: 0x68, array step: 0x5C */
        uint8_t RESERVED_9[4];
        __O uint32_t
            SETTRIG; /**< Set Trigger control bits for all DMA channels., array offset: 0x70, array step: 0x5C */
        uint8_t RESERVED_10[4];
        __O uint32_t ABORT; /**< Channel Abort control for all DMA channels., array offset: 0x78, array step: 0x5C */
    } COMMON[1];
    uint8_t RESERVED_1[900];
    struct
    {                      /* offset: 0x400, array step: 0x10 */
        __IO uint32_t CFG; /**< Configuration register for DMA channel ., array offset: 0x400, array step: 0x10 */
        __I uint32_t
            CTLSTAT; /**< Control and status register for DMA channel ., array offset: 0x404, array step: 0x10 */
        __IO uint32_t
            XFERCFG; /**< Transfer configuration register for DMA channel ., array offset: 0x408, array step: 0x10 */
        uint8_t RESERVED_0[4];
    } CHANNEL[23];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CTRL - DMA control. */
/*! @{ */
#define DMA_CTRL_ENABLE_MASK (0x1U)
#define DMA_CTRL_ENABLE_SHIFT (0U)
/*! ENABLE - DMA controller master enable.
 *  0b0..Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when
 *       disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
 *  0b1..Enabled. The DMA controller is enabled.
 */
#define DMA_CTRL_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << DMA_CTRL_ENABLE_SHIFT)) & DMA_CTRL_ENABLE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status. */
/*! @{ */
#define DMA_INTSTAT_ACTIVEINT_MASK (0x2U)
#define DMA_INTSTAT_ACTIVEINT_SHIFT (1U)
/*! ACTIVEINT - Summarizes whether any enabled interrupts (other than error interrupts) are pending.
 *  0b0..Not pending. No enabled interrupts are pending.
 *  0b1..Pending. At least one enabled interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEINT(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEINT_SHIFT)) & DMA_INTSTAT_ACTIVEINT_MASK)
#define DMA_INTSTAT_ACTIVEERRINT_MASK (0x4U)
#define DMA_INTSTAT_ACTIVEERRINT_SHIFT (2U)
/*! ACTIVEERRINT - Summarizes whether any error interrupts are pending.
 *  0b0..Not pending. No error interrupts are pending.
 *  0b1..Pending. At least one error interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEERRINT(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEERRINT_SHIFT)) & DMA_INTSTAT_ACTIVEERRINT_MASK)
/*! @} */

/*! @name SRAMBASE - SRAM address of the channel configuration table. */
/*! @{ */
#define DMA_SRAMBASE_OFFSET_MASK (0xFFFFFE00U)
#define DMA_SRAMBASE_OFFSET_SHIFT (9U)
/*! OFFSET - Address bits 31:9 of the beginning of the DMA descriptor table. For 18 channels, the
 *    table must begin on a 512 byte boundary.
 */
#define DMA_SRAMBASE_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << DMA_SRAMBASE_OFFSET_SHIFT)) & DMA_SRAMBASE_OFFSET_MASK)
/*! @} */

/*! @name COMMON_ENABLESET - Channel Enable read and Set for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ENABLESET_ENA_MASK (0xFFFFFFFFU)
#define DMA_COMMON_ENABLESET_ENA_SHIFT (0U)
/*! ENA - Enable for DMA channels. Bit n enables or disables DMA channel n. The number of bits =
 *    number of DMA channels in this device. Other bits are reserved. 0 = disabled. 1 = enabled.
 */
#define DMA_COMMON_ENABLESET_ENA(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENA_SHIFT)) & DMA_COMMON_ENABLESET_ENA_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET */
#define DMA_COMMON_ENABLESET_COUNT (1U)

/*! @name COMMON_ENABLECLR - Channel Enable Clear for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ENABLECLR_CLR_MASK (0xFFFFFFFFU)
#define DMA_COMMON_ENABLECLR_CLR_SHIFT (0U)
/*! CLR - Writing ones to this register clears the corresponding bits in ENABLESET0. Bit n clears
 *    the channel enable bit n. The number of bits = number of DMA channels in this device. Other bits
 *    are reserved.
 */
#define DMA_COMMON_ENABLECLR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR_SHIFT)) & DMA_COMMON_ENABLECLR_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR */
#define DMA_COMMON_ENABLECLR_COUNT (1U)

/*! @name COMMON_ACTIVE - Channel Active status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ACTIVE_ACT_MASK (0xFFFFFFFFU)
#define DMA_COMMON_ACTIVE_ACT_SHIFT (0U)
/*! ACT - Active flag for DMA channel n. Bit n corresponds to DMA channel n. The number of bits =
 *    number of DMA channels in this device. Other bits are reserved. 0 = not active. 1 = active.
 */
#define DMA_COMMON_ACTIVE_ACT(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACT_SHIFT)) & DMA_COMMON_ACTIVE_ACT_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE */
#define DMA_COMMON_ACTIVE_COUNT (1U)

/*! @name COMMON_BUSY - Channel Busy status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_BUSY_BSY_MASK (0xFFFFFFFFU)
#define DMA_COMMON_BUSY_BSY_SHIFT (0U)
/*! BSY - Busy flag for DMA channel n. Bit n corresponds to DMA channel n. The number of bits =
 *    number of DMA channels in this device. Other bits are reserved. 0 = not busy. 1 = busy.
 */
#define DMA_COMMON_BUSY_BSY(x) (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BSY_SHIFT)) & DMA_COMMON_BUSY_BSY_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY */
#define DMA_COMMON_BUSY_COUNT (1U)

/*! @name COMMON_ERRINT - Error Interrupt status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ERRINT_ERR_MASK (0xFFFFFFFFU)
#define DMA_COMMON_ERRINT_ERR_SHIFT (0U)
/*! ERR - Error Interrupt flag for DMA channel n. Bit n corresponds to DMA channel n. The number of
 *    bits = number of DMA channels in this device. Other bits are reserved. 0 = error interrupt is
 *    not active. 1 = error interrupt is active.
 */
#define DMA_COMMON_ERRINT_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR_SHIFT)) & DMA_COMMON_ERRINT_ERR_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT */
#define DMA_COMMON_ERRINT_COUNT (1U)

/*! @name COMMON_INTENSET - Interrupt Enable read and Set for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTENSET_INTEN_MASK (0xFFFFFFFFU)
#define DMA_COMMON_INTENSET_INTEN_SHIFT (0U)
/*! INTEN - Interrupt Enable read and set for DMA channel n. Bit n corresponds to DMA channel n. The
 *    number of bits = number of DMA channels in this device. Other bits are reserved. 0 =
 *    interrupt for DMA channel is disabled. 1 = interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN_SHIFT)) & DMA_COMMON_INTENSET_INTEN_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET */
#define DMA_COMMON_INTENSET_COUNT (1U)

/*! @name COMMON_INTENCLR - Interrupt Enable Clear for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTENCLR_CLR_MASK (0xFFFFFFFFU)
#define DMA_COMMON_INTENCLR_CLR_SHIFT (0U)
/*! CLR - Writing ones to this register clears corresponding bits in the INTENSET0. Bit n
 *    corresponds to DMA channel n. The number of bits = number of DMA channels in this device. Other bits are
 *    reserved.
 */
#define DMA_COMMON_INTENCLR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR_SHIFT)) & DMA_COMMON_INTENCLR_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR */
#define DMA_COMMON_INTENCLR_COUNT (1U)

/*! @name COMMON_INTA - Interrupt A status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTA_IA_MASK (0xFFFFFFFFU)
#define DMA_COMMON_INTA_IA_SHIFT (0U)
/*! IA - Interrupt A status for DMA channel n. Bit n corresponds to DMA channel n. The number of
 *    bits = number of DMA channels in this device. Other bits are reserved. 0 = the DMA channel
 *    interrupt A is not active. 1 = the DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_IA(x) (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_IA_SHIFT)) & DMA_COMMON_INTA_IA_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA */
#define DMA_COMMON_INTA_COUNT (1U)

/*! @name COMMON_INTB - Interrupt B status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTB_IB_MASK (0xFFFFFFFFU)
#define DMA_COMMON_INTB_IB_SHIFT (0U)
/*! IB - Interrupt B status for DMA channel n. Bit n corresponds to DMA channel n. The number of
 *    bits = number of DMA channels in this device. Other bits are reserved. 0 = the DMA channel
 *    interrupt B is not active. 1 = the DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_IB(x) (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_IB_SHIFT)) & DMA_COMMON_INTB_IB_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB */
#define DMA_COMMON_INTB_COUNT (1U)

/*! @name COMMON_SETVALID - Set ValidPending control bits for all DMA channels. */
/*! @{ */
#define DMA_COMMON_SETVALID_SV_MASK (0xFFFFFFFFU)
#define DMA_COMMON_SETVALID_SV_SHIFT (0U)
/*! SV - SETVALID control for DMA channel n. Bit n corresponds to DMA channel n. The number of bits
 *    = number of DMA channels in this device. Other bits are reserved. 0 = no effect. 1 = sets the
 *    VALIDPENDING control bit for DMA channel n
 */
#define DMA_COMMON_SETVALID_SV(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SV_SHIFT)) & DMA_COMMON_SETVALID_SV_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID */
#define DMA_COMMON_SETVALID_COUNT (1U)

/*! @name COMMON_SETTRIG - Set Trigger control bits for all DMA channels. */
/*! @{ */
#define DMA_COMMON_SETTRIG_TRIG_MASK (0xFFFFFFFFU)
#define DMA_COMMON_SETTRIG_TRIG_SHIFT (0U)
/*! TRIG - Set Trigger control bit for DMA channel 0. Bit n corresponds to DMA channel n. The number
 *    of bits = number of DMA channels in this device. Other bits are reserved. 0 = no effect. 1 =
 *    sets the TRIG bit for DMA channel n.
 */
#define DMA_COMMON_SETTRIG_TRIG(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_TRIG_SHIFT)) & DMA_COMMON_SETTRIG_TRIG_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG */
#define DMA_COMMON_SETTRIG_COUNT (1U)

/*! @name COMMON_ABORT - Channel Abort control for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ABORT_ABORTCTRL_MASK (0xFFFFFFFFU)
#define DMA_COMMON_ABORT_ABORTCTRL_SHIFT (0U)
/*! ABORTCTRL - Abort control for DMA channel 0. Bit n corresponds to DMA channel n. 0 = no effect.
 *    1 = aborts DMA operations on channel n.
 */
#define DMA_COMMON_ABORT_ABORTCTRL(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORTCTRL_SHIFT)) & DMA_COMMON_ABORT_ABORTCTRL_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT */
#define DMA_COMMON_ABORT_COUNT (1U)

/*! @name CHANNEL_CFG - Configuration register for DMA channel . */
/*! @{ */
#define DMA_CHANNEL_CFG_PERIPHREQEN_MASK (0x1U)
#define DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT (0U)
/*! PERIPHREQEN - Peripheral request Enable. If a DMA channel is used to perform a memory-to-memory
 *    move, any peripheral DMA request associated with that channel can be disabled to prevent any
 *    interaction between the peripheral and the DMA controller.
 *  0b0..Disabled. Peripheral DMA requests are disabled.
 *  0b1..Enabled. Peripheral DMA requests are enabled.
 */
#define DMA_CHANNEL_CFG_PERIPHREQEN(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT)) & DMA_CHANNEL_CFG_PERIPHREQEN_MASK)
#define DMA_CHANNEL_CFG_HWTRIGEN_MASK (0x2U)
#define DMA_CHANNEL_CFG_HWTRIGEN_SHIFT (1U)
/*! HWTRIGEN - Hardware Triggering Enable for this channel.
 *  0b0..Disabled. Hardware triggering is not used.
 *  0b1..Enabled. Use hardware triggering.
 */
#define DMA_CHANNEL_CFG_HWTRIGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_HWTRIGEN_SHIFT)) & DMA_CHANNEL_CFG_HWTRIGEN_MASK)
#define DMA_CHANNEL_CFG_TRIGPOL_MASK (0x10U)
#define DMA_CHANNEL_CFG_TRIGPOL_SHIFT (4U)
/*! TRIGPOL - Trigger Polarity. Selects the polarity of a hardware trigger for this channel.
 *  0b0..Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
 *  0b1..Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
 */
#define DMA_CHANNEL_CFG_TRIGPOL(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGPOL_SHIFT)) & DMA_CHANNEL_CFG_TRIGPOL_MASK)
#define DMA_CHANNEL_CFG_TRIGTYPE_MASK (0x20U)
#define DMA_CHANNEL_CFG_TRIGTYPE_SHIFT (5U)
/*! TRIGTYPE - Trigger Type. Selects hardware trigger as edge triggered or level triggered.
 *  0b0..Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single
 * trigger. 0b1..Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER =
 *       0) is selected, only hardware triggers should be used on that channel. Transfers continue as long as the
 *       trigger level is asserted. Once the trigger is de-asserted, the transfer will be paused until the trigger
 *       is, again, asserted. However, the transfer will not be paused until any remaining transfers within the
 *       current BURSTPOWER length are completed.
 */
#define DMA_CHANNEL_CFG_TRIGTYPE(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGTYPE_SHIFT)) & DMA_CHANNEL_CFG_TRIGTYPE_MASK)
#define DMA_CHANNEL_CFG_TRIGBURST_MASK (0x40U)
#define DMA_CHANNEL_CFG_TRIGBURST_SHIFT (6U)
/*! TRIGBURST - Trigger Burst. Selects whether hardware triggers cause a single or burst transfer.
 *  0b0..Single transfer. Hardware trigger causes a single transfer.
 *  0b1..Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a
 *       burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a
 *       hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is
 *       complete.
 */
#define DMA_CHANNEL_CFG_TRIGBURST(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGBURST_SHIFT)) & DMA_CHANNEL_CFG_TRIGBURST_MASK)
#define DMA_CHANNEL_CFG_BURSTPOWER_MASK (0xF00U)
#define DMA_CHANNEL_CFG_BURSTPOWER_SHIFT (8U)
/*! BURSTPOWER - Burst Power is used in two ways. It always selects the address wrap size when
 *    SRCBURSTWRAP and/or DSTBURSTWRAP modes are selected (see descriptions elsewhere in this register).
 *    When the TRIGBURST field elsewhere in this register = 1, Burst Power selects how many
 *    transfers are performed for each DMA trigger. This can be used, for example, with peripherals that
 *    contain a FIFO that can initiate a DMA operation when the FIFO reaches a certain level. 0000:
 *    Burst size = 1 (20). 0001: Burst size = 2 (21). 0010: Burst size = 4 (22). 1010: Burst size =
 *    1024 (210). This corresponds to the maximum supported transfer count. others: not supported. The
 *    total transfer length as defined in the XFERCOUNT bits in the XFERCFG register must be an even
 *    multiple of the burst size.
 */
#define DMA_CHANNEL_CFG_BURSTPOWER(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_BURSTPOWER_SHIFT)) & DMA_CHANNEL_CFG_BURSTPOWER_MASK)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK (0x4000U)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT (14U)
/*! SRCBURSTWRAP - Source Burst Wrap. When enabled, the source data address for the DMA is
 *    'wrapped', meaning that the source address range for each burst will be the same. As an example, this
 *    could be used to read several sequential registers from a peripheral for each DMA burst,
 *    reading the same registers again for each burst.
 *  0b0..Disabled. Source burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Source burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_SRCBURSTWRAP(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK (0x8000U)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT (15U)
/*! DSTBURSTWRAP - Destination Burst Wrap. When enabled, the destination data address for the DMA is
 *    'wrapped', meaning that the destination address range for each burst will be the same. As an
 *    example, this could be used to write several sequential registers to a peripheral for each DMA
 *    burst, writing the same registers again for each burst.
 *  0b0..Disabled. Destination burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Destination burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_DSTBURSTWRAP(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_CHPRIORITY_MASK (0x70000U)
#define DMA_CHANNEL_CFG_CHPRIORITY_SHIFT (16U)
/*! CHPRIORITY - Priority of this channel when multiple DMA requests are pending. Eight priority
 *    levels are supported: 0x0 = highest priority. 0x7 = lowest priority.
 */
#define DMA_CHANNEL_CFG_CHPRIORITY(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_CHPRIORITY_SHIFT)) & DMA_CHANNEL_CFG_CHPRIORITY_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CFG */
#define DMA_CHANNEL_CFG_COUNT (23U)

/*! @name CHANNEL_CTLSTAT - Control and status register for DMA channel . */
/*! @{ */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK (0x1U)
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT (0U)
/*! VALIDPENDING - Valid pending flag for this channel. This bit is set when a 1 is written to the
 *    corresponding bit in the related SETVALID register when CFGVALID = 1 for the same channel.
 *  0b0..No effect. No effect on DMA operation.
 *  0b1..Valid pending.
 */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT)) & DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK)
#define DMA_CHANNEL_CTLSTAT_TRIG_MASK (0x4U)
#define DMA_CHANNEL_CTLSTAT_TRIG_SHIFT (2U)
/*! TRIG - Trigger flag. Indicates that the trigger for this channel is currently set. This bit is
 *    cleared at the end of an entire transfer or upon reload when CLRTRIG = 1.
 *  0b0..Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
 *  0b1..Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
 */
#define DMA_CHANNEL_CTLSTAT_TRIG(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_TRIG_SHIFT)) & DMA_CHANNEL_CTLSTAT_TRIG_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CTLSTAT */
#define DMA_CHANNEL_CTLSTAT_COUNT (23U)

/*! @name CHANNEL_XFERCFG - Transfer configuration register for DMA channel . */
/*! @{ */
#define DMA_CHANNEL_XFERCFG_CFGVALID_MASK (0x1U)
#define DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT (0U)
/*! CFGVALID - Configuration Valid flag. This bit indicates whether the current channel descriptor
 *    is valid and can potentially be acted upon, if all other activation criteria are fulfilled.
 *  0b0..Not valid. The channel descriptor is not considered valid until validated by an associated SETVALID0 setting.
 *  0b1..Valid. The current channel descriptor is considered valid.
 */
#define DMA_CHANNEL_XFERCFG_CFGVALID(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT)) & DMA_CHANNEL_XFERCFG_CFGVALID_MASK)
#define DMA_CHANNEL_XFERCFG_RELOAD_MASK (0x2U)
#define DMA_CHANNEL_XFERCFG_RELOAD_SHIFT (1U)
/*! RELOAD - Indicates whether the channel's control structure will be reloaded when the current
 *    descriptor is exhausted. Reloading allows ping-pong and linked transfers.
 *  0b0..Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
 *  0b1..Enabled. Reload the channels' control structure when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_RELOAD(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_RELOAD_SHIFT)) & DMA_CHANNEL_XFERCFG_RELOAD_MASK)
#define DMA_CHANNEL_XFERCFG_SWTRIG_MASK (0x4U)
#define DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT (2U)
/*! SWTRIG - Software Trigger.
 *  0b0..Not set. When written by software, the trigger for this channel is not set. A new trigger, as defined by
 *       the HWTRIGEN, TRIGPOL, and TRIGTYPE will be needed to start the channel.
 *  0b1..Set. When written by software, the trigger for this channel is set immediately. This feature should not
 *       be used with level triggering when TRIGBURST = 0.
 */
#define DMA_CHANNEL_XFERCFG_SWTRIG(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_SWTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_MASK (0x8U)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT (3U)
/*! CLRTRIG - Clear Trigger.
 *  0b0..Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next
 * descriptor will be started. 0b1..Cleared. The trigger is cleared when this descriptor is exhausted
 */
#define DMA_CHANNEL_XFERCFG_CLRTRIG(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_CLRTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTA_MASK (0x10U)
#define DMA_CHANNEL_XFERCFG_SETINTA_SHIFT (4U)
/*! SETINTA - Set Interrupt flag A for this channel. There is no hardware distinction between
 *    interrupt A and B. They can be used by software to assist with more complex descriptor usage. By
 *    convention, interrupt A may be used when only one interrupt flag is needed.
 *  0b0..No effect.
 *  0b1..Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTA(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTA_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTA_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTB_MASK (0x20U)
#define DMA_CHANNEL_XFERCFG_SETINTB_SHIFT (5U)
/*! SETINTB - Set Interrupt flag B for this channel. There is no hardware distinction between
 *    interrupt A and B. They can be used by software to assist with more complex descriptor usage. By
 *    convention, interrupt A may be used when only one interrupt flag is needed.
 *  0b0..No effect.
 *  0b1..Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTB(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTB_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTB_MASK)
#define DMA_CHANNEL_XFERCFG_WIDTH_MASK (0x300U)
#define DMA_CHANNEL_XFERCFG_WIDTH_SHIFT (8U)
/*! WIDTH - Transfer width used for this DMA channel.
 *  0b00..8-bit. 8-bit transfers are performed (8-bit source reads and destination writes).
 *  0b01..16-bit. 6-bit transfers are performed (16-bit source reads and destination writes).
 *  0b10..32-bit. 32-bit transfers are performed (32-bit source reads and destination writes).
 *  0b11..Reserved. Reserved setting, do not use.
 */
#define DMA_CHANNEL_XFERCFG_WIDTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_WIDTH_SHIFT)) & DMA_CHANNEL_XFERCFG_WIDTH_MASK)
#define DMA_CHANNEL_XFERCFG_SRCINC_MASK (0x3000U)
#define DMA_CHANNEL_XFERCFG_SRCINC_SHIFT (12U)
/*! SRCINC - Determines whether the source address is incremented for each DMA transfer.
 *  0b00..No increment. The source address is not incremented for each transfer. This is the usual case when the source
 * is a peripheral device. 0b01..1 x width. The source address is incremented by the amount specified by Width for each
 * transfer. This is the usual case when the source is memory. 0b10..2 x width. The source address is incremented by 2
 * times the amount specified by Width for each transfer. 0b11..4 x width. The source address is incremented by 4 times
 * the amount specified by Width for each transfer.
 */
#define DMA_CHANNEL_XFERCFG_SRCINC(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SRCINC_SHIFT)) & DMA_CHANNEL_XFERCFG_SRCINC_MASK)
#define DMA_CHANNEL_XFERCFG_DSTINC_MASK (0xC000U)
#define DMA_CHANNEL_XFERCFG_DSTINC_SHIFT (14U)
/*! DSTINC - Determines whether the destination address is incremented for each DMA transfer.
 *  0b00..No increment. The destination address is not incremented for each transfer. This is the usual case when
 *        the destination is a peripheral device.
 *  0b01..1 x width. The destination address is incremented by the amount specified by Width for each transfer.
 *        This is the usual case when the destination is memory.
 *  0b10..2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
 *  0b11..4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
 */
#define DMA_CHANNEL_XFERCFG_DSTINC(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_DSTINC_SHIFT)) & DMA_CHANNEL_XFERCFG_DSTINC_MASK)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK (0x3FF0000U)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT (16U)
/*! XFERCOUNT - Total number of transfers to be performed, minus 1 encoded. The number of bytes
 *    transferred is: (XFERCOUNT + 1) x data width (as defined by the WIDTH field). The DMA controller
 *    uses this bit field during transfer to count down. Hence, it cannot be used by software to read
 *    back the size of the transfer, for instance, in an interrupt handler. 0x0 = a total of 1
 *    transfer will be performed. 0x1 = a total of 2 transfers will be performed. 0x3FF = a total of
 *    1,024 transfers will be performed.
 */
#define DMA_CHANNEL_XFERCFG_XFERCOUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT)) & DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK)
/*! @} */

/* The count of DMA_CHANNEL_XFERCFG */
#define DMA_CHANNEL_XFERCFG_COUNT (23U)

/*!
 * @}
 */ /* end of group DMA_Register_Masks */

/* DMA - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral DMA0 base address */
#define DMA0_BASE (0x50082000u)
/** Peripheral DMA0 base address */
#define DMA0_BASE_NS (0x40082000u)
/** Peripheral DMA0 base pointer */
#define DMA0 ((DMA_Type *)DMA0_BASE)
/** Peripheral DMA0 base pointer */
#define DMA0_NS ((DMA_Type *)DMA0_BASE_NS)
/** Peripheral DMA1 base address */
#define DMA1_BASE (0x500A7000u)
/** Peripheral DMA1 base address */
#define DMA1_BASE_NS (0x400A7000u)
/** Peripheral DMA1 base pointer */
#define DMA1 ((DMA_Type *)DMA1_BASE)
/** Peripheral DMA1 base pointer */
#define DMA1_NS ((DMA_Type *)DMA1_BASE_NS)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS       \
    {                        \
        DMA0_BASE, DMA1_BASE \
    }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS \
    {                 \
        DMA0, DMA1    \
    }
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS_NS          \
    {                              \
        DMA0_BASE_NS, DMA1_BASE_NS \
    }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS_NS \
    {                    \
        DMA0_NS, DMA1_NS \
    }
#else
/** Peripheral DMA0 base address */
#define DMA0_BASE (0x40082000u)
/** Peripheral DMA0 base pointer */
#define DMA0 ((DMA_Type *)DMA0_BASE)
/** Peripheral DMA1 base address */
#define DMA1_BASE (0x400A7000u)
/** Peripheral DMA1 base pointer */
#define DMA1 ((DMA_Type *)DMA1_BASE)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS       \
    {                        \
        DMA0_BASE, DMA1_BASE \
    }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS \
    {                 \
        DMA0, DMA1    \
    }
#endif
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS             \
    {                        \
        DMA0_IRQn, DMA1_IRQn \
    }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- FLASH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_Peripheral_Access_Layer FLASH Peripheral Access Layer
 * @{
 */

/** FLASH - Register Layout Typedef */
typedef struct
{
    __O uint32_t CMD;   /**< command register, offset: 0x0 */
    __O uint32_t EVENT; /**< event register, offset: 0x4 */
    uint8_t RESERVED_0[8];
    __IO uint32_t STARTA; /**< start (or only) address for next flash command, offset: 0x10 */
    __IO uint32_t STOPA; /**< end address for next flash command, if command operates on address ranges, offset: 0x14 */
    uint8_t RESERVED_1[104];
    __IO uint32_t DATAW[4]; /**< data register, word 0-7; Memory data, or command parameter, or command result., array
                               offset: 0x80, array step: 0x4 */
    uint8_t RESERVED_2[3912];
    __O uint32_t INT_CLR_ENABLE; /**< Clear interrupt enable bits, offset: 0xFD8 */
    __O uint32_t INT_SET_ENABLE; /**< Set interrupt enable bits, offset: 0xFDC */
    __I uint32_t INT_STATUS;     /**< Interrupt status bits, offset: 0xFE0 */
    __I uint32_t INT_ENABLE;     /**< Interrupt enable bits, offset: 0xFE4 */
    __O uint32_t INT_CLR_STATUS; /**< Clear interrupt status bits, offset: 0xFE8 */
    __O uint32_t INT_SET_STATUS; /**< Set interrupt status bits, offset: 0xFEC */
    uint8_t RESERVED_3[12];
    __I uint32_t MODULE_ID; /**< Controller+Memory module identification, offset: 0xFFC */
} FLASH_Type;

/* ----------------------------------------------------------------------------
   -- FLASH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_Register_Masks FLASH Register Masks
 * @{
 */

/*! @name CMD - command register */
/*! @{ */
#define FLASH_CMD_CMD_MASK (0xFFFFFFFFU)
#define FLASH_CMD_CMD_SHIFT (0U)
/*! CMD - command register.
 */
#define FLASH_CMD_CMD(x) (((uint32_t)(((uint32_t)(x)) << FLASH_CMD_CMD_SHIFT)) & FLASH_CMD_CMD_MASK)
/*! @} */

/*! @name EVENT - event register */
/*! @{ */
#define FLASH_EVENT_RST_MASK (0x1U)
#define FLASH_EVENT_RST_SHIFT (0U)
/*! RST - When bit is set, the controller and flash are reset.
 */
#define FLASH_EVENT_RST(x) (((uint32_t)(((uint32_t)(x)) << FLASH_EVENT_RST_SHIFT)) & FLASH_EVENT_RST_MASK)
#define FLASH_EVENT_WAKEUP_MASK (0x2U)
#define FLASH_EVENT_WAKEUP_SHIFT (1U)
/*! WAKEUP - When bit is set, the controller wakes up from whatever low power or powerdown mode was active.
 */
#define FLASH_EVENT_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << FLASH_EVENT_WAKEUP_SHIFT)) & FLASH_EVENT_WAKEUP_MASK)
#define FLASH_EVENT_ABORT_MASK (0x4U)
#define FLASH_EVENT_ABORT_SHIFT (2U)
/*! ABORT - When bit is set, a running program/erase command is aborted.
 */
#define FLASH_EVENT_ABORT(x) (((uint32_t)(((uint32_t)(x)) << FLASH_EVENT_ABORT_SHIFT)) & FLASH_EVENT_ABORT_MASK)
/*! @} */

/*! @name STARTA - start (or only) address for next flash command */
/*! @{ */
#define FLASH_STARTA_STARTA_MASK (0x3FFFFU)
#define FLASH_STARTA_STARTA_SHIFT (0U)
/*! STARTA - Address / Start address for commands that take an address (range) as a parameter.
 */
#define FLASH_STARTA_STARTA(x) (((uint32_t)(((uint32_t)(x)) << FLASH_STARTA_STARTA_SHIFT)) & FLASH_STARTA_STARTA_MASK)
/*! @} */

/*! @name STOPA - end address for next flash command, if command operates on address ranges */
/*! @{ */
#define FLASH_STOPA_STOPA_MASK (0x3FFFFU)
#define FLASH_STOPA_STOPA_SHIFT (0U)
/*! STOPA - Stop address for commands that take an address range as a parameter (the word specified
 *    by STOPA is included in the address range).
 */
#define FLASH_STOPA_STOPA(x) (((uint32_t)(((uint32_t)(x)) << FLASH_STOPA_STOPA_SHIFT)) & FLASH_STOPA_STOPA_MASK)
/*! @} */

/*! @name DATAW - data register, word 0-7; Memory data, or command parameter, or command result. */
/*! @{ */
#define FLASH_DATAW_DATAW_MASK (0xFFFFFFFFU)
#define FLASH_DATAW_DATAW_SHIFT (0U)
#define FLASH_DATAW_DATAW(x) (((uint32_t)(((uint32_t)(x)) << FLASH_DATAW_DATAW_SHIFT)) & FLASH_DATAW_DATAW_MASK)
/*! @} */

/* The count of FLASH_DATAW */
#define FLASH_DATAW_COUNT (4U)

/*! @name INT_CLR_ENABLE - Clear interrupt enable bits */
/*! @{ */
#define FLASH_INT_CLR_ENABLE_FAIL_MASK (0x1U)
#define FLASH_INT_CLR_ENABLE_FAIL_SHIFT (0U)
/*! FAIL - When a CLR_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is cleared.
 */
#define FLASH_INT_CLR_ENABLE_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_ENABLE_FAIL_SHIFT)) & FLASH_INT_CLR_ENABLE_FAIL_MASK)
#define FLASH_INT_CLR_ENABLE_ERR_MASK (0x2U)
#define FLASH_INT_CLR_ENABLE_ERR_SHIFT (1U)
/*! ERR - When a CLR_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is cleared.
 */
#define FLASH_INT_CLR_ENABLE_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_ENABLE_ERR_SHIFT)) & FLASH_INT_CLR_ENABLE_ERR_MASK)
#define FLASH_INT_CLR_ENABLE_DONE_MASK (0x4U)
#define FLASH_INT_CLR_ENABLE_DONE_SHIFT (2U)
/*! DONE - When a CLR_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is cleared.
 */
#define FLASH_INT_CLR_ENABLE_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_ENABLE_DONE_SHIFT)) & FLASH_INT_CLR_ENABLE_DONE_MASK)
#define FLASH_INT_CLR_ENABLE_ECC_ERR_MASK (0x8U)
#define FLASH_INT_CLR_ENABLE_ECC_ERR_SHIFT (3U)
/*! ECC_ERR - When a CLR_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is cleared.
 */
#define FLASH_INT_CLR_ENABLE_ECC_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_ENABLE_ECC_ERR_SHIFT)) & FLASH_INT_CLR_ENABLE_ECC_ERR_MASK)
/*! @} */

/*! @name INT_SET_ENABLE - Set interrupt enable bits */
/*! @{ */
#define FLASH_INT_SET_ENABLE_FAIL_MASK (0x1U)
#define FLASH_INT_SET_ENABLE_FAIL_SHIFT (0U)
/*! FAIL - When a SET_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is set.
 */
#define FLASH_INT_SET_ENABLE_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_ENABLE_FAIL_SHIFT)) & FLASH_INT_SET_ENABLE_FAIL_MASK)
#define FLASH_INT_SET_ENABLE_ERR_MASK (0x2U)
#define FLASH_INT_SET_ENABLE_ERR_SHIFT (1U)
/*! ERR - When a SET_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is set.
 */
#define FLASH_INT_SET_ENABLE_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_ENABLE_ERR_SHIFT)) & FLASH_INT_SET_ENABLE_ERR_MASK)
#define FLASH_INT_SET_ENABLE_DONE_MASK (0x4U)
#define FLASH_INT_SET_ENABLE_DONE_SHIFT (2U)
/*! DONE - When a SET_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is set.
 */
#define FLASH_INT_SET_ENABLE_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_ENABLE_DONE_SHIFT)) & FLASH_INT_SET_ENABLE_DONE_MASK)
#define FLASH_INT_SET_ENABLE_ECC_ERR_MASK (0x8U)
#define FLASH_INT_SET_ENABLE_ECC_ERR_SHIFT (3U)
/*! ECC_ERR - When a SET_ENABLE bit is written to 1, the corresponding INT_ENABLE bit is set.
 */
#define FLASH_INT_SET_ENABLE_ECC_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_ENABLE_ECC_ERR_SHIFT)) & FLASH_INT_SET_ENABLE_ECC_ERR_MASK)
/*! @} */

/*! @name INT_STATUS - Interrupt status bits */
/*! @{ */
#define FLASH_INT_STATUS_FAIL_MASK (0x1U)
#define FLASH_INT_STATUS_FAIL_SHIFT (0U)
/*! FAIL - This status bit is set if execution of a (legal) command failed.
 */
#define FLASH_INT_STATUS_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_STATUS_FAIL_SHIFT)) & FLASH_INT_STATUS_FAIL_MASK)
#define FLASH_INT_STATUS_ERR_MASK (0x2U)
#define FLASH_INT_STATUS_ERR_SHIFT (1U)
/*! ERR - This status bit is set if execution of an illegal command is detected.
 */
#define FLASH_INT_STATUS_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_STATUS_ERR_SHIFT)) & FLASH_INT_STATUS_ERR_MASK)
#define FLASH_INT_STATUS_DONE_MASK (0x4U)
#define FLASH_INT_STATUS_DONE_SHIFT (2U)
/*! DONE - This status bit is set at the end of command execution.
 */
#define FLASH_INT_STATUS_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_STATUS_DONE_SHIFT)) & FLASH_INT_STATUS_DONE_MASK)
#define FLASH_INT_STATUS_ECC_ERR_MASK (0x8U)
#define FLASH_INT_STATUS_ECC_ERR_SHIFT (3U)
/*! ECC_ERR - This status bit is set if, during a memory read operation (either a user-requested
 *    read, or a speculative read, or reads performed by a controller command), a correctable or
 *    uncorrectable error is detected by ECC decoding logic.
 */
#define FLASH_INT_STATUS_ECC_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_STATUS_ECC_ERR_SHIFT)) & FLASH_INT_STATUS_ECC_ERR_MASK)
/*! @} */

/*! @name INT_ENABLE - Interrupt enable bits */
/*! @{ */
#define FLASH_INT_ENABLE_FAIL_MASK (0x1U)
#define FLASH_INT_ENABLE_FAIL_SHIFT (0U)
/*! FAIL - If an INT_ENABLE bit is set, an interrupt request will be generated if the corresponding INT_STATUS bit is
 * high.
 */
#define FLASH_INT_ENABLE_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_ENABLE_FAIL_SHIFT)) & FLASH_INT_ENABLE_FAIL_MASK)
#define FLASH_INT_ENABLE_ERR_MASK (0x2U)
#define FLASH_INT_ENABLE_ERR_SHIFT (1U)
/*! ERR - If an INT_ENABLE bit is set, an interrupt request will be generated if the corresponding INT_STATUS bit is
 * high.
 */
#define FLASH_INT_ENABLE_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_ENABLE_ERR_SHIFT)) & FLASH_INT_ENABLE_ERR_MASK)
#define FLASH_INT_ENABLE_DONE_MASK (0x4U)
#define FLASH_INT_ENABLE_DONE_SHIFT (2U)
/*! DONE - If an INT_ENABLE bit is set, an interrupt request will be generated if the corresponding INT_STATUS bit is
 * high.
 */
#define FLASH_INT_ENABLE_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_ENABLE_DONE_SHIFT)) & FLASH_INT_ENABLE_DONE_MASK)
#define FLASH_INT_ENABLE_ECC_ERR_MASK (0x8U)
#define FLASH_INT_ENABLE_ECC_ERR_SHIFT (3U)
/*! ECC_ERR - If an INT_ENABLE bit is set, an interrupt request will be generated if the corresponding INT_STATUS bit is
 * high.
 */
#define FLASH_INT_ENABLE_ECC_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_ENABLE_ECC_ERR_SHIFT)) & FLASH_INT_ENABLE_ECC_ERR_MASK)
/*! @} */

/*! @name INT_CLR_STATUS - Clear interrupt status bits */
/*! @{ */
#define FLASH_INT_CLR_STATUS_FAIL_MASK (0x1U)
#define FLASH_INT_CLR_STATUS_FAIL_SHIFT (0U)
/*! FAIL - When a CLR_STATUS bit is written to 1, the corresponding INT_STATUS bit is cleared.
 */
#define FLASH_INT_CLR_STATUS_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_STATUS_FAIL_SHIFT)) & FLASH_INT_CLR_STATUS_FAIL_MASK)
#define FLASH_INT_CLR_STATUS_ERR_MASK (0x2U)
#define FLASH_INT_CLR_STATUS_ERR_SHIFT (1U)
/*! ERR - When a CLR_STATUS bit is written to 1, the corresponding INT_STATUS bit is cleared.
 */
#define FLASH_INT_CLR_STATUS_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_STATUS_ERR_SHIFT)) & FLASH_INT_CLR_STATUS_ERR_MASK)
#define FLASH_INT_CLR_STATUS_DONE_MASK (0x4U)
#define FLASH_INT_CLR_STATUS_DONE_SHIFT (2U)
/*! DONE - When a CLR_STATUS bit is written to 1, the corresponding INT_STATUS bit is cleared.
 */
#define FLASH_INT_CLR_STATUS_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_STATUS_DONE_SHIFT)) & FLASH_INT_CLR_STATUS_DONE_MASK)
#define FLASH_INT_CLR_STATUS_ECC_ERR_MASK (0x8U)
#define FLASH_INT_CLR_STATUS_ECC_ERR_SHIFT (3U)
/*! ECC_ERR - When a CLR_STATUS bit is written to 1, the corresponding INT_STATUS bit is cleared.
 */
#define FLASH_INT_CLR_STATUS_ECC_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_CLR_STATUS_ECC_ERR_SHIFT)) & FLASH_INT_CLR_STATUS_ECC_ERR_MASK)
/*! @} */

/*! @name INT_SET_STATUS - Set interrupt status bits */
/*! @{ */
#define FLASH_INT_SET_STATUS_FAIL_MASK (0x1U)
#define FLASH_INT_SET_STATUS_FAIL_SHIFT (0U)
/*! FAIL - When a SET_STATUS bit is written to 1, the corresponding INT_STATUS bit is set.
 */
#define FLASH_INT_SET_STATUS_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_STATUS_FAIL_SHIFT)) & FLASH_INT_SET_STATUS_FAIL_MASK)
#define FLASH_INT_SET_STATUS_ERR_MASK (0x2U)
#define FLASH_INT_SET_STATUS_ERR_SHIFT (1U)
/*! ERR - When a SET_STATUS bit is written to 1, the corresponding INT_STATUS bit is set.
 */
#define FLASH_INT_SET_STATUS_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_STATUS_ERR_SHIFT)) & FLASH_INT_SET_STATUS_ERR_MASK)
#define FLASH_INT_SET_STATUS_DONE_MASK (0x4U)
#define FLASH_INT_SET_STATUS_DONE_SHIFT (2U)
/*! DONE - When a SET_STATUS bit is written to 1, the corresponding INT_STATUS bit is set.
 */
#define FLASH_INT_SET_STATUS_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_STATUS_DONE_SHIFT)) & FLASH_INT_SET_STATUS_DONE_MASK)
#define FLASH_INT_SET_STATUS_ECC_ERR_MASK (0x8U)
#define FLASH_INT_SET_STATUS_ECC_ERR_SHIFT (3U)
/*! ECC_ERR - When a SET_STATUS bit is written to 1, the corresponding INT_STATUS bit is set.
 */
#define FLASH_INT_SET_STATUS_ECC_ERR(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_INT_SET_STATUS_ECC_ERR_SHIFT)) & FLASH_INT_SET_STATUS_ECC_ERR_MASK)
/*! @} */

/*! @name MODULE_ID - Controller+Memory module identification */
/*! @{ */
#define FLASH_MODULE_ID_APERTURE_MASK (0xFFU)
#define FLASH_MODULE_ID_APERTURE_SHIFT (0U)
/*! APERTURE - Aperture i.
 */
#define FLASH_MODULE_ID_APERTURE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_APERTURE_SHIFT)) & FLASH_MODULE_ID_APERTURE_MASK)
#define FLASH_MODULE_ID_MINOR_REV_MASK (0xF00U)
#define FLASH_MODULE_ID_MINOR_REV_SHIFT (8U)
/*! MINOR_REV - Minor revision i.
 */
#define FLASH_MODULE_ID_MINOR_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_MINOR_REV_SHIFT)) & FLASH_MODULE_ID_MINOR_REV_MASK)
#define FLASH_MODULE_ID_MAJOR_REV_MASK (0xF000U)
#define FLASH_MODULE_ID_MAJOR_REV_SHIFT (12U)
/*! MAJOR_REV - Major revision i.
 */
#define FLASH_MODULE_ID_MAJOR_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_MAJOR_REV_SHIFT)) & FLASH_MODULE_ID_MAJOR_REV_MASK)
#define FLASH_MODULE_ID_ID_MASK (0xFFFF0000U)
#define FLASH_MODULE_ID_ID_SHIFT (16U)
/*! ID - Identifier.
 */
#define FLASH_MODULE_ID_ID(x) (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_ID_SHIFT)) & FLASH_MODULE_ID_ID_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group FLASH_Register_Masks */

/* FLASH - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral FLASH base address */
#define FLASH_BASE (0x50034000u)
/** Peripheral FLASH base address */
#define FLASH_BASE_NS (0x40034000u)
/** Peripheral FLASH base pointer */
#define FLASH ((FLASH_Type *)FLASH_BASE)
/** Peripheral FLASH base pointer */
#define FLASH_NS ((FLASH_Type *)FLASH_BASE_NS)
/** Array initializer of FLASH peripheral base addresses */
#define FLASH_BASE_ADDRS \
    {                    \
        FLASH_BASE       \
    }
/** Array initializer of FLASH peripheral base pointers */
#define FLASH_BASE_PTRS \
    {                   \
        FLASH           \
    }
/** Array initializer of FLASH peripheral base addresses */
#define FLASH_BASE_ADDRS_NS \
    {                       \
        FLASH_BASE_NS       \
    }
/** Array initializer of FLASH peripheral base pointers */
#define FLASH_BASE_PTRS_NS \
    {                      \
        FLASH_NS           \
    }
#else
/** Peripheral FLASH base address */
#define FLASH_BASE (0x40034000u)
/** Peripheral FLASH base pointer */
#define FLASH ((FLASH_Type *)FLASH_BASE)
/** Array initializer of FLASH peripheral base addresses */
#define FLASH_BASE_ADDRS \
    {                    \
        FLASH_BASE       \
    }
/** Array initializer of FLASH peripheral base pointers */
#define FLASH_BASE_PTRS \
    {                   \
        FLASH           \
    }
#endif

/*!
 * @}
 */ /* end of group FLASH_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- FLASH_CFPA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_CFPA_Peripheral_Access_Layer FLASH_CFPA Peripheral Access Layer
 * @{
 */

/** FLASH_CFPA - Register Layout Typedef */
typedef struct
{
    __IO uint32_t HEADER;           /**< ., offset: 0x0 */
    __IO uint32_t VERSION;          /**< ., offset: 0x4 */
    __IO uint32_t S_FW_VERSION;     /**< Secure firmware version (Monotonic counter), offset: 0x8 */
    __IO uint32_t NS_FW_VERSION;    /**< Non-Secure firmware version (Monotonic counter), offset: 0xC */
    __IO uint32_t IMAGE_KEY_REVOKE; /**< Image key revocation ID (Monotonic counter), offset: 0x10 */
    uint8_t RESERVED_0[4];
    __IO uint32_t ROTKH_REVOKE; /**< ., offset: 0x18 */
    __IO uint32_t VENDOR_USAGE; /**< ., offset: 0x1C */
    __IO uint32_t
        DCFG_CC_SOCU_PIN; /**< With TZ-M, the part can be sold by level 1 customers (secure code developer) to level-2
                             customers who develops non-secure code only. - In this scenario, or easy of development,
                             Level-I customer releases the part to always allow non-secure debug. - To allow level-2
                             customers to further seal the part DCFG_CC_SOCU_NS is used. - ROM will use this word to
                             further restrict the debug access., offset: 0x20 */
    __IO uint32_t
        DCFG_CC_SOCU_DFLT; /**< With TZ-M, the part can be sold by level 1 customers (secure code developer) to level-2
                              customers who develops non-secure code only. - In this scenario, or easy of development,
                              Level-I customer releases the part to always allow non-secure debug. - To allow level-2
                              customers to further seal the part DCFG_CC_SOCU_NS is used. - ROM will use this word to
                              further restrict the debug access., offset: 0x24 */
    __IO uint32_t ENABLE_FA_MODE; /**< Enable FA mode. SET_FA_MODE Command should write 0xC33CA55A to this word to
                                     indicate boot ROM to enter FA mode., offset: 0x28 */
    __IO uint32_t CMPA_PROG_IN_PROGRESS; /**< CMPA Page programming on going. This field shall be set to 0x5CC55AA5 in
                                            the active CFPA page each time CMPA page programming is going on. It shall
                                            always be set to 0x00000000 in the CFPA scratch area., offset: 0x2C */
    union
    {                                             /* offset: 0x30 */
        __IO uint32_t PRINCE_REGION0_IV_CODE[14]; /**< ., array offset: 0x30, array step: 0x4 */
        struct
        {                                             /* offset: 0x30 */
            __IO uint32_t PRINCE_REGION0_IV_HEADER0;  /**< ., offset: 0x30 */
            __IO uint32_t PRINCE_REGION0_IV_HEADER1;  /**< ., offset: 0x34 */
            __IO uint32_t PRINCE_REGION0_IV_BODY[12]; /**< ., array offset: 0x38, array step: 0x4 */
        } PRINCE_REGION0_IV_CODE_CORE;
    };
    union
    {                                             /* offset: 0x68 */
        __IO uint32_t PRINCE_REGION1_IV_CODE[14]; /**< ., array offset: 0x68, array step: 0x4 */
        struct
        {                                             /* offset: 0x68 */
            __IO uint32_t PRINCE_REGION1_IV_HEADER0;  /**< ., offset: 0x68 */
            __IO uint32_t PRINCE_REGION1_IV_HEADER1;  /**< ., offset: 0x6C */
            __IO uint32_t PRINCE_REGION1_IV_BODY[12]; /**< ., array offset: 0x70, array step: 0x4 */
        } PRINCE_REGION1_IV_CODE_CORE;
    };
    union
    {                                             /* offset: 0xA0 */
        __IO uint32_t PRINCE_REGION2_IV_CODE[14]; /**< ., array offset: 0xA0, array step: 0x4 */
        struct
        {                                             /* offset: 0xA0 */
            __IO uint32_t PRINCE_REGION2_IV_HEADER0;  /**< ., offset: 0xA0 */
            __IO uint32_t PRINCE_REGION2_IV_HEADER1;  /**< ., offset: 0xA4 */
            __IO uint32_t PRINCE_REGION2_IV_BODY[12]; /**< ., array offset: 0xA8, array step: 0x4 */
        } PRINCE_REGION2_IV_CODE_CORE;
    };
    uint8_t RESERVED_1[40];
    __IO uint32_t CUSTOMER_DEFINED[56]; /**< Customer Defined (Programable through ROM API), array offset: 0x100, array
                                           step: 0x4 */
    __IO uint32_t
        SHA256_DIGEST[8]; /**< SHA256_DIGEST0 for DIGEST[31:0] SHA256_DIGEST1 for DIGEST[63:32] SHA256_DIGEST2 for
                             DIGEST[95:64] SHA256_DIGEST3 for DIGEST[127:96] SHA256_DIGEST4 for DIGEST[159:128]
                             SHA256_DIGEST5 for DIGEST[191:160] SHA256_DIGEST6 for DIGEST[223:192] SHA256_DIGEST7 for
                             DIGEST[255:224], array offset: 0x1E0, array step: 0x4 */
} FLASH_CFPA_Type;

/* ----------------------------------------------------------------------------
   -- FLASH_CFPA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_CFPA_Register_Masks FLASH_CFPA Register Masks
 * @{
 */

/*! @name HEADER - . */
/*! @{ */
#define FLASH_CFPA_HEADER_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_HEADER_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_HEADER_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_HEADER_FIELD_SHIFT)) & FLASH_CFPA_HEADER_FIELD_MASK)
/*! @} */

/*! @name VERSION - . */
/*! @{ */
#define FLASH_CFPA_VERSION_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_VERSION_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_VERSION_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_VERSION_FIELD_SHIFT)) & FLASH_CFPA_VERSION_FIELD_MASK)
/*! @} */

/*! @name S_FW_VERSION - Secure firmware version (Monotonic counter) */
/*! @{ */
#define FLASH_CFPA_S_FW_VERSION_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_S_FW_VERSION_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_S_FW_VERSION_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_S_FW_VERSION_FIELD_SHIFT)) & FLASH_CFPA_S_FW_VERSION_FIELD_MASK)
/*! @} */

/*! @name NS_FW_VERSION - Non-Secure firmware version (Monotonic counter) */
/*! @{ */
#define FLASH_CFPA_NS_FW_VERSION_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_NS_FW_VERSION_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_NS_FW_VERSION_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_NS_FW_VERSION_FIELD_SHIFT)) & FLASH_CFPA_NS_FW_VERSION_FIELD_MASK)
/*! @} */

/*! @name IMAGE_KEY_REVOKE - Image key revocation ID (Monotonic counter) */
/*! @{ */
#define FLASH_CFPA_IMAGE_KEY_REVOKE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_IMAGE_KEY_REVOKE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_IMAGE_KEY_REVOKE_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_IMAGE_KEY_REVOKE_FIELD_SHIFT)) & FLASH_CFPA_IMAGE_KEY_REVOKE_FIELD_MASK)
/*! @} */

/*! @name ROTKH_REVOKE - . */
/*! @{ */
#define FLASH_CFPA_ROTKH_REVOKE_RoTK0_EN_MASK (0x3U)
#define FLASH_CFPA_ROTKH_REVOKE_RoTK0_EN_SHIFT (0U)
/*! RoTK0_EN - RoT Key 0 enable. 00 - Invalid 01 - Enabled 10, 11 - Key revoked
 */
#define FLASH_CFPA_ROTKH_REVOKE_RoTK0_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_ROTKH_REVOKE_RoTK0_EN_SHIFT)) & FLASH_CFPA_ROTKH_REVOKE_RoTK0_EN_MASK)
#define FLASH_CFPA_ROTKH_REVOKE_RoTK1_EN_MASK (0xCU)
#define FLASH_CFPA_ROTKH_REVOKE_RoTK1_EN_SHIFT (2U)
/*! RoTK1_EN - RoT Key 1 enable. 00 - Invalid 01 - Enabled 10, 11 - Key revoked
 */
#define FLASH_CFPA_ROTKH_REVOKE_RoTK1_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_ROTKH_REVOKE_RoTK1_EN_SHIFT)) & FLASH_CFPA_ROTKH_REVOKE_RoTK1_EN_MASK)
#define FLASH_CFPA_ROTKH_REVOKE_RoTK2_EN_MASK (0x30U)
#define FLASH_CFPA_ROTKH_REVOKE_RoTK2_EN_SHIFT (4U)
/*! RoTK2_EN - RoT Key 2 enable. 00 - Invalid 01 - Enabled 10, 11 - Key revoked
 */
#define FLASH_CFPA_ROTKH_REVOKE_RoTK2_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_ROTKH_REVOKE_RoTK2_EN_SHIFT)) & FLASH_CFPA_ROTKH_REVOKE_RoTK2_EN_MASK)
/*! @} */

/*! @name VENDOR_USAGE - . */
/*! @{ */
#define FLASH_CFPA_VENDOR_USAGE_DBG_VENDOR_USAGE_MASK (0xFFFFU)
#define FLASH_CFPA_VENDOR_USAGE_DBG_VENDOR_USAGE_SHIFT (0U)
/*! DBG_VENDOR_USAGE - DBG_VENDOR_USAGE.
 */
#define FLASH_CFPA_VENDOR_USAGE_DBG_VENDOR_USAGE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_VENDOR_USAGE_DBG_VENDOR_USAGE_SHIFT)) & \
     FLASH_CFPA_VENDOR_USAGE_DBG_VENDOR_USAGE_MASK)
#define FLASH_CFPA_VENDOR_USAGE_INVERSE_VALUE_MASK (0xFFFF0000U)
#define FLASH_CFPA_VENDOR_USAGE_INVERSE_VALUE_SHIFT (16U)
/*! INVERSE_VALUE - inverse value of bits [15:0]
 */
#define FLASH_CFPA_VENDOR_USAGE_INVERSE_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_VENDOR_USAGE_INVERSE_VALUE_SHIFT)) & \
     FLASH_CFPA_VENDOR_USAGE_INVERSE_VALUE_MASK)
/*! @} */

/*! @name DCFG_CC_SOCU_PIN - With TZ-M, the part can be sold by level 1 customers (secure code developer) to level-2
 * customers who develops non-secure code only. - In this scenario, or easy of development, Level-I customer releases
 * the part to always allow non-secure debug. - To allow level-2 customers to further seal the part DCFG_CC_SOCU_NS is
 * used. - ROM will use this word to further restrict the debug access. */
/*! @{ */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_NIDEN_MASK (0x1U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_NIDEN_SHIFT (0U)
/*! NIDEN - Non Secure non-invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_NIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_NIDEN_SHIFT)) & FLASH_CFPA_DCFG_CC_SOCU_PIN_NIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_DBGEN_MASK (0x2U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_DBGEN_SHIFT (1U)
/*! DBGEN - Non Secure debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_DBGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_DBGEN_SHIFT)) & FLASH_CFPA_DCFG_CC_SOCU_PIN_DBGEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_SPNIDEN_MASK (0x4U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_SPNIDEN_SHIFT (2U)
/*! SPNIDEN - Secure non-invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_SPNIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_SPNIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_SPNIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_SPIDEN_MASK (0x8U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_SPIDEN_SHIFT (3U)
/*! SPIDEN - Secure invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_SPIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_SPIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_SPIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_TAPEN_MASK (0x10U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_TAPEN_SHIFT (4U)
/*! TAPEN - JTAG TAP enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_TAPEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_TAPEN_SHIFT)) & FLASH_CFPA_DCFG_CC_SOCU_PIN_TAPEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_DBGEN_MASK (0x20U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_DBGEN_SHIFT (5U)
/*! CPU1_DBGEN - CPU1 (Micro cortex M33) invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_DBGEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_DBGEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_DBGEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_ISP_CMD_EN_MASK (0x40U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_ISP_CMD_EN_SHIFT (6U)
/*! ISP_CMD_EN - ISP Boot Command enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_ISP_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_ISP_CMD_EN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_ISP_CMD_EN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_FA_CMD_EN_MASK (0x80U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_FA_CMD_EN_SHIFT (7U)
/*! FA_CMD_EN - FA Command enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_FA_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_FA_CMD_EN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_FA_CMD_EN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_ME_CMD_EN_MASK (0x100U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_ME_CMD_EN_SHIFT (8U)
/*! ME_CMD_EN - Flash Mass Erase Command enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_ME_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_ME_CMD_EN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_ME_CMD_EN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_NIDEN_MASK (0x200U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_NIDEN_SHIFT (9U)
/*! CPU1_NIDEN - CPU1 (Micro cortex M33) non-invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_NIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_NIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_CPU1_NIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_UUID_CHECK_MASK (0x8000U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_UUID_CHECK_SHIFT (15U)
/*! UUID_CHECK - Enforce UUID match during Debug authentication.
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_UUID_CHECK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_UUID_CHECK_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_UUID_CHECK_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_INVERSE_VALUE_MASK (0xFFFF0000U)
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_INVERSE_VALUE_SHIFT (16U)
/*! INVERSE_VALUE - inverse value of bits [15:0]
 */
#define FLASH_CFPA_DCFG_CC_SOCU_PIN_INVERSE_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_PIN_INVERSE_VALUE_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_PIN_INVERSE_VALUE_MASK)
/*! @} */

/*! @name DCFG_CC_SOCU_DFLT - With TZ-M, the part can be sold by level 1 customers (secure code developer) to level-2
 * customers who develops non-secure code only. - In this scenario, or easy of development, Level-I customer releases
 * the part to always allow non-secure debug. - To allow level-2 customers to further seal the part DCFG_CC_SOCU_NS is
 * used. - ROM will use this word to further restrict the debug access. */
/*! @{ */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_NIDEN_MASK (0x1U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_NIDEN_SHIFT (0U)
/*! NIDEN - Non Secure non-invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_NIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_NIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_NIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_DBGEN_MASK (0x2U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_DBGEN_SHIFT (1U)
/*! DBGEN - Non Secure debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_DBGEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_DBGEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_DBGEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPNIDEN_MASK (0x4U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPNIDEN_SHIFT (2U)
/*! SPNIDEN - Secure non-invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPNIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPNIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPNIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPIDEN_MASK (0x8U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPIDEN_SHIFT (3U)
/*! SPIDEN - Secure invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_SPIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_TAPEN_MASK (0x10U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_TAPEN_SHIFT (4U)
/*! TAPEN - JTAG TAP fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_TAPEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_TAPEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_TAPEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_DBGEN_MASK (0x20U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_DBGEN_SHIFT (5U)
/*! CPU1_DBGEN - CPU1 (Micro cortex M33) invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_DBGEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_DBGEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_DBGEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_ISP_CMD_EN_MASK (0x40U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_ISP_CMD_EN_SHIFT (6U)
/*! ISP_CMD_EN - ISP Boot Command fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_ISP_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_ISP_CMD_EN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_ISP_CMD_EN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_FA_CMD_EN_MASK (0x80U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_FA_CMD_EN_SHIFT (7U)
/*! FA_CMD_EN - FA Command fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_FA_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_FA_CMD_EN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_FA_CMD_EN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_ME_CMD_EN_MASK (0x100U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_ME_CMD_EN_SHIFT (8U)
/*! ME_CMD_EN - Flash Mass Erase Command fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_ME_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_ME_CMD_EN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_ME_CMD_EN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_NIDEN_MASK (0x200U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_NIDEN_SHIFT (9U)
/*! CPU1_NIDEN - CPU1 (Micro cortex M33) non-invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_NIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_NIDEN_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_CPU1_NIDEN_MASK)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_INVERSE_VALUE_MASK (0xFFFF0000U)
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_INVERSE_VALUE_SHIFT (16U)
/*! INVERSE_VALUE - inverse value of bits [15:0]
 */
#define FLASH_CFPA_DCFG_CC_SOCU_DFLT_INVERSE_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_DCFG_CC_SOCU_DFLT_INVERSE_VALUE_SHIFT)) & \
     FLASH_CFPA_DCFG_CC_SOCU_DFLT_INVERSE_VALUE_MASK)
/*! @} */

/*! @name ENABLE_FA_MODE - Enable FA mode. SET_FA_MODE Command should write 0xC33CA55A to this word to indicate boot ROM
 * to enter FA mode. */
/*! @{ */
#define FLASH_CFPA_ENABLE_FA_MODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_ENABLE_FA_MODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_ENABLE_FA_MODE_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_ENABLE_FA_MODE_FIELD_SHIFT)) & FLASH_CFPA_ENABLE_FA_MODE_FIELD_MASK)
/*! @} */

/*! @name CMPA_PROG_IN_PROGRESS - CMPA Page programming on going. This field shall be set to 0x5CC55AA5 in the active
 * CFPA page each time CMPA page programming is going on. It shall always be set to 0x00000000 in the CFPA scratch area.
 */
/*! @{ */
#define FLASH_CFPA_CMPA_PROG_IN_PROGRESS_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_CMPA_PROG_IN_PROGRESS_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_CMPA_PROG_IN_PROGRESS_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_CMPA_PROG_IN_PROGRESS_FIELD_SHIFT)) & \
     FLASH_CFPA_CMPA_PROG_IN_PROGRESS_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION0_IV_CODE - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION0_IV_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION0_IV_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION0_IV_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION0_IV_CODE_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION0_IV_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_PRINCE_REGION0_IV_CODE */
#define FLASH_CFPA_PRINCE_REGION0_IV_CODE_COUNT (14U)

/*! @name PRINCE_REGION0_IV_HEADER0 - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION0_IV_HEADER0_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION0_IV_HEADER0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION0_IV_HEADER1 - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_TYPE_MASK (0x3U)
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_TYPE_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_TYPE_MASK)
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_INDEX_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_INDEX_MASK)
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_SIZE_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION0_IV_HEADER1_SIZE_MASK)
/*! @} */

/*! @name PRINCE_REGION0_IV_BODY - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION0_IV_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION0_IV_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION0_IV_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION0_IV_BODY_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION0_IV_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_PRINCE_REGION0_IV_BODY */
#define FLASH_CFPA_PRINCE_REGION0_IV_BODY_COUNT (12U)

/*! @name PRINCE_REGION1_IV_CODE - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION1_IV_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION1_IV_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION1_IV_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION1_IV_CODE_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION1_IV_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_PRINCE_REGION1_IV_CODE */
#define FLASH_CFPA_PRINCE_REGION1_IV_CODE_COUNT (14U)

/*! @name PRINCE_REGION1_IV_HEADER0 - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION1_IV_HEADER0_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION1_IV_HEADER0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION1_IV_HEADER1 - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_TYPE_MASK (0x3U)
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_TYPE_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_TYPE_MASK)
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_INDEX_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_INDEX_MASK)
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_SIZE_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION1_IV_HEADER1_SIZE_MASK)
/*! @} */

/*! @name PRINCE_REGION1_IV_BODY - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION1_IV_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION1_IV_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION1_IV_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION1_IV_BODY_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION1_IV_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_PRINCE_REGION1_IV_BODY */
#define FLASH_CFPA_PRINCE_REGION1_IV_BODY_COUNT (12U)

/*! @name PRINCE_REGION2_IV_CODE - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION2_IV_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION2_IV_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION2_IV_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION2_IV_CODE_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION2_IV_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_PRINCE_REGION2_IV_CODE */
#define FLASH_CFPA_PRINCE_REGION2_IV_CODE_COUNT (14U)

/*! @name PRINCE_REGION2_IV_HEADER0 - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION2_IV_HEADER0_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION2_IV_HEADER0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION2_IV_HEADER1 - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_TYPE_MASK (0x3U)
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_TYPE_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_TYPE_MASK)
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_INDEX_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_INDEX_MASK)
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_SIZE_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION2_IV_HEADER1_SIZE_MASK)
/*! @} */

/*! @name PRINCE_REGION2_IV_BODY - . */
/*! @{ */
#define FLASH_CFPA_PRINCE_REGION2_IV_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_PRINCE_REGION2_IV_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_PRINCE_REGION2_IV_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_PRINCE_REGION2_IV_BODY_FIELD_SHIFT)) & \
     FLASH_CFPA_PRINCE_REGION2_IV_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_PRINCE_REGION2_IV_BODY */
#define FLASH_CFPA_PRINCE_REGION2_IV_BODY_COUNT (12U)

/*! @name CUSTOMER_DEFINED - Customer Defined (Programable through ROM API) */
/*! @{ */
#define FLASH_CFPA_CUSTOMER_DEFINED_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_CUSTOMER_DEFINED_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_CUSTOMER_DEFINED_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_CUSTOMER_DEFINED_FIELD_SHIFT)) & FLASH_CFPA_CUSTOMER_DEFINED_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_CUSTOMER_DEFINED */
#define FLASH_CFPA_CUSTOMER_DEFINED_COUNT (56U)

/*! @name SHA256_DIGEST - SHA256_DIGEST0 for DIGEST[31:0] SHA256_DIGEST1 for DIGEST[63:32] SHA256_DIGEST2 for
 * DIGEST[95:64] SHA256_DIGEST3 for DIGEST[127:96] SHA256_DIGEST4 for DIGEST[159:128] SHA256_DIGEST5 for DIGEST[191:160]
 * SHA256_DIGEST6 for DIGEST[223:192] SHA256_DIGEST7 for DIGEST[255:224] */
/*! @{ */
#define FLASH_CFPA_SHA256_DIGEST_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CFPA_SHA256_DIGEST_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CFPA_SHA256_DIGEST_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CFPA_SHA256_DIGEST_FIELD_SHIFT)) & FLASH_CFPA_SHA256_DIGEST_FIELD_MASK)
/*! @} */

/* The count of FLASH_CFPA_SHA256_DIGEST */
#define FLASH_CFPA_SHA256_DIGEST_COUNT (8U)

/*!
 * @}
 */ /* end of group FLASH_CFPA_Register_Masks */

/* FLASH_CFPA - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral FLASH_CFPA0 base address */
#define FLASH_CFPA0_BASE (0x1009E000u)
/** Peripheral FLASH_CFPA0 base address */
#define FLASH_CFPA0_BASE_NS (0x9E000u)
/** Peripheral FLASH_CFPA0 base pointer */
#define FLASH_CFPA0 ((FLASH_CFPA_Type *)FLASH_CFPA0_BASE)
/** Peripheral FLASH_CFPA0 base pointer */
#define FLASH_CFPA0_NS ((FLASH_CFPA_Type *)FLASH_CFPA0_BASE_NS)
/** Peripheral FLASH_CFPA1 base address */
#define FLASH_CFPA1_BASE (0x1009E200u)
/** Peripheral FLASH_CFPA1 base address */
#define FLASH_CFPA1_BASE_NS (0x9E200u)
/** Peripheral FLASH_CFPA1 base pointer */
#define FLASH_CFPA1 ((FLASH_CFPA_Type *)FLASH_CFPA1_BASE)
/** Peripheral FLASH_CFPA1 base pointer */
#define FLASH_CFPA1_NS ((FLASH_CFPA_Type *)FLASH_CFPA1_BASE_NS)
/** Peripheral FLASH_CFPA_SCRATCH base address */
#define FLASH_CFPA_SCRATCH_BASE (0x1009DE00u)
/** Peripheral FLASH_CFPA_SCRATCH base address */
#define FLASH_CFPA_SCRATCH_BASE_NS (0x9DE00u)
/** Peripheral FLASH_CFPA_SCRATCH base pointer */
#define FLASH_CFPA_SCRATCH ((FLASH_CFPA_Type *)FLASH_CFPA_SCRATCH_BASE)
/** Peripheral FLASH_CFPA_SCRATCH base pointer */
#define FLASH_CFPA_SCRATCH_NS ((FLASH_CFPA_Type *)FLASH_CFPA_SCRATCH_BASE_NS)
/** Array initializer of FLASH_CFPA peripheral base addresses */
#define FLASH_CFPA_BASE_ADDRS                                       \
    {                                                               \
        FLASH_CFPA0_BASE, FLASH_CFPA1_BASE, FLASH_CFPA_SCRATCH_BASE \
    }
/** Array initializer of FLASH_CFPA peripheral base pointers */
#define FLASH_CFPA_BASE_PTRS                         \
    {                                                \
        FLASH_CFPA0, FLASH_CFPA1, FLASH_CFPA_SCRATCH \
    }
/** Array initializer of FLASH_CFPA peripheral base addresses */
#define FLASH_CFPA_BASE_ADDRS_NS                                             \
    {                                                                        \
        FLASH_CFPA0_BASE_NS, FLASH_CFPA1_BASE_NS, FLASH_CFPA_SCRATCH_BASE_NS \
    }
/** Array initializer of FLASH_CFPA peripheral base pointers */
#define FLASH_CFPA_BASE_PTRS_NS                               \
    {                                                         \
        FLASH_CFPA0_NS, FLASH_CFPA1_NS, FLASH_CFPA_SCRATCH_NS \
    }
#else
/** Peripheral FLASH_CFPA0 base address */
#define FLASH_CFPA0_BASE (0x9E000u)
/** Peripheral FLASH_CFPA0 base pointer */
#define FLASH_CFPA0 ((FLASH_CFPA_Type *)FLASH_CFPA0_BASE)
/** Peripheral FLASH_CFPA1 base address */
#define FLASH_CFPA1_BASE (0x9E200u)
/** Peripheral FLASH_CFPA1 base pointer */
#define FLASH_CFPA1 ((FLASH_CFPA_Type *)FLASH_CFPA1_BASE)
/** Peripheral FLASH_CFPA_SCRATCH base address */
#define FLASH_CFPA_SCRATCH_BASE (0x9DE00u)
/** Peripheral FLASH_CFPA_SCRATCH base pointer */
#define FLASH_CFPA_SCRATCH ((FLASH_CFPA_Type *)FLASH_CFPA_SCRATCH_BASE)
/** Array initializer of FLASH_CFPA peripheral base addresses */
#define FLASH_CFPA_BASE_ADDRS                                       \
    {                                                               \
        FLASH_CFPA0_BASE, FLASH_CFPA1_BASE, FLASH_CFPA_SCRATCH_BASE \
    }
/** Array initializer of FLASH_CFPA peripheral base pointers */
#define FLASH_CFPA_BASE_PTRS                         \
    {                                                \
        FLASH_CFPA0, FLASH_CFPA1, FLASH_CFPA_SCRATCH \
    }
#endif

/*!
 * @}
 */ /* end of group FLASH_CFPA_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- FLASH_CMPA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_CMPA_Peripheral_Access_Layer FLASH_CMPA Peripheral Access Layer
 * @{
 */

/** FLASH_CMPA - Register Layout Typedef */
typedef struct
{
    __IO uint32_t BOOT_CFG;                 /**< ., offset: 0x0 */
    __IO uint32_t SPI_FLASH_CFG;            /**< ., offset: 0x4 */
    __IO uint32_t USB_ID;                   /**< ., offset: 0x8 */
    __IO uint32_t SDIO_CFG;                 /**< ., offset: 0xC */
    __IO uint32_t CC_SOCU_PIN;              /**< ., offset: 0x10 */
    __IO uint32_t CC_SOCU_DFLT;             /**< ., offset: 0x14 */
    __IO uint32_t VENDOR_USAGE;             /**< ., offset: 0x18 */
    __IO uint32_t SECURE_BOOT_CFG;          /**< ., offset: 0x1C */
    __IO uint32_t PRINCE_BASE_ADDR;         /**< ., offset: 0x20 */
    __IO uint32_t PRINCE_SR_0;              /**< Region 0, sub-region enable, offset: 0x24 */
    __IO uint32_t PRINCE_SR_1;              /**< Region 1, sub-region enable, offset: 0x28 */
    __IO uint32_t PRINCE_SR_2;              /**< Region 2, sub-region enable, offset: 0x2C */
    __IO uint32_t XTAL_32KHZ_CAPABANK_TRIM; /**< Xtal 32kHz capabank triming., offset: 0x30 */
    __IO uint32_t XTAL_16MHZ_CAPABANK_TRIM; /**< Xtal 16MHz capabank triming., offset: 0x34 */
    uint8_t RESERVED_0[24];
    __IO uint32_t ROTKH[8]; /**< ROTKH0 for Root of Trust Keys Table hash[255:224] ROTKH1 for Root of Trust Keys Table
                               hash[223:192] ROTKH2 for Root of Trust Keys Table hash[191:160] ROTKH3 for Root of Trust
                               Keys Table hash[159:128] ROTKH4 for Root of Trust Keys Table hash[127:96] ROTKH5 for Root
                               of Trust Keys Table hash[95:64] ROTKH6 for Root of Trust Keys Table hash[63:32] ROTKH7
                               for Root of Trust Keys Table hash[31:0], array offset: 0x50, array step: 0x4 */
    uint8_t RESERVED_1[144];
    __IO uint32_t CUSTOMER_DEFINED[56]; /**< Customer Defined (Programable through ROM API), array offset: 0x100, array
                                           step: 0x4 */
    __IO uint32_t
        SHA256_DIGEST[8]; /**< SHA256_DIGEST0 for DIGEST[31:0] SHA256_DIGEST1 for DIGEST[63:32] SHA256_DIGEST2 for
                             DIGEST[95:64] SHA256_DIGEST3 for DIGEST[127:96] SHA256_DIGEST4 for DIGEST[159:128]
                             SHA256_DIGEST5 for DIGEST[191:160] SHA256_DIGEST6 for DIGEST[223:192] SHA256_DIGEST7 for
                             DIGEST[255:224], array offset: 0x1E0, array step: 0x4 */
} FLASH_CMPA_Type;

/* ----------------------------------------------------------------------------
   -- FLASH_CMPA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_CMPA_Register_Masks FLASH_CMPA Register Masks
 * @{
 */

/*! @name BOOT_CFG - . */
/*! @{ */
#define FLASH_CMPA_BOOT_CFG_DEFAULT_ISP_MODE_MASK (0x70U)
#define FLASH_CMPA_BOOT_CFG_DEFAULT_ISP_MODE_SHIFT (4U)
/*! DEFAULT_ISP_MODE - Default ISP mode:
 *  0b000..Auto ISP
 *  0b001..USB_HID_MSC
 *  0b010..SPI Slave ISP
 *  0b011..I2C Slave ISP
 *  0b111..Disable ISP fall through
 */
#define FLASH_CMPA_BOOT_CFG_DEFAULT_ISP_MODE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_BOOT_CFG_DEFAULT_ISP_MODE_SHIFT)) & \
     FLASH_CMPA_BOOT_CFG_DEFAULT_ISP_MODE_MASK)
#define FLASH_CMPA_BOOT_CFG_BOOT_SPEED_MASK (0x180U)
#define FLASH_CMPA_BOOT_CFG_BOOT_SPEED_SHIFT (7U)
/*! BOOT_SPEED - Core clock:
 *  0b00..Defined by NMPA.SYSTEM_SPEED_CODE
 *  0b01..48MHz FRO
 *  0b10..96MHz FRO
 */
#define FLASH_CMPA_BOOT_CFG_BOOT_SPEED(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_BOOT_CFG_BOOT_SPEED_SHIFT)) & FLASH_CMPA_BOOT_CFG_BOOT_SPEED_MASK)
#define FLASH_CMPA_BOOT_CFG_BOOT_FAILURE_PIN_MASK (0xFF000000U)
#define FLASH_CMPA_BOOT_CFG_BOOT_FAILURE_PIN_SHIFT (24U)
/*! BOOT_FAILURE_PIN - GPIO port and pin number to use for indicating failure reason. The toggle
 *    rate of the pin is used to decode the error type. [2:0] - Defines GPIO port [7:3] - Defines GPIO
 *    pin
 */
#define FLASH_CMPA_BOOT_CFG_BOOT_FAILURE_PIN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_BOOT_CFG_BOOT_FAILURE_PIN_SHIFT)) & \
     FLASH_CMPA_BOOT_CFG_BOOT_FAILURE_PIN_MASK)
/*! @} */

/*! @name SPI_FLASH_CFG - . */
/*! @{ */
#define FLASH_CMPA_SPI_FLASH_CFG_SPI_RECOVERY_BOOT_EN_MASK (0x1FU)
#define FLASH_CMPA_SPI_FLASH_CFG_SPI_RECOVERY_BOOT_EN_SHIFT (0U)
/*! SPI_RECOVERY_BOOT_EN - SPI flash recovery boot is enabled, if non-zero value is written to this field.
 */
#define FLASH_CMPA_SPI_FLASH_CFG_SPI_RECOVERY_BOOT_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SPI_FLASH_CFG_SPI_RECOVERY_BOOT_EN_SHIFT)) & \
     FLASH_CMPA_SPI_FLASH_CFG_SPI_RECOVERY_BOOT_EN_MASK)
/*! @} */

/*! @name USB_ID - . */
/*! @{ */
#define FLASH_CMPA_USB_ID_USB_VENDOR_ID_MASK (0xFFFFU)
#define FLASH_CMPA_USB_ID_USB_VENDOR_ID_SHIFT (0U)
/*! USB_VENDOR_ID - .
 */
#define FLASH_CMPA_USB_ID_USB_VENDOR_ID(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_USB_ID_USB_VENDOR_ID_SHIFT)) & FLASH_CMPA_USB_ID_USB_VENDOR_ID_MASK)
#define FLASH_CMPA_USB_ID_USB_PRODUCT_ID_MASK (0xFFFF0000U)
#define FLASH_CMPA_USB_ID_USB_PRODUCT_ID_SHIFT (16U)
/*! USB_PRODUCT_ID - .
 */
#define FLASH_CMPA_USB_ID_USB_PRODUCT_ID(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_USB_ID_USB_PRODUCT_ID_SHIFT)) & FLASH_CMPA_USB_ID_USB_PRODUCT_ID_MASK)
/*! @} */

/*! @name SDIO_CFG - . */
/*! @{ */
#define FLASH_CMPA_SDIO_CFG_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_SDIO_CFG_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_SDIO_CFG_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SDIO_CFG_FIELD_SHIFT)) & FLASH_CMPA_SDIO_CFG_FIELD_MASK)
/*! @} */

/*! @name CC_SOCU_PIN - . */
/*! @{ */
#define FLASH_CMPA_CC_SOCU_PIN_NIDEN_MASK (0x1U)
#define FLASH_CMPA_CC_SOCU_PIN_NIDEN_SHIFT (0U)
/*! NIDEN - Non Secure non-invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_NIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_NIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_NIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_DBGEN_MASK (0x2U)
#define FLASH_CMPA_CC_SOCU_PIN_DBGEN_SHIFT (1U)
/*! DBGEN - Non Secure debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_DBGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_DBGEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_DBGEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_SPNIDEN_MASK (0x4U)
#define FLASH_CMPA_CC_SOCU_PIN_SPNIDEN_SHIFT (2U)
/*! SPNIDEN - Secure non-invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_SPNIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_SPNIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_SPNIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_SPIDEN_MASK (0x8U)
#define FLASH_CMPA_CC_SOCU_PIN_SPIDEN_SHIFT (3U)
/*! SPIDEN - Secure invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_SPIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_SPIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_SPIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_TAPEN_MASK (0x10U)
#define FLASH_CMPA_CC_SOCU_PIN_TAPEN_SHIFT (4U)
/*! TAPEN - JTAG TAP enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_TAPEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_TAPEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_TAPEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_CPU1_DBGEN_MASK (0x20U)
#define FLASH_CMPA_CC_SOCU_PIN_CPU1_DBGEN_SHIFT (5U)
/*! CPU1_DBGEN - CPU1 (Micro cortex M33) invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_CPU1_DBGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_CPU1_DBGEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_CPU1_DBGEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_ISP_CMD_EN_MASK (0x40U)
#define FLASH_CMPA_CC_SOCU_PIN_ISP_CMD_EN_SHIFT (6U)
/*! ISP_CMD_EN - ISP Boot Command enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_ISP_CMD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_ISP_CMD_EN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_ISP_CMD_EN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_FA_CMD_EN_MASK (0x80U)
#define FLASH_CMPA_CC_SOCU_PIN_FA_CMD_EN_SHIFT (7U)
/*! FA_CMD_EN - FA Command enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_FA_CMD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_FA_CMD_EN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_FA_CMD_EN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_ME_CMD_EN_MASK (0x100U)
#define FLASH_CMPA_CC_SOCU_PIN_ME_CMD_EN_SHIFT (8U)
/*! ME_CMD_EN - Flash Mass Erase Command enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_ME_CMD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_ME_CMD_EN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_ME_CMD_EN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_CPU1_NIDEN_MASK (0x200U)
#define FLASH_CMPA_CC_SOCU_PIN_CPU1_NIDEN_SHIFT (9U)
/*! CPU1_NIDEN - CPU1 (Micro cortex M33) non-invasive debug enable
 *  0b0..Use DAP to enable
 *  0b1..Fixed state
 */
#define FLASH_CMPA_CC_SOCU_PIN_CPU1_NIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_CPU1_NIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_CPU1_NIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_UUID_CHECK_MASK (0x8000U)
#define FLASH_CMPA_CC_SOCU_PIN_UUID_CHECK_SHIFT (15U)
/*! UUID_CHECK - Enforce UUID match during Debug authentication.
 */
#define FLASH_CMPA_CC_SOCU_PIN_UUID_CHECK(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_UUID_CHECK_SHIFT)) & FLASH_CMPA_CC_SOCU_PIN_UUID_CHECK_MASK)
#define FLASH_CMPA_CC_SOCU_PIN_INVERSE_VALUE_MASK (0xFFFF0000U)
#define FLASH_CMPA_CC_SOCU_PIN_INVERSE_VALUE_SHIFT (16U)
/*! INVERSE_VALUE - inverse value of bits [15:0]
 */
#define FLASH_CMPA_CC_SOCU_PIN_INVERSE_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_PIN_INVERSE_VALUE_SHIFT)) & \
     FLASH_CMPA_CC_SOCU_PIN_INVERSE_VALUE_MASK)
/*! @} */

/*! @name CC_SOCU_DFLT - . */
/*! @{ */
#define FLASH_CMPA_CC_SOCU_DFLT_NIDEN_MASK (0x1U)
#define FLASH_CMPA_CC_SOCU_DFLT_NIDEN_SHIFT (0U)
/*! NIDEN - Non Secure non-invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_NIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_NIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_NIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_DBGEN_MASK (0x2U)
#define FLASH_CMPA_CC_SOCU_DFLT_DBGEN_SHIFT (1U)
/*! DBGEN - Non Secure debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_DBGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_DBGEN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_DBGEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_SPNIDEN_MASK (0x4U)
#define FLASH_CMPA_CC_SOCU_DFLT_SPNIDEN_SHIFT (2U)
/*! SPNIDEN - Secure non-invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_SPNIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_SPNIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_SPNIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_SPIDEN_MASK (0x8U)
#define FLASH_CMPA_CC_SOCU_DFLT_SPIDEN_SHIFT (3U)
/*! SPIDEN - Secure invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_SPIDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_SPIDEN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_SPIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_TAPEN_MASK (0x10U)
#define FLASH_CMPA_CC_SOCU_DFLT_TAPEN_SHIFT (4U)
/*! TAPEN - JTAG TAP fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_TAPEN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_TAPEN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_TAPEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_CPU1_DBGEN_MASK (0x20U)
#define FLASH_CMPA_CC_SOCU_DFLT_CPU1_DBGEN_SHIFT (5U)
/*! CPU1_DBGEN - CPU1 (Micro cortex M33) invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_CPU1_DBGEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_CPU1_DBGEN_SHIFT)) & \
     FLASH_CMPA_CC_SOCU_DFLT_CPU1_DBGEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_ISP_CMD_EN_MASK (0x40U)
#define FLASH_CMPA_CC_SOCU_DFLT_ISP_CMD_EN_SHIFT (6U)
/*! ISP_CMD_EN - ISP Boot Command fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_ISP_CMD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_ISP_CMD_EN_SHIFT)) & \
     FLASH_CMPA_CC_SOCU_DFLT_ISP_CMD_EN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_FA_CMD_EN_MASK (0x80U)
#define FLASH_CMPA_CC_SOCU_DFLT_FA_CMD_EN_SHIFT (7U)
/*! FA_CMD_EN - FA Command fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_FA_CMD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_FA_CMD_EN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_FA_CMD_EN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_ME_CMD_EN_MASK (0x100U)
#define FLASH_CMPA_CC_SOCU_DFLT_ME_CMD_EN_SHIFT (8U)
/*! ME_CMD_EN - Flash Mass Erase Command fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_ME_CMD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_ME_CMD_EN_SHIFT)) & FLASH_CMPA_CC_SOCU_DFLT_ME_CMD_EN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_CPU1_NIDEN_MASK (0x200U)
#define FLASH_CMPA_CC_SOCU_DFLT_CPU1_NIDEN_SHIFT (9U)
/*! CPU1_NIDEN - CPU1 (Micro cortex M33) non-invasive debug fixed state
 *  0b0..Disable
 *  0b1..Enable
 */
#define FLASH_CMPA_CC_SOCU_DFLT_CPU1_NIDEN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_CPU1_NIDEN_SHIFT)) & \
     FLASH_CMPA_CC_SOCU_DFLT_CPU1_NIDEN_MASK)
#define FLASH_CMPA_CC_SOCU_DFLT_INVERSE_VALUE_MASK (0xFFFF0000U)
#define FLASH_CMPA_CC_SOCU_DFLT_INVERSE_VALUE_SHIFT (16U)
/*! INVERSE_VALUE - inverse value of bits [15:0]
 */
#define FLASH_CMPA_CC_SOCU_DFLT_INVERSE_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CC_SOCU_DFLT_INVERSE_VALUE_SHIFT)) & \
     FLASH_CMPA_CC_SOCU_DFLT_INVERSE_VALUE_MASK)
/*! @} */

/*! @name VENDOR_USAGE - . */
/*! @{ */
#define FLASH_CMPA_VENDOR_USAGE_VENDOR_USAGE_MASK (0xFFFF0000U)
#define FLASH_CMPA_VENDOR_USAGE_VENDOR_USAGE_SHIFT (16U)
/*! VENDOR_USAGE - Upper 16 bits of vendor usage field defined in DAP. Lower 16-bits come from customer field area.
 */
#define FLASH_CMPA_VENDOR_USAGE_VENDOR_USAGE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_VENDOR_USAGE_VENDOR_USAGE_SHIFT)) & \
     FLASH_CMPA_VENDOR_USAGE_VENDOR_USAGE_MASK)
/*! @} */

/*! @name SECURE_BOOT_CFG - . */
/*! @{ */
#define FLASH_CMPA_SECURE_BOOT_CFG_RSA4K_MASK (0x3U)
#define FLASH_CMPA_SECURE_BOOT_CFG_RSA4K_SHIFT (0U)
/*! RSA4K - Use RSA4096 keys only. 00- RSA2048 keys 01, 10, 11 - RSA4096 keys
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_RSA4K(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_RSA4K_SHIFT)) & FLASH_CMPA_SECURE_BOOT_CFG_RSA4K_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_ENC_NXP_CFG_MASK (0xCU)
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_ENC_NXP_CFG_SHIFT (2U)
/*! DICE_ENC_NXP_CFG - Include NXP area in DICE computation. 00 - not included 01, 10, 11 - included
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_ENC_NXP_CFG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_DICE_ENC_NXP_CFG_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_DICE_ENC_NXP_CFG_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_CUST_CFG_MASK (0x30U)
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_CUST_CFG_SHIFT (4U)
/*! DICE_CUST_CFG - Include Customer factory area (including keys) in DICE computation. 00 - not included 01, 10, 11 -
 * included
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_CUST_CFG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_DICE_CUST_CFG_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_DICE_CUST_CFG_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_SKIP_DICE_MASK (0xC0U)
#define FLASH_CMPA_SECURE_BOOT_CFG_SKIP_DICE_SHIFT (6U)
/*! SKIP_DICE - Skip DICE computation. 00 - Enable DICE 01,10,11 - Disable DICE
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_SKIP_DICE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_SKIP_DICE_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_SKIP_DICE_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_TZM_IMAGE_TYPE_MASK (0x300U)
#define FLASH_CMPA_SECURE_BOOT_CFG_TZM_IMAGE_TYPE_SHIFT (8U)
/*! TZM_IMAGE_TYPE - TrustZone-M mode. 00 - TZM mode in image header. 01 - Disable TZ-M. Boots to
 *    NonSecure. 10 - TZ-M enable boots to secure mode. 11 - Preset TZM checker from image header.
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_TZM_IMAGE_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_TZM_IMAGE_TYPE_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_TZM_IMAGE_TYPE_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_SET_KEY_MASK (0xC00U)
#define FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_SET_KEY_SHIFT (10U)
/*! BLOCK_SET_KEY - Block PUF key code generation. 00 - Enable Key code generation 01, 10, 11 - Disable key code
 * generation
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_SET_KEY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_SET_KEY_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_SET_KEY_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_ENROLL_MASK (0x3000U)
#define FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_ENROLL_SHIFT (12U)
/*! BLOCK_ENROLL - Block PUF enrollement. 00 - Enable enrollment mode 01, 10, 11 - Disable further enrollmnet
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_ENROLL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_ENROLL_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_BLOCK_ENROLL_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_INC_SEC_EPOCH_MASK (0xC000U)
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_INC_SEC_EPOCH_SHIFT (14U)
/*! DICE_INC_SEC_EPOCH - Include security EPOCH in DICE
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_DICE_INC_SEC_EPOCH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_DICE_INC_SEC_EPOCH_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_DICE_INC_SEC_EPOCH_MASK)
#define FLASH_CMPA_SECURE_BOOT_CFG_SEC_BOOT_EN_MASK (0xC0000000U)
#define FLASH_CMPA_SECURE_BOOT_CFG_SEC_BOOT_EN_SHIFT (30U)
/*! SEC_BOOT_EN - Secure boot enable. 00 - Plain image (internal flash with or without CRC) 01, 10,
 *    11 - Boot signed images. (internal flash, RSA signed)
 */
#define FLASH_CMPA_SECURE_BOOT_CFG_SEC_BOOT_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SECURE_BOOT_CFG_SEC_BOOT_EN_SHIFT)) & \
     FLASH_CMPA_SECURE_BOOT_CFG_SEC_BOOT_EN_MASK)
/*! @} */

/*! @name PRINCE_BASE_ADDR - . */
/*! @{ */
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR0_PRG_MASK (0xFU)
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR0_PRG_SHIFT (0U)
/*! ADDR0_PRG - Programmable portion of the base address of region 0.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR0_PRG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_ADDR0_PRG_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_ADDR0_PRG_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR1_PRG_MASK (0xF0U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR1_PRG_SHIFT (4U)
/*! ADDR1_PRG - Programmable portion of the base address of region 1.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR1_PRG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_ADDR1_PRG_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_ADDR1_PRG_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR2_PRG_MASK (0xF00U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR2_PRG_SHIFT (8U)
/*! ADDR2_PRG - Programmable portion of the base address of region 2.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_ADDR2_PRG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_ADDR2_PRG_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_ADDR2_PRG_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG0_MASK (0x30000U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG0_SHIFT (16U)
/*! LOCK_REG0 - Lock PRINCE region0 settings. 00 - Region is not locked. 01, 10, 11 - Region is locked.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG0(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG0_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG0_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG1_MASK (0xC0000U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG1_SHIFT (18U)
/*! LOCK_REG1 - Lock PRINCE region1 settings. 00 - Region is not locked. 01, 10, 11 - Region is locked.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG1(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG1_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG1_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG2_MASK (0x300000U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG2_SHIFT (20U)
/*! LOCK_REG2 - Lock PRINCE region2 settings. 00 - Region is not locked. 01, 10, 11 - Region is locked.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG2(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG2_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_LOCK_REG2_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG0_ERASE_CHECK_EN_MASK (0x3000000U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG0_ERASE_CHECK_EN_SHIFT (24U)
/*! REG0_ERASE_CHECK_EN - For PRINCE region0 enable checking whether all encrypted pages are erased
 *    together. 00 - Check is disabled. 01, 10, 11 - Check is enabled.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG0_ERASE_CHECK_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_REG0_ERASE_CHECK_EN_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_REG0_ERASE_CHECK_EN_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG1_ERASE_CHECK_EN_MASK (0xC000000U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG1_ERASE_CHECK_EN_SHIFT (26U)
/*! REG1_ERASE_CHECK_EN - For PRINCE region1 enable checking whether all encrypted pages are erased
 *    together. 00 - Check is disabled. 01, 10, 11 - Check is enabled.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG1_ERASE_CHECK_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_REG1_ERASE_CHECK_EN_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_REG1_ERASE_CHECK_EN_MASK)
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG2_ERASE_CHECK_EN_MASK (0x30000000U)
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG2_ERASE_CHECK_EN_SHIFT (28U)
/*! REG2_ERASE_CHECK_EN - For PRINCE region2 enable checking whether all encrypted pages are erased
 *    together. 00 - Check is disabled. 01, 10, 11 - Check is enabled.
 */
#define FLASH_CMPA_PRINCE_BASE_ADDR_REG2_ERASE_CHECK_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_BASE_ADDR_REG2_ERASE_CHECK_EN_SHIFT)) & \
     FLASH_CMPA_PRINCE_BASE_ADDR_REG2_ERASE_CHECK_EN_MASK)
/*! @} */

/*! @name PRINCE_SR_0 - Region 0, sub-region enable */
/*! @{ */
#define FLASH_CMPA_PRINCE_SR_0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_PRINCE_SR_0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_PRINCE_SR_0_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_SR_0_FIELD_SHIFT)) & FLASH_CMPA_PRINCE_SR_0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_SR_1 - Region 1, sub-region enable */
/*! @{ */
#define FLASH_CMPA_PRINCE_SR_1_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_PRINCE_SR_1_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_PRINCE_SR_1_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_SR_1_FIELD_SHIFT)) & FLASH_CMPA_PRINCE_SR_1_FIELD_MASK)
/*! @} */

/*! @name PRINCE_SR_2 - Region 2, sub-region enable */
/*! @{ */
#define FLASH_CMPA_PRINCE_SR_2_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_PRINCE_SR_2_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_PRINCE_SR_2_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_PRINCE_SR_2_FIELD_SHIFT)) & FLASH_CMPA_PRINCE_SR_2_FIELD_MASK)
/*! @} */

/*! @name XTAL_32KHZ_CAPABANK_TRIM - Xtal 32kHz capabank triming. */
/*! @{ */
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_TRIM_VALID_MASK (0x1U)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_TRIM_VALID_SHIFT (0U)
/*! TRIM_VALID - 0 : Capa Bank trimmings not valid. Default trimmings value are used. 1 : Capa Bank trimmings valid.
 */
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_TRIM_VALID(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_TRIM_VALID_SHIFT)) & \
     FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_TRIM_VALID_MASK)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_MASK (0x7FEU)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_SHIFT (1U)
/*! XTAL_LOAD_CAP_IEC_PF_X100 - Load capacitance, pF x 100. For example, 6pF becomes 600.
 */
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_SHIFT)) & \
     FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_MASK)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_MASK (0x1FF800U)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_SHIFT (11U)
/*! PCB_XIN_PARA_CAP_PF_X100 - PCB XIN parasitic capacitance, pF x 100. For example, 6pF becomes 600.
 */
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_SHIFT)) & \
     FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_MASK)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_MASK (0x7FE00000U)
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_SHIFT (21U)
/*! PCB_XOUT_PARA_CAP_PF_X100 - PCB XOUT parasitic capacitance, pF x 100. For example, 6pF becomes 600.
 */
#define FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_SHIFT)) & \
     FLASH_CMPA_XTAL_32KHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_MASK)
/*! @} */

/*! @name XTAL_16MHZ_CAPABANK_TRIM - Xtal 16MHz capabank triming. */
/*! @{ */
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_TRIM_VALID_MASK (0x1U)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_TRIM_VALID_SHIFT (0U)
/*! TRIM_VALID - 0 : Capa Bank trimmings not valid. Default trimmings value are used. 1 : Capa Bank trimmings valid.
 */
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_TRIM_VALID(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_TRIM_VALID_SHIFT)) & \
     FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_TRIM_VALID_MASK)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_MASK (0x7FEU)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_SHIFT (1U)
/*! XTAL_LOAD_CAP_IEC_PF_X100 - Load capacitance, pF x 100. For example, 6pF becomes 600.
 */
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_SHIFT)) & \
     FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_XTAL_LOAD_CAP_IEC_PF_X100_MASK)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_MASK (0x1FF800U)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_SHIFT (11U)
/*! PCB_XIN_PARA_CAP_PF_X100 - PCB XIN parasitic capacitance, pF x 100. For example, 6pF becomes 600.
 */
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_SHIFT)) & \
     FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XIN_PARA_CAP_PF_X100_MASK)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_MASK (0x7FE00000U)
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_SHIFT (21U)
/*! PCB_XOUT_PARA_CAP_PF_X100 - PCB XOUT parasitic capacitance, pF x 100. For example, 6pF becomes 600.
 */
#define FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_SHIFT)) & \
     FLASH_CMPA_XTAL_16MHZ_CAPABANK_TRIM_PCB_XOUT_PARA_CAP_PF_X100_MASK)
/*! @} */

/*! @name ROTKH - ROTKH0 for Root of Trust Keys Table hash[255:224] ROTKH1 for Root of Trust Keys Table hash[223:192]
 * ROTKH2 for Root of Trust Keys Table hash[191:160] ROTKH3 for Root of Trust Keys Table hash[159:128] ROTKH4 for Root
 * of Trust Keys Table hash[127:96] ROTKH5 for Root of Trust Keys Table hash[95:64] ROTKH6 for Root of Trust Keys Table
 * hash[63:32] ROTKH7 for Root of Trust Keys Table hash[31:0] */
/*! @{ */
#define FLASH_CMPA_ROTKH_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_ROTKH_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_ROTKH_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_ROTKH_FIELD_SHIFT)) & FLASH_CMPA_ROTKH_FIELD_MASK)
/*! @} */

/* The count of FLASH_CMPA_ROTKH */
#define FLASH_CMPA_ROTKH_COUNT (8U)

/*! @name CUSTOMER_DEFINED - Customer Defined (Programable through ROM API) */
/*! @{ */
#define FLASH_CMPA_CUSTOMER_DEFINED_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_CUSTOMER_DEFINED_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_CUSTOMER_DEFINED_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_CUSTOMER_DEFINED_FIELD_SHIFT)) & FLASH_CMPA_CUSTOMER_DEFINED_FIELD_MASK)
/*! @} */

/* The count of FLASH_CMPA_CUSTOMER_DEFINED */
#define FLASH_CMPA_CUSTOMER_DEFINED_COUNT (56U)

/*! @name SHA256_DIGEST - SHA256_DIGEST0 for DIGEST[31:0] SHA256_DIGEST1 for DIGEST[63:32] SHA256_DIGEST2 for
 * DIGEST[95:64] SHA256_DIGEST3 for DIGEST[127:96] SHA256_DIGEST4 for DIGEST[159:128] SHA256_DIGEST5 for DIGEST[191:160]
 * SHA256_DIGEST6 for DIGEST[223:192] SHA256_DIGEST7 for DIGEST[255:224] */
/*! @{ */
#define FLASH_CMPA_SHA256_DIGEST_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_CMPA_SHA256_DIGEST_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_CMPA_SHA256_DIGEST_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_CMPA_SHA256_DIGEST_FIELD_SHIFT)) & FLASH_CMPA_SHA256_DIGEST_FIELD_MASK)
/*! @} */

/* The count of FLASH_CMPA_SHA256_DIGEST */
#define FLASH_CMPA_SHA256_DIGEST_COUNT (8U)

/*!
 * @}
 */ /* end of group FLASH_CMPA_Register_Masks */

/* FLASH_CMPA - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral FLASH_CMPA base address */
#define FLASH_CMPA_BASE (0x1009E400u)
/** Peripheral FLASH_CMPA base address */
#define FLASH_CMPA_BASE_NS (0x9E400u)
/** Peripheral FLASH_CMPA base pointer */
#define FLASH_CMPA ((FLASH_CMPA_Type *)FLASH_CMPA_BASE)
/** Peripheral FLASH_CMPA base pointer */
#define FLASH_CMPA_NS ((FLASH_CMPA_Type *)FLASH_CMPA_BASE_NS)
/** Array initializer of FLASH_CMPA peripheral base addresses */
#define FLASH_CMPA_BASE_ADDRS \
    {                         \
        FLASH_CMPA_BASE       \
    }
/** Array initializer of FLASH_CMPA peripheral base pointers */
#define FLASH_CMPA_BASE_PTRS \
    {                        \
        FLASH_CMPA           \
    }
/** Array initializer of FLASH_CMPA peripheral base addresses */
#define FLASH_CMPA_BASE_ADDRS_NS \
    {                            \
        FLASH_CMPA_BASE_NS       \
    }
/** Array initializer of FLASH_CMPA peripheral base pointers */
#define FLASH_CMPA_BASE_PTRS_NS \
    {                           \
        FLASH_CMPA_NS           \
    }
#else
/** Peripheral FLASH_CMPA base address */
#define FLASH_CMPA_BASE (0x9E400u)
/** Peripheral FLASH_CMPA base pointer */
#define FLASH_CMPA ((FLASH_CMPA_Type *)FLASH_CMPA_BASE)
/** Array initializer of FLASH_CMPA peripheral base addresses */
#define FLASH_CMPA_BASE_ADDRS \
    {                         \
        FLASH_CMPA_BASE       \
    }
/** Array initializer of FLASH_CMPA peripheral base pointers */
#define FLASH_CMPA_BASE_PTRS \
    {                        \
        FLASH_CMPA           \
    }
#endif

/*!
 * @}
 */ /* end of group FLASH_CMPA_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- FLASH_KEY_STORE Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_KEY_STORE_Peripheral_Access_Layer FLASH_KEY_STORE Peripheral Access Layer
 * @{
 */

/** FLASH_KEY_STORE - Register Layout Typedef */
typedef struct
{
    struct
    {                                           /* offset: 0x0 */
        __IO uint32_t HEADER;                   /**< Valid Key Sore Header : 0x95959595, offset: 0x0 */
        __IO uint32_t PUF_DISCHARGE_TIME_IN_MS; /**< puf discharge time in ms., offset: 0x4 */
    } KEY_STORE_HEADER;
    __IO uint32_t ACTIVATION_CODE[298]; /**< ., array offset: 0x8, array step: 0x4 */
    union
    {                                     /* offset: 0x4B0 */
        __IO uint32_t SBKEY_KEY_CODE[14]; /**< ., array offset: 0x4B0, array step: 0x4 */
        struct
        {                                 /* offset: 0x4B0 */
            __IO uint32_t SBKEY_HEADER0;  /**< ., offset: 0x4B0 */
            __IO uint32_t SBKEY_HEADER1;  /**< ., offset: 0x4B4 */
            __IO uint32_t SBKEY_BODY[12]; /**< ., array offset: 0x4B8, array step: 0x4 */
        } SBKEY_KEY_CODE_CORE;
    };
    union
    {                                        /* offset: 0x4E8 */
        __IO uint32_t USER_KEK_KEY_CODE[14]; /**< ., array offset: 0x4E8, array step: 0x4 */
        struct
        {                                    /* offset: 0x4E8 */
            __IO uint32_t USER_KEK_HEADER0;  /**< ., offset: 0x4E8 */
            __IO uint32_t USER_KEK_HEADER1;  /**< ., offset: 0x4EC */
            __IO uint32_t USER_KEK_BODY[12]; /**< ., array offset: 0x4F0, array step: 0x4 */
        } USER_KEK_KEY_CODE_CORE;
    };
    union
    {                                   /* offset: 0x520 */
        __IO uint32_t UDS_KEY_CODE[14]; /**< ., array offset: 0x520, array step: 0x4 */
        struct
        {                               /* offset: 0x520 */
            __IO uint32_t UDS_HEADER0;  /**< ., offset: 0x520 */
            __IO uint32_t UDS_HEADER1;  /**< ., offset: 0x524 */
            __IO uint32_t UDS_BODY[12]; /**< ., array offset: 0x528, array step: 0x4 */
        } UDS_KEY_CODE_CORE;
    };
    union
    {                                              /* offset: 0x558 */
        __IO uint32_t PRINCE_REGION0_KEY_CODE[14]; /**< ., array offset: 0x558, array step: 0x4 */
        struct
        {                                          /* offset: 0x558 */
            __IO uint32_t PRINCE_REGION0_HEADER0;  /**< ., offset: 0x558 */
            __IO uint32_t PRINCE_REGION0_HEADER1;  /**< ., offset: 0x55C */
            __IO uint32_t PRINCE_REGION0_BODY[12]; /**< ., array offset: 0x560, array step: 0x4 */
        } PRINCE_REGION0_KEY_CODE_CORE;
    };
    union
    {                                              /* offset: 0x590 */
        __IO uint32_t PRINCE_REGION1_KEY_CODE[14]; /**< ., array offset: 0x590, array step: 0x4 */
        struct
        {                                          /* offset: 0x590 */
            __IO uint32_t PRINCE_REGION1_HEADER0;  /**< ., offset: 0x590 */
            __IO uint32_t PRINCE_REGION1_HEADER1;  /**< ., offset: 0x594 */
            __IO uint32_t PRINCE_REGION1_BODY[12]; /**< ., array offset: 0x598, array step: 0x4 */
        } PRINCE_REGION1_KEY_CODE_CORE;
    };
    union
    {                                              /* offset: 0x5C8 */
        __IO uint32_t PRINCE_REGION2_KEY_CODE[14]; /**< ., array offset: 0x5C8, array step: 0x4 */
        struct
        {                                          /* offset: 0x5C8 */
            __IO uint32_t PRINCE_REGION2_HEADER0;  /**< ., offset: 0x5C8 */
            __IO uint32_t PRINCE_REGION2_HEADER1;  /**< ., offset: 0x5CC */
            __IO uint32_t PRINCE_REGION2_BODY[12]; /**< ., array offset: 0x5D0, array step: 0x4 */
        } PRINCE_REGION2_KEY_CODE_CORE;
    };
} FLASH_KEY_STORE_Type;

/* ----------------------------------------------------------------------------
   -- FLASH_KEY_STORE Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_KEY_STORE_Register_Masks FLASH_KEY_STORE Register Masks
 * @{
 */

/*! @name HEADER - Valid Key Sore Header : 0x95959595 */
/*! @{ */
#define FLASH_KEY_STORE_HEADER_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_HEADER_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_HEADER_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_HEADER_FIELD_SHIFT)) & FLASH_KEY_STORE_HEADER_FIELD_MASK)
/*! @} */

/*! @name PUF_DISCHARGE_TIME_IN_MS - puf discharge time in ms. */
/*! @{ */
#define FLASH_KEY_STORE_PUF_DISCHARGE_TIME_IN_MS_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PUF_DISCHARGE_TIME_IN_MS_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PUF_DISCHARGE_TIME_IN_MS_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PUF_DISCHARGE_TIME_IN_MS_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PUF_DISCHARGE_TIME_IN_MS_FIELD_MASK)
/*! @} */

/*! @name ACTIVATION_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_ACTIVATION_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_ACTIVATION_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_ACTIVATION_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_ACTIVATION_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_ACTIVATION_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_ACTIVATION_CODE */
#define FLASH_KEY_STORE_ACTIVATION_CODE_COUNT (298U)

/*! @name SBKEY_KEY_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_SBKEY_KEY_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_SBKEY_KEY_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_SBKEY_KEY_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_SBKEY_KEY_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_SBKEY_KEY_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_SBKEY_KEY_CODE */
#define FLASH_KEY_STORE_SBKEY_KEY_CODE_COUNT (14U)

/*! @name SBKEY_HEADER0 - . */
/*! @{ */
#define FLASH_KEY_STORE_SBKEY_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_SBKEY_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_SBKEY_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_SBKEY_HEADER0_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_SBKEY_HEADER0_FIELD_MASK)
/*! @} */

/*! @name SBKEY_HEADER1 - . */
/*! @{ */
#define FLASH_KEY_STORE_SBKEY_HEADER1_TYPE_MASK (0x3U)
#define FLASH_KEY_STORE_SBKEY_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_KEY_STORE_SBKEY_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_SBKEY_HEADER1_TYPE_SHIFT)) & \
     FLASH_KEY_STORE_SBKEY_HEADER1_TYPE_MASK)
#define FLASH_KEY_STORE_SBKEY_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_KEY_STORE_SBKEY_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_KEY_STORE_SBKEY_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_SBKEY_HEADER1_INDEX_SHIFT)) & \
     FLASH_KEY_STORE_SBKEY_HEADER1_INDEX_MASK)
#define FLASH_KEY_STORE_SBKEY_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_KEY_STORE_SBKEY_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_KEY_STORE_SBKEY_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_SBKEY_HEADER1_SIZE_SHIFT)) & \
     FLASH_KEY_STORE_SBKEY_HEADER1_SIZE_MASK)
/*! @} */

/*! @name SBKEY_BODY - . */
/*! @{ */
#define FLASH_KEY_STORE_SBKEY_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_SBKEY_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_SBKEY_BODY_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_SBKEY_BODY_FIELD_SHIFT)) & FLASH_KEY_STORE_SBKEY_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_SBKEY_BODY */
#define FLASH_KEY_STORE_SBKEY_BODY_COUNT (12U)

/*! @name USER_KEK_KEY_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_USER_KEK_KEY_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_USER_KEK_KEY_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_USER_KEK_KEY_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_USER_KEK_KEY_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_USER_KEK_KEY_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_USER_KEK_KEY_CODE */
#define FLASH_KEY_STORE_USER_KEK_KEY_CODE_COUNT (14U)

/*! @name USER_KEK_HEADER0 - . */
/*! @{ */
#define FLASH_KEY_STORE_USER_KEK_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_USER_KEK_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_USER_KEK_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_USER_KEK_HEADER0_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_USER_KEK_HEADER0_FIELD_MASK)
/*! @} */

/*! @name USER_KEK_HEADER1 - . */
/*! @{ */
#define FLASH_KEY_STORE_USER_KEK_HEADER1_TYPE_MASK (0x3U)
#define FLASH_KEY_STORE_USER_KEK_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_KEY_STORE_USER_KEK_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_USER_KEK_HEADER1_TYPE_SHIFT)) & \
     FLASH_KEY_STORE_USER_KEK_HEADER1_TYPE_MASK)
#define FLASH_KEY_STORE_USER_KEK_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_KEY_STORE_USER_KEK_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_KEY_STORE_USER_KEK_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_USER_KEK_HEADER1_INDEX_SHIFT)) & \
     FLASH_KEY_STORE_USER_KEK_HEADER1_INDEX_MASK)
#define FLASH_KEY_STORE_USER_KEK_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_KEY_STORE_USER_KEK_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_KEY_STORE_USER_KEK_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_USER_KEK_HEADER1_SIZE_SHIFT)) & \
     FLASH_KEY_STORE_USER_KEK_HEADER1_SIZE_MASK)
/*! @} */

/*! @name USER_KEK_BODY - . */
/*! @{ */
#define FLASH_KEY_STORE_USER_KEK_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_USER_KEK_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_USER_KEK_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_USER_KEK_BODY_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_USER_KEK_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_USER_KEK_BODY */
#define FLASH_KEY_STORE_USER_KEK_BODY_COUNT (12U)

/*! @name UDS_KEY_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_UDS_KEY_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_UDS_KEY_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_UDS_KEY_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_UDS_KEY_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_UDS_KEY_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_UDS_KEY_CODE */
#define FLASH_KEY_STORE_UDS_KEY_CODE_COUNT (14U)

/*! @name UDS_HEADER0 - . */
/*! @{ */
#define FLASH_KEY_STORE_UDS_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_UDS_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_UDS_HEADER0_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_UDS_HEADER0_FIELD_SHIFT)) & FLASH_KEY_STORE_UDS_HEADER0_FIELD_MASK)
/*! @} */

/*! @name UDS_HEADER1 - . */
/*! @{ */
#define FLASH_KEY_STORE_UDS_HEADER1_TYPE_MASK (0x3U)
#define FLASH_KEY_STORE_UDS_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_KEY_STORE_UDS_HEADER1_TYPE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_UDS_HEADER1_TYPE_SHIFT)) & FLASH_KEY_STORE_UDS_HEADER1_TYPE_MASK)
#define FLASH_KEY_STORE_UDS_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_KEY_STORE_UDS_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_KEY_STORE_UDS_HEADER1_INDEX(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_UDS_HEADER1_INDEX_SHIFT)) & FLASH_KEY_STORE_UDS_HEADER1_INDEX_MASK)
#define FLASH_KEY_STORE_UDS_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_KEY_STORE_UDS_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_KEY_STORE_UDS_HEADER1_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_UDS_HEADER1_SIZE_SHIFT)) & FLASH_KEY_STORE_UDS_HEADER1_SIZE_MASK)
/*! @} */

/*! @name UDS_BODY - . */
/*! @{ */
#define FLASH_KEY_STORE_UDS_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_UDS_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_UDS_BODY_FIELD(x) \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_UDS_BODY_FIELD_SHIFT)) & FLASH_KEY_STORE_UDS_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_UDS_BODY */
#define FLASH_KEY_STORE_UDS_BODY_COUNT (12U)

/*! @name PRINCE_REGION0_KEY_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE */
#define FLASH_KEY_STORE_PRINCE_REGION0_KEY_CODE_COUNT (14U)

/*! @name PRINCE_REGION0_HEADER0 - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION0_HEADER0_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION0_HEADER0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION0_HEADER1 - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_TYPE_MASK (0x3U)
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_TYPE_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_TYPE_MASK)
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_INDEX_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_INDEX_MASK)
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_SIZE_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION0_HEADER1_SIZE_MASK)
/*! @} */

/*! @name PRINCE_REGION0_BODY - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION0_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION0_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION0_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION0_BODY_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION0_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_PRINCE_REGION0_BODY */
#define FLASH_KEY_STORE_PRINCE_REGION0_BODY_COUNT (12U)

/*! @name PRINCE_REGION1_KEY_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE */
#define FLASH_KEY_STORE_PRINCE_REGION1_KEY_CODE_COUNT (14U)

/*! @name PRINCE_REGION1_HEADER0 - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION1_HEADER0_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION1_HEADER0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION1_HEADER1 - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_TYPE_MASK (0x3U)
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_TYPE_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_TYPE_MASK)
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_INDEX_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_INDEX_MASK)
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_SIZE_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION1_HEADER1_SIZE_MASK)
/*! @} */

/*! @name PRINCE_REGION1_BODY - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION1_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION1_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION1_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION1_BODY_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION1_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_PRINCE_REGION1_BODY */
#define FLASH_KEY_STORE_PRINCE_REGION1_BODY_COUNT (12U)

/*! @name PRINCE_REGION2_KEY_CODE - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE */
#define FLASH_KEY_STORE_PRINCE_REGION2_KEY_CODE_COUNT (14U)

/*! @name PRINCE_REGION2_HEADER0 - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER0_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER0_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER0_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION2_HEADER0_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION2_HEADER0_FIELD_MASK)
/*! @} */

/*! @name PRINCE_REGION2_HEADER1 - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_TYPE_MASK (0x3U)
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_TYPE_SHIFT (0U)
/*! TYPE - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_TYPE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_TYPE_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_TYPE_MASK)
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_INDEX_MASK (0xF00U)
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_INDEX_SHIFT (8U)
/*! INDEX - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_INDEX(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_INDEX_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_INDEX_MASK)
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_SIZE_MASK (0x3F000000U)
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_SIZE_SHIFT (24U)
/*! SIZE - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_SIZE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_SIZE_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION2_HEADER1_SIZE_MASK)
/*! @} */

/*! @name PRINCE_REGION2_BODY - . */
/*! @{ */
#define FLASH_KEY_STORE_PRINCE_REGION2_BODY_FIELD_MASK (0xFFFFFFFFU)
#define FLASH_KEY_STORE_PRINCE_REGION2_BODY_FIELD_SHIFT (0U)
/*! FIELD - .
 */
#define FLASH_KEY_STORE_PRINCE_REGION2_BODY_FIELD(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << FLASH_KEY_STORE_PRINCE_REGION2_BODY_FIELD_SHIFT)) & \
     FLASH_KEY_STORE_PRINCE_REGION2_BODY_FIELD_MASK)
/*! @} */

/* The count of FLASH_KEY_STORE_PRINCE_REGION2_BODY */
#define FLASH_KEY_STORE_PRINCE_REGION2_BODY_COUNT (12U)

/*!
 * @}
 */ /* end of group FLASH_KEY_STORE_Register_Masks */

/* FLASH_KEY_STORE - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral FLASH_KEY_STORE base address */
#define FLASH_KEY_STORE_BASE (0x1009E600u)
/** Peripheral FLASH_KEY_STORE base address */
#define FLASH_KEY_STORE_BASE_NS (0x9E600u)
/** Peripheral FLASH_KEY_STORE base pointer */
#define FLASH_KEY_STORE ((FLASH_KEY_STORE_Type *)FLASH_KEY_STORE_BASE)
/** Peripheral FLASH_KEY_STORE base pointer */
#define FLASH_KEY_STORE_NS ((FLASH_KEY_STORE_Type *)FLASH_KEY_STORE_BASE_NS)
/** Array initializer of FLASH_KEY_STORE peripheral base addresses */
#define FLASH_KEY_STORE_BASE_ADDRS \
    {                              \
        FLASH_KEY_STORE_BASE       \
    }
/** Array initializer of FLASH_KEY_STORE peripheral base pointers */
#define FLASH_KEY_STORE_BASE_PTRS \
    {                             \
        FLASH_KEY_STORE           \
    }
/** Array initializer of FLASH_KEY_STORE peripheral base addresses */
#define FLASH_KEY_STORE_BASE_ADDRS_NS \
    {                                 \
        FLASH_KEY_STORE_BASE_NS       \
    }
/** Array initializer of FLASH_KEY_STORE peripheral base pointers */
#define FLASH_KEY_STORE_BASE_PTRS_NS \
    {                                \
        FLASH_KEY_STORE_NS           \
    }
#else
/** Peripheral FLASH_KEY_STORE base address */
#define FLASH_KEY_STORE_BASE (0x9E600u)
/** Peripheral FLASH_KEY_STORE base pointer */
#define FLASH_KEY_STORE ((FLASH_KEY_STORE_Type *)FLASH_KEY_STORE_BASE)
/** Array initializer of FLASH_KEY_STORE peripheral base addresses */
#define FLASH_KEY_STORE_BASE_ADDRS \
    {                              \
        FLASH_KEY_STORE_BASE       \
    }
/** Array initializer of FLASH_KEY_STORE peripheral base pointers */
#define FLASH_KEY_STORE_BASE_PTRS \
    {                             \
        FLASH_KEY_STORE           \
    }
#endif

/*!
 * @}
 */ /* end of group FLASH_KEY_STORE_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Peripheral_Access_Layer FLEXCOMM Peripheral Access Layer
 * @{
 */

/** FLEXCOMM - Register Layout Typedef */
typedef struct
{
    uint8_t RESERVED_0[4088];
    __IO uint32_t PSELID; /**< Peripheral Select and Flexcomm ID register., offset: 0xFF8 */
    __I uint32_t PID;     /**< Peripheral identification register., offset: 0xFFC */
} FLEXCOMM_Type;

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Register_Masks FLEXCOMM Register Masks
 * @{
 */

/*! @name PSELID - Peripheral Select and Flexcomm ID register. */
/*! @{ */
#define FLEXCOMM_PSELID_PERSEL_MASK (0x7U)
#define FLEXCOMM_PSELID_PERSEL_SHIFT (0U)
/*! PERSEL - Peripheral Select. This field is writable by software.
 *  0b000..No peripheral selected.
 *  0b001..USART function selected.
 *  0b010..SPI function selected.
 *  0b011..I2C function selected.
 *  0b100..I2S transmit function selected.
 *  0b101..I2S receive function selected.
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define FLEXCOMM_PSELID_PERSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_PERSEL_SHIFT)) & FLEXCOMM_PSELID_PERSEL_MASK)
#define FLEXCOMM_PSELID_LOCK_MASK (0x8U)
#define FLEXCOMM_PSELID_LOCK_SHIFT (3U)
/*! LOCK - Lock the peripheral select. This field is writable by software.
 *  0b0..Peripheral select can be changed by software.
 *  0b1..Peripheral select is locked and cannot be changed until this Flexcomm or the entire device is reset.
 */
#define FLEXCOMM_PSELID_LOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_LOCK_SHIFT)) & FLEXCOMM_PSELID_LOCK_MASK)
#define FLEXCOMM_PSELID_USARTPRESENT_MASK (0x10U)
#define FLEXCOMM_PSELID_USARTPRESENT_SHIFT (4U)
/*! USARTPRESENT - USART present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the USART function.
 *  0b1..This Flexcomm includes the USART function.
 */
#define FLEXCOMM_PSELID_USARTPRESENT(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_USARTPRESENT_SHIFT)) & FLEXCOMM_PSELID_USARTPRESENT_MASK)
#define FLEXCOMM_PSELID_SPIPRESENT_MASK (0x20U)
#define FLEXCOMM_PSELID_SPIPRESENT_SHIFT (5U)
/*! SPIPRESENT - SPI present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the SPI function.
 *  0b1..This Flexcomm includes the SPI function.
 */
#define FLEXCOMM_PSELID_SPIPRESENT(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_SPIPRESENT_SHIFT)) & FLEXCOMM_PSELID_SPIPRESENT_MASK)
#define FLEXCOMM_PSELID_I2CPRESENT_MASK (0x40U)
#define FLEXCOMM_PSELID_I2CPRESENT_SHIFT (6U)
/*! I2CPRESENT - I2C present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the I2C function.
 *  0b1..This Flexcomm includes the I2C function.
 */
#define FLEXCOMM_PSELID_I2CPRESENT(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2CPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2CPRESENT_MASK)
#define FLEXCOMM_PSELID_I2SPRESENT_MASK (0x80U)
#define FLEXCOMM_PSELID_I2SPRESENT_SHIFT (7U)
/*! I2SPRESENT - I 2S present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the I2S function.
 *  0b1..This Flexcomm includes the I2S function.
 */
#define FLEXCOMM_PSELID_I2SPRESENT(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2SPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2SPRESENT_MASK)
#define FLEXCOMM_PSELID_ID_MASK (0xFFFFF000U)
#define FLEXCOMM_PSELID_ID_SHIFT (12U)
/*! ID - Flexcomm ID.
 */
#define FLEXCOMM_PSELID_ID(x) (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_ID_SHIFT)) & FLEXCOMM_PSELID_ID_MASK)
/*! @} */

/*! @name PID - Peripheral identification register. */
/*! @{ */
#define FLEXCOMM_PID_APERTURE_MASK (0xFFU)
#define FLEXCOMM_PID_APERTURE_SHIFT (0U)
/*! APERTURE - size aperture for the register port on the bus (APB or AHB).
 */
#define FLEXCOMM_PID_APERTURE(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_APERTURE_SHIFT)) & FLEXCOMM_PID_APERTURE_MASK)
#define FLEXCOMM_PID_MINOR_REV_MASK (0xF00U)
#define FLEXCOMM_PID_MINOR_REV_SHIFT (8U)
/*! MINOR_REV - Minor revision of module implementation.
 */
#define FLEXCOMM_PID_MINOR_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_MINOR_REV_SHIFT)) & FLEXCOMM_PID_MINOR_REV_MASK)
#define FLEXCOMM_PID_MAJOR_REV_MASK (0xF000U)
#define FLEXCOMM_PID_MAJOR_REV_SHIFT (12U)
/*! MAJOR_REV - Major revision of module implementation.
 */
#define FLEXCOMM_PID_MAJOR_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_MAJOR_REV_SHIFT)) & FLEXCOMM_PID_MAJOR_REV_MASK)
#define FLEXCOMM_PID_ID_MASK (0xFFFF0000U)
#define FLEXCOMM_PID_ID_SHIFT (16U)
/*! ID - Module identifier for the selected function.
 */
#define FLEXCOMM_PID_ID(x) (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_ID_SHIFT)) & FLEXCOMM_PID_ID_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group FLEXCOMM_Register_Masks */

/* FLEXCOMM - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral FLEXCOMM0 base address */
#define FLEXCOMM0_BASE (0x50086000u)
/** Peripheral FLEXCOMM0 base address */
#define FLEXCOMM0_BASE_NS (0x40086000u)
/** Peripheral FLEXCOMM0 base pointer */
#define FLEXCOMM0 ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
/** Peripheral FLEXCOMM0 base pointer */
#define FLEXCOMM0_NS ((FLEXCOMM_Type *)FLEXCOMM0_BASE_NS)
/** Peripheral FLEXCOMM1 base address */
#define FLEXCOMM1_BASE (0x50087000u)
/** Peripheral FLEXCOMM1 base address */
#define FLEXCOMM1_BASE_NS (0x40087000u)
/** Peripheral FLEXCOMM1 base pointer */
#define FLEXCOMM1 ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
/** Peripheral FLEXCOMM1 base pointer */
#define FLEXCOMM1_NS ((FLEXCOMM_Type *)FLEXCOMM1_BASE_NS)
/** Peripheral FLEXCOMM2 base address */
#define FLEXCOMM2_BASE (0x50088000u)
/** Peripheral FLEXCOMM2 base address */
#define FLEXCOMM2_BASE_NS (0x40088000u)
/** Peripheral FLEXCOMM2 base pointer */
#define FLEXCOMM2 ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
/** Peripheral FLEXCOMM2 base pointer */
#define FLEXCOMM2_NS ((FLEXCOMM_Type *)FLEXCOMM2_BASE_NS)
/** Peripheral FLEXCOMM3 base address */
#define FLEXCOMM3_BASE (0x50089000u)
/** Peripheral FLEXCOMM3 base address */
#define FLEXCOMM3_BASE_NS (0x40089000u)
/** Peripheral FLEXCOMM3 base pointer */
#define FLEXCOMM3 ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
/** Peripheral FLEXCOMM3 base pointer */
#define FLEXCOMM3_NS ((FLEXCOMM_Type *)FLEXCOMM3_BASE_NS)
/** Peripheral FLEXCOMM4 base address */
#define FLEXCOMM4_BASE (0x5008A000u)
/** Peripheral FLEXCOMM4 base address */
#define FLEXCOMM4_BASE_NS (0x4008A000u)
/** Peripheral FLEXCOMM4 base pointer */
#define FLEXCOMM4 ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
/** Peripheral FLEXCOMM4 base pointer */
#define FLEXCOMM4_NS ((FLEXCOMM_Type *)FLEXCOMM4_BASE_NS)
/** Peripheral FLEXCOMM5 base address */
#define FLEXCOMM5_BASE (0x50096000u)
/** Peripheral FLEXCOMM5 base address */
#define FLEXCOMM5_BASE_NS (0x40096000u)
/** Peripheral FLEXCOMM5 base pointer */
#define FLEXCOMM5 ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
/** Peripheral FLEXCOMM5 base pointer */
#define FLEXCOMM5_NS ((FLEXCOMM_Type *)FLEXCOMM5_BASE_NS)
/** Peripheral FLEXCOMM6 base address */
#define FLEXCOMM6_BASE (0x50097000u)
/** Peripheral FLEXCOMM6 base address */
#define FLEXCOMM6_BASE_NS (0x40097000u)
/** Peripheral FLEXCOMM6 base pointer */
#define FLEXCOMM6 ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
/** Peripheral FLEXCOMM6 base pointer */
#define FLEXCOMM6_NS ((FLEXCOMM_Type *)FLEXCOMM6_BASE_NS)
/** Peripheral FLEXCOMM7 base address */
#define FLEXCOMM7_BASE (0x50098000u)
/** Peripheral FLEXCOMM7 base address */
#define FLEXCOMM7_BASE_NS (0x40098000u)
/** Peripheral FLEXCOMM7 base pointer */
#define FLEXCOMM7 ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
/** Peripheral FLEXCOMM7 base pointer */
#define FLEXCOMM7_NS ((FLEXCOMM_Type *)FLEXCOMM7_BASE_NS)
/** Peripheral FLEXCOMM8 base address */
#define FLEXCOMM8_BASE (0x5009F000u)
/** Peripheral FLEXCOMM8 base address */
#define FLEXCOMM8_BASE_NS (0x4009F000u)
/** Peripheral FLEXCOMM8 base pointer */
#define FLEXCOMM8 ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
/** Peripheral FLEXCOMM8 base pointer */
#define FLEXCOMM8_NS ((FLEXCOMM_Type *)FLEXCOMM8_BASE_NS)
/** Array initializer of FLEXCOMM peripheral base addresses */
#define FLEXCOMM_BASE_ADDRS                                                                             \
    {                                                                                                   \
        FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, \
            FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE                                              \
    }
/** Array initializer of FLEXCOMM peripheral base pointers */
#define FLEXCOMM_BASE_PTRS                                                                                \
    {                                                                                                     \
        FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8 \
    }
/** Array initializer of FLEXCOMM peripheral base addresses */
#define FLEXCOMM_BASE_ADDRS_NS                                                                         \
    {                                                                                                  \
        FLEXCOMM0_BASE_NS, FLEXCOMM1_BASE_NS, FLEXCOMM2_BASE_NS, FLEXCOMM3_BASE_NS, FLEXCOMM4_BASE_NS, \
            FLEXCOMM5_BASE_NS, FLEXCOMM6_BASE_NS, FLEXCOMM7_BASE_NS, FLEXCOMM8_BASE_NS                 \
    }
/** Array initializer of FLEXCOMM peripheral base pointers */
#define FLEXCOMM_BASE_PTRS_NS                                                                             \
    {                                                                                                     \
        FLEXCOMM0_NS, FLEXCOMM1_NS, FLEXCOMM2_NS, FLEXCOMM3_NS, FLEXCOMM4_NS, FLEXCOMM5_NS, FLEXCOMM6_NS, \
            FLEXCOMM7_NS, FLEXCOMM8_NS                                                                    \
    }
#else
/** Peripheral FLEXCOMM0 base address */
#define FLEXCOMM0_BASE (0x40086000u)
/** Peripheral FLEXCOMM0 base pointer */
#define FLEXCOMM0 ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
/** Peripheral FLEXCOMM1 base address */
#define FLEXCOMM1_BASE (0x40087000u)
/** Peripheral FLEXCOMM1 base pointer */
#define FLEXCOMM1 ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
/** Peripheral FLEXCOMM2 base address */
#define FLEXCOMM2_BASE (0x40088000u)
/** Peripheral FLEXCOMM2 base pointer */
#define FLEXCOMM2 ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
/** Peripheral FLEXCOMM3 base address */
#define FLEXCOMM3_BASE (0x40089000u)
/** Peripheral FLEXCOMM3 base pointer */
#define FLEXCOMM3 ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
/** Peripheral FLEXCOMM4 base address */
#define FLEXCOMM4_BASE (0x4008A000u)
/** Peripheral FLEXCOMM4 base pointer */
#define FLEXCOMM4 ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
/** Peripheral FLEXCOMM5 base address */
#define FLEXCOMM5_BASE (0x40096000u)
/** Peripheral FLEXCOMM5 base pointer */
#define FLEXCOMM5 ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
/** Peripheral FLEXCOMM6 base address */
#define FLEXCOMM6_BASE (0x40097000u)
/** Peripheral FLEXCOMM6 base pointer */
#define FLEXCOMM6 ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
/** Peripheral FLEXCOMM7 base address */
#define FLEXCOMM7_BASE (0x40098000u)
/** Peripheral FLEXCOMM7 base pointer */
#define FLEXCOMM7 ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
/** Peripheral FLEXCOMM8 base address */
#define FLEXCOMM8_BASE (0x4009F000u)
/** Peripheral FLEXCOMM8 base pointer */
#define FLEXCOMM8 ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
/** Array initializer of FLEXCOMM peripheral base addresses */
#define FLEXCOMM_BASE_ADDRS                                                                             \
    {                                                                                                   \
        FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, \
            FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE                                              \
    }
/** Array initializer of FLEXCOMM peripheral base pointers */
#define FLEXCOMM_BASE_PTRS                                                                                \
    {                                                                                                     \
        FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8 \
    }
#endif
/** Interrupt vectors for the FLEXCOMM peripheral type */
#define FLEXCOMM_IRQS                                                                                   \
    {                                                                                                   \
        FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, \
            FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, FLEXCOMM8_IRQn                                              \
    }

/*!
 * @}
 */ /* end of group FLEXCOMM_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- GINT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GINT_Peripheral_Access_Layer GINT Peripheral Access Layer
 * @{
 */

/** GINT - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL; /**< GPIO grouped interrupt control register, offset: 0x0 */
    uint8_t RESERVED_0[28];
    __IO uint32_t
        PORT_POL[2]; /**< GPIO grouped interrupt port 0 polarity register, array offset: 0x20, array step: 0x4 */
    uint8_t RESERVED_1[24];
    __IO uint32_t
        PORT_ENA[2]; /**< GPIO grouped interrupt port 0 enable register, array offset: 0x40, array step: 0x4 */
} GINT_Type;

/* ----------------------------------------------------------------------------
   -- GINT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GINT_Register_Masks GINT Register Masks
 * @{
 */

/*! @name CTRL - GPIO grouped interrupt control register */
/*! @{ */
#define GINT_CTRL_INT_MASK (0x1U)
#define GINT_CTRL_INT_SHIFT (0U)
/*! INT - Group interrupt status. This bit is cleared by writing a one to it. Writing zero has no effect.
 *  0b0..No request. No interrupt request is pending.
 *  0b1..Request active. Interrupt request is active.
 */
#define GINT_CTRL_INT(x) (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_INT_SHIFT)) & GINT_CTRL_INT_MASK)
#define GINT_CTRL_COMB_MASK (0x2U)
#define GINT_CTRL_COMB_SHIFT (1U)
/*! COMB - Combine enabled inputs for group interrupt
 *  0b0..Or. OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on
 * its programmed polarity). 0b1..And. AND functionality: An interrupt is generated when all enabled bits are active
 * (based on their programmed polarity).
 */
#define GINT_CTRL_COMB(x) (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_COMB_SHIFT)) & GINT_CTRL_COMB_MASK)
#define GINT_CTRL_TRIG_MASK (0x4U)
#define GINT_CTRL_TRIG_SHIFT (2U)
/*! TRIG - Group interrupt trigger
 *  0b0..Edge-triggered.
 *  0b1..Level-triggered.
 */
#define GINT_CTRL_TRIG(x) (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_TRIG_SHIFT)) & GINT_CTRL_TRIG_MASK)
/*! @} */

/*! @name PORT_POL - GPIO grouped interrupt port 0 polarity register */
/*! @{ */
#define GINT_PORT_POL_POL_MASK (0xFFFFFFFFU)
#define GINT_PORT_POL_POL_SHIFT (0U)
/*! POL - Configure pin polarity of port m pins for group interrupt. Bit n corresponds to pin PIOm_n
 *    of port m. 0 = the pin is active LOW. If the level on this pin is LOW, the pin contributes to
 *    the group interrupt. 1 = the pin is active HIGH. If the level on this pin is HIGH, the pin
 *    contributes to the group interrupt.
 */
#define GINT_PORT_POL_POL(x) (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL_SHIFT)) & GINT_PORT_POL_POL_MASK)
/*! @} */

/* The count of GINT_PORT_POL */
#define GINT_PORT_POL_COUNT (2U)

/*! @name PORT_ENA - GPIO grouped interrupt port 0 enable register */
/*! @{ */
#define GINT_PORT_ENA_ENA_MASK (0xFFFFFFFFU)
#define GINT_PORT_ENA_ENA_SHIFT (0U)
/*! ENA - Enable port 0 pin for group interrupt. Bit n corresponds to pin Pm_n of port m. 0 = the
 *    port 0 pin is disabled and does not contribute to the grouped interrupt. 1 = the port 0 pin is
 *    enabled and contributes to the grouped interrupt.
 */
#define GINT_PORT_ENA_ENA(x) (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA_SHIFT)) & GINT_PORT_ENA_ENA_MASK)
/*! @} */

/* The count of GINT_PORT_ENA */
#define GINT_PORT_ENA_COUNT (2U)

/*!
 * @}
 */ /* end of group GINT_Register_Masks */

/* GINT - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral GINT0 base address */
#define GINT0_BASE (0x50002000u)
/** Peripheral GINT0 base address */
#define GINT0_BASE_NS (0x40002000u)
/** Peripheral GINT0 base pointer */
#define GINT0 ((GINT_Type *)GINT0_BASE)
/** Peripheral GINT0 base pointer */
#define GINT0_NS ((GINT_Type *)GINT0_BASE_NS)
/** Peripheral GINT1 base address */
#define GINT1_BASE (0x50003000u)
/** Peripheral GINT1 base address */
#define GINT1_BASE_NS (0x40003000u)
/** Peripheral GINT1 base pointer */
#define GINT1 ((GINT_Type *)GINT1_BASE)
/** Peripheral GINT1 base pointer */
#define GINT1_NS ((GINT_Type *)GINT1_BASE_NS)
/** Array initializer of GINT peripheral base addresses */
#define GINT_BASE_ADDRS        \
    {                          \
        GINT0_BASE, GINT1_BASE \
    }
/** Array initializer of GINT peripheral base pointers */
#define GINT_BASE_PTRS \
    {                  \
        GINT0, GINT1   \
    }
/** Array initializer of GINT peripheral base addresses */
#define GINT_BASE_ADDRS_NS           \
    {                                \
        GINT0_BASE_NS, GINT1_BASE_NS \
    }
/** Array initializer of GINT peripheral base pointers */
#define GINT_BASE_PTRS_NS  \
    {                      \
        GINT0_NS, GINT1_NS \
    }
#else
/** Peripheral GINT0 base address */
#define GINT0_BASE (0x40002000u)
/** Peripheral GINT0 base pointer */
#define GINT0 ((GINT_Type *)GINT0_BASE)
/** Peripheral GINT1 base address */
#define GINT1_BASE (0x40003000u)
/** Peripheral GINT1 base pointer */
#define GINT1 ((GINT_Type *)GINT1_BASE)
/** Array initializer of GINT peripheral base addresses */
#define GINT_BASE_ADDRS        \
    {                          \
        GINT0_BASE, GINT1_BASE \
    }
/** Array initializer of GINT peripheral base pointers */
#define GINT_BASE_PTRS \
    {                  \
        GINT0, GINT1   \
    }
#endif
/** Interrupt vectors for the GINT peripheral type */
#define GINT_IRQS              \
    {                          \
        GINT0_IRQn, GINT1_IRQn \
    }

/*!
 * @}
 */ /* end of group GINT_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct
{
    __IO uint8_t B[2][32]; /**< Byte pin registers for all port GPIO pins, array offset: 0x0, array step: index*0x20,
                              index2*0x1 */
    uint8_t RESERVED_0[4032];
    __IO uint32_t W[2][32]; /**< Word pin registers for all port GPIO pins, array offset: 0x1000, array step:
                               index*0x80, index2*0x4 */
    uint8_t RESERVED_1[3840];
    __IO uint32_t DIR[2]; /**< Direction registers for all port GPIO pins, array offset: 0x2000, array step: 0x4 */
    uint8_t RESERVED_2[120];
    __IO uint32_t MASK[2]; /**< Mask register for all port GPIO pins, array offset: 0x2080, array step: 0x4 */
    uint8_t RESERVED_3[120];
    __IO uint32_t PIN[2]; /**< Port pin register for all port GPIO pins, array offset: 0x2100, array step: 0x4 */
    uint8_t RESERVED_4[120];
    __IO uint32_t MPIN[2]; /**< Masked port register for all port GPIO pins, array offset: 0x2180, array step: 0x4 */
    uint8_t RESERVED_5[120];
    __IO uint32_t
        SET[2]; /**< Write: Set register for port. Read: output bits for port, array offset: 0x2200, array step: 0x4 */
    uint8_t RESERVED_6[120];
    __O uint32_t CLR[2]; /**< Clear port for all port GPIO pins, array offset: 0x2280, array step: 0x4 */
    uint8_t RESERVED_7[120];
    __O uint32_t NOT[2]; /**< Toggle port for all port GPIO pins, array offset: 0x2300, array step: 0x4 */
    uint8_t RESERVED_8[120];
    __O uint32_t DIRSET[2]; /**< Set pin direction bits for port, array offset: 0x2380, array step: 0x4 */
    uint8_t RESERVED_9[120];
    __O uint32_t DIRCLR[2]; /**< Clear pin direction bits for port, array offset: 0x2400, array step: 0x4 */
    uint8_t RESERVED_10[120];
    __O uint32_t DIRNOT[2]; /**< Toggle pin direction bits for port, array offset: 0x2480, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name B - Byte pin registers for all port GPIO pins */
/*! @{ */
#define GPIO_B_PBYTE_MASK (0x1U)
#define GPIO_B_PBYTE_SHIFT (0U)
/*! PBYTE - Read: state of the pin PIOm_n, regardless of direction, masking, or alternate function,
 *    except that pins configured as analog I/O always read as 0. One register for each port pin.
 *    Supported pins depends on the specific device and package. Write: loads the pin's output bit.
 *    One register for each port pin. Supported pins depends on the specific device and package.
 */
#define GPIO_B_PBYTE(x) (((uint8_t)(((uint8_t)(x)) << GPIO_B_PBYTE_SHIFT)) & GPIO_B_PBYTE_MASK)
/*! @} */

/* The count of GPIO_B */
#define GPIO_B_COUNT (2U)

/* The count of GPIO_B */
#define GPIO_B_COUNT2 (32U)

/*! @name W - Word pin registers for all port GPIO pins */
/*! @{ */
#define GPIO_W_PWORD_MASK (0xFFFFFFFFU)
#define GPIO_W_PWORD_SHIFT (0U)
/*! PWORD - Read 0: pin PIOm_n is LOW. Write 0: clear output bit. Read 0xFFFF FFFF: pin PIOm_n is
 *    HIGH. Write any value 0x0000 0001 to 0xFFFF FFFF: set output bit. Only 0 or 0xFFFF FFFF can be
 *    read. Writing any value other than 0 will set the output bit. One register for each port pin.
 *    Supported pins depends on the specific device and package.
 */
#define GPIO_W_PWORD(x) (((uint32_t)(((uint32_t)(x)) << GPIO_W_PWORD_SHIFT)) & GPIO_W_PWORD_MASK)
/*! @} */

/* The count of GPIO_W */
#define GPIO_W_COUNT (2U)

/* The count of GPIO_W */
#define GPIO_W_COUNT2 (32U)

/*! @name DIR - Direction registers for all port GPIO pins */
/*! @{ */
#define GPIO_DIR_DIRP_MASK (0xFFFFFFFFU)
#define GPIO_DIR_DIRP_SHIFT (0U)
/*! DIRP - Selects pin direction for pin PIOm_n (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported
 *    pins depends on the specific device and package. 0 = input. 1 = output.
 */
#define GPIO_DIR_DIRP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP_SHIFT)) & GPIO_DIR_DIRP_MASK)
/*! @} */

/* The count of GPIO_DIR */
#define GPIO_DIR_COUNT (2U)

/*! @name MASK - Mask register for all port GPIO pins */
/*! @{ */
#define GPIO_MASK_MASKP_MASK (0xFFFFFFFFU)
#define GPIO_MASK_MASKP_SHIFT (0U)
/*! MASKP - Controls which bits corresponding to PIOm_n are active in the MPORT register (bit 0 =
 *    PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the specific device and package.0 =
 *    Read MPORT: pin state; write MPORT: load output bit. 1 = Read MPORT: 0; write MPORT: output bit
 *    not affected.
 */
#define GPIO_MASK_MASKP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP_SHIFT)) & GPIO_MASK_MASKP_MASK)
/*! @} */

/* The count of GPIO_MASK */
#define GPIO_MASK_COUNT (2U)

/*! @name PIN - Port pin register for all port GPIO pins */
/*! @{ */
#define GPIO_PIN_PORT_MASK (0xFFFFFFFFU)
#define GPIO_PIN_PORT_SHIFT (0U)
/*! PORT - Reads pin states or loads output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported
 *    pins depends on the specific device and package. 0 = Read: pin is low; write: clear output bit.
 *    1 = Read: pin is high; write: set output bit.
 */
#define GPIO_PIN_PORT(x) (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT_SHIFT)) & GPIO_PIN_PORT_MASK)
/*! @} */

/* The count of GPIO_PIN */
#define GPIO_PIN_COUNT (2U)

/*! @name MPIN - Masked port register for all port GPIO pins */
/*! @{ */
#define GPIO_MPIN_MPORTP_MASK (0xFFFFFFFFU)
#define GPIO_MPIN_MPORTP_SHIFT (0U)
/*! MPORTP - Masked port register (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = Read: pin is LOW and/or the corresponding bit in the MASK
 *    register is 1; write: clear output bit if the corresponding bit in the MASK register is 0. 1
 *    = Read: pin is HIGH and the corresponding bit in the MASK register is 0; write: set output bit
 *    if the corresponding bit in the MASK register is 0.
 */
#define GPIO_MPIN_MPORTP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP_SHIFT)) & GPIO_MPIN_MPORTP_MASK)
/*! @} */

/* The count of GPIO_MPIN */
#define GPIO_MPIN_COUNT (2U)

/*! @name SET - Write: Set register for port. Read: output bits for port */
/*! @{ */
#define GPIO_SET_SETP_MASK (0xFFFFFFFFU)
#define GPIO_SET_SETP_SHIFT (0U)
/*! SETP - Read or set output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = Read: output bit: write: no operation. 1 = Read: output
 *    bit; write: set output bit.
 */
#define GPIO_SET_SETP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_SET_SETP_SHIFT)) & GPIO_SET_SETP_MASK)
/*! @} */

/* The count of GPIO_SET */
#define GPIO_SET_COUNT (2U)

/*! @name CLR - Clear port for all port GPIO pins */
/*! @{ */
#define GPIO_CLR_CLRP_MASK (0xFFFFFFFFU)
#define GPIO_CLR_CLRP_SHIFT (0U)
/*! CLRP - Clear output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the
 *    specific device and package. 0 = No operation. 1 = Clear output bit.
 */
#define GPIO_CLR_CLRP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP_SHIFT)) & GPIO_CLR_CLRP_MASK)
/*! @} */

/* The count of GPIO_CLR */
#define GPIO_CLR_COUNT (2U)

/*! @name NOT - Toggle port for all port GPIO pins */
/*! @{ */
#define GPIO_NOT_NOTP_MASK (0xFFFFFFFFU)
#define GPIO_NOT_NOTP_SHIFT (0U)
/*! NOTP - Toggle output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the
 *    specific device and package. 0 = no operation. 1 = Toggle output bit.
 */
#define GPIO_NOT_NOTP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP_SHIFT)) & GPIO_NOT_NOTP_MASK)
/*! @} */

/* The count of GPIO_NOT */
#define GPIO_NOT_COUNT (2U)

/*! @name DIRSET - Set pin direction bits for port */
/*! @{ */
#define GPIO_DIRSET_DIRSETP_MASK (0xFFFFFFFFU)
#define GPIO_DIRSET_DIRSETP_SHIFT (0U)
/*! DIRSETP - Set direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = No operation. 1 = Set direction bit.
 */
#define GPIO_DIRSET_DIRSETP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP_SHIFT)) & GPIO_DIRSET_DIRSETP_MASK)
/*! @} */

/* The count of GPIO_DIRSET */
#define GPIO_DIRSET_COUNT (2U)

/*! @name DIRCLR - Clear pin direction bits for port */
/*! @{ */
#define GPIO_DIRCLR_DIRCLRP_MASK (0xFFFFFFFFU)
#define GPIO_DIRCLR_DIRCLRP_SHIFT (0U)
/*! DIRCLRP - Clear direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = No operation. 1 = Clear direction bit.
 */
#define GPIO_DIRCLR_DIRCLRP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP_SHIFT)) & GPIO_DIRCLR_DIRCLRP_MASK)
/*! @} */

/* The count of GPIO_DIRCLR */
#define GPIO_DIRCLR_COUNT (2U)

/*! @name DIRNOT - Toggle pin direction bits for port */
/*! @{ */
#define GPIO_DIRNOT_DIRNOTP_MASK (0xFFFFFFFFU)
#define GPIO_DIRNOT_DIRNOTP_SHIFT (0U)
/*! DIRNOTP - Toggle direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends
 *    on the specific device and package. 0 = no operation. 1 = Toggle direction bit.
 */
#define GPIO_DIRNOT_DIRNOTP(x) (((uint32_t)(((uint32_t)(x)) << GPIO_DIRNOT_DIRNOTP_SHIFT)) & GPIO_DIRNOT_DIRNOTP_MASK)
/*! @} */

/* The count of GPIO_DIRNOT */
#define GPIO_DIRNOT_COUNT (2U)

/*!
 * @}
 */ /* end of group GPIO_Register_Masks */

/* GPIO - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral GPIO base address */
#define GPIO_BASE (0x5008C000u)
/** Peripheral GPIO base address */
#define GPIO_BASE_NS (0x4008C000u)
/** Peripheral GPIO base pointer */
#define GPIO ((GPIO_Type *)GPIO_BASE)
/** Peripheral GPIO base pointer */
#define GPIO_NS ((GPIO_Type *)GPIO_BASE_NS)
/** Peripheral SECGPIO base address */
#define SECGPIO_BASE (0x500A8000u)
/** Peripheral SECGPIO base address */
#define SECGPIO_BASE_NS (0x400A8000u)
/** Peripheral SECGPIO base pointer */
#define SECGPIO ((GPIO_Type *)SECGPIO_BASE)
/** Peripheral SECGPIO base pointer */
#define SECGPIO_NS ((GPIO_Type *)SECGPIO_BASE_NS)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS         \
    {                           \
        GPIO_BASE, SECGPIO_BASE \
    }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS \
    {                  \
        GPIO, SECGPIO  \
    }
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS_NS            \
    {                                 \
        GPIO_BASE_NS, SECGPIO_BASE_NS \
    }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS_NS   \
    {                       \
        GPIO_NS, SECGPIO_NS \
    }
#else
/** Peripheral GPIO base address */
#define GPIO_BASE (0x4008C000u)
/** Peripheral GPIO base pointer */
#define GPIO ((GPIO_Type *)GPIO_BASE)
/** Peripheral SECGPIO base address */
#define SECGPIO_BASE (0x400A8000u)
/** Peripheral SECGPIO base pointer */
#define SECGPIO ((GPIO_Type *)SECGPIO_BASE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS         \
    {                           \
        GPIO_BASE, SECGPIO_BASE \
    }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS \
    {                  \
        GPIO, SECGPIO  \
    }
#endif

/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- HASHCRYPT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HASHCRYPT_Peripheral_Access_Layer HASHCRYPT Peripheral Access Layer
 * @{
 */

/** HASHCRYPT - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL;     /**< Control register to enable and operate Hash and Crypto, offset: 0x0 */
    __IO uint32_t STATUS;   /**< Indicates status of Hash peripheral., offset: 0x4 */
    __IO uint32_t INTENSET; /**< Write 1 to enable interrupts; reads back with which are set., offset: 0x8 */
    __IO uint32_t INTENCLR; /**< Write 1 to clear interrupts., offset: 0xC */
    __IO uint32_t MEMCTRL;  /**< Setup Master to access memory (if available), offset: 0x10 */
    __IO uint32_t MEMADDR;  /**< Address to start memory access from (if available)., offset: 0x14 */
    uint8_t RESERVED_0[8];
    __O uint32_t INDATA;     /**< Input of 16 words at a time to load up buffer., offset: 0x20 */
    __O uint32_t ALIAS[7];   /**< , array offset: 0x24, array step: 0x4 */
    __I uint32_t DIGEST0[8]; /**< , array offset: 0x40, array step: 0x4 */
    uint8_t RESERVED_1[32];
    __IO uint32_t CRYPTCFG; /**< Crypto settings for AES and Salsa and ChaCha, offset: 0x80 */
    __I uint32_t CONFIG;    /**< Returns the configuration of this block in this chip - indicates what services are
                               available., offset: 0x84 */
    uint8_t RESERVED_2[4];
    __IO uint32_t LOCK; /**< Lock register allows locking to the current security level or unlocking by the lock holding
                           level., offset: 0x8C */
    __O uint32_t MASK[4]; /**< , array offset: 0x90, array step: 0x4 */
} HASHCRYPT_Type;

/* ----------------------------------------------------------------------------
   -- HASHCRYPT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HASHCRYPT_Register_Masks HASHCRYPT Register Masks
 * @{
 */

/*! @name CTRL - Control register to enable and operate Hash and Crypto */
/*! @{ */
#define HASHCRYPT_CTRL_MODE_MASK (0x7U)
#define HASHCRYPT_CTRL_MODE_SHIFT (0U)
/*! Mode - The operational mode to use, or 0 if none. Note that the CONFIG register will indicate if
 *    specific modes beyond SHA1 and SHA2-256 are available.
 *  0b000..Disabled
 *  0b001..SHA1 is enabled
 *  0b010..SHA2-256 is enabled
 *  0b100..AES if available (see also CRYPTCFG register for more controls)
 *  0b101..ICB-AES if available (see also CRYPTCFG register for more controls)
 */
#define HASHCRYPT_CTRL_MODE(x) (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_MODE_SHIFT)) & HASHCRYPT_CTRL_MODE_MASK)
#define HASHCRYPT_CTRL_NEW_HASH_MASK (0x10U)
#define HASHCRYPT_CTRL_NEW_HASH_SHIFT (4U)
/*! New_Hash - Written with 1 when starting a new Hash/Crypto. It self clears. Note that the WAITING
 *    Status bit will clear for a cycle during the initialization from New=1.
 *  0b1..Starts a new Hash/Crypto and initializes the Digest/Result.
 */
#define HASHCRYPT_CTRL_NEW_HASH(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_NEW_HASH_SHIFT)) & HASHCRYPT_CTRL_NEW_HASH_MASK)
#define HASHCRYPT_CTRL_DMA_I_MASK (0x100U)
#define HASHCRYPT_CTRL_DMA_I_SHIFT (8U)
/*! DMA_I - Written with 1 to use DMA to fill INDATA. If Hash, will request from DMA for 16 words
 *    and then will process the Hash. If Cryptographic, it will load as many words as needed,
 *    including key if not already loaded. It will then request again. Normal model is that the DMA
 *    interrupts the processor when its length expires. Note that if the processor will write the key and
 *    optionally IV, it should not enable this until it has done so. Otherwise, the DMA will be
 *    expected to load those for the 1st block (when needed).
 *  0b0..DMA is not used. Processor writes the necessary words when WAITING is set (interrupts), unless AHB Master is
 * used. 0b1..DMA will push in the data.
 */
#define HASHCRYPT_CTRL_DMA_I(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_DMA_I_SHIFT)) & HASHCRYPT_CTRL_DMA_I_MASK)
#define HASHCRYPT_CTRL_DMA_O_MASK (0x200U)
#define HASHCRYPT_CTRL_DMA_O_SHIFT (9U)
/*! DMA_O - Written to 1 to use DMA to drain the digest/output. If both DMA_I and DMA_O are set, the
 *    DMA has to know to switch direction and the locations. This can be used for crypto uses.
 *  0b0..DMA is not used. Processor reads the digest/output in response to DIGEST interrupt.
 */
#define HASHCRYPT_CTRL_DMA_O(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_DMA_O_SHIFT)) & HASHCRYPT_CTRL_DMA_O_MASK)
#define HASHCRYPT_CTRL_HASHSWPB_MASK (0x1000U)
#define HASHCRYPT_CTRL_HASHSWPB_SHIFT (12U)
/*! HASHSWPB - If 1, will swap bytes in the word for SHA hashing. The default is byte order (so LSB
 *    is 1st byte) but this allows swapping to MSB is 1st such as is shown in SHS spec. For
 *    cryptographic swapping, see the CRYPTCFG register.
 */
#define HASHCRYPT_CTRL_HASHSWPB(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_HASHSWPB_SHIFT)) & HASHCRYPT_CTRL_HASHSWPB_MASK)
/*! @} */

/*! @name STATUS - Indicates status of Hash peripheral. */
/*! @{ */
#define HASHCRYPT_STATUS_WAITING_MASK (0x1U)
#define HASHCRYPT_STATUS_WAITING_SHIFT (0U)
/*! WAITING - If 1, the block is waiting for more data to process.
 *  0b0..Not waiting for data - may be disabled or may be busy. Note that for cryptographic uses, this is not set
 *       if IsLast is set nor will it set until at least 1 word is read of the output.
 *  0b1..Waiting for data to be written in (16 words)
 */
#define HASHCRYPT_STATUS_WAITING(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_WAITING_SHIFT)) & HASHCRYPT_STATUS_WAITING_MASK)
#define HASHCRYPT_STATUS_DIGEST_MASK (0x2U)
#define HASHCRYPT_STATUS_DIGEST_SHIFT (1U)
/*! DIGEST - For Hash, if 1 then a DIGEST is ready and waiting and there is no active next block
 *    already started. For Cryptographic uses, this will be set for each block processed, indicating
 *    OUTDATA (and OUTDATA2 if larger output) contains the next value to read out. This is cleared
 *    when any data is written, when New is written, for Cryptographic uses when the last word is read
 *    out, or when the block is disabled.
 *  0b0..No Digest is ready
 *  0b1..Digest is ready. Application may read it or may write more data
 */
#define HASHCRYPT_STATUS_DIGEST(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_DIGEST_SHIFT)) & HASHCRYPT_STATUS_DIGEST_MASK)
#define HASHCRYPT_STATUS_ERROR_MASK (0x4U)
#define HASHCRYPT_STATUS_ERROR_SHIFT (2U)
/*! ERROR - If 1, an error occurred. For normal uses, this is due to an attempted overrun: INDATA
 *    was written when it was not appropriate. For Master cases, this is an AHB bus error; the COUNT
 *    field will indicate which block it was on.
 *  0b0..No error.
 *  0b1..An error occurred since last cleared (written 1 to clear).
 */
#define HASHCRYPT_STATUS_ERROR(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_ERROR_SHIFT)) & HASHCRYPT_STATUS_ERROR_MASK)
#define HASHCRYPT_STATUS_NEEDKEY_MASK (0x10U)
#define HASHCRYPT_STATUS_NEEDKEY_SHIFT (4U)
/*! NEEDKEY - Indicates the block wants the key to be written in (set along with WAITING)
 *  0b0..No Key is needed and writes will not be treated as Key
 *  0b1..Key is needed and INDATA/ALIAS will be accepted as Key. Will also set WAITING.
 */
#define HASHCRYPT_STATUS_NEEDKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_NEEDKEY_SHIFT)) & HASHCRYPT_STATUS_NEEDKEY_MASK)
#define HASHCRYPT_STATUS_NEEDIV_MASK (0x20U)
#define HASHCRYPT_STATUS_NEEDIV_SHIFT (5U)
/*! NEEDIV - Indicates the block wants an IV/NONE to be written in (set along with WAITING)
 *  0b0..No IV/Nonce is needed, either because written already or because not needed.
 *  0b1..IV/Nonce is needed and INDATA/ALIAS will be accepted as IV/Nonce. Will also set WAITING.
 */
#define HASHCRYPT_STATUS_NEEDIV(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_NEEDIV_SHIFT)) & HASHCRYPT_STATUS_NEEDIV_MASK)
#define HASHCRYPT_STATUS_ICBIDX_MASK (0x3F0000U)
#define HASHCRYPT_STATUS_ICBIDX_SHIFT (16U)
/*! ICBIDX - If ICB-AES is selected, then reads as the ICB index count based on ICBSTRM (from
 *    CRYPTCFG). That is, if 3 bits of ICBSTRM, then this will count from 0 to 7 and then back to 0. On 0,
 *    it has to compute the full ICB, quicker when not 0.
 */
#define HASHCRYPT_STATUS_ICBIDX(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_ICBIDX_SHIFT)) & HASHCRYPT_STATUS_ICBIDX_MASK)
/*! @} */

/*! @name INTENSET - Write 1 to enable interrupts; reads back with which are set. */
/*! @{ */
#define HASHCRYPT_INTENSET_WAITING_MASK (0x1U)
#define HASHCRYPT_INTENSET_WAITING_SHIFT (0U)
/*! WAITING - Indicates if should interrupt when waiting for data input.
 *  0b0..Will not interrupt when waiting.
 *  0b1..Will interrupt when waiting
 */
#define HASHCRYPT_INTENSET_WAITING(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENSET_WAITING_SHIFT)) & HASHCRYPT_INTENSET_WAITING_MASK)
#define HASHCRYPT_INTENSET_DIGEST_MASK (0x2U)
#define HASHCRYPT_INTENSET_DIGEST_SHIFT (1U)
/*! DIGEST - Indicates if should interrupt when Digest (or Outdata) is ready (completed a hash/crypto or completed a
 * full sequence). 0b0..Will not interrupt when Digest is ready 0b1..Will interrupt when Digest is ready. Interrupt
 * cleared by writing more data, starting a new Hash, or disabling (done).
 */
#define HASHCRYPT_INTENSET_DIGEST(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENSET_DIGEST_SHIFT)) & HASHCRYPT_INTENSET_DIGEST_MASK)
#define HASHCRYPT_INTENSET_ERROR_MASK (0x4U)
#define HASHCRYPT_INTENSET_ERROR_SHIFT (2U)
/*! ERROR - Indicates if should interrupt on an ERROR (as defined in Status)
 *  0b0..Will not interrupt on Error.
 *  0b1..Will interrupt on Error (until cleared).
 */
#define HASHCRYPT_INTENSET_ERROR(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENSET_ERROR_SHIFT)) & HASHCRYPT_INTENSET_ERROR_MASK)
/*! @} */

/*! @name INTENCLR - Write 1 to clear interrupts. */
/*! @{ */
#define HASHCRYPT_INTENCLR_WAITING_MASK (0x1U)
#define HASHCRYPT_INTENCLR_WAITING_SHIFT (0U)
/*! WAITING - Write 1 to clear mask.
 */
#define HASHCRYPT_INTENCLR_WAITING(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENCLR_WAITING_SHIFT)) & HASHCRYPT_INTENCLR_WAITING_MASK)
#define HASHCRYPT_INTENCLR_DIGEST_MASK (0x2U)
#define HASHCRYPT_INTENCLR_DIGEST_SHIFT (1U)
/*! DIGEST - Write 1 to clear mask.
 */
#define HASHCRYPT_INTENCLR_DIGEST(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENCLR_DIGEST_SHIFT)) & HASHCRYPT_INTENCLR_DIGEST_MASK)
#define HASHCRYPT_INTENCLR_ERROR_MASK (0x4U)
#define HASHCRYPT_INTENCLR_ERROR_SHIFT (2U)
/*! ERROR - Write 1 to clear mask.
 */
#define HASHCRYPT_INTENCLR_ERROR(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENCLR_ERROR_SHIFT)) & HASHCRYPT_INTENCLR_ERROR_MASK)
/*! @} */

/*! @name MEMCTRL - Setup Master to access memory (if available) */
/*! @{ */
#define HASHCRYPT_MEMCTRL_MASTER_MASK (0x1U)
#define HASHCRYPT_MEMCTRL_MASTER_SHIFT (0U)
/*! MASTER - Enables mastering.
 *  0b0..Mastering is not used and the normal DMA or Interrupt based model is used with INDATA.
 *  0b1..Mastering is enabled and DMA and INDATA should not be used.
 */
#define HASHCRYPT_MEMCTRL_MASTER(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MEMCTRL_MASTER_SHIFT)) & HASHCRYPT_MEMCTRL_MASTER_MASK)
#define HASHCRYPT_MEMCTRL_COUNT_MASK (0x7FF0000U)
#define HASHCRYPT_MEMCTRL_COUNT_SHIFT (16U)
/*! COUNT - Number of 512-bit (128-bit if AES, except 1st block which may include key and IV) blocks
 *    to copy starting at MEMADDR. This register will decrement after each block is copied, ending
 *    in 0. For Hash, the DIGEST interrupt will occur when it reaches 0. Fro AES, the DIGEST/OUTDATA
 *    interrupt will occur on ever block. If a bus error occurs, it will stop with this field set
 *    to the block that failed. 0:Done - nothing to process. 1 to 2K: Number of 512-bit (or 128bit)
 *    blocks to hash.
 */
#define HASHCRYPT_MEMCTRL_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MEMCTRL_COUNT_SHIFT)) & HASHCRYPT_MEMCTRL_COUNT_MASK)
/*! @} */

/*! @name MEMADDR - Address to start memory access from (if available). */
/*! @{ */
#define HASHCRYPT_MEMADDR_BASE_MASK (0xFFFFFFFFU)
#define HASHCRYPT_MEMADDR_BASE_SHIFT (0U)
/*! BASE - Address base to start copying from, word aligned (so bits 1:0 must be 0). This field will
 *    advance as it processes the words. If it fails with a bus error, the register will contain
 *    the failing word. N:Address in Flash or RAM space; RAM only as mapped in this part. May also be
 *    able to address SPIFI.
 */
#define HASHCRYPT_MEMADDR_BASE(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MEMADDR_BASE_SHIFT)) & HASHCRYPT_MEMADDR_BASE_MASK)
/*! @} */

/*! @name INDATA - Input of 16 words at a time to load up buffer. */
/*! @{ */
#define HASHCRYPT_INDATA_DATA_MASK (0xFFFFFFFFU)
#define HASHCRYPT_INDATA_DATA_SHIFT (0U)
/*! DATA - Write next word in little-endian form. The hash requires big endian word data, but this
 *    block swaps the bytes automatically. That is, SHA assumes the data coming in is treated as
 *    bytes (e.g. "abcd") and since the ARM core will treat "abcd" as a word as 0x64636261, the block
 *    will swap the word to restore into big endian.
 */
#define HASHCRYPT_INDATA_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INDATA_DATA_SHIFT)) & HASHCRYPT_INDATA_DATA_MASK)
/*! @} */

/*! @name ALIAS -  */
/*! @{ */
#define HASHCRYPT_ALIAS_DATA_MASK (0xFFFFFFFFU)
#define HASHCRYPT_ALIAS_DATA_SHIFT (0U)
/*! DATA - Write next word in little-endian form. The hash requires big endian word data, but this
 *    block swaps the bytes automatically. That is, SHA assumes the data coming in is treated as
 *    bytes (e.g. "abcd") and since the ARM core will treat "abcd" as a word as 0x64636261, the block
 *    will swap the word to restore into big endian.
 */
#define HASHCRYPT_ALIAS_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_ALIAS_DATA_SHIFT)) & HASHCRYPT_ALIAS_DATA_MASK)
/*! @} */

/* The count of HASHCRYPT_ALIAS */
#define HASHCRYPT_ALIAS_COUNT (7U)

/*! @name DIGEST0 -  */
/*! @{ */
#define HASHCRYPT_DIGEST0_DIGEST_MASK (0xFFFFFFFFU)
#define HASHCRYPT_DIGEST0_DIGEST_SHIFT (0U)
/*! DIGEST - One word of the Digest or output. Note that only 1st 4 are populated for AES and 1st 5 are populated for
 * SHA1.
 */
#define HASHCRYPT_DIGEST0_DIGEST(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_DIGEST0_DIGEST_SHIFT)) & HASHCRYPT_DIGEST0_DIGEST_MASK)
/*! @} */

/* The count of HASHCRYPT_DIGEST0 */
#define HASHCRYPT_DIGEST0_COUNT (8U)

/*! @name CRYPTCFG - Crypto settings for AES and Salsa and ChaCha */
/*! @{ */
#define HASHCRYPT_CRYPTCFG_MSW1ST_OUT_MASK (0x1U)
#define HASHCRYPT_CRYPTCFG_MSW1ST_OUT_SHIFT (0U)
/*! MSW1ST_OUT - If 1, OUTDATA0 will be read Most significant word 1st for AES. Else it will be read
 *    in normal little endian - Least significant word 1st. Note: only if allowed by configuration.
 */
#define HASHCRYPT_CRYPTCFG_MSW1ST_OUT(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_MSW1ST_OUT_SHIFT)) & HASHCRYPT_CRYPTCFG_MSW1ST_OUT_MASK)
#define HASHCRYPT_CRYPTCFG_SWAPKEY_MASK (0x2U)
#define HASHCRYPT_CRYPTCFG_SWAPKEY_SHIFT (1U)
/*! SWAPKEY - If 1, will Swap the key input (bytes in each word).
 */
#define HASHCRYPT_CRYPTCFG_SWAPKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_SWAPKEY_SHIFT)) & HASHCRYPT_CRYPTCFG_SWAPKEY_MASK)
#define HASHCRYPT_CRYPTCFG_SWAPDAT_MASK (0x4U)
#define HASHCRYPT_CRYPTCFG_SWAPDAT_SHIFT (2U)
/*! SWAPDAT - If 1, will SWAP the data and IV inputs (bytes in each word).
 */
#define HASHCRYPT_CRYPTCFG_SWAPDAT(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_SWAPDAT_SHIFT)) & HASHCRYPT_CRYPTCFG_SWAPDAT_MASK)
#define HASHCRYPT_CRYPTCFG_MSW1ST_MASK (0x8U)
#define HASHCRYPT_CRYPTCFG_MSW1ST_SHIFT (3U)
/*! MSW1ST - If 1, load of key, IV, and data is MSW 1st for AES. Else, the words are little endian.
 *    Note: only if allowed by configuration.
 */
#define HASHCRYPT_CRYPTCFG_MSW1ST(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_MSW1ST_SHIFT)) & HASHCRYPT_CRYPTCFG_MSW1ST_MASK)
#define HASHCRYPT_CRYPTCFG_AESMODE_MASK (0x30U)
#define HASHCRYPT_CRYPTCFG_AESMODE_SHIFT (4U)
/*! AESMODE - AES Cipher mode to use if plain AES
 *  0b00..ECB - used as is
 *  0b01..CBC mode (see details on IV/nonce)
 *  0b10..CTR mode (see details on IV/nonce). See also AESCTRPOS.
 *  0b11..reserved
 */
#define HASHCRYPT_CRYPTCFG_AESMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESMODE_SHIFT)) & HASHCRYPT_CRYPTCFG_AESMODE_MASK)
#define HASHCRYPT_CRYPTCFG_AESDECRYPT_MASK (0x40U)
#define HASHCRYPT_CRYPTCFG_AESDECRYPT_SHIFT (6U)
/*! AESDECRYPT - AES ECB direction. Only encryption used if CTR mode or manual modes such as CFB
 *  0b0..Encrypt
 *  0b1..Decrypt
 */
#define HASHCRYPT_CRYPTCFG_AESDECRYPT(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESDECRYPT_SHIFT)) & HASHCRYPT_CRYPTCFG_AESDECRYPT_MASK)
#define HASHCRYPT_CRYPTCFG_AESSECRET_MASK (0x80U)
#define HASHCRYPT_CRYPTCFG_AESSECRET_SHIFT (7U)
/*! AESSECRET - Selects the Hidden Secret key vs. User key, if provided. If security levels are
 *    used, only the highest level is permitted to select this.
 *  0b0..User key provided in normal way
 *  0b1..Secret key provided in hidden way by HW
 */
#define HASHCRYPT_CRYPTCFG_AESSECRET(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESSECRET_SHIFT)) & HASHCRYPT_CRYPTCFG_AESSECRET_MASK)
#define HASHCRYPT_CRYPTCFG_AESKEYSZ_MASK (0x300U)
#define HASHCRYPT_CRYPTCFG_AESKEYSZ_SHIFT (8U)
/*! AESKEYSZ - Sets the AES key size
 *  0b00..128 bit key
 *  0b01..192 bit key
 *  0b10..256 bit key
 *  0b11..reserved
 */
#define HASHCRYPT_CRYPTCFG_AESKEYSZ(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESKEYSZ_SHIFT)) & HASHCRYPT_CRYPTCFG_AESKEYSZ_MASK)
#define HASHCRYPT_CRYPTCFG_AESCTRPOS_MASK (0x1C00U)
#define HASHCRYPT_CRYPTCFG_AESCTRPOS_SHIFT (10U)
/*! AESCTRPOS - Halfword position of 16b counter in IV if AESMODE is CTR (position is fixed for
 *    Salsa and ChaCha). Only supports 16b counter, so application must control any additional bytes if
 *    using more. The 16-bit counter is read from the IV and incremented by 1 each time. Any other
 *    use CTR should use ECB directly and do its own XOR and so on.
 */
#define HASHCRYPT_CRYPTCFG_AESCTRPOS(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESCTRPOS_SHIFT)) & HASHCRYPT_CRYPTCFG_AESCTRPOS_MASK)
#define HASHCRYPT_CRYPTCFG_STREAMLAST_MASK (0x10000U)
#define HASHCRYPT_CRYPTCFG_STREAMLAST_SHIFT (16U)
/*! STREAMLAST - Is 1 if last stream block. If not 1, then the engine will compute the next "hash".
 */
#define HASHCRYPT_CRYPTCFG_STREAMLAST(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_STREAMLAST_SHIFT)) & HASHCRYPT_CRYPTCFG_STREAMLAST_MASK)
#define HASHCRYPT_CRYPTCFG_ICBSZ_MASK (0x300000U)
#define HASHCRYPT_CRYPTCFG_ICBSZ_SHIFT (20U)
/*! ICBSZ - This sets the ICB size between 32 and 128 bits, using the following rules. Note that the
 *    counter is assumed to occupy the low order bits of the IV.
 *  0b00..32 bits of the IV/ctr are used (from 127:96)
 *  0b01..64 bits of the IV/ctr are used (from 127:64)
 *  0b10..96 bits of the IV/ctr are used (from 127:32)
 *  0b11..All 128 bits of the IV/ctr are used
 */
#define HASHCRYPT_CRYPTCFG_ICBSZ(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_ICBSZ_SHIFT)) & HASHCRYPT_CRYPTCFG_ICBSZ_MASK)
#define HASHCRYPT_CRYPTCFG_ICBSTRM_MASK (0xC00000U)
#define HASHCRYPT_CRYPTCFG_ICBSTRM_SHIFT (22U)
/*! ICBSTRM - The size of the ICB-AES stream that can be pushed before needing to compute a new
 *    IV/ctr (counter start). This optimizes the performance of the stream of blocks after the 1st.
 *  0b00..8 blocks
 *  0b01..16 blocks
 *  0b10..32 blocks
 *  0b11..64 blocks
 */
#define HASHCRYPT_CRYPTCFG_ICBSTRM(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_ICBSTRM_SHIFT)) & HASHCRYPT_CRYPTCFG_ICBSTRM_MASK)
/*! @} */

/*! @name CONFIG - Returns the configuration of this block in this chip - indicates what services are available. */
/*! @{ */
#define HASHCRYPT_CONFIG_DUAL_MASK (0x1U)
#define HASHCRYPT_CONFIG_DUAL_SHIFT (0U)
/*! DUAL - 1 if 2 x 512 bit buffers, 0 if only 1 x 512 bit
 */
#define HASHCRYPT_CONFIG_DUAL(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_DUAL_SHIFT)) & HASHCRYPT_CONFIG_DUAL_MASK)
#define HASHCRYPT_CONFIG_DMA_MASK (0x2U)
#define HASHCRYPT_CONFIG_DMA_SHIFT (1U)
/*! DMA - 1 if DMA is connected
 */
#define HASHCRYPT_CONFIG_DMA(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_DMA_SHIFT)) & HASHCRYPT_CONFIG_DMA_MASK)
#define HASHCRYPT_CONFIG_AHB_MASK (0x8U)
#define HASHCRYPT_CONFIG_AHB_SHIFT (3U)
/*! AHB - 1 if AHB Master is enabled
 */
#define HASHCRYPT_CONFIG_AHB(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_AHB_SHIFT)) & HASHCRYPT_CONFIG_AHB_MASK)
#define HASHCRYPT_CONFIG_AES_MASK (0x40U)
#define HASHCRYPT_CONFIG_AES_SHIFT (6U)
/*! AES - 1 if AES 128 included
 */
#define HASHCRYPT_CONFIG_AES(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_AES_SHIFT)) & HASHCRYPT_CONFIG_AES_MASK)
#define HASHCRYPT_CONFIG_AESKEY_MASK (0x80U)
#define HASHCRYPT_CONFIG_AESKEY_SHIFT (7U)
/*! AESKEY - 1 if AES 192 and 256 also included
 */
#define HASHCRYPT_CONFIG_AESKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_AESKEY_SHIFT)) & HASHCRYPT_CONFIG_AESKEY_MASK)
#define HASHCRYPT_CONFIG_SECRET_MASK (0x100U)
#define HASHCRYPT_CONFIG_SECRET_SHIFT (8U)
/*! SECRET - 1 if AES Secret key available
 */
#define HASHCRYPT_CONFIG_SECRET(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_SECRET_SHIFT)) & HASHCRYPT_CONFIG_SECRET_MASK)
#define HASHCRYPT_CONFIG_ICB_MASK (0x800U)
#define HASHCRYPT_CONFIG_ICB_SHIFT (11U)
/*! ICB - 1 if ICB over AES included
 */
#define HASHCRYPT_CONFIG_ICB(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_ICB_SHIFT)) & HASHCRYPT_CONFIG_ICB_MASK)
/*! @} */

/*! @name LOCK - Lock register allows locking to the current security level or unlocking by the lock holding level. */
/*! @{ */
#define HASHCRYPT_LOCK_SECLOCK_MASK (0x3U)
#define HASHCRYPT_LOCK_SECLOCK_SHIFT (0U)
/*! SECLOCK - Write 1 to secure-lock this block (if running in a security state). Write 0 to unlock.
 *    If locked already, may only write if at same or higher security level as lock. Reads as: 0 if
 *    unlocked, else 1, 2, 3 to indicate security level it is locked at. NOTE: this and ID are the
 *    only readable registers if locked and current state is lower than lock level.
 *  0b00..Unlocks, so block is open to all. But, AHB Master will only issue non-secure requests.
 *  0b01..Locks to the current security level. AHB Master will issue requests at this level.
 */
#define HASHCRYPT_LOCK_SECLOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_LOCK_SECLOCK_SHIFT)) & HASHCRYPT_LOCK_SECLOCK_MASK)
#define HASHCRYPT_LOCK_PATTERN_MASK (0xFFF0U)
#define HASHCRYPT_LOCK_PATTERN_SHIFT (4U)
/*! PATTERN - Must write 0xA75 to change lock state. A75:Pattern needed to change bits 1:0
 */
#define HASHCRYPT_LOCK_PATTERN(x) \
    (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_LOCK_PATTERN_SHIFT)) & HASHCRYPT_LOCK_PATTERN_MASK)
/*! @} */

/*! @name MASK -  */
/*! @{ */
#define HASHCRYPT_MASK_MASK_MASK (0xFFFFFFFFU)
#define HASHCRYPT_MASK_MASK_SHIFT (0U)
/*! MASK - A random word.
 */
#define HASHCRYPT_MASK_MASK(x) (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MASK_MASK_SHIFT)) & HASHCRYPT_MASK_MASK_MASK)
/*! @} */

/* The count of HASHCRYPT_MASK */
#define HASHCRYPT_MASK_COUNT (4U)

/*!
 * @}
 */ /* end of group HASHCRYPT_Register_Masks */

/* HASHCRYPT - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral HASHCRYPT base address */
#define HASHCRYPT_BASE (0x500A4000u)
/** Peripheral HASHCRYPT base address */
#define HASHCRYPT_BASE_NS (0x400A4000u)
/** Peripheral HASHCRYPT base pointer */
#define HASHCRYPT ((HASHCRYPT_Type *)HASHCRYPT_BASE)
/** Peripheral HASHCRYPT base pointer */
#define HASHCRYPT_NS ((HASHCRYPT_Type *)HASHCRYPT_BASE_NS)
/** Array initializer of HASHCRYPT peripheral base addresses */
#define HASHCRYPT_BASE_ADDRS \
    {                        \
        HASHCRYPT_BASE       \
    }
/** Array initializer of HASHCRYPT peripheral base pointers */
#define HASHCRYPT_BASE_PTRS \
    {                       \
        HASHCRYPT           \
    }
/** Array initializer of HASHCRYPT peripheral base addresses */
#define HASHCRYPT_BASE_ADDRS_NS \
    {                           \
        HASHCRYPT_BASE_NS       \
    }
/** Array initializer of HASHCRYPT peripheral base pointers */
#define HASHCRYPT_BASE_PTRS_NS \
    {                          \
        HASHCRYPT_NS           \
    }
#else
/** Peripheral HASHCRYPT base address */
#define HASHCRYPT_BASE (0x400A4000u)
/** Peripheral HASHCRYPT base pointer */
#define HASHCRYPT ((HASHCRYPT_Type *)HASHCRYPT_BASE)
/** Array initializer of HASHCRYPT peripheral base addresses */
#define HASHCRYPT_BASE_ADDRS \
    {                        \
        HASHCRYPT_BASE       \
    }
/** Array initializer of HASHCRYPT peripheral base pointers */
#define HASHCRYPT_BASE_PTRS \
    {                       \
        HASHCRYPT           \
    }
#endif

/*!
 * @}
 */ /* end of group HASHCRYPT_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct
{
    uint8_t RESERVED_0[2048];
    __IO uint32_t CFG;      /**< Configuration for shared functions., offset: 0x800 */
    __IO uint32_t STAT;     /**< Status register for Master, Slave, and Monitor functions., offset: 0x804 */
    __IO uint32_t INTENSET; /**< Interrupt Enable Set and read register., offset: 0x808 */
    __O uint32_t INTENCLR;  /**< Interrupt Enable Clear register., offset: 0x80C */
    __IO uint32_t TIMEOUT;  /**< Time-out value register., offset: 0x810 */
    __IO uint32_t
        CLKDIV; /**< Clock pre-divider for the entire I2C interface. This determines what time increments are used for
                   the MSTTIME register, and controls some timing of the Slave function., offset: 0x814 */
    __I uint32_t INTSTAT; /**< Interrupt Status register for Master, Slave, and Monitor functions., offset: 0x818 */
    uint8_t RESERVED_1[4];
    __IO uint32_t MSTCTL;  /**< Master control register., offset: 0x820 */
    __IO uint32_t MSTTIME; /**< Master timing configuration., offset: 0x824 */
    __IO uint32_t MSTDAT;  /**< Combined Master receiver and transmitter data register., offset: 0x828 */
    uint8_t RESERVED_2[20];
    __IO uint32_t SLVCTL;    /**< Slave control register., offset: 0x840 */
    __IO uint32_t SLVDAT;    /**< Combined Slave receiver and transmitter data register., offset: 0x844 */
    __IO uint32_t SLVADR[4]; /**< Slave address register., array offset: 0x848, array step: 0x4 */
    __IO uint32_t SLVQUAL0;  /**< Slave Qualification for address 0., offset: 0x858 */
    uint8_t RESERVED_3[36];
    __I uint32_t MONRXDAT; /**< Monitor receiver data register., offset: 0x880 */
    uint8_t RESERVED_4[1912];
    __I uint32_t ID; /**< Peripheral identification register., offset: 0xFFC */
} I2C_Type;

/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/*! @name CFG - Configuration for shared functions. */
/*! @{ */
#define I2C_CFG_MSTEN_MASK (0x1U)
#define I2C_CFG_MSTEN_SHIFT (0U)
/*! MSTEN - Master Enable. When disabled, configurations settings for the Master function are not
 *    changed, but the Master function is internally reset.
 *  0b0..Disabled. The I2C Master function is disabled.
 *  0b1..Enabled. The I2C Master function is enabled.
 */
#define I2C_CFG_MSTEN(x) (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MSTEN_SHIFT)) & I2C_CFG_MSTEN_MASK)
#define I2C_CFG_SLVEN_MASK (0x2U)
#define I2C_CFG_SLVEN_SHIFT (1U)
/*! SLVEN - Slave Enable. When disabled, configurations settings for the Slave function are not
 *    changed, but the Slave function is internally reset.
 *  0b0..Disabled. The I2C slave function is disabled.
 *  0b1..Enabled. The I2C slave function is enabled.
 */
#define I2C_CFG_SLVEN(x) (((uint32_t)(((uint32_t)(x)) << I2C_CFG_SLVEN_SHIFT)) & I2C_CFG_SLVEN_MASK)
#define I2C_CFG_MONEN_MASK (0x4U)
#define I2C_CFG_MONEN_SHIFT (2U)
/*! MONEN - Monitor Enable. When disabled, configurations settings for the Monitor function are not
 *    changed, but the Monitor function is internally reset.
 *  0b0..Disabled. The I2C Monitor function is disabled.
 *  0b1..Enabled. The I2C Monitor function is enabled.
 */
#define I2C_CFG_MONEN(x) (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONEN_SHIFT)) & I2C_CFG_MONEN_MASK)
#define I2C_CFG_TIMEOUTEN_MASK (0x8U)
#define I2C_CFG_TIMEOUTEN_SHIFT (3U)
/*! TIMEOUTEN - I2C bus Time-out Enable. When disabled, the time-out function is internally reset.
 *  0b0..Disabled. Time-out function is disabled.
 *  0b1..Enabled. Time-out function is enabled. Both types of time-out flags will be generated and will cause
 *       interrupts if they are enabled. Typically, only one time-out will be used in a system.
 */
#define I2C_CFG_TIMEOUTEN(x) (((uint32_t)(((uint32_t)(x)) << I2C_CFG_TIMEOUTEN_SHIFT)) & I2C_CFG_TIMEOUTEN_MASK)
#define I2C_CFG_MONCLKSTR_MASK (0x10U)
#define I2C_CFG_MONCLKSTR_SHIFT (4U)
/*! MONCLKSTR - Monitor function Clock Stretching.
 *  0b0..Disabled. The Monitor function will not perform clock stretching. Software or DMA may not always be able
 *       to read data provided by the Monitor function before it is overwritten. This mode may be used when
 *       non-invasive monitoring is critical.
 *  0b1..Enabled. The Monitor function will perform clock stretching in order to ensure that software or DMA can
 *       read all incoming data supplied by the Monitor function.
 */
#define I2C_CFG_MONCLKSTR(x) (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONCLKSTR_SHIFT)) & I2C_CFG_MONCLKSTR_MASK)
#define I2C_CFG_HSCAPABLE_MASK (0x20U)
#define I2C_CFG_HSCAPABLE_SHIFT (5U)
/*! HSCAPABLE - High-speed mode Capable enable. Since High Speed mode alters the way I2C pins drive
 *    and filter, as well as the timing for certain I2C signalling, enabling High-speed mode applies
 *    to all functions: Master, Slave, and Monitor.
 *  0b0..Fast-mode plus. The I 2C interface will support Standard-mode, Fast-mode, and Fast-mode Plus, to the
 *       extent that the pin electronics support these modes. Any changes that need to be made to the pin controls,
 *       such as changing the drive strength or filtering, must be made by software via the IOCON register associated
 *       with each I2C pin,
 *  0b1..High-speed. In addition to Standard-mode, Fast-mode, and Fast-mode Plus, the I 2C interface will support
 *       High-speed mode to the extent that the pin electronics support these modes. See Section 25.7.2.2 for more
 *       information.
 */
#define I2C_CFG_HSCAPABLE(x) (((uint32_t)(((uint32_t)(x)) << I2C_CFG_HSCAPABLE_SHIFT)) & I2C_CFG_HSCAPABLE_MASK)
/*! @} */

/*! @name STAT - Status register for Master, Slave, and Monitor functions. */
/*! @{ */
#define I2C_STAT_MSTPENDING_MASK (0x1U)
#define I2C_STAT_MSTPENDING_SHIFT (0U)
/*! MSTPENDING - Master Pending. Indicates that the Master is waiting to continue communication on
 *    the I2C-bus (pending) or is idle. When the master is pending, the MSTSTATE bits indicate what
 *    type of software service if any the master expects. This flag will cause an interrupt when set
 *    if, enabled via the INTENSET register. The MSTPENDING flag is not set when the DMA is handling
 *    an event (if the MSTDMA bit in the MSTCTL register is set). If the master is in the idle
 *    state, and no communication is needed, mask this interrupt.
 *  0b0..In progress. Communication is in progress and the Master function is busy and cannot currently accept a
 * command. 0b1..Pending. The Master function needs software service or is in the idle state. If the master is not in
 * the idle state, it is waiting to receive or transmit data or the NACK bit.
 */
#define I2C_STAT_MSTPENDING(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTPENDING_SHIFT)) & I2C_STAT_MSTPENDING_MASK)
#define I2C_STAT_MSTSTATE_MASK (0xEU)
#define I2C_STAT_MSTSTATE_SHIFT (1U)
/*! MSTSTATE - Master State code. The master state code reflects the master state when the
 *    MSTPENDING bit is set, that is the master is pending or in the idle state. Each value of this field
 *    indicates a specific required service for the Master function. All other values are reserved. See
 *    Table 400 for details of state values and appropriate responses.
 *  0b000..Idle. The Master function is available to be used for a new transaction.
 *  0b001..Receive ready. Received data available (Master Receiver mode). Address plus Read was previously sent and
 * Acknowledged by slave. 0b010..Transmit ready. Data can be transmitted (Master Transmitter mode). Address plus Write
 * was previously sent and Acknowledged by slave. 0b011..NACK Address. Slave NACKed address. 0b100..NACK Data. Slave
 * NACKed transmitted data.
 */
#define I2C_STAT_MSTSTATE(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTATE_SHIFT)) & I2C_STAT_MSTSTATE_MASK)
#define I2C_STAT_MSTARBLOSS_MASK (0x10U)
#define I2C_STAT_MSTARBLOSS_SHIFT (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag. This flag can be cleared by software writing a 1 to
 *    this bit. It is also cleared automatically a 1 is written to MSTCONTINUE.
 *  0b0..No Arbitration Loss has occurred.
 *  0b1..Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master
 *       function has already stopped driving the bus and gone to an idle state. Software can respond by doing nothing,
 *       or by sending a Start in order to attempt to gain control of the bus when it next becomes idle.
 */
#define I2C_STAT_MSTARBLOSS(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTARBLOSS_SHIFT)) & I2C_STAT_MSTARBLOSS_MASK)
#define I2C_STAT_MSTSTSTPERR_MASK (0x40U)
#define I2C_STAT_MSTSTSTPERR_SHIFT (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag. This flag can be cleared by software writing a 1 to
 *    this bit. It is also cleared automatically a 1 is written to MSTCONTINUE.
 *  0b0..No Start/Stop Error has occurred.
 *  0b1..The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when it is
 *       not allowed by the I2C specification. The Master interface has stopped driving the bus and gone to an
 *       idle state, no action is required. A request for a Start could be made, or software could attempt to insure
 *       that the bus has not stalled.
 */
#define I2C_STAT_MSTSTSTPERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTSTPERR_SHIFT)) & I2C_STAT_MSTSTSTPERR_MASK)
#define I2C_STAT_SLVPENDING_MASK (0x100U)
#define I2C_STAT_SLVPENDING_SHIFT (8U)
/*! SLVPENDING - Slave Pending. Indicates that the Slave function is waiting to continue
 *    communication on the I2C-bus and needs software service. This flag will cause an interrupt when set if
 *    enabled via INTENSET. The SLVPENDING flag is not set when the DMA is handling an event (if the
 *    SLVDMA bit in the SLVCTL register is set). The SLVPENDING flag is read-only and is
 *    automatically cleared when a 1 is written to the SLVCONTINUE bit in the SLVCTL register. The point in time
 *    when SlvPending is set depends on whether the I2C interface is in HSCAPABLE mode. See Section
 *    25.7.2.2.2. When the I2C interface is configured to be HSCAPABLE, HS master codes are
 *    detected automatically. Due to the requirements of the HS I2C specification, slave addresses must
 *    also be detected automatically, since the address must be acknowledged before the clock can be
 *    stretched.
 *  0b0..In progress. The Slave function does not currently need service.
 *  0b1..Pending. The Slave function needs service. Information on what is needed can be found in the adjacent SLVSTATE
 * field.
 */
#define I2C_STAT_SLVPENDING(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVPENDING_SHIFT)) & I2C_STAT_SLVPENDING_MASK)
#define I2C_STAT_SLVSTATE_MASK (0x600U)
#define I2C_STAT_SLVSTATE_SHIFT (9U)
/*! SLVSTATE - Slave State code. Each value of this field indicates a specific required service for
 *    the Slave function. All other values are reserved. See Table 401 for state values and actions.
 *    note that the occurrence of some states and how they are handled are affected by DMA mode and
 *    Automatic Operation modes.
 *  0b00..Slave address. Address plus R/W received. At least one of the four slave addresses has been matched by
 * hardware. 0b01..Slave receive. Received data is available (Slave Receiver mode). 0b10..Slave transmit. Data can be
 * transmitted (Slave Transmitter mode).
 */
#define I2C_STAT_SLVSTATE(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSTATE_SHIFT)) & I2C_STAT_SLVSTATE_MASK)
#define I2C_STAT_SLVNOTSTR_MASK (0x800U)
#define I2C_STAT_SLVNOTSTR_SHIFT (11U)
/*! SLVNOTSTR - Slave Not Stretching. Indicates when the slave function is stretching the I2C clock.
 *    This is needed in order to gracefully invoke Deep Sleep or Power-down modes during slave
 *    operation. This read-only flag reflects the slave function status in real time.
 *  0b0..Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleep or Power-down mode cannot
 * be entered at this time. 0b1..Not stretching. The slave function is not currently stretching the I 2C bus clock.
 * Deep-sleep or Power-down mode could be entered at this time.
 */
#define I2C_STAT_SLVNOTSTR(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVNOTSTR_SHIFT)) & I2C_STAT_SLVNOTSTR_MASK)
#define I2C_STAT_SLVIDX_MASK (0x3000U)
#define I2C_STAT_SLVIDX_SHIFT (12U)
/*! SLVIDX - Slave address match Index. This field is valid when the I2C slave function has been
 *    selected by receiving an address that matches one of the slave addresses defined by any enabled
 *    slave address registers, and provides an identification of the address that was matched. It is
 *    possible that more than one address could be matched, but only one match can be reported here.
 *  0b00..Address 0. Slave address 0 was matched.
 *  0b01..Address 1. Slave address 1 was matched.
 *  0b10..Address 2. Slave address 2 was matched.
 *  0b11..Address 3. Slave address 3 was matched.
 */
#define I2C_STAT_SLVIDX(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVIDX_SHIFT)) & I2C_STAT_SLVIDX_MASK)
#define I2C_STAT_SLVSEL_MASK (0x4000U)
#define I2C_STAT_SLVSEL_SHIFT (14U)
/*! SLVSEL - Slave selected flag. SLVSEL is set after an address match when software tells the Slave
 *    function to acknowledge the address, or when the address has been automatically acknowledged.
 *    It is cleared when another address cycle presents an address that does not match an enabled
 *    address on the Slave function, when slave software decides to NACK a matched address, when
 *    there is a Stop detected on the bus, when the master NACKs slave data, and in some combinations of
 *    Automatic Operation. SLVSEL is not cleared if software NACKs data.
 *  0b0..Not selected. The Slave function is not currently selected.
 *  0b1..Selected. The Slave function is currently selected.
 */
#define I2C_STAT_SLVSEL(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSEL_SHIFT)) & I2C_STAT_SLVSEL_MASK)
#define I2C_STAT_SLVDESEL_MASK (0x8000U)
#define I2C_STAT_SLVDESEL_SHIFT (15U)
/*! SLVDESEL - Slave Deselected flag. This flag will cause an interrupt when set if enabled via
 *    INTENSET. This flag can be cleared by writing a 1 to this bit.
 *  0b0..Not deselected. The Slave function has not become deselected. This does not mean that it is currently
 *       selected. That information can be found in the SLVSEL flag.
 *  0b1..Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag
 *       changing from 1 to 0. See the description of SLVSEL for details on when that event occurs.
 */
#define I2C_STAT_SLVDESEL(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVDESEL_SHIFT)) & I2C_STAT_SLVDESEL_MASK)
#define I2C_STAT_MONRDY_MASK (0x10000U)
#define I2C_STAT_MONRDY_SHIFT (16U)
/*! MONRDY - Monitor Ready. This flag is cleared when the MONRXDAT register is read.
 *  0b0..No data. The Monitor function does not currently have data available.
 *  0b1..Data waiting. The Monitor function has data waiting to be read.
 */
#define I2C_STAT_MONRDY(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONRDY_SHIFT)) & I2C_STAT_MONRDY_MASK)
#define I2C_STAT_MONOV_MASK (0x20000U)
#define I2C_STAT_MONOV_SHIFT (17U)
/*! MONOV - Monitor Overflow flag.
 *  0b0..No overrun. Monitor data has not overrun.
 *  0b1..Overrun. A Monitor data overrun has occurred. This can only happen when Monitor clock stretching not
 *       enabled via the MONCLKSTR bit in the CFG register. Writing 1 to this bit clears the flag.
 */
#define I2C_STAT_MONOV(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONOV_SHIFT)) & I2C_STAT_MONOV_MASK)
#define I2C_STAT_MONACTIVE_MASK (0x40000U)
#define I2C_STAT_MONACTIVE_SHIFT (18U)
/*! MONACTIVE - Monitor Active flag. Indicates when the Monitor function considers the I 2C bus to
 *    be active. Active is defined here as when some Master is on the bus: a bus Start has occurred
 *    more recently than a bus Stop.
 *  0b0..Inactive. The Monitor function considers the I2C bus to be inactive.
 *  0b1..Active. The Monitor function considers the I2C bus to be active.
 */
#define I2C_STAT_MONACTIVE(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONACTIVE_SHIFT)) & I2C_STAT_MONACTIVE_MASK)
#define I2C_STAT_MONIDLE_MASK (0x80000U)
#define I2C_STAT_MONIDLE_SHIFT (19U)
/*! MONIDLE - Monitor Idle flag. This flag is set when the Monitor function sees the I2C bus change
 *    from active to inactive. This can be used by software to decide when to process data
 *    accumulated by the Monitor function. This flag will cause an interrupt when set if enabled via the
 *    INTENSET register. The flag can be cleared by writing a 1 to this bit.
 *  0b0..Not idle. The I2C bus is not idle, or this flag has been cleared by software.
 *  0b1..Idle. The I2C bus has gone idle at least once since the last time this flag was cleared by software.
 */
#define I2C_STAT_MONIDLE(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONIDLE_SHIFT)) & I2C_STAT_MONIDLE_MASK)
#define I2C_STAT_EVENTTIMEOUT_MASK (0x1000000U)
#define I2C_STAT_EVENTTIMEOUT_SHIFT (24U)
/*! EVENTTIMEOUT - Event Time-out Interrupt flag. Indicates when the time between events has been
 *    longer than the time specified by the TIMEOUT register. Events include Start, Stop, and clock
 *    edges. The flag is cleared by writing a 1 to this bit. No time-out is created when the I2C-bus
 *    is idle.
 *  0b0..No time-out. I2C bus events have not caused a time-out.
 *  0b1..Event time-out. The time between I2C bus events has been longer than the time specified by the TIMEOUT
 * register.
 */
#define I2C_STAT_EVENTTIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_EVENTTIMEOUT_SHIFT)) & I2C_STAT_EVENTTIMEOUT_MASK)
#define I2C_STAT_SCLTIMEOUT_MASK (0x2000000U)
#define I2C_STAT_SCLTIMEOUT_SHIFT (25U)
/*! SCLTIMEOUT - SCL Time-out Interrupt flag. Indicates when SCL has remained low longer than the
 *    time specific by the TIMEOUT register. The flag is cleared by writing a 1 to this bit.
 *  0b0..No time-out. SCL low time has not caused a time-out.
 *  0b1..Time-out. SCL low time has caused a time-out.
 */
#define I2C_STAT_SCLTIMEOUT(x) (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SCLTIMEOUT_SHIFT)) & I2C_STAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable Set and read register. */
/*! @{ */
#define I2C_INTENSET_MSTPENDINGEN_MASK (0x1U)
#define I2C_INTENSET_MSTPENDINGEN_SHIFT (0U)
/*! MSTPENDINGEN - Master Pending interrupt Enable.
 *  0b0..Disabled. The MstPending interrupt is disabled.
 *  0b1..Enabled. The MstPending interrupt is enabled.
 */
#define I2C_INTENSET_MSTPENDINGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTPENDINGEN_SHIFT)) & I2C_INTENSET_MSTPENDINGEN_MASK)
#define I2C_INTENSET_MSTARBLOSSEN_MASK (0x10U)
#define I2C_INTENSET_MSTARBLOSSEN_SHIFT (4U)
/*! MSTARBLOSSEN - Master Arbitration Loss interrupt Enable.
 *  0b0..Disabled. The MstArbLoss interrupt is disabled.
 *  0b1..Enabled. The MstArbLoss interrupt is enabled.
 */
#define I2C_INTENSET_MSTARBLOSSEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTARBLOSSEN_SHIFT)) & I2C_INTENSET_MSTARBLOSSEN_MASK)
#define I2C_INTENSET_MSTSTSTPERREN_MASK (0x40U)
#define I2C_INTENSET_MSTSTSTPERREN_SHIFT (6U)
/*! MSTSTSTPERREN - Master Start/Stop Error interrupt Enable.
 *  0b0..Disabled. The MstStStpErr interrupt is disabled.
 *  0b1..Enabled. The MstStStpErr interrupt is enabled.
 */
#define I2C_INTENSET_MSTSTSTPERREN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTSTSTPERREN_SHIFT)) & I2C_INTENSET_MSTSTSTPERREN_MASK)
#define I2C_INTENSET_SLVPENDINGEN_MASK (0x100U)
#define I2C_INTENSET_SLVPENDINGEN_SHIFT (8U)
/*! SLVPENDINGEN - Slave Pending interrupt Enable.
 *  0b0..Disabled. The SlvPending interrupt is disabled.
 *  0b1..Enabled. The SlvPending interrupt is enabled.
 */
#define I2C_INTENSET_SLVPENDINGEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVPENDINGEN_SHIFT)) & I2C_INTENSET_SLVPENDINGEN_MASK)
#define I2C_INTENSET_SLVNOTSTREN_MASK (0x800U)
#define I2C_INTENSET_SLVNOTSTREN_SHIFT (11U)
/*! SLVNOTSTREN - Slave Not Stretching interrupt Enable.
 *  0b0..Disabled. The SlvNotStr interrupt is disabled.
 *  0b1..Enabled. The SlvNotStr interrupt is enabled.
 */
#define I2C_INTENSET_SLVNOTSTREN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVNOTSTREN_SHIFT)) & I2C_INTENSET_SLVNOTSTREN_MASK)
#define I2C_INTENSET_SLVDESELEN_MASK (0x8000U)
#define I2C_INTENSET_SLVDESELEN_SHIFT (15U)
/*! SLVDESELEN - Slave Deselect interrupt Enable.
 *  0b0..Disabled. The SlvDeSel interrupt is disabled.
 *  0b1..Enabled. The SlvDeSel interrupt is enabled.
 */
#define I2C_INTENSET_SLVDESELEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVDESELEN_SHIFT)) & I2C_INTENSET_SLVDESELEN_MASK)
#define I2C_INTENSET_MONRDYEN_MASK (0x10000U)
#define I2C_INTENSET_MONRDYEN_SHIFT (16U)
/*! MONRDYEN - Monitor data Ready interrupt Enable.
 *  0b0..Disabled. The MonRdy interrupt is disabled.
 *  0b1..Enabled. The MonRdy interrupt is enabled.
 */
#define I2C_INTENSET_MONRDYEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONRDYEN_SHIFT)) & I2C_INTENSET_MONRDYEN_MASK)
#define I2C_INTENSET_MONOVEN_MASK (0x20000U)
#define I2C_INTENSET_MONOVEN_SHIFT (17U)
/*! MONOVEN - Monitor Overrun interrupt Enable.
 *  0b0..Disabled. The MonOv interrupt is disabled.
 *  0b1..Enabled. The MonOv interrupt is enabled.
 */
#define I2C_INTENSET_MONOVEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONOVEN_SHIFT)) & I2C_INTENSET_MONOVEN_MASK)
#define I2C_INTENSET_MONIDLEEN_MASK (0x80000U)
#define I2C_INTENSET_MONIDLEEN_SHIFT (19U)
/*! MONIDLEEN - Monitor Idle interrupt Enable.
 *  0b0..Disabled. The MonIdle interrupt is disabled.
 *  0b1..Enabled. The MonIdle interrupt is enabled.
 */
#define I2C_INTENSET_MONIDLEEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONIDLEEN_SHIFT)) & I2C_INTENSET_MONIDLEEN_MASK)
#define I2C_INTENSET_EVENTTIMEOUTEN_MASK (0x1000000U)
#define I2C_INTENSET_EVENTTIMEOUTEN_SHIFT (24U)
/*! EVENTTIMEOUTEN - Event time-out interrupt Enable.
 *  0b0..Disabled. The Event time-out interrupt is disabled.
 *  0b1..Enabled. The Event time-out interrupt is enabled.
 */
#define I2C_INTENSET_EVENTTIMEOUTEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_EVENTTIMEOUTEN_SHIFT)) & I2C_INTENSET_EVENTTIMEOUTEN_MASK)
#define I2C_INTENSET_SCLTIMEOUTEN_MASK (0x2000000U)
#define I2C_INTENSET_SCLTIMEOUTEN_SHIFT (25U)
/*! SCLTIMEOUTEN - SCL time-out interrupt Enable.
 *  0b0..Disabled. The SCL time-out interrupt is disabled.
 *  0b1..Enabled. The SCL time-out interrupt is enabled.
 */
#define I2C_INTENSET_SCLTIMEOUTEN(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SCLTIMEOUTEN_SHIFT)) & I2C_INTENSET_SCLTIMEOUTEN_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Enable Clear register. */
/*! @{ */
#define I2C_INTENCLR_MSTPENDINGCLR_MASK (0x1U)
#define I2C_INTENCLR_MSTPENDINGCLR_SHIFT (0U)
/*! MSTPENDINGCLR - Master Pending interrupt clear. Writing 1 to this bit clears the corresponding
 *    bit in the INTENSET register if implemented.
 */
#define I2C_INTENCLR_MSTPENDINGCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTPENDINGCLR_SHIFT)) & I2C_INTENCLR_MSTPENDINGCLR_MASK)
#define I2C_INTENCLR_MSTARBLOSSCLR_MASK (0x10U)
#define I2C_INTENCLR_MSTARBLOSSCLR_SHIFT (4U)
/*! MSTARBLOSSCLR - Master Arbitration Loss interrupt clear.
 */
#define I2C_INTENCLR_MSTARBLOSSCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTARBLOSSCLR_SHIFT)) & I2C_INTENCLR_MSTARBLOSSCLR_MASK)
#define I2C_INTENCLR_MSTSTSTPERRCLR_MASK (0x40U)
#define I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT (6U)
/*! MSTSTSTPERRCLR - Master Start/Stop Error interrupt clear.
 */
#define I2C_INTENCLR_MSTSTSTPERRCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT)) & I2C_INTENCLR_MSTSTSTPERRCLR_MASK)
#define I2C_INTENCLR_SLVPENDINGCLR_MASK (0x100U)
#define I2C_INTENCLR_SLVPENDINGCLR_SHIFT (8U)
/*! SLVPENDINGCLR - Slave Pending interrupt clear.
 */
#define I2C_INTENCLR_SLVPENDINGCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVPENDINGCLR_SHIFT)) & I2C_INTENCLR_SLVPENDINGCLR_MASK)
#define I2C_INTENCLR_SLVNOTSTRCLR_MASK (0x800U)
#define I2C_INTENCLR_SLVNOTSTRCLR_SHIFT (11U)
/*! SLVNOTSTRCLR - Slave Not Stretching interrupt clear.
 */
#define I2C_INTENCLR_SLVNOTSTRCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVNOTSTRCLR_SHIFT)) & I2C_INTENCLR_SLVNOTSTRCLR_MASK)
#define I2C_INTENCLR_SLVDESELCLR_MASK (0x8000U)
#define I2C_INTENCLR_SLVDESELCLR_SHIFT (15U)
/*! SLVDESELCLR - Slave Deselect interrupt clear.
 */
#define I2C_INTENCLR_SLVDESELCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVDESELCLR_SHIFT)) & I2C_INTENCLR_SLVDESELCLR_MASK)
#define I2C_INTENCLR_MONRDYCLR_MASK (0x10000U)
#define I2C_INTENCLR_MONRDYCLR_SHIFT (16U)
/*! MONRDYCLR - Monitor data Ready interrupt clear.
 */
#define I2C_INTENCLR_MONRDYCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONRDYCLR_SHIFT)) & I2C_INTENCLR_MONRDYCLR_MASK)
#define I2C_INTENCLR_MONOVCLR_MASK (0x20000U)
#define I2C_INTENCLR_MONOVCLR_SHIFT (17U)
/*! MONOVCLR - Monitor Overrun interrupt clear.
 */
#define I2C_INTENCLR_MONOVCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONOVCLR_SHIFT)) & I2C_INTENCLR_MONOVCLR_MASK)
#define I2C_INTENCLR_MONIDLECLR_MASK (0x80000U)
#define I2C_INTENCLR_MONIDLECLR_SHIFT (19U)
/*! MONIDLECLR - Monitor Idle interrupt clear.
 */
#define I2C_INTENCLR_MONIDLECLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONIDLECLR_SHIFT)) & I2C_INTENCLR_MONIDLECLR_MASK)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_MASK (0x1000000U)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT (24U)
/*! EVENTTIMEOUTCLR - Event time-out interrupt clear.
 */
#define I2C_INTENCLR_EVENTTIMEOUTCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_EVENTTIMEOUTCLR_MASK)
#define I2C_INTENCLR_SCLTIMEOUTCLR_MASK (0x2000000U)
#define I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT (25U)
/*! SCLTIMEOUTCLR - SCL time-out interrupt clear.
 */
#define I2C_INTENCLR_SCLTIMEOUTCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_SCLTIMEOUTCLR_MASK)
/*! @} */

/*! @name TIMEOUT - Time-out value register. */
/*! @{ */
#define I2C_TIMEOUT_TOMIN_MASK (0xFU)
#define I2C_TIMEOUT_TOMIN_SHIFT (0U)
/*! TOMIN - Time-out time value, bottom four bits. These are hard-wired to 0xF. This gives a minimum
 *    time-out of 16 I2C function clocks and also a time-out resolution of 16 I2C function clocks.
 */
#define I2C_TIMEOUT_TOMIN(x) (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TOMIN_SHIFT)) & I2C_TIMEOUT_TOMIN_MASK)
#define I2C_TIMEOUT_TO_MASK (0xFFF0U)
#define I2C_TIMEOUT_TO_SHIFT (4U)
/*! TO - Time-out time value. Specifies the time-out interval value in increments of 16 I 2C
 *    function clocks, as defined by the CLKDIV register. To change this value while I2C is in operation,
 *    disable all time-outs, write a new value to TIMEOUT, then re-enable time-outs. 0x000 = A
 *    time-out will occur after 16 counts of the I2C function clock. 0x001 = A time-out will occur after
 *    32 counts of the I2C function clock. 0xFFF = A time-out will occur after 65,536 counts of the
 *    I2C function clock.
 */
#define I2C_TIMEOUT_TO(x) (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TO_SHIFT)) & I2C_TIMEOUT_TO_MASK)
/*! @} */

/*! @name CLKDIV - Clock pre-divider for the entire I2C interface. This determines what time increments are used for the
 * MSTTIME register, and controls some timing of the Slave function. */
/*! @{ */
#define I2C_CLKDIV_DIVVAL_MASK (0xFFFFU)
#define I2C_CLKDIV_DIVVAL_SHIFT (0U)
/*! DIVVAL - This field controls how the Flexcomm clock (FCLK) is used by the I2C functions that
 *    need an internal clock in order to operate. 0x0000 = FCLK is used directly by the I2C. 0x0001 =
 *    FCLK is divided by 2 before use. 0x0002 = FCLK is divided by 3 before use. 0xFFFF = FCLK is
 *    divided by 65,536 before use.
 */
#define I2C_CLKDIV_DIVVAL(x) (((uint32_t)(((uint32_t)(x)) << I2C_CLKDIV_DIVVAL_SHIFT)) & I2C_CLKDIV_DIVVAL_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt Status register for Master, Slave, and Monitor functions. */
/*! @{ */
#define I2C_INTSTAT_MSTPENDING_MASK (0x1U)
#define I2C_INTSTAT_MSTPENDING_SHIFT (0U)
/*! MSTPENDING - Master Pending.
 */
#define I2C_INTSTAT_MSTPENDING(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTPENDING_SHIFT)) & I2C_INTSTAT_MSTPENDING_MASK)
#define I2C_INTSTAT_MSTARBLOSS_MASK (0x10U)
#define I2C_INTSTAT_MSTARBLOSS_SHIFT (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag.
 */
#define I2C_INTSTAT_MSTARBLOSS(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTARBLOSS_SHIFT)) & I2C_INTSTAT_MSTARBLOSS_MASK)
#define I2C_INTSTAT_MSTSTSTPERR_MASK (0x40U)
#define I2C_INTSTAT_MSTSTSTPERR_SHIFT (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag.
 */
#define I2C_INTSTAT_MSTSTSTPERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTSTSTPERR_SHIFT)) & I2C_INTSTAT_MSTSTSTPERR_MASK)
#define I2C_INTSTAT_SLVPENDING_MASK (0x100U)
#define I2C_INTSTAT_SLVPENDING_SHIFT (8U)
/*! SLVPENDING - Slave Pending.
 */
#define I2C_INTSTAT_SLVPENDING(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVPENDING_SHIFT)) & I2C_INTSTAT_SLVPENDING_MASK)
#define I2C_INTSTAT_SLVNOTSTR_MASK (0x800U)
#define I2C_INTSTAT_SLVNOTSTR_SHIFT (11U)
/*! SLVNOTSTR - Slave Not Stretching status.
 */
#define I2C_INTSTAT_SLVNOTSTR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVNOTSTR_SHIFT)) & I2C_INTSTAT_SLVNOTSTR_MASK)
#define I2C_INTSTAT_SLVDESEL_MASK (0x8000U)
#define I2C_INTSTAT_SLVDESEL_SHIFT (15U)
/*! SLVDESEL - Slave Deselected flag.
 */
#define I2C_INTSTAT_SLVDESEL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVDESEL_SHIFT)) & I2C_INTSTAT_SLVDESEL_MASK)
#define I2C_INTSTAT_MONRDY_MASK (0x10000U)
#define I2C_INTSTAT_MONRDY_SHIFT (16U)
/*! MONRDY - Monitor Ready.
 */
#define I2C_INTSTAT_MONRDY(x) (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONRDY_SHIFT)) & I2C_INTSTAT_MONRDY_MASK)
#define I2C_INTSTAT_MONOV_MASK (0x20000U)
#define I2C_INTSTAT_MONOV_SHIFT (17U)
/*! MONOV - Monitor Overflow flag.
 */
#define I2C_INTSTAT_MONOV(x) (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONOV_SHIFT)) & I2C_INTSTAT_MONOV_MASK)
#define I2C_INTSTAT_MONIDLE_MASK (0x80000U)
#define I2C_INTSTAT_MONIDLE_SHIFT (19U)
/*! MONIDLE - Monitor Idle flag.
 */
#define I2C_INTSTAT_MONIDLE(x) (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONIDLE_SHIFT)) & I2C_INTSTAT_MONIDLE_MASK)
#define I2C_INTSTAT_EVENTTIMEOUT_MASK (0x1000000U)
#define I2C_INTSTAT_EVENTTIMEOUT_SHIFT (24U)
/*! EVENTTIMEOUT - Event time-out Interrupt flag.
 */
#define I2C_INTSTAT_EVENTTIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_EVENTTIMEOUT_SHIFT)) & I2C_INTSTAT_EVENTTIMEOUT_MASK)
#define I2C_INTSTAT_SCLTIMEOUT_MASK (0x2000000U)
#define I2C_INTSTAT_SCLTIMEOUT_SHIFT (25U)
/*! SCLTIMEOUT - SCL time-out Interrupt flag.
 */
#define I2C_INTSTAT_SCLTIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SCLTIMEOUT_SHIFT)) & I2C_INTSTAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name MSTCTL - Master control register. */
/*! @{ */
#define I2C_MSTCTL_MSTCONTINUE_MASK (0x1U)
#define I2C_MSTCTL_MSTCONTINUE_SHIFT (0U)
/*! MSTCONTINUE - Master Continue. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Continue. Informs the Master function to continue to the next operation. This must done after writing
 *       transmit data, reading received data, or any other housekeeping related to the next bus operation.
 */
#define I2C_MSTCTL_MSTCONTINUE(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTCONTINUE_SHIFT)) & I2C_MSTCTL_MSTCONTINUE_MASK)
#define I2C_MSTCTL_MSTSTART_MASK (0x2U)
#define I2C_MSTCTL_MSTSTART_SHIFT (1U)
/*! MSTSTART - Master Start control. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Start. A Start will be generated on the I2C bus at the next allowed time.
 */
#define I2C_MSTCTL_MSTSTART(x) (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTART_SHIFT)) & I2C_MSTCTL_MSTSTART_MASK)
#define I2C_MSTCTL_MSTSTOP_MASK (0x4U)
#define I2C_MSTCTL_MSTSTOP_SHIFT (2U)
/*! MSTSTOP - Master Stop control. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a NACK to the slave
 *       if the master is receiving data from the slave (Master Receiver mode).
 */
#define I2C_MSTCTL_MSTSTOP(x) (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTOP_SHIFT)) & I2C_MSTCTL_MSTSTOP_MASK)
#define I2C_MSTCTL_MSTDMA_MASK (0x8U)
#define I2C_MSTCTL_MSTDMA_SHIFT (3U)
/*! MSTDMA - Master DMA enable. Data operations of the I2C can be performed with DMA. Protocol type
 *    operations such as Start, address, Stop, and address match must always be done with software,
 *    typically via an interrupt. Address acknowledgement must also be done by software except when
 *    the I2C is configured to be HSCAPABLE (and address acknowledgement is handled entirely by
 *    hardware) or when Automatic Operation is enabled. When a DMA data transfer is complete, MSTDMA
 *    must be cleared prior to beginning the next operation, typically a Start or Stop.This bit is
 *    read/write.
 *  0b0..Disable. No DMA requests are generated for master operation.
 *  0b1..Enable. A DMA request is generated for I2C master data operations. When this I2C master is generating
 *       Acknowledge bits in Master Receiver mode, the acknowledge is generated automatically.
 */
#define I2C_MSTCTL_MSTDMA(x) (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTDMA_SHIFT)) & I2C_MSTCTL_MSTDMA_MASK)
/*! @} */

/*! @name MSTTIME - Master timing configuration. */
/*! @{ */
#define I2C_MSTTIME_MSTSCLLOW_MASK (0x7U)
#define I2C_MSTTIME_MSTSCLLOW_SHIFT (0U)
/*! MSTSCLLOW - Master SCL Low time. Specifies the minimum low time that will be asserted by this
 *    master on SCL. Other devices on the bus (masters or slaves) could lengthen this time. This
 *    corresponds to the parameter t LOW in the I2C bus specification. I2C bus specification parameters
 *    tBUF and tSU;STA have the same values and are also controlled by MSTSCLLOW.
 *  0b000..2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
 *  0b010..4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLLOW_SHIFT)) & I2C_MSTTIME_MSTSCLLOW_MASK)
#define I2C_MSTTIME_MSTSCLHIGH_MASK (0x70U)
#define I2C_MSTTIME_MSTSCLHIGH_SHIFT (4U)
/*! MSTSCLHIGH - Master SCL High time. Specifies the minimum high time that will be asserted by this
 *    master on SCL. Other masters in a multi-master system could shorten this time. This
 *    corresponds to the parameter tHIGH in the I2C bus specification. I2C bus specification parameters
 *    tSU;STO and tHD;STA have the same values and are also controlled by MSTSCLHIGH.
 *  0b000..2 clocks. Minimum SCL high time is 2 clock of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
 *  0b010..4 clocks. Minimum SCL high time is 4 clock of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL high time is 5 clock of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL high time is 6 clock of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL high time is 7 clock of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL high time is 8 clock of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLHIGH(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLHIGH_SHIFT)) & I2C_MSTTIME_MSTSCLHIGH_MASK)
/*! @} */

/*! @name MSTDAT - Combined Master receiver and transmitter data register. */
/*! @{ */
#define I2C_MSTDAT_DATA_MASK (0xFFU)
#define I2C_MSTDAT_DATA_SHIFT (0U)
/*! DATA - Master function data register. Read: read the most recently received data for the Master
 *    function. Write: transmit data using the Master function.
 */
#define I2C_MSTDAT_DATA(x) (((uint32_t)(((uint32_t)(x)) << I2C_MSTDAT_DATA_SHIFT)) & I2C_MSTDAT_DATA_MASK)
/*! @} */

/*! @name SLVCTL - Slave control register. */
/*! @{ */
#define I2C_SLVCTL_SLVCONTINUE_MASK (0x1U)
#define I2C_SLVCTL_SLVCONTINUE_SHIFT (0U)
/*! SLVCONTINUE - Slave Continue.
 *  0b0..No effect.
 *  0b1..Continue. Informs the Slave function to continue to the next operation, by clearing the SLVPENDING flag
 *       in the STAT register. This must be done after writing transmit data, reading received data, or any other
 *       housekeeping related to the next bus operation. Automatic Operation has different requirements. SLVCONTINUE
 *       should not be set unless SLVPENDING = 1.
 */
#define I2C_SLVCTL_SLVCONTINUE(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVCONTINUE_SHIFT)) & I2C_SLVCTL_SLVCONTINUE_MASK)
#define I2C_SLVCTL_SLVNACK_MASK (0x2U)
#define I2C_SLVCTL_SLVNACK_SHIFT (1U)
/*! SLVNACK - Slave NACK.
 *  0b0..No effect.
 *  0b1..NACK. Causes the Slave function to NACK the master when the slave is receiving data from the master (Slave
 * Receiver mode).
 */
#define I2C_SLVCTL_SLVNACK(x) (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVNACK_SHIFT)) & I2C_SLVCTL_SLVNACK_MASK)
#define I2C_SLVCTL_SLVDMA_MASK (0x8U)
#define I2C_SLVCTL_SLVDMA_SHIFT (3U)
/*! SLVDMA - Slave DMA enable.
 *  0b0..Disabled. No DMA requests are issued for Slave mode operation.
 *  0b1..Enabled. DMA requests are issued for I2C slave data transmission and reception.
 */
#define I2C_SLVCTL_SLVDMA(x) (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVDMA_SHIFT)) & I2C_SLVCTL_SLVDMA_MASK)
#define I2C_SLVCTL_AUTOACK_MASK (0x100U)
#define I2C_SLVCTL_AUTOACK_SHIFT (8U)
/*! AUTOACK - Automatic Acknowledge.When this bit is set, it will cause an I2C header which matches
 *    SLVADR0 and the direction set by AUTOMATCHREAD to be ACKed immediately; this is used with DMA
 *    to allow processing of the data without intervention. If this bit is clear and a header
 *    matches SLVADR0, the behavior is controlled by AUTONACK in the SLVADR0 register: allowing NACK or
 *    interrupt.
 *  0b0..Normal, non-automatic operation. If AUTONACK = 0, an SlvPending interrupt is generated when a matching
 *       address is received. If AUTONACK = 1, received addresses are NACKed (ignored).
 *  0b1..A header with matching SLVADR0 and matching direction as set by AUTOMATCHREAD will be ACKed immediately,
 *       allowing the master to move on to the data bytes. If the address matches SLVADR0, but the direction does
 *       not match AUTOMATCHREAD, the behavior will depend on the AUTONACK bit in the SLVADR0 register: if AUTONACK
 *       is set, then it will be Nacked; else if AUTONACK is clear, then a SlvPending interrupt is generated.
 */
#define I2C_SLVCTL_AUTOACK(x) (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOACK_SHIFT)) & I2C_SLVCTL_AUTOACK_MASK)
#define I2C_SLVCTL_AUTOMATCHREAD_MASK (0x200U)
#define I2C_SLVCTL_AUTOMATCHREAD_SHIFT (9U)
/*! AUTOMATCHREAD - When AUTOACK is set, this bit controls whether it matches a read or write
 *    request on the next header with an address matching SLVADR0. Since DMA needs to be configured to
 *    match the transfer direction, the direction needs to be specified. This bit allows a direction to
 *    be chosen for the next operation.
 *  0b0..The expected next operation in Automatic Mode is an I2C write.
 *  0b1..The expected next operation in Automatic Mode is an I2C read.
 */
#define I2C_SLVCTL_AUTOMATCHREAD(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOMATCHREAD_SHIFT)) & I2C_SLVCTL_AUTOMATCHREAD_MASK)
/*! @} */

/*! @name SLVDAT - Combined Slave receiver and transmitter data register. */
/*! @{ */
#define I2C_SLVDAT_DATA_MASK (0xFFU)
#define I2C_SLVDAT_DATA_SHIFT (0U)
/*! DATA - Slave function data register. Read: read the most recently received data for the Slave
 *    function. Write: transmit data using the Slave function.
 */
#define I2C_SLVDAT_DATA(x) (((uint32_t)(((uint32_t)(x)) << I2C_SLVDAT_DATA_SHIFT)) & I2C_SLVDAT_DATA_MASK)
/*! @} */

/*! @name SLVADR - Slave address register. */
/*! @{ */
#define I2C_SLVADR_SADISABLE_MASK (0x1U)
#define I2C_SLVADR_SADISABLE_SHIFT (0U)
/*! SADISABLE - Slave Address n Disable.
 *  0b0..Enabled. Slave Address n is enabled.
 *  0b1..Ignored Slave Address n is ignored.
 */
#define I2C_SLVADR_SADISABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SADISABLE_SHIFT)) & I2C_SLVADR_SADISABLE_MASK)
#define I2C_SLVADR_SLVADR_MASK (0xFEU)
#define I2C_SLVADR_SLVADR_SHIFT (1U)
/*! SLVADR - Slave Address. Seven bit slave address that is compared to received addresses if enabled.
 */
#define I2C_SLVADR_SLVADR(x) (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SLVADR_SHIFT)) & I2C_SLVADR_SLVADR_MASK)
#define I2C_SLVADR_AUTONACK_MASK (0x8000U)
#define I2C_SLVADR_AUTONACK_SHIFT (15U)
/*! AUTONACK - Automatic NACK operation. Used in conjunction with AUTOACK and AUTOMATCHREAD, allows
 *    software to ignore I2C traffic while handling previous I2C data or other operations.
 *  0b0..Normal operation, matching I2C addresses are not ignored.
 *  0b1..Automatic-only mode. All incoming addresses are ignored (NACKed), unless AUTOACK is set, it matches
 *       SLVADRn, and AUTOMATCHREAD matches the direction.
 */
#define I2C_SLVADR_AUTONACK(x) (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_AUTONACK_SHIFT)) & I2C_SLVADR_AUTONACK_MASK)
/*! @} */

/* The count of I2C_SLVADR */
#define I2C_SLVADR_COUNT (4U)

/*! @name SLVQUAL0 - Slave Qualification for address 0. */
/*! @{ */
#define I2C_SLVQUAL0_QUALMODE0_MASK (0x1U)
#define I2C_SLVQUAL0_QUALMODE0_SHIFT (0U)
/*! QUALMODE0 - Qualify mode for slave address 0.
 *  0b0..Mask. The SLVQUAL0 field is used as a logical mask for matching address 0.
 *  0b1..Extend. The SLVQUAL0 field is used to extend address 0 matching in a range of addresses.
 */
#define I2C_SLVQUAL0_QUALMODE0(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_QUALMODE0_SHIFT)) & I2C_SLVQUAL0_QUALMODE0_MASK)
#define I2C_SLVQUAL0_SLVQUAL0_MASK (0xFEU)
#define I2C_SLVQUAL0_SLVQUAL0_SHIFT (1U)
/*! SLVQUAL0 - Slave address Qualifier for address 0. A value of 0 causes the address in SLVADR0 to
 *    be used as-is, assuming that it is enabled. If QUALMODE0 = 0, any bit in this field which is
 *    set to 1 will cause an automatic match of the corresponding bit of the received address when it
 *    is compared to the SLVADR0 register. If QUALMODE0 = 1, an address range is matched for
 *    address 0. This range extends from the value defined by SLVADR0 to the address defined by SLVQUAL0
 *    (address matches when SLVADR0[7:1] <= received address <= SLVQUAL0[7:1]).
 */
#define I2C_SLVQUAL0_SLVQUAL0(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_SLVQUAL0_SHIFT)) & I2C_SLVQUAL0_SLVQUAL0_MASK)
/*! @} */

/*! @name MONRXDAT - Monitor receiver data register. */
/*! @{ */
#define I2C_MONRXDAT_MONRXDAT_MASK (0xFFU)
#define I2C_MONRXDAT_MONRXDAT_SHIFT (0U)
/*! MONRXDAT - Monitor function Receiver Data. This reflects every data byte that passes on the I2C pins.
 */
#define I2C_MONRXDAT_MONRXDAT(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRXDAT_SHIFT)) & I2C_MONRXDAT_MONRXDAT_MASK)
#define I2C_MONRXDAT_MONSTART_MASK (0x100U)
#define I2C_MONRXDAT_MONSTART_SHIFT (8U)
/*! MONSTART - Monitor Received Start.
 *  0b0..No start detected. The Monitor function has not detected a Start event on the I2C bus.
 *  0b1..Start detected. The Monitor function has detected a Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONSTART(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONSTART_SHIFT)) & I2C_MONRXDAT_MONSTART_MASK)
#define I2C_MONRXDAT_MONRESTART_MASK (0x200U)
#define I2C_MONRXDAT_MONRESTART_SHIFT (9U)
/*! MONRESTART - Monitor Received Repeated Start.
 *  0b0..No repeated start detected. The Monitor function has not detected a Repeated Start event on the I2C bus.
 *  0b1..Repeated start detected. The Monitor function has detected a Repeated Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONRESTART(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRESTART_SHIFT)) & I2C_MONRXDAT_MONRESTART_MASK)
#define I2C_MONRXDAT_MONNACK_MASK (0x400U)
#define I2C_MONRXDAT_MONNACK_SHIFT (10U)
/*! MONNACK - Monitor Received NACK.
 *  0b0..Acknowledged. The data currently being provided by the Monitor function was acknowledged by at least one master
 * or slave receiver. 0b1..Not acknowledged. The data currently being provided by the Monitor function was not
 * acknowledged by any receiver.
 */
#define I2C_MONRXDAT_MONNACK(x) \
    (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONNACK_SHIFT)) & I2C_MONRXDAT_MONNACK_MASK)
/*! @} */

/*! @name ID - Peripheral identification register. */
/*! @{ */
#define I2C_ID_APERTURE_MASK (0xFFU)
#define I2C_ID_APERTURE_SHIFT (0U)
/*! APERTURE - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define I2C_ID_APERTURE(x) (((uint32_t)(((uint32_t)(x)) << I2C_ID_APERTURE_SHIFT)) & I2C_ID_APERTURE_MASK)
#define I2C_ID_MINOR_REV_MASK (0xF00U)
#define I2C_ID_MINOR_REV_SHIFT (8U)
/*! MINOR_REV - Minor revision of module implementation.
 */
#define I2C_ID_MINOR_REV(x) (((uint32_t)(((uint32_t)(x)) << I2C_ID_MINOR_REV_SHIFT)) & I2C_ID_MINOR_REV_MASK)
#define I2C_ID_MAJOR_REV_MASK (0xF000U)
#define I2C_ID_MAJOR_REV_SHIFT (12U)
/*! MAJOR_REV - Major revision of module implementation.
 */
#define I2C_ID_MAJOR_REV(x) (((uint32_t)(((uint32_t)(x)) << I2C_ID_MAJOR_REV_SHIFT)) & I2C_ID_MAJOR_REV_MASK)
#define I2C_ID_ID_MASK (0xFFFF0000U)
#define I2C_ID_ID_SHIFT (16U)
/*! ID - Module identifier for the selected function.
 */
#define I2C_ID_ID(x) (((uint32_t)(((uint32_t)(x)) << I2C_ID_ID_SHIFT)) & I2C_ID_ID_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group I2C_Register_Masks */

/* I2C - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral I2C0 base address */
#define I2C0_BASE (0x50086000u)
/** Peripheral I2C0 base address */
#define I2C0_BASE_NS (0x40086000u)
/** Peripheral I2C0 base pointer */
#define I2C0 ((I2C_Type *)I2C0_BASE)
/** Peripheral I2C0 base pointer */
#define I2C0_NS ((I2C_Type *)I2C0_BASE_NS)
/** Peripheral I2C1 base address */
#define I2C1_BASE (0x50087000u)
/** Peripheral I2C1 base address */
#define I2C1_BASE_NS (0x40087000u)
/** Peripheral I2C1 base pointer */
#define I2C1 ((I2C_Type *)I2C1_BASE)
/** Peripheral I2C1 base pointer */
#define I2C1_NS ((I2C_Type *)I2C1_BASE_NS)
/** Peripheral I2C2 base address */
#define I2C2_BASE (0x50088000u)
/** Peripheral I2C2 base address */
#define I2C2_BASE_NS (0x40088000u)
/** Peripheral I2C2 base pointer */
#define I2C2 ((I2C_Type *)I2C2_BASE)
/** Peripheral I2C2 base pointer */
#define I2C2_NS ((I2C_Type *)I2C2_BASE_NS)
/** Peripheral I2C3 base address */
#define I2C3_BASE (0x50089000u)
/** Peripheral I2C3 base address */
#define I2C3_BASE_NS (0x40089000u)
/** Peripheral I2C3 base pointer */
#define I2C3 ((I2C_Type *)I2C3_BASE)
/** Peripheral I2C3 base pointer */
#define I2C3_NS ((I2C_Type *)I2C3_BASE_NS)
/** Peripheral I2C4 base address */
#define I2C4_BASE (0x5008A000u)
/** Peripheral I2C4 base address */
#define I2C4_BASE_NS (0x4008A000u)
/** Peripheral I2C4 base pointer */
#define I2C4 ((I2C_Type *)I2C4_BASE)
/** Peripheral I2C4 base pointer */
#define I2C4_NS ((I2C_Type *)I2C4_BASE_NS)
/** Peripheral I2C5 base address */
#define I2C5_BASE (0x50096000u)
/** Peripheral I2C5 base address */
#define I2C5_BASE_NS (0x40096000u)
/** Peripheral I2C5 base pointer */
#define I2C5 ((I2C_Type *)I2C5_BASE)
/** Peripheral I2C5 base pointer */
#define I2C5_NS ((I2C_Type *)I2C5_BASE_NS)
/** Peripheral I2C6 base address */
#define I2C6_BASE (0x50097000u)
/** Peripheral I2C6 base address */
#define I2C6_BASE_NS (0x40097000u)
/** Peripheral I2C6 base pointer */
#define I2C6 ((I2C_Type *)I2C6_BASE)
/** Peripheral I2C6 base pointer */
#define I2C6_NS ((I2C_Type *)I2C6_BASE_NS)
/** Peripheral I2C7 base address */
#define I2C7_BASE (0x50098000u)
/** Peripheral I2C7 base address */
#define I2C7_BASE_NS (0x40098000u)
/** Peripheral I2C7 base pointer */
#define I2C7 ((I2C_Type *)I2C7_BASE)
/** Peripheral I2C7 base pointer */
#define I2C7_NS ((I2C_Type *)I2C7_BASE_NS)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                                                                         \
    {                                                                                          \
        I2C0_BASE, I2C1_BASE, I2C2_BASE, I2C3_BASE, I2C4_BASE, I2C5_BASE, I2C6_BASE, I2C7_BASE \
    }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                                  \
    {                                                  \
        I2C0, I2C1, I2C2, I2C3, I2C4, I2C5, I2C6, I2C7 \
    }
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS_NS                                                                                              \
    {                                                                                                                  \
        I2C0_BASE_NS, I2C1_BASE_NS, I2C2_BASE_NS, I2C3_BASE_NS, I2C4_BASE_NS, I2C5_BASE_NS, I2C6_BASE_NS, I2C7_BASE_NS \
    }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS_NS                                                       \
    {                                                                          \
        I2C0_NS, I2C1_NS, I2C2_NS, I2C3_NS, I2C4_NS, I2C5_NS, I2C6_NS, I2C7_NS \
    }
#else
/** Peripheral I2C0 base address */
#define I2C0_BASE (0x40086000u)
/** Peripheral I2C0 base pointer */
#define I2C0 ((I2C_Type *)I2C0_BASE)
/** Peripheral I2C1 base address */
#define I2C1_BASE (0x40087000u)
/** Peripheral I2C1 base pointer */
#define I2C1 ((I2C_Type *)I2C1_BASE)
/** Peripheral I2C2 base address */
#define I2C2_BASE (0x40088000u)
/** Peripheral I2C2 base pointer */
#define I2C2 ((I2C_Type *)I2C2_BASE)
/** Peripheral I2C3 base address */
#define I2C3_BASE (0x40089000u)
/** Peripheral I2C3 base pointer */
#define I2C3 ((I2C_Type *)I2C3_BASE)
/** Peripheral I2C4 base address */
#define I2C4_BASE (0x4008A000u)
/** Peripheral I2C4 base pointer */
#define I2C4 ((I2C_Type *)I2C4_BASE)
/** Peripheral I2C5 base address */
#define I2C5_BASE (0x40096000u)
/** Peripheral I2C5 base pointer */
#define I2C5 ((I2C_Type *)I2C5_BASE)
/** Peripheral I2C6 base address */
#define I2C6_BASE (0x40097000u)
/** Peripheral I2C6 base pointer */
#define I2C6 ((I2C_Type *)I2C6_BASE)
/** Peripheral I2C7 base address */
#define I2C7_BASE (0x40098000u)
/** Peripheral I2C7 base pointer */
#define I2C7 ((I2C_Type *)I2C7_BASE)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                                                                         \
    {                                                                                          \
        I2C0_BASE, I2C1_BASE, I2C2_BASE, I2C3_BASE, I2C4_BASE, I2C5_BASE, I2C6_BASE, I2C7_BASE \
    }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                                  \
    {                                                  \
        I2C0, I2C1, I2C2, I2C3, I2C4, I2C5, I2C6, I2C7 \
    }
#endif
/** Interrupt vectors for the I2C peripheral type */
#define I2C_IRQS                                                                                        \
    {                                                                                                   \
        FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, \
            FLEXCOMM6_IRQn, FLEXCOMM7_IRQn                                                              \
    }

/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- I2S Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Peripheral_Access_Layer I2S Peripheral Access Layer
 * @{
 */

/** I2S - Register Layout Typedef */
typedef struct
{
    uint8_t RESERVED_0[3072];
    __IO uint32_t CFG1; /**< Configuration register 1 for the primary channel pair., offset: 0xC00 */
    __IO uint32_t CFG2; /**< Configuration register 2 for the primary channel pair., offset: 0xC04 */
    __IO uint32_t STAT; /**< Status register for the primary channel pair., offset: 0xC08 */
    uint8_t RESERVED_1[16];
    __IO uint32_t DIV; /**< Clock divider, used by all channel pairs., offset: 0xC1C */
    uint8_t RESERVED_2[480];
    __IO uint32_t FIFOCFG;  /**< FIFO configuration and enable register., offset: 0xE00 */
    __IO uint32_t FIFOSTAT; /**< FIFO status register., offset: 0xE04 */
    __IO uint32_t FIFOTRIG; /**< FIFO trigger settings for interrupt and DMA request., offset: 0xE08 */
    uint8_t RESERVED_3[4];
    __IO uint32_t FIFOINTENSET; /**< FIFO interrupt enable set (enable) and read register., offset: 0xE10 */
    __IO uint32_t FIFOINTENCLR; /**< FIFO interrupt enable clear (disable) and read register., offset: 0xE14 */
    __I uint32_t FIFOINTSTAT;   /**< FIFO interrupt status register., offset: 0xE18 */
    uint8_t RESERVED_4[4];
    __O uint32_t FIFOWR;    /**< FIFO write data., offset: 0xE20 */
    __O uint32_t FIFOWR48H; /**< FIFO write data for upper data bits. May only be used if the I2S is configured for 2x
                               24-bit data and not using DMA., offset: 0xE24 */
    uint8_t RESERVED_5[8];
    __I uint32_t FIFORD;    /**< FIFO read data., offset: 0xE30 */
    __I uint32_t FIFORD48H; /**< FIFO read data for upper data bits. May only be used if the I2S is configured for 2x
                               24-bit data and not using DMA., offset: 0xE34 */
    uint8_t RESERVED_6[8];
    __I uint32_t FIFORDNOPOP;    /**< FIFO data read with no FIFO pop., offset: 0xE40 */
    __I uint32_t FIFORD48HNOPOP; /**< FIFO data read for upper data bits with no FIFO pop. May only be used if the I2S
                                    is configured for 2x 24-bit data and not using DMA., offset: 0xE44 */
    uint8_t RESERVED_7[436];
    __I uint32_t ID; /**< I2S Module identification, offset: 0xFFC */
} I2S_Type;

/* ----------------------------------------------------------------------------
   -- I2S Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Register_Masks I2S Register Masks
 * @{
 */

/*! @name CFG1 - Configuration register 1 for the primary channel pair. */
/*! @{ */
#define I2S_CFG1_MAINENABLE_MASK (0x1U)
#define I2S_CFG1_MAINENABLE_SHIFT (0U)
/*! MAINENABLE - Main enable for I 2S function in this Flexcomm
 *  0b0..All I 2S channel pairs in this Flexcomm are disabled and the internal state machines, counters, and flags
 *       are reset. No other channel pairs can be enabled.
 *  0b1..This I 2S channel pair is enabled. Other channel pairs in this Flexcomm may be enabled in their individual
 * PAIRENABLE bits.
 */
#define I2S_CFG1_MAINENABLE(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MAINENABLE_SHIFT)) & I2S_CFG1_MAINENABLE_MASK)
#define I2S_CFG1_DATAPAUSE_MASK (0x2U)
#define I2S_CFG1_DATAPAUSE_SHIFT (1U)
/*! DATAPAUSE - Data flow Pause. Allows pausing data flow between the I2S serializer/deserializer
 *    and the FIFO. This could be done in order to change streams, or while restarting after a data
 *    underflow or overflow. When paused, FIFO operations can be done without corrupting data that is
 *    in the process of being sent or received. Once a data pause has been requested, the interface
 *    may need to complete sending data that was in progress before interrupting the flow of data.
 *    Software must check that the pause is actually in effect before taking action. This is done by
 *    monitoring the DATAPAUSED flag in the STAT register. When DATAPAUSE is cleared, data transfer
 *    will resume at the beginning of the next frame.
 *  0b0..Normal operation, or resuming normal operation at the next frame if the I2S has already been paused.
 *  0b1..A pause in the data flow is being requested. It is in effect when DATAPAUSED in STAT = 1.
 */
#define I2S_CFG1_DATAPAUSE(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATAPAUSE_SHIFT)) & I2S_CFG1_DATAPAUSE_MASK)
#define I2S_CFG1_PAIRCOUNT_MASK (0xCU)
#define I2S_CFG1_PAIRCOUNT_SHIFT (2U)
/*! PAIRCOUNT - Provides the number of I2S channel pairs in this Flexcomm This is a read-only field
 *    whose value may be different in other Flexcomms. 00 = there is 1 I2S channel pair in this
 *    Flexcomm. 01 = there are 2 I2S channel pairs in this Flexcomm. 10 = there are 3 I2S channel pairs
 *    in this Flexcomm. 11 = there are 4 I2S channel pairs in this Flexcomm.
 *  0b00..1 I2S channel pairs in this flexcomm
 *  0b01..2 I2S channel pairs in this flexcomm
 *  0b10..3 I2S channel pairs in this flexcomm
 *  0b11..4 I2S channel pairs in this flexcomm
 */
#define I2S_CFG1_PAIRCOUNT(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PAIRCOUNT_SHIFT)) & I2S_CFG1_PAIRCOUNT_MASK)
#define I2S_CFG1_MSTSLVCFG_MASK (0x30U)
#define I2S_CFG1_MSTSLVCFG_SHIFT (4U)
/*! MSTSLVCFG - Master / slave configuration selection, determining how SCK and WS are used by all channel pairs in this
 * Flexcomm. 0b00..Normal slave mode, the default mode. SCK and WS are received from a master and used to transmit or
 * receive data. 0b01..WS synchronized master. WS is received from another master and used to synchronize the generation
 * of SCK, when divided from the Flexcomm function clock. 0b10..Master using an existing SCK. SCK is received and used
 * directly to generate WS, as well as transmitting or receiving data. 0b11..Normal master mode. SCK and WS are
 * generated so they can be sent to one or more slave devices.
 */
#define I2S_CFG1_MSTSLVCFG(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MSTSLVCFG_SHIFT)) & I2S_CFG1_MSTSLVCFG_MASK)
#define I2S_CFG1_MODE_MASK (0xC0U)
#define I2S_CFG1_MODE_SHIFT (6U)
/*! MODE - Selects the basic I2S operating mode. Other configurations modify this to obtain all
 *    supported cases. See Formats and modes for examples.
 *  0b00..I2S mode a.k.a. 'classic' mode. WS has a 50% duty cycle, with (for each enabled channel pair) one piece
 *        of left channel data occurring during the first phase, and one pieces of right channel data occurring
 *        during the second phase. In this mode, the data region begins one clock after the leading WS edge for the
 *        frame. For a 50% WS duty cycle, FRAMELEN must define an even number of I2S clocks for the frame. If
 *        FRAMELEN defines an odd number of clocks per frame, the extra clock will occur on the right.
 *  0b01..DSP mode where WS has a 50% duty cycle. See remark for mode 0.
 *  0b10..DSP mode where WS has a one clock long pulse at the beginning of each data frame.
 *  0b11..DSP mode where WS has a one data slot long pulse at the beginning of each data frame.
 */
#define I2S_CFG1_MODE(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MODE_SHIFT)) & I2S_CFG1_MODE_MASK)
#define I2S_CFG1_RIGHTLOW_MASK (0x100U)
#define I2S_CFG1_RIGHTLOW_SHIFT (8U)
/*! RIGHTLOW - Right channel data is in the Low portion of FIFO data. Essentially, this swaps left
 *    and right channel data as it is transferred to or from the FIFO. This bit is not used if the
 *    data width is greater than 24 bits or if PDMDATA = 1. Note that if the ONECHANNEL field (bit 10
 *    of this register) = 1, the one channel to be used is the nominally the left channel. POSITION
 *    can still place that data in the frame where right channel data is normally located. if all
 *    enabled channel pairs have ONECHANNEL = 1, then RIGHTLOW = 1 is not allowed.
 *  0b0..The right channel is taken from the high part of the FIFO data. For example, when data is 16 bits, FIFO
 *       bits 31:16 are used for the right channel.
 *  0b1..The right channel is taken from the low part of the FIFO data. For example, when data is 16 bits, FIFO
 *       bits 15:0 are used for the right channel.
 */
#define I2S_CFG1_RIGHTLOW(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_RIGHTLOW_SHIFT)) & I2S_CFG1_RIGHTLOW_MASK)
#define I2S_CFG1_LEFTJUST_MASK (0x200U)
#define I2S_CFG1_LEFTJUST_SHIFT (9U)
/*! LEFTJUST - Left Justify data.
 *  0b0..Data is transferred between the FIFO and the I2S serializer/deserializer right justified, i.e. starting
 *       from bit 0 and continuing to the position defined by DATALEN. This would correspond to right justified data
 *       in the stream on the data bus.
 *  0b1..Data is transferred between the FIFO and the I2S serializer/deserializer left justified, i.e. starting
 *       from the MSB of the FIFO entry and continuing for the number of bits defined by DATALEN. This would
 *       correspond to left justified data in the stream on the data bus.
 */
#define I2S_CFG1_LEFTJUST(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_LEFTJUST_SHIFT)) & I2S_CFG1_LEFTJUST_MASK)
#define I2S_CFG1_ONECHANNEL_MASK (0x400U)
#define I2S_CFG1_ONECHANNEL_SHIFT (10U)
/*! ONECHANNEL - Single channel mode. Applies to both transmit and receive. This configuration bit
 *    applies only to the first I2S channel pair. Other channel pairs may select this mode
 *    independently in their separate CFG1 registers.
 *  0b0..I2S data for this channel pair is treated as left and right channels.
 *  0b1..I2S data for this channel pair is treated as a single channel, functionally the left channel for this
 *       pair. In mode 0 only, the right side of the frame begins at POSITION = 0x100. This is because mode 0 makes a
 *       clear distinction between the left and right sides of the frame. When ONECHANNEL = 1, the single channel
 *       of data may be placed on the right by setting POSITION to 0x100 + the data position within the right side
 *       (e.g. 0x108 would place data starting at the 8th clock after the middle of the frame). In other modes, data
 *       for the single channel of data is placed at the clock defined by POSITION.
 */
#define I2S_CFG1_ONECHANNEL(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_ONECHANNEL_SHIFT)) & I2S_CFG1_ONECHANNEL_MASK)
#define I2S_CFG1_SCK_POL_MASK (0x1000U)
#define I2S_CFG1_SCK_POL_SHIFT (12U)
/*! SCK_POL - SCK polarity.
 *  0b0..Data is launched on SCK falling edges and sampled on SCK rising edges (standard for I2S).
 *  0b1..Data is launched on SCK rising edges and sampled on SCK falling edges.
 */
#define I2S_CFG1_SCK_POL(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_SCK_POL_SHIFT)) & I2S_CFG1_SCK_POL_MASK)
#define I2S_CFG1_WS_POL_MASK (0x2000U)
#define I2S_CFG1_WS_POL_SHIFT (13U)
/*! WS_POL - WS polarity.
 *  0b0..Data frames begin at a falling edge of WS (standard for classic I2S).
 *  0b1..WS is inverted, resulting in a data frame beginning at a rising edge of WS (standard for most 'non-classic'
 * variations of I2S).
 */
#define I2S_CFG1_WS_POL(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_WS_POL_SHIFT)) & I2S_CFG1_WS_POL_MASK)
#define I2S_CFG1_DATALEN_MASK (0x1F0000U)
#define I2S_CFG1_DATALEN_SHIFT (16U)
/*! DATALEN - Data Length, minus 1 encoded, defines the number of data bits to be transmitted or
 *    received for all I2S channel pairs in this Flexcomm. Note that data is only driven to or received
 *    from SDA for the number of bits defined by DATALEN. DATALEN is also used in these ways by the
 *    I2S: Determines the size of data transfers between the FIFO and the I2S
 *    serializer/deserializer. See FIFO buffer configurations and usage In mode 1, 2, and 3, determines the location of
 *    right data following left data in the frame. In mode 3 (where WS has a one data slot long pulse
 *    at the beginning of each data frame) determines the duration of the WS pulse. Values: 0x00 to
 *    0x02 = not supported 0x03 = data is 4 bits in length 0x04 = data is 5 bits in length 0x1F =
 *    data is 32 bits in length
 */
#define I2S_CFG1_DATALEN(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATALEN_SHIFT)) & I2S_CFG1_DATALEN_MASK)
/*! @} */

/*! @name CFG2 - Configuration register 2 for the primary channel pair. */
/*! @{ */
#define I2S_CFG2_FRAMELEN_MASK (0x1FFU)
#define I2S_CFG2_FRAMELEN_SHIFT (0U)
/*! FRAMELEN - Frame Length, minus 1 encoded, defines the number of clocks and data bits in the
 *    frames that this channel pair participates in. See Frame format. 0x000 to 0x002 = not supported
 *    0x003 = frame is 4 bits in total length 0x004 = frame is 5 bits in total length 0x1FF = frame is
 *    512 bits in total length if FRAMELEN is an defines an odd length frame (e.g. 33 clocks) in
 *    mode 0 or 1, the extra clock appears in the right half. When MODE = 3, FRAMELEN must be larger
 *    than DATALEN in order for the WS pulse to be generated correctly.
 */
#define I2S_CFG2_FRAMELEN(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_FRAMELEN_SHIFT)) & I2S_CFG2_FRAMELEN_MASK)
#define I2S_CFG2_POSITION_MASK (0x1FF0000U)
#define I2S_CFG2_POSITION_SHIFT (16U)
/*! POSITION - Data Position. Defines the location within the frame of the data for this channel
 *    pair. POSITION + DATALEN must be less than FRAMELEN. See Frame format. When MODE = 0, POSITION
 *    defines the location of data in both the left phase and right phase, starting one clock after
 *    the WS edge. In other modes, POSITION defines the location of data within the entire frame.
 *    ONECHANNEL = 1 while MODE = 0 is a special case, see the description of ONECHANNEL. The
 *    combination of DATALEN and the POSITION fields of all channel pairs must be made such that the channels
 *    do not overlap within the frame. 0x000 = data begins at bit position 0 (the first bit
 *    position) within the frame or WS phase. 0x001 = data begins at bit position 1 within the frame or WS
 *    phase. 0x002 = data begins at bit position 2 within the frame or WS phase.
 */
#define I2S_CFG2_POSITION(x) (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_POSITION_SHIFT)) & I2S_CFG2_POSITION_MASK)
/*! @} */

/*! @name STAT - Status register for the primary channel pair. */
/*! @{ */
#define I2S_STAT_BUSY_MASK (0x1U)
#define I2S_STAT_BUSY_SHIFT (0U)
/*! BUSY - Busy status for the primary channel pair. Other BUSY flags may be found in the STAT register for each channel
 * pair. 0b0..The transmitter/receiver for channel pair is currently idle. 0b1..The transmitter/receiver for channel
 * pair is currently processing data.
 */
#define I2S_STAT_BUSY(x) (((uint32_t)(((uint32_t)(x)) << I2S_STAT_BUSY_SHIFT)) & I2S_STAT_BUSY_MASK)
#define I2S_STAT_SLVFRMERR_MASK (0x2U)
#define I2S_STAT_SLVFRMERR_SHIFT (1U)
/*! SLVFRMERR - Slave Frame Error flag. This applies when at least one channel pair is operating as
 *    a slave. An error indicates that the incoming WS signal did not transition as expected due to
 *    a mismatch between FRAMELEN and the actual incoming I2S stream.
 *  0b0..No error has been recorded.
 *  0b1..An error has been recorded for some channel pair that is operating in slave mode. ERROR is cleared by writing a
 * 1 to this bit position.
 */
#define I2S_STAT_SLVFRMERR(x) (((uint32_t)(((uint32_t)(x)) << I2S_STAT_SLVFRMERR_SHIFT)) & I2S_STAT_SLVFRMERR_MASK)
#define I2S_STAT_LR_MASK (0x4U)
#define I2S_STAT_LR_SHIFT (2U)
/*! LR - Left/Right indication. This flag is considered to be a debugging aid and is not expected to
 *    be used by an I2S driver. Valid when one channel pair is busy. Indicates left or right data
 *    being processed for the currently busy channel pair.
 *  0b0..Left channel.
 *  0b1..Right channel.
 */
#define I2S_STAT_LR(x) (((uint32_t)(((uint32_t)(x)) << I2S_STAT_LR_SHIFT)) & I2S_STAT_LR_MASK)
#define I2S_STAT_DATAPAUSED_MASK (0x8U)
#define I2S_STAT_DATAPAUSED_SHIFT (3U)
/*! DATAPAUSED - Data Paused status flag. Applies to all I2S channels
 *  0b0..Data is not currently paused. A data pause may have been requested but is not yet in force, waiting for
 *       an allowed pause point. Refer to the description of the DATAPAUSE control bit in the CFG1 register.
 *  0b1..A data pause has been requested and is now in force.
 */
#define I2S_STAT_DATAPAUSED(x) (((uint32_t)(((uint32_t)(x)) << I2S_STAT_DATAPAUSED_SHIFT)) & I2S_STAT_DATAPAUSED_MASK)
/*! @} */

/*! @name DIV - Clock divider, used by all channel pairs. */
/*! @{ */
#define I2S_DIV_DIV_MASK (0xFFFU)
#define I2S_DIV_DIV_SHIFT (0U)
/*! DIV - This field controls how this I2S block uses the Flexcomm function clock. 0x000 = The
 *    Flexcomm function clock is used directly. 0x001 = The Flexcomm function clock is divided by 2.
 *    0x002 = The Flexcomm function clock is divided by 3. 0xFFF = The Flexcomm function clock is
 *    divided by 4,096.
 */
#define I2S_DIV_DIV(x) (((uint32_t)(((uint32_t)(x)) << I2S_DIV_DIV_SHIFT)) & I2S_DIV_DIV_MASK)
/*! @} */

/*! @name FIFOCFG - FIFO configuration and enable register. */
/*! @{ */
#define I2S_FIFOCFG_ENABLETX_MASK (0x1U)
#define I2S_FIFOCFG_ENABLETX_SHIFT (0U)
/*! ENABLETX - Enable the transmit FIFO.
 *  0b0..The transmit FIFO is not enabled.
 *  0b1..The transmit FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLETX(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLETX_SHIFT)) & I2S_FIFOCFG_ENABLETX_MASK)
#define I2S_FIFOCFG_ENABLERX_MASK (0x2U)
#define I2S_FIFOCFG_ENABLERX_SHIFT (1U)
/*! ENABLERX - Enable the receive FIFO.
 *  0b0..The receive FIFO is not enabled.
 *  0b1..The receive FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLERX(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLERX_SHIFT)) & I2S_FIFOCFG_ENABLERX_MASK)
#define I2S_FIFOCFG_TXI2SE0_MASK (0x4U)
#define I2S_FIFOCFG_TXI2SE0_SHIFT (2U)
/*! TXI2SE0 - Transmit I2S empty 0. Determines the value sent by the I2S in transmit mode if the TX
 *    FIFO becomes empty. This value is sent repeatedly until the I2S is paused, the error is
 *    cleared, new data is provided, and the I2S is un-paused.
 *  0b0..If the TX FIFO becomes empty, the last value is sent. This setting may be used when the data length is 24
 *       bits or less, or when MONO = 1 for this channel pair.
 *  0b1..If the TX FIFO becomes empty, 0 is sent. Use if the data length is greater than 24 bits or if zero fill is
 * preferred.
 */
#define I2S_FIFOCFG_TXI2SE0(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_TXI2SE0_SHIFT)) & I2S_FIFOCFG_TXI2SE0_MASK)
#define I2S_FIFOCFG_PACK48_MASK (0x8U)
#define I2S_FIFOCFG_PACK48_SHIFT (3U)
/*! PACK48 - Packing format for 48-bit data. This relates to how data is entered into or taken from the FIFO by software
 * or DMA. 0b0..48-bit I2S FIFO entries are handled as all 24-bit values. 0b1..48-bit I2S FIFO entries are handled as
 * alternating 32-bit and 16-bit values.
 */
#define I2S_FIFOCFG_PACK48(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_PACK48_SHIFT)) & I2S_FIFOCFG_PACK48_MASK)
#define I2S_FIFOCFG_SIZE_MASK (0x30U)
#define I2S_FIFOCFG_SIZE_SHIFT (4U)
/*! SIZE - FIFO size configuration. This is a read-only field. 0x0 = FIFO is configured as 16
 *    entries of 8 bits. 0x1, 0x2, 0x3 = not applicable to USART.
 */
#define I2S_FIFOCFG_SIZE(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_SIZE_SHIFT)) & I2S_FIFOCFG_SIZE_MASK)
#define I2S_FIFOCFG_DMATX_MASK (0x1000U)
#define I2S_FIFOCFG_DMATX_SHIFT (12U)
/*! DMATX - DMA configuration for transmit.
 *  0b0..DMA is not used for the transmit function.
 *  0b1..Trigger DMA for the transmit function if the FIFO is not full. Generally, data interrupts would be disabled if
 * DMA is enabled.
 */
#define I2S_FIFOCFG_DMATX(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMATX_SHIFT)) & I2S_FIFOCFG_DMATX_MASK)
#define I2S_FIFOCFG_DMARX_MASK (0x2000U)
#define I2S_FIFOCFG_DMARX_SHIFT (13U)
/*! DMARX - DMA configuration for receive.
 *  0b0..DMA is not used for the receive function.
 *  0b1..Trigger DMA for the receive function if the FIFO is not empty. Generally, data interrupts would be disabled if
 * DMA is enabled.
 */
#define I2S_FIFOCFG_DMARX(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMARX_SHIFT)) & I2S_FIFOCFG_DMARX_MASK)
#define I2S_FIFOCFG_WAKETX_MASK (0x4000U)
#define I2S_FIFOCFG_WAKETX_SHIFT (14U)
/*! WAKETX - Wake-up for transmit FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the transmit FIFO level reaches the value specified by TXLVL in
 *       FIFOTRIG, even when the TXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKETX(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKETX_SHIFT)) & I2S_FIFOCFG_WAKETX_MASK)
#define I2S_FIFOCFG_WAKERX_MASK (0x8000U)
#define I2S_FIFOCFG_WAKERX_SHIFT (15U)
/*! WAKERX - Wake-up for receive FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the receive FIFO level reaches the value specified by RXLVL in
 *       FIFOTRIG, even when the RXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKERX(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKERX_SHIFT)) & I2S_FIFOCFG_WAKERX_MASK)
#define I2S_FIFOCFG_EMPTYTX_MASK (0x10000U)
#define I2S_FIFOCFG_EMPTYTX_SHIFT (16U)
/*! EMPTYTX - Empty command for the transmit FIFO. When a 1 is written to this bit, the TX FIFO is emptied.
 */
#define I2S_FIFOCFG_EMPTYTX(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYTX_SHIFT)) & I2S_FIFOCFG_EMPTYTX_MASK)
#define I2S_FIFOCFG_EMPTYRX_MASK (0x20000U)
#define I2S_FIFOCFG_EMPTYRX_SHIFT (17U)
/*! EMPTYRX - Empty command for the receive FIFO. When a 1 is written to this bit, the RX FIFO is emptied.
 */
#define I2S_FIFOCFG_EMPTYRX(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYRX_SHIFT)) & I2S_FIFOCFG_EMPTYRX_MASK)
/*! @} */

/*! @name FIFOSTAT - FIFO status register. */
/*! @{ */
#define I2S_FIFOSTAT_TXERR_MASK (0x1U)
#define I2S_FIFOSTAT_TXERR_SHIFT (0U)
/*! TXERR - TX FIFO error. Will be set if a transmit FIFO error occurs. This could be an overflow
 *    caused by pushing data into a full FIFO, or by an underflow if the FIFO is empty when data is
 *    needed. Cleared by writing a 1 to this bit.
 */
#define I2S_FIFOSTAT_TXERR(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXERR_SHIFT)) & I2S_FIFOSTAT_TXERR_MASK)
#define I2S_FIFOSTAT_RXERR_MASK (0x2U)
#define I2S_FIFOSTAT_RXERR_SHIFT (1U)
/*! RXERR - RX FIFO error. Will be set if a receive FIFO overflow occurs, caused by software or DMA
 *    not emptying the FIFO fast enough. Cleared by writing a 1 to this bit.
 */
#define I2S_FIFOSTAT_RXERR(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXERR_SHIFT)) & I2S_FIFOSTAT_RXERR_MASK)
#define I2S_FIFOSTAT_PERINT_MASK (0x8U)
#define I2S_FIFOSTAT_PERINT_SHIFT (3U)
/*! PERINT - Peripheral interrupt. When 1, this indicates that the peripheral function has asserted
 *    an interrupt. The details can be found by reading the peripheral's STAT register.
 */
#define I2S_FIFOSTAT_PERINT(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_PERINT_SHIFT)) & I2S_FIFOSTAT_PERINT_MASK)
#define I2S_FIFOSTAT_TXEMPTY_MASK (0x10U)
#define I2S_FIFOSTAT_TXEMPTY_SHIFT (4U)
/*! TXEMPTY - Transmit FIFO empty. When 1, the transmit FIFO is empty. The peripheral may still be processing the last
 * piece of data.
 */
#define I2S_FIFOSTAT_TXEMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXEMPTY_SHIFT)) & I2S_FIFOSTAT_TXEMPTY_MASK)
#define I2S_FIFOSTAT_TXNOTFULL_MASK (0x20U)
#define I2S_FIFOSTAT_TXNOTFULL_SHIFT (5U)
/*! TXNOTFULL - Transmit FIFO not full. When 1, the transmit FIFO is not full, so more data can be
 *    written. When 0, the transmit FIFO is full and another write would cause it to overflow.
 */
#define I2S_FIFOSTAT_TXNOTFULL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXNOTFULL_SHIFT)) & I2S_FIFOSTAT_TXNOTFULL_MASK)
#define I2S_FIFOSTAT_RXNOTEMPTY_MASK (0x40U)
#define I2S_FIFOSTAT_RXNOTEMPTY_SHIFT (6U)
/*! RXNOTEMPTY - Receive FIFO not empty. When 1, the receive FIFO is not empty, so data can be read. When 0, the receive
 * FIFO is empty.
 */
#define I2S_FIFOSTAT_RXNOTEMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXNOTEMPTY_SHIFT)) & I2S_FIFOSTAT_RXNOTEMPTY_MASK)
#define I2S_FIFOSTAT_RXFULL_MASK (0x80U)
#define I2S_FIFOSTAT_RXFULL_SHIFT (7U)
/*! RXFULL - Receive FIFO full. When 1, the receive FIFO is full. Data needs to be read out to
 *    prevent the peripheral from causing an overflow.
 */
#define I2S_FIFOSTAT_RXFULL(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXFULL_SHIFT)) & I2S_FIFOSTAT_RXFULL_MASK)
#define I2S_FIFOSTAT_TXLVL_MASK (0x1F00U)
#define I2S_FIFOSTAT_TXLVL_SHIFT (8U)
/*! TXLVL - Transmit FIFO current level. A 0 means the TX FIFO is currently empty, and the TXEMPTY
 *    and TXNOTFULL flags will be 1. Other values tell how much data is actually in the TX FIFO at
 *    the point where the read occurs. If the TX FIFO is full, the TXEMPTY and TXNOTFULL flags will be
 *    0.
 */
#define I2S_FIFOSTAT_TXLVL(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXLVL_SHIFT)) & I2S_FIFOSTAT_TXLVL_MASK)
#define I2S_FIFOSTAT_RXLVL_MASK (0x1F0000U)
#define I2S_FIFOSTAT_RXLVL_SHIFT (16U)
/*! RXLVL - Receive FIFO current level. A 0 means the RX FIFO is currently empty, and the RXFULL and
 *    RXNOTEMPTY flags will be 0. Other values tell how much data is actually in the RX FIFO at the
 *    point where the read occurs. If the RX FIFO is full, the RXFULL and RXNOTEMPTY flags will be
 *    1.
 */
#define I2S_FIFOSTAT_RXLVL(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXLVL_SHIFT)) & I2S_FIFOSTAT_RXLVL_MASK)
/*! @} */

/*! @name FIFOTRIG - FIFO trigger settings for interrupt and DMA request. */
/*! @{ */
#define I2S_FIFOTRIG_TXLVLENA_MASK (0x1U)
#define I2S_FIFOTRIG_TXLVLENA_SHIFT (0U)
/*! TXLVLENA - Transmit FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMATX in FIFOCFG is set.
 *  0b0..Transmit FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the transmit FIFO level reaches the value specified by the TXLVL field in this
 * register.
 */
#define I2S_FIFOTRIG_TXLVLENA(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVLENA_SHIFT)) & I2S_FIFOTRIG_TXLVLENA_MASK)
#define I2S_FIFOTRIG_RXLVLENA_MASK (0x2U)
#define I2S_FIFOTRIG_RXLVLENA_SHIFT (1U)
/*! RXLVLENA - Receive FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMARX in FIFOCFG is set.
 *  0b0..Receive FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the receive FIFO level reaches the value specified by the RXLVL field in this
 * register.
 */
#define I2S_FIFOTRIG_RXLVLENA(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVLENA_SHIFT)) & I2S_FIFOTRIG_RXLVLENA_MASK)
#define I2S_FIFOTRIG_TXLVL_MASK (0xF00U)
#define I2S_FIFOTRIG_TXLVL_SHIFT (8U)
/*! TXLVL - Transmit FIFO level trigger point. This field is used only when TXLVLENA = 1. If enabled
 *    to do so, the FIFO level can wake up the device just enough to perform DMA, then return to
 *    the reduced power mode. See Hardware Wake-up control register. 0 = trigger when the TX FIFO
 *    becomes empty. 1 = trigger when the TX FIFO level decreases to one entry. 15 = trigger when the TX
 *    FIFO level decreases to 15 entries (is no longer full).
 */
#define I2S_FIFOTRIG_TXLVL(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVL_SHIFT)) & I2S_FIFOTRIG_TXLVL_MASK)
#define I2S_FIFOTRIG_RXLVL_MASK (0xF0000U)
#define I2S_FIFOTRIG_RXLVL_SHIFT (16U)
/*! RXLVL - Receive FIFO level trigger point. The RX FIFO level is checked when a new piece of data
 *    is received. This field is used only when RXLVLENA = 1. If enabled to do so, the FIFO level
 *    can wake up the device just enough to perform DMA, then return to the reduced power mode. See
 *    Hardware Wake-up control register. 0 = trigger when the RX FIFO has received one entry (is no
 *    longer empty). 1 = trigger when the RX FIFO has received two entries. 15 = trigger when the RX
 *    FIFO has received 16 entries (has become full).
 */
#define I2S_FIFOTRIG_RXLVL(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVL_SHIFT)) & I2S_FIFOTRIG_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENSET - FIFO interrupt enable set (enable) and read register. */
/*! @{ */
#define I2S_FIFOINTENSET_TXERR_MASK (0x1U)
#define I2S_FIFOINTENSET_TXERR_SHIFT (0U)
/*! TXERR - Determines whether an interrupt occurs when a transmit error occurs, based on the TXERR flag in the FIFOSTAT
 * register. 0b0..No interrupt will be generated for a transmit error. 0b1..An interrupt will be generated when a
 * transmit error occurs.
 */
#define I2S_FIFOINTENSET_TXERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXERR_SHIFT)) & I2S_FIFOINTENSET_TXERR_MASK)
#define I2S_FIFOINTENSET_RXERR_MASK (0x2U)
#define I2S_FIFOINTENSET_RXERR_SHIFT (1U)
/*! RXERR - Determines whether an interrupt occurs when a receive error occurs, based on the RXERR flag in the FIFOSTAT
 * register. 0b0..No interrupt will be generated for a receive error. 0b1..An interrupt will be generated when a receive
 * error occurs.
 */
#define I2S_FIFOINTENSET_RXERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXERR_SHIFT)) & I2S_FIFOINTENSET_RXERR_MASK)
#define I2S_FIFOINTENSET_TXLVL_MASK (0x4U)
#define I2S_FIFOINTENSET_TXLVL_SHIFT (2U)
/*! TXLVL - Determines whether an interrupt occurs when a the transmit FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the TX FIFO level.
 *  0b1..If TXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the TX FIFO level decreases
 *       to the level specified by TXLVL in the FIFOTRIG register.
 */
#define I2S_FIFOINTENSET_TXLVL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXLVL_SHIFT)) & I2S_FIFOINTENSET_TXLVL_MASK)
#define I2S_FIFOINTENSET_RXLVL_MASK (0x8U)
#define I2S_FIFOINTENSET_RXLVL_SHIFT (3U)
/*! RXLVL - Determines whether an interrupt occurs when a the receive FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the RX FIFO level.
 *  0b1..If RXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the when the RX FIFO level
 *       increases to the level specified by RXLVL in the FIFOTRIG register.
 */
#define I2S_FIFOINTENSET_RXLVL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXLVL_SHIFT)) & I2S_FIFOINTENSET_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENCLR - FIFO interrupt enable clear (disable) and read register. */
/*! @{ */
#define I2S_FIFOINTENCLR_TXERR_MASK (0x1U)
#define I2S_FIFOINTENCLR_TXERR_SHIFT (0U)
/*! TXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_TXERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXERR_SHIFT)) & I2S_FIFOINTENCLR_TXERR_MASK)
#define I2S_FIFOINTENCLR_RXERR_MASK (0x2U)
#define I2S_FIFOINTENCLR_RXERR_SHIFT (1U)
/*! RXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_RXERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXERR_SHIFT)) & I2S_FIFOINTENCLR_RXERR_MASK)
#define I2S_FIFOINTENCLR_TXLVL_MASK (0x4U)
#define I2S_FIFOINTENCLR_TXLVL_SHIFT (2U)
/*! TXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_TXLVL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXLVL_SHIFT)) & I2S_FIFOINTENCLR_TXLVL_MASK)
#define I2S_FIFOINTENCLR_RXLVL_MASK (0x8U)
#define I2S_FIFOINTENCLR_RXLVL_SHIFT (3U)
/*! RXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_RXLVL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXLVL_SHIFT)) & I2S_FIFOINTENCLR_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTSTAT - FIFO interrupt status register. */
/*! @{ */
#define I2S_FIFOINTSTAT_TXERR_MASK (0x1U)
#define I2S_FIFOINTSTAT_TXERR_SHIFT (0U)
/*! TXERR - TX FIFO error.
 */
#define I2S_FIFOINTSTAT_TXERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXERR_SHIFT)) & I2S_FIFOINTSTAT_TXERR_MASK)
#define I2S_FIFOINTSTAT_RXERR_MASK (0x2U)
#define I2S_FIFOINTSTAT_RXERR_SHIFT (1U)
/*! RXERR - RX FIFO error.
 */
#define I2S_FIFOINTSTAT_RXERR(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXERR_SHIFT)) & I2S_FIFOINTSTAT_RXERR_MASK)
#define I2S_FIFOINTSTAT_TXLVL_MASK (0x4U)
#define I2S_FIFOINTSTAT_TXLVL_SHIFT (2U)
/*! TXLVL - Transmit FIFO level interrupt.
 */
#define I2S_FIFOINTSTAT_TXLVL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXLVL_SHIFT)) & I2S_FIFOINTSTAT_TXLVL_MASK)
#define I2S_FIFOINTSTAT_RXLVL_MASK (0x8U)
#define I2S_FIFOINTSTAT_RXLVL_SHIFT (3U)
/*! RXLVL - Receive FIFO level interrupt.
 */
#define I2S_FIFOINTSTAT_RXLVL(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXLVL_SHIFT)) & I2S_FIFOINTSTAT_RXLVL_MASK)
#define I2S_FIFOINTSTAT_PERINT_MASK (0x10U)
#define I2S_FIFOINTSTAT_PERINT_SHIFT (4U)
/*! PERINT - Peripheral interrupt.
 */
#define I2S_FIFOINTSTAT_PERINT(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_PERINT_SHIFT)) & I2S_FIFOINTSTAT_PERINT_MASK)
/*! @} */

/*! @name FIFOWR - FIFO write data. */
/*! @{ */
#define I2S_FIFOWR_TXDATA_MASK (0xFFFFFFFFU)
#define I2S_FIFOWR_TXDATA_SHIFT (0U)
/*! TXDATA - Transmit data to the FIFO. The number of bits used depends on configuration details.
 */
#define I2S_FIFOWR_TXDATA(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR_TXDATA_SHIFT)) & I2S_FIFOWR_TXDATA_MASK)
/*! @} */

/*! @name FIFOWR48H - FIFO write data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data
 * and not using DMA. */
/*! @{ */
#define I2S_FIFOWR48H_TXDATA_MASK (0xFFFFFFU)
#define I2S_FIFOWR48H_TXDATA_SHIFT (0U)
/*! TXDATA - Transmit data to the FIFO. Whether this register is used and the number of bits used depends on
 * configuration details.
 */
#define I2S_FIFOWR48H_TXDATA(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR48H_TXDATA_SHIFT)) & I2S_FIFOWR48H_TXDATA_MASK)
/*! @} */

/*! @name FIFORD - FIFO read data. */
/*! @{ */
#define I2S_FIFORD_RXDATA_MASK (0xFFFFFFFFU)
#define I2S_FIFORD_RXDATA_SHIFT (0U)
/*! RXDATA - Received data from the FIFO. The number of bits used depends on configuration details.
 */
#define I2S_FIFORD_RXDATA(x) (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD_RXDATA_SHIFT)) & I2S_FIFORD_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48H - FIFO read data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data
 * and not using DMA. */
/*! @{ */
#define I2S_FIFORD48H_RXDATA_MASK (0xFFFFFFU)
#define I2S_FIFORD48H_RXDATA_SHIFT (0U)
/*! RXDATA - Received data from the FIFO. Whether this register is used and the number of bits used depends on
 * configuration details.
 */
#define I2S_FIFORD48H_RXDATA(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48H_RXDATA_SHIFT)) & I2S_FIFORD48H_RXDATA_MASK)
/*! @} */

/*! @name FIFORDNOPOP - FIFO data read with no FIFO pop. */
/*! @{ */
#define I2S_FIFORDNOPOP_RXDATA_MASK (0xFFFFFFFFU)
#define I2S_FIFORDNOPOP_RXDATA_SHIFT (0U)
/*! RXDATA - Received data from the FIFO.
 */
#define I2S_FIFORDNOPOP_RXDATA(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFORDNOPOP_RXDATA_SHIFT)) & I2S_FIFORDNOPOP_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48HNOPOP - FIFO data read for upper data bits with no FIFO pop. May only be used if the I2S is
 * configured for 2x 24-bit data and not using DMA. */
/*! @{ */
#define I2S_FIFORD48HNOPOP_RXDATA_MASK (0xFFFFFFU)
#define I2S_FIFORD48HNOPOP_RXDATA_SHIFT (0U)
/*! RXDATA - Received data from the FIFO. Whether this register is used and the number of bits used depends on
 * configuration details.
 */
#define I2S_FIFORD48HNOPOP_RXDATA(x) \
    (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48HNOPOP_RXDATA_SHIFT)) & I2S_FIFORD48HNOPOP_RXDATA_MASK)
/*! @} */

/*! @name ID - I2S Module identification */
/*! @{ */
#define I2S_ID_APERTURE_MASK (0xFFU)
#define I2S_ID_APERTURE_SHIFT (0U)
/*! APERTURE - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define I2S_ID_APERTURE(x) (((uint32_t)(((uint32_t)(x)) << I2S_ID_APERTURE_SHIFT)) & I2S_ID_APERTURE_MASK)
#define I2S_ID_MINOR_REV_MASK (0xF00U)
#define I2S_ID_MINOR_REV_SHIFT (8U)
/*! MINOR_REV - Minor revision of module implementation, starting at 0.
 */
#define I2S_ID_MINOR_REV(x) (((uint32_t)(((uint32_t)(x)) << I2S_ID_MINOR_REV_SHIFT)) & I2S_ID_MINOR_REV_MASK)
#define I2S_ID_MAJOR_REV_MASK (0xF000U)
#define I2S_ID_MAJOR_REV_SHIFT (12U)
/*! MAJOR_REV - Major revision of module implementation, starting at 0.
 */
#define I2S_ID_MAJOR_REV(x) (((uint32_t)(((uint32_t)(x)) << I2S_ID_MAJOR_REV_SHIFT)) & I2S_ID_MAJOR_REV_MASK)
#define I2S_ID_ID_MASK (0xFFFF0000U)
#define I2S_ID_ID_SHIFT (16U)
/*! ID - Unique module identifier for this IP block.
 */
#define I2S_ID_ID(x) (((uint32_t)(((uint32_t)(x)) << I2S_ID_ID_SHIFT)) & I2S_ID_ID_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group I2S_Register_Masks */

/* I2S - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral I2S0 base address */
#define I2S0_BASE (0x50086000u)
/** Peripheral I2S0 base address */
#define I2S0_BASE_NS (0x40086000u)
/** Peripheral I2S0 base pointer */
#define I2S0 ((I2S_Type *)I2S0_BASE)
/** Peripheral I2S0 base pointer */
#define I2S0_NS ((I2S_Type *)I2S0_BASE_NS)
/** Peripheral I2S1 base address */
#define I2S1_BASE (0x50087000u)
/** Peripheral I2S1 base address */
#define I2S1_BASE_NS (0x40087000u)
/** Peripheral I2S1 base pointer */
#define I2S1 ((I2S_Type *)I2S1_BASE)
/** Peripheral I2S1 base pointer */
#define I2S1_NS ((I2S_Type *)I2S1_BASE_NS)
/** Peripheral I2S2 base address */
#define I2S2_BASE (0x50088000u)
/** Peripheral I2S2 base address */
#define I2S2_BASE_NS (0x40088000u)
/** Peripheral I2S2 base pointer */
#define I2S2 ((I2S_Type *)I2S2_BASE)
/** Peripheral I2S2 base pointer */
#define I2S2_NS ((I2S_Type *)I2S2_BASE_NS)
/** Peripheral I2S3 base address */
#define I2S3_BASE (0x50089000u)
/** Peripheral I2S3 base address */
#define I2S3_BASE_NS (0x40089000u)
/** Peripheral I2S3 base pointer */
#define I2S3 ((I2S_Type *)I2S3_BASE)
/** Peripheral I2S3 base pointer */
#define I2S3_NS ((I2S_Type *)I2S3_BASE_NS)
/** Peripheral I2S4 base address */
#define I2S4_BASE (0x5008A000u)
/** Peripheral I2S4 base address */
#define I2S4_BASE_NS (0x4008A000u)
/** Peripheral I2S4 base pointer */
#define I2S4 ((I2S_Type *)I2S4_BASE)
/** Peripheral I2S4 base pointer */
#define I2S4_NS ((I2S_Type *)I2S4_BASE_NS)
/** Peripheral I2S5 base address */
#define I2S5_BASE (0x50096000u)
/** Peripheral I2S5 base address */
#define I2S5_BASE_NS (0x40096000u)
/** Peripheral I2S5 base pointer */
#define I2S5 ((I2S_Type *)I2S5_BASE)
/** Peripheral I2S5 base pointer */
#define I2S5_NS ((I2S_Type *)I2S5_BASE_NS)
/** Peripheral I2S6 base address */
#define I2S6_BASE (0x50097000u)
/** Peripheral I2S6 base address */
#define I2S6_BASE_NS (0x40097000u)
/** Peripheral I2S6 base pointer */
#define I2S6 ((I2S_Type *)I2S6_BASE)
/** Peripheral I2S6 base pointer */
#define I2S6_NS ((I2S_Type *)I2S6_BASE_NS)
/** Peripheral I2S7 base address */
#define I2S7_BASE (0x50098000u)
/** Peripheral I2S7 base address */
#define I2S7_BASE_NS (0x40098000u)
/** Peripheral I2S7 base pointer */
#define I2S7 ((I2S_Type *)I2S7_BASE)
/** Peripheral I2S7 base pointer */
#define I2S7_NS ((I2S_Type *)I2S7_BASE_NS)
/** Array initializer of I2S peripheral base addresses */
#define I2S_BASE_ADDRS                                                                         \
    {                                                                                          \
        I2S0_BASE, I2S1_BASE, I2S2_BASE, I2S3_BASE, I2S4_BASE, I2S5_BASE, I2S6_BASE, I2S7_BASE \
    }
/** Array initializer of I2S peripheral base pointers */
#define I2S_BASE_PTRS                                  \
    {                                                  \
        I2S0, I2S1, I2S2, I2S3, I2S4, I2S5, I2S6, I2S7 \
    }
/** Array initializer of I2S peripheral base addresses */
#define I2S_BASE_ADDRS_NS                                                                                              \
    {                                                                                                                  \
        I2S0_BASE_NS, I2S1_BASE_NS, I2S2_BASE_NS, I2S3_BASE_NS, I2S4_BASE_NS, I2S5_BASE_NS, I2S6_BASE_NS, I2S7_BASE_NS \
    }
/** Array initializer of I2S peripheral base pointers */
#define I2S_BASE_PTRS_NS                                                       \
    {                                                                          \
        I2S0_NS, I2S1_NS, I2S2_NS, I2S3_NS, I2S4_NS, I2S5_NS, I2S6_NS, I2S7_NS \
    }
#else
/** Peripheral I2S0 base address */
#define I2S0_BASE (0x40086000u)
/** Peripheral I2S0 base pointer */
#define I2S0 ((I2S_Type *)I2S0_BASE)
/** Peripheral I2S1 base address */
#define I2S1_BASE (0x40087000u)
/** Peripheral I2S1 base pointer */
#define I2S1 ((I2S_Type *)I2S1_BASE)
/** Peripheral I2S2 base address */
#define I2S2_BASE (0x40088000u)
/** Peripheral I2S2 base pointer */
#define I2S2 ((I2S_Type *)I2S2_BASE)
/** Peripheral I2S3 base address */
#define I2S3_BASE (0x40089000u)
/** Peripheral I2S3 base pointer */
#define I2S3 ((I2S_Type *)I2S3_BASE)
/** Peripheral I2S4 base address */
#define I2S4_BASE (0x4008A000u)
/** Peripheral I2S4 base pointer */
#define I2S4 ((I2S_Type *)I2S4_BASE)
/** Peripheral I2S5 base address */
#define I2S5_BASE (0x40096000u)
/** Peripheral I2S5 base pointer */
#define I2S5 ((I2S_Type *)I2S5_BASE)
/** Peripheral I2S6 base address */
#define I2S6_BASE (0x40097000u)
/** Peripheral I2S6 base pointer */
#define I2S6 ((I2S_Type *)I2S6_BASE)
/** Peripheral I2S7 base address */
#define I2S7_BASE (0x40098000u)
/** Peripheral I2S7 base pointer */
#define I2S7 ((I2S_Type *)I2S7_BASE)
/** Array initializer of I2S peripheral base addresses */
#define I2S_BASE_ADDRS                                                                         \
    {                                                                                          \
        I2S0_BASE, I2S1_BASE, I2S2_BASE, I2S3_BASE, I2S4_BASE, I2S5_BASE, I2S6_BASE, I2S7_BASE \
    }
/** Array initializer of I2S peripheral base pointers */
#define I2S_BASE_PTRS                                  \
    {                                                  \
        I2S0, I2S1, I2S2, I2S3, I2S4, I2S5, I2S6, I2S7 \
    }
#endif
/** Interrupt vectors for the I2S peripheral type */
#define I2S_IRQS                                                                                        \
    {                                                                                                   \
        FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, \
            FLEXCOMM6_IRQn, FLEXCOMM7_IRQn                                                              \
    }

/*!
 * @}
 */ /* end of group I2S_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- INPUTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Peripheral_Access_Layer INPUTMUX Peripheral Access Layer
 * @{
 */

/** INPUTMUX - Register Layout Typedef */
typedef struct
{
    __IO uint32_t SCT0_INMUX[7]; /**< Input mux register for SCT0 input, array offset: 0x0, array step: 0x4 */
    uint8_t RESERVED_0[4];
    __IO uint32_t
        TIMER0CAPTSEL[4]; /**< Capture select registers for TIMER0 inputs, array offset: 0x20, array step: 0x4 */
    uint8_t RESERVED_1[16];
    __IO uint32_t
        TIMER1CAPTSEL[4]; /**< Capture select registers for TIMER1 inputs, array offset: 0x40, array step: 0x4 */
    uint8_t RESERVED_2[16];
    __IO uint32_t
        TIMER2CAPTSEL[4]; /**< Capture select registers for TIMER2 inputs, array offset: 0x60, array step: 0x4 */
    uint8_t RESERVED_3[80];
    __IO uint32_t PINTSEL[8]; /**< Pin interrupt select register, array offset: 0xC0, array step: 0x4 */
    __IO uint32_t
        DMA0_ITRIG_INMUX[23]; /**< Trigger select register for DMA0 channel, array offset: 0xE0, array step: 0x4 */
    uint8_t RESERVED_4[36];
    __IO uint32_t DMA0_OTRIG_INMUX[4]; /**< DMA0 output trigger selection to become DMA0 trigger, array offset: 0x160,
                                          array step: 0x4 */
    uint8_t RESERVED_5[16];
    __IO uint32_t FREQMEAS_REF;    /**< Selection for frequency measurement reference clock, offset: 0x180 */
    __IO uint32_t FREQMEAS_TARGET; /**< Selection for frequency measurement target clock, offset: 0x184 */
    uint8_t RESERVED_6[24];
    __IO uint32_t
        TIMER3CAPTSEL[4]; /**< Capture select registers for TIMER3 inputs, array offset: 0x1A0, array step: 0x4 */
    uint8_t RESERVED_7[16];
    __IO uint32_t
        TIMER4CAPTSEL[4]; /**< Capture select registers for TIMER4 inputs, array offset: 0x1C0, array step: 0x4 */
    uint8_t RESERVED_8[16];
    __IO uint32_t PINTSECSEL[2]; /**< Pin interrupt secure select register, array offset: 0x1E0, array step: 0x4 */
    uint8_t RESERVED_9[24];
    __IO uint32_t
        DMA1_ITRIG_INMUX[10]; /**< Trigger select register for DMA1 channel, array offset: 0x200, array step: 0x4 */
    uint8_t RESERVED_10[24];
    __IO uint32_t DMA1_OTRIG_INMUX[4]; /**< DMA1 output trigger selection to become DMA1 trigger, array offset: 0x240,
                                          array step: 0x4 */
    uint8_t RESERVED_11[1264];
    __IO uint32_t DMA0_REQ_ENA; /**< Enable DMA0 requests, offset: 0x740 */
    uint8_t RESERVED_12[4];
    __O uint32_t DMA0_REQ_ENA_SET; /**< Set one or several bits in DMA0_REQ_ENA register, offset: 0x748 */
    uint8_t RESERVED_13[4];
    __O uint32_t DMA0_REQ_ENA_CLR; /**< Clear one or several bits in DMA0_REQ_ENA register, offset: 0x750 */
    uint8_t RESERVED_14[12];
    __IO uint32_t DMA1_REQ_ENA; /**< Enable DMA1 requests, offset: 0x760 */
    uint8_t RESERVED_15[4];
    __O uint32_t DMA1_REQ_ENA_SET; /**< Set one or several bits in DMA1_REQ_ENA register, offset: 0x768 */
    uint8_t RESERVED_16[4];
    __O uint32_t DMA1_REQ_ENA_CLR; /**< Clear one or several bits in DMA1_REQ_ENA register, offset: 0x770 */
    uint8_t RESERVED_17[12];
    __IO uint32_t DMA0_ITRIG_ENA; /**< Enable DMA0 triggers, offset: 0x780 */
    uint8_t RESERVED_18[4];
    __O uint32_t DMA0_ITRIG_ENA_SET; /**< Set one or several bits in DMA0_ITRIG_ENA register, offset: 0x788 */
    uint8_t RESERVED_19[4];
    __O uint32_t DMA0_ITRIG_ENA_CLR; /**< Clear one or several bits in DMA0_ITRIG_ENA register, offset: 0x790 */
    uint8_t RESERVED_20[12];
    __IO uint32_t DMA1_ITRIG_ENA; /**< Enable DMA1 triggers, offset: 0x7A0 */
    uint8_t RESERVED_21[4];
    __O uint32_t DMA1_ITRIG_ENA_SET; /**< Set one or several bits in DMA1_ITRIG_ENA register, offset: 0x7A8 */
    uint8_t RESERVED_22[4];
    __O uint32_t DMA1_ITRIG_ENA_CLR; /**< Clear one or several bits in DMA1_ITRIG_ENA register, offset: 0x7B0 */
} INPUTMUX_Type;

/* ----------------------------------------------------------------------------
   -- INPUTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Register_Masks INPUTMUX Register Masks
 * @{
 */

/*! @name SCT0_INMUX - Input mux register for SCT0 input */
/*! @{ */
#define INPUTMUX_SCT0_INMUX_INP_N_MASK (0x1FU)
#define INPUTMUX_SCT0_INMUX_INP_N_SHIFT (0U)
/*! INP_N - Input number to SCT0 inputs 0 to 6..
 *  0b00000..SCT_GPI0 function selected from IOCON register
 *  0b00001..SCT_GPI1 function selected from IOCON register
 *  0b00010..SCT_GPI2 function selected from IOCON register
 *  0b00011..SCT_GPI3 function selected from IOCON register
 *  0b00100..SCT_GPI4 function selected from IOCON register
 *  0b00101..SCT_GPI5 function selected from IOCON register
 *  0b00110..SCT_GPI6 function selected from IOCON register
 *  0b00111..SCT_GPI7 function selected from IOCON register
 *  0b01000..T0_OUT0 ctimer 0 match[0] output
 *  0b01001..T1_OUT0 ctimer 1 match[0] output
 *  0b01010..T2_OUT0 ctimer 2 match[0] output
 *  0b01011..T3_OUT0 ctimer 3 match[0] output
 *  0b01100..T4_OUT0 ctimer 4 match[0] output
 *  0b01101..ADC_IRQ interrupt request from ADC
 *  0b01110..GPIOINT_BMATCH
 *  0b01111..USB0_FRAME_TOGGLE
 *  0b10000..USB1_FRAME_TOGGLE
 *  0b10001..COMP_OUTPUT output from analog comparator
 *  0b10010..I2S_SHARED_SCK[0] output from I2S pin sharing
 *  0b10011..I2S_SHARED_SCK[1] output from I2S pin sharing
 *  0b10100..I2S_SHARED_WS[0] output from I2S pin sharing
 *  0b10101..I2S_SHARED_WS[1] output from I2S pin sharing
 *  0b10110..ARM_TXEV interrupt event from cpu0 or cpu1
 *  0b10111..DEBUG_HALTED from cpu0 or cpu1
 *  0b11000-0b11111..None
 */
#define INPUTMUX_SCT0_INMUX_INP_N(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_SCT0_INMUX_INP_N_SHIFT)) & INPUTMUX_SCT0_INMUX_INP_N_MASK)
/*! @} */

/* The count of INPUTMUX_SCT0_INMUX */
#define INPUTMUX_SCT0_INMUX_COUNT (7U)

/*! @name TIMER0CAPTSEL - Capture select registers for TIMER0 inputs */
/*! @{ */
#define INPUTMUX_TIMER0CAPTSEL_CAPTSEL_MASK (0x1FU)
#define INPUTMUX_TIMER0CAPTSEL_CAPTSEL_SHIFT (0U)
/*! CAPTSEL - Input number to TIMER0 capture inputs 0 to 4
 *  0b00000..CT_INP0 function selected from IOCON register
 *  0b00001..CT_INP1 function selected from IOCON register
 *  0b00010..CT_INP2 function selected from IOCON register
 *  0b00011..CT_INP3 function selected from IOCON register
 *  0b00100..CT_INP4 function selected from IOCON register
 *  0b00101..CT_INP5 function selected from IOCON register
 *  0b00110..CT_INP6 function selected from IOCON register
 *  0b00111..CT_INP7 function selected from IOCON register
 *  0b01000..CT_INP8 function selected from IOCON register
 *  0b01001..CT_INP9 function selected from IOCON register
 *  0b01010..CT_INP10 function selected from IOCON register
 *  0b01011..CT_INP11 function selected from IOCON register
 *  0b01100..CT_INP12 function selected from IOCON register
 *  0b01101..CT_INP13 function selected from IOCON register
 *  0b01110..CT_INP14 function selected from IOCON register
 *  0b01111..CT_INP15 function selected from IOCON register
 *  0b10000..CT_INP16 function selected from IOCON register
 *  0b10001..None
 *  0b10010..None
 *  0b10011..None
 *  0b10100..USB0_FRAME_TOGGLE
 *  0b10101..USB1_FRAME_TOGGLE
 *  0b10110..COMP_OUTPUT output from analog comparator
 *  0b10111..I2S_SHARED_WS[0] output from I2S pin sharing
 *  0b11000..I2S_SHARED_WS[1] output from I2S pin sharing
 *  0b11001-0b11111..None
 */
#define INPUTMUX_TIMER0CAPTSEL_CAPTSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER0CAPTSEL_CAPTSEL_SHIFT)) & INPUTMUX_TIMER0CAPTSEL_CAPTSEL_MASK)
/*! @} */

/* The count of INPUTMUX_TIMER0CAPTSEL */
#define INPUTMUX_TIMER0CAPTSEL_COUNT (4U)

/*! @name TIMER1CAPTSEL - Capture select registers for TIMER1 inputs */
/*! @{ */
#define INPUTMUX_TIMER1CAPTSEL_CAPTSEL_MASK (0x1FU)
#define INPUTMUX_TIMER1CAPTSEL_CAPTSEL_SHIFT (0U)
/*! CAPTSEL - Input number to TIMER1 capture inputs 0 to 4
 *  0b00000..CT_INP0 function selected from IOCON register
 *  0b00001..CT_INP1 function selected from IOCON register
 *  0b00010..CT_INP2 function selected from IOCON register
 *  0b00011..CT_INP3 function selected from IOCON register
 *  0b00100..CT_INP4 function selected from IOCON register
 *  0b00101..CT_INP5 function selected from IOCON register
 *  0b00110..CT_INP6 function selected from IOCON register
 *  0b00111..CT_INP7 function selected from IOCON register
 *  0b01000..CT_INP8 function selected from IOCON register
 *  0b01001..CT_INP9 function selected from IOCON register
 *  0b01010..CT_INP10 function selected from IOCON register
 *  0b01011..CT_INP11 function selected from IOCON register
 *  0b01100..CT_INP12 function selected from IOCON register
 *  0b01101..CT_INP13 function selected from IOCON register
 *  0b01110..CT_INP14 function selected from IOCON register
 *  0b01111..CT_INP15 function selected from IOCON register
 *  0b10000..CT_INP16 function selected from IOCON register
 *  0b10001..None
 *  0b10010..None
 *  0b10011..None
 *  0b10100..USB0_FRAME_TOGGLE
 *  0b10101..USB1_FRAME_TOGGLE
 *  0b10110..COMP_OUTPUT output from analog comparator
 *  0b10111..I2S_SHARED_WS[0] output from I2S pin sharing
 *  0b11000..I2S_SHARED_WS[1] output from I2S pin sharing
 *  0b11001-0b11111..None
 */
#define INPUTMUX_TIMER1CAPTSEL_CAPTSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER1CAPTSEL_CAPTSEL_SHIFT)) & INPUTMUX_TIMER1CAPTSEL_CAPTSEL_MASK)
/*! @} */

/* The count of INPUTMUX_TIMER1CAPTSEL */
#define INPUTMUX_TIMER1CAPTSEL_COUNT (4U)

/*! @name TIMER2CAPTSEL - Capture select registers for TIMER2 inputs */
/*! @{ */
#define INPUTMUX_TIMER2CAPTSEL_CAPTSEL_MASK (0x1FU)
#define INPUTMUX_TIMER2CAPTSEL_CAPTSEL_SHIFT (0U)
/*! CAPTSEL - Input number to TIMER2 capture inputs 0 to 4
 *  0b00000..CT_INP0 function selected from IOCON register
 *  0b00001..CT_INP1 function selected from IOCON register
 *  0b00010..CT_INP2 function selected from IOCON register
 *  0b00011..CT_INP3 function selected from IOCON register
 *  0b00100..CT_INP4 function selected from IOCON register
 *  0b00101..CT_INP5 function selected from IOCON register
 *  0b00110..CT_INP6 function selected from IOCON register
 *  0b00111..CT_INP7 function selected from IOCON register
 *  0b01000..CT_INP8 function selected from IOCON register
 *  0b01001..CT_INP9 function selected from IOCON register
 *  0b01010..CT_INP10 function selected from IOCON register
 *  0b01011..CT_INP11 function selected from IOCON register
 *  0b01100..CT_INP12 function selected from IOCON register
 *  0b01101..CT_INP13 function selected from IOCON register
 *  0b01110..CT_INP14 function selected from IOCON register
 *  0b01111..CT_INP15 function selected from IOCON register
 *  0b10000..CT_INP16 function selected from IOCON register
 *  0b10001..None
 *  0b10010..None
 *  0b10011..None
 *  0b10100..USB0_FRAME_TOGGLE
 *  0b10101..USB1_FRAME_TOGGLE
 *  0b10110..COMP_OUTPUT output from analog comparator
 *  0b10111..I2S_SHARED_WS[0] output from I2S pin sharing
 *  0b11000..I2S_SHARED_WS[1] output from I2S pin sharing
 *  0b11001-0b11111..None
 */
#define INPUTMUX_TIMER2CAPTSEL_CAPTSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER2CAPTSEL_CAPTSEL_SHIFT)) & INPUTMUX_TIMER2CAPTSEL_CAPTSEL_MASK)
/*! @} */

/* The count of INPUTMUX_TIMER2CAPTSEL */
#define INPUTMUX_TIMER2CAPTSEL_COUNT (4U)

/*! @name PINTSEL - Pin interrupt select register */
/*! @{ */
#define INPUTMUX_PINTSEL_INTPIN_MASK (0x7FU)
#define INPUTMUX_PINTSEL_INTPIN_SHIFT (0U)
/*! INTPIN - Pin number select for pin interrupt or pattern match engine input. For PIOx_y: INTPIN =
 *    (x * 32) + y. PIO0_0 to PIO1_31 correspond to numbers 0 to 63.
 */
#define INPUTMUX_PINTSEL_INTPIN(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PINTSEL_INTPIN_SHIFT)) & INPUTMUX_PINTSEL_INTPIN_MASK)
/*! @} */

/* The count of INPUTMUX_PINTSEL */
#define INPUTMUX_PINTSEL_COUNT (8U)

/*! @name DMA0_ITRIG_INMUX - Trigger select register for DMA0 channel */
/*! @{ */
#define INPUTMUX_DMA0_ITRIG_INMUX_INP_MASK (0x1FU)
#define INPUTMUX_DMA0_ITRIG_INMUX_INP_SHIFT (0U)
/*! INP - Trigger input number (decimal value) for DMA channel n (n = 0 to 22).
 *  0b00000..Pin interrupt 0
 *  0b00001..Pin interrupt 1
 *  0b00010..Pin interrupt 2
 *  0b00011..Pin interrupt 3
 *  0b00100..Timer CTIMER0 Match 0
 *  0b00101..Timer CTIMER0 Match 1
 *  0b00110..Timer CTIMER1 Match 0
 *  0b00111..Timer CTIMER1 Match 1
 *  0b01000..Timer CTIMER2 Match 0
 *  0b01001..Timer CTIMER2 Match 1
 *  0b01010..Timer CTIMER3 Match 0
 *  0b01011..Timer CTIMER3 Match 1
 *  0b01100..Timer CTIMER4 Match 0
 *  0b01101..Timer CTIMER4 Match 1
 *  0b01110..COMP_OUTPUT
 *  0b01111..DMA0 output trigger mux 0
 *  0b10000..DMA0 output trigger mux 1
 *  0b10001..DMA0 output trigger mux 1
 *  0b10010..DMA0 output trigger mux 3
 *  0b10011..SCT0 DMA request 0
 *  0b10100..SCT0 DMA request 1
 *  0b10101..HASH DMA RX trigger
 *  0b10110-0b11111..None
 */
#define INPUTMUX_DMA0_ITRIG_INMUX_INP(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_ITRIG_INMUX_INP_SHIFT)) & INPUTMUX_DMA0_ITRIG_INMUX_INP_MASK)
/*! @} */

/* The count of INPUTMUX_DMA0_ITRIG_INMUX */
#define INPUTMUX_DMA0_ITRIG_INMUX_COUNT (23U)

/*! @name DMA0_OTRIG_INMUX - DMA0 output trigger selection to become DMA0 trigger */
/*! @{ */
#define INPUTMUX_DMA0_OTRIG_INMUX_INP_MASK (0x1FU)
#define INPUTMUX_DMA0_OTRIG_INMUX_INP_SHIFT (0U)
/*! INP - DMA trigger output number (decimal value) for DMA channel n (n = 0 to 22).
 */
#define INPUTMUX_DMA0_OTRIG_INMUX_INP(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_OTRIG_INMUX_INP_SHIFT)) & INPUTMUX_DMA0_OTRIG_INMUX_INP_MASK)
/*! @} */

/* The count of INPUTMUX_DMA0_OTRIG_INMUX */
#define INPUTMUX_DMA0_OTRIG_INMUX_COUNT (4U)

/*! @name FREQMEAS_REF - Selection for frequency measurement reference clock */
/*! @{ */
#define INPUTMUX_FREQMEAS_REF_CLKIN_MASK (0x1FU)
#define INPUTMUX_FREQMEAS_REF_CLKIN_SHIFT (0U)
/*! CLKIN - Clock source number (decimal value) for frequency measure function target clock: 0 =
 *    CLK_IN 1 = FRO 12 MHz oscillator 2 = Watchdog oscillator 3 = 32 kHz RTC oscillator 4 = Main clock
 *    (see Section 4.5.23) 5 = PIO0_4 6 = PIO0_20 7 = PIO0_24 8 = PIO1_4
 */
#define INPUTMUX_FREQMEAS_REF_CLKIN(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FREQMEAS_REF_CLKIN_SHIFT)) & INPUTMUX_FREQMEAS_REF_CLKIN_MASK)
/*! @} */

/*! @name FREQMEAS_TARGET - Selection for frequency measurement target clock */
/*! @{ */
#define INPUTMUX_FREQMEAS_TARGET_CLKIN_MASK (0x1FU)
#define INPUTMUX_FREQMEAS_TARGET_CLKIN_SHIFT (0U)
/*! CLKIN - Clock source number (decimal value) for frequency measure function target clock: 0 =
 *    CLK_IN 1 = FRO 12 MHz oscillator 2 = Watchdog oscillator 3 = 32 kHz RTC oscillator 4 = Main clock
 *    (see Section 4.5.23) 5 = PIO0_4 6 = PIO0_20 7 = PIO0_24 8 = PIO1_4
 */
#define INPUTMUX_FREQMEAS_TARGET_CLKIN(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FREQMEAS_TARGET_CLKIN_SHIFT)) & INPUTMUX_FREQMEAS_TARGET_CLKIN_MASK)
/*! @} */

/*! @name TIMER3CAPTSEL - Capture select registers for TIMER3 inputs */
/*! @{ */
#define INPUTMUX_TIMER3CAPTSEL_CAPTSEL_MASK (0x1FU)
#define INPUTMUX_TIMER3CAPTSEL_CAPTSEL_SHIFT (0U)
/*! CAPTSEL - Input number to TIMER3 capture inputs 0 to 4
 *  0b00000..CT_INP0 function selected from IOCON register
 *  0b00001..CT_INP1 function selected from IOCON register
 *  0b00010..CT_INP2 function selected from IOCON register
 *  0b00011..CT_INP3 function selected from IOCON register
 *  0b00100..CT_INP4 function selected from IOCON register
 *  0b00101..CT_INP5 function selected from IOCON register
 *  0b00110..CT_INP6 function selected from IOCON register
 *  0b00111..CT_INP7 function selected from IOCON register
 *  0b01000..CT_INP8 function selected from IOCON register
 *  0b01001..CT_INP9 function selected from IOCON register
 *  0b01010..CT_INP10 function selected from IOCON register
 *  0b01011..CT_INP11 function selected from IOCON register
 *  0b01100..CT_INP12 function selected from IOCON register
 *  0b01101..CT_INP13 function selected from IOCON register
 *  0b01110..CT_INP14 function selected from IOCON register
 *  0b01111..CT_INP15 function selected from IOCON register
 *  0b10000..CT_INP16 function selected from IOCON register
 *  0b10001..CT_INP17 function selected from IOCON register
 *  0b10010..CT_INP18 function selected from IOCON register
 *  0b10011..CT_INP19 function selected from IOCON register
 *  0b10100..USB0_FRAME_TOGGLE
 *  0b10101..USB1_FRAME_TOGGLE
 *  0b10110..COMP_OUTPUT output from analog comparator
 *  0b10111..I2S_SHARED_WS[0] output from I2S pin sharing
 *  0b11000..I2S_SHARED_WS[1] output from I2S pin sharing
 *  0b11001-0b11111..None
 */
#define INPUTMUX_TIMER3CAPTSEL_CAPTSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER3CAPTSEL_CAPTSEL_SHIFT)) & INPUTMUX_TIMER3CAPTSEL_CAPTSEL_MASK)
/*! @} */

/* The count of INPUTMUX_TIMER3CAPTSEL */
#define INPUTMUX_TIMER3CAPTSEL_COUNT (4U)

/*! @name TIMER4CAPTSEL - Capture select registers for TIMER4 inputs */
/*! @{ */
#define INPUTMUX_TIMER4CAPTSEL_CAPTSEL_MASK (0x1FU)
#define INPUTMUX_TIMER4CAPTSEL_CAPTSEL_SHIFT (0U)
/*! CAPTSEL - Input number to TIMER4 capture inputs 0 to 4
 *  0b00000..CT_INP0 function selected from IOCON register
 *  0b00001..CT_INP1 function selected from IOCON register
 *  0b00010..CT_INP2 function selected from IOCON register
 *  0b00011..CT_INP3 function selected from IOCON register
 *  0b00100..CT_INP4 function selected from IOCON register
 *  0b00101..CT_INP5 function selected from IOCON register
 *  0b00110..CT_INP6 function selected from IOCON register
 *  0b00111..CT_INP7 function selected from IOCON register
 *  0b01000..CT_INP8 function selected from IOCON register
 *  0b01001..CT_INP9 function selected from IOCON register
 *  0b01010..CT_INP10 function selected from IOCON register
 *  0b01011..CT_INP11 function selected from IOCON register
 *  0b01100..CT_INP12 function selected from IOCON register
 *  0b01101..CT_INP13 function selected from IOCON register
 *  0b01110..CT_INP14 function selected from IOCON register
 *  0b01111..CT_INP15 function selected from IOCON register
 *  0b10000..CT_INP16 function selected from IOCON register
 *  0b10001..CT_INP17 function selected from IOCON register
 *  0b10010..CT_INP18 function selected from IOCON register
 *  0b10011..CT_INP19 function selected from IOCON register
 *  0b10100..USB0_FRAME_TOGGLE
 *  0b10101..USB1_FRAME_TOGGLE
 *  0b10110..COMP_OUTPUT output from analog comparator
 *  0b10111..I2S_SHARED_WS[0] output from I2S pin sharing
 *  0b11000..I2S_SHARED_WS[1] output from I2S pin sharing
 *  0b11001-0b11111..None
 */
#define INPUTMUX_TIMER4CAPTSEL_CAPTSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_TIMER4CAPTSEL_CAPTSEL_SHIFT)) & INPUTMUX_TIMER4CAPTSEL_CAPTSEL_MASK)
/*! @} */

/* The count of INPUTMUX_TIMER4CAPTSEL */
#define INPUTMUX_TIMER4CAPTSEL_COUNT (4U)

/*! @name PINTSECSEL - Pin interrupt secure select register */
/*! @{ */
#define INPUTMUX_PINTSECSEL_INTPIN_MASK (0x3FU)
#define INPUTMUX_PINTSECSEL_INTPIN_SHIFT (0U)
/*! INTPIN - Pin number select for pin interrupt secure or pattern match engine input. For PIO0_x:
 *    INTPIN = x. PIO0_0 to PIO0_31 correspond to numbers 0 to 31.
 */
#define INPUTMUX_PINTSECSEL_INTPIN(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PINTSECSEL_INTPIN_SHIFT)) & INPUTMUX_PINTSECSEL_INTPIN_MASK)
/*! @} */

/* The count of INPUTMUX_PINTSECSEL */
#define INPUTMUX_PINTSECSEL_COUNT (2U)

/*! @name DMA1_ITRIG_INMUX - Trigger select register for DMA1 channel */
/*! @{ */
#define INPUTMUX_DMA1_ITRIG_INMUX_INP_MASK (0xFU)
#define INPUTMUX_DMA1_ITRIG_INMUX_INP_SHIFT (0U)
/*! INP - Trigger input number (decimal value) for DMA channel n (n = 0 to 9).
 *  0b0000..Pin interrupt 0
 *  0b0001..Pin interrupt 1
 *  0b0010..Pin interrupt 2
 *  0b0011..Pin interrupt 3
 *  0b0100..Timer CTIMER0 Match 0
 *  0b0101..Timer CTIMER0 Match 1
 *  0b0110..Timer CTIMER2 Match 0
 *  0b0111..Timer CTIMER4 Match 0
 *  0b1000..DMA1 output trigger mux 0
 *  0b1001..DMA1 output trigger mux 1
 *  0b1010..DMA1 output trigger mux 2
 *  0b1011..DMA1 output trigger mux 3
 *  0b1100..SCT0 DMA request 0
 *  0b1101..SCT0 DMA request 1
 *  0b1110..HASH DMA RX trigger
 *  0b1111..None
 */
#define INPUTMUX_DMA1_ITRIG_INMUX_INP(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_ITRIG_INMUX_INP_SHIFT)) & INPUTMUX_DMA1_ITRIG_INMUX_INP_MASK)
/*! @} */

/* The count of INPUTMUX_DMA1_ITRIG_INMUX */
#define INPUTMUX_DMA1_ITRIG_INMUX_COUNT (10U)

/*! @name DMA1_OTRIG_INMUX - DMA1 output trigger selection to become DMA1 trigger */
/*! @{ */
#define INPUTMUX_DMA1_OTRIG_INMUX_INP_MASK (0xFU)
#define INPUTMUX_DMA1_OTRIG_INMUX_INP_SHIFT (0U)
/*! INP - DMA trigger output number (decimal value) for DMA channel n (n = 0 to 9).
 */
#define INPUTMUX_DMA1_OTRIG_INMUX_INP(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_OTRIG_INMUX_INP_SHIFT)) & INPUTMUX_DMA1_OTRIG_INMUX_INP_MASK)
/*! @} */

/* The count of INPUTMUX_DMA1_OTRIG_INMUX */
#define INPUTMUX_DMA1_OTRIG_INMUX_COUNT (4U)

/*! @name DMA0_REQ_ENA - Enable DMA0 requests */
/*! @{ */
#define INPUTMUX_DMA0_REQ_ENA_REQ_ENA_MASK (0x7FFFFFU)
#define INPUTMUX_DMA0_REQ_ENA_REQ_ENA_SHIFT (0U)
/*! REQ_ENA - Controls the 23 request inputs of DMA0. If bit i is '1' the DMA request input #i is enabled.
 */
#define INPUTMUX_DMA0_REQ_ENA_REQ_ENA(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_REQ_ENA_REQ_ENA_SHIFT)) & INPUTMUX_DMA0_REQ_ENA_REQ_ENA_MASK)
/*! @} */

/*! @name DMA0_REQ_ENA_SET - Set one or several bits in DMA0_REQ_ENA register */
/*! @{ */
#define INPUTMUX_DMA0_REQ_ENA_SET_SET_MASK (0x7FFFFFU)
#define INPUTMUX_DMA0_REQ_ENA_SET_SET_SHIFT (0U)
/*! SET - Write : If bit #i = 1, bit #i in DMA0_REQ_ENA register is set to 1; if bit #i = 0 , no change in DMA0_REQ_ENA
 * register
 */
#define INPUTMUX_DMA0_REQ_ENA_SET_SET(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_REQ_ENA_SET_SET_SHIFT)) & INPUTMUX_DMA0_REQ_ENA_SET_SET_MASK)
/*! @} */

/*! @name DMA0_REQ_ENA_CLR - Clear one or several bits in DMA0_REQ_ENA register */
/*! @{ */
#define INPUTMUX_DMA0_REQ_ENA_CLR_CLR_MASK (0x7FFFFFU)
#define INPUTMUX_DMA0_REQ_ENA_CLR_CLR_SHIFT (0U)
/*! CLR - Write : If bit #i = 1, bit #i in DMA0_REQ_ENA register is reset to 0; if bit #i = 0 , no change in
 * DMA0_REQ_ENA register
 */
#define INPUTMUX_DMA0_REQ_ENA_CLR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_REQ_ENA_CLR_CLR_SHIFT)) & INPUTMUX_DMA0_REQ_ENA_CLR_CLR_MASK)
/*! @} */

/*! @name DMA1_REQ_ENA - Enable DMA1 requests */
/*! @{ */
#define INPUTMUX_DMA1_REQ_ENA_REQ_ENA_MASK (0x3FFU)
#define INPUTMUX_DMA1_REQ_ENA_REQ_ENA_SHIFT (0U)
/*! REQ_ENA - Controls the 10 request inputs of DMA1. If bit i is '1' the DMA request input #i is enabled.
 */
#define INPUTMUX_DMA1_REQ_ENA_REQ_ENA(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_REQ_ENA_REQ_ENA_SHIFT)) & INPUTMUX_DMA1_REQ_ENA_REQ_ENA_MASK)
/*! @} */

/*! @name DMA1_REQ_ENA_SET - Set one or several bits in DMA1_REQ_ENA register */
/*! @{ */
#define INPUTMUX_DMA1_REQ_ENA_SET_SET_MASK (0x3FFU)
#define INPUTMUX_DMA1_REQ_ENA_SET_SET_SHIFT (0U)
/*! SET - Write : If bit #i = 1, bit #i in DMA1_REQ_ENA register is set to 1; if bit #i = 0 , no change in DMA1_REQ_ENA
 * register
 */
#define INPUTMUX_DMA1_REQ_ENA_SET_SET(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_REQ_ENA_SET_SET_SHIFT)) & INPUTMUX_DMA1_REQ_ENA_SET_SET_MASK)
/*! @} */

/*! @name DMA1_REQ_ENA_CLR - Clear one or several bits in DMA1_REQ_ENA register */
/*! @{ */
#define INPUTMUX_DMA1_REQ_ENA_CLR_CLR_MASK (0x3FFU)
#define INPUTMUX_DMA1_REQ_ENA_CLR_CLR_SHIFT (0U)
/*! CLR - Write : If bit #i = 1, bit #i in DMA1_REQ_ENA register is reset to 0; if bit #i = 0 , no change in
 * DMA1_REQ_ENA register
 */
#define INPUTMUX_DMA1_REQ_ENA_CLR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_REQ_ENA_CLR_CLR_SHIFT)) & INPUTMUX_DMA1_REQ_ENA_CLR_CLR_MASK)
/*! @} */

/*! @name DMA0_ITRIG_ENA - Enable DMA0 triggers */
/*! @{ */
#define INPUTMUX_DMA0_ITRIG_ENA_ITRIG_ENA_MASK (0x3FFFFFU)
#define INPUTMUX_DMA0_ITRIG_ENA_ITRIG_ENA_SHIFT (0U)
/*! ITRIG_ENA - Controls the 22 trigger inputs of DMA0. If bit i is '1' the DMA trigger input #i is enabled.
 */
#define INPUTMUX_DMA0_ITRIG_ENA_ITRIG_ENA(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_ITRIG_ENA_ITRIG_ENA_SHIFT)) & INPUTMUX_DMA0_ITRIG_ENA_ITRIG_ENA_MASK)
/*! @} */

/*! @name DMA0_ITRIG_ENA_SET - Set one or several bits in DMA0_ITRIG_ENA register */
/*! @{ */
#define INPUTMUX_DMA0_ITRIG_ENA_SET_SET_MASK (0x3FFFFFU)
#define INPUTMUX_DMA0_ITRIG_ENA_SET_SET_SHIFT (0U)
/*! SET - Write : If bit #i = 1, bit #i in DMA0_ITRIG_ENA register is set to 1; if bit #i = 0 , no
 *    change in DMA0_ITRIG_ENA register
 */
#define INPUTMUX_DMA0_ITRIG_ENA_SET_SET(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_ITRIG_ENA_SET_SET_SHIFT)) & INPUTMUX_DMA0_ITRIG_ENA_SET_SET_MASK)
/*! @} */

/*! @name DMA0_ITRIG_ENA_CLR - Clear one or several bits in DMA0_ITRIG_ENA register */
/*! @{ */
#define INPUTMUX_DMA0_ITRIG_ENA_CLR_CLR_MASK (0x3FFFFFU)
#define INPUTMUX_DMA0_ITRIG_ENA_CLR_CLR_SHIFT (0U)
/*! CLR - Write : If bit #i = 1, bit #i in DMA0_ITRIG_ENA register is reset to 0; if bit #i = 0 , no
 *    change in DMA0_ITRIG_ENA register
 */
#define INPUTMUX_DMA0_ITRIG_ENA_CLR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA0_ITRIG_ENA_CLR_CLR_SHIFT)) & INPUTMUX_DMA0_ITRIG_ENA_CLR_CLR_MASK)
/*! @} */

/*! @name DMA1_ITRIG_ENA - Enable DMA1 triggers */
/*! @{ */
#define INPUTMUX_DMA1_ITRIG_ENA_ITRIG_ENA_MASK (0x7FFFU)
#define INPUTMUX_DMA1_ITRIG_ENA_ITRIG_ENA_SHIFT (0U)
/*! ITRIG_ENA - Controls the 15 trigger inputs of DMA1. If bit i is '1' the DMA trigger input #i is enabled.
 */
#define INPUTMUX_DMA1_ITRIG_ENA_ITRIG_ENA(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_ITRIG_ENA_ITRIG_ENA_SHIFT)) & INPUTMUX_DMA1_ITRIG_ENA_ITRIG_ENA_MASK)
/*! @} */

/*! @name DMA1_ITRIG_ENA_SET - Set one or several bits in DMA1_ITRIG_ENA register */
/*! @{ */
#define INPUTMUX_DMA1_ITRIG_ENA_SET_SET_MASK (0x7FFFU)
#define INPUTMUX_DMA1_ITRIG_ENA_SET_SET_SHIFT (0U)
/*! SET - Write : If bit #i = 1, bit #i in DMA1_ITRIG_ENA register is set to 1; if bit #i = 0 , no
 *    change in DMA1_ITRIG_ENA register
 */
#define INPUTMUX_DMA1_ITRIG_ENA_SET_SET(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_ITRIG_ENA_SET_SET_SHIFT)) & INPUTMUX_DMA1_ITRIG_ENA_SET_SET_MASK)
/*! @} */

/*! @name DMA1_ITRIG_ENA_CLR - Clear one or several bits in DMA1_ITRIG_ENA register */
/*! @{ */
#define INPUTMUX_DMA1_ITRIG_ENA_CLR_CLR_MASK (0x7FFFU)
#define INPUTMUX_DMA1_ITRIG_ENA_CLR_CLR_SHIFT (0U)
/*! CLR - Write : If bit #i = 1, bit #i in DMA1_ITRIG_ENA register is reset to 0; if bit #i = 0 , no
 *    change in DMA1_ITRIG_ENA register
 */
#define INPUTMUX_DMA1_ITRIG_ENA_CLR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA1_ITRIG_ENA_CLR_CLR_SHIFT)) & INPUTMUX_DMA1_ITRIG_ENA_CLR_CLR_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group INPUTMUX_Register_Masks */

/* INPUTMUX - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral INPUTMUX base address */
#define INPUTMUX_BASE (0x50006000u)
/** Peripheral INPUTMUX base address */
#define INPUTMUX_BASE_NS (0x40006000u)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX ((INPUTMUX_Type *)INPUTMUX_BASE)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX_NS ((INPUTMUX_Type *)INPUTMUX_BASE_NS)
/** Array initializer of INPUTMUX peripheral base addresses */
#define INPUTMUX_BASE_ADDRS \
    {                       \
        INPUTMUX_BASE       \
    }
/** Array initializer of INPUTMUX peripheral base pointers */
#define INPUTMUX_BASE_PTRS \
    {                      \
        INPUTMUX           \
    }
/** Array initializer of INPUTMUX peripheral base addresses */
#define INPUTMUX_BASE_ADDRS_NS \
    {                          \
        INPUTMUX_BASE_NS       \
    }
/** Array initializer of INPUTMUX peripheral base pointers */
#define INPUTMUX_BASE_PTRS_NS \
    {                         \
        INPUTMUX_NS           \
    }
#else
/** Peripheral INPUTMUX base address */
#define INPUTMUX_BASE (0x40006000u)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX ((INPUTMUX_Type *)INPUTMUX_BASE)
/** Array initializer of INPUTMUX peripheral base addresses */
#define INPUTMUX_BASE_ADDRS \
    {                       \
        INPUTMUX_BASE       \
    }
/** Array initializer of INPUTMUX peripheral base pointers */
#define INPUTMUX_BASE_PTRS \
    {                      \
        INPUTMUX           \
    }
#endif

/*!
 * @}
 */ /* end of group INPUTMUX_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- IOCON Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup IOCON_Peripheral_Access_Layer IOCON Peripheral Access Layer
 * @{
 */

/** IOCON - Register Layout Typedef */
typedef struct
{
    __IO uint32_t PIO[2][32]; /**< Digital I/O control for port 0 pins PIO0_0..Digital I/O control for port 1 pins
                                 PIO1_31, array offset: 0x0, array step: index*0x80, index2*0x4 */
} IOCON_Type;

/* ----------------------------------------------------------------------------
   -- IOCON Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup IOCON_Register_Masks IOCON Register Masks
 * @{
 */

/*! @name PIO - Digital I/O control for port 0 pins PIO0_0..Digital I/O control for port 1 pins PIO1_31 */
/*! @{ */
#define IOCON_PIO_FUNC_MASK (0xFU)
#define IOCON_PIO_FUNC_SHIFT (0U)
/*! FUNC - Selects pin function.
 *  0b0000..Alternative connection 0.
 *  0b0001..Alternative connection 1.
 *  0b0010..Alternative connection 2.
 *  0b0011..Alternative connection 3.
 *  0b0100..Alternative connection 4.
 *  0b0101..Alternative connection 5.
 *  0b0110..Alternative connection 6.
 *  0b0111..Alternative connection 7.
 */
#define IOCON_PIO_FUNC(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_FUNC_SHIFT)) & IOCON_PIO_FUNC_MASK)
#define IOCON_PIO_MODE_MASK (0x30U)
#define IOCON_PIO_MODE_SHIFT (4U)
/*! MODE - Selects function mode (on-chip pull-up/pull-down resistor control).
 *  0b00..Inactive. Inactive (no pull-down/pull-up resistor enabled).
 *  0b01..Pull-down. Pull-down resistor enabled.
 *  0b10..Pull-up. Pull-up resistor enabled.
 *  0b11..Repeater. Repeater mode.
 */
#define IOCON_PIO_MODE(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_MODE_SHIFT)) & IOCON_PIO_MODE_MASK)
#define IOCON_PIO_SLEW_MASK (0x40U)
#define IOCON_PIO_SLEW_SHIFT (6U)
/*! SLEW - Driver slew rate.
 *  0b0..Standard-mode, output slew rate is slower. More outputs can be switched simultaneously.
 *  0b1..Fast-mode, output slew rate is faster. Refer to the appropriate specific device data sheet for details.
 */
#define IOCON_PIO_SLEW(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_SLEW_SHIFT)) & IOCON_PIO_SLEW_MASK)
#define IOCON_PIO_INVERT_MASK (0x80U)
#define IOCON_PIO_INVERT_SHIFT (7U)
/*! INVERT - Input polarity.
 *  0b0..Disabled. Input function is not inverted.
 *  0b1..Enabled. Input is function inverted.
 */
#define IOCON_PIO_INVERT(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_INVERT_SHIFT)) & IOCON_PIO_INVERT_MASK)
#define IOCON_PIO_DIGIMODE_MASK (0x100U)
#define IOCON_PIO_DIGIMODE_SHIFT (8U)
/*! DIGIMODE - Select Digital mode.
 *  0b0..Disable digital mode. Digital input set to 0.
 *  0b1..Enable Digital mode. Digital input is enabled.
 */
#define IOCON_PIO_DIGIMODE(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_DIGIMODE_SHIFT)) & IOCON_PIO_DIGIMODE_MASK)
#define IOCON_PIO_OD_MASK (0x200U)
#define IOCON_PIO_OD_SHIFT (9U)
/*! OD - Controls open-drain mode in standard GPIO mode (EGP = 1). This bit has no effect in I2C mode (EGP=0).
 *  0b0..Normal. Normal push-pull output
 *  0b1..Open-drain. Simulated open-drain output (high drive disabled).
 */
#define IOCON_PIO_OD(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_OD_SHIFT)) & IOCON_PIO_OD_MASK)
#define IOCON_PIO_ASW_MASK (0x400U)
#define IOCON_PIO_ASW_SHIFT (10U)
/*! ASW - Analog switch input control.
 *  0b0..For pins PIO0_9, PIO0_11, PIO0_12, PIO0_15, PIO0_18, PIO0_31, PIO1_0 and PIO1_9, analog switch is closed
 *       (enabled). For the other pins, analog switch is open (disabled).
 *  0b1..For all pins except PIO0_9, PIO0_11, PIO0_12, PIO0_15, PIO0_18, PIO0_31, PIO1_0 and PIO1_9 analog switch is
 * closed (enabled)
 */
#define IOCON_PIO_ASW(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_ASW_SHIFT)) & IOCON_PIO_ASW_MASK)
#define IOCON_PIO_SSEL_MASK (0x800U)
#define IOCON_PIO_SSEL_SHIFT (11U)
/*! SSEL - Supply Selection bit.
 *  0b0..3V3 Signaling in I2C Mode.
 *  0b1..1V8 Signaling in I2C Mode.
 */
#define IOCON_PIO_SSEL(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_SSEL_SHIFT)) & IOCON_PIO_SSEL_MASK)
#define IOCON_PIO_FILTEROFF_MASK (0x1000U)
#define IOCON_PIO_FILTEROFF_SHIFT (12U)
/*! FILTEROFF - Controls input glitch filter.
 *  0b0..Filter enabled.
 *  0b1..Filter disabled.
 */
#define IOCON_PIO_FILTEROFF(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_FILTEROFF_SHIFT)) & IOCON_PIO_FILTEROFF_MASK)
#define IOCON_PIO_ECS_MASK (0x2000U)
#define IOCON_PIO_ECS_SHIFT (13U)
/*! ECS - Pull-up current source enable in I2C mode.
 *  0b1..Enabled. Pull resistor is conencted.
 *  0b0..Disabled. IO is in open drain cell.
 */
#define IOCON_PIO_ECS(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_ECS_SHIFT)) & IOCON_PIO_ECS_MASK)
#define IOCON_PIO_EGP_MASK (0x4000U)
#define IOCON_PIO_EGP_SHIFT (14U)
/*! EGP - Switch between GPIO mode and I2C mode.
 *  0b0..I2C mode.
 *  0b1..GPIO mode.
 */
#define IOCON_PIO_EGP(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_EGP_SHIFT)) & IOCON_PIO_EGP_MASK)
#define IOCON_PIO_I2CFILTER_MASK (0x8000U)
#define IOCON_PIO_I2CFILTER_SHIFT (15U)
/*! I2CFILTER - Configures I2C features for standard mode, fast mode, and Fast Mode Plus operation and High-Speed mode
 * operation. 0b0..I2C 50 ns glitch filter enabled. Typically used for Standard-mode, Fast-mode and Fast-mode Plus I2C.
 *  0b1..I2C 10 ns glitch filter enabled. Typically used for High-speed mode I2C.
 */
#define IOCON_PIO_I2CFILTER(x) (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_I2CFILTER_SHIFT)) & IOCON_PIO_I2CFILTER_MASK)
/*! @} */

/* The count of IOCON_PIO */
#define IOCON_PIO_COUNT (2U)

/* The count of IOCON_PIO */
#define IOCON_PIO_COUNT2 (32U)

/*!
 * @}
 */ /* end of group IOCON_Register_Masks */

/* IOCON - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral IOCON base address */
#define IOCON_BASE (0x50001000u)
/** Peripheral IOCON base address */
#define IOCON_BASE_NS (0x40001000u)
/** Peripheral IOCON base pointer */
#define IOCON ((IOCON_Type *)IOCON_BASE)
/** Peripheral IOCON base pointer */
#define IOCON_NS ((IOCON_Type *)IOCON_BASE_NS)
/** Array initializer of IOCON peripheral base addresses */
#define IOCON_BASE_ADDRS \
    {                    \
        IOCON_BASE       \
    }
/** Array initializer of IOCON peripheral base pointers */
#define IOCON_BASE_PTRS \
    {                   \
        IOCON           \
    }
/** Array initializer of IOCON peripheral base addresses */
#define IOCON_BASE_ADDRS_NS \
    {                       \
        IOCON_BASE_NS       \
    }
/** Array initializer of IOCON peripheral base pointers */
#define IOCON_BASE_PTRS_NS \
    {                      \
        IOCON_NS           \
    }
#else
/** Peripheral IOCON base address */
#define IOCON_BASE (0x40001000u)
/** Peripheral IOCON base pointer */
#define IOCON ((IOCON_Type *)IOCON_BASE)
/** Array initializer of IOCON peripheral base addresses */
#define IOCON_BASE_ADDRS \
    {                    \
        IOCON_BASE       \
    }
/** Array initializer of IOCON peripheral base pointers */
#define IOCON_BASE_PTRS \
    {                   \
        IOCON           \
    }
#endif

/*!
 * @}
 */ /* end of group IOCON_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- MAILBOX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MAILBOX_Peripheral_Access_Layer MAILBOX Peripheral Access Layer
 * @{
 */

/** MAILBOX - Register Layout Typedef */
typedef struct
{
    struct
    { /* offset: 0x0, array step: 0x10 */
        __IO uint32_t
            IRQ; /**< Interrupt request register for the Cortex-M0+ CPU., array offset: 0x0, array step: 0x10 */
        __O uint32_t IRQSET; /**< Set bits in IRQ0, array offset: 0x4, array step: 0x10 */
        __O uint32_t IRQCLR; /**< Clear bits in IRQ0, array offset: 0x8, array step: 0x10 */
        uint8_t RESERVED_0[4];
    } MBOXIRQ[2];
    uint8_t RESERVED_0[216];
    __IO uint32_t MUTEX; /**< Mutual exclusion register[1], offset: 0xF8 */
} MAILBOX_Type;

/* ----------------------------------------------------------------------------
   -- MAILBOX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MAILBOX_Register_Masks MAILBOX Register Masks
 * @{
 */

/*! @name MBOXIRQ_IRQ - Interrupt request register for the Cortex-M0+ CPU. */
/*! @{ */
#define MAILBOX_MBOXIRQ_IRQ_INTREQ_MASK (0xFFFFFFFFU)
#define MAILBOX_MBOXIRQ_IRQ_INTREQ_SHIFT (0U)
/*! INTREQ - If any bit is set, an interrupt request is sent to the Cortex-M0+ interrupt controller.
 */
#define MAILBOX_MBOXIRQ_IRQ_INTREQ(x) \
    (((uint32_t)(((uint32_t)(x)) << MAILBOX_MBOXIRQ_IRQ_INTREQ_SHIFT)) & MAILBOX_MBOXIRQ_IRQ_INTREQ_MASK)
/*! @} */

/* The count of MAILBOX_MBOXIRQ_IRQ */
#define MAILBOX_MBOXIRQ_IRQ_COUNT (2U)

/*! @name MBOXIRQ_IRQSET - Set bits in IRQ0 */
/*! @{ */
#define MAILBOX_MBOXIRQ_IRQSET_INTREQSET_MASK (0xFFFFFFFFU)
#define MAILBOX_MBOXIRQ_IRQSET_INTREQSET_SHIFT (0U)
/*! INTREQSET - Writing 1 sets the corresponding bit in the IRQ0 register.
 */
#define MAILBOX_MBOXIRQ_IRQSET_INTREQSET(x) \
    (((uint32_t)(((uint32_t)(x)) << MAILBOX_MBOXIRQ_IRQSET_INTREQSET_SHIFT)) & MAILBOX_MBOXIRQ_IRQSET_INTREQSET_MASK)
/*! @} */

/* The count of MAILBOX_MBOXIRQ_IRQSET */
#define MAILBOX_MBOXIRQ_IRQSET_COUNT (2U)

/*! @name MBOXIRQ_IRQCLR - Clear bits in IRQ0 */
/*! @{ */
#define MAILBOX_MBOXIRQ_IRQCLR_INTREQCLR_MASK (0xFFFFFFFFU)
#define MAILBOX_MBOXIRQ_IRQCLR_INTREQCLR_SHIFT (0U)
/*! INTREQCLR - Writing 1 clears the corresponding bit in the IRQ0 register.
 */
#define MAILBOX_MBOXIRQ_IRQCLR_INTREQCLR(x) \
    (((uint32_t)(((uint32_t)(x)) << MAILBOX_MBOXIRQ_IRQCLR_INTREQCLR_SHIFT)) & MAILBOX_MBOXIRQ_IRQCLR_INTREQCLR_MASK)
/*! @} */

/* The count of MAILBOX_MBOXIRQ_IRQCLR */
#define MAILBOX_MBOXIRQ_IRQCLR_COUNT (2U)

/*! @name MUTEX - Mutual exclusion register[1] */
/*! @{ */
#define MAILBOX_MUTEX_EX_MASK (0x1U)
#define MAILBOX_MUTEX_EX_SHIFT (0U)
/*! EX - Cleared when read, set when written. See usage description above.
 */
#define MAILBOX_MUTEX_EX(x) (((uint32_t)(((uint32_t)(x)) << MAILBOX_MUTEX_EX_SHIFT)) & MAILBOX_MUTEX_EX_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group MAILBOX_Register_Masks */

/* MAILBOX - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral MAILBOX base address */
#define MAILBOX_BASE (0x5008B000u)
/** Peripheral MAILBOX base address */
#define MAILBOX_BASE_NS (0x4008B000u)
/** Peripheral MAILBOX base pointer */
#define MAILBOX ((MAILBOX_Type *)MAILBOX_BASE)
/** Peripheral MAILBOX base pointer */
#define MAILBOX_NS ((MAILBOX_Type *)MAILBOX_BASE_NS)
/** Array initializer of MAILBOX peripheral base addresses */
#define MAILBOX_BASE_ADDRS \
    {                      \
        MAILBOX_BASE       \
    }
/** Array initializer of MAILBOX peripheral base pointers */
#define MAILBOX_BASE_PTRS \
    {                     \
        MAILBOX           \
    }
/** Array initializer of MAILBOX peripheral base addresses */
#define MAILBOX_BASE_ADDRS_NS \
    {                         \
        MAILBOX_BASE_NS       \
    }
/** Array initializer of MAILBOX peripheral base pointers */
#define MAILBOX_BASE_PTRS_NS \
    {                        \
        MAILBOX_NS           \
    }
#else
/** Peripheral MAILBOX base address */
#define MAILBOX_BASE (0x4008B000u)
/** Peripheral MAILBOX base pointer */
#define MAILBOX ((MAILBOX_Type *)MAILBOX_BASE)
/** Array initializer of MAILBOX peripheral base addresses */
#define MAILBOX_BASE_ADDRS \
    {                      \
        MAILBOX_BASE       \
    }
/** Array initializer of MAILBOX peripheral base pointers */
#define MAILBOX_BASE_PTRS \
    {                     \
        MAILBOX           \
    }
#endif
/** Interrupt vectors for the MAILBOX peripheral type */
#define MAILBOX_IRQS \
    {                \
        MAILBOX_IRQn \
    }

/*!
 * @}
 */ /* end of group MAILBOX_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- MRT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MRT_Peripheral_Access_Layer MRT Peripheral Access Layer
 * @{
 */

/** MRT - Register Layout Typedef */
typedef struct
{
    struct
    {                         /* offset: 0x0, array step: 0x10 */
        __IO uint32_t INTVAL; /**< MRT Time interval value register. This value is loaded into the TIMER register.,
                                 array offset: 0x0, array step: 0x10 */
        __I uint32_t TIMER;   /**< MRT Timer register. This register reads the value of the down-counter., array offset:
                                 0x4, array step: 0x10 */
        __IO uint32_t CTRL;   /**< MRT Control register. This register controls the MRT modes., array offset: 0x8, array
                                 step: 0x10 */
        __IO uint32_t STAT;   /**< MRT Status register., array offset: 0xC, array step: 0x10 */
    } CHANNEL[4];
    uint8_t RESERVED_0[176];
    __IO uint32_t
        MODCFG; /**< Module Configuration register. This register provides information about this particular MRT
                   instance, and allows choosing an overall mode for the idle channel feature., offset: 0xF0 */
    __I uint32_t IDLE_CH;   /**< Idle channel register. This register returns the number of the first idle channel.,
                               offset: 0xF4 */
    __IO uint32_t IRQ_FLAG; /**< Global interrupt flag register, offset: 0xF8 */
} MRT_Type;

/* ----------------------------------------------------------------------------
   -- MRT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MRT_Register_Masks MRT Register Masks
 * @{
 */

/*! @name CHANNEL_INTVAL - MRT Time interval value register. This value is loaded into the TIMER register. */
/*! @{ */
#define MRT_CHANNEL_INTVAL_IVALUE_MASK (0xFFFFFFU)
#define MRT_CHANNEL_INTVAL_IVALUE_SHIFT (0U)
/*! IVALUE - Time interval load value. This value is loaded into the TIMERn register and the MRT
 *    channel n starts counting down from IVALUE -1. If the timer is idle, writing a non-zero value to
 *    this bit field starts the timer immediately. If the timer is running, writing a zero to this
 *    bit field does the following: If LOAD = 1, the timer stops immediately. If LOAD = 0, the timer
 *    stops at the end of the time interval.
 */
#define MRT_CHANNEL_INTVAL_IVALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_INTVAL_IVALUE_SHIFT)) & MRT_CHANNEL_INTVAL_IVALUE_MASK)
#define MRT_CHANNEL_INTVAL_LOAD_MASK (0x80000000U)
#define MRT_CHANNEL_INTVAL_LOAD_SHIFT (31U)
/*! LOAD - Determines how the timer interval value IVALUE -1 is loaded into the TIMERn register.
 *    This bit is write-only. Reading this bit always returns 0.
 *  0b0..No force load. The load from the INTVALn register to the TIMERn register is processed at the end of the
 *       time interval if the repeat mode is selected.
 *  0b1..Force load. The INTVALn interval value IVALUE -1 is immediately loaded into the TIMERn register while TIMERn is
 * running.
 */
#define MRT_CHANNEL_INTVAL_LOAD(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_INTVAL_LOAD_SHIFT)) & MRT_CHANNEL_INTVAL_LOAD_MASK)
/*! @} */

/* The count of MRT_CHANNEL_INTVAL */
#define MRT_CHANNEL_INTVAL_COUNT (4U)

/*! @name CHANNEL_TIMER - MRT Timer register. This register reads the value of the down-counter. */
/*! @{ */
#define MRT_CHANNEL_TIMER_VALUE_MASK (0xFFFFFFU)
#define MRT_CHANNEL_TIMER_VALUE_SHIFT (0U)
/*! VALUE - Holds the current timer value of the down-counter. The initial value of the TIMERn
 *    register is loaded as IVALUE - 1 from the INTVALn register either at the end of the time interval
 *    or immediately in the following cases: INTVALn register is updated in the idle state. INTVALn
 *    register is updated with LOAD = 1. When the timer is in idle state, reading this bit fields
 *    returns -1 (0x00FF FFFF).
 */
#define MRT_CHANNEL_TIMER_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_TIMER_VALUE_SHIFT)) & MRT_CHANNEL_TIMER_VALUE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_TIMER */
#define MRT_CHANNEL_TIMER_COUNT (4U)

/*! @name CHANNEL_CTRL - MRT Control register. This register controls the MRT modes. */
/*! @{ */
#define MRT_CHANNEL_CTRL_INTEN_MASK (0x1U)
#define MRT_CHANNEL_CTRL_INTEN_SHIFT (0U)
/*! INTEN - Enable the TIMERn interrupt.
 *  0b0..Disabled. TIMERn interrupt is disabled.
 *  0b1..Enabled. TIMERn interrupt is enabled.
 */
#define MRT_CHANNEL_CTRL_INTEN(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_CTRL_INTEN_SHIFT)) & MRT_CHANNEL_CTRL_INTEN_MASK)
#define MRT_CHANNEL_CTRL_MODE_MASK (0x6U)
#define MRT_CHANNEL_CTRL_MODE_SHIFT (1U)
/*! MODE - Selects timer mode.
 *  0b00..Repeat interrupt mode.
 *  0b01..One-shot interrupt mode.
 *  0b10..One-shot stall mode.
 *  0b11..Reserved.
 */
#define MRT_CHANNEL_CTRL_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_CTRL_MODE_SHIFT)) & MRT_CHANNEL_CTRL_MODE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_CTRL */
#define MRT_CHANNEL_CTRL_COUNT (4U)

/*! @name CHANNEL_STAT - MRT Status register. */
/*! @{ */
#define MRT_CHANNEL_STAT_INTFLAG_MASK (0x1U)
#define MRT_CHANNEL_STAT_INTFLAG_SHIFT (0U)
/*! INTFLAG - Monitors the interrupt flag.
 *  0b0..No pending interrupt. Writing a zero is equivalent to no operation.
 *  0b1..Pending interrupt. The interrupt is pending because TIMERn has reached the end of the time interval. If
 *       the INTEN bit in the CONTROLn is also set to 1, the interrupt for timer channel n and the global interrupt
 *       are raised. Writing a 1 to this bit clears the interrupt request.
 */
#define MRT_CHANNEL_STAT_INTFLAG(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_INTFLAG_SHIFT)) & MRT_CHANNEL_STAT_INTFLAG_MASK)
#define MRT_CHANNEL_STAT_RUN_MASK (0x2U)
#define MRT_CHANNEL_STAT_RUN_SHIFT (1U)
/*! RUN - Indicates the state of TIMERn. This bit is read-only.
 *  0b0..Idle state. TIMERn is stopped.
 *  0b1..Running. TIMERn is running.
 */
#define MRT_CHANNEL_STAT_RUN(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_RUN_SHIFT)) & MRT_CHANNEL_STAT_RUN_MASK)
#define MRT_CHANNEL_STAT_INUSE_MASK (0x4U)
#define MRT_CHANNEL_STAT_INUSE_SHIFT (2U)
/*! INUSE - Channel In Use flag. Operating details depend on the MULTITASK bit in the MODCFG
 *    register, and affects the use of IDLE_CH. See Idle channel register for details of the two operating
 *    modes.
 *  0b0..This channel is not in use.
 *  0b1..This channel is in use.
 */
#define MRT_CHANNEL_STAT_INUSE(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_INUSE_SHIFT)) & MRT_CHANNEL_STAT_INUSE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_STAT */
#define MRT_CHANNEL_STAT_COUNT (4U)

/*! @name MODCFG - Module Configuration register. This register provides information about this particular MRT instance,
 * and allows choosing an overall mode for the idle channel feature. */
/*! @{ */
#define MRT_MODCFG_NOC_MASK (0xFU)
#define MRT_MODCFG_NOC_SHIFT (0U)
/*! NOC - Identifies the number of channels in this MRT.(4 channels on this device.)
 */
#define MRT_MODCFG_NOC(x) (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_NOC_SHIFT)) & MRT_MODCFG_NOC_MASK)
#define MRT_MODCFG_NOB_MASK (0x1F0U)
#define MRT_MODCFG_NOB_SHIFT (4U)
/*! NOB - Identifies the number of timer bits in this MRT. (24 bits wide on this device.)
 */
#define MRT_MODCFG_NOB(x) (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_NOB_SHIFT)) & MRT_MODCFG_NOB_MASK)
#define MRT_MODCFG_MULTITASK_MASK (0x80000000U)
#define MRT_MODCFG_MULTITASK_SHIFT (31U)
/*! MULTITASK - Selects the operating mode for the INUSE flags and the IDLE_CH register.
 *  0b0..Hardware status mode. In this mode, the INUSE(n) flags for all channels are reset.
 *  0b1..Multi-task mode.
 */
#define MRT_MODCFG_MULTITASK(x) \
    (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_MULTITASK_SHIFT)) & MRT_MODCFG_MULTITASK_MASK)
/*! @} */

/*! @name IDLE_CH - Idle channel register. This register returns the number of the first idle channel. */
/*! @{ */
#define MRT_IDLE_CH_CHAN_MASK (0xF0U)
#define MRT_IDLE_CH_CHAN_SHIFT (4U)
/*! CHAN - Idle channel. Reading the CHAN bits, returns the lowest idle timer channel. The number is
 *    positioned such that it can be used as an offset from the MRT base address in order to access
 *    the registers for the allocated channel. If all timer channels are running, CHAN = 0xF. See
 *    text above for more details.
 */
#define MRT_IDLE_CH_CHAN(x) (((uint32_t)(((uint32_t)(x)) << MRT_IDLE_CH_CHAN_SHIFT)) & MRT_IDLE_CH_CHAN_MASK)
/*! @} */

/*! @name IRQ_FLAG - Global interrupt flag register */
/*! @{ */
#define MRT_IRQ_FLAG_GFLAG0_MASK (0x1U)
#define MRT_IRQ_FLAG_GFLAG0_SHIFT (0U)
/*! GFLAG0 - Monitors the interrupt flag of TIMER0.
 *  0b0..No pending interrupt. Writing a zero is equivalent to no operation.
 *  0b1..Pending interrupt. The interrupt is pending because TIMER0 has reached the end of the time interval. If
 *       the INTEN bit in the CONTROL0 register is also set to 1, the interrupt for timer channel 0 and the global
 *       interrupt are raised. Writing a 1 to this bit clears the interrupt request.
 */
#define MRT_IRQ_FLAG_GFLAG0(x) (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG0_SHIFT)) & MRT_IRQ_FLAG_GFLAG0_MASK)
#define MRT_IRQ_FLAG_GFLAG1_MASK (0x2U)
#define MRT_IRQ_FLAG_GFLAG1_SHIFT (1U)
/*! GFLAG1 - Monitors the interrupt flag of TIMER1. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG1(x) (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG1_SHIFT)) & MRT_IRQ_FLAG_GFLAG1_MASK)
#define MRT_IRQ_FLAG_GFLAG2_MASK (0x4U)
#define MRT_IRQ_FLAG_GFLAG2_SHIFT (2U)
/*! GFLAG2 - Monitors the interrupt flag of TIMER2. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG2(x) (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG2_SHIFT)) & MRT_IRQ_FLAG_GFLAG2_MASK)
#define MRT_IRQ_FLAG_GFLAG3_MASK (0x8U)
#define MRT_IRQ_FLAG_GFLAG3_SHIFT (3U)
/*! GFLAG3 - Monitors the interrupt flag of TIMER3. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG3(x) (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG3_SHIFT)) & MRT_IRQ_FLAG_GFLAG3_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group MRT_Register_Masks */

/* MRT - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral MRT0 base address */
#define MRT0_BASE (0x5000D000u)
/** Peripheral MRT0 base address */
#define MRT0_BASE_NS (0x4000D000u)
/** Peripheral MRT0 base pointer */
#define MRT0 ((MRT_Type *)MRT0_BASE)
/** Peripheral MRT0 base pointer */
#define MRT0_NS ((MRT_Type *)MRT0_BASE_NS)
/** Array initializer of MRT peripheral base addresses */
#define MRT_BASE_ADDRS \
    {                  \
        MRT0_BASE      \
    }
/** Array initializer of MRT peripheral base pointers */
#define MRT_BASE_PTRS \
    {                 \
        MRT0          \
    }
/** Array initializer of MRT peripheral base addresses */
#define MRT_BASE_ADDRS_NS \
    {                     \
        MRT0_BASE_NS      \
    }
/** Array initializer of MRT peripheral base pointers */
#define MRT_BASE_PTRS_NS \
    {                    \
        MRT0_NS          \
    }
#else
/** Peripheral MRT0 base address */
#define MRT0_BASE (0x4000D000u)
/** Peripheral MRT0 base pointer */
#define MRT0 ((MRT_Type *)MRT0_BASE)
/** Array initializer of MRT peripheral base addresses */
#define MRT_BASE_ADDRS \
    {                  \
        MRT0_BASE      \
    }
/** Array initializer of MRT peripheral base pointers */
#define MRT_BASE_PTRS \
    {                 \
        MRT0          \
    }
#endif
/** Interrupt vectors for the MRT peripheral type */
#define MRT_IRQS  \
    {             \
        MRT0_IRQn \
    }

/*!
 * @}
 */ /* end of group MRT_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- OSTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSTIMER_Peripheral_Access_Layer OSTIMER Peripheral Access Layer
 * @{
 */

/** OSTIMER - Register Layout Typedef */
typedef struct
{
    __I uint32_t EVTIMERL;   /**< EVTIMER Low Register, offset: 0x0 */
    __I uint32_t EVTIMERH;   /**< EVTIMER High Register, offset: 0x4 */
    __I uint32_t CAPTUREN_L; /**< Local Capture Low Register for CPUn, offset: 0x8 */
    __I uint32_t CAPTUREN_H; /**< Local Capture High Register for CPUn, offset: 0xC */
    __IO uint32_t MATCHN_L;  /**< Local Match Low Register for CPUn, offset: 0x10 */
    __IO uint32_t MATCHN_H;  /**< Match High Register for CPUn, offset: 0x14 */
    uint8_t RESERVED_0[4];
    __IO uint32_t OSEVENT_CTRL; /**< OS_EVENT TIMER Control Register for CPUn, offset: 0x1C */
} OSTIMER_Type;

/* ----------------------------------------------------------------------------
   -- OSTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSTIMER_Register_Masks OSTIMER Register Masks
 * @{
 */

/*! @name EVTIMERL - EVTIMER Low Register */
/*! @{ */
#define OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_MASK (0xFFFFFFFFU)
#define OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_SHIFT (0U)
/*! EVTIMER_COUNT_VALUE - A read reflects the current value of the lower 32 bits of the EVTIMER.
 *    Note there is physically only one EVTimer, readable from all domains.
 */
#define OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_SHIFT)) & \
     OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_MASK)
/*! @} */

/*! @name EVTIMERH - EVTIMER High Register */
/*! @{ */
#define OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_MASK (0x3FFU)
#define OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_SHIFT (0U)
/*! EVTIMER_COUNT_VALUE - A read reflects the current value of the upper 32 bits of the EVTIMER.
 *    Note there is physically only one EVTimer, readable from all domains.
 */
#define OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_SHIFT)) & \
     OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_MASK)
/*! @} */

/*! @name CAPTUREN_L - Local Capture Low Register for CPUn */
/*! @{ */
#define OSTIMER_CAPTUREN_L_CAPTUREn_VALUE_MASK (0xFFFFFFFFU)
#define OSTIMER_CAPTUREN_L_CAPTUREn_VALUE_SHIFT (0U)
/*! CAPTUREn_VALUE - A read reflects the value of the lower 32 bits of the central EVTIMER at the
 *    time the last capture signal was generated by the CPU. A separate pair of CAPTURE registers are
 *    implemented for each CPU. Each CPU reads its own capture value at the same pair of addresses.
 */
#define OSTIMER_CAPTUREN_L_CAPTUREn_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_CAPTUREN_L_CAPTUREn_VALUE_SHIFT)) & OSTIMER_CAPTUREN_L_CAPTUREn_VALUE_MASK)
/*! @} */

/*! @name CAPTUREN_H - Local Capture High Register for CPUn */
/*! @{ */
#define OSTIMER_CAPTUREN_H_CAPTUREn_VALUE_MASK (0x3FFU)
#define OSTIMER_CAPTUREN_H_CAPTUREn_VALUE_SHIFT (0U)
/*! CAPTUREn_VALUE - A read reflects the value of the upper 32 bits of the central EVTIMER at the
 *    time the last capture signal was generated by the CPU. A separate pair of CAPTURE registers are
 *    implemented for each CPU. Each CPU reads its own capture value at the same pair of addresses.
 */
#define OSTIMER_CAPTUREN_H_CAPTUREn_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_CAPTUREN_H_CAPTUREn_VALUE_SHIFT)) & OSTIMER_CAPTUREN_H_CAPTUREn_VALUE_MASK)
/*! @} */

/*! @name MATCHN_L - Local Match Low Register for CPUn */
/*! @{ */
#define OSTIMER_MATCHN_L_MATCHn_VALUE_MASK (0xFFFFFFFFU)
#define OSTIMER_MATCHN_L_MATCHn_VALUE_SHIFT (0U)
/*! MATCHn_VALUE - The value written to the MATCH (L/H) register pair is compared against the
 *    central EVTIMER. When a match occurs, an interrupt request is generated if enabled. A separate pair
 *    of MATCH registers are implemented for each CPU. Each CPU reads its own local value at the
 *    same pair of addresses.
 */
#define OSTIMER_MATCHN_L_MATCHn_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_MATCHN_L_MATCHn_VALUE_SHIFT)) & OSTIMER_MATCHN_L_MATCHn_VALUE_MASK)
/*! @} */

/*! @name MATCHN_H - Match High Register for CPUn */
/*! @{ */
#define OSTIMER_MATCHN_H_MATCHn_VALUE_MASK (0x3FFU)
#define OSTIMER_MATCHN_H_MATCHn_VALUE_SHIFT (0U)
/*! MATCHn_VALUE - The value written to the MATCH (L/H) register pair is compared against the
 *    central EVTIMER. When a match occurs, an interrupt request is generated if enabled. A separate pair
 *    of MATCH registers are implemented for each CPU. Each CPU reads its own local value at the
 *    same pair of addresses.
 */
#define OSTIMER_MATCHN_H_MATCHn_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_MATCHN_H_MATCHn_VALUE_SHIFT)) & OSTIMER_MATCHN_H_MATCHn_VALUE_MASK)
/*! @} */

/*! @name OSEVENT_CTRL - OS_EVENT TIMER Control Register for CPUn */
/*! @{ */
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_MASK (0x1U)
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_SHIFT (0U)
/*! OSTIMER_INTRFLAG - This bit is set when a match occurs between the central 64-bit EVTIMER and
 *    the value programmed in the Match-register pair for the associated CPU This bit is cleared by
 *    writing a '1'. Writes to clear this bit are asynchronous. This should be done before a new match
 *    value is written into the MATCH_L/H registers
 */
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_SHIFT)) & \
     OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_MASK)
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_MASK (0x2U)
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_SHIFT (1U)
/*! OSTIMER_INTENA - When this bit is '1' an interrupt/wakeup request to the Domainn processor will
 *    be asserted when the OSTIMER_INTR flag is set. When this bit is '0', interrupt/wakeup requests
 *    due to the OSTIMER_INTR flag are blocked.A separate OSEVENT_CTRL register is implemented for
 *    each CPU. Each CPU reads its own local value at the same address.
 */
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_SHIFT)) & \
     OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group OSTIMER_Register_Masks */

/* OSTIMER - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral OSTIMER base address */
#define OSTIMER_BASE (0x5002D000u)
/** Peripheral OSTIMER base address */
#define OSTIMER_BASE_NS (0x4002D000u)
/** Peripheral OSTIMER base pointer */
#define OSTIMER ((OSTIMER_Type *)OSTIMER_BASE)
/** Peripheral OSTIMER base pointer */
#define OSTIMER_NS ((OSTIMER_Type *)OSTIMER_BASE_NS)
/** Array initializer of OSTIMER peripheral base addresses */
#define OSTIMER_BASE_ADDRS \
    {                      \
        OSTIMER_BASE       \
    }
/** Array initializer of OSTIMER peripheral base pointers */
#define OSTIMER_BASE_PTRS \
    {                     \
        OSTIMER           \
    }
/** Array initializer of OSTIMER peripheral base addresses */
#define OSTIMER_BASE_ADDRS_NS \
    {                         \
        OSTIMER_BASE_NS       \
    }
/** Array initializer of OSTIMER peripheral base pointers */
#define OSTIMER_BASE_PTRS_NS \
    {                        \
        OSTIMER_NS           \
    }
#else
/** Peripheral OSTIMER base address */
#define OSTIMER_BASE (0x4002D000u)
/** Peripheral OSTIMER base pointer */
#define OSTIMER ((OSTIMER_Type *)OSTIMER_BASE)
/** Array initializer of OSTIMER peripheral base addresses */
#define OSTIMER_BASE_ADDRS \
    {                      \
        OSTIMER_BASE       \
    }
/** Array initializer of OSTIMER peripheral base pointers */
#define OSTIMER_BASE_PTRS \
    {                     \
        OSTIMER           \
    }
#endif
/** Interrupt vectors for the OSTIMER peripheral type */
#define OSTIMER_IRQS  \
    {                 \
        OS_EVENT_IRQn \
    }

/*!
 * @}
 */ /* end of group OSTIMER_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- PINT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PINT_Peripheral_Access_Layer PINT Peripheral Access Layer
 * @{
 */

/** PINT - Register Layout Typedef */
typedef struct
{
    __IO uint32_t ISEL;   /**< Pin Interrupt Mode register, offset: 0x0 */
    __IO uint32_t IENR;   /**< Pin interrupt level or rising edge interrupt enable register, offset: 0x4 */
    __O uint32_t SIENR;   /**< Pin interrupt level or rising edge interrupt set register, offset: 0x8 */
    __O uint32_t CIENR;   /**< Pin interrupt level (rising edge interrupt) clear register, offset: 0xC */
    __IO uint32_t IENF;   /**< Pin interrupt active level or falling edge interrupt enable register, offset: 0x10 */
    __O uint32_t SIENF;   /**< Pin interrupt active level or falling edge interrupt set register, offset: 0x14 */
    __O uint32_t CIENF;   /**< Pin interrupt active level or falling edge interrupt clear register, offset: 0x18 */
    __IO uint32_t RISE;   /**< Pin interrupt rising edge register, offset: 0x1C */
    __IO uint32_t FALL;   /**< Pin interrupt falling edge register, offset: 0x20 */
    __IO uint32_t IST;    /**< Pin interrupt status register, offset: 0x24 */
    __IO uint32_t PMCTRL; /**< Pattern match interrupt control register, offset: 0x28 */
    __IO uint32_t PMSRC;  /**< Pattern match interrupt bit-slice source register, offset: 0x2C */
    __IO uint32_t PMCFG;  /**< Pattern match interrupt bit slice configuration register, offset: 0x30 */
} PINT_Type;

/* ----------------------------------------------------------------------------
   -- PINT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PINT_Register_Masks PINT Register Masks
 * @{
 */

/*! @name ISEL - Pin Interrupt Mode register */
/*! @{ */
#define PINT_ISEL_PMODE_MASK (0xFFU)
#define PINT_ISEL_PMODE_SHIFT (0U)
/*! PMODE - Selects the interrupt mode for each pin interrupt. Bit n configures the pin interrupt
 *    selected in PINTSELn. 0 = Edge sensitive 1 = Level sensitive
 */
#define PINT_ISEL_PMODE(x) (((uint32_t)(((uint32_t)(x)) << PINT_ISEL_PMODE_SHIFT)) & PINT_ISEL_PMODE_MASK)
/*! @} */

/*! @name IENR - Pin interrupt level or rising edge interrupt enable register */
/*! @{ */
#define PINT_IENR_ENRL_MASK (0xFFU)
#define PINT_IENR_ENRL_SHIFT (0U)
/*! ENRL - Enables the rising edge or level interrupt for each pin interrupt. Bit n configures the
 *    pin interrupt selected in PINTSELn. 0 = Disable rising edge or level interrupt. 1 = Enable
 *    rising edge or level interrupt.
 */
#define PINT_IENR_ENRL(x) (((uint32_t)(((uint32_t)(x)) << PINT_IENR_ENRL_SHIFT)) & PINT_IENR_ENRL_MASK)
/*! @} */

/*! @name SIENR - Pin interrupt level or rising edge interrupt set register */
/*! @{ */
#define PINT_SIENR_SETENRL_MASK (0xFFU)
#define PINT_SIENR_SETENRL_SHIFT (0U)
/*! SETENRL - Ones written to this address set bits in the IENR, thus enabling interrupts. Bit n
 *    sets bit n in the IENR register. 0 = No operation. 1 = Enable rising edge or level interrupt.
 */
#define PINT_SIENR_SETENRL(x) (((uint32_t)(((uint32_t)(x)) << PINT_SIENR_SETENRL_SHIFT)) & PINT_SIENR_SETENRL_MASK)
/*! @} */

/*! @name CIENR - Pin interrupt level (rising edge interrupt) clear register */
/*! @{ */
#define PINT_CIENR_CENRL_MASK (0xFFU)
#define PINT_CIENR_CENRL_SHIFT (0U)
/*! CENRL - Ones written to this address clear bits in the IENR, thus disabling the interrupts. Bit
 *    n clears bit n in the IENR register. 0 = No operation. 1 = Disable rising edge or level
 *    interrupt.
 */
#define PINT_CIENR_CENRL(x) (((uint32_t)(((uint32_t)(x)) << PINT_CIENR_CENRL_SHIFT)) & PINT_CIENR_CENRL_MASK)
/*! @} */

/*! @name IENF - Pin interrupt active level or falling edge interrupt enable register */
/*! @{ */
#define PINT_IENF_ENAF_MASK (0xFFU)
#define PINT_IENF_ENAF_SHIFT (0U)
/*! ENAF - Enables the falling edge or configures the active level interrupt for each pin interrupt.
 *    Bit n configures the pin interrupt selected in PINTSELn. 0 = Disable falling edge interrupt
 *    or set active interrupt level LOW. 1 = Enable falling edge interrupt enabled or set active
 *    interrupt level HIGH.
 */
#define PINT_IENF_ENAF(x) (((uint32_t)(((uint32_t)(x)) << PINT_IENF_ENAF_SHIFT)) & PINT_IENF_ENAF_MASK)
/*! @} */

/*! @name SIENF - Pin interrupt active level or falling edge interrupt set register */
/*! @{ */
#define PINT_SIENF_SETENAF_MASK (0xFFU)
#define PINT_SIENF_SETENAF_SHIFT (0U)
/*! SETENAF - Ones written to this address set bits in the IENF, thus enabling interrupts. Bit n
 *    sets bit n in the IENF register. 0 = No operation. 1 = Select HIGH-active interrupt or enable
 *    falling edge interrupt.
 */
#define PINT_SIENF_SETENAF(x) (((uint32_t)(((uint32_t)(x)) << PINT_SIENF_SETENAF_SHIFT)) & PINT_SIENF_SETENAF_MASK)
/*! @} */

/*! @name CIENF - Pin interrupt active level or falling edge interrupt clear register */
/*! @{ */
#define PINT_CIENF_CENAF_MASK (0xFFU)
#define PINT_CIENF_CENAF_SHIFT (0U)
/*! CENAF - Ones written to this address clears bits in the IENF, thus disabling interrupts. Bit n
 *    clears bit n in the IENF register. 0 = No operation. 1 = LOW-active interrupt selected or
 *    falling edge interrupt disabled.
 */
#define PINT_CIENF_CENAF(x) (((uint32_t)(((uint32_t)(x)) << PINT_CIENF_CENAF_SHIFT)) & PINT_CIENF_CENAF_MASK)
/*! @} */

/*! @name RISE - Pin interrupt rising edge register */
/*! @{ */
#define PINT_RISE_RDET_MASK (0xFFU)
#define PINT_RISE_RDET_SHIFT (0U)
/*! RDET - Rising edge detect. Bit n detects the rising edge of the pin selected in PINTSELn. Read
 *    0: No rising edge has been detected on this pin since Reset or the last time a one was written
 *    to this bit. Write 0: no operation. Read 1: a rising edge has been detected since Reset or the
 *    last time a one was written to this bit. Write 1: clear rising edge detection for this pin.
 */
#define PINT_RISE_RDET(x) (((uint32_t)(((uint32_t)(x)) << PINT_RISE_RDET_SHIFT)) & PINT_RISE_RDET_MASK)
/*! @} */

/*! @name FALL - Pin interrupt falling edge register */
/*! @{ */
#define PINT_FALL_FDET_MASK (0xFFU)
#define PINT_FALL_FDET_SHIFT (0U)
/*! FDET - Falling edge detect. Bit n detects the falling edge of the pin selected in PINTSELn. Read
 *    0: No falling edge has been detected on this pin since Reset or the last time a one was
 *    written to this bit. Write 0: no operation. Read 1: a falling edge has been detected since Reset or
 *    the last time a one was written to this bit. Write 1: clear falling edge detection for this
 *    pin.
 */
#define PINT_FALL_FDET(x) (((uint32_t)(((uint32_t)(x)) << PINT_FALL_FDET_SHIFT)) & PINT_FALL_FDET_MASK)
/*! @} */

/*! @name IST - Pin interrupt status register */
/*! @{ */
#define PINT_IST_PSTAT_MASK (0xFFU)
#define PINT_IST_PSTAT_SHIFT (0U)
/*! PSTAT - Pin interrupt status. Bit n returns the status, clears the edge interrupt, or inverts
 *    the active level of the pin selected in PINTSELn. Read 0: interrupt is not being requested for
 *    this interrupt pin. Write 0: no operation. Read 1: interrupt is being requested for this
 *    interrupt pin. Write 1 (edge-sensitive): clear rising- and falling-edge detection for this pin.
 *    Write 1 (level-sensitive): switch the active level for this pin (in the IENF register).
 */
#define PINT_IST_PSTAT(x) (((uint32_t)(((uint32_t)(x)) << PINT_IST_PSTAT_SHIFT)) & PINT_IST_PSTAT_MASK)
/*! @} */

/*! @name PMCTRL - Pattern match interrupt control register */
/*! @{ */
#define PINT_PMCTRL_SEL_PMATCH_MASK (0x1U)
#define PINT_PMCTRL_SEL_PMATCH_SHIFT (0U)
/*! SEL_PMATCH - Specifies whether the 8 pin interrupts are controlled by the pin interrupt function or by the pattern
 * match function. 0b0..Pin interrupt. Interrupts are driven in response to the standard pin interrupt function.
 *  0b1..Pattern match. Interrupts are driven in response to pattern matches.
 */
#define PINT_PMCTRL_SEL_PMATCH(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_SEL_PMATCH_SHIFT)) & PINT_PMCTRL_SEL_PMATCH_MASK)
#define PINT_PMCTRL_ENA_RXEV_MASK (0x2U)
#define PINT_PMCTRL_ENA_RXEV_SHIFT (1U)
/*! ENA_RXEV - Enables the RXEV output to the CPU and/or to a GPIO output when the specified boolean expression
 * evaluates to true. 0b0..Disabled. RXEV output to the CPU is disabled. 0b1..Enabled. RXEV output to the CPU is
 * enabled.
 */
#define PINT_PMCTRL_ENA_RXEV(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_ENA_RXEV_SHIFT)) & PINT_PMCTRL_ENA_RXEV_MASK)
#define PINT_PMCTRL_PMAT_MASK (0xFF000000U)
#define PINT_PMCTRL_PMAT_SHIFT (24U)
/*! PMAT - This field displays the current state of pattern matches. A 1 in any bit of this field
 *    indicates that the corresponding product term is matched by the current state of the appropriate
 *    inputs.
 */
#define PINT_PMCTRL_PMAT(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_PMAT_SHIFT)) & PINT_PMCTRL_PMAT_MASK)
/*! @} */

/*! @name PMSRC - Pattern match interrupt bit-slice source register */
/*! @{ */
#define PINT_PMSRC_SRC0_MASK (0x700U)
#define PINT_PMSRC_SRC0_SHIFT (8U)
/*! SRC0 - Selects the input source for bit slice 0
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 0.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 0.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 0.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 0.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 0.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 0.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 0.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 0.
 */
#define PINT_PMSRC_SRC0(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC0_SHIFT)) & PINT_PMSRC_SRC0_MASK)
#define PINT_PMSRC_SRC1_MASK (0x3800U)
#define PINT_PMSRC_SRC1_SHIFT (11U)
/*! SRC1 - Selects the input source for bit slice 1
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 1.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 1.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 1.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 1.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 1.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 1.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 1.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 1.
 */
#define PINT_PMSRC_SRC1(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC1_SHIFT)) & PINT_PMSRC_SRC1_MASK)
#define PINT_PMSRC_SRC2_MASK (0x1C000U)
#define PINT_PMSRC_SRC2_SHIFT (14U)
/*! SRC2 - Selects the input source for bit slice 2
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 2.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 2.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 2.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 2.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 2.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 2.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 2.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 2.
 */
#define PINT_PMSRC_SRC2(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC2_SHIFT)) & PINT_PMSRC_SRC2_MASK)
#define PINT_PMSRC_SRC3_MASK (0xE0000U)
#define PINT_PMSRC_SRC3_SHIFT (17U)
/*! SRC3 - Selects the input source for bit slice 3
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 3.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 3.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 3.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 3.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 3.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 3.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 3.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 3.
 */
#define PINT_PMSRC_SRC3(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC3_SHIFT)) & PINT_PMSRC_SRC3_MASK)
#define PINT_PMSRC_SRC4_MASK (0x700000U)
#define PINT_PMSRC_SRC4_SHIFT (20U)
/*! SRC4 - Selects the input source for bit slice 4
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 4.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 4.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 4.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 4.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 4.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 4.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 4.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 4.
 */
#define PINT_PMSRC_SRC4(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC4_SHIFT)) & PINT_PMSRC_SRC4_MASK)
#define PINT_PMSRC_SRC5_MASK (0x3800000U)
#define PINT_PMSRC_SRC5_SHIFT (23U)
/*! SRC5 - Selects the input source for bit slice 5
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 5.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 5.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 5.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 5.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 5.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 5.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 5.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 5.
 */
#define PINT_PMSRC_SRC5(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC5_SHIFT)) & PINT_PMSRC_SRC5_MASK)
#define PINT_PMSRC_SRC6_MASK (0x1C000000U)
#define PINT_PMSRC_SRC6_SHIFT (26U)
/*! SRC6 - Selects the input source for bit slice 6
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 6.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 6.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 6.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 6.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 6.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 6.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 6.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 6.
 */
#define PINT_PMSRC_SRC6(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC6_SHIFT)) & PINT_PMSRC_SRC6_MASK)
#define PINT_PMSRC_SRC7_MASK (0xE0000000U)
#define PINT_PMSRC_SRC7_SHIFT (29U)
/*! SRC7 - Selects the input source for bit slice 7
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 7.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 7.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 7.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 7.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 7.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 7.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 7.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 7.
 */
#define PINT_PMSRC_SRC7(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC7_SHIFT)) & PINT_PMSRC_SRC7_MASK)
/*! @} */

/*! @name PMCFG - Pattern match interrupt bit slice configuration register */
/*! @{ */
#define PINT_PMCFG_PROD_ENDPTS0_MASK (0x1U)
#define PINT_PMCFG_PROD_ENDPTS0_SHIFT (0U)
/*! PROD_ENDPTS0 - Determines whether slice 0 is an endpoint.
 *  0b0..No effect. Slice 0 is not an endpoint.
 *  0b1..endpoint. Slice 0 is the endpoint of a product term (minterm). Pin interrupt 0 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS0(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS0_SHIFT)) & PINT_PMCFG_PROD_ENDPTS0_MASK)
#define PINT_PMCFG_PROD_ENDPTS1_MASK (0x2U)
#define PINT_PMCFG_PROD_ENDPTS1_SHIFT (1U)
/*! PROD_ENDPTS1 - Determines whether slice 1 is an endpoint.
 *  0b0..No effect. Slice 1 is not an endpoint.
 *  0b1..endpoint. Slice 1 is the endpoint of a product term (minterm). Pin interrupt 1 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS1(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS1_SHIFT)) & PINT_PMCFG_PROD_ENDPTS1_MASK)
#define PINT_PMCFG_PROD_ENDPTS2_MASK (0x4U)
#define PINT_PMCFG_PROD_ENDPTS2_SHIFT (2U)
/*! PROD_ENDPTS2 - Determines whether slice 2 is an endpoint.
 *  0b0..No effect. Slice 2 is not an endpoint.
 *  0b1..endpoint. Slice 2 is the endpoint of a product term (minterm). Pin interrupt 2 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS2(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS2_SHIFT)) & PINT_PMCFG_PROD_ENDPTS2_MASK)
#define PINT_PMCFG_PROD_ENDPTS3_MASK (0x8U)
#define PINT_PMCFG_PROD_ENDPTS3_SHIFT (3U)
/*! PROD_ENDPTS3 - Determines whether slice 3 is an endpoint.
 *  0b0..No effect. Slice 3 is not an endpoint.
 *  0b1..endpoint. Slice 3 is the endpoint of a product term (minterm). Pin interrupt 3 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS3(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS3_SHIFT)) & PINT_PMCFG_PROD_ENDPTS3_MASK)
#define PINT_PMCFG_PROD_ENDPTS4_MASK (0x10U)
#define PINT_PMCFG_PROD_ENDPTS4_SHIFT (4U)
/*! PROD_ENDPTS4 - Determines whether slice 4 is an endpoint.
 *  0b0..No effect. Slice 4 is not an endpoint.
 *  0b1..endpoint. Slice 4 is the endpoint of a product term (minterm). Pin interrupt 4 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS4(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS4_SHIFT)) & PINT_PMCFG_PROD_ENDPTS4_MASK)
#define PINT_PMCFG_PROD_ENDPTS5_MASK (0x20U)
#define PINT_PMCFG_PROD_ENDPTS5_SHIFT (5U)
/*! PROD_ENDPTS5 - Determines whether slice 5 is an endpoint.
 *  0b0..No effect. Slice 5 is not an endpoint.
 *  0b1..endpoint. Slice 5 is the endpoint of a product term (minterm). Pin interrupt 5 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS5(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS5_SHIFT)) & PINT_PMCFG_PROD_ENDPTS5_MASK)
#define PINT_PMCFG_PROD_ENDPTS6_MASK (0x40U)
#define PINT_PMCFG_PROD_ENDPTS6_SHIFT (6U)
/*! PROD_ENDPTS6 - Determines whether slice 6 is an endpoint.
 *  0b0..No effect. Slice 6 is not an endpoint.
 *  0b1..endpoint. Slice 6 is the endpoint of a product term (minterm). Pin interrupt 6 in the NVIC is raised if the
 * minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS6(x) \
    (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS6_SHIFT)) & PINT_PMCFG_PROD_ENDPTS6_MASK)
#define PINT_PMCFG_CFG0_MASK (0x700U)
#define PINT_PMCFG_CFG0_SHIFT (8U)
/*! CFG0 - Specifies the match contribution condition for bit slice 0.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG0(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG0_SHIFT)) & PINT_PMCFG_CFG0_MASK)
#define PINT_PMCFG_CFG1_MASK (0x3800U)
#define PINT_PMCFG_CFG1_SHIFT (11U)
/*! CFG1 - Specifies the match contribution condition for bit slice 1.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG1(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG1_SHIFT)) & PINT_PMCFG_CFG1_MASK)
#define PINT_PMCFG_CFG2_MASK (0x1C000U)
#define PINT_PMCFG_CFG2_SHIFT (14U)
/*! CFG2 - Specifies the match contribution condition for bit slice 2.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG2(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG2_SHIFT)) & PINT_PMCFG_CFG2_MASK)
#define PINT_PMCFG_CFG3_MASK (0xE0000U)
#define PINT_PMCFG_CFG3_SHIFT (17U)
/*! CFG3 - Specifies the match contribution condition for bit slice 3.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG3(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG3_SHIFT)) & PINT_PMCFG_CFG3_MASK)
#define PINT_PMCFG_CFG4_MASK (0x700000U)
#define PINT_PMCFG_CFG4_SHIFT (20U)
/*! CFG4 - Specifies the match contribution condition for bit slice 4.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG4(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG4_SHIFT)) & PINT_PMCFG_CFG4_MASK)
#define PINT_PMCFG_CFG5_MASK (0x3800000U)
#define PINT_PMCFG_CFG5_SHIFT (23U)
/*! CFG5 - Specifies the match contribution condition for bit slice 5.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG5(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG5_SHIFT)) & PINT_PMCFG_CFG5_MASK)
#define PINT_PMCFG_CFG6_MASK (0x1C000000U)
#define PINT_PMCFG_CFG6_SHIFT (26U)
/*! CFG6 - Specifies the match contribution condition for bit slice 6.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG6(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG6_SHIFT)) & PINT_PMCFG_CFG6_MASK)
#define PINT_PMCFG_CFG7_MASK (0xE0000000U)
#define PINT_PMCFG_CFG7_SHIFT (29U)
/*! CFG7 - Specifies the match contribution condition for bit slice 7.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit
 * slice in the PMSRC register. 0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG7(x) (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG7_SHIFT)) & PINT_PMCFG_CFG7_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group PINT_Register_Masks */

/* PINT - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral PINT base address */
#define PINT_BASE (0x50004000u)
/** Peripheral PINT base address */
#define PINT_BASE_NS (0x40004000u)
/** Peripheral PINT base pointer */
#define PINT ((PINT_Type *)PINT_BASE)
/** Peripheral PINT base pointer */
#define PINT_NS ((PINT_Type *)PINT_BASE_NS)
/** Peripheral SECPINT base address */
#define SECPINT_BASE (0x50005000u)
/** Peripheral SECPINT base address */
#define SECPINT_BASE_NS (0x40005000u)
/** Peripheral SECPINT base pointer */
#define SECPINT ((PINT_Type *)SECPINT_BASE)
/** Peripheral SECPINT base pointer */
#define SECPINT_NS ((PINT_Type *)SECPINT_BASE_NS)
/** Array initializer of PINT peripheral base addresses */
#define PINT_BASE_ADDRS         \
    {                           \
        PINT_BASE, SECPINT_BASE \
    }
/** Array initializer of PINT peripheral base pointers */
#define PINT_BASE_PTRS \
    {                  \
        PINT, SECPINT  \
    }
/** Array initializer of PINT peripheral base addresses */
#define PINT_BASE_ADDRS_NS            \
    {                                 \
        PINT_BASE_NS, SECPINT_BASE_NS \
    }
/** Array initializer of PINT peripheral base pointers */
#define PINT_BASE_PTRS_NS   \
    {                       \
        PINT_NS, SECPINT_NS \
    }
#else
/** Peripheral PINT base address */
#define PINT_BASE (0x40004000u)
/** Peripheral PINT base pointer */
#define PINT ((PINT_Type *)PINT_BASE)
/** Peripheral SECPINT base address */
#define SECPINT_BASE (0x40005000u)
/** Peripheral SECPINT base pointer */
#define SECPINT ((PINT_Type *)SECPINT_BASE)
/** Array initializer of PINT peripheral base addresses */
#define PINT_BASE_ADDRS         \
    {                           \
        PINT_BASE, SECPINT_BASE \
    }
/** Array initializer of PINT peripheral base pointers */
#define PINT_BASE_PTRS \
    {                  \
        PINT, SECPINT  \
    }
#endif
/** Interrupt vectors for the PINT peripheral type */
#define PINT_IRQS                                                                                                \
    {                                                                                                            \
        PIN_INT0_IRQn, PIN_INT1_IRQn, PIN_INT2_IRQn, PIN_INT3_IRQn, PIN_INT4_IRQn, PIN_INT5_IRQn, PIN_INT6_IRQn, \
            PIN_INT7_IRQn, SEC_GPIO_INT0_IRQ0_IRQn, SEC_GPIO_INT0_IRQ1_IRQn                                      \
    }

/*!
 * @}
 */ /* end of group PINT_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- PLU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PLU_Peripheral_Access_Layer PLU Peripheral Access Layer
 * @{
 */

/** PLU - Register Layout Typedef */
typedef struct
{
    struct
    {                             /* offset: 0x0, array step: 0x20 */
        __IO uint32_t INP_MUX[5]; /**< LUTn input x MUX, array offset: 0x0, array step: index*0x20, index2*0x4 */
        uint8_t RESERVED_0[12];
    } LUT[26];
    uint8_t RESERVED_0[1216];
    __IO uint32_t LUT_TRUTH[26]; /**< Specifies the Truth Table contents for LUT0..Specifies the Truth Table contents
                                    for LUT25, array offset: 0x800, array step: 0x4 */
    uint8_t RESERVED_1[152];
    __I uint32_t OUTPUTS;       /**< Provides the current state of the 8 designated PLU Outputs., offset: 0x900 */
    __IO uint32_t WAKEINT_CTRL; /**< Wakeup interrupt control for PLU, offset: 0x904 */
    uint8_t RESERVED_2[760];
    __IO uint32_t OUTPUT_MUX[8]; /**< Selects the source to be connected to PLU Output 0..Selects the source to be
                                    connected to PLU Output 7, array offset: 0xC00, array step: 0x4 */
} PLU_Type;

/* ----------------------------------------------------------------------------
   -- PLU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PLU_Register_Masks PLU Register Masks
 * @{
 */

/*! @name LUT_INP_MUX - LUTn input x MUX */
/*! @{ */
#define PLU_LUT_INP_MUX_LUTn_INPx_MASK (0x3FU)
#define PLU_LUT_INP_MUX_LUTn_INPx_SHIFT (0U)
/*! LUTn_INPx - Selects the input source to be connected to LUT25 input4. For each LUT, the slot
 *    associated with the output from LUTn itself is tied low.
 *  0b000000..The PLU primary inputs 0.
 *  0b000001..The PLU primary inputs 1.
 *  0b000010..The PLU primary inputs 2.
 *  0b000011..The PLU primary inputs 3.
 *  0b000100..The PLU primary inputs 4.
 *  0b000101..The PLU primary inputs 5.
 *  0b000110..The output of LUT0.
 *  0b000111..The output of LUT1.
 *  0b001000..The output of LUT2.
 *  0b001001..The output of LUT3.
 *  0b001010..The output of LUT4.
 *  0b001011..The output of LUT5.
 *  0b001100..The output of LUT6.
 *  0b001101..The output of LUT7.
 *  0b001110..The output of LUT8.
 *  0b001111..The output of LUT9.
 *  0b010000..The output of LUT10.
 *  0b010001..The output of LUT11.
 *  0b010010..The output of LUT12.
 *  0b010011..The output of LUT13.
 *  0b010100..The output of LUT14.
 *  0b010101..The output of LUT15.
 *  0b010110..The output of LUT16.
 *  0b010111..The output of LUT17.
 *  0b011000..The output of LUT18.
 *  0b011001..The output of LUT19.
 *  0b011010..The output of LUT20.
 *  0b011011..The output of LUT21.
 *  0b011100..The output of LUT22.
 *  0b011101..The output of LUT23.
 *  0b011110..The output of LUT24.
 *  0b011111..The output of LUT25.
 *  0b100000..state(0).
 *  0b100001..state(1).
 *  0b100010..state(2).
 *  0b100011..state(3).
 */
#define PLU_LUT_INP_MUX_LUTn_INPx(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_LUT_INP_MUX_LUTn_INPx_SHIFT)) & PLU_LUT_INP_MUX_LUTn_INPx_MASK)
/*! @} */

/* The count of PLU_LUT_INP_MUX */
#define PLU_LUT_INP_MUX_COUNT (26U)

/* The count of PLU_LUT_INP_MUX */
#define PLU_LUT_INP_MUX_COUNT2 (5U)

/*! @name LUT_TRUTH - Specifies the Truth Table contents for LUT0..Specifies the Truth Table contents for LUT25 */
/*! @{ */
#define PLU_LUT_TRUTH_LUTn_TRUTH_MASK (0xFFFFFFFFU)
#define PLU_LUT_TRUTH_LUTn_TRUTH_SHIFT (0U)
/*! LUTn_TRUTH - Specifies the Truth Table contents for LUT25..
 */
#define PLU_LUT_TRUTH_LUTn_TRUTH(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_LUT_TRUTH_LUTn_TRUTH_SHIFT)) & PLU_LUT_TRUTH_LUTn_TRUTH_MASK)
/*! @} */

/* The count of PLU_LUT_TRUTH */
#define PLU_LUT_TRUTH_COUNT (26U)

/*! @name OUTPUTS - Provides the current state of the 8 designated PLU Outputs. */
/*! @{ */
#define PLU_OUTPUTS_OUTPUT_STATE_MASK (0xFFU)
#define PLU_OUTPUTS_OUTPUT_STATE_SHIFT (0U)
/*! OUTPUT_STATE - Provides the current state of the 8 designated PLU Outputs..
 */
#define PLU_OUTPUTS_OUTPUT_STATE(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_OUTPUTS_OUTPUT_STATE_SHIFT)) & PLU_OUTPUTS_OUTPUT_STATE_MASK)
/*! @} */

/*! @name WAKEINT_CTRL - Wakeup interrupt control for PLU */
/*! @{ */
#define PLU_WAKEINT_CTRL_MASK_MASK (0xFFU)
#define PLU_WAKEINT_CTRL_MASK_SHIFT (0U)
/*! MASK - Interrupt mask (which of the 8 PLU Outputs contribute to interrupt)
 */
#define PLU_WAKEINT_CTRL_MASK(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_WAKEINT_CTRL_MASK_SHIFT)) & PLU_WAKEINT_CTRL_MASK_MASK)
#define PLU_WAKEINT_CTRL_FILTER_MODE_MASK (0x300U)
#define PLU_WAKEINT_CTRL_FILTER_MODE_SHIFT (8U)
/*! FILTER_MODE - control input of the PLU, add filtering for glitch.
 *  0b00..Bypass mode.
 *  0b01..Filter 1 clock period.
 *  0b10..Filter 2 clock period.
 *  0b11..Filter 3 clock period.
 */
#define PLU_WAKEINT_CTRL_FILTER_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_WAKEINT_CTRL_FILTER_MODE_SHIFT)) & PLU_WAKEINT_CTRL_FILTER_MODE_MASK)
#define PLU_WAKEINT_CTRL_FILTER_CLKSEL_MASK (0xC00U)
#define PLU_WAKEINT_CTRL_FILTER_CLKSEL_SHIFT (10U)
/*! FILTER_CLKSEL - hclk is divided by 2**filter_clksel.
 *  0b00..Selects the 1 MHz low-power oscillator as the filter clock.
 *  0b01..Selects the 12 Mhz FRO as the filter clock.
 *  0b10..Selects a third filter clock source, if provided.
 *  0b11..Reserved.
 */
#define PLU_WAKEINT_CTRL_FILTER_CLKSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_WAKEINT_CTRL_FILTER_CLKSEL_SHIFT)) & PLU_WAKEINT_CTRL_FILTER_CLKSEL_MASK)
#define PLU_WAKEINT_CTRL_LATCH_ENABLE_MASK (0x1000U)
#define PLU_WAKEINT_CTRL_LATCH_ENABLE_SHIFT (12U)
/*! LATCH_ENABLE - latch the interrupt , then can be cleared with next bit INTR_CLEAR
 */
#define PLU_WAKEINT_CTRL_LATCH_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_WAKEINT_CTRL_LATCH_ENABLE_SHIFT)) & PLU_WAKEINT_CTRL_LATCH_ENABLE_MASK)
#define PLU_WAKEINT_CTRL_INTR_CLEAR_MASK (0x2000U)
#define PLU_WAKEINT_CTRL_INTR_CLEAR_SHIFT (13U)
/*! INTR_CLEAR - Write to clear wakeint_latched
 */
#define PLU_WAKEINT_CTRL_INTR_CLEAR(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_WAKEINT_CTRL_INTR_CLEAR_SHIFT)) & PLU_WAKEINT_CTRL_INTR_CLEAR_MASK)
/*! @} */

/*! @name OUTPUT_MUX - Selects the source to be connected to PLU Output 0..Selects the source to be connected to PLU
 * Output 7 */
/*! @{ */
#define PLU_OUTPUT_MUX_OUTPUTn_MASK (0x1FU)
#define PLU_OUTPUT_MUX_OUTPUTn_SHIFT (0U)
/*! OUTPUTn - Selects the source to be connected to PLU Output 7.
 *  0b00000..The PLU output 0.
 *  0b00001..The PLU output 1.
 *  0b00010..The PLU output 2.
 *  0b00011..The PLU output 3.
 *  0b00100..The PLU output 4.
 *  0b00101..The PLU output 5.
 *  0b00110..The PLU output 6.
 *  0b00111..The PLU output 7.
 *  0b01000..The PLU output 8.
 *  0b01001..The PLU output 9.
 *  0b01010..The PLU output 10.
 *  0b01011..The PLU output 11.
 *  0b01100..The PLU output 12.
 *  0b01101..The PLU output 13.
 *  0b01110..The PLU output 14.
 *  0b01111..The PLU output 15.
 *  0b10000..The PLU output 16.
 *  0b10001..The PLU output 17.
 *  0b10010..The PLU output 18.
 *  0b10011..The PLU output 19.
 *  0b10100..The PLU output 20.
 *  0b10101..The PLU output 21.
 *  0b10110..The PLU output 22.
 *  0b10111..The PLU output 23.
 *  0b11000..The PLU output 24.
 *  0b11001..The PLU output 25.
 *  0b11010..state(0).
 *  0b11011..state(1).
 *  0b11100..state(2).
 *  0b11101..state(3).
 */
#define PLU_OUTPUT_MUX_OUTPUTn(x) \
    (((uint32_t)(((uint32_t)(x)) << PLU_OUTPUT_MUX_OUTPUTn_SHIFT)) & PLU_OUTPUT_MUX_OUTPUTn_MASK)
/*! @} */

/* The count of PLU_OUTPUT_MUX */
#define PLU_OUTPUT_MUX_COUNT (8U)

/*!
 * @}
 */ /* end of group PLU_Register_Masks */

/* PLU - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral PLU base address */
#define PLU_BASE (0x5003D000u)
/** Peripheral PLU base address */
#define PLU_BASE_NS (0x4003D000u)
/** Peripheral PLU base pointer */
#define PLU ((PLU_Type *)PLU_BASE)
/** Peripheral PLU base pointer */
#define PLU_NS ((PLU_Type *)PLU_BASE_NS)
/** Array initializer of PLU peripheral base addresses */
#define PLU_BASE_ADDRS \
    {                  \
        PLU_BASE       \
    }
/** Array initializer of PLU peripheral base pointers */
#define PLU_BASE_PTRS \
    {                 \
        PLU           \
    }
/** Array initializer of PLU peripheral base addresses */
#define PLU_BASE_ADDRS_NS \
    {                     \
        PLU_BASE_NS       \
    }
/** Array initializer of PLU peripheral base pointers */
#define PLU_BASE_PTRS_NS \
    {                    \
        PLU_NS           \
    }
#else
/** Peripheral PLU base address */
#define PLU_BASE (0x4003D000u)
/** Peripheral PLU base pointer */
#define PLU ((PLU_Type *)PLU_BASE)
/** Array initializer of PLU peripheral base addresses */
#define PLU_BASE_ADDRS \
    {                  \
        PLU_BASE       \
    }
/** Array initializer of PLU peripheral base pointers */
#define PLU_BASE_PTRS \
    {                 \
        PLU           \
    }
#endif

/*!
 * @}
 */ /* end of group PLU_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- PMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Peripheral_Access_Layer PMC Peripheral Access Layer
 * @{
 */

/** PMC - Register Layout Typedef */
typedef struct
{
    uint8_t RESERVED_0[8];
    __IO uint32_t RESETCTRL; /**< Reset Control [Reset by: PoR, Pin Reset, Brown Out Detectors Reset, Deep Power Down
                                Reset, Software Reset], offset: 0x8 */
    uint8_t RESERVED_1[36];
    __IO uint32_t BODVBAT; /**< VBAT Brown Out Dectector (BoD) control register [Reset by: PoR, Pin Reset, Software
                              Reset], offset: 0x30 */
    uint8_t RESERVED_2[28];
    __IO uint32_t COMP; /**< Analog Comparator control register [Reset by: PoR, Pin Reset, Brown Out Detectors Reset,
                           Deep Power Down Reset, Software Reset], offset: 0x50 */
    uint8_t RESERVED_3[20];
    __IO uint32_t WAKEIOCAUSE; /**< Allows to identify the Wake-up I/O source from Deep Power Down mode, offset: 0x68 */
    uint8_t RESERVED_4[8];
    __IO uint32_t
        STATUSCLK; /**< FRO and XTAL status register [Reset by: PoR, Brown Out Detectors Reset], offset: 0x74 */
    uint8_t RESERVED_5[12];
    __IO uint32_t AOREG1; /**< General purpose always on domain data storage [Reset by: PoR, Brown Out Detectors Reset],
                             offset: 0x84 */
    uint8_t RESERVED_6[16];
    __IO uint32_t RTCOSC32K; /**< RTC 1 KHZ and 1 Hz clocks source control register [Reset by: PoR, Brown Out Detectors
                                Reset], offset: 0x98 */
    __IO uint32_t OSTIMERr;  /**< OS Timer control register [Reset by: PoR, Brown Out Detectors Reset], offset: 0x9C */
    uint8_t RESERVED_7[24];
    __IO uint32_t PDRUNCFG0; /**< Controls the power to various analog blocks [Reset by: PoR, Pin Reset, Brown Out
                                Detectors Reset, Deep Power Down Reset, Software Reset], offset: 0xB8 */
    uint8_t RESERVED_8[4];
    __O uint32_t PDRUNCFGSET0; /**< Controls the power to various analog blocks [Reset by: PoR, Pin Reset, Brown Out
                                  Detectors Reset, Deep Power Down Reset, Software Reset], offset: 0xC0 */
    uint8_t RESERVED_9[4];
    __O uint32_t PDRUNCFGCLR0; /**< Controls the power to various analog blocks [Reset by: PoR, Pin Reset, Brown Out
                                  Detectors Reset, Deep Power Down Reset, Software Reset], offset: 0xC8 */
} PMC_Type;

/* ----------------------------------------------------------------------------
   -- PMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Masks PMC Register Masks
 * @{
 */

/*! @name RESETCTRL - Reset Control [Reset by: PoR, Pin Reset, Brown Out Detectors Reset, Deep Power Down Reset,
 * Software Reset] */
/*! @{ */
#define PMC_RESETCTRL_DPDWAKEUPRESETENABLE_MASK (0x1U)
#define PMC_RESETCTRL_DPDWAKEUPRESETENABLE_SHIFT (0U)
/*! DPDWAKEUPRESETENABLE - Wake-up from DEEP POWER DOWN reset event (either from wake up I/O or RTC or OS Event Timer).
 *  0b0..Reset event from DEEP POWER DOWN mode is disable.
 *  0b1..Reset event from DEEP POWER DOWN mode is enable.
 */
#define PMC_RESETCTRL_DPDWAKEUPRESETENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << PMC_RESETCTRL_DPDWAKEUPRESETENABLE_SHIFT)) & \
     PMC_RESETCTRL_DPDWAKEUPRESETENABLE_MASK)
#define PMC_RESETCTRL_BODVBATRESETENABLE_MASK (0x2U)
#define PMC_RESETCTRL_BODVBATRESETENABLE_SHIFT (1U)
/*! BODVBATRESETENABLE - BOD VBAT reset enable.
 *  0b0..BOD VBAT reset is disable.
 *  0b1..BOD VBAT reset is enable.
 */
#define PMC_RESETCTRL_BODVBATRESETENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RESETCTRL_BODVBATRESETENABLE_SHIFT)) & PMC_RESETCTRL_BODVBATRESETENABLE_MASK)
#define PMC_RESETCTRL_SWRRESETENABLE_MASK (0x8U)
#define PMC_RESETCTRL_SWRRESETENABLE_SHIFT (3U)
/*! SWRRESETENABLE - Software reset enable.
 *  0b0..Software reset is disable.
 *  0b1..Software reset is enable.
 */
#define PMC_RESETCTRL_SWRRESETENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RESETCTRL_SWRRESETENABLE_SHIFT)) & PMC_RESETCTRL_SWRRESETENABLE_MASK)
/*! @} */

/*! @name BODVBAT - VBAT Brown Out Dectector (BoD) control register [Reset by: PoR, Pin Reset, Software Reset] */
/*! @{ */
#define PMC_BODVBAT_TRIGLVL_MASK (0x1FU)
#define PMC_BODVBAT_TRIGLVL_SHIFT (0U)
/*! TRIGLVL - BoD trigger level.
 *  0b00000..1.00 V.
 *  0b00001..1.10 V.
 *  0b00010..1.20 V.
 *  0b00011..1.30 V.
 *  0b00100..1.40 V.
 *  0b00101..1.50 V.
 *  0b00110..1.60 V.
 *  0b00111..1.65 V.
 *  0b01000..1.70 V.
 *  0b01001..1.75 V.
 *  0b01010..1.80 V.
 *  0b01011..1.90 V.
 *  0b01100..2.00 V.
 *  0b01101..2.10 V.
 *  0b01110..2.20 V.
 *  0b01111..2.30 V.
 *  0b10000..2.40 V.
 *  0b10001..2.50 V.
 *  0b10010..2.60 V.
 *  0b10011..2.70 V.
 *  0b10100..2.806 V.
 *  0b10101..2.90 V.
 *  0b10110..3.00 V.
 *  0b10111..3.10 V.
 *  0b11000..3.20 V.
 *  0b11001..3.30 V.
 *  0b11010..3.30 V.
 *  0b11011..3.30 V.
 *  0b11100..3.30 V.
 *  0b11101..3.30 V.
 *  0b11110..3.30 V.
 *  0b11111..3.30 V.
 */
#define PMC_BODVBAT_TRIGLVL(x) (((uint32_t)(((uint32_t)(x)) << PMC_BODVBAT_TRIGLVL_SHIFT)) & PMC_BODVBAT_TRIGLVL_MASK)
#define PMC_BODVBAT_HYST_MASK (0x60U)
#define PMC_BODVBAT_HYST_SHIFT (5U)
/*! HYST - BoD Hysteresis control.
 *  0b00..25 mV.
 *  0b01..50 mV.
 *  0b10..75 mV.
 *  0b11..100 mV.
 */
#define PMC_BODVBAT_HYST(x) (((uint32_t)(((uint32_t)(x)) << PMC_BODVBAT_HYST_SHIFT)) & PMC_BODVBAT_HYST_MASK)
/*! @} */

/*! @name COMP - Analog Comparator control register [Reset by: PoR, Pin Reset, Brown Out Detectors Reset, Deep Power
 * Down Reset, Software Reset] */
/*! @{ */
#define PMC_COMP_HYST_MASK (0x2U)
#define PMC_COMP_HYST_SHIFT (1U)
/*! HYST - Hysteris when hyst = '1'.
 *  0b0..Hysteresis is disable.
 *  0b1..Hysteresis is enable.
 */
#define PMC_COMP_HYST(x) (((uint32_t)(((uint32_t)(x)) << PMC_COMP_HYST_SHIFT)) & PMC_COMP_HYST_MASK)
#define PMC_COMP_VREFINPUT_MASK (0x4U)
#define PMC_COMP_VREFINPUT_SHIFT (2U)
/*! VREFINPUT - Dedicated control bit to select between internal VREF and VDDA (for the resistive ladder).
 *  0b0..Select internal VREF.
 *  0b1..Select VDDA.
 */
#define PMC_COMP_VREFINPUT(x) (((uint32_t)(((uint32_t)(x)) << PMC_COMP_VREFINPUT_SHIFT)) & PMC_COMP_VREFINPUT_MASK)
#define PMC_COMP_LOWPOWER_MASK (0x8U)
#define PMC_COMP_LOWPOWER_SHIFT (3U)
/*! LOWPOWER - Low power mode.
 *  0b0..High speed mode.
 *  0b1..Low power mode (Low speed).
 */
#define PMC_COMP_LOWPOWER(x) (((uint32_t)(((uint32_t)(x)) << PMC_COMP_LOWPOWER_SHIFT)) & PMC_COMP_LOWPOWER_MASK)
#define PMC_COMP_PMUX_MASK (0x70U)
#define PMC_COMP_PMUX_SHIFT (4U)
/*! PMUX - Control word for P multiplexer:.
 *  0b000..VREF (See fiedl VREFINPUT).
 *  0b001..Pin P0_0.
 *  0b010..Pin P0_9.
 *  0b011..Pin P0_18.
 *  0b100..Pin P1_14.
 *  0b101..Pin P2_23.
 */
#define PMC_COMP_PMUX(x) (((uint32_t)(((uint32_t)(x)) << PMC_COMP_PMUX_SHIFT)) & PMC_COMP_PMUX_MASK)
#define PMC_COMP_NMUX_MASK (0x380U)
#define PMC_COMP_NMUX_SHIFT (7U)
/*! NMUX - Control word for N multiplexer:.
 *  0b000..VREF (See field VREFINPUT).
 *  0b001..Pin P0_0.
 *  0b010..Pin P0_9.
 *  0b011..Pin P0_18.
 *  0b100..Pin P1_14.
 *  0b101..Pin P2_23.
 */
#define PMC_COMP_NMUX(x) (((uint32_t)(((uint32_t)(x)) << PMC_COMP_NMUX_SHIFT)) & PMC_COMP_NMUX_MASK)
#define PMC_COMP_VREF_MASK (0x7C00U)
#define PMC_COMP_VREF_SHIFT (10U)
/*! VREF - Control reference voltage step, per steps of (VREFINPUT/31).
 */
#define PMC_COMP_VREF(x) (((uint32_t)(((uint32_t)(x)) << PMC_COMP_VREF_SHIFT)) & PMC_COMP_VREF_MASK)
#define PMC_COMP_FILTERCGF_SAMPLEMODE_MASK (0x30000U)
#define PMC_COMP_FILTERCGF_SAMPLEMODE_SHIFT (16U)
/*! FILTERCGF_SAMPLEMODE - Control the filtering of the Analog Comparator output.
 *  0b00..Bypass mode.
 *  0b01..Filter 1 clock period.
 *  0b10..Filter 2 clock period.
 *  0b11..Filter 3 clock period.
 */
#define PMC_COMP_FILTERCGF_SAMPLEMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_COMP_FILTERCGF_SAMPLEMODE_SHIFT)) & PMC_COMP_FILTERCGF_SAMPLEMODE_MASK)
#define PMC_COMP_FILTERCGF_CLKDIV_MASK (0x1C0000U)
#define PMC_COMP_FILTERCGF_CLKDIV_SHIFT (18U)
/*! FILTERCGF_CLKDIV - Filter Clock divider.
 *  0b000..Filter clock period duration equals 1 Analog Comparator clock period.
 *  0b001..Filter clock period duration equals 2 Analog Comparator clock period.
 *  0b010..Filter clock period duration equals 4 Analog Comparator clock period.
 *  0b011..Filter clock period duration equals 8 Analog Comparator clock period.
 *  0b100..Filter clock period duration equals 16 Analog Comparator clock period.
 *  0b101..Filter clock period duration equals 32 Analog Comparator clock period.
 *  0b110..Filter clock period duration equals 64 Analog Comparator clock period.
 *  0b111..Filter clock period duration equals 128 Analog Comparator clock period.
 */
#define PMC_COMP_FILTERCGF_CLKDIV(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_COMP_FILTERCGF_CLKDIV_SHIFT)) & PMC_COMP_FILTERCGF_CLKDIV_MASK)
/*! @} */

/*! @name WAKEIOCAUSE - Allows to identify the Wake-up I/O source from Deep Power Down mode */
/*! @{ */
#define PMC_WAKEIOCAUSE_WAKEUP0_MASK (0x1U)
#define PMC_WAKEIOCAUSE_WAKEUP0_SHIFT (0U)
/*! WAKEUP0 - Allows to identify Wake up I/O 0 as the wake-up source from Deep Power Down mode.
 *  0b0..Last wake up from Deep Power down mode was NOT triggred by wake up I/O 0.
 *  0b1..Last wake up from Deep Power down mode was triggred by wake up I/O 0.
 */
#define PMC_WAKEIOCAUSE_WAKEUP0(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_WAKEIOCAUSE_WAKEUP0_SHIFT)) & PMC_WAKEIOCAUSE_WAKEUP0_MASK)
#define PMC_WAKEIOCAUSE_WAKEUP1_MASK (0x2U)
#define PMC_WAKEIOCAUSE_WAKEUP1_SHIFT (1U)
/*! WAKEUP1 - Allows to identify Wake up I/O 1 as the wake-up source from Deep Power Down mode.
 *  0b0..Last wake up from Deep Power down mode was NOT triggred by wake up I/O 1.
 *  0b1..Last wake up from Deep Power down mode was triggred by wake up I/O 1.
 */
#define PMC_WAKEIOCAUSE_WAKEUP1(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_WAKEIOCAUSE_WAKEUP1_SHIFT)) & PMC_WAKEIOCAUSE_WAKEUP1_MASK)
#define PMC_WAKEIOCAUSE_WAKEUP2_MASK (0x4U)
#define PMC_WAKEIOCAUSE_WAKEUP2_SHIFT (2U)
/*! WAKEUP2 - Allows to identify Wake up I/O 2 as the wake-up source from Deep Power Down mode.
 *  0b0..Last wake up from Deep Power down mode was NOT triggred by wake up I/O 2.
 *  0b1..Last wake up from Deep Power down mode was triggred by wake up I/O 2.
 */
#define PMC_WAKEIOCAUSE_WAKEUP2(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_WAKEIOCAUSE_WAKEUP2_SHIFT)) & PMC_WAKEIOCAUSE_WAKEUP2_MASK)
#define PMC_WAKEIOCAUSE_WAKEUP3_MASK (0x8U)
#define PMC_WAKEIOCAUSE_WAKEUP3_SHIFT (3U)
/*! WAKEUP3 - Allows to identify Wake up I/O 3 as the wake-up source from Deep Power Down mode.
 *  0b0..Last wake up from Deep Power down mode was NOT triggred by wake up I/O 3.
 *  0b1..Last wake up from Deep Power down mode was triggred by wake up I/O 3.
 */
#define PMC_WAKEIOCAUSE_WAKEUP3(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_WAKEIOCAUSE_WAKEUP3_SHIFT)) & PMC_WAKEIOCAUSE_WAKEUP3_MASK)
/*! @} */

/*! @name STATUSCLK - FRO and XTAL status register [Reset by: PoR, Brown Out Detectors Reset] */
/*! @{ */
#define PMC_STATUSCLK_XTAL32KOK_MASK (0x1U)
#define PMC_STATUSCLK_XTAL32KOK_SHIFT (0U)
/*! XTAL32KOK - XTAL oscillator 32 K OK signal.
 */
#define PMC_STATUSCLK_XTAL32KOK(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_STATUSCLK_XTAL32KOK_SHIFT)) & PMC_STATUSCLK_XTAL32KOK_MASK)
#define PMC_STATUSCLK_XTAL32KOSCFAILURE_MASK (0x4U)
#define PMC_STATUSCLK_XTAL32KOSCFAILURE_SHIFT (2U)
/*! XTAL32KOSCFAILURE - XTAL32 KHZ oscillator oscillation failure detection indicator.
 *  0b0..No oscillation failure has been detetced since the last time this bit has been cleared..
 *  0b1..At least one oscillation failure has been detetced since the last time this bit has been cleared..
 */
#define PMC_STATUSCLK_XTAL32KOSCFAILURE(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_STATUSCLK_XTAL32KOSCFAILURE_SHIFT)) & PMC_STATUSCLK_XTAL32KOSCFAILURE_MASK)
/*! @} */

/*! @name AOREG1 - General purpose always on domain data storage [Reset by: PoR, Brown Out Detectors Reset] */
/*! @{ */
#define PMC_AOREG1_POR_MASK (0x10U)
#define PMC_AOREG1_POR_SHIFT (4U)
/*! POR - The last chip reset was caused by a Power On Reset.
 */
#define PMC_AOREG1_POR(x) (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_POR_SHIFT)) & PMC_AOREG1_POR_MASK)
#define PMC_AOREG1_PADRESET_MASK (0x20U)
#define PMC_AOREG1_PADRESET_SHIFT (5U)
/*! PADRESET - The last chip reset was caused by a Pin Reset.
 */
#define PMC_AOREG1_PADRESET(x) (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_PADRESET_SHIFT)) & PMC_AOREG1_PADRESET_MASK)
#define PMC_AOREG1_BODRESET_MASK (0x40U)
#define PMC_AOREG1_BODRESET_SHIFT (6U)
/*! BODRESET - The last chip reset was caused by a Brown Out Detector (BoD), either VBAT BoD or Core Logic BoD.
 */
#define PMC_AOREG1_BODRESET(x) (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_BODRESET_SHIFT)) & PMC_AOREG1_BODRESET_MASK)
#define PMC_AOREG1_SYSTEMRESET_MASK (0x80U)
#define PMC_AOREG1_SYSTEMRESET_SHIFT (7U)
/*! SYSTEMRESET - The last chip reset was caused by a System Reset requested by the ARM CPU.
 */
#define PMC_AOREG1_SYSTEMRESET(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_SYSTEMRESET_SHIFT)) & PMC_AOREG1_SYSTEMRESET_MASK)
#define PMC_AOREG1_WDTRESET_MASK (0x100U)
#define PMC_AOREG1_WDTRESET_SHIFT (8U)
/*! WDTRESET - The last chip reset was caused by the Watchdog Timer.
 */
#define PMC_AOREG1_WDTRESET(x) (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_WDTRESET_SHIFT)) & PMC_AOREG1_WDTRESET_MASK)
#define PMC_AOREG1_SWRRESET_MASK (0x200U)
#define PMC_AOREG1_SWRRESET_SHIFT (9U)
/*! SWRRESET - The last chip reset was caused by a Software event.
 */
#define PMC_AOREG1_SWRRESET(x) (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_SWRRESET_SHIFT)) & PMC_AOREG1_SWRRESET_MASK)
#define PMC_AOREG1_DPDRESET_WAKEUPIO_MASK (0x400U)
#define PMC_AOREG1_DPDRESET_WAKEUPIO_SHIFT (10U)
/*! DPDRESET_WAKEUPIO - The last chip reset was caused by a Wake-up I/O reset event during a Deep Power-Down mode.
 */
#define PMC_AOREG1_DPDRESET_WAKEUPIO(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_DPDRESET_WAKEUPIO_SHIFT)) & PMC_AOREG1_DPDRESET_WAKEUPIO_MASK)
#define PMC_AOREG1_DPDRESET_RTC_MASK (0x800U)
#define PMC_AOREG1_DPDRESET_RTC_SHIFT (11U)
/*! DPDRESET_RTC - The last chip reset was caused by an RTC (either RTC Alarm or RTC wake up) reset event during a Deep
 * Power-Down mode.
 */
#define PMC_AOREG1_DPDRESET_RTC(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_DPDRESET_RTC_SHIFT)) & PMC_AOREG1_DPDRESET_RTC_MASK)
#define PMC_AOREG1_DPDRESET_OSTIMER_MASK (0x1000U)
#define PMC_AOREG1_DPDRESET_OSTIMER_SHIFT (12U)
/*! DPDRESET_OSTIMER - The last chip reset was caused by an OS Event Timer reset event during a Deep Power-Down mode.
 */
#define PMC_AOREG1_DPDRESET_OSTIMER(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_DPDRESET_OSTIMER_SHIFT)) & PMC_AOREG1_DPDRESET_OSTIMER_MASK)
#define PMC_AOREG1_BOOTERRORCOUNTER_MASK (0xF0000U)
#define PMC_AOREG1_BOOTERRORCOUNTER_SHIFT (16U)
/*! BOOTERRORCOUNTER - ROM Boot Fatal Error Counter.
 */
#define PMC_AOREG1_BOOTERRORCOUNTER(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_AOREG1_BOOTERRORCOUNTER_SHIFT)) & PMC_AOREG1_BOOTERRORCOUNTER_MASK)
/*! @} */

/*! @name RTCOSC32K - RTC 1 KHZ and 1 Hz clocks source control register [Reset by: PoR, Brown Out Detectors Reset] */
/*! @{ */
#define PMC_RTCOSC32K_SEL_MASK (0x1U)
#define PMC_RTCOSC32K_SEL_SHIFT (0U)
/*! SEL - Select the 32K oscillator to be used in Deep Power Down Mode for the RTC (either XTAL32KHz or FRO32KHz) .
 *  0b0..FRO 32 KHz.
 *  0b1..XTAL 32KHz.
 */
#define PMC_RTCOSC32K_SEL(x) (((uint32_t)(((uint32_t)(x)) << PMC_RTCOSC32K_SEL_SHIFT)) & PMC_RTCOSC32K_SEL_MASK)
#define PMC_RTCOSC32K_CLK1KHZDIV_MASK (0xEU)
#define PMC_RTCOSC32K_CLK1KHZDIV_SHIFT (1U)
/*! CLK1KHZDIV - Actual division ratio is : 28 + CLK1KHZDIV.
 */
#define PMC_RTCOSC32K_CLK1KHZDIV(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RTCOSC32K_CLK1KHZDIV_SHIFT)) & PMC_RTCOSC32K_CLK1KHZDIV_MASK)
#define PMC_RTCOSC32K_CLK1KHZDIVUPDATEREQ_MASK (0x8000U)
#define PMC_RTCOSC32K_CLK1KHZDIVUPDATEREQ_SHIFT (15U)
/*! CLK1KHZDIVUPDATEREQ - RTC 1KHz clock Divider status flag.
 */
#define PMC_RTCOSC32K_CLK1KHZDIVUPDATEREQ(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RTCOSC32K_CLK1KHZDIVUPDATEREQ_SHIFT)) & PMC_RTCOSC32K_CLK1KHZDIVUPDATEREQ_MASK)
#define PMC_RTCOSC32K_CLK1HZDIV_MASK (0x7FF0000U)
#define PMC_RTCOSC32K_CLK1HZDIV_SHIFT (16U)
/*! CLK1HZDIV - Actual division ratio is : 31744 + CLK1HZDIV.
 */
#define PMC_RTCOSC32K_CLK1HZDIV(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RTCOSC32K_CLK1HZDIV_SHIFT)) & PMC_RTCOSC32K_CLK1HZDIV_MASK)
#define PMC_RTCOSC32K_CLK1HZDIVHALT_MASK (0x40000000U)
#define PMC_RTCOSC32K_CLK1HZDIVHALT_SHIFT (30U)
/*! CLK1HZDIVHALT - Halts the divider counter.
 */
#define PMC_RTCOSC32K_CLK1HZDIVHALT(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RTCOSC32K_CLK1HZDIVHALT_SHIFT)) & PMC_RTCOSC32K_CLK1HZDIVHALT_MASK)
#define PMC_RTCOSC32K_CLK1HZDIVUPDATEREQ_MASK (0x80000000U)
#define PMC_RTCOSC32K_CLK1HZDIVUPDATEREQ_SHIFT (31U)
/*! CLK1HZDIVUPDATEREQ - RTC 1Hz Divider status flag.
 */
#define PMC_RTCOSC32K_CLK1HZDIVUPDATEREQ(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_RTCOSC32K_CLK1HZDIVUPDATEREQ_SHIFT)) & PMC_RTCOSC32K_CLK1HZDIVUPDATEREQ_MASK)
/*! @} */

/*! @name OSTIMER - OS Timer control register [Reset by: PoR, Brown Out Detectors Reset] */
/*! @{ */
#define PMC_OSTIMER_SOFTRESET_MASK (0x1U)
#define PMC_OSTIMER_SOFTRESET_SHIFT (0U)
/*! SOFTRESET - Active high reset.
 */
#define PMC_OSTIMER_SOFTRESET(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_OSTIMER_SOFTRESET_SHIFT)) & PMC_OSTIMER_SOFTRESET_MASK)
#define PMC_OSTIMER_CLOCKENABLE_MASK (0x2U)
#define PMC_OSTIMER_CLOCKENABLE_SHIFT (1U)
/*! CLOCKENABLE - Enable OSTIMER 32 KHz clock.
 */
#define PMC_OSTIMER_CLOCKENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_OSTIMER_CLOCKENABLE_SHIFT)) & PMC_OSTIMER_CLOCKENABLE_MASK)
#define PMC_OSTIMER_DPDWAKEUPENABLE_MASK (0x4U)
#define PMC_OSTIMER_DPDWAKEUPENABLE_SHIFT (2U)
/*! DPDWAKEUPENABLE - Wake up enable in Deep Power Down mode (To be used in Enable Deep Power Down mode).
 */
#define PMC_OSTIMER_DPDWAKEUPENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_OSTIMER_DPDWAKEUPENABLE_SHIFT)) & PMC_OSTIMER_DPDWAKEUPENABLE_MASK)
#define PMC_OSTIMER_OSC32KPD_MASK (0x8U)
#define PMC_OSTIMER_OSC32KPD_SHIFT (3U)
/*! OSC32KPD - Oscilator 32KHz (either FRO32KHz or XTAL32KHz according to RTCOSC32K.
 */
#define PMC_OSTIMER_OSC32KPD(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_OSTIMER_OSC32KPD_SHIFT)) & PMC_OSTIMER_OSC32KPD_MASK)
/*! @} */

/*! @name PDRUNCFG0 - Controls the power to various analog blocks [Reset by: PoR, Pin Reset, Brown Out Detectors Reset,
 * Deep Power Down Reset, Software Reset] */
/*! @{ */
#define PMC_PDRUNCFG0_PDEN_BODVBAT_MASK (0x8U)
#define PMC_PDRUNCFG0_PDEN_BODVBAT_SHIFT (3U)
/*! PDEN_BODVBAT - Controls power to VBAT Brown Out Detector (BOD).
 *  0b0..BOD VBAT is powered.
 *  0b1..BOD VBAT is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_BODVBAT(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_BODVBAT_SHIFT)) & PMC_PDRUNCFG0_PDEN_BODVBAT_MASK)
#define PMC_PDRUNCFG0_PDEN_FRO32K_MASK (0x40U)
#define PMC_PDRUNCFG0_PDEN_FRO32K_SHIFT (6U)
/*! PDEN_FRO32K - Controls power to the Free Running Oscillator (FRO) 32 KHz.
 *  0b0..FRO32KHz is powered.
 *  0b1..FRO32KHz is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_FRO32K(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_FRO32K_SHIFT)) & PMC_PDRUNCFG0_PDEN_FRO32K_MASK)
#define PMC_PDRUNCFG0_PDEN_XTAL32K_MASK (0x80U)
#define PMC_PDRUNCFG0_PDEN_XTAL32K_SHIFT (7U)
/*! PDEN_XTAL32K - Controls power to crystal 32 KHz.
 *  0b0..Crystal 32KHz is powered.
 *  0b1..Crystal 32KHz is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_XTAL32K(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_XTAL32K_SHIFT)) & PMC_PDRUNCFG0_PDEN_XTAL32K_MASK)
#define PMC_PDRUNCFG0_PDEN_XTAL32M_MASK (0x100U)
#define PMC_PDRUNCFG0_PDEN_XTAL32M_SHIFT (8U)
/*! PDEN_XTAL32M - Controls power to crystal 32 MHz.
 *  0b0..Crystal 32MHz is powered.
 *  0b1..Crystal 32MHz is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_XTAL32M(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_XTAL32M_SHIFT)) & PMC_PDRUNCFG0_PDEN_XTAL32M_MASK)
#define PMC_PDRUNCFG0_PDEN_PLL0_MASK (0x200U)
#define PMC_PDRUNCFG0_PDEN_PLL0_SHIFT (9U)
/*! PDEN_PLL0 - Controls power to System PLL (also refered as PLL0).
 *  0b0..PLL0 is powered.
 *  0b1..PLL0 is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_PLL0(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_PLL0_SHIFT)) & PMC_PDRUNCFG0_PDEN_PLL0_MASK)
#define PMC_PDRUNCFG0_PDEN_PLL1_MASK (0x400U)
#define PMC_PDRUNCFG0_PDEN_PLL1_SHIFT (10U)
/*! PDEN_PLL1 - Controls power to USB PLL (also refered as PLL1).
 *  0b0..PLL1 is powered.
 *  0b1..PLL1 is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_PLL1(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_PLL1_SHIFT)) & PMC_PDRUNCFG0_PDEN_PLL1_MASK)
#define PMC_PDRUNCFG0_PDEN_USBFSPHY_MASK (0x800U)
#define PMC_PDRUNCFG0_PDEN_USBFSPHY_SHIFT (11U)
/*! PDEN_USBFSPHY - Controls power to USB Full Speed phy.
 *  0b0..USB Full Speed phy is powered.
 *  0b1..USB Full Speed phy is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_USBFSPHY(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_USBFSPHY_SHIFT)) & PMC_PDRUNCFG0_PDEN_USBFSPHY_MASK)
#define PMC_PDRUNCFG0_PDEN_USBHSPHY_MASK (0x1000U)
#define PMC_PDRUNCFG0_PDEN_USBHSPHY_SHIFT (12U)
/*! PDEN_USBHSPHY - Controls power to USB High Speed Phy.
 *  0b0..USB HS phy is powered.
 *  0b1..USB HS phy is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_USBHSPHY(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_USBHSPHY_SHIFT)) & PMC_PDRUNCFG0_PDEN_USBHSPHY_MASK)
#define PMC_PDRUNCFG0_PDEN_COMP_MASK (0x2000U)
#define PMC_PDRUNCFG0_PDEN_COMP_SHIFT (13U)
/*! PDEN_COMP - Controls power to Analog Comparator.
 *  0b0..Analog Comparator is powered.
 *  0b1..Analog Comparator is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_COMP(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_COMP_SHIFT)) & PMC_PDRUNCFG0_PDEN_COMP_MASK)
#define PMC_PDRUNCFG0_PDEN_LDOUSBHS_MASK (0x40000U)
#define PMC_PDRUNCFG0_PDEN_LDOUSBHS_SHIFT (18U)
/*! PDEN_LDOUSBHS - Controls power to USB high speed LDO.
 *  0b0..USB high speed LDO is powered.
 *  0b1..USB high speed LDO is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_LDOUSBHS(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_LDOUSBHS_SHIFT)) & PMC_PDRUNCFG0_PDEN_LDOUSBHS_MASK)
#define PMC_PDRUNCFG0_PDEN_AUXBIAS_MASK (0x80000U)
#define PMC_PDRUNCFG0_PDEN_AUXBIAS_SHIFT (19U)
/*! PDEN_AUXBIAS - Controls power to auxiliary biasing (AUXBIAS)
 *  0b0..auxiliary biasing is powered.
 *  0b1..auxiliary biasing is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_AUXBIAS(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_AUXBIAS_SHIFT)) & PMC_PDRUNCFG0_PDEN_AUXBIAS_MASK)
#define PMC_PDRUNCFG0_PDEN_LDOXO32M_MASK (0x100000U)
#define PMC_PDRUNCFG0_PDEN_LDOXO32M_SHIFT (20U)
/*! PDEN_LDOXO32M - Controls power to crystal 32 MHz LDO.
 *  0b0..crystal 32 MHz LDO is powered.
 *  0b1..crystal 32 MHz LDO is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_LDOXO32M(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_LDOXO32M_SHIFT)) & PMC_PDRUNCFG0_PDEN_LDOXO32M_MASK)
#define PMC_PDRUNCFG0_PDEN_RNG_MASK (0x400000U)
#define PMC_PDRUNCFG0_PDEN_RNG_SHIFT (22U)
/*! PDEN_RNG - Controls power to all True Random Number Genetaor (TRNG) clock sources.
 *  0b0..TRNG clocks are powered.
 *  0b1..TRNG clocks are powered down.
 */
#define PMC_PDRUNCFG0_PDEN_RNG(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_RNG_SHIFT)) & PMC_PDRUNCFG0_PDEN_RNG_MASK)
#define PMC_PDRUNCFG0_PDEN_PLL0_SSCG_MASK (0x800000U)
#define PMC_PDRUNCFG0_PDEN_PLL0_SSCG_SHIFT (23U)
/*! PDEN_PLL0_SSCG - Controls power to System PLL (PLL0) Spread Spectrum module.
 *  0b0..PLL0 Sread spectrum module is powered.
 *  0b1..PLL0 Sread spectrum module is powered down.
 */
#define PMC_PDRUNCFG0_PDEN_PLL0_SSCG(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFG0_PDEN_PLL0_SSCG_SHIFT)) & PMC_PDRUNCFG0_PDEN_PLL0_SSCG_MASK)
/*! @} */

/*! @name PDRUNCFGSET0 - Controls the power to various analog blocks [Reset by: PoR, Pin Reset, Brown Out Detectors
 * Reset, Deep Power Down Reset, Software Reset] */
/*! @{ */
#define PMC_PDRUNCFGSET0_PDRUNCFGSET0_MASK (0xFFFFFFFFU)
#define PMC_PDRUNCFGSET0_PDRUNCFGSET0_SHIFT (0U)
/*! PDRUNCFGSET0 - Writing ones to this register sets the corresponding bit or bits in the PDRUNCFG0 register, if they
 * are implemented.
 */
#define PMC_PDRUNCFGSET0_PDRUNCFGSET0(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFGSET0_PDRUNCFGSET0_SHIFT)) & PMC_PDRUNCFGSET0_PDRUNCFGSET0_MASK)
/*! @} */

/*! @name PDRUNCFGCLR0 - Controls the power to various analog blocks [Reset by: PoR, Pin Reset, Brown Out Detectors
 * Reset, Deep Power Down Reset, Software Reset] */
/*! @{ */
#define PMC_PDRUNCFGCLR0_PDRUNCFGCLR0_MASK (0xFFFFFFFFU)
#define PMC_PDRUNCFGCLR0_PDRUNCFGCLR0_SHIFT (0U)
/*! PDRUNCFGCLR0 - Writing ones to this register clears the corresponding bit or bits in the PDRUNCFG0 register, if they
 * are implemented.
 */
#define PMC_PDRUNCFGCLR0_PDRUNCFGCLR0(x) \
    (((uint32_t)(((uint32_t)(x)) << PMC_PDRUNCFGCLR0_PDRUNCFGCLR0_SHIFT)) & PMC_PDRUNCFGCLR0_PDRUNCFGCLR0_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group PMC_Register_Masks */

/* PMC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral PMC base address */
#define PMC_BASE (0x50020000u)
/** Peripheral PMC base address */
#define PMC_BASE_NS (0x40020000u)
/** Peripheral PMC base pointer */
#define PMC ((PMC_Type *)PMC_BASE)
/** Peripheral PMC base pointer */
#define PMC_NS ((PMC_Type *)PMC_BASE_NS)
/** Array initializer of PMC peripheral base addresses */
#define PMC_BASE_ADDRS \
    {                  \
        PMC_BASE       \
    }
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS \
    {                 \
        PMC           \
    }
/** Array initializer of PMC peripheral base addresses */
#define PMC_BASE_ADDRS_NS \
    {                     \
        PMC_BASE_NS       \
    }
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS_NS \
    {                    \
        PMC_NS           \
    }
#else
/** Peripheral PMC base address */
#define PMC_BASE (0x40020000u)
/** Peripheral PMC base pointer */
#define PMC ((PMC_Type *)PMC_BASE)
/** Array initializer of PMC peripheral base addresses */
#define PMC_BASE_ADDRS \
    {                  \
        PMC_BASE       \
    }
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS \
    {                 \
        PMC           \
    }
#endif

/*!
 * @}
 */ /* end of group PMC_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- POWERQUAD Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup POWERQUAD_Peripheral_Access_Layer POWERQUAD Peripheral Access Layer
 * @{
 */

/** POWERQUAD - Register Layout Typedef */
typedef struct
{
    __IO uint32_t OUTBASE;   /**< Base address register for output region, offset: 0x0 */
    __IO uint32_t OUTFORMAT; /**< Output format, offset: 0x4 */
    __IO uint32_t TMPBASE;   /**< Base address register for temp region, offset: 0x8 */
    __IO uint32_t TMPFORMAT; /**< Temp format, offset: 0xC */
    __IO uint32_t INABASE;   /**< Base address register for input A region, offset: 0x10 */
    __IO uint32_t INAFORMAT; /**< Input A format, offset: 0x14 */
    __IO uint32_t INBBASE;   /**< Base address register for input B region, offset: 0x18 */
    __IO uint32_t INBFORMAT; /**< Input B format, offset: 0x1C */
    uint8_t RESERVED_0[224];
    __IO uint32_t CONTROL; /**< PowerQuad Control register, offset: 0x100 */
    __IO uint32_t LENGTH;  /**< Length register, offset: 0x104 */
    __IO uint32_t CPPRE;   /**< Pre-scale register, offset: 0x108 */
    __IO uint32_t MISC;    /**< Misc register, offset: 0x10C */
    __IO uint32_t CURSORY; /**< Cursory register, offset: 0x110 */
    uint8_t RESERVED_1[108];
    __IO uint32_t CORDIC_X; /**< Cordic input X register, offset: 0x180 */
    __IO uint32_t CORDIC_Y; /**< Cordic input Y register, offset: 0x184 */
    __IO uint32_t CORDIC_Z; /**< Cordic input Z register, offset: 0x188 */
    __IO uint32_t ERRSTAT;  /**< Read/Write register where error statuses are captured (sticky), offset: 0x18C */
    __IO uint32_t INTREN;   /**< INTERRUPT enable register, offset: 0x190 */
    __IO uint32_t EVENTEN;  /**< Event Enable register, offset: 0x194 */
    __IO uint32_t INTRSTAT; /**< INTERRUPT STATUS register, offset: 0x198 */
    uint8_t RESERVED_2[100];
    __IO uint32_t GPREG[16];  /**< General purpose register bank N., array offset: 0x200, array step: 0x4 */
    __IO uint32_t COMPREG[8]; /**< Compute register bank, array offset: 0x240, array step: 0x4 */
} POWERQUAD_Type;

/* ----------------------------------------------------------------------------
   -- POWERQUAD Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup POWERQUAD_Register_Masks POWERQUAD Register Masks
 * @{
 */

/*! @name OUTBASE - Base address register for output region */
/*! @{ */
#define POWERQUAD_OUTBASE_OUTBASE_MASK (0xFFFFFFFFU)
#define POWERQUAD_OUTBASE_OUTBASE_SHIFT (0U)
/*! outbase - Base address register for the output region
 */
#define POWERQUAD_OUTBASE_OUTBASE(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_OUTBASE_OUTBASE_SHIFT)) & POWERQUAD_OUTBASE_OUTBASE_MASK)
/*! @} */

/*! @name OUTFORMAT - Output format */
/*! @{ */
#define POWERQUAD_OUTFORMAT_OUT_FORMATINT_MASK (0x3U)
#define POWERQUAD_OUTFORMAT_OUT_FORMATINT_SHIFT (0U)
/*! out_formatint - Output Internal format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_OUTFORMAT_OUT_FORMATINT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_OUTFORMAT_OUT_FORMATINT_SHIFT)) & POWERQUAD_OUTFORMAT_OUT_FORMATINT_MASK)
#define POWERQUAD_OUTFORMAT_OUT_FORMATEXT_MASK (0x30U)
#define POWERQUAD_OUTFORMAT_OUT_FORMATEXT_SHIFT (4U)
/*! out_formatext - Output External format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_OUTFORMAT_OUT_FORMATEXT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_OUTFORMAT_OUT_FORMATEXT_SHIFT)) & POWERQUAD_OUTFORMAT_OUT_FORMATEXT_MASK)
#define POWERQUAD_OUTFORMAT_OUT_SCALER_MASK (0xFF00U)
#define POWERQUAD_OUTFORMAT_OUT_SCALER_SHIFT (8U)
/*! out_scaler - Output Scaler value (for scaled 'q31' formats)
 */
#define POWERQUAD_OUTFORMAT_OUT_SCALER(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_OUTFORMAT_OUT_SCALER_SHIFT)) & POWERQUAD_OUTFORMAT_OUT_SCALER_MASK)
/*! @} */

/*! @name TMPBASE - Base address register for temp region */
/*! @{ */
#define POWERQUAD_TMPBASE_TMPBASE_MASK (0xFFFFFFFFU)
#define POWERQUAD_TMPBASE_TMPBASE_SHIFT (0U)
/*! tmpbase - Base address register for the temporary region
 */
#define POWERQUAD_TMPBASE_TMPBASE(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_TMPBASE_TMPBASE_SHIFT)) & POWERQUAD_TMPBASE_TMPBASE_MASK)
/*! @} */

/*! @name TMPFORMAT - Temp format */
/*! @{ */
#define POWERQUAD_TMPFORMAT_TMP_FORMATINT_MASK (0x3U)
#define POWERQUAD_TMPFORMAT_TMP_FORMATINT_SHIFT (0U)
/*! tmp_formatint - Temp Internal format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_TMPFORMAT_TMP_FORMATINT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_TMPFORMAT_TMP_FORMATINT_SHIFT)) & POWERQUAD_TMPFORMAT_TMP_FORMATINT_MASK)
#define POWERQUAD_TMPFORMAT_TMP_FORMATEXT_MASK (0x30U)
#define POWERQUAD_TMPFORMAT_TMP_FORMATEXT_SHIFT (4U)
/*! tmp_formatext - Temp External format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_TMPFORMAT_TMP_FORMATEXT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_TMPFORMAT_TMP_FORMATEXT_SHIFT)) & POWERQUAD_TMPFORMAT_TMP_FORMATEXT_MASK)
#define POWERQUAD_TMPFORMAT_TMP_SCALER_MASK (0xFF00U)
#define POWERQUAD_TMPFORMAT_TMP_SCALER_SHIFT (8U)
/*! tmp_scaler - Temp Scaler value (for scaled 'q31' formats)
 */
#define POWERQUAD_TMPFORMAT_TMP_SCALER(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_TMPFORMAT_TMP_SCALER_SHIFT)) & POWERQUAD_TMPFORMAT_TMP_SCALER_MASK)
/*! @} */

/*! @name INABASE - Base address register for input A region */
/*! @{ */
#define POWERQUAD_INABASE_INABASE_MASK (0xFFFFFFFFU)
#define POWERQUAD_INABASE_INABASE_SHIFT (0U)
/*! inabase - Base address register for the input A region
 */
#define POWERQUAD_INABASE_INABASE(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INABASE_INABASE_SHIFT)) & POWERQUAD_INABASE_INABASE_MASK)
/*! @} */

/*! @name INAFORMAT - Input A format */
/*! @{ */
#define POWERQUAD_INAFORMAT_INA_FORMATINT_MASK (0x3U)
#define POWERQUAD_INAFORMAT_INA_FORMATINT_SHIFT (0U)
/*! ina_formatint - Input A Internal format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_INAFORMAT_INA_FORMATINT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INAFORMAT_INA_FORMATINT_SHIFT)) & POWERQUAD_INAFORMAT_INA_FORMATINT_MASK)
#define POWERQUAD_INAFORMAT_INA_FORMATEXT_MASK (0x30U)
#define POWERQUAD_INAFORMAT_INA_FORMATEXT_SHIFT (4U)
/*! ina_formatext - Input A External format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_INAFORMAT_INA_FORMATEXT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INAFORMAT_INA_FORMATEXT_SHIFT)) & POWERQUAD_INAFORMAT_INA_FORMATEXT_MASK)
#define POWERQUAD_INAFORMAT_INA_SCALER_MASK (0xFF00U)
#define POWERQUAD_INAFORMAT_INA_SCALER_SHIFT (8U)
/*! ina_scaler - Input A Scaler value (for scaled 'q31' formats)
 */
#define POWERQUAD_INAFORMAT_INA_SCALER(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INAFORMAT_INA_SCALER_SHIFT)) & POWERQUAD_INAFORMAT_INA_SCALER_MASK)
/*! @} */

/*! @name INBBASE - Base address register for input B region */
/*! @{ */
#define POWERQUAD_INBBASE_INBBASE_MASK (0xFFFFFFFFU)
#define POWERQUAD_INBBASE_INBBASE_SHIFT (0U)
/*! inbbase - Base address register for the input B region
 */
#define POWERQUAD_INBBASE_INBBASE(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INBBASE_INBBASE_SHIFT)) & POWERQUAD_INBBASE_INBBASE_MASK)
/*! @} */

/*! @name INBFORMAT - Input B format */
/*! @{ */
#define POWERQUAD_INBFORMAT_INB_FORMATINT_MASK (0x3U)
#define POWERQUAD_INBFORMAT_INB_FORMATINT_SHIFT (0U)
/*! inb_formatint - Input B Internal format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_INBFORMAT_INB_FORMATINT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INBFORMAT_INB_FORMATINT_SHIFT)) & POWERQUAD_INBFORMAT_INB_FORMATINT_MASK)
#define POWERQUAD_INBFORMAT_INB_FORMATEXT_MASK (0x30U)
#define POWERQUAD_INBFORMAT_INB_FORMATEXT_SHIFT (4U)
/*! inb_formatext - Input B External format (00: q15; 01:q31; 10:float)
 */
#define POWERQUAD_INBFORMAT_INB_FORMATEXT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INBFORMAT_INB_FORMATEXT_SHIFT)) & POWERQUAD_INBFORMAT_INB_FORMATEXT_MASK)
#define POWERQUAD_INBFORMAT_INB_SCALER_MASK (0xFF00U)
#define POWERQUAD_INBFORMAT_INB_SCALER_SHIFT (8U)
/*! inb_scaler - Input B Scaler value (for scaled 'q31' formats)
 */
#define POWERQUAD_INBFORMAT_INB_SCALER(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INBFORMAT_INB_SCALER_SHIFT)) & POWERQUAD_INBFORMAT_INB_SCALER_MASK)
/*! @} */

/*! @name CONTROL - PowerQuad Control register */
/*! @{ */
#define POWERQUAD_CONTROL_DECODE_OPCODE_MASK (0xFU)
#define POWERQUAD_CONTROL_DECODE_OPCODE_SHIFT (0U)
/*! decode_opcode - opcode specific to decode_machine
 */
#define POWERQUAD_CONTROL_DECODE_OPCODE(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CONTROL_DECODE_OPCODE_SHIFT)) & POWERQUAD_CONTROL_DECODE_OPCODE_MASK)
#define POWERQUAD_CONTROL_DECODE_MACHINE_MASK (0xF0U)
#define POWERQUAD_CONTROL_DECODE_MACHINE_SHIFT (4U)
/*! decode_machine - 0 : Coprocessor , 1 : matrix , 2 : fft , 3 : fir , 4 : stat , 5 : cordic , 6 -15 : NA
 */
#define POWERQUAD_CONTROL_DECODE_MACHINE(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CONTROL_DECODE_MACHINE_SHIFT)) & POWERQUAD_CONTROL_DECODE_MACHINE_MASK)
#define POWERQUAD_CONTROL_INST_BUSY_MASK (0x80000000U)
#define POWERQUAD_CONTROL_INST_BUSY_SHIFT (31U)
/*! inst_busy - Instruction busy signal when high indicates processing is on
 */
#define POWERQUAD_CONTROL_INST_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CONTROL_INST_BUSY_SHIFT)) & POWERQUAD_CONTROL_INST_BUSY_MASK)
/*! @} */

/*! @name LENGTH - Length register */
/*! @{ */
#define POWERQUAD_LENGTH_INST_LENGTH_MASK (0xFFFFFFFFU)
#define POWERQUAD_LENGTH_INST_LENGTH_SHIFT (0U)
/*! inst_length - Length register. When FIR : fir_xlength = inst_length[15:0] , fir_tlength =
 *    inst_len[31:16]. When MTX : rows_a = inst_length[4:0] , cols_a = inst_length[12:8] , cols_b =
 *    inst_length[20:16]
 */
#define POWERQUAD_LENGTH_INST_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_LENGTH_INST_LENGTH_SHIFT)) & POWERQUAD_LENGTH_INST_LENGTH_MASK)
/*! @} */

/*! @name CPPRE - Pre-scale register */
/*! @{ */
#define POWERQUAD_CPPRE_CPPRE_IN_MASK (0xFFU)
#define POWERQUAD_CPPRE_CPPRE_IN_SHIFT (0U)
/*! cppre_in - co-processor scaling of input
 */
#define POWERQUAD_CPPRE_CPPRE_IN(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CPPRE_CPPRE_IN_SHIFT)) & POWERQUAD_CPPRE_CPPRE_IN_MASK)
#define POWERQUAD_CPPRE_CPPRE_OUT_MASK (0xFF00U)
#define POWERQUAD_CPPRE_CPPRE_OUT_SHIFT (8U)
/*! cppre_out - co-processor fixed point output
 */
#define POWERQUAD_CPPRE_CPPRE_OUT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CPPRE_CPPRE_OUT_SHIFT)) & POWERQUAD_CPPRE_CPPRE_OUT_MASK)
#define POWERQUAD_CPPRE_CPPRE_SAT_MASK (0x10000U)
#define POWERQUAD_CPPRE_CPPRE_SAT_SHIFT (16U)
/*! cppre_sat - 1 : forces sub-32 bit saturation
 */
#define POWERQUAD_CPPRE_CPPRE_SAT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CPPRE_CPPRE_SAT_SHIFT)) & POWERQUAD_CPPRE_CPPRE_SAT_MASK)
#define POWERQUAD_CPPRE_CPPRE_SAT8_MASK (0x20000U)
#define POWERQUAD_CPPRE_CPPRE_SAT8_SHIFT (17U)
/*! cppre_sat8 - 0 = 8bits, 1 = 16bits
 */
#define POWERQUAD_CPPRE_CPPRE_SAT8(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CPPRE_CPPRE_SAT8_SHIFT)) & POWERQUAD_CPPRE_CPPRE_SAT8_MASK)
/*! @} */

/*! @name MISC - Misc register */
/*! @{ */
#define POWERQUAD_MISC_INST_MISC_MASK (0xFFFFFFFFU)
#define POWERQUAD_MISC_INST_MISC_SHIFT (0U)
/*! inst_misc - Misc register. For Matrix : Used for scale factor
 */
#define POWERQUAD_MISC_INST_MISC(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_MISC_INST_MISC_SHIFT)) & POWERQUAD_MISC_INST_MISC_MASK)
/*! @} */

/*! @name CURSORY - Cursory register */
/*! @{ */
#define POWERQUAD_CURSORY_CURSORY_MASK (0x1U)
#define POWERQUAD_CURSORY_CURSORY_SHIFT (0U)
/*! cursory - 1 : Enable cursory mode
 */
#define POWERQUAD_CURSORY_CURSORY(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CURSORY_CURSORY_SHIFT)) & POWERQUAD_CURSORY_CURSORY_MASK)
/*! @} */

/*! @name CORDIC_X - Cordic input X register */
/*! @{ */
#define POWERQUAD_CORDIC_X_CORDIC_X_MASK (0xFFFFFFFFU)
#define POWERQUAD_CORDIC_X_CORDIC_X_SHIFT (0U)
/*! cordic_x - Cordic input x
 */
#define POWERQUAD_CORDIC_X_CORDIC_X(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CORDIC_X_CORDIC_X_SHIFT)) & POWERQUAD_CORDIC_X_CORDIC_X_MASK)
/*! @} */

/*! @name CORDIC_Y - Cordic input Y register */
/*! @{ */
#define POWERQUAD_CORDIC_Y_CORDIC_Y_MASK (0xFFFFFFFFU)
#define POWERQUAD_CORDIC_Y_CORDIC_Y_SHIFT (0U)
/*! cordic_y - Cordic input y
 */
#define POWERQUAD_CORDIC_Y_CORDIC_Y(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CORDIC_Y_CORDIC_Y_SHIFT)) & POWERQUAD_CORDIC_Y_CORDIC_Y_MASK)
/*! @} */

/*! @name CORDIC_Z - Cordic input Z register */
/*! @{ */
#define POWERQUAD_CORDIC_Z_CORDIC_Z_MASK (0xFFFFFFFFU)
#define POWERQUAD_CORDIC_Z_CORDIC_Z_SHIFT (0U)
/*! cordic_z - Cordic input z
 */
#define POWERQUAD_CORDIC_Z_CORDIC_Z(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_CORDIC_Z_CORDIC_Z_SHIFT)) & POWERQUAD_CORDIC_Z_CORDIC_Z_MASK)
/*! @} */

/*! @name ERRSTAT - Read/Write register where error statuses are captured (sticky) */
/*! @{ */
#define POWERQUAD_ERRSTAT_OVERFLOW_MASK (0x1U)
#define POWERQUAD_ERRSTAT_OVERFLOW_SHIFT (0U)
/*! OVERFLOW - overflow
 */
#define POWERQUAD_ERRSTAT_OVERFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_ERRSTAT_OVERFLOW_SHIFT)) & POWERQUAD_ERRSTAT_OVERFLOW_MASK)
#define POWERQUAD_ERRSTAT_NAN_MASK (0x2U)
#define POWERQUAD_ERRSTAT_NAN_SHIFT (1U)
/*! NAN - nan
 */
#define POWERQUAD_ERRSTAT_NAN(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_ERRSTAT_NAN_SHIFT)) & POWERQUAD_ERRSTAT_NAN_MASK)
#define POWERQUAD_ERRSTAT_FIXEDOVERFLOW_MASK (0x4U)
#define POWERQUAD_ERRSTAT_FIXEDOVERFLOW_SHIFT (2U)
/*! FIXEDOVERFLOW - fixed_pt_overflow
 */
#define POWERQUAD_ERRSTAT_FIXEDOVERFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_ERRSTAT_FIXEDOVERFLOW_SHIFT)) & POWERQUAD_ERRSTAT_FIXEDOVERFLOW_MASK)
#define POWERQUAD_ERRSTAT_UNDERFLOW_MASK (0x8U)
#define POWERQUAD_ERRSTAT_UNDERFLOW_SHIFT (3U)
/*! UNDERFLOW - underflow
 */
#define POWERQUAD_ERRSTAT_UNDERFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_ERRSTAT_UNDERFLOW_SHIFT)) & POWERQUAD_ERRSTAT_UNDERFLOW_MASK)
#define POWERQUAD_ERRSTAT_BUSERROR_MASK (0x10U)
#define POWERQUAD_ERRSTAT_BUSERROR_SHIFT (4U)
/*! BUSERROR - bus_error
 */
#define POWERQUAD_ERRSTAT_BUSERROR(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_ERRSTAT_BUSERROR_SHIFT)) & POWERQUAD_ERRSTAT_BUSERROR_MASK)
/*! @} */

/*! @name INTREN - INTERRUPT enable register */
/*! @{ */
#define POWERQUAD_INTREN_INTR_OFLOW_MASK (0x1U)
#define POWERQUAD_INTREN_INTR_OFLOW_SHIFT (0U)
/*! intr_oflow - 1 : Enable interrupt on Floating point overflow
 */
#define POWERQUAD_INTREN_INTR_OFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTREN_INTR_OFLOW_SHIFT)) & POWERQUAD_INTREN_INTR_OFLOW_MASK)
#define POWERQUAD_INTREN_INTR_NAN_MASK (0x2U)
#define POWERQUAD_INTREN_INTR_NAN_SHIFT (1U)
/*! intr_nan - 1 : Enable interrupt on Floating point NaN
 */
#define POWERQUAD_INTREN_INTR_NAN(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTREN_INTR_NAN_SHIFT)) & POWERQUAD_INTREN_INTR_NAN_MASK)
#define POWERQUAD_INTREN_INTR_FIXED_MASK (0x4U)
#define POWERQUAD_INTREN_INTR_FIXED_SHIFT (2U)
/*! intr_fixed - 1: Enable interrupt on Fixed point Overflow
 */
#define POWERQUAD_INTREN_INTR_FIXED(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTREN_INTR_FIXED_SHIFT)) & POWERQUAD_INTREN_INTR_FIXED_MASK)
#define POWERQUAD_INTREN_INTR_UFLOW_MASK (0x8U)
#define POWERQUAD_INTREN_INTR_UFLOW_SHIFT (3U)
/*! intr_uflow - 1 : Enable interrupt on Subnormal truncation
 */
#define POWERQUAD_INTREN_INTR_UFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTREN_INTR_UFLOW_SHIFT)) & POWERQUAD_INTREN_INTR_UFLOW_MASK)
#define POWERQUAD_INTREN_INTR_BERR_MASK (0x10U)
#define POWERQUAD_INTREN_INTR_BERR_SHIFT (4U)
/*! intr_berr - 1: Enable interrupt on AHBM Buss Error
 */
#define POWERQUAD_INTREN_INTR_BERR(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTREN_INTR_BERR_SHIFT)) & POWERQUAD_INTREN_INTR_BERR_MASK)
#define POWERQUAD_INTREN_INTR_COMP_MASK (0x80U)
#define POWERQUAD_INTREN_INTR_COMP_SHIFT (7U)
/*! intr_comp - 1: Enable interrupt on instruction completion
 */
#define POWERQUAD_INTREN_INTR_COMP(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTREN_INTR_COMP_SHIFT)) & POWERQUAD_INTREN_INTR_COMP_MASK)
/*! @} */

/*! @name EVENTEN - Event Enable register */
/*! @{ */
#define POWERQUAD_EVENTEN_EVENT_OFLOW_MASK (0x1U)
#define POWERQUAD_EVENTEN_EVENT_OFLOW_SHIFT (0U)
/*! event_oflow - 1 : Enable event trigger on Floating point overflow
 */
#define POWERQUAD_EVENTEN_EVENT_OFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_EVENTEN_EVENT_OFLOW_SHIFT)) & POWERQUAD_EVENTEN_EVENT_OFLOW_MASK)
#define POWERQUAD_EVENTEN_EVENT_NAN_MASK (0x2U)
#define POWERQUAD_EVENTEN_EVENT_NAN_SHIFT (1U)
/*! event_nan - 1 : Enable event trigger on Floating point NaN
 */
#define POWERQUAD_EVENTEN_EVENT_NAN(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_EVENTEN_EVENT_NAN_SHIFT)) & POWERQUAD_EVENTEN_EVENT_NAN_MASK)
#define POWERQUAD_EVENTEN_EVENT_FIXED_MASK (0x4U)
#define POWERQUAD_EVENTEN_EVENT_FIXED_SHIFT (2U)
/*! event_fixed - 1: Enable event trigger on Fixed point Overflow
 */
#define POWERQUAD_EVENTEN_EVENT_FIXED(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_EVENTEN_EVENT_FIXED_SHIFT)) & POWERQUAD_EVENTEN_EVENT_FIXED_MASK)
#define POWERQUAD_EVENTEN_EVENT_UFLOW_MASK (0x8U)
#define POWERQUAD_EVENTEN_EVENT_UFLOW_SHIFT (3U)
/*! event_uflow - 1 : Enable event trigger on Subnormal truncation
 */
#define POWERQUAD_EVENTEN_EVENT_UFLOW(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_EVENTEN_EVENT_UFLOW_SHIFT)) & POWERQUAD_EVENTEN_EVENT_UFLOW_MASK)
#define POWERQUAD_EVENTEN_EVENT_BERR_MASK (0x10U)
#define POWERQUAD_EVENTEN_EVENT_BERR_SHIFT (4U)
/*! event_berr - 1: Enable event trigger on AHBM Buss Error
 */
#define POWERQUAD_EVENTEN_EVENT_BERR(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_EVENTEN_EVENT_BERR_SHIFT)) & POWERQUAD_EVENTEN_EVENT_BERR_MASK)
#define POWERQUAD_EVENTEN_EVENT_COMP_MASK (0x80U)
#define POWERQUAD_EVENTEN_EVENT_COMP_SHIFT (7U)
/*! event_comp - 1: Enable event trigger on instruction completion
 */
#define POWERQUAD_EVENTEN_EVENT_COMP(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_EVENTEN_EVENT_COMP_SHIFT)) & POWERQUAD_EVENTEN_EVENT_COMP_MASK)
/*! @} */

/*! @name INTRSTAT - INTERRUPT STATUS register */
/*! @{ */
#define POWERQUAD_INTRSTAT_INTR_STAT_MASK (0x1U)
#define POWERQUAD_INTRSTAT_INTR_STAT_SHIFT (0U)
/*! intr_stat - Intr status ( 1 bit to indicate interrupt captured, 0 means no new interrupt), write any value will
 * clear this bit
 */
#define POWERQUAD_INTRSTAT_INTR_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_INTRSTAT_INTR_STAT_SHIFT)) & POWERQUAD_INTRSTAT_INTR_STAT_MASK)
/*! @} */

/*! @name GPREG - General purpose register bank N. */
/*! @{ */
#define POWERQUAD_GPREG_GPREG_MASK (0xFFFFFFFFU)
#define POWERQUAD_GPREG_GPREG_SHIFT (0U)
/*! gpreg - General purpose register bank
 */
#define POWERQUAD_GPREG_GPREG(x) \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_GPREG_GPREG_SHIFT)) & POWERQUAD_GPREG_GPREG_MASK)
/*! @} */

/* The count of POWERQUAD_GPREG */
#define POWERQUAD_GPREG_COUNT (16U)

/*! @name COMPREGS_COMPREG - Compute register bank */
/*! @{ */
#define POWERQUAD_COMPREGS_COMPREG_COMPREG_MASK (0xFFFFFFFFU)
#define POWERQUAD_COMPREGS_COMPREG_COMPREG_SHIFT (0U)
/*! compreg - Compute register bank
 */
#define POWERQUAD_COMPREGS_COMPREG_COMPREG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << POWERQUAD_COMPREGS_COMPREG_COMPREG_SHIFT)) & \
     POWERQUAD_COMPREGS_COMPREG_COMPREG_MASK)
/*! @} */

/* The count of POWERQUAD_COMPREGS_COMPREG */
#define POWERQUAD_COMPREGS_COMPREG_COUNT (8U)

/*!
 * @}
 */ /* end of group POWERQUAD_Register_Masks */

/* POWERQUAD - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral POWERQUAD base address */
#define POWERQUAD_BASE (0x500A6000u)
/** Peripheral POWERQUAD base address */
#define POWERQUAD_BASE_NS (0x400A6000u)
/** Peripheral POWERQUAD base pointer */
#define POWERQUAD ((POWERQUAD_Type *)POWERQUAD_BASE)
/** Peripheral POWERQUAD base pointer */
#define POWERQUAD_NS ((POWERQUAD_Type *)POWERQUAD_BASE_NS)
/** Array initializer of POWERQUAD peripheral base addresses */
#define POWERQUAD_BASE_ADDRS \
    {                        \
        POWERQUAD_BASE       \
    }
/** Array initializer of POWERQUAD peripheral base pointers */
#define POWERQUAD_BASE_PTRS \
    {                       \
        POWERQUAD           \
    }
/** Array initializer of POWERQUAD peripheral base addresses */
#define POWERQUAD_BASE_ADDRS_NS \
    {                           \
        POWERQUAD_BASE_NS       \
    }
/** Array initializer of POWERQUAD peripheral base pointers */
#define POWERQUAD_BASE_PTRS_NS \
    {                          \
        POWERQUAD_NS           \
    }
#else
/** Peripheral POWERQUAD base address */
#define POWERQUAD_BASE (0x400A6000u)
/** Peripheral POWERQUAD base pointer */
#define POWERQUAD ((POWERQUAD_Type *)POWERQUAD_BASE)
/** Array initializer of POWERQUAD peripheral base addresses */
#define POWERQUAD_BASE_ADDRS \
    {                        \
        POWERQUAD_BASE       \
    }
/** Array initializer of POWERQUAD peripheral base pointers */
#define POWERQUAD_BASE_PTRS \
    {                       \
        POWERQUAD           \
    }
#endif

/*!
 * @}
 */ /* end of group POWERQUAD_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- PRINCE Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PRINCE_Peripheral_Access_Layer PRINCE Peripheral Access Layer
 * @{
 */

/** PRINCE - Register Layout Typedef */
typedef struct
{
    __IO uint32_t ENC_ENABLE; /**< Encryption Enable register, offset: 0x0 */
    __O uint32_t MASK_LSB;    /**< Data Mask register, 32 Least Significant Bits, offset: 0x4 */
    __O uint32_t MASK_MSB;    /**< Data Mask register, 32 Most Significant Bits, offset: 0x8 */
    __IO uint32_t LOCK;       /**< Lock register, offset: 0xC */
    __O uint32_t IV_LSB0;     /**< Initial Vector register for region 0, Least Significant Bits, offset: 0x10 */
    __O uint32_t IV_MSB0;     /**< Initial Vector register for region 0, Most Significant Bits, offset: 0x14 */
    __IO uint32_t BASE_ADDR0; /**< Base Address for region 0 register, offset: 0x18 */
    __IO uint32_t SR_ENABLE0; /**< Sub-Region Enable register for region 0, offset: 0x1C */
    __O uint32_t IV_LSB1;     /**< Initial Vector register for region 1, Least Significant Bits, offset: 0x20 */
    __O uint32_t IV_MSB1;     /**< Initial Vector register for region 1, Most Significant Bits, offset: 0x24 */
    __IO uint32_t BASE_ADDR1; /**< Base Address for region 1 register, offset: 0x28 */
    __IO uint32_t SR_ENABLE1; /**< Sub-Region Enable register for region 1, offset: 0x2C */
    __O uint32_t IV_LSB2;     /**< Initial Vector register for region 2, Least Significant Bits, offset: 0x30 */
    __O uint32_t IV_MSB2;     /**< Initial Vector register for region 2, Most Significant Bits, offset: 0x34 */
    __IO uint32_t BASE_ADDR2; /**< Base Address for region 2 register, offset: 0x38 */
    __IO uint32_t SR_ENABLE2; /**< Sub-Region Enable register for region 2, offset: 0x3C */
} PRINCE_Type;

/* ----------------------------------------------------------------------------
   -- PRINCE Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PRINCE_Register_Masks PRINCE Register Masks
 * @{
 */

/*! @name ENC_ENABLE - Encryption Enable register */
/*! @{ */
#define PRINCE_ENC_ENABLE_EN_MASK (0x1U)
#define PRINCE_ENC_ENABLE_EN_SHIFT (0U)
/*! EN - Encryption Enable.
 *  0b0..Encryption of writes to the flash controller DATAW* registers is disabled.
 *  0b1..Encryption of writes to the flash controller DATAW* registers is enabled.
 */
#define PRINCE_ENC_ENABLE_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_ENC_ENABLE_EN_SHIFT)) & PRINCE_ENC_ENABLE_EN_MASK)
/*! @} */

/*! @name MASK_LSB - Data Mask register, 32 Least Significant Bits */
/*! @{ */
#define PRINCE_MASK_LSB_MASKVAL_MASK (0xFFFFFFFFU)
#define PRINCE_MASK_LSB_MASKVAL_SHIFT (0U)
/*! MASKVAL - Value of the 32 Least Significant Bits of the 64-bit data mask.
 */
#define PRINCE_MASK_LSB_MASKVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_MASK_LSB_MASKVAL_SHIFT)) & PRINCE_MASK_LSB_MASKVAL_MASK)
/*! @} */

/*! @name MASK_MSB - Data Mask register, 32 Most Significant Bits */
/*! @{ */
#define PRINCE_MASK_MSB_MASKVAL_MASK (0xFFFFFFFFU)
#define PRINCE_MASK_MSB_MASKVAL_SHIFT (0U)
/*! MASKVAL - Value of the 32 Most Significant Bits of the 64-bit data mask.
 */
#define PRINCE_MASK_MSB_MASKVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_MASK_MSB_MASKVAL_SHIFT)) & PRINCE_MASK_MSB_MASKVAL_MASK)
/*! @} */

/*! @name LOCK - Lock register */
/*! @{ */
#define PRINCE_LOCK_LOCKREG0_MASK (0x1U)
#define PRINCE_LOCK_LOCKREG0_SHIFT (0U)
/*! LOCKREG0 - Lock Region 0 registers.
 *  0b0..Disabled. IV_LSB0, IV_MSB0, BASE_ADDR0, and SR_ENABLE0 are writable..
 *  0b1..Enabled. IV_LSB0, IV_MSB0, BASE_ADDR0, and SR_ENABLE0 are not writable..
 */
#define PRINCE_LOCK_LOCKREG0(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_LOCK_LOCKREG0_SHIFT)) & PRINCE_LOCK_LOCKREG0_MASK)
#define PRINCE_LOCK_LOCKREG1_MASK (0x2U)
#define PRINCE_LOCK_LOCKREG1_SHIFT (1U)
/*! LOCKREG1 - Lock Region 1 registers.
 *  0b0..Disabled. IV_LSB1, IV_MSB1, BASE_ADDR1, and SR_ENABLE1 are writable..
 *  0b1..Enabled. IV_LSB1, IV_MSB1, BASE_ADDR1, and SR_ENABLE1 are not writable..
 */
#define PRINCE_LOCK_LOCKREG1(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_LOCK_LOCKREG1_SHIFT)) & PRINCE_LOCK_LOCKREG1_MASK)
#define PRINCE_LOCK_LOCKREG2_MASK (0x4U)
#define PRINCE_LOCK_LOCKREG2_SHIFT (2U)
/*! LOCKREG2 - Lock Region 2 registers.
 *  0b0..Disabled. IV_LSB2, IV_MSB2, BASE_ADDR2, and SR_ENABLE2 are writable..
 *  0b1..Enabled. IV_LSB2, IV_MSB2, BASE_ADDR2, and SR_ENABLE2 are not writable..
 */
#define PRINCE_LOCK_LOCKREG2(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_LOCK_LOCKREG2_SHIFT)) & PRINCE_LOCK_LOCKREG2_MASK)
#define PRINCE_LOCK_LOCKMASK_MASK (0x100U)
#define PRINCE_LOCK_LOCKMASK_SHIFT (8U)
/*! LOCKMASK - Lock the Mask registers.
 *  0b0..Disabled. MASK_LSB, and MASK_MSB are writable..
 *  0b1..Enabled. MASK_LSB, and MASK_MSB are not writable..
 */
#define PRINCE_LOCK_LOCKMASK(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_LOCK_LOCKMASK_SHIFT)) & PRINCE_LOCK_LOCKMASK_MASK)
/*! @} */

/*! @name IV_LSB0 - Initial Vector register for region 0, Least Significant Bits */
/*! @{ */
#define PRINCE_IV_LSB0_IVVAL_MASK (0xFFFFFFFFU)
#define PRINCE_IV_LSB0_IVVAL_SHIFT (0U)
/*! IVVAL - Initial Vector value for the 32 Least Significant Bits of the 64-bit Initial Vector.
 */
#define PRINCE_IV_LSB0_IVVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_IV_LSB0_IVVAL_SHIFT)) & PRINCE_IV_LSB0_IVVAL_MASK)
/*! @} */

/*! @name IV_MSB0 - Initial Vector register for region 0, Most Significant Bits */
/*! @{ */
#define PRINCE_IV_MSB0_IVVAL_MASK (0xFFFFFFFFU)
#define PRINCE_IV_MSB0_IVVAL_SHIFT (0U)
/*! IVVAL - Initial Vector value for the 32 Most Significant Bits of the 64-bit Initial Vector.
 */
#define PRINCE_IV_MSB0_IVVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_IV_MSB0_IVVAL_SHIFT)) & PRINCE_IV_MSB0_IVVAL_MASK)
/*! @} */

/*! @name BASE_ADDR0 - Base Address for region 0 register */
/*! @{ */
#define PRINCE_BASE_ADDR0_ADDR_FIXED_MASK (0x3FFFFU)
#define PRINCE_BASE_ADDR0_ADDR_FIXED_SHIFT (0U)
/*! ADDR_FIXED - Fixed portion of the base address of region 0.
 */
#define PRINCE_BASE_ADDR0_ADDR_FIXED(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_BASE_ADDR0_ADDR_FIXED_SHIFT)) & PRINCE_BASE_ADDR0_ADDR_FIXED_MASK)
#define PRINCE_BASE_ADDR0_ADDR_PRG_MASK (0xC0000U)
#define PRINCE_BASE_ADDR0_ADDR_PRG_SHIFT (18U)
/*! ADDR_PRG - Programmable portion of the base address of region 0.
 */
#define PRINCE_BASE_ADDR0_ADDR_PRG(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_BASE_ADDR0_ADDR_PRG_SHIFT)) & PRINCE_BASE_ADDR0_ADDR_PRG_MASK)
/*! @} */

/*! @name SR_ENABLE0 - Sub-Region Enable register for region 0 */
/*! @{ */
#define PRINCE_SR_ENABLE0_EN_MASK (0xFFFFFFFFU)
#define PRINCE_SR_ENABLE0_EN_SHIFT (0U)
/*! EN - Each bit in this field enables an 8KB subregion for encryption at offset 8KB*bitnum of region 0.
 */
#define PRINCE_SR_ENABLE0_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_SR_ENABLE0_EN_SHIFT)) & PRINCE_SR_ENABLE0_EN_MASK)
/*! @} */

/*! @name IV_LSB1 - Initial Vector register for region 1, Least Significant Bits */
/*! @{ */
#define PRINCE_IV_LSB1_IVVAL_MASK (0xFFFFFFFFU)
#define PRINCE_IV_LSB1_IVVAL_SHIFT (0U)
/*! IVVAL - Initial Vector value for the 32 Least Significant Bits of the 64-bit Initial Vector.
 */
#define PRINCE_IV_LSB1_IVVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_IV_LSB1_IVVAL_SHIFT)) & PRINCE_IV_LSB1_IVVAL_MASK)
/*! @} */

/*! @name IV_MSB1 - Initial Vector register for region 1, Most Significant Bits */
/*! @{ */
#define PRINCE_IV_MSB1_IVVAL_MASK (0xFFFFFFFFU)
#define PRINCE_IV_MSB1_IVVAL_SHIFT (0U)
/*! IVVAL - Initial Vector value for the 32 Most Significant Bits of the 64-bit Initial Vector.
 */
#define PRINCE_IV_MSB1_IVVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_IV_MSB1_IVVAL_SHIFT)) & PRINCE_IV_MSB1_IVVAL_MASK)
/*! @} */

/*! @name BASE_ADDR1 - Base Address for region 1 register */
/*! @{ */
#define PRINCE_BASE_ADDR1_ADDR_FIXED_MASK (0x3FFFFU)
#define PRINCE_BASE_ADDR1_ADDR_FIXED_SHIFT (0U)
/*! ADDR_FIXED - Fixed portion of the base address of region 1.
 */
#define PRINCE_BASE_ADDR1_ADDR_FIXED(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_BASE_ADDR1_ADDR_FIXED_SHIFT)) & PRINCE_BASE_ADDR1_ADDR_FIXED_MASK)
#define PRINCE_BASE_ADDR1_ADDR_PRG_MASK (0xC0000U)
#define PRINCE_BASE_ADDR1_ADDR_PRG_SHIFT (18U)
/*! ADDR_PRG - Programmable portion of the base address of region 1.
 */
#define PRINCE_BASE_ADDR1_ADDR_PRG(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_BASE_ADDR1_ADDR_PRG_SHIFT)) & PRINCE_BASE_ADDR1_ADDR_PRG_MASK)
/*! @} */

/*! @name SR_ENABLE1 - Sub-Region Enable register for region 1 */
/*! @{ */
#define PRINCE_SR_ENABLE1_EN_MASK (0xFFFFFFFFU)
#define PRINCE_SR_ENABLE1_EN_SHIFT (0U)
/*! EN - Each bit in this field enables an 8KB subregion for encryption at offset 8KB*bitnum of region 1.
 */
#define PRINCE_SR_ENABLE1_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_SR_ENABLE1_EN_SHIFT)) & PRINCE_SR_ENABLE1_EN_MASK)
/*! @} */

/*! @name IV_LSB2 - Initial Vector register for region 2, Least Significant Bits */
/*! @{ */
#define PRINCE_IV_LSB2_IVVAL_MASK (0xFFFFFFFFU)
#define PRINCE_IV_LSB2_IVVAL_SHIFT (0U)
/*! IVVAL - Initial Vector value for the 32 Least Significant Bits of the 64-bit Initial Vector.
 */
#define PRINCE_IV_LSB2_IVVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_IV_LSB2_IVVAL_SHIFT)) & PRINCE_IV_LSB2_IVVAL_MASK)
/*! @} */

/*! @name IV_MSB2 - Initial Vector register for region 2, Most Significant Bits */
/*! @{ */
#define PRINCE_IV_MSB2_IVVAL_MASK (0xFFFFFFFFU)
#define PRINCE_IV_MSB2_IVVAL_SHIFT (0U)
/*! IVVAL - Initial Vector value for the 32 Most Significant Bits of the 64-bit Initial Vector.
 */
#define PRINCE_IV_MSB2_IVVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_IV_MSB2_IVVAL_SHIFT)) & PRINCE_IV_MSB2_IVVAL_MASK)
/*! @} */

/*! @name BASE_ADDR2 - Base Address for region 2 register */
/*! @{ */
#define PRINCE_BASE_ADDR2_ADDR_FIXED_MASK (0x3FFFFU)
#define PRINCE_BASE_ADDR2_ADDR_FIXED_SHIFT (0U)
/*! ADDR_FIXED - Fixed portion of the base address of region 2.
 */
#define PRINCE_BASE_ADDR2_ADDR_FIXED(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_BASE_ADDR2_ADDR_FIXED_SHIFT)) & PRINCE_BASE_ADDR2_ADDR_FIXED_MASK)
#define PRINCE_BASE_ADDR2_ADDR_PRG_MASK (0xC0000U)
#define PRINCE_BASE_ADDR2_ADDR_PRG_SHIFT (18U)
/*! ADDR_PRG - Programmable portion of the base address of region 2.
 */
#define PRINCE_BASE_ADDR2_ADDR_PRG(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_BASE_ADDR2_ADDR_PRG_SHIFT)) & PRINCE_BASE_ADDR2_ADDR_PRG_MASK)
/*! @} */

/*! @name SR_ENABLE2 - Sub-Region Enable register for region 2 */
/*! @{ */
#define PRINCE_SR_ENABLE2_EN_MASK (0xFFFFFFFFU)
#define PRINCE_SR_ENABLE2_EN_SHIFT (0U)
/*! EN - Each bit in this field enables an 8KB subregion for encryption at offset 8KB*bitnum of region 2.
 */
#define PRINCE_SR_ENABLE2_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << PRINCE_SR_ENABLE2_EN_SHIFT)) & PRINCE_SR_ENABLE2_EN_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group PRINCE_Register_Masks */

/* PRINCE - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral PRINCE base address */
#define PRINCE_BASE (0x50035000u)
/** Peripheral PRINCE base address */
#define PRINCE_BASE_NS (0x40035000u)
/** Peripheral PRINCE base pointer */
#define PRINCE ((PRINCE_Type *)PRINCE_BASE)
/** Peripheral PRINCE base pointer */
#define PRINCE_NS ((PRINCE_Type *)PRINCE_BASE_NS)
/** Array initializer of PRINCE peripheral base addresses */
#define PRINCE_BASE_ADDRS \
    {                     \
        PRINCE_BASE       \
    }
/** Array initializer of PRINCE peripheral base pointers */
#define PRINCE_BASE_PTRS \
    {                    \
        PRINCE           \
    }
/** Array initializer of PRINCE peripheral base addresses */
#define PRINCE_BASE_ADDRS_NS \
    {                        \
        PRINCE_BASE_NS       \
    }
/** Array initializer of PRINCE peripheral base pointers */
#define PRINCE_BASE_PTRS_NS \
    {                       \
        PRINCE_NS           \
    }
#else
/** Peripheral PRINCE base address */
#define PRINCE_BASE (0x40035000u)
/** Peripheral PRINCE base pointer */
#define PRINCE ((PRINCE_Type *)PRINCE_BASE)
/** Array initializer of PRINCE peripheral base addresses */
#define PRINCE_BASE_ADDRS \
    {                     \
        PRINCE_BASE       \
    }
/** Array initializer of PRINCE peripheral base pointers */
#define PRINCE_BASE_PTRS \
    {                    \
        PRINCE           \
    }
#endif

/*!
 * @}
 */ /* end of group PRINCE_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- PUF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PUF_Peripheral_Access_Layer PUF Peripheral Access Layer
 * @{
 */

/** PUF - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL;     /**< PUF Control register, offset: 0x0 */
    __IO uint32_t KEYINDEX; /**< PUF Key Index register, offset: 0x4 */
    __IO uint32_t KEYSIZE;  /**< PUF Key Size register, offset: 0x8 */
    uint8_t RESERVED_0[20];
    __I uint32_t STAT; /**< PUF Status register, offset: 0x20 */
    uint8_t RESERVED_1[4];
    __I uint32_t ALLOW; /**< PUF Allow register, offset: 0x28 */
    uint8_t RESERVED_2[20];
    __O uint32_t KEYINPUT;   /**< PUF Key Input register, offset: 0x40 */
    __O uint32_t CODEINPUT;  /**< PUF Code Input register, offset: 0x44 */
    __I uint32_t CODEOUTPUT; /**< PUF Code Output register, offset: 0x48 */
    uint8_t RESERVED_3[20];
    __I uint32_t KEYOUTINDEX; /**< PUF Key Output Index register, offset: 0x60 */
    __I uint32_t KEYOUTPUT;   /**< PUF Key Output register, offset: 0x64 */
    uint8_t RESERVED_4[116];
    __IO uint32_t IFSTAT; /**< PUF Interface Status and clear register, offset: 0xDC */
    uint8_t RESERVED_5[28];
    __I uint32_t VERSION;  /**< PUF version register., offset: 0xFC */
    __IO uint32_t INTEN;   /**< PUF Interrupt Enable, offset: 0x100 */
    __IO uint32_t INTSTAT; /**< PUF interrupt status, offset: 0x104 */
    __IO uint32_t PWRCTRL; /**< PUF RAM Power Control, offset: 0x108 */
    __IO uint32_t CFG;     /**< PUF config register for block bits, offset: 0x10C */
    uint8_t RESERVED_6[240];
    __IO uint32_t KEYLOCK;     /**< Only reset in case of full IC reset, offset: 0x200 */
    __IO uint32_t KEYENABLE;   /**< , offset: 0x204 */
    __O uint32_t KEYRESET;     /**< Reinitialize Keys shift registers counters, offset: 0x208 */
    __IO uint32_t IDXBLK_L;    /**< , offset: 0x20C */
    __IO uint32_t IDXBLK_H_DP; /**< , offset: 0x210 */
    __O uint32_t KEYMASK[4];   /**< Only reset in case of full IC reset, array offset: 0x214, array step: 0x4 */
    uint8_t RESERVED_7[48];
    __IO uint32_t IDXBLK_H;    /**< , offset: 0x254 */
    __IO uint32_t IDXBLK_L_DP; /**< , offset: 0x258 */
    __I uint32_t SHIFT_STATUS; /**< , offset: 0x25C */
} PUF_Type;

/* ----------------------------------------------------------------------------
   -- PUF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PUF_Register_Masks PUF Register Masks
 * @{
 */

/*! @name CTRL - PUF Control register */
/*! @{ */
#define PUF_CTRL_ZEROIZE_MASK (0x1U)
#define PUF_CTRL_ZEROIZE_SHIFT (0U)
/*! zeroize - Begin Zeroize operation for PUF and go to Error state
 */
#define PUF_CTRL_ZEROIZE(x) (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_ZEROIZE_SHIFT)) & PUF_CTRL_ZEROIZE_MASK)
#define PUF_CTRL_ENROLL_MASK (0x2U)
#define PUF_CTRL_ENROLL_SHIFT (1U)
/*! enroll - Begin Enroll operation
 */
#define PUF_CTRL_ENROLL(x) (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_ENROLL_SHIFT)) & PUF_CTRL_ENROLL_MASK)
#define PUF_CTRL_START_MASK (0x4U)
#define PUF_CTRL_START_SHIFT (2U)
/*! start - Begin Start operation
 */
#define PUF_CTRL_START(x) (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_START_SHIFT)) & PUF_CTRL_START_MASK)
#define PUF_CTRL_GENERATEKEY_MASK (0x8U)
#define PUF_CTRL_GENERATEKEY_SHIFT (3U)
/*! GENERATEKEY - Begin Set Intrinsic Key operation
 */
#define PUF_CTRL_GENERATEKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_GENERATEKEY_SHIFT)) & PUF_CTRL_GENERATEKEY_MASK)
#define PUF_CTRL_SETKEY_MASK (0x10U)
#define PUF_CTRL_SETKEY_SHIFT (4U)
/*! SETKEY - Begin Set User Key operation
 */
#define PUF_CTRL_SETKEY(x) (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_SETKEY_SHIFT)) & PUF_CTRL_SETKEY_MASK)
#define PUF_CTRL_GETKEY_MASK (0x40U)
#define PUF_CTRL_GETKEY_SHIFT (6U)
/*! GETKEY - Begin Get Key operation
 */
#define PUF_CTRL_GETKEY(x) (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_GETKEY_SHIFT)) & PUF_CTRL_GETKEY_MASK)
/*! @} */

/*! @name KEYINDEX - PUF Key Index register */
/*! @{ */
#define PUF_KEYINDEX_KEYIDX_MASK (0xFU)
#define PUF_KEYINDEX_KEYIDX_SHIFT (0U)
/*! KEYIDX - Key index for Set Key operations
 */
#define PUF_KEYINDEX_KEYIDX(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYINDEX_KEYIDX_SHIFT)) & PUF_KEYINDEX_KEYIDX_MASK)
/*! @} */

/*! @name KEYSIZE - PUF Key Size register */
/*! @{ */
#define PUF_KEYSIZE_KEYSIZE_MASK (0x3FU)
#define PUF_KEYSIZE_KEYSIZE_SHIFT (0U)
/*! KEYSIZE - Key size for Set Key operations
 */
#define PUF_KEYSIZE_KEYSIZE(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYSIZE_KEYSIZE_SHIFT)) & PUF_KEYSIZE_KEYSIZE_MASK)
/*! @} */

/*! @name STAT - PUF Status register */
/*! @{ */
#define PUF_STAT_BUSY_MASK (0x1U)
#define PUF_STAT_BUSY_SHIFT (0U)
/*! busy - Indicates that operation is in progress
 */
#define PUF_STAT_BUSY(x) (((uint32_t)(((uint32_t)(x)) << PUF_STAT_BUSY_SHIFT)) & PUF_STAT_BUSY_MASK)
#define PUF_STAT_SUCCESS_MASK (0x2U)
#define PUF_STAT_SUCCESS_SHIFT (1U)
/*! SUCCESS - Last operation was successful
 */
#define PUF_STAT_SUCCESS(x) (((uint32_t)(((uint32_t)(x)) << PUF_STAT_SUCCESS_SHIFT)) & PUF_STAT_SUCCESS_MASK)
#define PUF_STAT_ERROR_MASK (0x4U)
#define PUF_STAT_ERROR_SHIFT (2U)
/*! error - PUF is in the Error state and no operations can be performed
 */
#define PUF_STAT_ERROR(x) (((uint32_t)(((uint32_t)(x)) << PUF_STAT_ERROR_SHIFT)) & PUF_STAT_ERROR_MASK)
#define PUF_STAT_KEYINREQ_MASK (0x10U)
#define PUF_STAT_KEYINREQ_SHIFT (4U)
/*! KEYINREQ - Request for next part of key
 */
#define PUF_STAT_KEYINREQ(x) (((uint32_t)(((uint32_t)(x)) << PUF_STAT_KEYINREQ_SHIFT)) & PUF_STAT_KEYINREQ_MASK)
#define PUF_STAT_KEYOUTAVAIL_MASK (0x20U)
#define PUF_STAT_KEYOUTAVAIL_SHIFT (5U)
/*! KEYOUTAVAIL - Next part of key is available
 */
#define PUF_STAT_KEYOUTAVAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_STAT_KEYOUTAVAIL_SHIFT)) & PUF_STAT_KEYOUTAVAIL_MASK)
#define PUF_STAT_CODEINREQ_MASK (0x40U)
#define PUF_STAT_CODEINREQ_SHIFT (6U)
/*! CODEINREQ - Request for next part of AC/KC
 */
#define PUF_STAT_CODEINREQ(x) (((uint32_t)(((uint32_t)(x)) << PUF_STAT_CODEINREQ_SHIFT)) & PUF_STAT_CODEINREQ_MASK)
#define PUF_STAT_CODEOUTAVAIL_MASK (0x80U)
#define PUF_STAT_CODEOUTAVAIL_SHIFT (7U)
/*! CODEOUTAVAIL - Next part of AC/KC is available
 */
#define PUF_STAT_CODEOUTAVAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_STAT_CODEOUTAVAIL_SHIFT)) & PUF_STAT_CODEOUTAVAIL_MASK)
/*! @} */

/*! @name ALLOW - PUF Allow register */
/*! @{ */
#define PUF_ALLOW_ALLOWENROLL_MASK (0x1U)
#define PUF_ALLOW_ALLOWENROLL_SHIFT (0U)
/*! ALLOWENROLL - Enroll operation is allowed
 */
#define PUF_ALLOW_ALLOWENROLL(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWENROLL_SHIFT)) & PUF_ALLOW_ALLOWENROLL_MASK)
#define PUF_ALLOW_ALLOWSTART_MASK (0x2U)
#define PUF_ALLOW_ALLOWSTART_SHIFT (1U)
/*! ALLOWSTART - Start operation is allowed
 */
#define PUF_ALLOW_ALLOWSTART(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWSTART_SHIFT)) & PUF_ALLOW_ALLOWSTART_MASK)
#define PUF_ALLOW_ALLOWSETKEY_MASK (0x4U)
#define PUF_ALLOW_ALLOWSETKEY_SHIFT (2U)
/*! ALLOWSETKEY - Set Key operations are allowed
 */
#define PUF_ALLOW_ALLOWSETKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWSETKEY_SHIFT)) & PUF_ALLOW_ALLOWSETKEY_MASK)
#define PUF_ALLOW_ALLOWGETKEY_MASK (0x8U)
#define PUF_ALLOW_ALLOWGETKEY_SHIFT (3U)
/*! ALLOWGETKEY - Get Key operation is allowed
 */
#define PUF_ALLOW_ALLOWGETKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWGETKEY_SHIFT)) & PUF_ALLOW_ALLOWGETKEY_MASK)
/*! @} */

/*! @name KEYINPUT - PUF Key Input register */
/*! @{ */
#define PUF_KEYINPUT_KEYIN_MASK (0xFFFFFFFFU)
#define PUF_KEYINPUT_KEYIN_SHIFT (0U)
/*! KEYIN - Key input data
 */
#define PUF_KEYINPUT_KEYIN(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYINPUT_KEYIN_SHIFT)) & PUF_KEYINPUT_KEYIN_MASK)
/*! @} */

/*! @name CODEINPUT - PUF Code Input register */
/*! @{ */
#define PUF_CODEINPUT_CODEIN_MASK (0xFFFFFFFFU)
#define PUF_CODEINPUT_CODEIN_SHIFT (0U)
/*! CODEIN - AC/KC input data
 */
#define PUF_CODEINPUT_CODEIN(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_CODEINPUT_CODEIN_SHIFT)) & PUF_CODEINPUT_CODEIN_MASK)
/*! @} */

/*! @name CODEOUTPUT - PUF Code Output register */
/*! @{ */
#define PUF_CODEOUTPUT_CODEOUT_MASK (0xFFFFFFFFU)
#define PUF_CODEOUTPUT_CODEOUT_SHIFT (0U)
/*! CODEOUT - AC/KC output data
 */
#define PUF_CODEOUTPUT_CODEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_CODEOUTPUT_CODEOUT_SHIFT)) & PUF_CODEOUTPUT_CODEOUT_MASK)
/*! @} */

/*! @name KEYOUTINDEX - PUF Key Output Index register */
/*! @{ */
#define PUF_KEYOUTINDEX_KEYOUTIDX_MASK (0xFU)
#define PUF_KEYOUTINDEX_KEYOUTIDX_SHIFT (0U)
/*! KEYOUTIDX - Key index for the key that is currently output via the Key Output register
 */
#define PUF_KEYOUTINDEX_KEYOUTIDX(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_KEYOUTINDEX_KEYOUTIDX_SHIFT)) & PUF_KEYOUTINDEX_KEYOUTIDX_MASK)
/*! @} */

/*! @name KEYOUTPUT - PUF Key Output register */
/*! @{ */
#define PUF_KEYOUTPUT_KEYOUT_MASK (0xFFFFFFFFU)
#define PUF_KEYOUTPUT_KEYOUT_SHIFT (0U)
/*! KEYOUT - Key output data
 */
#define PUF_KEYOUTPUT_KEYOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_KEYOUTPUT_KEYOUT_SHIFT)) & PUF_KEYOUTPUT_KEYOUT_MASK)
/*! @} */

/*! @name IFSTAT - PUF Interface Status and clear register */
/*! @{ */
#define PUF_IFSTAT_ERROR_MASK (0x1U)
#define PUF_IFSTAT_ERROR_SHIFT (0U)
/*! ERROR - Indicates that an APB error has occurred,Writing logic1 clears the if_error bit
 */
#define PUF_IFSTAT_ERROR(x) (((uint32_t)(((uint32_t)(x)) << PUF_IFSTAT_ERROR_SHIFT)) & PUF_IFSTAT_ERROR_MASK)
/*! @} */

/*! @name VERSION - PUF version register. */
/*! @{ */
#define PUF_VERSION_VERSION_MASK (0xFFFFFFFFU)
#define PUF_VERSION_VERSION_SHIFT (0U)
/*! VERSION - Version of the PUF module.
 */
#define PUF_VERSION_VERSION(x) (((uint32_t)(((uint32_t)(x)) << PUF_VERSION_VERSION_SHIFT)) & PUF_VERSION_VERSION_MASK)
/*! @} */

/*! @name INTEN - PUF Interrupt Enable */
/*! @{ */
#define PUF_INTEN_READYEN_MASK (0x1U)
#define PUF_INTEN_READYEN_SHIFT (0U)
/*! READYEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status
 * Register)
 */
#define PUF_INTEN_READYEN(x) (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_READYEN_SHIFT)) & PUF_INTEN_READYEN_MASK)
#define PUF_INTEN_SUCCESEN_MASK (0x2U)
#define PUF_INTEN_SUCCESEN_SHIFT (1U)
/*! SUCCESEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status
 * Register)
 */
#define PUF_INTEN_SUCCESEN(x) (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_SUCCESEN_SHIFT)) & PUF_INTEN_SUCCESEN_MASK)
#define PUF_INTEN_ERROREN_MASK (0x4U)
#define PUF_INTEN_ERROREN_SHIFT (2U)
/*! ERROREN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status
 * Register)
 */
#define PUF_INTEN_ERROREN(x) (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_ERROREN_SHIFT)) & PUF_INTEN_ERROREN_MASK)
#define PUF_INTEN_KEYINREQEN_MASK (0x10U)
#define PUF_INTEN_KEYINREQEN_SHIFT (4U)
/*! KEYINREQEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status
 * Register)
 */
#define PUF_INTEN_KEYINREQEN(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_KEYINREQEN_SHIFT)) & PUF_INTEN_KEYINREQEN_MASK)
#define PUF_INTEN_KEYOUTAVAILEN_MASK (0x20U)
#define PUF_INTEN_KEYOUTAVAILEN_SHIFT (5U)
/*! KEYOUTAVAILEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey
 * Status Register)
 */
#define PUF_INTEN_KEYOUTAVAILEN(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_KEYOUTAVAILEN_SHIFT)) & PUF_INTEN_KEYOUTAVAILEN_MASK)
#define PUF_INTEN_CODEINREQEN_MASK (0x40U)
#define PUF_INTEN_CODEINREQEN_SHIFT (6U)
/*! CODEINREQEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status
 * Register)
 */
#define PUF_INTEN_CODEINREQEN(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_CODEINREQEN_SHIFT)) & PUF_INTEN_CODEINREQEN_MASK)
#define PUF_INTEN_CODEOUTAVAILEN_MASK (0x80U)
#define PUF_INTEN_CODEOUTAVAILEN_SHIFT (7U)
/*! CODEOUTAVAILEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey
 * Status Register)
 */
#define PUF_INTEN_CODEOUTAVAILEN(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_CODEOUTAVAILEN_SHIFT)) & PUF_INTEN_CODEOUTAVAILEN_MASK)
/*! @} */

/*! @name INTSTAT - PUF interrupt status */
/*! @{ */
#define PUF_INTSTAT_READY_MASK (0x1U)
#define PUF_INTSTAT_READY_SHIFT (0U)
/*! READY - Triggers on falling edge of busy, write 1 to clear
 */
#define PUF_INTSTAT_READY(x) (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_READY_SHIFT)) & PUF_INTSTAT_READY_MASK)
#define PUF_INTSTAT_SUCCESS_MASK (0x2U)
#define PUF_INTSTAT_SUCCESS_SHIFT (1U)
/*! SUCCESS - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_SUCCESS(x) (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_SUCCESS_SHIFT)) & PUF_INTSTAT_SUCCESS_MASK)
#define PUF_INTSTAT_ERROR_MASK (0x4U)
#define PUF_INTSTAT_ERROR_SHIFT (2U)
/*! ERROR - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_ERROR(x) (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_ERROR_SHIFT)) & PUF_INTSTAT_ERROR_MASK)
#define PUF_INTSTAT_KEYINREQ_MASK (0x10U)
#define PUF_INTSTAT_KEYINREQ_SHIFT (4U)
/*! KEYINREQ - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_KEYINREQ(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_KEYINREQ_SHIFT)) & PUF_INTSTAT_KEYINREQ_MASK)
#define PUF_INTSTAT_KEYOUTAVAIL_MASK (0x20U)
#define PUF_INTSTAT_KEYOUTAVAIL_SHIFT (5U)
/*! KEYOUTAVAIL - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_KEYOUTAVAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_KEYOUTAVAIL_SHIFT)) & PUF_INTSTAT_KEYOUTAVAIL_MASK)
#define PUF_INTSTAT_CODEINREQ_MASK (0x40U)
#define PUF_INTSTAT_CODEINREQ_SHIFT (6U)
/*! CODEINREQ - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_CODEINREQ(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_CODEINREQ_SHIFT)) & PUF_INTSTAT_CODEINREQ_MASK)
#define PUF_INTSTAT_CODEOUTAVAIL_MASK (0x80U)
#define PUF_INTSTAT_CODEOUTAVAIL_SHIFT (7U)
/*! CODEOUTAVAIL - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_CODEOUTAVAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_CODEOUTAVAIL_SHIFT)) & PUF_INTSTAT_CODEOUTAVAIL_MASK)
/*! @} */

/*! @name PWRCTRL - PUF RAM Power Control */
/*! @{ */
#define PUF_PWRCTRL_RAMON_MASK (0x1U)
#define PUF_PWRCTRL_RAMON_SHIFT (0U)
/*! RAMON - Power on the PUF RAM.
 */
#define PUF_PWRCTRL_RAMON(x) (((uint32_t)(((uint32_t)(x)) << PUF_PWRCTRL_RAMON_SHIFT)) & PUF_PWRCTRL_RAMON_MASK)
#define PUF_PWRCTRL_RAMSTAT_MASK (0x2U)
#define PUF_PWRCTRL_RAMSTAT_SHIFT (1U)
/*! RAMSTAT - PUF RAM status.
 */
#define PUF_PWRCTRL_RAMSTAT(x) (((uint32_t)(((uint32_t)(x)) << PUF_PWRCTRL_RAMSTAT_SHIFT)) & PUF_PWRCTRL_RAMSTAT_MASK)
/*! @} */

/*! @name CFG - PUF config register for block bits */
/*! @{ */
#define PUF_CFG_BLOCKENROLL_SETKEY_MASK (0x1U)
#define PUF_CFG_BLOCKENROLL_SETKEY_SHIFT (0U)
/*! BLOCKENROLL_SETKEY - Block enroll operation. Write 1 to set, cleared on reset.
 */
#define PUF_CFG_BLOCKENROLL_SETKEY(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_CFG_BLOCKENROLL_SETKEY_SHIFT)) & PUF_CFG_BLOCKENROLL_SETKEY_MASK)
#define PUF_CFG_BLOCKKEYOUTPUT_MASK (0x2U)
#define PUF_CFG_BLOCKKEYOUTPUT_SHIFT (1U)
/*! BLOCKKEYOUTPUT - Block set key operation. Write 1 to set, cleared on reset.
 */
#define PUF_CFG_BLOCKKEYOUTPUT(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_CFG_BLOCKKEYOUTPUT_SHIFT)) & PUF_CFG_BLOCKKEYOUTPUT_MASK)
/*! @} */

/*! @name KEYLOCK - Only reset in case of full IC reset */
/*! @{ */
#define PUF_KEYLOCK_KEY0_MASK (0x3U)
#define PUF_KEYLOCK_KEY0_SHIFT (0U)
/*! KEY0 - "10:Write access to KEY0MASK, KEYENABLE.KEY0 and KEYRESET.KEY0 is allowed. 00, 01,
 *    11:Write access to KEY0MASK, KEYENABLE.KEY0 and KEYRESET.KEY0 is NOT allowed. Important Note : Once
 *    this field is written with a value different from '10', its value can no longer be modified
 *    until un Power On Reset occurs."
 */
#define PUF_KEYLOCK_KEY0(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY0_SHIFT)) & PUF_KEYLOCK_KEY0_MASK)
#define PUF_KEYLOCK_KEY1_MASK (0xCU)
#define PUF_KEYLOCK_KEY1_SHIFT (2U)
/*! KEY1 - "10:Write access to KEY1MASK, KEYENABLE.KEY1 and KEYRESET.KEY1 is allowed. 00, 01,
 *    11:Write access to KEY1MASK, KEYENABLE.KEY1 and KEYRESET.KEY1 is NOT allowed. Important Note : Once
 *    this field is written with a value different from '10', its value can no longer be modified
 *    until un Power On Reset occurs."
 */
#define PUF_KEYLOCK_KEY1(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY1_SHIFT)) & PUF_KEYLOCK_KEY1_MASK)
#define PUF_KEYLOCK_KEY2_MASK (0x30U)
#define PUF_KEYLOCK_KEY2_SHIFT (4U)
/*! KEY2 - "10:Write access to KEY2MASK, KEYENABLE.KEY2 and KEYRESET.KEY2 is allowed. 00, 01,
 *    11:Write access to KEY2MASK, KEYENABLE.KEY2 and KEYRESET.KEY2 is NOT allowed. Important Note : Once
 *    this field is written with a value different from '10', its value can no longer be modified
 *    until un Power On Reset occurs."
 */
#define PUF_KEYLOCK_KEY2(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY2_SHIFT)) & PUF_KEYLOCK_KEY2_MASK)
#define PUF_KEYLOCK_KEY3_MASK (0xC0U)
#define PUF_KEYLOCK_KEY3_SHIFT (6U)
/*! KEY3 - "10:Write access to KEY3MASK, KEYENABLE.KEY3 and KEYRESET.KEY3 is allowed. 00, 01,
 *    11:Write access to KEY3MASK, KEYENABLE.KEY3 and KEYRESET.KEY3 is NOT allowed. Important Note : Once
 *    this field is written with a value different from '10', its value can no longer be modified
 *    until un Power On Reset occurs."
 */
#define PUF_KEYLOCK_KEY3(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY3_SHIFT)) & PUF_KEYLOCK_KEY3_MASK)
/*! @} */

/*! @name KEYENABLE -  */
/*! @{ */
#define PUF_KEYENABLE_KEY0_MASK (0x3U)
#define PUF_KEYENABLE_KEY0_SHIFT (0U)
/*! KEY0 - "10: Data coming out from PUF Index 0 interface are shifted in KEY0 register. 00, 01, 11
 *    : Data coming out from PUF Index 0 interface are NOT shifted in KEY0 register."
 */
#define PUF_KEYENABLE_KEY0(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY0_SHIFT)) & PUF_KEYENABLE_KEY0_MASK)
#define PUF_KEYENABLE_KEY1_MASK (0xCU)
#define PUF_KEYENABLE_KEY1_SHIFT (2U)
/*! KEY1 - "10: Data coming out from PUF Index 0 interface are shifted in KEY1 register. 00, 01, 11
 *    : Data coming out from PUF Index 0 interface are NOT shifted in KEY1 register."
 */
#define PUF_KEYENABLE_KEY1(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY1_SHIFT)) & PUF_KEYENABLE_KEY1_MASK)
#define PUF_KEYENABLE_KEY2_MASK (0x30U)
#define PUF_KEYENABLE_KEY2_SHIFT (4U)
/*! KEY2 - "10: Data coming out from PUF Index 0 interface are shifted in KEY2 register. 00, 01, 11
 *    : Data coming out from PUF Index 0 interface are NOT shifted in KEY2 register."
 */
#define PUF_KEYENABLE_KEY2(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY2_SHIFT)) & PUF_KEYENABLE_KEY2_MASK)
#define PUF_KEYENABLE_KEY3_MASK (0xC0U)
#define PUF_KEYENABLE_KEY3_SHIFT (6U)
/*! KEY3 - "10: Data coming out from PUF Index 0 interface are shifted in KEY3 register. 00, 01, 11
 *    : Data coming out from PUF Index 0 interface are NOT shifted in KEY3 register."
 */
#define PUF_KEYENABLE_KEY3(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY3_SHIFT)) & PUF_KEYENABLE_KEY3_MASK)
/*! @} */

/*! @name KEYRESET - Reinitialize Keys shift registers counters */
/*! @{ */
#define PUF_KEYRESET_KEY0_MASK (0x3U)
#define PUF_KEYRESET_KEY0_SHIFT (0U)
/*! KEY0 - 10: Reset KEY0 shift register. Self clearing. Must be done before loading any new key.
 */
#define PUF_KEYRESET_KEY0(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY0_SHIFT)) & PUF_KEYRESET_KEY0_MASK)
#define PUF_KEYRESET_KEY1_MASK (0xCU)
#define PUF_KEYRESET_KEY1_SHIFT (2U)
/*! KEY1 - 10: Reset KEY1 shift register. Self clearing. Must be done before loading any new key.
 */
#define PUF_KEYRESET_KEY1(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY1_SHIFT)) & PUF_KEYRESET_KEY1_MASK)
#define PUF_KEYRESET_KEY2_MASK (0x30U)
#define PUF_KEYRESET_KEY2_SHIFT (4U)
/*! KEY2 - 10: Reset KEY2 shift register. Self clearing. Must be done before loading any new key.
 */
#define PUF_KEYRESET_KEY2(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY2_SHIFT)) & PUF_KEYRESET_KEY2_MASK)
#define PUF_KEYRESET_KEY3_MASK (0xC0U)
#define PUF_KEYRESET_KEY3_SHIFT (6U)
/*! KEY3 - 10: Reset KEY3 shift register. Self clearing. Must be done before loading any new key.
 */
#define PUF_KEYRESET_KEY3(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY3_SHIFT)) & PUF_KEYRESET_KEY3_MASK)
/*! @} */

/*! @name IDXBLK_L -  */
/*! @{ */
#define PUF_IDXBLK_L_IDX1_MASK (0xCU)
#define PUF_IDXBLK_L_IDX1_SHIFT (2U)
/*! IDX1 - Use to block PUF index 1
 */
#define PUF_IDXBLK_L_IDX1(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX1_SHIFT)) & PUF_IDXBLK_L_IDX1_MASK)
#define PUF_IDXBLK_L_IDX2_MASK (0x30U)
#define PUF_IDXBLK_L_IDX2_SHIFT (4U)
/*! IDX2 - Use to block PUF index 2
 */
#define PUF_IDXBLK_L_IDX2(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX2_SHIFT)) & PUF_IDXBLK_L_IDX2_MASK)
#define PUF_IDXBLK_L_IDX3_MASK (0xC0U)
#define PUF_IDXBLK_L_IDX3_SHIFT (6U)
/*! IDX3 - Use to block PUF index 3
 */
#define PUF_IDXBLK_L_IDX3(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX3_SHIFT)) & PUF_IDXBLK_L_IDX3_MASK)
#define PUF_IDXBLK_L_IDX4_MASK (0x300U)
#define PUF_IDXBLK_L_IDX4_SHIFT (8U)
/*! IDX4 - Use to block PUF index 4
 */
#define PUF_IDXBLK_L_IDX4(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX4_SHIFT)) & PUF_IDXBLK_L_IDX4_MASK)
#define PUF_IDXBLK_L_IDX5_MASK (0xC00U)
#define PUF_IDXBLK_L_IDX5_SHIFT (10U)
/*! IDX5 - Use to block PUF index 5
 */
#define PUF_IDXBLK_L_IDX5(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX5_SHIFT)) & PUF_IDXBLK_L_IDX5_MASK)
#define PUF_IDXBLK_L_IDX6_MASK (0x3000U)
#define PUF_IDXBLK_L_IDX6_SHIFT (12U)
/*! IDX6 - Use to block PUF index 6
 */
#define PUF_IDXBLK_L_IDX6(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX6_SHIFT)) & PUF_IDXBLK_L_IDX6_MASK)
#define PUF_IDXBLK_L_IDX7_MASK (0xC000U)
#define PUF_IDXBLK_L_IDX7_SHIFT (14U)
/*! IDX7 - Use to block PUF index 7
 */
#define PUF_IDXBLK_L_IDX7(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX7_SHIFT)) & PUF_IDXBLK_L_IDX7_MASK)
#define PUF_IDXBLK_L_LOCK_IDX_MASK (0xC0000000U)
#define PUF_IDXBLK_L_LOCK_IDX_SHIFT (30U)
/*! LOCK_IDX - Lock 0 to 7 PUF key indexes
 */
#define PUF_IDXBLK_L_LOCK_IDX(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_LOCK_IDX_SHIFT)) & PUF_IDXBLK_L_LOCK_IDX_MASK)
/*! @} */

/*! @name IDXBLK_H_DP -  */
/*! @{ */
#define PUF_IDXBLK_H_DP_IDX8_MASK (0x3U)
#define PUF_IDXBLK_H_DP_IDX8_SHIFT (0U)
/*! IDX8 - Use to block PUF index 8
 */
#define PUF_IDXBLK_H_DP_IDX8(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX8_SHIFT)) & PUF_IDXBLK_H_DP_IDX8_MASK)
#define PUF_IDXBLK_H_DP_IDX9_MASK (0xCU)
#define PUF_IDXBLK_H_DP_IDX9_SHIFT (2U)
/*! IDX9 - Use to block PUF index 9
 */
#define PUF_IDXBLK_H_DP_IDX9(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX9_SHIFT)) & PUF_IDXBLK_H_DP_IDX9_MASK)
#define PUF_IDXBLK_H_DP_IDX10_MASK (0x30U)
#define PUF_IDXBLK_H_DP_IDX10_SHIFT (4U)
/*! IDX10 - Use to block PUF index 10
 */
#define PUF_IDXBLK_H_DP_IDX10(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX10_SHIFT)) & PUF_IDXBLK_H_DP_IDX10_MASK)
#define PUF_IDXBLK_H_DP_IDX11_MASK (0xC0U)
#define PUF_IDXBLK_H_DP_IDX11_SHIFT (6U)
/*! IDX11 - Use to block PUF index 11
 */
#define PUF_IDXBLK_H_DP_IDX11(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX11_SHIFT)) & PUF_IDXBLK_H_DP_IDX11_MASK)
#define PUF_IDXBLK_H_DP_IDX12_MASK (0x300U)
#define PUF_IDXBLK_H_DP_IDX12_SHIFT (8U)
/*! IDX12 - Use to block PUF index 12
 */
#define PUF_IDXBLK_H_DP_IDX12(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX12_SHIFT)) & PUF_IDXBLK_H_DP_IDX12_MASK)
#define PUF_IDXBLK_H_DP_IDX13_MASK (0xC00U)
#define PUF_IDXBLK_H_DP_IDX13_SHIFT (10U)
/*! IDX13 - Use to block PUF index 13
 */
#define PUF_IDXBLK_H_DP_IDX13(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX13_SHIFT)) & PUF_IDXBLK_H_DP_IDX13_MASK)
#define PUF_IDXBLK_H_DP_IDX14_MASK (0x3000U)
#define PUF_IDXBLK_H_DP_IDX14_SHIFT (12U)
/*! IDX14 - Use to block PUF index 14
 */
#define PUF_IDXBLK_H_DP_IDX14(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX14_SHIFT)) & PUF_IDXBLK_H_DP_IDX14_MASK)
#define PUF_IDXBLK_H_DP_IDX15_MASK (0xC000U)
#define PUF_IDXBLK_H_DP_IDX15_SHIFT (14U)
/*! IDX15 - Use to block PUF index 15
 */
#define PUF_IDXBLK_H_DP_IDX15(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX15_SHIFT)) & PUF_IDXBLK_H_DP_IDX15_MASK)
/*! @} */

/*! @name KEYMASK - Only reset in case of full IC reset */
/*! @{ */
#define PUF_KEYMASK_KEYMASK_MASK (0xFFFFFFFFU)
#define PUF_KEYMASK_KEYMASK_SHIFT (0U)
#define PUF_KEYMASK_KEYMASK(x) (((uint32_t)(((uint32_t)(x)) << PUF_KEYMASK_KEYMASK_SHIFT)) & PUF_KEYMASK_KEYMASK_MASK)
/*! @} */

/* The count of PUF_KEYMASK */
#define PUF_KEYMASK_COUNT (4U)

/*! @name IDXBLK_H -  */
/*! @{ */
#define PUF_IDXBLK_H_IDX8_MASK (0x3U)
#define PUF_IDXBLK_H_IDX8_SHIFT (0U)
/*! IDX8 - Use to block PUF index 8
 */
#define PUF_IDXBLK_H_IDX8(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX8_SHIFT)) & PUF_IDXBLK_H_IDX8_MASK)
#define PUF_IDXBLK_H_IDX9_MASK (0xCU)
#define PUF_IDXBLK_H_IDX9_SHIFT (2U)
/*! IDX9 - Use to block PUF index 9
 */
#define PUF_IDXBLK_H_IDX9(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX9_SHIFT)) & PUF_IDXBLK_H_IDX9_MASK)
#define PUF_IDXBLK_H_IDX10_MASK (0x30U)
#define PUF_IDXBLK_H_IDX10_SHIFT (4U)
/*! IDX10 - Use to block PUF index 10
 */
#define PUF_IDXBLK_H_IDX10(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX10_SHIFT)) & PUF_IDXBLK_H_IDX10_MASK)
#define PUF_IDXBLK_H_IDX11_MASK (0xC0U)
#define PUF_IDXBLK_H_IDX11_SHIFT (6U)
/*! IDX11 - Use to block PUF index 11
 */
#define PUF_IDXBLK_H_IDX11(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX11_SHIFT)) & PUF_IDXBLK_H_IDX11_MASK)
#define PUF_IDXBLK_H_IDX12_MASK (0x300U)
#define PUF_IDXBLK_H_IDX12_SHIFT (8U)
/*! IDX12 - Use to block PUF index 12
 */
#define PUF_IDXBLK_H_IDX12(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX12_SHIFT)) & PUF_IDXBLK_H_IDX12_MASK)
#define PUF_IDXBLK_H_IDX13_MASK (0xC00U)
#define PUF_IDXBLK_H_IDX13_SHIFT (10U)
/*! IDX13 - Use to block PUF index 13
 */
#define PUF_IDXBLK_H_IDX13(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX13_SHIFT)) & PUF_IDXBLK_H_IDX13_MASK)
#define PUF_IDXBLK_H_IDX14_MASK (0x3000U)
#define PUF_IDXBLK_H_IDX14_SHIFT (12U)
/*! IDX14 - Use to block PUF index 14
 */
#define PUF_IDXBLK_H_IDX14(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX14_SHIFT)) & PUF_IDXBLK_H_IDX14_MASK)
#define PUF_IDXBLK_H_IDX15_MASK (0xC000U)
#define PUF_IDXBLK_H_IDX15_SHIFT (14U)
/*! IDX15 - Use to block PUF index 15
 */
#define PUF_IDXBLK_H_IDX15(x) (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX15_SHIFT)) & PUF_IDXBLK_H_IDX15_MASK)
#define PUF_IDXBLK_H_LOCK_IDX_MASK (0xC0000000U)
#define PUF_IDXBLK_H_LOCK_IDX_SHIFT (30U)
/*! LOCK_IDX - Lock 8 to 15 PUF key indexes
 */
#define PUF_IDXBLK_H_LOCK_IDX(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_LOCK_IDX_SHIFT)) & PUF_IDXBLK_H_LOCK_IDX_MASK)
/*! @} */

/*! @name IDXBLK_L_DP -  */
/*! @{ */
#define PUF_IDXBLK_L_DP_IDX1_MASK (0xCU)
#define PUF_IDXBLK_L_DP_IDX1_SHIFT (2U)
/*! IDX1 - Use to block PUF index 1
 */
#define PUF_IDXBLK_L_DP_IDX1(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX1_SHIFT)) & PUF_IDXBLK_L_DP_IDX1_MASK)
#define PUF_IDXBLK_L_DP_IDX2_MASK (0x30U)
#define PUF_IDXBLK_L_DP_IDX2_SHIFT (4U)
/*! IDX2 - Use to block PUF index 2
 */
#define PUF_IDXBLK_L_DP_IDX2(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX2_SHIFT)) & PUF_IDXBLK_L_DP_IDX2_MASK)
#define PUF_IDXBLK_L_DP_IDX3_MASK (0xC0U)
#define PUF_IDXBLK_L_DP_IDX3_SHIFT (6U)
/*! IDX3 - Use to block PUF index 3
 */
#define PUF_IDXBLK_L_DP_IDX3(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX3_SHIFT)) & PUF_IDXBLK_L_DP_IDX3_MASK)
#define PUF_IDXBLK_L_DP_IDX4_MASK (0x300U)
#define PUF_IDXBLK_L_DP_IDX4_SHIFT (8U)
/*! IDX4 - Use to block PUF index 4
 */
#define PUF_IDXBLK_L_DP_IDX4(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX4_SHIFT)) & PUF_IDXBLK_L_DP_IDX4_MASK)
#define PUF_IDXBLK_L_DP_IDX5_MASK (0xC00U)
#define PUF_IDXBLK_L_DP_IDX5_SHIFT (10U)
/*! IDX5 - Use to block PUF index 5
 */
#define PUF_IDXBLK_L_DP_IDX5(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX5_SHIFT)) & PUF_IDXBLK_L_DP_IDX5_MASK)
#define PUF_IDXBLK_L_DP_IDX6_MASK (0x3000U)
#define PUF_IDXBLK_L_DP_IDX6_SHIFT (12U)
/*! IDX6 - Use to block PUF index 6
 */
#define PUF_IDXBLK_L_DP_IDX6(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX6_SHIFT)) & PUF_IDXBLK_L_DP_IDX6_MASK)
#define PUF_IDXBLK_L_DP_IDX7_MASK (0xC000U)
#define PUF_IDXBLK_L_DP_IDX7_SHIFT (14U)
/*! IDX7 - Use to block PUF index 7
 */
#define PUF_IDXBLK_L_DP_IDX7(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX7_SHIFT)) & PUF_IDXBLK_L_DP_IDX7_MASK)
/*! @} */

/*! @name SHIFT_STATUS -  */
/*! @{ */
#define PUF_SHIFT_STATUS_KEY0_MASK (0xFU)
#define PUF_SHIFT_STATUS_KEY0_SHIFT (0U)
/*! KEY0 - Index counter from key 0 shift register
 */
#define PUF_SHIFT_STATUS_KEY0(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_SHIFT_STATUS_KEY0_SHIFT)) & PUF_SHIFT_STATUS_KEY0_MASK)
#define PUF_SHIFT_STATUS_KEY1_MASK (0xF0U)
#define PUF_SHIFT_STATUS_KEY1_SHIFT (4U)
/*! KEY1 - Index counter from key 1 shift register
 */
#define PUF_SHIFT_STATUS_KEY1(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_SHIFT_STATUS_KEY1_SHIFT)) & PUF_SHIFT_STATUS_KEY1_MASK)
#define PUF_SHIFT_STATUS_KEY2_MASK (0xF00U)
#define PUF_SHIFT_STATUS_KEY2_SHIFT (8U)
/*! KEY2 - Index counter from key 2 shift register
 */
#define PUF_SHIFT_STATUS_KEY2(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_SHIFT_STATUS_KEY2_SHIFT)) & PUF_SHIFT_STATUS_KEY2_MASK)
#define PUF_SHIFT_STATUS_KEY3_MASK (0xF000U)
#define PUF_SHIFT_STATUS_KEY3_SHIFT (12U)
/*! KEY3 - Index counter from key 3 shift register
 */
#define PUF_SHIFT_STATUS_KEY3(x) \
    (((uint32_t)(((uint32_t)(x)) << PUF_SHIFT_STATUS_KEY3_SHIFT)) & PUF_SHIFT_STATUS_KEY3_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group PUF_Register_Masks */

/* PUF - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral PUF base address */
#define PUF_BASE (0x5003B000u)
/** Peripheral PUF base address */
#define PUF_BASE_NS (0x4003B000u)
/** Peripheral PUF base pointer */
#define PUF ((PUF_Type *)PUF_BASE)
/** Peripheral PUF base pointer */
#define PUF_NS ((PUF_Type *)PUF_BASE_NS)
/** Array initializer of PUF peripheral base addresses */
#define PUF_BASE_ADDRS \
    {                  \
        PUF_BASE       \
    }
/** Array initializer of PUF peripheral base pointers */
#define PUF_BASE_PTRS \
    {                 \
        PUF           \
    }
/** Array initializer of PUF peripheral base addresses */
#define PUF_BASE_ADDRS_NS \
    {                     \
        PUF_BASE_NS       \
    }
/** Array initializer of PUF peripheral base pointers */
#define PUF_BASE_PTRS_NS \
    {                    \
        PUF_NS           \
    }
#else
/** Peripheral PUF base address */
#define PUF_BASE (0x4003B000u)
/** Peripheral PUF base pointer */
#define PUF ((PUF_Type *)PUF_BASE)
/** Array initializer of PUF peripheral base addresses */
#define PUF_BASE_ADDRS \
    {                  \
        PUF_BASE       \
    }
/** Array initializer of PUF peripheral base pointers */
#define PUF_BASE_PTRS \
    {                 \
        PUF           \
    }
#endif
/** Interrupt vectors for the PUF peripheral type */
#define PUF_IRQS \
    {            \
        PUF_IRQn \
    }

/*!
 * @}
 */ /* end of group PUF_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- RNG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RNG_Peripheral_Access_Layer RNG Peripheral Access Layer
 * @{
 */

/** RNG - Register Layout Typedef */
typedef struct
{
    __I uint32_t RANDOM_NUMBER; /**< This register contains a random 32 bit number which is computed on demand, at each
                                   time it is read, offset: 0x0 */
    uint8_t RESERVED_0[4];
    __I uint32_t COUNTER_VAL;      /**< , offset: 0x8 */
    __IO uint32_t COUNTER_CFG;     /**< , offset: 0xC */
    __IO uint32_t ONLINE_TEST_CFG; /**< , offset: 0x10 */
    __I uint32_t ONLINE_TEST_VAL;  /**< , offset: 0x14 */
    uint8_t RESERVED_1[4068];
    __I uint32_t MODULEID; /**< IP identifier, offset: 0xFFC */
} RNG_Type;

/* ----------------------------------------------------------------------------
   -- RNG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RNG_Register_Masks RNG Register Masks
 * @{
 */

/*! @name RANDOM_NUMBER - This register contains a random 32 bit number which is computed on demand, at each time it is
 * read */
/*! @{ */
#define RNG_RANDOM_NUMBER_RANDOM_NUMBER_MASK (0xFFFFFFFFU)
#define RNG_RANDOM_NUMBER_RANDOM_NUMBER_SHIFT (0U)
/*! RANDOM_NUMBER - This register contains a random 32 bit number which is computed on demand, at each time it is read.
 */
#define RNG_RANDOM_NUMBER_RANDOM_NUMBER(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_RANDOM_NUMBER_RANDOM_NUMBER_SHIFT)) & RNG_RANDOM_NUMBER_RANDOM_NUMBER_MASK)
/*! @} */

/*! @name COUNTER_VAL -  */
/*! @{ */
#define RNG_COUNTER_VAL_CLK_RATIO_MASK (0xFFU)
#define RNG_COUNTER_VAL_CLK_RATIO_SHIFT (0U)
/*! CLK_RATIO - Gives the ratio between the internal clocks frequencies and the register clock
 *    frequency for evaluation and certification purposes.
 */
#define RNG_COUNTER_VAL_CLK_RATIO(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_COUNTER_VAL_CLK_RATIO_SHIFT)) & RNG_COUNTER_VAL_CLK_RATIO_MASK)
#define RNG_COUNTER_VAL_REFRESH_CNT_MASK (0x1F00U)
#define RNG_COUNTER_VAL_REFRESH_CNT_SHIFT (8U)
/*! REFRESH_CNT - Incremented (till max possible value) each time COUNTER was updated since last reading to any
 * *_NUMBER.
 */
#define RNG_COUNTER_VAL_REFRESH_CNT(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_COUNTER_VAL_REFRESH_CNT_SHIFT)) & RNG_COUNTER_VAL_REFRESH_CNT_MASK)
/*! @} */

/*! @name COUNTER_CFG -  */
/*! @{ */
#define RNG_COUNTER_CFG_MODE_MASK (0x3U)
#define RNG_COUNTER_CFG_MODE_SHIFT (0U)
/*! MODE - 00: disabled 01: update once.
 */
#define RNG_COUNTER_CFG_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_COUNTER_CFG_MODE_SHIFT)) & RNG_COUNTER_CFG_MODE_MASK)
#define RNG_COUNTER_CFG_CLOCK_SEL_MASK (0x1CU)
#define RNG_COUNTER_CFG_CLOCK_SEL_SHIFT (2U)
/*! CLOCK_SEL - Selects the internal clock on which to compute statistics.
 */
#define RNG_COUNTER_CFG_CLOCK_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_COUNTER_CFG_CLOCK_SEL_SHIFT)) & RNG_COUNTER_CFG_CLOCK_SEL_MASK)
#define RNG_COUNTER_CFG_SHIFT4X_MASK (0xE0U)
#define RNG_COUNTER_CFG_SHIFT4X_SHIFT (5U)
/*! SHIFT4X - To be used to add precision to clock_ratio and determine 'entropy refill'.
 */
#define RNG_COUNTER_CFG_SHIFT4X(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_COUNTER_CFG_SHIFT4X_SHIFT)) & RNG_COUNTER_CFG_SHIFT4X_MASK)
/*! @} */

/*! @name ONLINE_TEST_CFG -  */
/*! @{ */
#define RNG_ONLINE_TEST_CFG_ACTIVATE_MASK (0x1U)
#define RNG_ONLINE_TEST_CFG_ACTIVATE_SHIFT (0U)
/*! ACTIVATE - 0: disabled 1: activated Update rythm for VAL depends on COUNTER_CFG if data_sel is set to COUNTER.
 */
#define RNG_ONLINE_TEST_CFG_ACTIVATE(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_ONLINE_TEST_CFG_ACTIVATE_SHIFT)) & RNG_ONLINE_TEST_CFG_ACTIVATE_MASK)
#define RNG_ONLINE_TEST_CFG_DATA_SEL_MASK (0x6U)
#define RNG_ONLINE_TEST_CFG_DATA_SEL_SHIFT (1U)
/*! DATA_SEL - Selects source on which to apply online test: 00: LSB of COUNTER: raw data from one
 *    or all sources of entropy 01: MSB of COUNTER: raw data from one or all sources of entropy 10:
 *    RANDOM_NUMBER 11: ENCRYPTED_NUMBER 'activate' should be set to 'disabled' before changing this
 *    field.
 */
#define RNG_ONLINE_TEST_CFG_DATA_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_ONLINE_TEST_CFG_DATA_SEL_SHIFT)) & RNG_ONLINE_TEST_CFG_DATA_SEL_MASK)
/*! @} */

/*! @name ONLINE_TEST_VAL -  */
/*! @{ */
#define RNG_ONLINE_TEST_VAL_LIVE_CHI_SQUARED_MASK (0xFU)
#define RNG_ONLINE_TEST_VAL_LIVE_CHI_SQUARED_SHIFT (0U)
/*! LIVE_CHI_SQUARED - This value is updated as described in field 'activate'.
 */
#define RNG_ONLINE_TEST_VAL_LIVE_CHI_SQUARED(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << RNG_ONLINE_TEST_VAL_LIVE_CHI_SQUARED_SHIFT)) & \
     RNG_ONLINE_TEST_VAL_LIVE_CHI_SQUARED_MASK)
#define RNG_ONLINE_TEST_VAL_MIN_CHI_SQUARED_MASK (0xF0U)
#define RNG_ONLINE_TEST_VAL_MIN_CHI_SQUARED_SHIFT (4U)
/*! MIN_CHI_SQUARED - This field is reset when 'activate'==0.
 */
#define RNG_ONLINE_TEST_VAL_MIN_CHI_SQUARED(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << RNG_ONLINE_TEST_VAL_MIN_CHI_SQUARED_SHIFT)) & \
     RNG_ONLINE_TEST_VAL_MIN_CHI_SQUARED_MASK)
#define RNG_ONLINE_TEST_VAL_MAX_CHI_SQUARED_MASK (0xF00U)
#define RNG_ONLINE_TEST_VAL_MAX_CHI_SQUARED_SHIFT (8U)
/*! MAX_CHI_SQUARED - This field is reset when 'activate'==0.
 */
#define RNG_ONLINE_TEST_VAL_MAX_CHI_SQUARED(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << RNG_ONLINE_TEST_VAL_MAX_CHI_SQUARED_SHIFT)) & \
     RNG_ONLINE_TEST_VAL_MAX_CHI_SQUARED_MASK)
/*! @} */

/*! @name MODULEID - IP identifier */
/*! @{ */
#define RNG_MODULEID_APERTURE_MASK (0xFFU)
#define RNG_MODULEID_APERTURE_SHIFT (0U)
/*! APERTURE - Aperture i.
 */
#define RNG_MODULEID_APERTURE(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_MODULEID_APERTURE_SHIFT)) & RNG_MODULEID_APERTURE_MASK)
#define RNG_MODULEID_MIN_REV_MASK (0xF00U)
#define RNG_MODULEID_MIN_REV_SHIFT (8U)
/*! MIN_REV - Minor revision i.
 */
#define RNG_MODULEID_MIN_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_MODULEID_MIN_REV_SHIFT)) & RNG_MODULEID_MIN_REV_MASK)
#define RNG_MODULEID_MAJ_REV_MASK (0xF000U)
#define RNG_MODULEID_MAJ_REV_SHIFT (12U)
/*! MAJ_REV - Major revision i.
 */
#define RNG_MODULEID_MAJ_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << RNG_MODULEID_MAJ_REV_SHIFT)) & RNG_MODULEID_MAJ_REV_MASK)
#define RNG_MODULEID_ID_MASK (0xFFFF0000U)
#define RNG_MODULEID_ID_SHIFT (16U)
/*! ID - Identifier.
 */
#define RNG_MODULEID_ID(x) (((uint32_t)(((uint32_t)(x)) << RNG_MODULEID_ID_SHIFT)) & RNG_MODULEID_ID_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group RNG_Register_Masks */

/* RNG - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral RNG base address */
#define RNG_BASE (0x5003A000u)
/** Peripheral RNG base address */
#define RNG_BASE_NS (0x4003A000u)
/** Peripheral RNG base pointer */
#define RNG ((RNG_Type *)RNG_BASE)
/** Peripheral RNG base pointer */
#define RNG_NS ((RNG_Type *)RNG_BASE_NS)
/** Array initializer of RNG peripheral base addresses */
#define RNG_BASE_ADDRS \
    {                  \
        RNG_BASE       \
    }
/** Array initializer of RNG peripheral base pointers */
#define RNG_BASE_PTRS \
    {                 \
        RNG           \
    }
/** Array initializer of RNG peripheral base addresses */
#define RNG_BASE_ADDRS_NS \
    {                     \
        RNG_BASE_NS       \
    }
/** Array initializer of RNG peripheral base pointers */
#define RNG_BASE_PTRS_NS \
    {                    \
        RNG_NS           \
    }
#else
/** Peripheral RNG base address */
#define RNG_BASE (0x4003A000u)
/** Peripheral RNG base pointer */
#define RNG ((RNG_Type *)RNG_BASE)
/** Array initializer of RNG peripheral base addresses */
#define RNG_BASE_ADDRS \
    {                  \
        RNG_BASE       \
    }
/** Array initializer of RNG peripheral base pointers */
#define RNG_BASE_PTRS \
    {                 \
        RNG           \
    }
#endif

/*!
 * @}
 */ /* end of group RNG_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- RTC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Peripheral_Access_Layer RTC Peripheral Access Layer
 * @{
 */

/** RTC - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL;  /**< RTC control register, offset: 0x0 */
    __IO uint32_t MATCH; /**< RTC match register, offset: 0x4 */
    __IO uint32_t COUNT; /**< RTC counter register, offset: 0x8 */
    __IO uint32_t WAKE;  /**< High-resolution/wake-up timer control register, offset: 0xC */
    __I uint32_t SUBSEC; /**< Sub-second counter register, offset: 0x10 */
    uint8_t RESERVED_0[44];
    __IO uint32_t GPREG[8]; /**< General Purpose register, array offset: 0x40, array step: 0x4 */
} RTC_Type;

/* ----------------------------------------------------------------------------
   -- RTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Masks RTC Register Masks
 * @{
 */

/*! @name CTRL - RTC control register */
/*! @{ */
#define RTC_CTRL_SWRESET_MASK (0x1U)
#define RTC_CTRL_SWRESET_SHIFT (0U)
/*! SWRESET - Software reset control
 *  0b0..Not in reset. The RTC is not held in reset. This bit must be cleared prior to configuring or initiating any
 * operation of the RTC. 0b1..In reset. The RTC is held in reset. All register bits within the RTC will be forced to
 * their reset value except the OFD bit. This bit must be cleared before writing to any register in the RTC - including
 * writes to set any of the other bits within this register. Do not attempt to write to any bits of this register at the
 * same time that the reset bit is being cleared.
 */
#define RTC_CTRL_SWRESET(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_SWRESET_SHIFT)) & RTC_CTRL_SWRESET_MASK)
#define RTC_CTRL_ALARM1HZ_MASK (0x4U)
#define RTC_CTRL_ALARM1HZ_SHIFT (2U)
/*! ALARM1HZ - RTC 1 Hz timer alarm flag status.
 *  0b0..No match. No match has occurred on the 1 Hz RTC timer. Writing a 0 has no effect.
 *  0b1..Match. A match condition has occurred on the 1 Hz RTC timer. This flag generates an RTC alarm interrupt
 *       request RTC_ALARM which can also wake up the part from any low power mode. Writing a 1 clears this bit.
 */
#define RTC_CTRL_ALARM1HZ(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_ALARM1HZ_SHIFT)) & RTC_CTRL_ALARM1HZ_MASK)
#define RTC_CTRL_WAKE1KHZ_MASK (0x8U)
#define RTC_CTRL_WAKE1KHZ_SHIFT (3U)
/*! WAKE1KHZ - RTC 1 kHz timer wake-up flag status.
 *  0b0..Run. The RTC 1 kHz timer is running. Writing a 0 has no effect.
 *  0b1..Time-out. The 1 kHz high-resolution/wake-up timer has timed out. This flag generates an RTC wake-up
 *       interrupt request RTC-WAKE which can also wake up the part from any low power mode. Writing a 1 clears this
 * bit.
 */
#define RTC_CTRL_WAKE1KHZ(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_WAKE1KHZ_SHIFT)) & RTC_CTRL_WAKE1KHZ_MASK)
#define RTC_CTRL_ALARMDPD_EN_MASK (0x10U)
#define RTC_CTRL_ALARMDPD_EN_SHIFT (4U)
/*! ALARMDPD_EN - RTC 1 Hz timer alarm enable for Deep power-down.
 *  0b0..Disable. A match on the 1 Hz RTC timer will not bring the part out of Deep power-down mode.
 *  0b1..Enable. A match on the 1 Hz RTC timer bring the part out of Deep power-down mode.
 */
#define RTC_CTRL_ALARMDPD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_ALARMDPD_EN_SHIFT)) & RTC_CTRL_ALARMDPD_EN_MASK)
#define RTC_CTRL_WAKEDPD_EN_MASK (0x20U)
#define RTC_CTRL_WAKEDPD_EN_SHIFT (5U)
/*! WAKEDPD_EN - RTC 1 kHz timer wake-up enable for Deep power-down.
 *  0b0..Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
 *  0b1..Enable. A match on the 1 kHz RTC timer bring the part out of Deep power-down mode.
 */
#define RTC_CTRL_WAKEDPD_EN(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_WAKEDPD_EN_SHIFT)) & RTC_CTRL_WAKEDPD_EN_MASK)
#define RTC_CTRL_RTC1KHZ_EN_MASK (0x40U)
#define RTC_CTRL_RTC1KHZ_EN_SHIFT (6U)
/*! RTC1KHZ_EN - RTC 1 kHz clock enable. This bit can be set to 0 to conserve power if the 1 kHz
 *    timer is not used. This bit has no effect when the RTC is disabled (bit 7 of this register is 0).
 *  0b0..Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
 *  0b1..Enable. The 1 kHz RTC timer is enabled.
 */
#define RTC_CTRL_RTC1KHZ_EN(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC1KHZ_EN_SHIFT)) & RTC_CTRL_RTC1KHZ_EN_MASK)
#define RTC_CTRL_RTC_EN_MASK (0x80U)
#define RTC_CTRL_RTC_EN_SHIFT (7U)
/*! RTC_EN - RTC enable.
 *  0b0..Disable. The RTC 1 Hz and 1 kHz clocks are shut down and the RTC operation is disabled. This bit should
 *       be 0 when writing to load a value in the RTC counter register.
 *  0b1..Enable. The 1 Hz RTC clock is running and RTC operation is enabled. This bit must be set to initiate
 *       operation of the RTC. The first clock to the RTC counter occurs 1 s after this bit is set. To also enable the
 *       high-resolution, 1 kHz clock, set bit 6 in this register.
 */
#define RTC_CTRL_RTC_EN(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC_EN_SHIFT)) & RTC_CTRL_RTC_EN_MASK)
#define RTC_CTRL_RTC_OSC_PD_MASK (0x100U)
#define RTC_CTRL_RTC_OSC_PD_SHIFT (8U)
/*! RTC_OSC_PD - RTC oscillator power-down control.
 *  0b0..See RTC_OSC_BYPASS
 *  0b1..RTC oscillator is powered-down.
 */
#define RTC_CTRL_RTC_OSC_PD(x) (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC_OSC_PD_SHIFT)) & RTC_CTRL_RTC_OSC_PD_MASK)
#define RTC_CTRL_RTC_OSC_BYPASS_MASK (0x200U)
#define RTC_CTRL_RTC_OSC_BYPASS_SHIFT (9U)
/*! RTC_OSC_BYPASS - RTC oscillator bypass control.
 *  0b0..The RTC Oscillator operates normally as a crystal oscillator with the crystal connected between the RTC_XTALIN
 * and RTC_XTALOUT pins. 0b1..The RTC Oscillator is in bypass mode. In this mode a clock can be directly input into the
 * RTC_XTALIN pin.
 */
#define RTC_CTRL_RTC_OSC_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC_OSC_BYPASS_SHIFT)) & RTC_CTRL_RTC_OSC_BYPASS_MASK)
#define RTC_CTRL_RTC_SUBSEC_ENA_MASK (0x400U)
#define RTC_CTRL_RTC_SUBSEC_ENA_SHIFT (10U)
/*! RTC_SUBSEC_ENA - RTC Sub-second counter control.
 *  0b0..The sub-second counter (if implemented) is disabled. This bit is cleared by a system-level POR or BOD
 *       reset as well as a by the RTC_ENA bit (bit 7 in this register). On modules not equipped with a sub-second
 *       counter, this bit will always read-back as a '0'.
 *  0b1..The 32 KHz sub-second counter is enabled (if implemented). Counting commences on the start of the first
 *       one-second interval after this bit is set. Note: This bit can only be set after the RTC_ENA bit (bit 7) is
 *       set by a previous write operation. Note: The RTC sub-second counter must be re-enabled whenever the chip
 *       exits deep power-down mode.
 */
#define RTC_CTRL_RTC_SUBSEC_ENA(x) \
    (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC_SUBSEC_ENA_SHIFT)) & RTC_CTRL_RTC_SUBSEC_ENA_MASK)
/*! @} */

/*! @name MATCH - RTC match register */
/*! @{ */
#define RTC_MATCH_MATVAL_MASK (0xFFFFFFFFU)
#define RTC_MATCH_MATVAL_SHIFT (0U)
/*! MATVAL - Contains the match value against which the 1 Hz RTC timer will be compared to set the
 *    alarm flag RTC_ALARM and generate an alarm interrupt/wake-up if enabled.
 */
#define RTC_MATCH_MATVAL(x) (((uint32_t)(((uint32_t)(x)) << RTC_MATCH_MATVAL_SHIFT)) & RTC_MATCH_MATVAL_MASK)
/*! @} */

/*! @name COUNT - RTC counter register */
/*! @{ */
#define RTC_COUNT_VAL_MASK (0xFFFFFFFFU)
#define RTC_COUNT_VAL_SHIFT (0U)
/*! VAL - A read reflects the current value of the main, 1 Hz RTC timer. A write loads a new initial
 *    value into the timer. The RTC counter will count up continuously at a 1 Hz rate once the RTC
 *    Software Reset is removed (by clearing bit 0 of the CTRL register). Only write to this
 *    register when the RTC_EN bit in the RTC CTRL Register is 0. The counter increments one second after
 *    the RTC_EN bit is set.
 */
#define RTC_COUNT_VAL(x) (((uint32_t)(((uint32_t)(x)) << RTC_COUNT_VAL_SHIFT)) & RTC_COUNT_VAL_MASK)
/*! @} */

/*! @name WAKE - High-resolution/wake-up timer control register */
/*! @{ */
#define RTC_WAKE_VAL_MASK (0xFFFFU)
#define RTC_WAKE_VAL_SHIFT (0U)
/*! VAL - A read reflects the current value of the high-resolution/wake-up timer. A write pre-loads
 *    a start count value into the wake-up timer and initializes a count-down sequence. Do not write
 *    to this register while counting is in progress.
 */
#define RTC_WAKE_VAL(x) (((uint32_t)(((uint32_t)(x)) << RTC_WAKE_VAL_SHIFT)) & RTC_WAKE_VAL_MASK)
/*! @} */

/*! @name SUBSEC - Sub-second counter register */
/*! @{ */
#define RTC_SUBSEC_SUBSEC_MASK (0x7FFFU)
#define RTC_SUBSEC_SUBSEC_SHIFT (0U)
/*! SUBSEC - A read reflects the current value of the 32KHz sub-second counter. This counter is
 *    cleared whenever the SUBSEC_ENA bit in the RTC_CONTROL register is low. Up-counting at a 32KHz
 *    rate commences at the start of the next one-second interval after the SUBSEC_ENA bit is set. This
 *    counter must be re-enabled after exiting deep power-down mode or after the main RTC module is
 *    disabled and re-enabled. On modules not equipped with a sub-second counter, this register
 *    will read-back as all zeroes.
 */
#define RTC_SUBSEC_SUBSEC(x) (((uint32_t)(((uint32_t)(x)) << RTC_SUBSEC_SUBSEC_SHIFT)) & RTC_SUBSEC_SUBSEC_MASK)
/*! @} */

/*! @name GPREG - General Purpose register */
/*! @{ */
#define RTC_GPREG_GPDATA_MASK (0xFFFFFFFFU)
#define RTC_GPREG_GPDATA_SHIFT (0U)
/*! GPDATA - Data retained during Deep power-down mode or loss of main power as long as VBAT is supplied.
 */
#define RTC_GPREG_GPDATA(x) (((uint32_t)(((uint32_t)(x)) << RTC_GPREG_GPDATA_SHIFT)) & RTC_GPREG_GPDATA_MASK)
/*! @} */

/* The count of RTC_GPREG */
#define RTC_GPREG_COUNT (8U)

/*!
 * @}
 */ /* end of group RTC_Register_Masks */

/* RTC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral RTC base address */
#define RTC_BASE (0x5002C000u)
/** Peripheral RTC base address */
#define RTC_BASE_NS (0x4002C000u)
/** Peripheral RTC base pointer */
#define RTC ((RTC_Type *)RTC_BASE)
/** Peripheral RTC base pointer */
#define RTC_NS ((RTC_Type *)RTC_BASE_NS)
/** Array initializer of RTC peripheral base addresses */
#define RTC_BASE_ADDRS \
    {                  \
        RTC_BASE       \
    }
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS \
    {                 \
        RTC           \
    }
/** Array initializer of RTC peripheral base addresses */
#define RTC_BASE_ADDRS_NS \
    {                     \
        RTC_BASE_NS       \
    }
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS_NS \
    {                    \
        RTC_NS           \
    }
#else
/** Peripheral RTC base address */
#define RTC_BASE (0x4002C000u)
/** Peripheral RTC base pointer */
#define RTC ((RTC_Type *)RTC_BASE)
/** Array initializer of RTC peripheral base addresses */
#define RTC_BASE_ADDRS \
    {                  \
        RTC_BASE       \
    }
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS \
    {                 \
        RTC           \
    }
#endif
/** Interrupt vectors for the RTC peripheral type */
#define RTC_IRQS \
    {            \
        RTC_IRQn \
    }

/*!
 * @}
 */ /* end of group RTC_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- SCT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCT_Peripheral_Access_Layer SCT Peripheral Access Layer
 * @{
 */

/** SCT - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CONFIG; /**< SCT configuration register, offset: 0x0 */
    __IO uint32_t CTRL;   /**< SCT control register, offset: 0x4 */
    __IO uint32_t LIMIT;  /**< SCT limit event select register, offset: 0x8 */
    __IO uint32_t HALT;   /**< SCT halt event select register, offset: 0xC */
    __IO uint32_t STOP;   /**< SCT stop event select register, offset: 0x10 */
    __IO uint32_t START;  /**< SCT start event select register, offset: 0x14 */
    uint8_t RESERVED_0[40];
    __IO uint32_t COUNT;         /**< SCT counter register, offset: 0x40 */
    __IO uint32_t STATE;         /**< SCT state register, offset: 0x44 */
    __I uint32_t INPUT;          /**< SCT input register, offset: 0x48 */
    __IO uint32_t REGMODE;       /**< SCT match/capture mode register, offset: 0x4C */
    __IO uint32_t OUTPUT;        /**< SCT output register, offset: 0x50 */
    __IO uint32_t OUTPUTDIRCTRL; /**< SCT output counter direction control register, offset: 0x54 */
    __IO uint32_t RES;           /**< SCT conflict resolution register, offset: 0x58 */
    __IO uint32_t DMAREQ0;       /**< SCT DMA request 0 register, offset: 0x5C */
    __IO uint32_t DMAREQ1;       /**< SCT DMA request 1 register, offset: 0x60 */
    uint8_t RESERVED_1[140];
    __IO uint32_t EVEN;    /**< SCT event interrupt enable register, offset: 0xF0 */
    __IO uint32_t EVFLAG;  /**< SCT event flag register, offset: 0xF4 */
    __IO uint32_t CONEN;   /**< SCT conflict interrupt enable register, offset: 0xF8 */
    __IO uint32_t CONFLAG; /**< SCT conflict flag register, offset: 0xFC */
    union
    {                          /* offset: 0x100 */
        __IO uint32_t CAP[16]; /**< SCT capture register of capture channel, array offset: 0x100, array step: 0x4 */
        __IO uint32_t
            MATCH[16]; /**< SCT match value register of match channels, array offset: 0x100, array step: 0x4 */
    };
    uint8_t RESERVED_2[192];
    union
    {                               /* offset: 0x200 */
        __IO uint32_t CAPCTRL[16];  /**< SCT capture control register, array offset: 0x200, array step: 0x4 */
        __IO uint32_t MATCHREL[16]; /**< SCT match reload value register, array offset: 0x200, array step: 0x4 */
    };
    uint8_t RESERVED_3[192];
    struct
    {                        /* offset: 0x300, array step: 0x8 */
        __IO uint32_t STATE; /**< SCT event state register 0, array offset: 0x300, array step: 0x8 */
        __IO uint32_t CTRL;  /**< SCT event control register 0, array offset: 0x304, array step: 0x8 */
    } EV[16];
    uint8_t RESERVED_4[384];
    struct
    {                      /* offset: 0x500, array step: 0x8 */
        __IO uint32_t SET; /**< SCT output 0 set register, array offset: 0x500, array step: 0x8 */
        __IO uint32_t CLR; /**< SCT output 0 clear register, array offset: 0x504, array step: 0x8 */
    } OUT[10];
} SCT_Type;

/* ----------------------------------------------------------------------------
   -- SCT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCT_Register_Masks SCT Register Masks
 * @{
 */

/*! @name CONFIG - SCT configuration register */
/*! @{ */
#define SCT_CONFIG_UNIFY_MASK (0x1U)
#define SCT_CONFIG_UNIFY_SHIFT (0U)
/*! UNIFY - SCT operation
 *  0b0..The SCT operates as two 16-bit counters named COUNTER_L and COUNTER_H.
 *  0b1..The SCT operates as a unified 32-bit counter.
 */
#define SCT_CONFIG_UNIFY(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_UNIFY_SHIFT)) & SCT_CONFIG_UNIFY_MASK)
#define SCT_CONFIG_CLKMODE_MASK (0x6U)
#define SCT_CONFIG_CLKMODE_SHIFT (1U)
/*! CLKMODE - SCT clock mode
 *  0b00..System Clock Mode. The system clock clocks the entire SCT module including the counter(s) and counter
 * prescalers. 0b01..Sampled System Clock Mode. The system clock clocks the SCT module, but the counter and prescalers
 * are only enabled to count when the designated edge is detected on the input selected by the CKSEL field. The minimum
 * pulse width on the selected clock-gate input is 1 bus clock period. This mode is the high-performance, sampled-clock
 * mode. 0b10..SCT Input Clock Mode. The input/edge selected by the CKSEL field clocks the SCT module, including the
 *        counters and prescalers, after first being synchronized to the system clock. The minimum pulse width on the
 *        clock input is 1 bus clock period. This mode is the low-power, sampled-clock mode.
 *  0b11..Asynchronous Mode. The entire SCT module is clocked directly by the input/edge selected by the CKSEL
 *        field. In this mode, the SCT outputs are switched synchronously to the SCT input clock - not the system
 *        clock. The input clock rate must be at least half the system clock rate and can be the same or faster than
 *        the system clock.
 */
#define SCT_CONFIG_CLKMODE(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_CLKMODE_SHIFT)) & SCT_CONFIG_CLKMODE_MASK)
#define SCT_CONFIG_CKSEL_MASK (0x78U)
#define SCT_CONFIG_CKSEL_SHIFT (3U)
/*! CKSEL - SCT clock select. The specific functionality of the designated input/edge is dependent
 *    on the CLKMODE bit selection in this register.
 *  0b0000..Rising edges on input 0.
 *  0b0001..Falling edges on input 0.
 *  0b0010..Rising edges on input 1.
 *  0b0011..Falling edges on input 1.
 *  0b0100..Rising edges on input 2.
 *  0b0101..Falling edges on input 2.
 *  0b0110..Rising edges on input 3.
 *  0b0111..Falling edges on input 3.
 *  0b1000..Rising edges on input 4.
 *  0b1001..Falling edges on input 4.
 *  0b1010..Rising edges on input 5.
 *  0b1011..Falling edges on input 5.
 *  0b1100..Rising edges on input 6.
 *  0b1101..Falling edges on input 6.
 *  0b1110..Rising edges on input 7.
 *  0b1111..Falling edges on input 7.
 */
#define SCT_CONFIG_CKSEL(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_CKSEL_SHIFT)) & SCT_CONFIG_CKSEL_MASK)
#define SCT_CONFIG_NORELOAD_L_MASK (0x80U)
#define SCT_CONFIG_NORELOAD_L_SHIFT (7U)
/*! NORELOAD_L - A 1 in this bit prevents the lower match registers from being reloaded from their
 *    respective reload registers. Setting this bit eliminates the need to write to the reload
 *    registers MATCHREL if the match values are fixed. Software can write to set or clear this bit at any
 *    time. This bit applies to both the higher and lower registers when the UNIFY bit is set.
 */
#define SCT_CONFIG_NORELOAD_L(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_NORELOAD_L_SHIFT)) & SCT_CONFIG_NORELOAD_L_MASK)
#define SCT_CONFIG_NORELOAD_H_MASK (0x100U)
#define SCT_CONFIG_NORELOAD_H_SHIFT (8U)
/*! NORELOAD_H - A 1 in this bit prevents the higher match registers from being reloaded from their
 *    respective reload registers. Setting this bit eliminates the need to write to the reload
 *    registers MATCHREL if the match values are fixed. Software can write to set or clear this bit at
 *    any time. This bit is not used when the UNIFY bit is set.
 */
#define SCT_CONFIG_NORELOAD_H(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_NORELOAD_H_SHIFT)) & SCT_CONFIG_NORELOAD_H_MASK)
#define SCT_CONFIG_INSYNC_MASK (0x1E00U)
#define SCT_CONFIG_INSYNC_SHIFT (9U)
/*! INSYNC - Synchronization for input N (bit 9 = input 0, bit 10 = input 1,, bit 12 = input 3); all
 *    other bits are reserved. A 1 in one of these bits subjects the corresponding input to
 *    synchronization to the SCT clock, before it is used to create an event. If an input is known to
 *    already be synchronous to the SCT clock, this bit may be set to 0 for faster input response. (Note:
 *    The SCT clock is the system clock for CKMODEs 0-2. It is the selected, asynchronous SCT input
 *    clock for CKMODE3). Note that the INSYNC field only affects inputs used for event generation.
 *    It does not apply to the clock input specified in the CKSEL field.
 */
#define SCT_CONFIG_INSYNC(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_INSYNC_SHIFT)) & SCT_CONFIG_INSYNC_MASK)
#define SCT_CONFIG_AUTOLIMIT_L_MASK (0x20000U)
#define SCT_CONFIG_AUTOLIMIT_L_SHIFT (17U)
/*! AUTOLIMIT_L - A one in this bit causes a match on match register 0 to be treated as a de-facto
 *    LIMIT condition without the need to define an associated event. As with any LIMIT event, this
 *    automatic limit causes the counter to be cleared to zero in unidirectional mode or to change
 *    the direction of count in bi-directional mode. Software can write to set or clear this bit at
 *    any time. This bit applies to both the higher and lower registers when the UNIFY bit is set.
 */
#define SCT_CONFIG_AUTOLIMIT_L(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_AUTOLIMIT_L_SHIFT)) & SCT_CONFIG_AUTOLIMIT_L_MASK)
#define SCT_CONFIG_AUTOLIMIT_H_MASK (0x40000U)
#define SCT_CONFIG_AUTOLIMIT_H_SHIFT (18U)
/*! AUTOLIMIT_H - A one in this bit will cause a match on match register 0 to be treated as a
 *    de-facto LIMIT condition without the need to define an associated event. As with any LIMIT event,
 *    this automatic limit causes the counter to be cleared to zero in unidirectional mode or to
 *    change the direction of count in bi-directional mode. Software can write to set or clear this bit
 *    at any time. This bit is not used when the UNIFY bit is set.
 */
#define SCT_CONFIG_AUTOLIMIT_H(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_AUTOLIMIT_H_SHIFT)) & SCT_CONFIG_AUTOLIMIT_H_MASK)
/*! @} */

/*! @name CTRL - SCT control register */
/*! @{ */
#define SCT_CTRL_DOWN_L_MASK (0x1U)
#define SCT_CTRL_DOWN_L_SHIFT (0U)
/*! DOWN_L - This bit is 1 when the L or unified counter is counting down. Hardware sets this bit
 *    when the counter is counting up, counter limit occurs, and BIDIR = 1.Hardware clears this bit
 *    when the counter is counting down and a limit condition occurs or when the counter reaches 0.
 */
#define SCT_CTRL_DOWN_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_DOWN_L_SHIFT)) & SCT_CTRL_DOWN_L_MASK)
#define SCT_CTRL_STOP_L_MASK (0x2U)
#define SCT_CTRL_STOP_L_SHIFT (1U)
/*! STOP_L - When this bit is 1 and HALT is 0, the L or unified counter does not run, but I/O events
 *    related to the counter can occur. If a designated start event occurs, this bit is cleared and
 *    counting resumes.
 */
#define SCT_CTRL_STOP_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_STOP_L_SHIFT)) & SCT_CTRL_STOP_L_MASK)
#define SCT_CTRL_HALT_L_MASK (0x4U)
#define SCT_CTRL_HALT_L_SHIFT (2U)
/*! HALT_L - When this bit is 1, the L or unified counter does not run and no events can occur. A
 *    reset sets this bit. When the HALT_L bit is one, the STOP_L bit is cleared. It is possible to
 *    remove the halt condition while keeping the SCT in the stop condition (not running) with a
 *    single write to this register to simultaneously clear the HALT bit and set the STOP bit. Once set,
 *    only software can clear this bit to restore counter operation. This bit is set on reset.
 */
#define SCT_CTRL_HALT_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_HALT_L_SHIFT)) & SCT_CTRL_HALT_L_MASK)
#define SCT_CTRL_CLRCTR_L_MASK (0x8U)
#define SCT_CTRL_CLRCTR_L_SHIFT (3U)
/*! CLRCTR_L - Writing a 1 to this bit clears the L or unified counter. This bit always reads as 0.
 */
#define SCT_CTRL_CLRCTR_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_CLRCTR_L_SHIFT)) & SCT_CTRL_CLRCTR_L_MASK)
#define SCT_CTRL_BIDIR_L_MASK (0x10U)
#define SCT_CTRL_BIDIR_L_SHIFT (4U)
/*! BIDIR_L - L or unified counter direction select
 *  0b0..Up. The counter counts up to a limit condition, then is cleared to zero.
 *  0b1..Up-down. The counter counts up to a limit, then counts down to a limit condition or to 0.
 */
#define SCT_CTRL_BIDIR_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_BIDIR_L_SHIFT)) & SCT_CTRL_BIDIR_L_MASK)
#define SCT_CTRL_PRE_L_MASK (0x1FE0U)
#define SCT_CTRL_PRE_L_SHIFT (5U)
/*! PRE_L - Specifies the factor by which the SCT clock is prescaled to produce the L or unified
 *    counter clock. The counter clock is clocked at the rate of the SCT clock divided by PRE_L+1.
 *    Clear the counter (by writing a 1 to the CLRCTR bit) whenever changing the PRE value.
 */
#define SCT_CTRL_PRE_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_PRE_L_SHIFT)) & SCT_CTRL_PRE_L_MASK)
#define SCT_CTRL_DOWN_H_MASK (0x10000U)
#define SCT_CTRL_DOWN_H_SHIFT (16U)
/*! DOWN_H - This bit is 1 when the H counter is counting down. Hardware sets this bit when the
 *    counter is counting, a counter limit condition occurs, and BIDIR is 1. Hardware clears this bit
 *    when the counter is counting down and a limit condition occurs or when the counter reaches 0.
 */
#define SCT_CTRL_DOWN_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_DOWN_H_SHIFT)) & SCT_CTRL_DOWN_H_MASK)
#define SCT_CTRL_STOP_H_MASK (0x20000U)
#define SCT_CTRL_STOP_H_SHIFT (17U)
/*! STOP_H - When this bit is 1 and HALT is 0, the H counter does not, run but I/O events related to
 *    the counter can occur. If such an event matches the mask in the Start register, this bit is
 *    cleared and counting resumes.
 */
#define SCT_CTRL_STOP_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_STOP_H_SHIFT)) & SCT_CTRL_STOP_H_MASK)
#define SCT_CTRL_HALT_H_MASK (0x40000U)
#define SCT_CTRL_HALT_H_SHIFT (18U)
/*! HALT_H - When this bit is 1, the H counter does not run and no events can occur. A reset sets
 *    this bit. When the HALT_H bit is one, the STOP_H bit is cleared. It is possible to remove the
 *    halt condition while keeping the SCT in the stop condition (not running) with a single write to
 *    this register to simultaneously clear the HALT bit and set the STOP bit. Once set, this bit
 *    can only be cleared by software to restore counter operation. This bit is set on reset.
 */
#define SCT_CTRL_HALT_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_HALT_H_SHIFT)) & SCT_CTRL_HALT_H_MASK)
#define SCT_CTRL_CLRCTR_H_MASK (0x80000U)
#define SCT_CTRL_CLRCTR_H_SHIFT (19U)
/*! CLRCTR_H - Writing a 1 to this bit clears the H counter. This bit always reads as 0.
 */
#define SCT_CTRL_CLRCTR_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_CLRCTR_H_SHIFT)) & SCT_CTRL_CLRCTR_H_MASK)
#define SCT_CTRL_BIDIR_H_MASK (0x100000U)
#define SCT_CTRL_BIDIR_H_SHIFT (20U)
/*! BIDIR_H - Direction select
 *  0b0..The H counter counts up to its limit condition, then is cleared to zero.
 *  0b1..The H counter counts up to its limit, then counts down to a limit condition or to 0.
 */
#define SCT_CTRL_BIDIR_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_BIDIR_H_SHIFT)) & SCT_CTRL_BIDIR_H_MASK)
#define SCT_CTRL_PRE_H_MASK (0x1FE00000U)
#define SCT_CTRL_PRE_H_SHIFT (21U)
/*! PRE_H - Specifies the factor by which the SCT clock is prescaled to produce the H counter clock.
 *    The counter clock is clocked at the rate of the SCT clock divided by PRELH+1. Clear the
 *    counter (by writing a 1 to the CLRCTR bit) whenever changing the PRE value.
 */
#define SCT_CTRL_PRE_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_PRE_H_SHIFT)) & SCT_CTRL_PRE_H_MASK)
/*! @} */

/*! @name LIMIT - SCT limit event select register */
/*! @{ */
#define SCT_LIMIT_LIMMSK_L_MASK (0xFFFFU)
#define SCT_LIMIT_LIMMSK_L_SHIFT (0U)
/*! LIMMSK_L - If bit n is one, event n is used as a counter limit for the L or unified counter
 *    (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_LIMIT_LIMMSK_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_LIMIT_LIMMSK_L_SHIFT)) & SCT_LIMIT_LIMMSK_L_MASK)
#define SCT_LIMIT_LIMMSK_H_MASK (0xFFFF0000U)
#define SCT_LIMIT_LIMMSK_H_SHIFT (16U)
/*! LIMMSK_H - If bit n is one, event n is used as a counter limit for the H counter (event 0 = bit
 *    16, event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_LIMIT_LIMMSK_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_LIMIT_LIMMSK_H_SHIFT)) & SCT_LIMIT_LIMMSK_H_MASK)
/*! @} */

/*! @name HALT - SCT halt event select register */
/*! @{ */
#define SCT_HALT_HALTMSK_L_MASK (0xFFFFU)
#define SCT_HALT_HALTMSK_L_SHIFT (0U)
/*! HALTMSK_L - If bit n is one, event n sets the HALT_L bit in the CTRL register (event 0 = bit 0,
 *    event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_HALT_HALTMSK_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_HALT_HALTMSK_L_SHIFT)) & SCT_HALT_HALTMSK_L_MASK)
#define SCT_HALT_HALTMSK_H_MASK (0xFFFF0000U)
#define SCT_HALT_HALTMSK_H_SHIFT (16U)
/*! HALTMSK_H - If bit n is one, event n sets the HALT_H bit in the CTRL register (event 0 = bit 16,
 *    event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_HALT_HALTMSK_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_HALT_HALTMSK_H_SHIFT)) & SCT_HALT_HALTMSK_H_MASK)
/*! @} */

/*! @name STOP - SCT stop event select register */
/*! @{ */
#define SCT_STOP_STOPMSK_L_MASK (0xFFFFU)
#define SCT_STOP_STOPMSK_L_SHIFT (0U)
/*! STOPMSK_L - If bit n is one, event n sets the STOP_L bit in the CTRL register (event 0 = bit 0,
 *    event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_STOP_STOPMSK_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_STOP_STOPMSK_L_SHIFT)) & SCT_STOP_STOPMSK_L_MASK)
#define SCT_STOP_STOPMSK_H_MASK (0xFFFF0000U)
#define SCT_STOP_STOPMSK_H_SHIFT (16U)
/*! STOPMSK_H - If bit n is one, event n sets the STOP_H bit in the CTRL register (event 0 = bit 16,
 *    event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_STOP_STOPMSK_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_STOP_STOPMSK_H_SHIFT)) & SCT_STOP_STOPMSK_H_MASK)
/*! @} */

/*! @name START - SCT start event select register */
/*! @{ */
#define SCT_START_STARTMSK_L_MASK (0xFFFFU)
#define SCT_START_STARTMSK_L_SHIFT (0U)
/*! STARTMSK_L - If bit n is one, event n clears the STOP_L bit in the CTRL register (event 0 = bit
 *    0, event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_START_STARTMSK_L(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_START_STARTMSK_L_SHIFT)) & SCT_START_STARTMSK_L_MASK)
#define SCT_START_STARTMSK_H_MASK (0xFFFF0000U)
#define SCT_START_STARTMSK_H_SHIFT (16U)
/*! STARTMSK_H - If bit n is one, event n clears the STOP_H bit in the CTRL register (event 0 = bit
 *    16, event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_START_STARTMSK_H(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_START_STARTMSK_H_SHIFT)) & SCT_START_STARTMSK_H_MASK)
/*! @} */

/*! @name COUNT - SCT counter register */
/*! @{ */
#define SCT_COUNT_CTR_L_MASK (0xFFFFU)
#define SCT_COUNT_CTR_L_SHIFT (0U)
/*! CTR_L - When UNIFY = 0, read or write the 16-bit L counter value. When UNIFY = 1, read or write
 *    the lower 16 bits of the 32-bit unified counter.
 */
#define SCT_COUNT_CTR_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_COUNT_CTR_L_SHIFT)) & SCT_COUNT_CTR_L_MASK)
#define SCT_COUNT_CTR_H_MASK (0xFFFF0000U)
#define SCT_COUNT_CTR_H_SHIFT (16U)
/*! CTR_H - When UNIFY = 0, read or write the 16-bit H counter value. When UNIFY = 1, read or write
 *    the upper 16 bits of the 32-bit unified counter.
 */
#define SCT_COUNT_CTR_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_COUNT_CTR_H_SHIFT)) & SCT_COUNT_CTR_H_MASK)
/*! @} */

/*! @name STATE - SCT state register */
/*! @{ */
#define SCT_STATE_STATE_L_MASK (0x1FU)
#define SCT_STATE_STATE_L_SHIFT (0U)
/*! STATE_L - State variable.
 */
#define SCT_STATE_STATE_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_STATE_STATE_L_SHIFT)) & SCT_STATE_STATE_L_MASK)
#define SCT_STATE_STATE_H_MASK (0x1F0000U)
#define SCT_STATE_STATE_H_SHIFT (16U)
/*! STATE_H - State variable.
 */
#define SCT_STATE_STATE_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_STATE_STATE_H_SHIFT)) & SCT_STATE_STATE_H_MASK)
/*! @} */

/*! @name INPUT - SCT input register */
/*! @{ */
#define SCT_INPUT_AIN0_MASK (0x1U)
#define SCT_INPUT_AIN0_SHIFT (0U)
/*! AIN0 - Input 0 state. Input 0 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN0(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN0_SHIFT)) & SCT_INPUT_AIN0_MASK)
#define SCT_INPUT_AIN1_MASK (0x2U)
#define SCT_INPUT_AIN1_SHIFT (1U)
/*! AIN1 - Input 1 state. Input 1 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN1(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN1_SHIFT)) & SCT_INPUT_AIN1_MASK)
#define SCT_INPUT_AIN2_MASK (0x4U)
#define SCT_INPUT_AIN2_SHIFT (2U)
/*! AIN2 - Input 2 state. Input 2 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN2(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN2_SHIFT)) & SCT_INPUT_AIN2_MASK)
#define SCT_INPUT_AIN3_MASK (0x8U)
#define SCT_INPUT_AIN3_SHIFT (3U)
/*! AIN3 - Input 3 state. Input 3 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN3(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN3_SHIFT)) & SCT_INPUT_AIN3_MASK)
#define SCT_INPUT_AIN4_MASK (0x10U)
#define SCT_INPUT_AIN4_SHIFT (4U)
/*! AIN4 - Input 4 state. Input 4 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN4(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN4_SHIFT)) & SCT_INPUT_AIN4_MASK)
#define SCT_INPUT_AIN5_MASK (0x20U)
#define SCT_INPUT_AIN5_SHIFT (5U)
/*! AIN5 - Input 5 state. Input 5 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN5(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN5_SHIFT)) & SCT_INPUT_AIN5_MASK)
#define SCT_INPUT_AIN6_MASK (0x40U)
#define SCT_INPUT_AIN6_SHIFT (6U)
/*! AIN6 - Input 6 state. Input 6 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN6(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN6_SHIFT)) & SCT_INPUT_AIN6_MASK)
#define SCT_INPUT_AIN7_MASK (0x80U)
#define SCT_INPUT_AIN7_SHIFT (7U)
/*! AIN7 - Input 7 state. Input 7 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN7(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN7_SHIFT)) & SCT_INPUT_AIN7_MASK)
#define SCT_INPUT_AIN8_MASK (0x100U)
#define SCT_INPUT_AIN8_SHIFT (8U)
/*! AIN8 - Input 8 state. Input 8 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN8(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN8_SHIFT)) & SCT_INPUT_AIN8_MASK)
#define SCT_INPUT_AIN9_MASK (0x200U)
#define SCT_INPUT_AIN9_SHIFT (9U)
/*! AIN9 - Input 9 state. Input 9 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN9(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN9_SHIFT)) & SCT_INPUT_AIN9_MASK)
#define SCT_INPUT_AIN10_MASK (0x400U)
#define SCT_INPUT_AIN10_SHIFT (10U)
/*! AIN10 - Input 10 state. Input 10 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN10(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN10_SHIFT)) & SCT_INPUT_AIN10_MASK)
#define SCT_INPUT_AIN11_MASK (0x800U)
#define SCT_INPUT_AIN11_SHIFT (11U)
/*! AIN11 - Input 11 state. Input 11 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN11(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN11_SHIFT)) & SCT_INPUT_AIN11_MASK)
#define SCT_INPUT_AIN12_MASK (0x1000U)
#define SCT_INPUT_AIN12_SHIFT (12U)
/*! AIN12 - Input 12 state. Input 12 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN12(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN12_SHIFT)) & SCT_INPUT_AIN12_MASK)
#define SCT_INPUT_AIN13_MASK (0x2000U)
#define SCT_INPUT_AIN13_SHIFT (13U)
/*! AIN13 - Input 13 state. Input 13 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN13(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN13_SHIFT)) & SCT_INPUT_AIN13_MASK)
#define SCT_INPUT_AIN14_MASK (0x4000U)
#define SCT_INPUT_AIN14_SHIFT (14U)
/*! AIN14 - Input 14 state. Input 14 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN14(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN14_SHIFT)) & SCT_INPUT_AIN14_MASK)
#define SCT_INPUT_AIN15_MASK (0x8000U)
#define SCT_INPUT_AIN15_SHIFT (15U)
/*! AIN15 - Input 15 state. Input 15 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN15(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN15_SHIFT)) & SCT_INPUT_AIN15_MASK)
#define SCT_INPUT_SIN0_MASK (0x10000U)
#define SCT_INPUT_SIN0_SHIFT (16U)
/*! SIN0 - Input 0 state. Input 0 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN0(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN0_SHIFT)) & SCT_INPUT_SIN0_MASK)
#define SCT_INPUT_SIN1_MASK (0x20000U)
#define SCT_INPUT_SIN1_SHIFT (17U)
/*! SIN1 - Input 1 state. Input 1 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN1(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN1_SHIFT)) & SCT_INPUT_SIN1_MASK)
#define SCT_INPUT_SIN2_MASK (0x40000U)
#define SCT_INPUT_SIN2_SHIFT (18U)
/*! SIN2 - Input 2 state. Input 2 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN2(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN2_SHIFT)) & SCT_INPUT_SIN2_MASK)
#define SCT_INPUT_SIN3_MASK (0x80000U)
#define SCT_INPUT_SIN3_SHIFT (19U)
/*! SIN3 - Input 3 state. Input 3 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN3(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN3_SHIFT)) & SCT_INPUT_SIN3_MASK)
#define SCT_INPUT_SIN4_MASK (0x100000U)
#define SCT_INPUT_SIN4_SHIFT (20U)
/*! SIN4 - Input 4 state. Input 4 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN4(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN4_SHIFT)) & SCT_INPUT_SIN4_MASK)
#define SCT_INPUT_SIN5_MASK (0x200000U)
#define SCT_INPUT_SIN5_SHIFT (21U)
/*! SIN5 - Input 5 state. Input 5 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN5(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN5_SHIFT)) & SCT_INPUT_SIN5_MASK)
#define SCT_INPUT_SIN6_MASK (0x400000U)
#define SCT_INPUT_SIN6_SHIFT (22U)
/*! SIN6 - Input 6 state. Input 6 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN6(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN6_SHIFT)) & SCT_INPUT_SIN6_MASK)
#define SCT_INPUT_SIN7_MASK (0x800000U)
#define SCT_INPUT_SIN7_SHIFT (23U)
/*! SIN7 - Input 7 state. Input 7 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN7(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN7_SHIFT)) & SCT_INPUT_SIN7_MASK)
#define SCT_INPUT_SIN8_MASK (0x1000000U)
#define SCT_INPUT_SIN8_SHIFT (24U)
/*! SIN8 - Input 8 state. Input 8 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN8(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN8_SHIFT)) & SCT_INPUT_SIN8_MASK)
#define SCT_INPUT_SIN9_MASK (0x2000000U)
#define SCT_INPUT_SIN9_SHIFT (25U)
/*! SIN9 - Input 9 state. Input 9 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN9(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN9_SHIFT)) & SCT_INPUT_SIN9_MASK)
#define SCT_INPUT_SIN10_MASK (0x4000000U)
#define SCT_INPUT_SIN10_SHIFT (26U)
/*! SIN10 - Input 10 state. Input 10 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN10(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN10_SHIFT)) & SCT_INPUT_SIN10_MASK)
#define SCT_INPUT_SIN11_MASK (0x8000000U)
#define SCT_INPUT_SIN11_SHIFT (27U)
/*! SIN11 - Input 11 state. Input 11 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN11(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN11_SHIFT)) & SCT_INPUT_SIN11_MASK)
#define SCT_INPUT_SIN12_MASK (0x10000000U)
#define SCT_INPUT_SIN12_SHIFT (28U)
/*! SIN12 - Input 12 state. Input 12 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN12(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN12_SHIFT)) & SCT_INPUT_SIN12_MASK)
#define SCT_INPUT_SIN13_MASK (0x20000000U)
#define SCT_INPUT_SIN13_SHIFT (29U)
/*! SIN13 - Input 13 state. Input 13 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN13(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN13_SHIFT)) & SCT_INPUT_SIN13_MASK)
#define SCT_INPUT_SIN14_MASK (0x40000000U)
#define SCT_INPUT_SIN14_SHIFT (30U)
/*! SIN14 - Input 14 state. Input 14 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN14(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN14_SHIFT)) & SCT_INPUT_SIN14_MASK)
#define SCT_INPUT_SIN15_MASK (0x80000000U)
#define SCT_INPUT_SIN15_SHIFT (31U)
/*! SIN15 - Input 15 state. Input 15 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN15(x) (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN15_SHIFT)) & SCT_INPUT_SIN15_MASK)
/*! @} */

/*! @name REGMODE - SCT match/capture mode register */
/*! @{ */
#define SCT_REGMODE_REGMOD_L_MASK (0xFFFFU)
#define SCT_REGMODE_REGMOD_L_SHIFT (0U)
/*! REGMOD_L - Each bit controls one match/capture register (register 0 = bit 0, register 1 = bit 1,
 *    etc.). The number of bits = number of match/captures in this SCT. 0 = register operates as
 *    match register. 1 = register operates as capture register.
 */
#define SCT_REGMODE_REGMOD_L(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_REGMODE_REGMOD_L_SHIFT)) & SCT_REGMODE_REGMOD_L_MASK)
#define SCT_REGMODE_REGMOD_H_MASK (0xFFFF0000U)
#define SCT_REGMODE_REGMOD_H_SHIFT (16U)
/*! REGMOD_H - Each bit controls one match/capture register (register 0 = bit 16, register 1 = bit
 *    17, etc.). The number of bits = number of match/captures in this SCT. 0 = register operates as
 *    match registers. 1 = register operates as capture registers.
 */
#define SCT_REGMODE_REGMOD_H(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_REGMODE_REGMOD_H_SHIFT)) & SCT_REGMODE_REGMOD_H_MASK)
/*! @} */

/*! @name OUTPUT - SCT output register */
/*! @{ */
#define SCT_OUTPUT_OUT_MASK (0xFFFFU)
#define SCT_OUTPUT_OUT_SHIFT (0U)
/*! OUT - Writing a 1 to bit n forces the corresponding output HIGH. Writing a 0 forces the
 *    corresponding output LOW (output 0 = bit 0, output 1 = bit 1, etc.). The number of bits = number of
 *    outputs in this SCT.
 */
#define SCT_OUTPUT_OUT(x) (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUT_OUT_SHIFT)) & SCT_OUTPUT_OUT_MASK)
/*! @} */

/*! @name OUTPUTDIRCTRL - SCT output counter direction control register */
/*! @{ */
#define SCT_OUTPUTDIRCTRL_SETCLR0_MASK (0x3U)
#define SCT_OUTPUTDIRCTRL_SETCLR0_SHIFT (0U)
/*! SETCLR0 - Set/clear operation on output 0. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR0(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR0_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR0_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR1_MASK (0xCU)
#define SCT_OUTPUTDIRCTRL_SETCLR1_SHIFT (2U)
/*! SETCLR1 - Set/clear operation on output 1. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR1(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR1_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR1_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR2_MASK (0x30U)
#define SCT_OUTPUTDIRCTRL_SETCLR2_SHIFT (4U)
/*! SETCLR2 - Set/clear operation on output 2. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR2(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR2_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR2_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR3_MASK (0xC0U)
#define SCT_OUTPUTDIRCTRL_SETCLR3_SHIFT (6U)
/*! SETCLR3 - Set/clear operation on output 3. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR3(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR3_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR3_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR4_MASK (0x300U)
#define SCT_OUTPUTDIRCTRL_SETCLR4_SHIFT (8U)
/*! SETCLR4 - Set/clear operation on output 4. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR4(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR4_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR4_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR5_MASK (0xC00U)
#define SCT_OUTPUTDIRCTRL_SETCLR5_SHIFT (10U)
/*! SETCLR5 - Set/clear operation on output 5. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR5(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR5_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR5_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR6_MASK (0x3000U)
#define SCT_OUTPUTDIRCTRL_SETCLR6_SHIFT (12U)
/*! SETCLR6 - Set/clear operation on output 6. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR6(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR6_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR6_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR7_MASK (0xC000U)
#define SCT_OUTPUTDIRCTRL_SETCLR7_SHIFT (14U)
/*! SETCLR7 - Set/clear operation on output 7. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR7(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR7_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR7_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR8_MASK (0x30000U)
#define SCT_OUTPUTDIRCTRL_SETCLR8_SHIFT (16U)
/*! SETCLR8 - Set/clear operation on output 8. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR8(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR8_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR8_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR9_MASK (0xC0000U)
#define SCT_OUTPUTDIRCTRL_SETCLR9_SHIFT (18U)
/*! SETCLR9 - Set/clear operation on output 9. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR9(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR9_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR9_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR10_MASK (0x300000U)
#define SCT_OUTPUTDIRCTRL_SETCLR10_SHIFT (20U)
/*! SETCLR10 - Set/clear operation on output 10. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR10(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR10_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR10_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR11_MASK (0xC00000U)
#define SCT_OUTPUTDIRCTRL_SETCLR11_SHIFT (22U)
/*! SETCLR11 - Set/clear operation on output 11. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR11(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR11_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR11_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR12_MASK (0x3000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR12_SHIFT (24U)
/*! SETCLR12 - Set/clear operation on output 12. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR12(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR12_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR12_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR13_MASK (0xC000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR13_SHIFT (26U)
/*! SETCLR13 - Set/clear operation on output 13. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR13(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR13_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR13_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR14_MASK (0x30000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR14_SHIFT (28U)
/*! SETCLR14 - Set/clear operation on output 14. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR14(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR14_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR14_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR15_MASK (0xC0000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR15_SHIFT (30U)
/*! SETCLR15 - Set/clear operation on output 15. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR15(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR15_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR15_MASK)
/*! @} */

/*! @name RES - SCT conflict resolution register */
/*! @{ */
#define SCT_RES_O0RES_MASK (0x3U)
#define SCT_RES_O0RES_SHIFT (0U)
/*! O0RES - Effect of simultaneous set and clear on output 0.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR0 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR0 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O0RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O0RES_SHIFT)) & SCT_RES_O0RES_MASK)
#define SCT_RES_O1RES_MASK (0xCU)
#define SCT_RES_O1RES_SHIFT (2U)
/*! O1RES - Effect of simultaneous set and clear on output 1.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR1 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR1 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O1RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O1RES_SHIFT)) & SCT_RES_O1RES_MASK)
#define SCT_RES_O2RES_MASK (0x30U)
#define SCT_RES_O2RES_SHIFT (4U)
/*! O2RES - Effect of simultaneous set and clear on output 2.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR2 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output n (or set based on the SETCLR2 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O2RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O2RES_SHIFT)) & SCT_RES_O2RES_MASK)
#define SCT_RES_O3RES_MASK (0xC0U)
#define SCT_RES_O3RES_SHIFT (6U)
/*! O3RES - Effect of simultaneous set and clear on output 3.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR3 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR3 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O3RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O3RES_SHIFT)) & SCT_RES_O3RES_MASK)
#define SCT_RES_O4RES_MASK (0x300U)
#define SCT_RES_O4RES_SHIFT (8U)
/*! O4RES - Effect of simultaneous set and clear on output 4.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR4 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR4 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O4RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O4RES_SHIFT)) & SCT_RES_O4RES_MASK)
#define SCT_RES_O5RES_MASK (0xC00U)
#define SCT_RES_O5RES_SHIFT (10U)
/*! O5RES - Effect of simultaneous set and clear on output 5.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR5 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR5 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O5RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O5RES_SHIFT)) & SCT_RES_O5RES_MASK)
#define SCT_RES_O6RES_MASK (0x3000U)
#define SCT_RES_O6RES_SHIFT (12U)
/*! O6RES - Effect of simultaneous set and clear on output 6.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR6 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR6 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O6RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O6RES_SHIFT)) & SCT_RES_O6RES_MASK)
#define SCT_RES_O7RES_MASK (0xC000U)
#define SCT_RES_O7RES_SHIFT (14U)
/*! O7RES - Effect of simultaneous set and clear on output 7.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR7 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output n (or set based on the SETCLR7 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O7RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O7RES_SHIFT)) & SCT_RES_O7RES_MASK)
#define SCT_RES_O8RES_MASK (0x30000U)
#define SCT_RES_O8RES_SHIFT (16U)
/*! O8RES - Effect of simultaneous set and clear on output 8.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR8 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR8 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O8RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O8RES_SHIFT)) & SCT_RES_O8RES_MASK)
#define SCT_RES_O9RES_MASK (0xC0000U)
#define SCT_RES_O9RES_SHIFT (18U)
/*! O9RES - Effect of simultaneous set and clear on output 9.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR9 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR9 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O9RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O9RES_SHIFT)) & SCT_RES_O9RES_MASK)
#define SCT_RES_O10RES_MASK (0x300000U)
#define SCT_RES_O10RES_SHIFT (20U)
/*! O10RES - Effect of simultaneous set and clear on output 10.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR10 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR10 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O10RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O10RES_SHIFT)) & SCT_RES_O10RES_MASK)
#define SCT_RES_O11RES_MASK (0xC00000U)
#define SCT_RES_O11RES_SHIFT (22U)
/*! O11RES - Effect of simultaneous set and clear on output 11.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR11 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR11 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O11RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O11RES_SHIFT)) & SCT_RES_O11RES_MASK)
#define SCT_RES_O12RES_MASK (0x3000000U)
#define SCT_RES_O12RES_SHIFT (24U)
/*! O12RES - Effect of simultaneous set and clear on output 12.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR12 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR12 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O12RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O12RES_SHIFT)) & SCT_RES_O12RES_MASK)
#define SCT_RES_O13RES_MASK (0xC000000U)
#define SCT_RES_O13RES_SHIFT (26U)
/*! O13RES - Effect of simultaneous set and clear on output 13.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR13 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR13 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O13RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O13RES_SHIFT)) & SCT_RES_O13RES_MASK)
#define SCT_RES_O14RES_MASK (0x30000000U)
#define SCT_RES_O14RES_SHIFT (28U)
/*! O14RES - Effect of simultaneous set and clear on output 14.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR14 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR14 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O14RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O14RES_SHIFT)) & SCT_RES_O14RES_MASK)
#define SCT_RES_O15RES_MASK (0xC0000000U)
#define SCT_RES_O15RES_SHIFT (30U)
/*! O15RES - Effect of simultaneous set and clear on output 15.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR15 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR15 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O15RES(x) (((uint32_t)(((uint32_t)(x)) << SCT_RES_O15RES_SHIFT)) & SCT_RES_O15RES_MASK)
/*! @} */

/*! @name DMAREQ0 - SCT DMA request 0 register */
/*! @{ */
#define SCT_DMAREQ0_DEV_0_MASK (0xFFFFU)
#define SCT_DMAREQ0_DEV_0_SHIFT (0U)
/*! DEV_0 - If bit n is one, event n triggers DMA request 0 (event 0 = bit 0, event 1 = bit 1,
 *    etc.). The number of bits = number of events in this SCT.
 */
#define SCT_DMAREQ0_DEV_0(x) (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ0_DEV_0_SHIFT)) & SCT_DMAREQ0_DEV_0_MASK)
#define SCT_DMAREQ0_DRL0_MASK (0x40000000U)
#define SCT_DMAREQ0_DRL0_SHIFT (30U)
/*! DRL0 - A 1 in this bit triggers DMA request 0 when it loads the MATCH_L/Unified registers from the RELOAD_L/Unified
 * registers.
 */
#define SCT_DMAREQ0_DRL0(x) (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ0_DRL0_SHIFT)) & SCT_DMAREQ0_DRL0_MASK)
#define SCT_DMAREQ0_DRQ0_MASK (0x80000000U)
#define SCT_DMAREQ0_DRQ0_SHIFT (31U)
/*! DRQ0 - This read-only bit indicates the state of DMA Request 0. Note that if the related DMA
 *    channel is enabled and properly set up, it is unlikely that software will see this flag, it will
 *    be cleared rapidly by the DMA service. The flag remaining set could point to an issue with DMA
 *    setup.
 */
#define SCT_DMAREQ0_DRQ0(x) (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ0_DRQ0_SHIFT)) & SCT_DMAREQ0_DRQ0_MASK)
/*! @} */

/*! @name DMAREQ1 - SCT DMA request 1 register */
/*! @{ */
#define SCT_DMAREQ1_DEV_1_MASK (0xFFFFU)
#define SCT_DMAREQ1_DEV_1_SHIFT (0U)
/*! DEV_1 - If bit n is one, event n triggers DMA request 1 (event 0 = bit 0, event 1 = bit 1,
 *    etc.). The number of bits = number of events in this SCT.
 */
#define SCT_DMAREQ1_DEV_1(x) (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ1_DEV_1_SHIFT)) & SCT_DMAREQ1_DEV_1_MASK)
#define SCT_DMAREQ1_DRL1_MASK (0x40000000U)
#define SCT_DMAREQ1_DRL1_SHIFT (30U)
/*! DRL1 - A 1 in this bit triggers DMA request 1 when it loads the Match L/Unified registers from the Reload L/Unified
 * registers.
 */
#define SCT_DMAREQ1_DRL1(x) (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ1_DRL1_SHIFT)) & SCT_DMAREQ1_DRL1_MASK)
#define SCT_DMAREQ1_DRQ1_MASK (0x80000000U)
#define SCT_DMAREQ1_DRQ1_SHIFT (31U)
/*! DRQ1 - This read-only bit indicates the state of DMA Request 1. Note that if the related DMA
 *    channel is enabled and properly set up, it is unlikely that software will see this flag, it will
 *    be cleared rapidly by the DMA service. The flag remaining set could point to an issue with DMA
 *    setup.
 */
#define SCT_DMAREQ1_DRQ1(x) (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ1_DRQ1_SHIFT)) & SCT_DMAREQ1_DRQ1_MASK)
/*! @} */

/*! @name EVEN - SCT event interrupt enable register */
/*! @{ */
#define SCT_EVEN_IEN_MASK (0xFFFFU)
#define SCT_EVEN_IEN_SHIFT (0U)
/*! IEN - The SCT requests an interrupt when bit n of this register and the event flag register are
 *    both one (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of events in
 *    this SCT.
 */
#define SCT_EVEN_IEN(x) (((uint32_t)(((uint32_t)(x)) << SCT_EVEN_IEN_SHIFT)) & SCT_EVEN_IEN_MASK)
/*! @} */

/*! @name EVFLAG - SCT event flag register */
/*! @{ */
#define SCT_EVFLAG_FLAG_MASK (0xFFFFU)
#define SCT_EVFLAG_FLAG_SHIFT (0U)
/*! FLAG - Bit n is one if event n has occurred since reset or a 1 was last written to this bit
 *    (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_EVFLAG_FLAG(x) (((uint32_t)(((uint32_t)(x)) << SCT_EVFLAG_FLAG_SHIFT)) & SCT_EVFLAG_FLAG_MASK)
/*! @} */

/*! @name CONEN - SCT conflict interrupt enable register */
/*! @{ */
#define SCT_CONEN_NCEN_MASK (0xFFFFU)
#define SCT_CONEN_NCEN_SHIFT (0U)
/*! NCEN - The SCT requests an interrupt when bit n of this register and the SCT conflict flag
 *    register are both one (output 0 = bit 0, output 1 = bit 1, etc.). The number of bits = number of
 *    outputs in this SCT.
 */
#define SCT_CONEN_NCEN(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONEN_NCEN_SHIFT)) & SCT_CONEN_NCEN_MASK)
/*! @} */

/*! @name CONFLAG - SCT conflict flag register */
/*! @{ */
#define SCT_CONFLAG_NCFLAG_MASK (0xFFFFU)
#define SCT_CONFLAG_NCFLAG_SHIFT (0U)
/*! NCFLAG - Bit n is one if a no-change conflict event occurred on output n since reset or a 1 was
 *    last written to this bit (output 0 = bit 0, output 1 = bit 1, etc.). The number of bits =
 *    number of outputs in this SCT.
 */
#define SCT_CONFLAG_NCFLAG(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFLAG_NCFLAG_SHIFT)) & SCT_CONFLAG_NCFLAG_MASK)
#define SCT_CONFLAG_BUSERRL_MASK (0x40000000U)
#define SCT_CONFLAG_BUSERRL_SHIFT (30U)
/*! BUSERRL - The most recent bus error from this SCT involved writing CTR L/Unified, STATE
 *    L/Unified, MATCH L/Unified, or the Output register when the L/U counter was not halted. A word write
 *    to certain L and H registers can be half successful and half unsuccessful.
 */
#define SCT_CONFLAG_BUSERRL(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFLAG_BUSERRL_SHIFT)) & SCT_CONFLAG_BUSERRL_MASK)
#define SCT_CONFLAG_BUSERRH_MASK (0x80000000U)
#define SCT_CONFLAG_BUSERRH_SHIFT (31U)
/*! BUSERRH - The most recent bus error from this SCT involved writing CTR H, STATE H, MATCH H, or
 *    the Output register when the H counter was not halted.
 */
#define SCT_CONFLAG_BUSERRH(x) (((uint32_t)(((uint32_t)(x)) << SCT_CONFLAG_BUSERRH_SHIFT)) & SCT_CONFLAG_BUSERRH_MASK)
/*! @} */

/*! @name CAP - SCT capture register of capture channel */
/*! @{ */
#define SCT_CAP_CAPn_L_MASK (0xFFFFU)
#define SCT_CAP_CAPn_L_SHIFT (0U)
/*! CAPn_L - When UNIFY = 0, read the 16-bit counter value at which this register was last captured.
 *    When UNIFY = 1, read the lower 16 bits of the 32-bit value at which this register was last
 *    captured.
 */
#define SCT_CAP_CAPn_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_CAP_CAPn_L_SHIFT)) & SCT_CAP_CAPn_L_MASK)
#define SCT_CAP_CAPn_H_MASK (0xFFFF0000U)
#define SCT_CAP_CAPn_H_SHIFT (16U)
/*! CAPn_H - When UNIFY = 0, read the 16-bit counter value at which this register was last captured.
 *    When UNIFY = 1, read the upper 16 bits of the 32-bit value at which this register was last
 *    captured.
 */
#define SCT_CAP_CAPn_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_CAP_CAPn_H_SHIFT)) & SCT_CAP_CAPn_H_MASK)
/*! @} */

/* The count of SCT_CAP */
#define SCT_CAP_COUNT (16U)

/*! @name MATCH - SCT match value register of match channels */
/*! @{ */
#define SCT_MATCH_MATCHn_L_MASK (0xFFFFU)
#define SCT_MATCH_MATCHn_L_SHIFT (0U)
/*! MATCHn_L - When UNIFY = 0, read or write the 16-bit value to be compared to the L counter. When
 *    UNIFY = 1, read or write the lower 16 bits of the 32-bit value to be compared to the unified
 *    counter.
 */
#define SCT_MATCH_MATCHn_L(x) (((uint32_t)(((uint32_t)(x)) << SCT_MATCH_MATCHn_L_SHIFT)) & SCT_MATCH_MATCHn_L_MASK)
#define SCT_MATCH_MATCHn_H_MASK (0xFFFF0000U)
#define SCT_MATCH_MATCHn_H_SHIFT (16U)
/*! MATCHn_H - When UNIFY = 0, read or write the 16-bit value to be compared to the H counter. When
 *    UNIFY = 1, read or write the upper 16 bits of the 32-bit value to be compared to the unified
 *    counter.
 */
#define SCT_MATCH_MATCHn_H(x) (((uint32_t)(((uint32_t)(x)) << SCT_MATCH_MATCHn_H_SHIFT)) & SCT_MATCH_MATCHn_H_MASK)
/*! @} */

/* The count of SCT_MATCH */
#define SCT_MATCH_COUNT (16U)

/*! @name CAPCTRL - SCT capture control register */
/*! @{ */
#define SCT_CAPCTRL_CAPCONn_L_MASK (0xFFFFU)
#define SCT_CAPCTRL_CAPCONn_L_SHIFT (0U)
/*! CAPCONn_L - If bit m is one, event m causes the CAPn_L (UNIFY = 0) or the CAPn (UNIFY = 1)
 *    register to be loaded (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of
 *    match/captures in this SCT.
 */
#define SCT_CAPCTRL_CAPCONn_L(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_CAPCTRL_CAPCONn_L_SHIFT)) & SCT_CAPCTRL_CAPCONn_L_MASK)
#define SCT_CAPCTRL_CAPCONn_H_MASK (0xFFFF0000U)
#define SCT_CAPCTRL_CAPCONn_H_SHIFT (16U)
/*! CAPCONn_H - If bit m is one, event m causes the CAPn_H (UNIFY = 0) register to be loaded (event
 *    0 = bit 16, event 1 = bit 17, etc.). The number of bits = number of match/captures in this SCT.
 */
#define SCT_CAPCTRL_CAPCONn_H(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_CAPCTRL_CAPCONn_H_SHIFT)) & SCT_CAPCTRL_CAPCONn_H_MASK)
/*! @} */

/* The count of SCT_CAPCTRL */
#define SCT_CAPCTRL_COUNT (16U)

/*! @name MATCHREL - SCT match reload value register */
/*! @{ */
#define SCT_MATCHREL_RELOADn_L_MASK (0xFFFFU)
#define SCT_MATCHREL_RELOADn_L_SHIFT (0U)
/*! RELOADn_L - When UNIFY = 0, specifies the 16-bit value to be loaded into the MATCHn_L register.
 *    When UNIFY = 1, specifies the lower 16 bits of the 32-bit value to be loaded into the MATCHn
 *    register.
 */
#define SCT_MATCHREL_RELOADn_L(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_MATCHREL_RELOADn_L_SHIFT)) & SCT_MATCHREL_RELOADn_L_MASK)
#define SCT_MATCHREL_RELOADn_H_MASK (0xFFFF0000U)
#define SCT_MATCHREL_RELOADn_H_SHIFT (16U)
/*! RELOADn_H - When UNIFY = 0, specifies the 16-bit to be loaded into the MATCHn_H register. When
 *    UNIFY = 1, specifies the upper 16 bits of the 32-bit value to be loaded into the MATCHn
 *    register.
 */
#define SCT_MATCHREL_RELOADn_H(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_MATCHREL_RELOADn_H_SHIFT)) & SCT_MATCHREL_RELOADn_H_MASK)
/*! @} */

/* The count of SCT_MATCHREL */
#define SCT_MATCHREL_COUNT (16U)

/*! @name EV_STATE - SCT event state register 0 */
/*! @{ */
#define SCT_EV_STATE_STATEMSKn_MASK (0xFFFFU)
#define SCT_EV_STATE_STATEMSKn_SHIFT (0U)
/*! STATEMSKn - If bit m is one, event n happens in state m of the counter selected by the HEVENT
 *    bit (n = event number, m = state number; state 0 = bit 0, state 1= bit 1, etc.). The number of
 *    bits = number of states in this SCT.
 */
#define SCT_EV_STATE_STATEMSKn(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_EV_STATE_STATEMSKn_SHIFT)) & SCT_EV_STATE_STATEMSKn_MASK)
/*! @} */

/* The count of SCT_EV_STATE */
#define SCT_EV_STATE_COUNT (16U)

/*! @name EV_CTRL - SCT event control register 0 */
/*! @{ */
#define SCT_EV_CTRL_MATCHSEL_MASK (0xFU)
#define SCT_EV_CTRL_MATCHSEL_SHIFT (0U)
/*! MATCHSEL - Selects the Match register associated with this event (if any). A match can occur
 *    only when the counter selected by the HEVENT bit is running.
 */
#define SCT_EV_CTRL_MATCHSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_MATCHSEL_SHIFT)) & SCT_EV_CTRL_MATCHSEL_MASK)
#define SCT_EV_CTRL_HEVENT_MASK (0x10U)
#define SCT_EV_CTRL_HEVENT_SHIFT (4U)
/*! HEVENT - Select L/H counter. Do not set this bit if UNIFY = 1.
 *  0b0..Selects the L state and the L match register selected by MATCHSEL.
 *  0b1..Selects the H state and the H match register selected by MATCHSEL.
 */
#define SCT_EV_CTRL_HEVENT(x) (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_HEVENT_SHIFT)) & SCT_EV_CTRL_HEVENT_MASK)
#define SCT_EV_CTRL_OUTSEL_MASK (0x20U)
#define SCT_EV_CTRL_OUTSEL_SHIFT (5U)
/*! OUTSEL - Input/output select
 *  0b0..Selects the inputs selected by IOSEL.
 *  0b1..Selects the outputs selected by IOSEL.
 */
#define SCT_EV_CTRL_OUTSEL(x) (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_OUTSEL_SHIFT)) & SCT_EV_CTRL_OUTSEL_MASK)
#define SCT_EV_CTRL_IOSEL_MASK (0x3C0U)
#define SCT_EV_CTRL_IOSEL_SHIFT (6U)
/*! IOSEL - Selects the input or output signal number associated with this event (if any). Do not
 *    select an input in this register if CKMODE is 1x. In this case the clock input is an implicit
 *    ingredient of every event.
 */
#define SCT_EV_CTRL_IOSEL(x) (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_IOSEL_SHIFT)) & SCT_EV_CTRL_IOSEL_MASK)
#define SCT_EV_CTRL_IOCOND_MASK (0xC00U)
#define SCT_EV_CTRL_IOCOND_SHIFT (10U)
/*! IOCOND - Selects the I/O condition for event n. (The detection of edges on outputs lag the
 *    conditions that switch the outputs by one SCT clock). In order to guarantee proper edge/state
 *    detection, an input must have a minimum pulse width of at least one SCT clock period .
 *  0b00..LOW
 *  0b01..Rise
 *  0b10..Fall
 *  0b11..HIGH
 */
#define SCT_EV_CTRL_IOCOND(x) (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_IOCOND_SHIFT)) & SCT_EV_CTRL_IOCOND_MASK)
#define SCT_EV_CTRL_COMBMODE_MASK (0x3000U)
#define SCT_EV_CTRL_COMBMODE_SHIFT (12U)
/*! COMBMODE - Selects how the specified match and I/O condition are used and combined.
 *  0b00..OR. The event occurs when either the specified match or I/O condition occurs.
 *  0b01..MATCH. Uses the specified match only.
 *  0b10..IO. Uses the specified I/O condition only.
 *  0b11..AND. The event occurs when the specified match and I/O condition occur simultaneously.
 */
#define SCT_EV_CTRL_COMBMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_COMBMODE_SHIFT)) & SCT_EV_CTRL_COMBMODE_MASK)
#define SCT_EV_CTRL_STATELD_MASK (0x4000U)
#define SCT_EV_CTRL_STATELD_SHIFT (14U)
/*! STATELD - This bit controls how the STATEV value modifies the state selected by HEVENT when this
 *    event is the highest-numbered event occurring for that state.
 *  0b0..STATEV value is added into STATE (the carry-out is ignored).
 *  0b1..STATEV value is loaded into STATE.
 */
#define SCT_EV_CTRL_STATELD(x) (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_STATELD_SHIFT)) & SCT_EV_CTRL_STATELD_MASK)
#define SCT_EV_CTRL_STATEV_MASK (0xF8000U)
#define SCT_EV_CTRL_STATEV_SHIFT (15U)
/*! STATEV - This value is loaded into or added to the state selected by HEVENT, depending on
 *    STATELD, when this event is the highest-numbered event occurring for that state. If STATELD and
 *    STATEV are both zero, there is no change to the STATE value.
 */
#define SCT_EV_CTRL_STATEV(x) (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_STATEV_SHIFT)) & SCT_EV_CTRL_STATEV_MASK)
#define SCT_EV_CTRL_MATCHMEM_MASK (0x100000U)
#define SCT_EV_CTRL_MATCHMEM_SHIFT (20U)
/*! MATCHMEM - If this bit is one and the COMBMODE field specifies a match component to the
 *    triggering of this event, then a match is considered to be active whenever the counter value is
 *    GREATER THAN OR EQUAL TO the value specified in the match register when counting up, LESS THEN OR
 *    EQUAL TO the match value when counting down. If this bit is zero, a match is only be active
 *    during the cycle when the counter is equal to the match value.
 */
#define SCT_EV_CTRL_MATCHMEM(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_MATCHMEM_SHIFT)) & SCT_EV_CTRL_MATCHMEM_MASK)
#define SCT_EV_CTRL_DIRECTION_MASK (0x600000U)
#define SCT_EV_CTRL_DIRECTION_SHIFT (21U)
/*! DIRECTION - Direction qualifier for event generation. This field only applies when the counters
 *    are operating in BIDIR mode. If BIDIR = 0, the SCT ignores this field. Value 0x3 is reserved.
 *  0b00..Direction independent. This event is triggered regardless of the count direction.
 *  0b01..Counting up. This event is triggered only during up-counting when BIDIR = 1.
 *  0b10..Counting down. This event is triggered only during down-counting when BIDIR = 1.
 */
#define SCT_EV_CTRL_DIRECTION(x) \
    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_DIRECTION_SHIFT)) & SCT_EV_CTRL_DIRECTION_MASK)
/*! @} */

/* The count of SCT_EV_CTRL */
#define SCT_EV_CTRL_COUNT (16U)

/*! @name OUT_SET - SCT output 0 set register */
/*! @{ */
#define SCT_OUT_SET_SET_MASK (0xFFFFU)
#define SCT_OUT_SET_SET_SHIFT (0U)
/*! SET - A 1 in bit m selects event m to set output n (or clear it if SETCLRn = 0x1 or 0x2) output
 *    0 = bit 0, output 1 = bit 1, etc. The number of bits = number of events in this SCT. When the
 *    counter is used in bi-directional mode, it is possible to reverse the action specified by the
 *    output set and clear registers when counting down, See the OUTPUTCTRL register.
 */
#define SCT_OUT_SET_SET(x) (((uint32_t)(((uint32_t)(x)) << SCT_OUT_SET_SET_SHIFT)) & SCT_OUT_SET_SET_MASK)
/*! @} */

/* The count of SCT_OUT_SET */
#define SCT_OUT_SET_COUNT (10U)

/*! @name OUT_CLR - SCT output 0 clear register */
/*! @{ */
#define SCT_OUT_CLR_CLR_MASK (0xFFFFU)
#define SCT_OUT_CLR_CLR_SHIFT (0U)
/*! CLR - A 1 in bit m selects event m to clear output n (or set it if SETCLRn = 0x1 or 0x2) event 0
 *    = bit 0, event 1 = bit 1, etc. The number of bits = number of events in this SCT. When the
 *    counter is used in bi-directional mode, it is possible to reverse the action specified by the
 *    output set and clear registers when counting down, See the OUTPUTCTRL register.
 */
#define SCT_OUT_CLR_CLR(x) (((uint32_t)(((uint32_t)(x)) << SCT_OUT_CLR_CLR_SHIFT)) & SCT_OUT_CLR_CLR_MASK)
/*! @} */

/* The count of SCT_OUT_CLR */
#define SCT_OUT_CLR_COUNT (10U)

/*!
 * @}
 */ /* end of group SCT_Register_Masks */

/* SCT - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral SCT0 base address */
#define SCT0_BASE (0x50085000u)
/** Peripheral SCT0 base address */
#define SCT0_BASE_NS (0x40085000u)
/** Peripheral SCT0 base pointer */
#define SCT0 ((SCT_Type *)SCT0_BASE)
/** Peripheral SCT0 base pointer */
#define SCT0_NS ((SCT_Type *)SCT0_BASE_NS)
/** Array initializer of SCT peripheral base addresses */
#define SCT_BASE_ADDRS \
    {                  \
        SCT0_BASE      \
    }
/** Array initializer of SCT peripheral base pointers */
#define SCT_BASE_PTRS \
    {                 \
        SCT0          \
    }
/** Array initializer of SCT peripheral base addresses */
#define SCT_BASE_ADDRS_NS \
    {                     \
        SCT0_BASE_NS      \
    }
/** Array initializer of SCT peripheral base pointers */
#define SCT_BASE_PTRS_NS \
    {                    \
        SCT0_NS          \
    }
#else
/** Peripheral SCT0 base address */
#define SCT0_BASE (0x40085000u)
/** Peripheral SCT0 base pointer */
#define SCT0 ((SCT_Type *)SCT0_BASE)
/** Array initializer of SCT peripheral base addresses */
#define SCT_BASE_ADDRS \
    {                  \
        SCT0_BASE      \
    }
/** Array initializer of SCT peripheral base pointers */
#define SCT_BASE_PTRS \
    {                 \
        SCT0          \
    }
#endif
/** Interrupt vectors for the SCT peripheral type */
#define SCT_IRQS  \
    {             \
        SCT0_IRQn \
    }

/*!
 * @}
 */ /* end of group SCT_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- SDIF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SDIF_Peripheral_Access_Layer SDIF Peripheral Access Layer
 * @{
 */

/** SDIF - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL;   /**< Control register, offset: 0x0 */
    __IO uint32_t PWREN;  /**< Power Enable register, offset: 0x4 */
    __IO uint32_t CLKDIV; /**< Clock Divider register, offset: 0x8 */
    uint8_t RESERVED_0[4];
    __IO uint32_t CLKENA;  /**< Clock Enable register, offset: 0x10 */
    __IO uint32_t TMOUT;   /**< Time-out register, offset: 0x14 */
    __IO uint32_t CTYPE;   /**< Card Type register, offset: 0x18 */
    __IO uint32_t BLKSIZ;  /**< Block Size register, offset: 0x1C */
    __IO uint32_t BYTCNT;  /**< Byte Count register, offset: 0x20 */
    __IO uint32_t INTMASK; /**< Interrupt Mask register, offset: 0x24 */
    __IO uint32_t CMDARG;  /**< Command Argument register, offset: 0x28 */
    __IO uint32_t CMD;     /**< Command register, offset: 0x2C */
    __IO uint32_t RESP[4]; /**< Response register, array offset: 0x30, array step: 0x4 */
    __IO uint32_t MINTSTS; /**< Masked Interrupt Status register, offset: 0x40 */
    __IO uint32_t RINTSTS; /**< Raw Interrupt Status register, offset: 0x44 */
    __IO uint32_t STATUS;  /**< Status register, offset: 0x48 */
    __IO uint32_t FIFOTH;  /**< FIFO Threshold Watermark register, offset: 0x4C */
    __IO uint32_t CDETECT; /**< Card Detect register, offset: 0x50 */
    __IO uint32_t WRTPRT;  /**< Write Protect register, offset: 0x54 */
    uint8_t RESERVED_1[4];
    __IO uint32_t TCBCNT; /**< Transferred CIU Card Byte Count register, offset: 0x5C */
    __IO uint32_t TBBCNT; /**< Transferred Host to BIU-FIFO Byte Count register, offset: 0x60 */
    __IO uint32_t DEBNCE; /**< Debounce Count register, offset: 0x64 */
    uint8_t RESERVED_2[16];
    __IO uint32_t RST_N; /**< Hardware Reset, offset: 0x78 */
    uint8_t RESERVED_3[4];
    __IO uint32_t BMOD;    /**< Bus Mode register, offset: 0x80 */
    __IO uint32_t PLDMND;  /**< Poll Demand register, offset: 0x84 */
    __IO uint32_t DBADDR;  /**< Descriptor List Base Address register, offset: 0x88 */
    __IO uint32_t IDSTS;   /**< Internal DMAC Status register, offset: 0x8C */
    __IO uint32_t IDINTEN; /**< Internal DMAC Interrupt Enable register, offset: 0x90 */
    __IO uint32_t DSCADDR; /**< Current Host Descriptor Address register, offset: 0x94 */
    __IO uint32_t BUFADDR; /**< Current Buffer Descriptor Address register, offset: 0x98 */
    uint8_t RESERVED_4[100];
    __IO uint32_t CARDTHRCTL; /**< Card Threshold Control, offset: 0x100 */
    __IO uint32_t BACKENDPWR; /**< Power control, offset: 0x104 */
    uint8_t RESERVED_5[248];
    __IO uint32_t FIFO[64]; /**< SDIF FIFO, array offset: 0x200, array step: 0x4 */
} SDIF_Type;

/* ----------------------------------------------------------------------------
   -- SDIF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SDIF_Register_Masks SDIF Register Masks
 * @{
 */

/*! @name CTRL - Control register */
/*! @{ */
#define SDIF_CTRL_CONTROLLER_RESET_MASK (0x1U)
#define SDIF_CTRL_CONTROLLER_RESET_SHIFT (0U)
/*! CONTROLLER_RESET - Controller reset.
 */
#define SDIF_CTRL_CONTROLLER_RESET(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CONTROLLER_RESET_SHIFT)) & SDIF_CTRL_CONTROLLER_RESET_MASK)
#define SDIF_CTRL_FIFO_RESET_MASK (0x2U)
#define SDIF_CTRL_FIFO_RESET_SHIFT (1U)
/*! FIFO_RESET - Fifo reset.
 */
#define SDIF_CTRL_FIFO_RESET(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_FIFO_RESET_SHIFT)) & SDIF_CTRL_FIFO_RESET_MASK)
#define SDIF_CTRL_DMA_RESET_MASK (0x4U)
#define SDIF_CTRL_DMA_RESET_SHIFT (2U)
/*! DMA_RESET - DMA reset.
 */
#define SDIF_CTRL_DMA_RESET(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_DMA_RESET_SHIFT)) & SDIF_CTRL_DMA_RESET_MASK)
#define SDIF_CTRL_INT_ENABLE_MASK (0x10U)
#define SDIF_CTRL_INT_ENABLE_SHIFT (4U)
/*! INT_ENABLE - Global interrupt enable/disable bit.
 */
#define SDIF_CTRL_INT_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_INT_ENABLE_SHIFT)) & SDIF_CTRL_INT_ENABLE_MASK)
#define SDIF_CTRL_READ_WAIT_MASK (0x40U)
#define SDIF_CTRL_READ_WAIT_SHIFT (6U)
/*! READ_WAIT - Read/wait.
 */
#define SDIF_CTRL_READ_WAIT(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_READ_WAIT_SHIFT)) & SDIF_CTRL_READ_WAIT_MASK)
#define SDIF_CTRL_SEND_IRQ_RESPONSE_MASK (0x80U)
#define SDIF_CTRL_SEND_IRQ_RESPONSE_SHIFT (7U)
/*! SEND_IRQ_RESPONSE - Send irq response.
 */
#define SDIF_CTRL_SEND_IRQ_RESPONSE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_SEND_IRQ_RESPONSE_SHIFT)) & SDIF_CTRL_SEND_IRQ_RESPONSE_MASK)
#define SDIF_CTRL_ABORT_READ_DATA_MASK (0x100U)
#define SDIF_CTRL_ABORT_READ_DATA_SHIFT (8U)
/*! ABORT_READ_DATA - Abort read data.
 */
#define SDIF_CTRL_ABORT_READ_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_ABORT_READ_DATA_SHIFT)) & SDIF_CTRL_ABORT_READ_DATA_MASK)
#define SDIF_CTRL_SEND_CCSD_MASK (0x200U)
#define SDIF_CTRL_SEND_CCSD_SHIFT (9U)
/*! SEND_CCSD - Send ccsd.
 */
#define SDIF_CTRL_SEND_CCSD(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_SEND_CCSD_SHIFT)) & SDIF_CTRL_SEND_CCSD_MASK)
#define SDIF_CTRL_SEND_AUTO_STOP_CCSD_MASK (0x400U)
#define SDIF_CTRL_SEND_AUTO_STOP_CCSD_SHIFT (10U)
/*! SEND_AUTO_STOP_CCSD - Send auto stop ccsd.
 */
#define SDIF_CTRL_SEND_AUTO_STOP_CCSD(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_SEND_AUTO_STOP_CCSD_SHIFT)) & SDIF_CTRL_SEND_AUTO_STOP_CCSD_MASK)
#define SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_MASK (0x800U)
#define SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_SHIFT (11U)
/*! CEATA_DEVICE_INTERRUPT_STATUS - CEATA device interrupt status.
 */
#define SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_SHIFT)) & \
     SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_MASK)
#define SDIF_CTRL_CARD_VOLTAGE_A0_MASK (0x10000U)
#define SDIF_CTRL_CARD_VOLTAGE_A0_SHIFT (16U)
/*! CARD_VOLTAGE_A0 - Controls the state of the SD_VOLT0 pin.
 */
#define SDIF_CTRL_CARD_VOLTAGE_A0(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CARD_VOLTAGE_A0_SHIFT)) & SDIF_CTRL_CARD_VOLTAGE_A0_MASK)
#define SDIF_CTRL_CARD_VOLTAGE_A1_MASK (0x20000U)
#define SDIF_CTRL_CARD_VOLTAGE_A1_SHIFT (17U)
/*! CARD_VOLTAGE_A1 - Controls the state of the SD_VOLT1 pin.
 */
#define SDIF_CTRL_CARD_VOLTAGE_A1(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CARD_VOLTAGE_A1_SHIFT)) & SDIF_CTRL_CARD_VOLTAGE_A1_MASK)
#define SDIF_CTRL_CARD_VOLTAGE_A2_MASK (0x40000U)
#define SDIF_CTRL_CARD_VOLTAGE_A2_SHIFT (18U)
/*! CARD_VOLTAGE_A2 - Controls the state of the SD_VOLT2 pin.
 */
#define SDIF_CTRL_CARD_VOLTAGE_A2(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CARD_VOLTAGE_A2_SHIFT)) & SDIF_CTRL_CARD_VOLTAGE_A2_MASK)
#define SDIF_CTRL_USE_INTERNAL_DMAC_MASK (0x2000000U)
#define SDIF_CTRL_USE_INTERNAL_DMAC_SHIFT (25U)
/*! USE_INTERNAL_DMAC - SD/MMC DMA use.
 */
#define SDIF_CTRL_USE_INTERNAL_DMAC(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_USE_INTERNAL_DMAC_SHIFT)) & SDIF_CTRL_USE_INTERNAL_DMAC_MASK)
/*! @} */

/*! @name PWREN - Power Enable register */
/*! @{ */
#define SDIF_PWREN_POWER_ENABLE0_MASK (0x1U)
#define SDIF_PWREN_POWER_ENABLE0_SHIFT (0U)
/*! POWER_ENABLE0 - Power on/off switch for card 0; once power is turned on, software should wait
 *    for regulator/switch ramp-up time before trying to initialize card 0.
 */
#define SDIF_PWREN_POWER_ENABLE0(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_PWREN_POWER_ENABLE0_SHIFT)) & SDIF_PWREN_POWER_ENABLE0_MASK)
#define SDIF_PWREN_POWER_ENABLE1_MASK (0x2U)
#define SDIF_PWREN_POWER_ENABLE1_SHIFT (1U)
/*! POWER_ENABLE1 - Power on/off switch for card 1; once power is turned on, software should wait
 *    for regulator/switch ramp-up time before trying to initialize card 1.
 */
#define SDIF_PWREN_POWER_ENABLE1(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_PWREN_POWER_ENABLE1_SHIFT)) & SDIF_PWREN_POWER_ENABLE1_MASK)
/*! @} */

/*! @name CLKDIV - Clock Divider register */
/*! @{ */
#define SDIF_CLKDIV_CLK_DIVIDER0_MASK (0xFFU)
#define SDIF_CLKDIV_CLK_DIVIDER0_SHIFT (0U)
/*! CLK_DIVIDER0 - Clock divider-0 value.
 */
#define SDIF_CLKDIV_CLK_DIVIDER0(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CLKDIV_CLK_DIVIDER0_SHIFT)) & SDIF_CLKDIV_CLK_DIVIDER0_MASK)
/*! @} */

/*! @name CLKENA - Clock Enable register */
/*! @{ */
#define SDIF_CLKENA_CCLK0_ENABLE_MASK (0x1U)
#define SDIF_CLKENA_CCLK0_ENABLE_SHIFT (0U)
/*! CCLK0_ENABLE - Clock-enable control for SD card 0 clock.
 */
#define SDIF_CLKENA_CCLK0_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CLKENA_CCLK0_ENABLE_SHIFT)) & SDIF_CLKENA_CCLK0_ENABLE_MASK)
#define SDIF_CLKENA_CCLK1_ENABLE_MASK (0x2U)
#define SDIF_CLKENA_CCLK1_ENABLE_SHIFT (1U)
/*! CCLK1_ENABLE - Clock-enable control for SD card 1 clock.
 */
#define SDIF_CLKENA_CCLK1_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CLKENA_CCLK1_ENABLE_SHIFT)) & SDIF_CLKENA_CCLK1_ENABLE_MASK)
#define SDIF_CLKENA_CCLK0_LOW_POWER_MASK (0x10000U)
#define SDIF_CLKENA_CCLK0_LOW_POWER_SHIFT (16U)
/*! CCLK0_LOW_POWER - Low-power control for SD card 0 clock.
 */
#define SDIF_CLKENA_CCLK0_LOW_POWER(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CLKENA_CCLK0_LOW_POWER_SHIFT)) & SDIF_CLKENA_CCLK0_LOW_POWER_MASK)
#define SDIF_CLKENA_CCLK1_LOW_POWER_MASK (0x20000U)
#define SDIF_CLKENA_CCLK1_LOW_POWER_SHIFT (17U)
/*! CCLK1_LOW_POWER - Low-power control for SD card 1 clock.
 */
#define SDIF_CLKENA_CCLK1_LOW_POWER(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CLKENA_CCLK1_LOW_POWER_SHIFT)) & SDIF_CLKENA_CCLK1_LOW_POWER_MASK)
/*! @} */

/*! @name TMOUT - Time-out register */
/*! @{ */
#define SDIF_TMOUT_RESPONSE_TIMEOUT_MASK (0xFFU)
#define SDIF_TMOUT_RESPONSE_TIMEOUT_SHIFT (0U)
/*! RESPONSE_TIMEOUT - Response time-out value.
 */
#define SDIF_TMOUT_RESPONSE_TIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_TMOUT_RESPONSE_TIMEOUT_SHIFT)) & SDIF_TMOUT_RESPONSE_TIMEOUT_MASK)
#define SDIF_TMOUT_DATA_TIMEOUT_MASK (0xFFFFFF00U)
#define SDIF_TMOUT_DATA_TIMEOUT_SHIFT (8U)
/*! DATA_TIMEOUT - Value for card Data Read time-out; same value also used for Data Starvation by Host time-out.
 */
#define SDIF_TMOUT_DATA_TIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_TMOUT_DATA_TIMEOUT_SHIFT)) & SDIF_TMOUT_DATA_TIMEOUT_MASK)
/*! @} */

/*! @name CTYPE - Card Type register */
/*! @{ */
#define SDIF_CTYPE_CARD0_WIDTH0_MASK (0x1U)
#define SDIF_CTYPE_CARD0_WIDTH0_SHIFT (0U)
/*! CARD0_WIDTH0 - Indicates if card 0 is 1-bit or 4-bit: 0 - 1-bit mode 1 - 4-bit mode 1 and 4-bit
 *    modes only work when 8-bit mode in CARD0_WIDTH1 is not enabled (bit 16 in this register is set
 *    to 0).
 */
#define SDIF_CTYPE_CARD0_WIDTH0(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTYPE_CARD0_WIDTH0_SHIFT)) & SDIF_CTYPE_CARD0_WIDTH0_MASK)
#define SDIF_CTYPE_CARD1_WIDTH0_MASK (0x2U)
#define SDIF_CTYPE_CARD1_WIDTH0_SHIFT (1U)
/*! CARD1_WIDTH0 - Indicates if card 1 is 1-bit or 4-bit: 0 - 1-bit mode 1 - 4-bit mode 1 and 4-bit
 *    modes only work when 8-bit mode in CARD1_WIDTH1 is not enabled (bit 16 in this register is set
 *    to 0).
 */
#define SDIF_CTYPE_CARD1_WIDTH0(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTYPE_CARD1_WIDTH0_SHIFT)) & SDIF_CTYPE_CARD1_WIDTH0_MASK)
#define SDIF_CTYPE_CARD0_WIDTH1_MASK (0x10000U)
#define SDIF_CTYPE_CARD0_WIDTH1_SHIFT (16U)
/*! CARD0_WIDTH1 - Indicates if card 0 is 8-bit: 0 - Non 8-bit mode 1 - 8-bit mode.
 */
#define SDIF_CTYPE_CARD0_WIDTH1(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTYPE_CARD0_WIDTH1_SHIFT)) & SDIF_CTYPE_CARD0_WIDTH1_MASK)
#define SDIF_CTYPE_CARD1_WIDTH1_MASK (0x20000U)
#define SDIF_CTYPE_CARD1_WIDTH1_SHIFT (17U)
/*! CARD1_WIDTH1 - Indicates if card 1 is 8-bit: 0 - Non 8-bit mode 1 - 8-bit mode.
 */
#define SDIF_CTYPE_CARD1_WIDTH1(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CTYPE_CARD1_WIDTH1_SHIFT)) & SDIF_CTYPE_CARD1_WIDTH1_MASK)
/*! @} */

/*! @name BLKSIZ - Block Size register */
/*! @{ */
#define SDIF_BLKSIZ_BLOCK_SIZE_MASK (0xFFFFU)
#define SDIF_BLKSIZ_BLOCK_SIZE_SHIFT (0U)
/*! BLOCK_SIZE - Block size.
 */
#define SDIF_BLKSIZ_BLOCK_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_BLKSIZ_BLOCK_SIZE_SHIFT)) & SDIF_BLKSIZ_BLOCK_SIZE_MASK)
/*! @} */

/*! @name BYTCNT - Byte Count register */
/*! @{ */
#define SDIF_BYTCNT_BYTE_COUNT_MASK (0xFFFFFFFFU)
#define SDIF_BYTCNT_BYTE_COUNT_SHIFT (0U)
/*! BYTE_COUNT - Number of bytes to be transferred; should be integer multiple of Block Size for block transfers.
 */
#define SDIF_BYTCNT_BYTE_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_BYTCNT_BYTE_COUNT_SHIFT)) & SDIF_BYTCNT_BYTE_COUNT_MASK)
/*! @} */

/*! @name INTMASK - Interrupt Mask register */
/*! @{ */
#define SDIF_INTMASK_CDET_MASK (0x1U)
#define SDIF_INTMASK_CDET_SHIFT (0U)
/*! CDET - Card detect.
 */
#define SDIF_INTMASK_CDET(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_CDET_SHIFT)) & SDIF_INTMASK_CDET_MASK)
#define SDIF_INTMASK_RE_MASK (0x2U)
#define SDIF_INTMASK_RE_SHIFT (1U)
/*! RE - Response error.
 */
#define SDIF_INTMASK_RE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RE_SHIFT)) & SDIF_INTMASK_RE_MASK)
#define SDIF_INTMASK_CDONE_MASK (0x4U)
#define SDIF_INTMASK_CDONE_SHIFT (2U)
/*! CDONE - Command done.
 */
#define SDIF_INTMASK_CDONE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_CDONE_SHIFT)) & SDIF_INTMASK_CDONE_MASK)
#define SDIF_INTMASK_DTO_MASK (0x8U)
#define SDIF_INTMASK_DTO_SHIFT (3U)
/*! DTO - Data transfer over.
 */
#define SDIF_INTMASK_DTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_DTO_SHIFT)) & SDIF_INTMASK_DTO_MASK)
#define SDIF_INTMASK_TXDR_MASK (0x10U)
#define SDIF_INTMASK_TXDR_SHIFT (4U)
/*! TXDR - Transmit FIFO data request.
 */
#define SDIF_INTMASK_TXDR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_TXDR_SHIFT)) & SDIF_INTMASK_TXDR_MASK)
#define SDIF_INTMASK_RXDR_MASK (0x20U)
#define SDIF_INTMASK_RXDR_SHIFT (5U)
/*! RXDR - Receive FIFO data request.
 */
#define SDIF_INTMASK_RXDR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RXDR_SHIFT)) & SDIF_INTMASK_RXDR_MASK)
#define SDIF_INTMASK_RCRC_MASK (0x40U)
#define SDIF_INTMASK_RCRC_SHIFT (6U)
/*! RCRC - Response CRC error.
 */
#define SDIF_INTMASK_RCRC(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RCRC_SHIFT)) & SDIF_INTMASK_RCRC_MASK)
#define SDIF_INTMASK_DCRC_MASK (0x80U)
#define SDIF_INTMASK_DCRC_SHIFT (7U)
/*! DCRC - Data CRC error.
 */
#define SDIF_INTMASK_DCRC(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_DCRC_SHIFT)) & SDIF_INTMASK_DCRC_MASK)
#define SDIF_INTMASK_RTO_MASK (0x100U)
#define SDIF_INTMASK_RTO_SHIFT (8U)
/*! RTO - Response time-out.
 */
#define SDIF_INTMASK_RTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RTO_SHIFT)) & SDIF_INTMASK_RTO_MASK)
#define SDIF_INTMASK_DRTO_MASK (0x200U)
#define SDIF_INTMASK_DRTO_SHIFT (9U)
/*! DRTO - Data read time-out.
 */
#define SDIF_INTMASK_DRTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_DRTO_SHIFT)) & SDIF_INTMASK_DRTO_MASK)
#define SDIF_INTMASK_HTO_MASK (0x400U)
#define SDIF_INTMASK_HTO_SHIFT (10U)
/*! HTO - Data starvation-by-host time-out (HTO).
 */
#define SDIF_INTMASK_HTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_HTO_SHIFT)) & SDIF_INTMASK_HTO_MASK)
#define SDIF_INTMASK_FRUN_MASK (0x800U)
#define SDIF_INTMASK_FRUN_SHIFT (11U)
/*! FRUN - FIFO underrun/overrun error.
 */
#define SDIF_INTMASK_FRUN(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_FRUN_SHIFT)) & SDIF_INTMASK_FRUN_MASK)
#define SDIF_INTMASK_HLE_MASK (0x1000U)
#define SDIF_INTMASK_HLE_SHIFT (12U)
/*! HLE - Hardware locked write error.
 */
#define SDIF_INTMASK_HLE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_HLE_SHIFT)) & SDIF_INTMASK_HLE_MASK)
#define SDIF_INTMASK_SBE_MASK (0x2000U)
#define SDIF_INTMASK_SBE_SHIFT (13U)
/*! SBE - Start-bit error.
 */
#define SDIF_INTMASK_SBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_SBE_SHIFT)) & SDIF_INTMASK_SBE_MASK)
#define SDIF_INTMASK_ACD_MASK (0x4000U)
#define SDIF_INTMASK_ACD_SHIFT (14U)
/*! ACD - Auto command done.
 */
#define SDIF_INTMASK_ACD(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_ACD_SHIFT)) & SDIF_INTMASK_ACD_MASK)
#define SDIF_INTMASK_EBE_MASK (0x8000U)
#define SDIF_INTMASK_EBE_SHIFT (15U)
/*! EBE - End-bit error (read)/Write no CRC.
 */
#define SDIF_INTMASK_EBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_EBE_SHIFT)) & SDIF_INTMASK_EBE_MASK)
#define SDIF_INTMASK_SDIO_INT_MASK_MASK (0x10000U)
#define SDIF_INTMASK_SDIO_INT_MASK_SHIFT (16U)
/*! SDIO_INT_MASK - Mask SDIO interrupt.
 */
#define SDIF_INTMASK_SDIO_INT_MASK(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_SDIO_INT_MASK_SHIFT)) & SDIF_INTMASK_SDIO_INT_MASK_MASK)
/*! @} */

/*! @name CMDARG - Command Argument register */
/*! @{ */
#define SDIF_CMDARG_CMD_ARG_MASK (0xFFFFFFFFU)
#define SDIF_CMDARG_CMD_ARG_SHIFT (0U)
/*! CMD_ARG - Value indicates command argument to be passed to card.
 */
#define SDIF_CMDARG_CMD_ARG(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CMDARG_CMD_ARG_SHIFT)) & SDIF_CMDARG_CMD_ARG_MASK)
/*! @} */

/*! @name CMD - Command register */
/*! @{ */
#define SDIF_CMD_CMD_INDEX_MASK (0x3FU)
#define SDIF_CMD_CMD_INDEX_SHIFT (0U)
/*! CMD_INDEX - Command index.
 */
#define SDIF_CMD_CMD_INDEX(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CMD_INDEX_SHIFT)) & SDIF_CMD_CMD_INDEX_MASK)
#define SDIF_CMD_RESPONSE_EXPECT_MASK (0x40U)
#define SDIF_CMD_RESPONSE_EXPECT_SHIFT (6U)
/*! RESPONSE_EXPECT - Response expect.
 */
#define SDIF_CMD_RESPONSE_EXPECT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_RESPONSE_EXPECT_SHIFT)) & SDIF_CMD_RESPONSE_EXPECT_MASK)
#define SDIF_CMD_RESPONSE_LENGTH_MASK (0x80U)
#define SDIF_CMD_RESPONSE_LENGTH_SHIFT (7U)
/*! RESPONSE_LENGTH - Response length.
 */
#define SDIF_CMD_RESPONSE_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_RESPONSE_LENGTH_SHIFT)) & SDIF_CMD_RESPONSE_LENGTH_MASK)
#define SDIF_CMD_CHECK_RESPONSE_CRC_MASK (0x100U)
#define SDIF_CMD_CHECK_RESPONSE_CRC_SHIFT (8U)
/*! CHECK_RESPONSE_CRC - Check response CRC.
 */
#define SDIF_CMD_CHECK_RESPONSE_CRC(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CHECK_RESPONSE_CRC_SHIFT)) & SDIF_CMD_CHECK_RESPONSE_CRC_MASK)
#define SDIF_CMD_DATA_EXPECTED_MASK (0x200U)
#define SDIF_CMD_DATA_EXPECTED_SHIFT (9U)
/*! DATA_EXPECTED - Data expected.
 */
#define SDIF_CMD_DATA_EXPECTED(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_DATA_EXPECTED_SHIFT)) & SDIF_CMD_DATA_EXPECTED_MASK)
#define SDIF_CMD_READ_WRITE_MASK (0x400U)
#define SDIF_CMD_READ_WRITE_SHIFT (10U)
/*! READ_WRITE - read/write.
 */
#define SDIF_CMD_READ_WRITE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_READ_WRITE_SHIFT)) & SDIF_CMD_READ_WRITE_MASK)
#define SDIF_CMD_TRANSFER_MODE_MASK (0x800U)
#define SDIF_CMD_TRANSFER_MODE_SHIFT (11U)
/*! TRANSFER_MODE - Transfer mode.
 */
#define SDIF_CMD_TRANSFER_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_TRANSFER_MODE_SHIFT)) & SDIF_CMD_TRANSFER_MODE_MASK)
#define SDIF_CMD_SEND_AUTO_STOP_MASK (0x1000U)
#define SDIF_CMD_SEND_AUTO_STOP_SHIFT (12U)
/*! SEND_AUTO_STOP - Send auto stop.
 */
#define SDIF_CMD_SEND_AUTO_STOP(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_SEND_AUTO_STOP_SHIFT)) & SDIF_CMD_SEND_AUTO_STOP_MASK)
#define SDIF_CMD_WAIT_PRVDATA_COMPLETE_MASK (0x2000U)
#define SDIF_CMD_WAIT_PRVDATA_COMPLETE_SHIFT (13U)
/*! WAIT_PRVDATA_COMPLETE - Wait prvdata complete.
 */
#define SDIF_CMD_WAIT_PRVDATA_COMPLETE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_WAIT_PRVDATA_COMPLETE_SHIFT)) & SDIF_CMD_WAIT_PRVDATA_COMPLETE_MASK)
#define SDIF_CMD_STOP_ABORT_CMD_MASK (0x4000U)
#define SDIF_CMD_STOP_ABORT_CMD_SHIFT (14U)
/*! STOP_ABORT_CMD - Stop abort command.
 */
#define SDIF_CMD_STOP_ABORT_CMD(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_STOP_ABORT_CMD_SHIFT)) & SDIF_CMD_STOP_ABORT_CMD_MASK)
#define SDIF_CMD_SEND_INITIALIZATION_MASK (0x8000U)
#define SDIF_CMD_SEND_INITIALIZATION_SHIFT (15U)
/*! SEND_INITIALIZATION - Send initialization.
 */
#define SDIF_CMD_SEND_INITIALIZATION(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_SEND_INITIALIZATION_SHIFT)) & SDIF_CMD_SEND_INITIALIZATION_MASK)
#define SDIF_CMD_CARD_NUMBER_MASK (0x1F0000U)
#define SDIF_CMD_CARD_NUMBER_SHIFT (16U)
/*! CARD_NUMBER - Specifies the card number of SDCARD for which the current Command is being executed
 *  0b00000..Command will be execute on SDCARD 0
 *  0b00001..Command will be execute on SDCARD 1
 */
#define SDIF_CMD_CARD_NUMBER(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CARD_NUMBER_SHIFT)) & SDIF_CMD_CARD_NUMBER_MASK)
#define SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_MASK (0x200000U)
#define SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_SHIFT (21U)
/*! UPDATE_CLOCK_REGISTERS_ONLY - Update clock registers only.
 */
#define SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_SHIFT)) & \
     SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_MASK)
#define SDIF_CMD_READ_CEATA_DEVICE_MASK (0x400000U)
#define SDIF_CMD_READ_CEATA_DEVICE_SHIFT (22U)
/*! READ_CEATA_DEVICE - Read ceata device.
 */
#define SDIF_CMD_READ_CEATA_DEVICE(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_READ_CEATA_DEVICE_SHIFT)) & SDIF_CMD_READ_CEATA_DEVICE_MASK)
#define SDIF_CMD_CCS_EXPECTED_MASK (0x800000U)
#define SDIF_CMD_CCS_EXPECTED_SHIFT (23U)
/*! CCS_EXPECTED - CCS expected.
 */
#define SDIF_CMD_CCS_EXPECTED(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CCS_EXPECTED_SHIFT)) & SDIF_CMD_CCS_EXPECTED_MASK)
#define SDIF_CMD_ENABLE_BOOT_MASK (0x1000000U)
#define SDIF_CMD_ENABLE_BOOT_SHIFT (24U)
/*! ENABLE_BOOT - Enable Boot - this bit should be set only for mandatory boot mode.
 */
#define SDIF_CMD_ENABLE_BOOT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_ENABLE_BOOT_SHIFT)) & SDIF_CMD_ENABLE_BOOT_MASK)
#define SDIF_CMD_EXPECT_BOOT_ACK_MASK (0x2000000U)
#define SDIF_CMD_EXPECT_BOOT_ACK_SHIFT (25U)
/*! EXPECT_BOOT_ACK - Expect Boot Acknowledge.
 */
#define SDIF_CMD_EXPECT_BOOT_ACK(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_EXPECT_BOOT_ACK_SHIFT)) & SDIF_CMD_EXPECT_BOOT_ACK_MASK)
#define SDIF_CMD_DISABLE_BOOT_MASK (0x4000000U)
#define SDIF_CMD_DISABLE_BOOT_SHIFT (26U)
/*! DISABLE_BOOT - Disable Boot.
 */
#define SDIF_CMD_DISABLE_BOOT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_DISABLE_BOOT_SHIFT)) & SDIF_CMD_DISABLE_BOOT_MASK)
#define SDIF_CMD_BOOT_MODE_MASK (0x8000000U)
#define SDIF_CMD_BOOT_MODE_SHIFT (27U)
/*! BOOT_MODE - Boot Mode.
 */
#define SDIF_CMD_BOOT_MODE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_BOOT_MODE_SHIFT)) & SDIF_CMD_BOOT_MODE_MASK)
#define SDIF_CMD_VOLT_SWITCH_MASK (0x10000000U)
#define SDIF_CMD_VOLT_SWITCH_SHIFT (28U)
/*! VOLT_SWITCH - Voltage switch bit.
 */
#define SDIF_CMD_VOLT_SWITCH(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_VOLT_SWITCH_SHIFT)) & SDIF_CMD_VOLT_SWITCH_MASK)
#define SDIF_CMD_USE_HOLD_REG_MASK (0x20000000U)
#define SDIF_CMD_USE_HOLD_REG_SHIFT (29U)
/*! USE_HOLD_REG - Use Hold Register.
 */
#define SDIF_CMD_USE_HOLD_REG(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_USE_HOLD_REG_SHIFT)) & SDIF_CMD_USE_HOLD_REG_MASK)
#define SDIF_CMD_START_CMD_MASK (0x80000000U)
#define SDIF_CMD_START_CMD_SHIFT (31U)
/*! START_CMD - Start command.
 */
#define SDIF_CMD_START_CMD(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_START_CMD_SHIFT)) & SDIF_CMD_START_CMD_MASK)
/*! @} */

/*! @name RESP - Response register */
/*! @{ */
#define SDIF_RESP_RESPONSE_MASK (0xFFFFFFFFU)
#define SDIF_RESP_RESPONSE_SHIFT (0U)
/*! RESPONSE - Bits of response.
 */
#define SDIF_RESP_RESPONSE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RESP_RESPONSE_SHIFT)) & SDIF_RESP_RESPONSE_MASK)
/*! @} */

/* The count of SDIF_RESP */
#define SDIF_RESP_COUNT (4U)

/*! @name MINTSTS - Masked Interrupt Status register */
/*! @{ */
#define SDIF_MINTSTS_CDET_MASK (0x1U)
#define SDIF_MINTSTS_CDET_SHIFT (0U)
/*! CDET - Card detect.
 */
#define SDIF_MINTSTS_CDET(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_CDET_SHIFT)) & SDIF_MINTSTS_CDET_MASK)
#define SDIF_MINTSTS_RE_MASK (0x2U)
#define SDIF_MINTSTS_RE_SHIFT (1U)
/*! RE - Response error.
 */
#define SDIF_MINTSTS_RE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RE_SHIFT)) & SDIF_MINTSTS_RE_MASK)
#define SDIF_MINTSTS_CDONE_MASK (0x4U)
#define SDIF_MINTSTS_CDONE_SHIFT (2U)
/*! CDONE - Command done.
 */
#define SDIF_MINTSTS_CDONE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_CDONE_SHIFT)) & SDIF_MINTSTS_CDONE_MASK)
#define SDIF_MINTSTS_DTO_MASK (0x8U)
#define SDIF_MINTSTS_DTO_SHIFT (3U)
/*! DTO - Data transfer over.
 */
#define SDIF_MINTSTS_DTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_DTO_SHIFT)) & SDIF_MINTSTS_DTO_MASK)
#define SDIF_MINTSTS_TXDR_MASK (0x10U)
#define SDIF_MINTSTS_TXDR_SHIFT (4U)
/*! TXDR - Transmit FIFO data request.
 */
#define SDIF_MINTSTS_TXDR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_TXDR_SHIFT)) & SDIF_MINTSTS_TXDR_MASK)
#define SDIF_MINTSTS_RXDR_MASK (0x20U)
#define SDIF_MINTSTS_RXDR_SHIFT (5U)
/*! RXDR - Receive FIFO data request.
 */
#define SDIF_MINTSTS_RXDR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RXDR_SHIFT)) & SDIF_MINTSTS_RXDR_MASK)
#define SDIF_MINTSTS_RCRC_MASK (0x40U)
#define SDIF_MINTSTS_RCRC_SHIFT (6U)
/*! RCRC - Response CRC error.
 */
#define SDIF_MINTSTS_RCRC(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RCRC_SHIFT)) & SDIF_MINTSTS_RCRC_MASK)
#define SDIF_MINTSTS_DCRC_MASK (0x80U)
#define SDIF_MINTSTS_DCRC_SHIFT (7U)
/*! DCRC - Data CRC error.
 */
#define SDIF_MINTSTS_DCRC(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_DCRC_SHIFT)) & SDIF_MINTSTS_DCRC_MASK)
#define SDIF_MINTSTS_RTO_MASK (0x100U)
#define SDIF_MINTSTS_RTO_SHIFT (8U)
/*! RTO - Response time-out.
 */
#define SDIF_MINTSTS_RTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RTO_SHIFT)) & SDIF_MINTSTS_RTO_MASK)
#define SDIF_MINTSTS_DRTO_MASK (0x200U)
#define SDIF_MINTSTS_DRTO_SHIFT (9U)
/*! DRTO - Data read time-out.
 */
#define SDIF_MINTSTS_DRTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_DRTO_SHIFT)) & SDIF_MINTSTS_DRTO_MASK)
#define SDIF_MINTSTS_HTO_MASK (0x400U)
#define SDIF_MINTSTS_HTO_SHIFT (10U)
/*! HTO - Data starvation-by-host time-out (HTO).
 */
#define SDIF_MINTSTS_HTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_HTO_SHIFT)) & SDIF_MINTSTS_HTO_MASK)
#define SDIF_MINTSTS_FRUN_MASK (0x800U)
#define SDIF_MINTSTS_FRUN_SHIFT (11U)
/*! FRUN - FIFO underrun/overrun error.
 */
#define SDIF_MINTSTS_FRUN(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_FRUN_SHIFT)) & SDIF_MINTSTS_FRUN_MASK)
#define SDIF_MINTSTS_HLE_MASK (0x1000U)
#define SDIF_MINTSTS_HLE_SHIFT (12U)
/*! HLE - Hardware locked write error.
 */
#define SDIF_MINTSTS_HLE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_HLE_SHIFT)) & SDIF_MINTSTS_HLE_MASK)
#define SDIF_MINTSTS_SBE_MASK (0x2000U)
#define SDIF_MINTSTS_SBE_SHIFT (13U)
/*! SBE - Start-bit error.
 */
#define SDIF_MINTSTS_SBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_SBE_SHIFT)) & SDIF_MINTSTS_SBE_MASK)
#define SDIF_MINTSTS_ACD_MASK (0x4000U)
#define SDIF_MINTSTS_ACD_SHIFT (14U)
/*! ACD - Auto command done.
 */
#define SDIF_MINTSTS_ACD(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_ACD_SHIFT)) & SDIF_MINTSTS_ACD_MASK)
#define SDIF_MINTSTS_EBE_MASK (0x8000U)
#define SDIF_MINTSTS_EBE_SHIFT (15U)
/*! EBE - End-bit error (read)/write no CRC.
 */
#define SDIF_MINTSTS_EBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_EBE_SHIFT)) & SDIF_MINTSTS_EBE_MASK)
#define SDIF_MINTSTS_SDIO_INTERRUPT_MASK (0x10000U)
#define SDIF_MINTSTS_SDIO_INTERRUPT_SHIFT (16U)
/*! SDIO_INTERRUPT - Interrupt from SDIO card.
 */
#define SDIF_MINTSTS_SDIO_INTERRUPT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_SDIO_INTERRUPT_SHIFT)) & SDIF_MINTSTS_SDIO_INTERRUPT_MASK)
/*! @} */

/*! @name RINTSTS - Raw Interrupt Status register */
/*! @{ */
#define SDIF_RINTSTS_CDET_MASK (0x1U)
#define SDIF_RINTSTS_CDET_SHIFT (0U)
/*! CDET - Card detect.
 */
#define SDIF_RINTSTS_CDET(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_CDET_SHIFT)) & SDIF_RINTSTS_CDET_MASK)
#define SDIF_RINTSTS_RE_MASK (0x2U)
#define SDIF_RINTSTS_RE_SHIFT (1U)
/*! RE - Response error.
 */
#define SDIF_RINTSTS_RE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RE_SHIFT)) & SDIF_RINTSTS_RE_MASK)
#define SDIF_RINTSTS_CDONE_MASK (0x4U)
#define SDIF_RINTSTS_CDONE_SHIFT (2U)
/*! CDONE - Command done.
 */
#define SDIF_RINTSTS_CDONE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_CDONE_SHIFT)) & SDIF_RINTSTS_CDONE_MASK)
#define SDIF_RINTSTS_DTO_MASK (0x8U)
#define SDIF_RINTSTS_DTO_SHIFT (3U)
/*! DTO - Data transfer over.
 */
#define SDIF_RINTSTS_DTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_DTO_SHIFT)) & SDIF_RINTSTS_DTO_MASK)
#define SDIF_RINTSTS_TXDR_MASK (0x10U)
#define SDIF_RINTSTS_TXDR_SHIFT (4U)
/*! TXDR - Transmit FIFO data request.
 */
#define SDIF_RINTSTS_TXDR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_TXDR_SHIFT)) & SDIF_RINTSTS_TXDR_MASK)
#define SDIF_RINTSTS_RXDR_MASK (0x20U)
#define SDIF_RINTSTS_RXDR_SHIFT (5U)
/*! RXDR - Receive FIFO data request.
 */
#define SDIF_RINTSTS_RXDR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RXDR_SHIFT)) & SDIF_RINTSTS_RXDR_MASK)
#define SDIF_RINTSTS_RCRC_MASK (0x40U)
#define SDIF_RINTSTS_RCRC_SHIFT (6U)
/*! RCRC - Response CRC error.
 */
#define SDIF_RINTSTS_RCRC(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RCRC_SHIFT)) & SDIF_RINTSTS_RCRC_MASK)
#define SDIF_RINTSTS_DCRC_MASK (0x80U)
#define SDIF_RINTSTS_DCRC_SHIFT (7U)
/*! DCRC - Data CRC error.
 */
#define SDIF_RINTSTS_DCRC(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_DCRC_SHIFT)) & SDIF_RINTSTS_DCRC_MASK)
#define SDIF_RINTSTS_RTO_BAR_MASK (0x100U)
#define SDIF_RINTSTS_RTO_BAR_SHIFT (8U)
/*! RTO_BAR - Response time-out (RTO)/Boot Ack Received (BAR).
 */
#define SDIF_RINTSTS_RTO_BAR(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RTO_BAR_SHIFT)) & SDIF_RINTSTS_RTO_BAR_MASK)
#define SDIF_RINTSTS_DRTO_BDS_MASK (0x200U)
#define SDIF_RINTSTS_DRTO_BDS_SHIFT (9U)
/*! DRTO_BDS - Data read time-out (DRTO)/Boot Data Start (BDS).
 */
#define SDIF_RINTSTS_DRTO_BDS(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_DRTO_BDS_SHIFT)) & SDIF_RINTSTS_DRTO_BDS_MASK)
#define SDIF_RINTSTS_HTO_MASK (0x400U)
#define SDIF_RINTSTS_HTO_SHIFT (10U)
/*! HTO - Data starvation-by-host time-out (HTO).
 */
#define SDIF_RINTSTS_HTO(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_HTO_SHIFT)) & SDIF_RINTSTS_HTO_MASK)
#define SDIF_RINTSTS_FRUN_MASK (0x800U)
#define SDIF_RINTSTS_FRUN_SHIFT (11U)
/*! FRUN - FIFO underrun/overrun error.
 */
#define SDIF_RINTSTS_FRUN(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_FRUN_SHIFT)) & SDIF_RINTSTS_FRUN_MASK)
#define SDIF_RINTSTS_HLE_MASK (0x1000U)
#define SDIF_RINTSTS_HLE_SHIFT (12U)
/*! HLE - Hardware locked write error.
 */
#define SDIF_RINTSTS_HLE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_HLE_SHIFT)) & SDIF_RINTSTS_HLE_MASK)
#define SDIF_RINTSTS_SBE_MASK (0x2000U)
#define SDIF_RINTSTS_SBE_SHIFT (13U)
/*! SBE - Start-bit error.
 */
#define SDIF_RINTSTS_SBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_SBE_SHIFT)) & SDIF_RINTSTS_SBE_MASK)
#define SDIF_RINTSTS_ACD_MASK (0x4000U)
#define SDIF_RINTSTS_ACD_SHIFT (14U)
/*! ACD - Auto command done.
 */
#define SDIF_RINTSTS_ACD(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_ACD_SHIFT)) & SDIF_RINTSTS_ACD_MASK)
#define SDIF_RINTSTS_EBE_MASK (0x8000U)
#define SDIF_RINTSTS_EBE_SHIFT (15U)
/*! EBE - End-bit error (read)/write no CRC.
 */
#define SDIF_RINTSTS_EBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_EBE_SHIFT)) & SDIF_RINTSTS_EBE_MASK)
#define SDIF_RINTSTS_SDIO_INTERRUPT_MASK (0x10000U)
#define SDIF_RINTSTS_SDIO_INTERRUPT_SHIFT (16U)
/*! SDIO_INTERRUPT - Interrupt from SDIO card.
 */
#define SDIF_RINTSTS_SDIO_INTERRUPT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_SDIO_INTERRUPT_SHIFT)) & SDIF_RINTSTS_SDIO_INTERRUPT_MASK)
/*! @} */

/*! @name STATUS - Status register */
/*! @{ */
#define SDIF_STATUS_FIFO_RX_WATERMARK_MASK (0x1U)
#define SDIF_STATUS_FIFO_RX_WATERMARK_SHIFT (0U)
/*! FIFO_RX_WATERMARK - FIFO reached Receive watermark level; not qualified with data transfer.
 */
#define SDIF_STATUS_FIFO_RX_WATERMARK(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_RX_WATERMARK_SHIFT)) & SDIF_STATUS_FIFO_RX_WATERMARK_MASK)
#define SDIF_STATUS_FIFO_TX_WATERMARK_MASK (0x2U)
#define SDIF_STATUS_FIFO_TX_WATERMARK_SHIFT (1U)
/*! FIFO_TX_WATERMARK - FIFO reached Transmit watermark level; not qualified with data transfer.
 */
#define SDIF_STATUS_FIFO_TX_WATERMARK(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_TX_WATERMARK_SHIFT)) & SDIF_STATUS_FIFO_TX_WATERMARK_MASK)
#define SDIF_STATUS_FIFO_EMPTY_MASK (0x4U)
#define SDIF_STATUS_FIFO_EMPTY_SHIFT (2U)
/*! FIFO_EMPTY - FIFO is empty status.
 */
#define SDIF_STATUS_FIFO_EMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_EMPTY_SHIFT)) & SDIF_STATUS_FIFO_EMPTY_MASK)
#define SDIF_STATUS_FIFO_FULL_MASK (0x8U)
#define SDIF_STATUS_FIFO_FULL_SHIFT (3U)
/*! FIFO_FULL - FIFO is full status.
 */
#define SDIF_STATUS_FIFO_FULL(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_FULL_SHIFT)) & SDIF_STATUS_FIFO_FULL_MASK)
#define SDIF_STATUS_CMDFSMSTATES_MASK (0xF0U)
#define SDIF_STATUS_CMDFSMSTATES_SHIFT (4U)
/*! CMDFSMSTATES - Command FSM states: 0 - Idle 1 - Send init sequence 2 - Tx cmd start bit 3 - Tx
 *    cmd tx bit 4 - Tx cmd index + arg 5 - Tx cmd crc7 6 - Tx cmd end bit 7 - Rx resp start bit 8 -
 *    Rx resp IRQ response 9 - Rx resp tx bit 10 - Rx resp cmd idx 11 - Rx resp data 12 - Rx resp
 *    crc7 13 - Rx resp end bit 14 - Cmd path wait NCC 15 - Wait; CMD-to-response turnaround NOTE: The
 *    command FSM state is represented using 19 bits.
 */
#define SDIF_STATUS_CMDFSMSTATES(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_CMDFSMSTATES_SHIFT)) & SDIF_STATUS_CMDFSMSTATES_MASK)
#define SDIF_STATUS_DATA_3_STATUS_MASK (0x100U)
#define SDIF_STATUS_DATA_3_STATUS_SHIFT (8U)
/*! DATA_3_STATUS - Raw selected card_data[3]; checks whether card is present 0 - card not present 1 - card present.
 */
#define SDIF_STATUS_DATA_3_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DATA_3_STATUS_SHIFT)) & SDIF_STATUS_DATA_3_STATUS_MASK)
#define SDIF_STATUS_DATA_BUSY_MASK (0x200U)
#define SDIF_STATUS_DATA_BUSY_SHIFT (9U)
/*! DATA_BUSY - Inverted version of raw selected card_data[0] 0 - card data not busy 1 - card data busy.
 */
#define SDIF_STATUS_DATA_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DATA_BUSY_SHIFT)) & SDIF_STATUS_DATA_BUSY_MASK)
#define SDIF_STATUS_DATA_STATE_MC_BUSY_MASK (0x400U)
#define SDIF_STATUS_DATA_STATE_MC_BUSY_SHIFT (10U)
/*! DATA_STATE_MC_BUSY - Data transmit or receive state-machine is busy.
 */
#define SDIF_STATUS_DATA_STATE_MC_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DATA_STATE_MC_BUSY_SHIFT)) & SDIF_STATUS_DATA_STATE_MC_BUSY_MASK)
#define SDIF_STATUS_RESPONSE_INDEX_MASK (0x1F800U)
#define SDIF_STATUS_RESPONSE_INDEX_SHIFT (11U)
/*! RESPONSE_INDEX - Index of previous response, including any auto-stop sent by core.
 */
#define SDIF_STATUS_RESPONSE_INDEX(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_RESPONSE_INDEX_SHIFT)) & SDIF_STATUS_RESPONSE_INDEX_MASK)
#define SDIF_STATUS_FIFO_COUNT_MASK (0x3FFE0000U)
#define SDIF_STATUS_FIFO_COUNT_SHIFT (17U)
/*! FIFO_COUNT - FIFO count - Number of filled locations in FIFO.
 */
#define SDIF_STATUS_FIFO_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_COUNT_SHIFT)) & SDIF_STATUS_FIFO_COUNT_MASK)
#define SDIF_STATUS_DMA_ACK_MASK (0x40000000U)
#define SDIF_STATUS_DMA_ACK_SHIFT (30U)
/*! DMA_ACK - DMA acknowledge signal state.
 */
#define SDIF_STATUS_DMA_ACK(x) (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DMA_ACK_SHIFT)) & SDIF_STATUS_DMA_ACK_MASK)
#define SDIF_STATUS_DMA_REQ_MASK (0x80000000U)
#define SDIF_STATUS_DMA_REQ_SHIFT (31U)
/*! DMA_REQ - DMA request signal state.
 */
#define SDIF_STATUS_DMA_REQ(x) (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DMA_REQ_SHIFT)) & SDIF_STATUS_DMA_REQ_MASK)
/*! @} */

/*! @name FIFOTH - FIFO Threshold Watermark register */
/*! @{ */
#define SDIF_FIFOTH_TX_WMARK_MASK (0xFFFU)
#define SDIF_FIFOTH_TX_WMARK_SHIFT (0U)
/*! TX_WMARK - FIFO threshold watermark level when transmitting data to card.
 */
#define SDIF_FIFOTH_TX_WMARK(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_FIFOTH_TX_WMARK_SHIFT)) & SDIF_FIFOTH_TX_WMARK_MASK)
#define SDIF_FIFOTH_RX_WMARK_MASK (0xFFF0000U)
#define SDIF_FIFOTH_RX_WMARK_SHIFT (16U)
/*! RX_WMARK - FIFO threshold watermark level when receiving data to card.
 */
#define SDIF_FIFOTH_RX_WMARK(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_FIFOTH_RX_WMARK_SHIFT)) & SDIF_FIFOTH_RX_WMARK_MASK)
#define SDIF_FIFOTH_DMA_MTS_MASK (0x70000000U)
#define SDIF_FIFOTH_DMA_MTS_SHIFT (28U)
/*! DMA_MTS - Burst size of multiple transaction; should be programmed same as DW-DMA controller
 *    multiple-transaction-size SRC/DEST_MSIZE.
 */
#define SDIF_FIFOTH_DMA_MTS(x) (((uint32_t)(((uint32_t)(x)) << SDIF_FIFOTH_DMA_MTS_SHIFT)) & SDIF_FIFOTH_DMA_MTS_MASK)
/*! @} */

/*! @name CDETECT - Card Detect register */
/*! @{ */
#define SDIF_CDETECT_CARD0_DETECT_MASK (0x1U)
#define SDIF_CDETECT_CARD0_DETECT_SHIFT (0U)
/*! CARD0_DETECT - Card 0 detect
 */
#define SDIF_CDETECT_CARD0_DETECT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CDETECT_CARD0_DETECT_SHIFT)) & SDIF_CDETECT_CARD0_DETECT_MASK)
#define SDIF_CDETECT_CARD1_DETECT_MASK (0x2U)
#define SDIF_CDETECT_CARD1_DETECT_SHIFT (1U)
/*! CARD1_DETECT - Card 1 detect
 */
#define SDIF_CDETECT_CARD1_DETECT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CDETECT_CARD1_DETECT_SHIFT)) & SDIF_CDETECT_CARD1_DETECT_MASK)
/*! @} */

/*! @name WRTPRT - Write Protect register */
/*! @{ */
#define SDIF_WRTPRT_WRITE_PROTECT_MASK (0x1U)
#define SDIF_WRTPRT_WRITE_PROTECT_SHIFT (0U)
/*! WRITE_PROTECT - Write protect.
 */
#define SDIF_WRTPRT_WRITE_PROTECT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_WRTPRT_WRITE_PROTECT_SHIFT)) & SDIF_WRTPRT_WRITE_PROTECT_MASK)
/*! @} */

/*! @name TCBCNT - Transferred CIU Card Byte Count register */
/*! @{ */
#define SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_MASK (0xFFFFFFFFU)
#define SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_SHIFT (0U)
/*! TRANS_CARD_BYTE_COUNT - Number of bytes transferred by CIU unit to card.
 */
#define SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_SHIFT)) & SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_MASK)
/*! @} */

/*! @name TBBCNT - Transferred Host to BIU-FIFO Byte Count register */
/*! @{ */
#define SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_MASK (0xFFFFFFFFU)
#define SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_SHIFT (0U)
/*! TRANS_FIFO_BYTE_COUNT - Number of bytes transferred between Host/DMA memory and BIU FIFO.
 */
#define SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_SHIFT)) & SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_MASK)
/*! @} */

/*! @name DEBNCE - Debounce Count register */
/*! @{ */
#define SDIF_DEBNCE_DEBOUNCE_COUNT_MASK (0xFFFFFFU)
#define SDIF_DEBNCE_DEBOUNCE_COUNT_SHIFT (0U)
/*! DEBOUNCE_COUNT - Number of host clocks (SD_CLK) used by debounce filter logic for card detect; typical debounce time
 * is 5-25 ms.
 */
#define SDIF_DEBNCE_DEBOUNCE_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_DEBNCE_DEBOUNCE_COUNT_SHIFT)) & SDIF_DEBNCE_DEBOUNCE_COUNT_MASK)
/*! @} */

/*! @name RST_N - Hardware Reset */
/*! @{ */
#define SDIF_RST_N_CARD_RESET_MASK (0x1U)
#define SDIF_RST_N_CARD_RESET_SHIFT (0U)
/*! CARD_RESET - Hardware reset.
 */
#define SDIF_RST_N_CARD_RESET(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_RST_N_CARD_RESET_SHIFT)) & SDIF_RST_N_CARD_RESET_MASK)
/*! @} */

/*! @name BMOD - Bus Mode register */
/*! @{ */
#define SDIF_BMOD_SWR_MASK (0x1U)
#define SDIF_BMOD_SWR_SHIFT (0U)
/*! SWR - Software Reset.
 */
#define SDIF_BMOD_SWR(x) (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_SWR_SHIFT)) & SDIF_BMOD_SWR_MASK)
#define SDIF_BMOD_FB_MASK (0x2U)
#define SDIF_BMOD_FB_SHIFT (1U)
/*! FB - Fixed Burst.
 */
#define SDIF_BMOD_FB(x) (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_FB_SHIFT)) & SDIF_BMOD_FB_MASK)
#define SDIF_BMOD_DSL_MASK (0x7CU)
#define SDIF_BMOD_DSL_SHIFT (2U)
/*! DSL - Descriptor Skip Length.
 */
#define SDIF_BMOD_DSL(x) (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_DSL_SHIFT)) & SDIF_BMOD_DSL_MASK)
#define SDIF_BMOD_DE_MASK (0x80U)
#define SDIF_BMOD_DE_SHIFT (7U)
/*! DE - SD/MMC DMA Enable.
 */
#define SDIF_BMOD_DE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_DE_SHIFT)) & SDIF_BMOD_DE_MASK)
#define SDIF_BMOD_PBL_MASK (0x700U)
#define SDIF_BMOD_PBL_SHIFT (8U)
/*! PBL - Programmable Burst Length.
 */
#define SDIF_BMOD_PBL(x) (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_PBL_SHIFT)) & SDIF_BMOD_PBL_MASK)
/*! @} */

/*! @name PLDMND - Poll Demand register */
/*! @{ */
#define SDIF_PLDMND_PD_MASK (0xFFFFFFFFU)
#define SDIF_PLDMND_PD_SHIFT (0U)
/*! PD - Poll Demand.
 */
#define SDIF_PLDMND_PD(x) (((uint32_t)(((uint32_t)(x)) << SDIF_PLDMND_PD_SHIFT)) & SDIF_PLDMND_PD_MASK)
/*! @} */

/*! @name DBADDR - Descriptor List Base Address register */
/*! @{ */
#define SDIF_DBADDR_SDL_MASK (0xFFFFFFFFU)
#define SDIF_DBADDR_SDL_SHIFT (0U)
/*! SDL - Start of Descriptor List.
 */
#define SDIF_DBADDR_SDL(x) (((uint32_t)(((uint32_t)(x)) << SDIF_DBADDR_SDL_SHIFT)) & SDIF_DBADDR_SDL_MASK)
/*! @} */

/*! @name IDSTS - Internal DMAC Status register */
/*! @{ */
#define SDIF_IDSTS_TI_MASK (0x1U)
#define SDIF_IDSTS_TI_SHIFT (0U)
/*! TI - Transmit Interrupt.
 */
#define SDIF_IDSTS_TI(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_TI_SHIFT)) & SDIF_IDSTS_TI_MASK)
#define SDIF_IDSTS_RI_MASK (0x2U)
#define SDIF_IDSTS_RI_SHIFT (1U)
/*! RI - Receive Interrupt.
 */
#define SDIF_IDSTS_RI(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_RI_SHIFT)) & SDIF_IDSTS_RI_MASK)
#define SDIF_IDSTS_FBE_MASK (0x4U)
#define SDIF_IDSTS_FBE_SHIFT (2U)
/*! FBE - Fatal Bus Error Interrupt.
 */
#define SDIF_IDSTS_FBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_FBE_SHIFT)) & SDIF_IDSTS_FBE_MASK)
#define SDIF_IDSTS_DU_MASK (0x10U)
#define SDIF_IDSTS_DU_SHIFT (4U)
/*! DU - Descriptor Unavailable Interrupt.
 */
#define SDIF_IDSTS_DU(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_DU_SHIFT)) & SDIF_IDSTS_DU_MASK)
#define SDIF_IDSTS_CES_MASK (0x20U)
#define SDIF_IDSTS_CES_SHIFT (5U)
/*! CES - Card Error Summary.
 */
#define SDIF_IDSTS_CES(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_CES_SHIFT)) & SDIF_IDSTS_CES_MASK)
#define SDIF_IDSTS_NIS_MASK (0x100U)
#define SDIF_IDSTS_NIS_SHIFT (8U)
/*! NIS - Normal Interrupt Summary.
 */
#define SDIF_IDSTS_NIS(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_NIS_SHIFT)) & SDIF_IDSTS_NIS_MASK)
#define SDIF_IDSTS_AIS_MASK (0x200U)
#define SDIF_IDSTS_AIS_SHIFT (9U)
/*! AIS - Abnormal Interrupt Summary.
 */
#define SDIF_IDSTS_AIS(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_AIS_SHIFT)) & SDIF_IDSTS_AIS_MASK)
#define SDIF_IDSTS_EB_MASK (0x1C00U)
#define SDIF_IDSTS_EB_SHIFT (10U)
/*! EB - Error Bits.
 */
#define SDIF_IDSTS_EB(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_EB_SHIFT)) & SDIF_IDSTS_EB_MASK)
#define SDIF_IDSTS_FSM_MASK (0x1E000U)
#define SDIF_IDSTS_FSM_SHIFT (13U)
/*! FSM - DMAC state machine present state.
 */
#define SDIF_IDSTS_FSM(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_FSM_SHIFT)) & SDIF_IDSTS_FSM_MASK)
/*! @} */

/*! @name IDINTEN - Internal DMAC Interrupt Enable register */
/*! @{ */
#define SDIF_IDINTEN_TI_MASK (0x1U)
#define SDIF_IDINTEN_TI_SHIFT (0U)
/*! TI - Transmit Interrupt Enable.
 */
#define SDIF_IDINTEN_TI(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_TI_SHIFT)) & SDIF_IDINTEN_TI_MASK)
#define SDIF_IDINTEN_RI_MASK (0x2U)
#define SDIF_IDINTEN_RI_SHIFT (1U)
/*! RI - Receive Interrupt Enable.
 */
#define SDIF_IDINTEN_RI(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_RI_SHIFT)) & SDIF_IDINTEN_RI_MASK)
#define SDIF_IDINTEN_FBE_MASK (0x4U)
#define SDIF_IDINTEN_FBE_SHIFT (2U)
/*! FBE - Fatal Bus Error Enable.
 */
#define SDIF_IDINTEN_FBE(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_FBE_SHIFT)) & SDIF_IDINTEN_FBE_MASK)
#define SDIF_IDINTEN_DU_MASK (0x10U)
#define SDIF_IDINTEN_DU_SHIFT (4U)
/*! DU - Descriptor Unavailable Interrupt.
 */
#define SDIF_IDINTEN_DU(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_DU_SHIFT)) & SDIF_IDINTEN_DU_MASK)
#define SDIF_IDINTEN_CES_MASK (0x20U)
#define SDIF_IDINTEN_CES_SHIFT (5U)
/*! CES - Card Error summary Interrupt Enable.
 */
#define SDIF_IDINTEN_CES(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_CES_SHIFT)) & SDIF_IDINTEN_CES_MASK)
#define SDIF_IDINTEN_NIS_MASK (0x100U)
#define SDIF_IDINTEN_NIS_SHIFT (8U)
/*! NIS - Normal Interrupt Summary Enable.
 */
#define SDIF_IDINTEN_NIS(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_NIS_SHIFT)) & SDIF_IDINTEN_NIS_MASK)
#define SDIF_IDINTEN_AIS_MASK (0x200U)
#define SDIF_IDINTEN_AIS_SHIFT (9U)
/*! AIS - Abnormal Interrupt Summary Enable.
 */
#define SDIF_IDINTEN_AIS(x) (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_AIS_SHIFT)) & SDIF_IDINTEN_AIS_MASK)
/*! @} */

/*! @name DSCADDR - Current Host Descriptor Address register */
/*! @{ */
#define SDIF_DSCADDR_HDA_MASK (0xFFFFFFFFU)
#define SDIF_DSCADDR_HDA_SHIFT (0U)
/*! HDA - Host Descriptor Address Pointer.
 */
#define SDIF_DSCADDR_HDA(x) (((uint32_t)(((uint32_t)(x)) << SDIF_DSCADDR_HDA_SHIFT)) & SDIF_DSCADDR_HDA_MASK)
/*! @} */

/*! @name BUFADDR - Current Buffer Descriptor Address register */
/*! @{ */
#define SDIF_BUFADDR_HBA_MASK (0xFFFFFFFFU)
#define SDIF_BUFADDR_HBA_SHIFT (0U)
/*! HBA - Host Buffer Address Pointer.
 */
#define SDIF_BUFADDR_HBA(x) (((uint32_t)(((uint32_t)(x)) << SDIF_BUFADDR_HBA_SHIFT)) & SDIF_BUFADDR_HBA_MASK)
/*! @} */

/*! @name CARDTHRCTL - Card Threshold Control */
/*! @{ */
#define SDIF_CARDTHRCTL_CARDRDTHREN_MASK (0x1U)
#define SDIF_CARDTHRCTL_CARDRDTHREN_SHIFT (0U)
/*! CARDRDTHREN - Card Read Threshold Enable.
 */
#define SDIF_CARDTHRCTL_CARDRDTHREN(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CARDTHRCTL_CARDRDTHREN_SHIFT)) & SDIF_CARDTHRCTL_CARDRDTHREN_MASK)
#define SDIF_CARDTHRCTL_BSYCLRINTEN_MASK (0x2U)
#define SDIF_CARDTHRCTL_BSYCLRINTEN_SHIFT (1U)
/*! BSYCLRINTEN - Busy Clear Interrupt Enable.
 */
#define SDIF_CARDTHRCTL_BSYCLRINTEN(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CARDTHRCTL_BSYCLRINTEN_SHIFT)) & SDIF_CARDTHRCTL_BSYCLRINTEN_MASK)
#define SDIF_CARDTHRCTL_CARDTHRESHOLD_MASK (0xFF0000U)
#define SDIF_CARDTHRCTL_CARDTHRESHOLD_SHIFT (16U)
/*! CARDTHRESHOLD - Card Threshold size.
 */
#define SDIF_CARDTHRCTL_CARDTHRESHOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_CARDTHRCTL_CARDTHRESHOLD_SHIFT)) & SDIF_CARDTHRCTL_CARDTHRESHOLD_MASK)
/*! @} */

/*! @name BACKENDPWR - Power control */
/*! @{ */
#define SDIF_BACKENDPWR_BACKENDPWR_MASK (0x1U)
#define SDIF_BACKENDPWR_BACKENDPWR_SHIFT (0U)
/*! BACKENDPWR - Back-end Power control for card application.
 */
#define SDIF_BACKENDPWR_BACKENDPWR(x) \
    (((uint32_t)(((uint32_t)(x)) << SDIF_BACKENDPWR_BACKENDPWR_SHIFT)) & SDIF_BACKENDPWR_BACKENDPWR_MASK)
/*! @} */

/*! @name FIFO - SDIF FIFO */
/*! @{ */
#define SDIF_FIFO_DATA_MASK (0xFFFFFFFFU)
#define SDIF_FIFO_DATA_SHIFT (0U)
/*! DATA - SDIF FIFO.
 */
#define SDIF_FIFO_DATA(x) (((uint32_t)(((uint32_t)(x)) << SDIF_FIFO_DATA_SHIFT)) & SDIF_FIFO_DATA_MASK)
/*! @} */

/* The count of SDIF_FIFO */
#define SDIF_FIFO_COUNT (64U)

/*!
 * @}
 */ /* end of group SDIF_Register_Masks */

/* SDIF - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
/** Peripheral SDIF base address */
#define SDIF_BASE (0x5009B000u)
/** Peripheral SDIF base address */
#define SDIF_BASE_NS (0x4009B000u)
/** Peripheral SDIF base pointer */
#define SDIF ((SDIF_Type *)SDIF_BASE)
/** Peripheral SDIF base pointer */
#define SDIF_NS ((SDIF_Type *)SDIF_BASE_NS)
/** Array initializer of SDIF peripheral base addresses */
#define SDIF_BASE_ADDRS \
    {                   \
        SDIF_BASE       \
    }
/** Array initializer of SDIF peripheral base pointers */
#define SDIF_BASE_PTRS \
    {                  \
        SDIF           \
    }
/** Array initializer of SDIF peripheral base addresses */
#define SDIF_BASE_ADDRS_NS \
    {                      \
        SDIF_BASE_NS       \
    }
/** Array initializer of SDIF peripheral base pointers */
#define SDIF_BASE_PTRS_NS \
    {                     \
        SDIF_NS           \
    }
#else
/** Peripheral SDIF base address */
#define SDIF_BASE (0x4009B000u)
/** Peripheral SDIF base pointer */
#define SDIF ((SDIF_Type *)SDIF_BASE)
/** Array initializer of SDIF peripheral base addresses */
#define SDIF_BASE_ADDRS \
    {                   \
        SDIF_BASE       \
    }
/** Array initializer of SDIF peripheral base pointers */
#define SDIF_BASE_PTRS \
    {                  \
        SDIF           \
    }
#endif
/** Interrupt vectors for the SDIF peripheral type */
#define SDIF_IRQS \
    {             \
        SDIO_IRQn \
    }

/*!
 * @}
 */ /* end of group SDIF_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- SPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Peripheral_Access_Layer SPI Peripheral Access Layer
 * @{
 */

/** SPI - Register Layout Typedef */
typedef struct
{
    uint8_t RESERVED_0[1024];
    __IO uint32_t CFG; /**< SPI Configuration register, offset: 0x400 */
    __IO uint32_t DLY; /**< SPI Delay register, offset: 0x404 */
    __IO uint32_t
        STAT; /**< SPI Status. Some status flags can be cleared by writing a 1 to that bit position., offset: 0x408 */
    __IO uint32_t INTENSET; /**< SPI Interrupt Enable read and Set. A complete value may be read from this register.
                               Writing a 1 to any implemented bit position causes that bit to be set., offset: 0x40C */
    __O uint32_t INTENCLR;  /**< SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the
                               corresponding bit in INTENSET to be cleared., offset: 0x410 */
    uint8_t RESERVED_1[16];
    __IO uint32_t DIV;    /**< SPI clock Divider, offset: 0x424 */
    __I uint32_t INTSTAT; /**< SPI Interrupt Status, offset: 0x428 */
    uint8_t RESERVED_2[2516];
    __IO uint32_t FIFOCFG;  /**< FIFO configuration and enable register., offset: 0xE00 */
    __IO uint32_t FIFOSTAT; /**< FIFO status register., offset: 0xE04 */
    __IO uint32_t FIFOTRIG; /**< FIFO trigger settings for interrupt and DMA request., offset: 0xE08 */
    uint8_t RESERVED_3[4];
    __IO uint32_t FIFOINTENSET; /**< FIFO interrupt enable set (enable) and read register., offset: 0xE10 */
    __IO uint32_t FIFOINTENCLR; /**< FIFO interrupt enable clear (disable) and read register., offset: 0xE14 */
    __I uint32_t FIFOINTSTAT;   /**< FIFO interrupt status register., offset: 0xE18 */
    uint8_t RESERVED_4[4];
    __O uint32_t FIFOWR; /**< FIFO write data., offset: 0xE20 */
    uint8_t RESERVED_5[12];
    __I uint32_t FIFORD; /**< FIFO read data., offset: 0xE30 */
    uint8_t RESERVED_6[12];
    __I uint32_t FIFORDNOPOP; /**< FIFO data read with no FIFO pop., offset: 0xE40 */
    uint8_t RESERVED_7[440];
    __I uint32_t ID; /**< Peripheral identification register., offset: 0xFFC */
} SPI_Type;

/* ----------------------------------------------------------------------------
   -- SPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Masks SPI Register Masks
 * @{
 */

/*! @name CFG - SPI Configuration register */
/*! @{ */
#define SPI_CFG_ENABLE_MASK (0x1U)
#define SPI_CFG_ENABLE_SHIFT (0U)
/*! ENABLE - SPI enable.
 *  0b0..Disabled. The SPI is disabled and the internal state machine and counters are reset.
 *  0b1..Enabled. The SPI is enabled for operation.
 */
#define SPI_CFG_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_ENABLE_SHIFT)) & SPI_CFG_ENABLE_MASK)
#define SPI_CFG_MASTER_MASK (0x4U)
#define SPI_CFG_MASTER_SHIFT (2U)
/*! MASTER - Master mode select.
 *  0b0..Slave mode. The SPI will operate in slave mode. SCK, MOSI, and the SSEL signals are inputs, MISO is an output.
 *  0b1..Master mode. The SPI will operate in master mode. SCK, MOSI, and the SSEL signals are outputs, MISO is an
 * input.
 */
#define SPI_CFG_MASTER(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_MASTER_SHIFT)) & SPI_CFG_MASTER_MASK)
#define SPI_CFG_LSBF_MASK (0x8U)
#define SPI_CFG_LSBF_SHIFT (3U)
/*! LSBF - LSB First mode enable.
 *  0b0..Standard. Data is transmitted and received in standard MSB first order.
 *  0b1..Reverse. Data is transmitted and received in reverse order (LSB first).
 */
#define SPI_CFG_LSBF(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_LSBF_SHIFT)) & SPI_CFG_LSBF_MASK)
#define SPI_CFG_CPHA_MASK (0x10U)
#define SPI_CFG_CPHA_SHIFT (4U)
/*! CPHA - Clock Phase select.
 *  0b0..Change. The SPI captures serial data on the first clock transition of the transfer (when the clock
 *       changes away from the rest state). Data is changed on the following edge.
 *  0b1..Capture. The SPI changes serial data on the first clock transition of the transfer (when the clock
 *       changes away from the rest state). Data is captured on the following edge.
 */
#define SPI_CFG_CPHA(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_CPHA_SHIFT)) & SPI_CFG_CPHA_MASK)
#define SPI_CFG_CPOL_MASK (0x20U)
#define SPI_CFG_CPOL_SHIFT (5U)
/*! CPOL - Clock Polarity select.
 *  0b0..Low. The rest state of the clock (between transfers) is low.
 *  0b1..High. The rest state of the clock (between transfers) is high.
 */
#define SPI_CFG_CPOL(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_CPOL_SHIFT)) & SPI_CFG_CPOL_MASK)
#define SPI_CFG_LOOP_MASK (0x80U)
#define SPI_CFG_LOOP_SHIFT (7U)
/*! LOOP - Loopback mode enable. Loopback mode applies only to Master mode, and connects transmit
 *    and receive data connected together to allow simple software testing.
 *  0b0..Disabled.
 *  0b1..Enabled.
 */
#define SPI_CFG_LOOP(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_LOOP_SHIFT)) & SPI_CFG_LOOP_MASK)
#define SPI_CFG_SPOL0_MASK (0x100U)
#define SPI_CFG_SPOL0_SHIFT (8U)
/*! SPOL0 - SSEL0 Polarity select.
 *  0b0..Low. The SSEL0 pin is active low.
 *  0b1..High. The SSEL0 pin is active high.
 */
#define SPI_CFG_SPOL0(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL0_SHIFT)) & SPI_CFG_SPOL0_MASK)
#define SPI_CFG_SPOL1_MASK (0x200U)
#define SPI_CFG_SPOL1_SHIFT (9U)
/*! SPOL1 - SSEL1 Polarity select.
 *  0b0..Low. The SSEL1 pin is active low.
 *  0b1..High. The SSEL1 pin is active high.
 */
#define SPI_CFG_SPOL1(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL1_SHIFT)) & SPI_CFG_SPOL1_MASK)
#define SPI_CFG_SPOL2_MASK (0x400U)
#define SPI_CFG_SPOL2_SHIFT (10U)
/*! SPOL2 - SSEL2 Polarity select.
 *  0b0..Low. The SSEL2 pin is active low.
 *  0b1..High. The SSEL2 pin is active high.
 */
#define SPI_CFG_SPOL2(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL2_SHIFT)) & SPI_CFG_SPOL2_MASK)
#define SPI_CFG_SPOL3_MASK (0x800U)
#define SPI_CFG_SPOL3_SHIFT (11U)
/*! SPOL3 - SSEL3 Polarity select.
 *  0b0..Low. The SSEL3 pin is active low.
 *  0b1..High. The SSEL3 pin is active high.
 */
#define SPI_CFG_SPOL3(x) (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL3_SHIFT)) & SPI_CFG_SPOL3_MASK)
/*! @} */

/*! @name DLY - SPI Delay register */
/*! @{ */
#define SPI_DLY_PRE_DELAY_MASK (0xFU)
#define SPI_DLY_PRE_DELAY_SHIFT (0U)
/*! PRE_DELAY - Controls the amount of time between SSEL assertion and the beginning of a data
 *    transfer. There is always one SPI clock time between SSEL assertion and the first clock edge. This
 *    is not considered part of the pre-delay. 0x0 = No additional time is inserted. 0x1 = 1 SPI
 *    clock time is inserted. 0x2 = 2 SPI clock times are inserted. 0xF = 15 SPI clock times are
 *    inserted.
 */
#define SPI_DLY_PRE_DELAY(x) (((uint32_t)(((uint32_t)(x)) << SPI_DLY_PRE_DELAY_SHIFT)) & SPI_DLY_PRE_DELAY_MASK)
#define SPI_DLY_POST_DELAY_MASK (0xF0U)
#define SPI_DLY_POST_DELAY_SHIFT (4U)
/*! POST_DELAY - Controls the amount of time between the end of a data transfer and SSEL
 *    deassertion. 0x0 = No additional time is inserted. 0x1 = 1 SPI clock time is inserted. 0x2 = 2 SPI clock
 *    times are inserted. 0xF = 15 SPI clock times are inserted.
 */
#define SPI_DLY_POST_DELAY(x) (((uint32_t)(((uint32_t)(x)) << SPI_DLY_POST_DELAY_SHIFT)) & SPI_DLY_POST_DELAY_MASK)
#define SPI_DLY_FRAME_DELAY_MASK (0xF00U)
#define SPI_DLY_FRAME_DELAY_SHIFT (8U)
/*! FRAME_DELAY - If the EOF flag is set, controls the minimum amount of time between the current
 *    frame and the next frame (or SSEL deassertion if EOT). 0x0 = No additional time is inserted. 0x1
 *    = 1 SPI clock time is inserted. 0x2 = 2 SPI clock times are inserted. 0xF = 15 SPI clock
 *    times are inserted.
 */
#define SPI_DLY_FRAME_DELAY(x) (((uint32_t)(((uint32_t)(x)) << SPI_DLY_FRAME_DELAY_SHIFT)) & SPI_DLY_FRAME_DELAY_MASK)
#define SPI_DLY_TRANSFER_DELAY_MASK (0xF000U)
#define SPI_DLY_TRANSFER_DELAY_SHIFT (12U)
/*! TRANSFER_DELAY - Controls the minimum amount of time that the SSEL is deasserted between
 *    transfers. 0x0 = The minimum time that SSEL is deasserted is 1 SPI clock time. (Zero added time.) 0x1
 *    = The minimum time that SSEL is deasserted is 2 SPI clock times. 0x2 = The minimum time that
 *    SSEL is deasserted is 3 SPI clock times. 0xF = The minimum time that SSEL is deasserted is 16
 *    SPI clock times.
 */
#define SPI_DLY_TRANSFER_DELAY(x) \
    (((uint32_t)(((uint32_t)(x)) << SPI_DLY_TRANSFER_DELAY_SHIFT)) & SPI_DLY_TRANSFER_DELAY_MASK)
/*! @} */

/*! @name STAT - SPI Status. Some status flags can be cleared by writing a 1 to that bit position. */
/*! @{ */
#define SPI_STAT_SSA_MASK (0x10U)
#define SPI_STAT_SSA_SHIFT (4U)
/*! SSA - Slave Select Assert. This flag is set whenever any slave select transitions from
 *    deasserted to asserted, in both master and slave modes. This allows determining when the SPI
 *    transmit/receive functions become busy, and allows waking up the device from reduced power modes when a
 *    slave mode access begins. This flag is cleared by software.
 */
#define SPI_STAT_SSA(x) (((uint32_t)(((uint32_t)(x)) << SPI_STAT_SSA_SHIFT)) & SPI_STAT_SSA_MASK)
#define SPI_STAT_SSD_MASK (0x20U)
#define SPI_STAT_SSD_SHIFT (5U)
/*! SSD - Slave Select Deassert. This flag is set whenever any asserted slave selects transition to
 *    deasserted, in both master and slave modes. This allows determining when the SPI
 *    transmit/receive functions become idle. This flag is c