/* app_cmsisdsp_rfft_fast_f32.c */
#include "app.h"

extern uint32_t   timerCounter;
extern float32_t  inputF32[APP_FFT_LEN_512*2];
extern float32_t outputF32[APP_FFT_LEN_512*2];

void App_CmsisDsp_RFFT_Fast_F32_Example(void)
{
    uint32_t i;
    arm_rfft_fast_instance_f32 rfft_fast_instance;

    PRINTF("%s\r\n", __func__);

    /* input. */
    for (i = 0u; i < APP_FFT_LEN_512; i++)
    {
        inputF32[i] = (1.0f + i%2); /* only real part. */
    }

    arm_rfft_fast_init_f32(&rfft_fast_instance, APP_FFT_LEN_512);

    TimerCount_Start();
    arm_rfft_fast_f32(&rfft_fast_instance, inputF32, outputF32, 0);
    TimerCount_Stop(timerCounter);

    /* output. */
#if defined(APP_CFG_ENABLE_SHOW_OUTPUT_NUMBERS) && (APP_CFG_ENABLE_SHOW_OUTPUT_NUMBERS==1)
    PRINTF("Output :\r\n");
    for (i = 0u; i < APP_FFT_LEN_512/2; i++)
    {
        PRINTF("%4d: %f, %f\r\n", i, outputF32[2*i], outputF32[2*i+1]);
    }
#endif /* APP_CFG_ENABLE_SHOW_OUTPUT_NUMBERS */
    PRINTF("Cycles : %6d  | us : %d\r\n", timerCounter, timerCounter/TIMER_TICKERS_PER_US);
    PRINTF("\r\n");
}

/* EOF. */

