/* boot_info.c */

#include <stdint.h>
#include "fw_boot.h"
#include "fsl_common.h"


#if 0
/*
* Fetch the version information
* Return:
* 0 - the number is available.
* 1 - the firmware is the initial one, to be download the new one.
* 2 - the number is wrong.
*/
uint32_t FwBoot_GetFirmwareVersion(uint32_t fwImageBaseAddr, uint8_t *verInfoStr)
{
    uint8_t isAvailableVal = *((uint8_t *)(  fwImageBaseAddr
                                           + BOOT_FIRMWARE_INFO_OFFSET
                                           + BOOT_FIRMWARE_INFO_IS_AVAILABLE_OFFSET));
    uint32_t i;

    if (isAvailableVal != BOOT_FIRMWARE_INFO_AVAILABLE_KEY)
    {
        return 1U;
    }

    for (i = 0U; i < BOOT_FIRMWARE_FILENAME_VER_NUM_LEN; i++)
    {
        *(verInfoStr+i) = *((uint8_t *)(  fwImageBaseAddr
                                        + BOOT_FIRMWARE_INFO_OFFSET
                                        + BOOT_FIRMWARE_INFO_VER_NUM_OFFSET
                                        + i));
        if (   (*(verInfoStr+i) < '0')
            || (*(verInfoStr+i) > '9') )
        {
            return 2U;
        }
    }
    return 0U;
}

/*
* Compare the version number.
* Return:
* 0 - ver1 == ver2
* 1 - ver1 > ver2
* 2 - ver1 < ver2
*/
uint32_t FwBoot_CompareVersion(uint8_t *verStr1, uint8_t *verStr2)
{
    uint32_t i;

    for (i = 0U; i < BOOT_FIRMWARE_FILENAME_VER_NUM_LEN; i++)
    {
        if ( (*(verStr1+i)) > (*(verStr2+i)) )
        {
            return 1U;
        }
        else if ( (*(verStr1+i)) < (*(verStr2+i)) )
        {
            return 2U;
        }
    }
    return 0U;
}

void FwBoot_AppendVersion(uint32_t fwImageBaseAddr, uint8_t *verInfoStr)
{
    uint8_t * fwImagePtr = (uint8_t *)fwImageBaseAddr;
    uint32_t i;

    for (i = 0U; i < BOOT_FIRMWARE_FILENAME_VER_NUM_LEN; i++)
    {
        *(fwImagePtr+BOOT_FIRMWARE_INFO_OFFSET+BOOT_FIRMWARE_INFO_VER_NUM_OFFSET+i)
            = *(verInfoStr+i);
    }
    *(fwImagePtr+BOOT_FIRMWARE_INFO_OFFSET+BOOT_FIRMWARE_INFO_IS_AVAILABLE_OFFSET)
        = BOOT_FIRMWARE_INFO_AVAILABLE_KEY;
}

#endif



/*
* The vector table is in the front of the image, and the following is for the normal code.
* The new image is just like the normal image file but with a indicated base address offset. 
*/
void FwBoot_BootToFwImage(uint32_t fwImageBaseAddr)
{
    void (*firmwareFunc)(void);
    uint32_t fwStackVal = *((uint32_t *)(fwImageBaseAddr));     /* the first word is for the stack pointer. */
    uint32_t fwEntryVal = *((uint32_t *)(fwImageBaseAddr+4U));  /* the second works is for the boot function. */
    firmwareFunc = (void (*)(void))fwEntryVal;

    SCB->VTOR = fwImageBaseAddr; /* The stack address is also the start address of vector. */
    __set_MSP(fwStackVal);
    __set_PSP(fwStackVal);
    firmwareFunc();
}

void FwBoot_Exit(void)
{
    NVIC_SystemReset();
}

/* EOF. */
