/* fw_boot.h */

#ifndef __FW_BOOT__
#define __FW_BOOT__

#include <stdint.h>

#if 0
#define BOOT_FIRMWARE_BASE_COUNT 2U

#define BOOT_FIRMWARE_BYTES_MAX                 (7 * FSL_FEATURE_SYSCON_FLASH_SECTOR_SIZE_BYTES)/*(1024*224)*/
#define BOOT_FIRMWARE_A_BASE_ADDRESS            (2U * FSL_FEATURE_SYSCON_FLASH_SECTOR_SIZE_BYTES)/*(1024*64)*/
#define BOOT_FIRMWARE_B_BASE_ADDRESS            (BOOT_FIRMWARE_A_BASE_ADDRESS + BOOT_FIRMWARE_BYTES_MAX)/*(1024*288)*/


/* The address offset from the start address of each firmware. */
#define BOOT_FIRMWARE_INFO_OFFSET               (1024U-16U) /* 中断向量表的最后16个字节 */
#define BOOT_FIRMWARE_INFO_VER_NUM_OFFSET        0U
#define BOOT_FIRMWARE_INFO_IS_AVAILABLE_OFFSET   4U
//#define BOOT_FIRMWARE_INFO_CRC_VALUE_OFFSET      8U

#define BOOT_FIRMWARE_FILENAME_IDX_OFFSET        3U
#define BOOT_FIRMWARE_FILENAME_VER_NUM_OFFSET    5U
#define BOOT_FIRMWARE_FILENAME_VER_NUM_LEN       4U

#define BOOT_FIRMWARE_INFO_AVAILABLE_KEY         0x55


uint32_t FwBoot_GetFirmwareVersion(uint32_t fwImageBaseAddr, uint8_t *verInfoStr);
uint32_t FwBoot_CompareVersion(uint8_t *verStr1, uint8_t *verStr2);
void FwBoot_AppendVersion(uint32_t fwImageBaseAddr, uint8_t *verInfoStr);
#endif


/* for bootloader.*/
//#define BOOT_FIRMWARE_INFO_BASE_ADDRESS          FSL_FEATURE_SYSCON_FLASH_SECTOR_SIZE_BYTES - 1024  /* reserved 1KB for version info in bootloader area.*/

/* for firmware. */
#define BOOT_FIRMWARE_BASE_ADDRESS           (1U * FSL_FEATURE_SYSCON_FLASH_SECTOR_SIZE_BYTES)  /* (1024 * 32) Bytes. */
#define BOOT_FIRMWARE_INFO_OFFSET            (1024U-32U) /* 中断向量表的最后16个字节 */

void FwBoot_BootToFwImage(uint32_t fwImageBaseAddr);
void FwBoot_Exit(void);

#endif /* __FW_BOOT__ */

