/*
===============================================================================
 Name        : Example_I2C_MasterSlave.c
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : main definition
===============================================================================
*/

#include "LPC8xx.h"
#include "i2c.h"
#include "swm.h"
#include "syscon.h"
#include "uart.h"
#include "utilities.h"

#include "sl_common.h"
#include "chip.h"
#include "i2c_common_8xx.h"


#define BUFFER_SIZE 35
#define WaitForUART0txRdy  while(((LPC_USART0->STAT) & (1<<2)) == 0)
#define Self_Slave_address 0x55
#define I2CBAUD 100000


void setup_debug_uart(void);


const unsigned char the_prompt[] = "Enter some characters to be transmitted from the I2C master to the slave\n\r";
const unsigned char the_massage[] = "Characters received by the I2C slave were \n\r";
unsigned char u0_rx_buffer[BUFFER_SIZE];
unsigned char slave_rx_data[BUFFER_SIZE];


static uint32_t rx_char_counter = 0;
static uint32_t slave_data_counter = 0;

/*******************************************************************/
typedef void (*loopHostIfFunc)(int pNum);

SL_HOSTIF_PACKET_T sendBuff, recvBuff;

IMG_HEADER_T *pImageHeader = (IMG_HEADER_T *) (SL_BOOTAPP_ADDR + SL_BOOTAPP_IMGHDR_OFS);

static SL_PINSETUP_T *pinCfgData = (SL_PINSETUP_T *) SL_ADDRESS_APPPINDATA;
static uint32_t *pushAppFlag = (uint32_t *) SL_ADDRESS_APPCALLEDFL;

/*****************************************************************************/
/*****************************************************************************
** Function:    UART0_IRQHandler
** Description: UART0 interrupt service routine.
**              This ISR reads one received char from the UART0 RXDAT register,
**              appends it to the u0_rx_buffer array, and echos it back via the
**              UART0 transmitter. If the char. is 0xD (carriage return),
**              a new line char (0xA) is appended to the array and echoed,
**              then a NUL char (0x0) is appended to the array to terminate the string
**              for future use.
** Parameters:  None
** Returns:     void
*****************************************************************************/



/*****************************************************************************
** Function: I2C0_IRQHandler
** Description: I2C0 interrupt service routine
** parameters: None
** Returns: void
*****************************************************************************/




/*****************************************************************************
*****************************************************************************/
int main(void) {
 

} // end of main

